!> @file
!! Contains all data related to builtin pseudopotentials
!! @author
!!    Copyright (C) 2012-2013 BigDFT group
!!    This file is distributed under the terms of the
!!    GNU General Public License, see ~/COPYING file
!!    or http://www.gnu.org/copyleft/gpl.txt .
!!    For the list of contributors, see ~/AUTHORS

!> Routine containing the data for the builtin pseudopotentials
!! The file pspconf.f90 is generated from the file pspconf.in.f90.
subroutine psp_from_data(symbol, nzatom, nelpsp, npspcode, ixc, psppar, exists)
  use module_base
  use module_xc
  implicit none
  
  character(len = *), intent(in) :: symbol
  integer, intent(inout) :: ixc
  integer, intent(out) :: nzatom, nelpsp, npspcode
  real(gp), intent(out) :: psppar(0:4,0:6)
  logical, intent(out) :: exists

  character(len=500) :: name_ixc, name_xcpsp(3)

  exists      = .false.
  nzatom      = 0
  nelpsp      = 0
  npspcode    = 1
  psppar(:,:) = 0._gp

  if (ixc < 0) then
     call xc_get_name(name_ixc, ixc, XC_MIXED)
  else
     call xc_get_name(name_ixc, ixc, XC_ABINIT)
  end if
  call xc_get_name(name_xcpsp(1),  1, XC_ABINIT)
  call xc_get_name(name_xcpsp(2), 11, XC_ABINIT)

  if (trim(symbol) == "X") then
     return
!!PSP_TABLE!!
  else if (trim(symbol) == "Ag" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 47
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.650000000000_gp, -2.376060960000_gp /)
     psppar(1,0:6) = (/ 1.012704560000_gp, 0.897931340000_gp, -0.748322970000_gp, 0.029787300000_gp, 0.289824240000_gp &
        & , 0.007267360000_gp, -0.018764240000_gp /)
     psppar(2,0:6) = (/ 1.235842020000_gp, 0.130080680000_gp, -0.277495480000_gp, 0.000000000000_gp, 0.117263240000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.016159130000_gp, -0.038842350000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ag_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 47
     nelpsp   = 11
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.570000000000_gp, 1.017053240000_gp /)
     psppar(1,0:6) = (/ 0.498900390000_gp, 2.990284010000_gp, 3.912395480000_gp, 2.205847230000_gp, -1.515264250000_gp &
        & , 0.538171620000_gp, -1.389553140000_gp /)
     psppar(2,0:6) = (/ 0.630008530000_gp, 1.813967860000_gp, 1.304449970000_gp, 0.000000000000_gp, -0.551230720000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.387659550000_gp, -3.420075730000_gp, -1.019948520000_gp, 0.000000000000_gp, 0.449755020000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Al" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 13
     nelpsp   = 3
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.450000000000_gp, -8.491351160000_gp /)
     psppar(1,0:6) = (/ 0.460104270000_gp, 5.088339530000_gp, 2.679699750000_gp, 0.000000000000_gp, -1.037843250000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.536744390000_gp, 2.193438270000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ar" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 18
     nelpsp   = 8
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.400000000000_gp, -7.100000000000_gp /)
     psppar(1,0:6) = (/ 0.317380810000_gp, 10.249486990000_gp, 5.602516270000_gp, 0.000000000000_gp, -2.169845220000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.351619210000_gp, 4.978801010000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "As" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 33
     nelpsp   = 5
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.520000000000_gp /)
     psppar(1,0:6) = (/ 0.456400250000_gp, 4.560761060000_gp, 1.692388760000_gp, -1.373804210000_gp, -0.655459350000_gp &
        & , -0.335173910000_gp, 0.865415310000_gp /)
     psppar(2,0:6) = (/ 0.550561680000_gp, 1.812246640000_gp, -0.646726580000_gp, 0.000000000000_gp, 0.273291860000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.685282720000_gp, 0.312372760000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "At" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 85
     nelpsp   = 7
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.580000000000_gp, 13.520411160000_gp /)
     psppar(1,0:6) = (/ 0.627826940000_gp, 0.945556520000_gp, -0.965902850000_gp, -0.190428560000_gp, 0.374092570000_gp &
        & , -0.046459810000_gp, 0.119958720000_gp /)
     psppar(2,0:6) = (/ 0.709823200000_gp, 0.527078050000_gp, -0.318820730000_gp, 0.000000000000_gp, 0.134726350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.838364990000_gp, 0.468947870000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Au" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 79
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.650000000000_gp, -1.963712230000_gp, -1.698122910000_gp /)
     psppar(1,0:6) = (/ 0.919307570000_gp, 1.539599150000_gp, -0.468778610000_gp, -0.792038900000_gp, 0.181557170000_gp &
        & , -0.193237710000_gp, 0.498937610000_gp /)
     psppar(2,0:6) = (/ 1.140350800000_gp, 0.471229430000_gp, -0.497538270000_gp, -0.209757800000_gp, 0.210248290000_gp &
        & , -0.062359780000_gp, 0.147570160000_gp /)
     exists = .true.
  else if (trim(symbol) == "Au_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 79
     nelpsp   = 11
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.590000000000_gp, 11.604427900000_gp /)
     psppar(1,0:6) = (/ 0.521179750000_gp, 2.538613590000_gp, 2.701113200000_gp, 0.000000000000_gp, -1.046136640000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.630613060000_gp, 0.394852700000_gp, 2.057830560000_gp, 0.000000000000_gp, -0.869592130000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.440706430000_gp, -4.719069660000_gp, -1.650429070000_gp, 0.000000000000_gp, 0.727770810000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "B" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 5
     nelpsp   = 3
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.433929560000_gp, -5.578641730000_gp, 0.804251450000_gp /)
     psppar(1,0:6) = (/ 0.373843260000_gp, 6.233928220000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.360393170000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ba" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 56
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 1.200000000000_gp /)
     psppar(1,0:6) = (/ 1.016186840000_gp, 0.922592590000_gp, 0.763494890000_gp, -0.333464930000_gp, -0.295700300000_gp &
        & , -0.081357110000_gp, 0.210063160000_gp /)
     psppar(2,0:6) = (/ 1.249879910000_gp, 0.447168200000_gp, 0.151080730000_gp, 0.000000000000_gp, -0.063843260000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.937158230000_gp, -0.718933820000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ba_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 56
     nelpsp   = 10
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.540000000000_gp, 24.478653250000_gp, -2.500849940000_gp /)
     psppar(1,0:6) = (/ 0.514776130000_gp, 1.046729030000_gp, -0.977217070000_gp, 0.000000000000_gp, 0.378474540000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.375190110000_gp, -0.202439120000_gp, 0.680330650000_gp, 0.000000000000_gp, -0.287492170000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.665403190000_gp, 0.378418500000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.304920430000_gp, -18.795207770000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Be" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 4
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.739008650000_gp, -2.592950780000_gp, 0.354838930000_gp /)
     psppar(1,0:6) = (/ 0.528796560000_gp, 3.061665910000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.658153480000_gp, 0.092461960000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Be_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 4
     nelpsp   = 4
     npspcode = 10
     ixc      = 1
     psppar(0,0:4) = (/ 0.325000000000_gp, -24.015040920000_gp, 17.204014440000_gp, -3.326390180000_gp, 0.165419430000_gp &
        &  /)
     exists = .true.
  else if (trim(symbol) == "Bi" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 83
     nelpsp   = 5
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.605000000000_gp, 6.679437140000_gp /)
     psppar(1,0:6) = (/ 0.678857950000_gp, 1.377633780000_gp, -0.513696910000_gp, -0.471028130000_gp, 0.198953960000_gp &
        & , -0.114919100000_gp, 0.296719830000_gp /)
     psppar(2,0:6) = (/ 0.798672670000_gp, 0.655578090000_gp, -0.402932190000_gp, 0.000000000000_gp, 0.170269930000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.934682550000_gp, 0.378475790000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Br" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 35
     nelpsp   = 7
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.500000000000_gp /)
     psppar(1,0:6) = (/ 0.428207340000_gp, 5.398837130000_gp, 1.820292050000_gp, -1.323973920000_gp, -0.704996080000_gp &
        & , -0.323016560000_gp, 0.834025170000_gp /)
     psppar(2,0:6) = (/ 0.455323080000_gp, 3.108822690000_gp, -0.632201880000_gp, 0.000000000000_gp, 0.267154050000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.557847270000_gp, 0.555902940000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "C" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 6
     nelpsp   = 4
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.348830450000_gp, -8.513771100000_gp, 1.228432030000_gp /)
     psppar(1,0:6) = (/ 0.304553210000_gp, 9.522841790000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.232677300000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ca" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 20
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.800000000000_gp /)
     psppar(1,0:6) = (/ 0.669737210000_gp, 1.645014420000_gp, 1.523490820000_gp, 0.295996340000_gp, -0.590045460000_gp &
        & , 0.072215710000_gp, -0.186460170000_gp /)
     psppar(2,0:6) = (/ 0.946474020000_gp, 0.585478930000_gp, 0.126328780000_gp, 0.000000000000_gp, -0.053383650000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.526549980000_gp, -3.032320950000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ca_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 20
     nelpsp   = 10
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.390000000000_gp, -4.928146020000_gp, -1.232854090000_gp /)
     psppar(1,0:6) = (/ 0.281909480000_gp, 12.352339560000_gp, 7.657455180000_gp, 0.000000000000_gp, -2.965719640000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.310345280000_gp, 5.722423480000_gp, 0.923591410000_gp, 0.000000000000_gp, -0.390288600000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.904330110000_gp, 0.016806330000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cd" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 48
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.625000000000_gp, -1.796837990000_gp /)
     psppar(1,0:6) = (/ 0.828464670000_gp, 1.485292410000_gp, -0.424752830000_gp, -0.407986270000_gp, 0.164506060000_gp &
        & , -0.099538460000_gp, 0.257007190000_gp /)
     psppar(2,0:6) = (/ 0.972872540000_gp, 0.469208430000_gp, -0.448111070000_gp, 0.000000000000_gp, 0.189361490000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.240949000000_gp, 0.065411640000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cd_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 48
     nelpsp   = 12
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.550000000000_gp, 2.382713060000_gp /)
     psppar(1,0:6) = (/ 0.491504790000_gp, 3.207932470000_gp, 4.140963410000_gp, 1.584234460000_gp, -1.603788230000_gp &
        & , 0.386513630000_gp, -0.997973900000_gp /)
     psppar(2,0:6) = (/ 0.598564810000_gp, 1.940149940000_gp, 1.515892420000_gp, 0.000000000000_gp, -0.640581460000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.377874360000_gp, -4.190071930000_gp, -0.770155580000_gp, 0.000000000000_gp, 0.339606690000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ce" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 58
     nelpsp   = 12
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.535000000000_gp, 18.847469840000_gp, -0.765636070000_gp /)
     psppar(1,0:6) = (/ 0.521790480000_gp, 1.321616430000_gp, -1.700443940000_gp, 0.000000000000_gp, 0.658579110000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.470324400000_gp, 0.972640770000_gp, -1.451336510000_gp, 0.000000000000_gp, 0.613301610000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.703592680000_gp, 0.074240790000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.306716680000_gp, -17.214789970000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cl" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 17
     nelpsp   = 7
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.410000000000_gp, -6.864754310000_gp /)
     psppar(1,0:6) = (/ 0.338208320000_gp, 9.062239680000_gp, 5.065682400000_gp, 0.000000000000_gp, -1.961930360000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.376137090000_gp, 4.465876400000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Co" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 27
     nelpsp   = 9
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.580000000000_gp /)
     psppar(1,0:6) = (/ 0.440457350000_gp, 3.334978250000_gp, 2.873150170000_gp, 3.091028050000_gp, -1.112766280000_gp &
        & , 0.754133620000_gp, -1.947164650000_gp /)
     psppar(2,0:6) = (/ 0.610048470000_gp, 1.634004810000_gp, 0.356083160000_gp, 0.000000000000_gp, -0.150472600000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.291660580000_gp, -10.358800170000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Co_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 27
     nelpsp   = 17
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.355000000000_gp, 3.418390940000_gp, 0.482078200000_gp /)
     psppar(1,0:6) = (/ 0.259140470000_gp, 11.195225890000_gp, -7.845824660000_gp, 0.000000000000_gp, 3.038674820000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.251424510000_gp, -0.551463750000_gp, -4.639237310000_gp, 0.000000000000_gp, 1.960435580000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.221664540000_gp, -12.075353660000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cr" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 24
     nelpsp   = 6
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.660000000000_gp /)
     psppar(1,0:6) = (/ 0.498577670000_gp, 2.400755560000_gp, 2.072336580000_gp, 2.952179340000_gp, -0.802612510000_gp &
        & , 0.720258010000_gp, -1.859698180000_gp /)
     psppar(2,0:6) = (/ 0.719768240000_gp, 1.145556580000_gp, 0.278236040000_gp, 0.000000000000_gp, -0.117576190000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.354340600000_gp, -6.615878320000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cr_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 24
     nelpsp   = 14
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.370000000000_gp, 5.113361660000_gp, -0.646819320000_gp /)
     psppar(1,0:6) = (/ 0.306011400000_gp, 8.617835150000_gp, -4.137694750000_gp, 0.000000000000_gp, 1.602522290000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.241089640000_gp, 3.161587580000_gp, -5.032906190000_gp, 0.000000000000_gp, 2.126791040000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.219577020000_gp, -11.157868280000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cs" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 55
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 1.200000000000_gp /)
     psppar(1,0:6) = (/ 1.224737270000_gp, 0.611526570000_gp, 0.239830050000_gp, -0.294024180000_gp, -0.092885780000_gp &
        & , -0.071734550000_gp, 0.185217820000_gp /)
     psppar(2,0:6) = (/ 1.280477590000_gp, 0.244892770000_gp, 0.227278630000_gp, 0.000000000000_gp, -0.096042750000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.107522120000_gp, -0.542162600000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cs_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 55
     nelpsp   = 9
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.540000000000_gp, 35.234438100000_gp, -3.318070090000_gp /)
     psppar(1,0:6) = (/ 0.456821030000_gp, -0.282378490000_gp, -2.780955650000_gp, 0.000000000000_gp, 1.077059490000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.362467000000_gp, -2.696733210000_gp, -2.290939960000_gp, 0.000000000000_gp, 0.968098830000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.761462050000_gp, 0.183754400000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.333507030000_gp, -17.948259440000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cu" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 29
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.580000000000_gp /)
     psppar(1,0:6) = (/ 0.843282880000_gp, 0.975786620000_gp, -0.822069620000_gp, -0.133237070000_gp, 0.318386190000_gp &
        & , -0.032506520000_gp, 0.083931470000_gp /)
     psppar(2,0:6) = (/ 1.089542660000_gp, 0.024579860000_gp, -0.249000930000_gp, 0.000000000000_gp, 0.105222100000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.291602250000_gp, -0.065292090000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cu_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 29
     nelpsp   = 11
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.530000000000_gp /)
     psppar(1,0:6) = (/ 0.423734310000_gp, 3.888050010000_gp, 3.276583910000_gp, 2.290091390000_gp, -1.269015490000_gp &
        & , 0.558725090000_gp, -1.442621980000_gp /)
     psppar(2,0:6) = (/ 0.572176970000_gp, 1.751272420000_gp, 0.374942690000_gp, 0.000000000000_gp, -0.158442200000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.266142750000_gp, -12.676957490000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Dy" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 66
     nelpsp   = 20
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.511666660000_gp, 16.994331380000_gp, -0.955297920000_gp /)
     psppar(1,0:6) = (/ 0.440590450000_gp, 1.940319500000_gp, -3.559797770000_gp, 0.000000000000_gp, 1.378703750000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.434642060000_gp, 0.014315360000_gp, -2.046237930000_gp, 0.000000000000_gp, 0.864693350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.467228800000_gp, -0.668924170000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.261670450000_gp, -23.922358170000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Er" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 68
     nelpsp   = 22
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.505833330000_gp, 17.105292810000_gp, -1.430953180000_gp /)
     psppar(1,0:6) = (/ 0.419948010000_gp, 2.144502570000_gp, -3.984203230000_gp, 0.000000000000_gp, 1.543075280000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.414455300000_gp, 0.054087360000_gp, -2.294476800000_gp, 0.000000000000_gp, 0.969593420000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.418384970000_gp, -0.999006320000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.249125910000_gp, -26.696809360000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Eu" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 63
     nelpsp   = 17
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.520416680000_gp, 17.373516250000_gp, -0.648467780000_gp /)
     psppar(1,0:6) = (/ 0.469042610000_gp, 1.763637900000_gp, -2.916931720000_gp, 0.000000000000_gp, 1.129722800000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.445907220000_gp, 0.518045940000_gp, -2.135185540000_gp, 0.000000000000_gp, 0.902280570000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.490038400000_gp, -0.426119960000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.278401290000_gp, -20.946527630000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "F" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 9
     nelpsp   = 7
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.218524650000_gp, -21.307361120000_gp, 3.072869420000_gp /)
     psppar(1,0:6) = (/ 0.195567210000_gp, 23.584942110000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.174268320000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Fe" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 26
     nelpsp   = 8
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.610000000000_gp /)
     psppar(1,0:6) = (/ 0.454482000000_gp, 3.016640460000_gp, 2.583038360000_gp, 3.257635340000_gp, -1.000406460000_gp &
        & , 0.794781640000_gp, -2.052117370000_gp /)
     psppar(2,0:6) = (/ 0.638902820000_gp, 1.499641990000_gp, 0.326873690000_gp, 0.000000000000_gp, -0.138129350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.308731770000_gp, -9.145353710000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Fe_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 26
     nelpsp   = 16
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.360000000000_gp, 5.392506670000_gp, -0.030066380000_gp /)
     psppar(1,0:6) = (/ 0.269268100000_gp, 10.193722760000_gp, -6.834982060000_gp, 0.000000000000_gp, 2.647177170000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.247685630000_gp, 0.145612610000_gp, -5.234954290000_gp, 0.000000000000_gp, 2.212171950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.223021050000_gp, -12.026941000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ga" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 31
     nelpsp   = 3
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.560000000000_gp /)
     psppar(1,0:6) = (/ 0.610790740000_gp, 2.369325160000_gp, -0.249015120000_gp, -0.551796240000_gp, 0.096443140000_gp &
        & , -0.134624500000_gp, 0.347598960000_gp /)
     psppar(2,0:6) = (/ 0.704595830000_gp, 0.746305290000_gp, -0.513132340000_gp, 0.000000000000_gp, 0.216837990000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.982579670000_gp, 0.075436560000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ga_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 31
     nelpsp   = 13
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.490000000000_gp /)
     psppar(1,0:6) = (/ 0.395301560000_gp, 12.457036510000_gp, 12.151586540000_gp, 3.785484660000_gp, -7.085416710000_gp &
        & , 1.847127380000_gp, -4.769262380000_gp /)
     psppar(2,0:6) = (/ 0.580854410000_gp, 1.578986060000_gp, -0.388914440000_gp, 0.000000000000_gp, 0.328692700000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.239081000000_gp, -16.135751030000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Gd" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 64
     nelpsp   = 18
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.517500040000_gp, 17.512556400000_gp, -0.719534200000_gp /)
     psppar(1,0:6) = (/ 0.462013720000_gp, 1.551855910000_gp, -3.068702560000_gp, 0.000000000000_gp, 1.188503390000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.456953270000_gp, -0.058347130000_gp, -1.697710950000_gp, 0.000000000000_gp, 0.717413820000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.482368130000_gp, -0.562600770000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.273389800000_gp, -21.923490110000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ge" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 32
     nelpsp   = 4
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.540000000000_gp /)
     psppar(1,0:6) = (/ 0.493742540000_gp, 3.826890990000_gp, 1.100231290000_gp, -1.344217650000_gp, -0.426117750000_gp &
        & , -0.327955530000_gp, 0.846777530000_gp /)
     psppar(2,0:6) = (/ 0.601064380000_gp, 1.362517810000_gp, -0.627369870000_gp, 0.000000000000_gp, 0.265112160000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.788368510000_gp, 0.191204850000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "H" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 1
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.200000000000_gp, -4.180236800000_gp, 0.725074820000_gp /)
     exists = .true.
  else if (trim(symbol) == "He" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 2
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.200000000000_gp, -9.112023400000_gp, 1.698367970000_gp /)
     exists = .true.
  else if (trim(symbol) == "Hf" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 72
     nelpsp   = 12
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.560000000000_gp, 5.134800560000_gp, 0.529190620000_gp /)
     psppar(1,0:6) = (/ 0.422810350000_gp, 2.564442090000_gp, -6.013732340000_gp, 1.109759640000_gp, 2.329108520000_gp &
        & , 0.270753630000_gp, -0.699082860000_gp /)
     psppar(2,0:6) = (/ 0.472681300000_gp, -1.025274900000_gp, -1.872548390000_gp, 0.000000000000_gp, 0.791296120000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.426387520000_gp, 1.459363260000_gp, -5.282764480000_gp, 0.000000000000_gp, 2.329480180000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Hg" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 80
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.640000000000_gp, -3.296328800000_gp /)
     psppar(1,0:6) = (/ 0.812107800000_gp, 1.765041430000_gp, -0.466127370000_gp, -0.799940850000_gp, 0.180530350000_gp &
        & , -0.195165580000_gp, 0.503915370000_gp /)
     psppar(2,0:6) = (/ 1.053713780000_gp, 0.474055880000_gp, -0.531815820000_gp, 0.000000000000_gp, 0.224733200000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.100000000000_gp, 0.120638310000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Hg_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 80
     nelpsp   = 12
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.570000000000_gp, 2.134571830000_gp /)
     psppar(1,0:6) = (/ 0.521801880000_gp, 3.293920210000_gp, 4.661000690000_gp, 0.000000000000_gp, -1.805197800000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.621647900000_gp, 2.100960400000_gp, 1.689988460000_gp, 0.000000000000_gp, -0.714150470000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.401894010000_gp, -1.669885780000_gp, -2.473265030000_gp, 0.000000000000_gp, 1.090607370000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ho" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 67
     nelpsp   = 21
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.508750020000_gp, 16.781570030000_gp, -1.173514480000_gp /)
     psppar(1,0:6) = (/ 0.432211760000_gp, 2.052796890000_gp, -3.674534290000_gp, 0.000000000000_gp, 1.423141010000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.420137920000_gp, 0.253294640000_gp, -2.355288780000_gp, 0.000000000000_gp, 0.995291170000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.447130570000_gp, -0.742862670000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.254992260000_gp, -25.197210810000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "I" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 53
     nelpsp   = 7
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.560000000000_gp, 14.661825210000_gp /)
     psppar(1,0:6) = (/ 0.552830080000_gp, 1.338053740000_gp, -0.834851080000_gp, -0.467437680000_gp, 0.323336430000_gp &
        & , -0.114043120000_gp, 0.294458060000_gp /)
     psppar(2,0:6) = (/ 0.562251470000_gp, 0.674496170000_gp, -0.577786760000_gp, 0.000000000000_gp, 0.244159470000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.794324950000_gp, 0.224345430000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "In" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 49
     nelpsp   = 3
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.610000000000_gp, 2.865776760000_gp /)
     psppar(1,0:6) = (/ 0.770601970000_gp, 1.256193600000_gp, -0.397254990000_gp, -0.278329060000_gp, 0.153856200000_gp &
        & , -0.067905340000_gp, 0.175330830000_gp /)
     psppar(2,0:6) = (/ 0.858131600000_gp, 0.494458640000_gp, -0.380788780000_gp, 0.000000000000_gp, 0.160912630000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.088690900000_gp, 0.129207780000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "In_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 49
     nelpsp   = 13
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.530000000000_gp, 2.395403850000_gp /)
     psppar(1,0:6) = (/ 0.474080540000_gp, 3.554410640000_gp, 4.754135350000_gp, 1.565040080000_gp, -1.841268700000_gp &
        & , 0.381830680000_gp, -0.985882580000_gp /)
     psppar(2,0:6) = (/ 0.559819450000_gp, 2.223664250000_gp, 2.035277620000_gp, 0.000000000000_gp, -0.860061770000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.360487510000_gp, -4.566413720000_gp, -0.773785150000_gp, 0.000000000000_gp, 0.341207180000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ir" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 77
     nelpsp   = 9
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.641000000000_gp, 10.720015910000_gp /)
     psppar(1,0:6) = (/ 0.509960440000_gp, 2.445998870000_gp, 2.811037360000_gp, 0.000000000000_gp, -1.088710090000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.684970520000_gp, 0.461791820000_gp, 1.304725630000_gp, 0.000000000000_gp, -0.551347210000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.471745280000_gp, -4.545484110000_gp, -1.635428470000_gp, 0.000000000000_gp, 0.721156170000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ir_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 77
     nelpsp   = 17
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.510000000000_gp, 4.904509460000_gp, 1.313786450000_gp /)
     psppar(1,0:6) = (/ 0.404468870000_gp, 3.243278350000_gp, -7.315509270000_gp, 2.956978240000_gp, 2.833284560000_gp &
        & , 0.721428820000_gp, -1.862721200000_gp /)
     psppar(2,0:6) = (/ 0.411425710000_gp, -0.380574450000_gp, -3.504402730000_gp, 0.000000000000_gp, 1.480880440000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.376428130000_gp, 0.754315470000_gp, -5.875580420000_gp, 0.000000000000_gp, 2.590887430000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "K" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 19
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.950000000000_gp /)
     psppar(1,0:6) = (/ 0.955363950000_gp, 0.914612000000_gp, 0.287550940000_gp, -0.300223860000_gp, -0.111368000000_gp &
        & , -0.073247120000_gp, 0.189123260000_gp /)
     psppar(2,0:6) = (/ 1.086410630000_gp, 0.315461770000_gp, 0.068194100000_gp, 0.000000000000_gp, -0.028817260000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.720606080000_gp, -1.529513610000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "K_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 19
     nelpsp   = 9
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.400000000000_gp, -4.989347510000_gp, -0.756048210000_gp /)
     psppar(1,0:6) = (/ 0.294825500000_gp, 11.238704660000_gp, 7.067778710000_gp, 0.000000000000_gp, -2.737338930000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.322358650000_gp, 5.256702390000_gp, 0.938946900000_gp, 0.000000000000_gp, -0.396777480000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Kr" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 36
     nelpsp   = 8
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.500000000000_gp /)
     psppar(1,0:6) = (/ 0.410758930000_gp, 5.911194290000_gp, 1.967372360000_gp, -1.458068690000_gp, -0.761960040000_gp &
        & , -0.355732340000_gp, 0.918496940000_gp /)
     psppar(2,0:6) = (/ 0.430256410000_gp, 3.524356920000_gp, -0.691197630000_gp, 0.000000000000_gp, 0.292084310000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.517120050000_gp, 0.629228500000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "La" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 57
     nelpsp   = 11
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.535000000000_gp, 19.909308230000_gp, -1.474830230000_gp /)
     psppar(1,0:6) = (/ 0.551775420000_gp, 1.293271920000_gp, -1.121819370000_gp, 0.000000000000_gp, 0.434478770000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.476308060000_gp, 1.172526820000_gp, -0.828809860000_gp, 0.029857280000_gp, 0.350236090000_gp &
        & , 0.008876400000_gp, -0.021005390000_gp /)
     psppar(3,0:6) = (/ 0.626672200000_gp, 0.328377040000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.299310170000_gp, -18.269438960000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Li" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 3
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.787553050000_gp, -1.892612470000_gp, 0.286059680000_gp /)
     psppar(1,0:6) = (/ 0.666375180000_gp, 1.858811110000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 1.079305610000_gp, -0.005895040000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Li_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 3
     nelpsp   = 3
     npspcode = 10
     ixc      = 1
     psppar(0,0:4) = (/ 0.400000000000_gp, -14.034868490000_gp, 9.553476270000_gp, -1.766488170000_gp, 0.084369980000_gp &
        &  /)
     exists = .true.
  else if (trim(symbol) == "Lu" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 71
     nelpsp   = 25
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.497000000000_gp, 17.037052920000_gp, -1.661610230000_gp /)
     psppar(1,0:6) = (/ 0.391206150000_gp, 2.184677790000_gp, -5.432346100000_gp, 0.000000000000_gp, 2.103938600000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.393895670000_gp, -0.719818780000_gp, -2.723798900000_gp, 0.000000000000_gp, 1.151015120000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.436518270000_gp, -1.173245130000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.232629260000_gp, -31.852261770000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mg" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 12
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.651811690000_gp, -2.864297460000_gp /)
     psppar(1,0:6) = (/ 0.556478140000_gp, 2.970957120000_gp, 1.329940910000_gp, 0.000000000000_gp, -0.515083900000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.677568810000_gp, 1.049881010000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mg_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 12
     nelpsp   = 10
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.210949540000_gp, -19.419007510000_gp, 2.871330990000_gp /)
     psppar(1,0:6) = (/ 0.141546960000_gp, 40.316626290000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.105469020000_gp, -10.891113290000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mn" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 25
     nelpsp   = 7
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.640000000000_gp /)
     psppar(1,0:6) = (/ 0.481246080000_gp, 2.799030570000_gp, 2.486101070000_gp, 2.565629820000_gp, -0.962862810000_gp &
        & , 0.625949580000_gp, -1.616194870000_gp /)
     psppar(2,0:6) = (/ 0.669304320000_gp, 1.368775640000_gp, 0.316763370000_gp, 0.000000000000_gp, -0.133856950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.327763140000_gp, -7.995417840000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mn_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 25
     nelpsp   = 15
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.365000000000_gp, 6.748683320000_gp, -0.576569000000_gp /)
     psppar(1,0:6) = (/ 0.280752660000_gp, 9.379531500000_gp, -5.575280020000_gp, 0.000000000000_gp, 2.159296670000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.254535670000_gp, 0.371175680000_gp, -4.229056900000_gp, 0.000000000000_gp, 1.787102710000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.221422100000_gp, -12.115384530000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mo" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 42
     nelpsp   = 6
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.699000000000_gp, 7.995868210000_gp /)
     psppar(1,0:6) = (/ 0.678125950000_gp, 1.289607280000_gp, 0.998113010000_gp, 0.000000000000_gp, -0.386567510000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.800771400000_gp, 0.301412260000_gp, 0.741614510000_gp, 0.000000000000_gp, -0.313389330000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.453383930000_gp, -2.809707710000_gp, -6.820946350000_gp, 0.000000000000_gp, 3.007754630000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mo_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 42
     nelpsp   = 14
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.430000000000_gp, 16.237452280000_gp, 1.496536130000_gp /)
     psppar(1,0:6) = (/ 0.376255270000_gp, 3.362425510000_gp, -5.289276350000_gp, 0.000000000000_gp, 2.048527920000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.361734350000_gp, -0.379570750000_gp, -4.067713500000_gp, 0.000000000000_gp, 1.718922680000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.525828120000_gp, -1.543211300000_gp, 1.074387690000_gp, 0.000000000000_gp, -0.473760440000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "N" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 7
     nelpsp   = 5
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.289179230000_gp, -12.234819880000_gp, 1.766407280000_gp /)
     psppar(1,0:6) = (/ 0.256604870000_gp, 13.552242720000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.270133690000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Na" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 11
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.885509380000_gp, -1.238867130000_gp /)
     psppar(1,0:6) = (/ 0.661103900000_gp, 1.847271350000_gp, 0.582003620000_gp, 0.000000000000_gp, -0.225409030000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.857119280000_gp, 0.471132580000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Na_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 11
     nelpsp   = 9
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.246317800000_gp, -7.545592530000_gp, 1.125996710000_gp /)
     psppar(1,0:6) = (/ 0.141251250000_gp, 36.556986530000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.139668400000_gp, -10.392083320000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Nb" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 41
     nelpsp   = 5
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.724000000000_gp, 4.021057540000_gp /)
     psppar(1,0:6) = (/ 0.699708280000_gp, 1.532651350000_gp, 1.428263990000_gp, 0.000000000000_gp, -0.553164270000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.846671640000_gp, 0.609675180000_gp, 0.596787590000_gp, 0.000000000000_gp, -0.252188780000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.516072260000_gp, -2.696829930000_gp, -1.694966570000_gp, 0.000000000000_gp, 0.747410000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Nb_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 41
     nelpsp   = 13
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.460000000000_gp, 13.505393600000_gp, 0.752433720000_gp /)
     psppar(1,0:6) = (/ 0.393708020000_gp, 3.222024570000_gp, -4.599341710000_gp, 0.000000000000_gp, 1.781317380000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.403625570000_gp, -0.822036770000_gp, -2.247365750000_gp, 0.000000000000_gp, 0.949685360000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.513644050000_gp, -1.489847710000_gp, 0.823817330000_gp, 0.000000000000_gp, -0.363269300000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Nd" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 60
     nelpsp   = 14
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.529166700000_gp, 17.815030430000_gp, -0.594797670000_gp /)
     psppar(1,0:6) = (/ 0.502999860000_gp, 1.529109880000_gp, -2.153731940000_gp, 0.000000000000_gp, 0.834136800000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.467012900000_gp, 0.721553460000_gp, -1.647499200000_gp, 0.000000000000_gp, 0.696195480000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.325289580000_gp, -0.543240170000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.294742810000_gp, -18.520227600000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ne" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 10
     nelpsp   = 8
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.190000000000_gp, -27.692851820000_gp, 4.005905850000_gp /)
     psppar(1,0:6) = (/ 0.179488040000_gp, 28.506098280000_gp, -1.076245280000_gp, 0.000000000000_gp, 0.416828000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.214912710000_gp, -0.000089910000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ni" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 28
     nelpsp   = 10
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.560000000000_gp /)
     psppar(1,0:6) = (/ 0.425398700000_gp, 3.619650710000_gp, 3.088964960000_gp, 3.058598310000_gp, -1.196350990000_gp &
        & , 0.746221580000_gp, -1.926735830000_gp /)
     psppar(2,0:6) = (/ 0.584080760000_gp, 1.742220070000_gp, 0.386340670000_gp, 0.000000000000_gp, -0.163258730000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.278113480000_gp, -11.608428230000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ni_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 28
     nelpsp   = 18
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.350000000000_gp, 3.610310720000_gp, 0.449638320000_gp /)
     psppar(1,0:6) = (/ 0.245104890000_gp, 12.161130710000_gp, -9.078929310000_gp, 0.000000000000_gp, 3.516254200000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.234741360000_gp, -0.820623570000_gp, -6.029070690000_gp, 0.000000000000_gp, 2.547747370000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.214949500000_gp, -13.395062120000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "O" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 8
     nelpsp   = 6
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.247620860000_gp, -16.580317970000_gp, 2.395700920000_gp /)
     psppar(1,0:6) = (/ 0.221786140000_gp, 18.266917180000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.256828900000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Os" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 76
     nelpsp   = 8
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.667000000000_gp, 9.440459360000_gp /)
     psppar(1,0:6) = (/ 0.510307080000_gp, 2.402366880000_gp, 3.046705770000_gp, 0.000000000000_gp, -1.179984070000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.717553290000_gp, 0.499523210000_gp, 1.053284270000_gp, 0.000000000000_gp, -0.445093840000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.487586050000_gp, -4.142034710000_gp, -1.666100130000_gp, 0.000000000000_gp, 0.734681100000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Os_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 76
     nelpsp   = 16
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.520000000000_gp, 5.613072990000_gp, 0.921954760000_gp /)
     psppar(1,0:6) = (/ 0.410578300000_gp, 2.785758260000_gp, -6.692129830000_gp, 2.247034370000_gp, 2.591850740000_gp &
        & , 0.548220250000_gp, -1.415498600000_gp /)
     psppar(2,0:6) = (/ 0.422395460000_gp, -0.590005500000_gp, -3.018323470000_gp, 0.000000000000_gp, 1.275474460000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.380252000000_gp, 0.880132820000_gp, -5.732891680000_gp, 0.000000000000_gp, 2.527967610000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "P" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 15
     nelpsp   = 5
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.430000000000_gp, -6.654219810000_gp /)
     psppar(1,0:6) = (/ 0.389802840000_gp, 6.842135560000_gp, 3.856693320000_gp, 0.000000000000_gp, -1.493690900000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.440795850000_gp, 3.282605920000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pb" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 82
     nelpsp   = 4
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.617500000000_gp, 0.753142570000_gp /)
     psppar(1,0:6) = (/ 0.705258600000_gp, 1.979927410000_gp, -0.164959960000_gp, -0.806060400000_gp, 0.063888720000_gp &
        & , -0.196658600000_gp, 0.507770330000_gp /)
     psppar(2,0:6) = (/ 0.846641060000_gp, 0.864420300000_gp, -0.540968850000_gp, 0.000000000000_gp, 0.228601060000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.971938570000_gp, 0.374967080000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pd" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 46
     nelpsp   = 10
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.596000000000_gp, 5.209664760000_gp /)
     psppar(1,0:6) = (/ 0.582204220000_gp, 2.411076080000_gp, 2.318920240000_gp, 0.000000000000_gp, -0.898113950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.688787130000_gp, 1.227253300000_gp, 0.758020530000_gp, 0.000000000000_gp, -0.320322140000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.442835230000_gp, -4.377131240000_gp, 0.413271050000_gp, 0.000000000000_gp, -0.182235400000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pd_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 46
     nelpsp   = 18
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.410000000000_gp, 15.720259220000_gp, 0.140765080000_gp /)
     psppar(1,0:6) = (/ 0.342150630000_gp, 5.177686060000_gp, -5.852819060000_gp, 0.000000000000_gp, 2.266787070000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.343110640000_gp, -0.372560760000_gp, -3.258728090000_gp, 0.000000000000_gp, 1.377063950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.494916240000_gp, -1.608272980000_gp, 1.446609220000_gp, 0.000000000000_gp, -0.637894700000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pm" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 61
     nelpsp   = 15
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.526250000000_gp, 18.251722920000_gp, -0.492107440000_gp /)
     psppar(1,0:6) = (/ 0.489878560000_gp, 1.308977570000_gp, -2.507750880000_gp, 0.000000000000_gp, 0.971247740000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.472260160000_gp, 0.160512380000_gp, -1.565305270000_gp, 0.000000000000_gp, 0.661462210000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.473709140000_gp, -0.429952410000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.291526530000_gp, -19.305056680000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Po" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 84
     nelpsp   = 6
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.592500000000_gp, 10.411730700000_gp /)
     psppar(1,0:6) = (/ 0.647949610000_gp, 1.144202960000_gp, -0.735851490000_gp, -0.339386160000_gp, 0.284994060000_gp &
        & , -0.082801740000_gp, 0.213793180000_gp /)
     psppar(2,0:6) = (/ 0.748947080000_gp, 0.594561840000_gp, -0.353594820000_gp, 0.000000000000_gp, 0.149421080000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.880468400000_gp, 0.433232280000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pr" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 59
     nelpsp   = 13
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.532083330000_gp, 18.424739090000_gp, -0.657668930000_gp /)
     psppar(1,0:6) = (/ 0.526849960000_gp, 1.012621060000_gp, -1.717981650000_gp, 0.000000000000_gp, 0.665371430000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.458897360000_gp, 1.117060040000_gp, -1.852108720000_gp, 0.000000000000_gp, 0.782658780000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.747609890000_gp, 0.017571090000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.300772960000_gp, -17.897118910000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pt" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 78
     nelpsp   = 10
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.616000000000_gp, 11.027417070000_gp /)
     psppar(1,0:6) = (/ 0.520132110000_gp, 2.447430060000_gp, 2.640359780000_gp, 0.000000000000_gp, -1.022606950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.658975660000_gp, 0.408452970000_gp, 1.647716040000_gp, 0.000000000000_gp, -0.696287110000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.451243180000_gp, -4.552294540000_gp, -2.102395680000_gp, 0.000000000000_gp, 0.927069360000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pt_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 78
     nelpsp   = 18
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.500000000000_gp, 5.445831590000_gp, 1.156382040000_gp /)
     psppar(1,0:6) = (/ 0.409941500000_gp, 2.994365650000_gp, -7.448772020000_gp, 4.243095290000_gp, 2.884897000000_gp &
        & , 1.035209250000_gp, -2.672898790000_gp /)
     psppar(2,0:6) = (/ 0.398651990000_gp, -0.225181400000_gp, -3.776974260000_gp, 0.000000000000_gp, 1.596062930000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.367963970000_gp, 0.632066550000_gp, -5.755431340000_gp, 0.000000000000_gp, 2.537906670000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rb" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 37
     nelpsp   = 1
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 1.096206850000_gp, 0.847332740000_gp, -0.748120320000_gp /)
     psppar(1,0:6) = (/ 0.955699090000_gp, 0.887460220000_gp, 0.903088150000_gp, -0.006750030000_gp, -0.349764540000_gp &
        & , -0.001646840000_gp, 0.004252120000_gp /)
     psppar(2,0:6) = (/ 1.156680580000_gp, 0.461734480000_gp, 0.336112730000_gp, 0.000000000000_gp, -0.142033550000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.664322560000_gp, -1.362938290000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rb_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 37
     nelpsp   = 9
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.490000000000_gp, 4.504151060000_gp, -0.741018100000_gp /)
     psppar(1,0:6) = (/ 0.282300770000_gp, 9.536329200000_gp, 9.486633730000_gp, 0.000000000000_gp, -3.674157440000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.301886140000_gp, 2.209592430000_gp, 5.475249280000_gp, 0.000000000000_gp, -2.313715110000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.514895280000_gp, 0.449375740000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Re" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 75
     nelpsp   = 7
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.693000000000_gp, 8.180816180000_gp /)
     psppar(1,0:6) = (/ 0.509816210000_gp, 2.269379360000_gp, 3.528529340000_gp, 0.000000000000_gp, -1.366593540000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.745839060000_gp, 0.496693290000_gp, 0.925829110000_gp, 0.000000000000_gp, -0.391234210000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.500954200000_gp, -3.689629670000_gp, -1.894600990000_gp, 0.000000000000_gp, 0.835440510000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Re_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 75
     nelpsp   = 15
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.530000000000_gp, 5.592660280000_gp, 0.943956800000_gp /)
     psppar(1,0:6) = (/ 0.403251990000_gp, 2.760720430000_gp, -6.396414760000_gp, 0.868731580000_gp, 2.477320790000_gp &
        & , 0.211948800000_gp, -0.547249460000_gp /)
     psppar(2,0:6) = (/ 0.440950690000_gp, -0.900546310000_gp, -2.511211370000_gp, 0.000000000000_gp, 1.061180490000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.390395440000_gp, 0.875251420000_gp, -5.672542850000_gp, 0.000000000000_gp, 2.501356280000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rh" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 45
     nelpsp   = 9
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.621428570000_gp, 5.397962330000_gp /)
     psppar(1,0:6) = (/ 0.598078810000_gp, 2.242111310000_gp, 2.151596690000_gp, 0.000000000000_gp, -0.833309810000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.709585670000_gp, 1.155278300000_gp, 0.704846350000_gp, 0.000000000000_gp, -0.297851950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.369206870000_gp, -1.053058190000_gp, -10.923959690000_gp, 0.000000000000_gp, 4.817013440000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rh_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 45
     nelpsp   = 17
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.420000000000_gp, 15.225012310000_gp, 0.415911450000_gp /)
     psppar(1,0:6) = (/ 0.350051850000_gp, 4.715292440000_gp, -5.805524640000_gp, 0.000000000000_gp, 2.248470030000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.350253390000_gp, -0.504693860000_gp, -3.373039560000_gp, 0.000000000000_gp, 1.425369370000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.496949800000_gp, -1.685594310000_gp, 1.387707010000_gp, 0.000000000000_gp, -0.611921270000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rn" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 86
     nelpsp   = 8
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.570000000000_gp, 14.629184610000_gp /)
     psppar(1,0:6) = (/ 0.615181950000_gp, 0.981832240000_gp, -1.038962740000_gp, -0.120455840000_gp, 0.402388540000_gp &
        & , -0.029388210000_gp, 0.075880040000_gp /)
     psppar(2,0:6) = (/ 0.676697210000_gp, 0.612278590000_gp, -0.344122310000_gp, 0.000000000000_gp, 0.145418220000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.788337150000_gp, 0.557745960000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ru" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 44
     nelpsp   = 8
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.647214290000_gp, 8.687723330000_gp /)
     psppar(1,0:6) = (/ 0.625656120000_gp, 1.637866020000_gp, 1.329334770000_gp, 0.000000000000_gp, -0.514849140000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.746424870000_gp, 0.639011570000_gp, 0.650376120000_gp, 0.000000000000_gp, -0.274834070000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.440358020000_gp, -4.883364950000_gp, -3.063746290000_gp, 0.000000000000_gp, 1.350985130000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ru_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 44
     nelpsp   = 16
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.430000000000_gp, 13.582571300000_gp, 0.596226750000_gp /)
     psppar(1,0:6) = (/ 0.364083740000_gp, 4.480632200000_gp, -5.268678980000_gp, 0.000000000000_gp, 2.040550590000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.364053170000_gp, -0.320372140000_gp, -3.059713530000_gp, 0.000000000000_gp, 1.292964950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.495850360000_gp, -1.597870170000_gp, 1.165495050000_gp, 0.000000000000_gp, -0.513935010000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "S" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 16
     nelpsp   = 6
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.420000000000_gp, -6.554491840000_gp /)
     psppar(1,0:6) = (/ 0.361756650000_gp, 7.905302500000_gp, 4.471698300000_gp, 0.000000000000_gp, -1.731881300000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.405285020000_gp, 3.866579000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sb" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 51
     nelpsp   = 5
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.590000000000_gp, 6.680227830000_gp /)
     psppar(1,0:6) = (/ 0.597683560000_gp, 1.951476720000_gp, 0.037537270000_gp, -0.786630580000_gp, -0.014538120000_gp &
        & , -0.191918210000_gp, 0.495530690000_gp /)
     psppar(2,0:6) = (/ 0.672122050000_gp, 0.970312850000_gp, -0.466731320000_gp, 0.000000000000_gp, 0.197229980000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.856557290000_gp, 0.300102620000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 21
     nelpsp   = 3
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.750000000000_gp /)
     psppar(1,0:6) = (/ 0.597079410000_gp, 1.835768330000_gp, 1.734309390000_gp, 1.418483300000_gp, -0.671695140000_gp &
        & , 0.346074490000_gp, -0.893560490000_gp /)
     psppar(2,0:6) = (/ 0.847994380000_gp, 0.784126690000_gp, 0.246732970000_gp, 0.000000000000_gp, -0.104263710000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.454653180000_gp, -3.859240780000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sc_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 21
     nelpsp   = 11
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.385000000000_gp, 7.425036380000_gp, -0.489851550000_gp /)
     psppar(1,0:6) = (/ 0.359706530000_gp, 6.119584550000_gp, -2.563452930000_gp, 0.000000000000_gp, 0.992821050000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.243234160000_gp, 6.376618380000_gp, -6.016414690000_gp, 0.000000000000_gp, 2.542399240000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.252944630000_gp, -8.020891770000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Se" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 34
     nelpsp   = 6
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.510000000000_gp /)
     psppar(1,0:6) = (/ 0.432531080000_gp, 5.145130840000_gp, 2.052009000000_gp, -1.369203170000_gp, -0.794739670000_gp &
        & , -0.334051370000_gp, 0.862516930000_gp /)
     psppar(2,0:6) = (/ 0.472472520000_gp, 2.858806070000_gp, -0.590670500000_gp, 0.000000000000_gp, 0.249603840000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.613420130000_gp, 0.434828880000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Si" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 14
     nelpsp   = 4
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.440000000000_gp, -7.336102970000_gp /)
     psppar(1,0:6) = (/ 0.422738130000_gp, 5.906928310000_gp, 3.258196220000_gp, 0.000000000000_gp, -1.261893970000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.484278420000_gp, 2.727013460000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sm" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 62
     nelpsp   = 16
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.523333370000_gp, 17.206791720000_gp, -0.532802920000_gp /)
     psppar(1,0:6) = (/ 0.479676760000_gp, 1.723635190000_gp, -2.659367310000_gp, 0.000000000000_gp, 1.029968530000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.490597750000_gp, -0.082403110000_gp, -1.111008580000_gp, 0.000000000000_gp, 0.469486810000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.470840260000_gp, -0.410630340000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.284040490000_gp, -19.984292010000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sn" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 50
     nelpsp   = 4
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.605000000000_gp, 4.610912340000_gp /)
     psppar(1,0:6) = (/ 0.663543690000_gp, 1.648791460000_gp, -0.141973840000_gp, -0.576545630000_gp, 0.054986230000_gp &
        & , -0.140662730000_gp, 0.363189610000_gp /)
     psppar(2,0:6) = (/ 0.745864920000_gp, 0.769355440000_gp, -0.445070280000_gp, 0.000000000000_gp, 0.188076520000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.944458970000_gp, 0.225115080000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sr" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 38
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 1.010000000000_gp, 0.684748880000_gp, -0.062124650000_gp /)
     psppar(1,0:6) = (/ 0.837564310000_gp, 1.200395040000_gp, 0.926675250000_gp, -0.315857550000_gp, -0.358899780000_gp &
        & , -0.077061350000_gp, 0.198971550000_gp /)
     psppar(2,0:6) = (/ 1.174178250000_gp, 0.439983390000_gp, 0.018266850000_gp, 0.000000000000_gp, -0.007719150000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.743175480000_gp, -1.386990260000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sr_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 38
     nelpsp   = 10
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.480000000000_gp, 5.571455090000_gp, -1.079963040000_gp /)
     psppar(1,0:6) = (/ 0.275440560000_gp, 9.995135310000_gp, 9.336678920000_gp, 0.000000000000_gp, -3.616080190000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.302243130000_gp, 3.169125720000_gp, 4.049231440000_gp, 0.000000000000_gp, -1.711112590000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.502045440000_gp, 0.438728210000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ta" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 73
     nelpsp   = 5
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.744000000000_gp, 3.623116450000_gp /)
     psppar(1,0:6) = (/ 0.581801130000_gp, 2.005338330000_gp, 3.027036130000_gp, 0.000000000000_gp, -1.172366050000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.770646280000_gp, 0.518566640000_gp, 1.185378410000_gp, 0.000000000000_gp, -0.500913800000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.534369960000_gp, -2.202200400000_gp, -1.666674950000_gp, 0.000000000000_gp, 0.734934570000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ta_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 73
     nelpsp   = 13
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.550000000000_gp, 4.546236270000_gp, 0.779422340000_gp /)
     psppar(1,0:6) = (/ 0.421853500000_gp, 2.708135580000_gp, -5.790959060000_gp, 0.947663140000_gp, 2.242828800000_gp &
        & , 0.231206130000_gp, -0.596971670000_gp /)
     psppar(2,0:6) = (/ 0.461345160000_gp, -0.724852770000_gp, -2.215211410000_gp, 0.000000000000_gp, 0.936097670000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.410994340000_gp, 1.348494720000_gp, -5.386946620000_gp, 0.000000000000_gp, 2.375420180000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tb" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 65
     nelpsp   = 19
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.514583350000_gp, 17.603616230000_gp, -0.828080040000_gp /)
     psppar(1,0:6) = (/ 0.448694390000_gp, 1.718480880000_gp, -3.435239290000_gp, 0.000000000000_gp, 1.330462450000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.424220130000_gp, 0.562399780000_gp, -2.781826710000_gp, 0.000000000000_gp, 1.175536340000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.482808660000_gp, -0.625802190000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.268259950000_gp, -22.911697090000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 43
     nelpsp   = 7
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.673000000000_gp, 13.315380670000_gp /)
     psppar(1,0:6) = (/ 0.677611880000_gp, 0.819217670000_gp, 0.348459680000_gp, 0.000000000000_gp, -0.134957860000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.784275380000_gp, 0.028672660000_gp, 0.658362920000_gp, 0.000000000000_gp, -0.278209110000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.519889750000_gp, -5.984224270000_gp, 0.721822460000_gp, 0.000000000000_gp, -0.318293790000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tc_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 43
     nelpsp   = 15
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.430000010000_gp, 14.910011290000_gp, 1.046381470000_gp /)
     psppar(1,0:6) = (/ 0.369721110000_gp, 3.917408440000_gp, -5.268398920000_gp, 0.000000000000_gp, 2.040442130000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.357772350000_gp, -0.270000070000_gp, -3.737771160000_gp, 0.000000000000_gp, 1.579496600000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.510487330000_gp, -1.586709100000_gp, 1.132307240000_gp, 0.000000000000_gp, -0.499300560000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Te" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 52
     nelpsp   = 6
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.575000000000_gp, 9.387084810000_gp /)
     psppar(1,0:6) = (/ 0.556456020000_gp, 2.046890310000_gp, -0.029332600000_gp, -0.881119270000_gp, 0.011360470000_gp &
        & , -0.214971090000_gp, 0.555052970000_gp /)
     psppar(2,0:6) = (/ 0.615261870000_gp, 1.033477540000_gp, -0.481172400000_gp, 0.000000000000_gp, 0.203332450000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.805100720000_gp, 0.317410730000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ti" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 22
     nelpsp   = 4
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.720000000000_gp /)
     psppar(1,0:6) = (/ 0.528410760000_gp, 1.866613300000_gp, 1.440233250000_gp, 3.658171770000_gp, -0.557799940000_gp &
        & , 0.892502530000_gp, -2.304431610000_gp /)
     psppar(2,0:6) = (/ 0.791145540000_gp, 0.967915770000_gp, 0.260686690000_gp, 0.000000000000_gp, -0.110160230000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.408711780000_gp, -4.826456350000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ti_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 22
     nelpsp   = 12
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.380000000000_gp, 7.548789470000_gp, -0.588376660000_gp /)
     psppar(1,0:6) = (/ 0.334234660000_gp, 6.925739700000_gp, -3.142004990000_gp, 0.000000000000_gp, 1.216893300000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.242415820000_gp, 5.079086500000_gp, -6.284280530000_gp, 0.000000000000_gp, 2.655593210000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.242947500000_gp, -9.125895910000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tl" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 81
     nelpsp   = 3
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.630000000000_gp, -1.235845520000_gp /)
     psppar(1,0:6) = (/ 0.754005470000_gp, 1.875765710000_gp, -0.303679640000_gp, -0.781336890000_gp, 0.117614620000_gp &
        & , -0.190626680000_gp, 0.492195970000_gp /)
     psppar(2,0:6) = (/ 0.903741700000_gp, 0.759668300000_gp, -0.586720510000_gp, 0.000000000000_gp, 0.247934670000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.063512120000_gp, 0.247613960000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tl_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 81
     nelpsp   = 13
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.550000000000_gp, 7.301885820000_gp /)
     psppar(1,0:6) = (/ 0.502422660000_gp, 3.326560220000_gp, 4.341390270000_gp, 0.000000000000_gp, -1.681413220000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.572015940000_gp, 1.272807290000_gp, 2.992205980000_gp, 0.000000000000_gp, -1.264437810000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.393185040000_gp, -3.200652270000_gp, -3.008295730000_gp, 0.000000000000_gp, 1.326533730000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tm" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 69
     nelpsp   = 23
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.502916690000_gp, 17.247292540000_gp, -1.627697080000_gp /)
     psppar(1,0:6) = (/ 0.413372860000_gp, 1.947195830000_gp, -4.121556440000_gp, 0.000000000000_gp, 1.596271950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.409923010000_gp, -0.094492810000_gp, -2.224087180000_gp, 0.000000000000_gp, 0.939848370000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.392870090000_gp, -1.353307700000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.243916960000_gp, -28.104158750000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "V" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 23
     nelpsp   = 5
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.690000000000_gp /)
     psppar(1,0:6) = (/ 0.514704210000_gp, 2.208669780000_gp, 1.896763070000_gp, 3.076377230000_gp, -0.734613180000_gp &
        & , 0.750559190000_gp, -1.937935500000_gp /)
     psppar(2,0:6) = (/ 0.743503810000_gp, 1.115751210000_gp, 0.286648870000_gp, 0.000000000000_gp, -0.121131260000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.374889590000_gp, -5.841633170000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "V_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 23
     nelpsp   = 13
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.375000000000_gp, 4.941290580000_gp, -0.096443360000_gp /)
     psppar(1,0:6) = (/ 0.326651120000_gp, 7.659390480000_gp, -3.892229250000_gp, 0.000000000000_gp, 1.507453910000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.246407480000_gp, 4.256230490000_gp, -5.941211870000_gp, 0.000000000000_gp, 2.510620240000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.240791500000_gp, -8.828517570000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "W" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 74
     nelpsp   = 6
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.719000000000_gp, 4.058449910000_gp /)
     psppar(1,0:6) = (/ 0.582462890000_gp, 2.161165560000_gp, 2.741499910000_gp, 0.000000000000_gp, -1.061778350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.742307410000_gp, 0.600973390000_gp, 1.299942840000_gp, 0.000000000000_gp, -0.549326110000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.534958870000_gp, -2.517063470000_gp, -0.789136610000_gp, 0.000000000000_gp, 0.347976540000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "W_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 74
     nelpsp   = 14
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.540000000000_gp, 4.800250940000_gp, 0.901544340000_gp /)
     psppar(1,0:6) = (/ 0.418569630000_gp, 2.692204330000_gp, -6.022637500000_gp, 1.218315500000_gp, 2.332557470000_gp &
        & , 0.297238550000_gp, -0.767466630000_gp /)
     psppar(2,0:6) = (/ 0.449554920000_gp, -0.702084260000_gp, -2.451680430000_gp, 0.000000000000_gp, 1.036024070000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.399601670000_gp, 1.177436380000_gp, -5.553621060000_gp, 0.000000000000_gp, 2.448916700000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Xe" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 54
     nelpsp   = 8
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.560000000000_gp, 12.734279720000_gp /)
     psppar(1,0:6) = (/ 0.507371180000_gp, 2.236450690000_gp, -0.403550730000_gp, -1.132506550000_gp, 0.156294530000_gp &
        & , -0.276303310000_gp, 0.713412070000_gp /)
     psppar(2,0:6) = (/ 0.541023710000_gp, 1.130042990000_gp, -0.752764130000_gp, 0.000000000000_gp, 0.318100910000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.729821110000_gp, 0.280130780000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Y" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 39
     nelpsp   = 3
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.900000000000_gp, -0.343891320000_gp /)
     psppar(1,0:6) = (/ 0.782456990000_gp, 1.520654660000_gp, 1.484368360000_gp, -0.189013340000_gp, -0.574893400000_gp &
        & , -0.046114530000_gp, 0.119067210000_gp /)
     psppar(2,0:6) = (/ 0.949863750000_gp, 0.780950000000_gp, 0.368738940000_gp, 0.000000000000_gp, -0.155820640000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.653850600000_gp, -1.256929790000_gp, -0.075367970000_gp, 0.000000000000_gp, 0.033234150000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Y_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 39
     nelpsp   = 11
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.475000000000_gp, 6.892621130000_gp, -1.448411370000_gp /)
     psppar(1,0:6) = (/ 0.259296130000_gp, 11.068494070000_gp, 10.479636160000_gp, 0.000000000000_gp, -4.058745630000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.288511470000_gp, 3.019075480000_gp, 4.282482100000_gp, 0.000000000000_gp, -1.809678990000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.503642090000_gp, 0.339919010000_gp, 0.018042510000_gp, 0.000000000000_gp, -0.007956000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Yb" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 70
     nelpsp   = 24
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.500000000000_gp, 17.357144210000_gp, -1.773916420000_gp /)
     psppar(1,0:6) = (/ 0.402309180000_gp, 2.120770950000_gp, -4.802989990000_gp, 0.000000000000_gp, 1.860190030000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.414357740000_gp, -0.923212160000_gp, -1.678539590000_gp, 0.000000000000_gp, 0.709312440000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.444024680000_gp, -0.889967330000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.238298290000_gp, -29.932853670000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Zn" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 30
     nelpsp   = 2
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.570000000000_gp /)
     psppar(1,0:6) = (/ 0.640712190000_gp, 2.088557240000_gp, -0.218270240000_gp, -0.941316590000_gp, 0.084535700000_gp &
        & , -0.229657730000_gp, 0.592973710000_gp /)
     psppar(2,0:6) = (/ 0.967604830000_gp, 0.163546000000_gp, -0.227086350000_gp, 0.000000000000_gp, 0.095961500000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.330352000000_gp, 0.010485780000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Zn_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 30
     nelpsp   = 12
     npspcode = 10
     ixc      = 1
     psppar(0,0:0) = (/ 0.510000000000_gp /)
     psppar(1,0:6) = (/ 0.400866200000_gp, 4.278709730000_gp, 3.627341960000_gp, 2.849566860000_gp, -1.404863500000_gp &
        & , 0.695223130000_gp, -1.795058400000_gp /)
     psppar(2,0:6) = (/ 0.539618060000_gp, 2.023884000000_gp, 0.431741710000_gp, 0.000000000000_gp, -0.182444170000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.252150590000_gp, -14.338368410000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Zn_sc+" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 30
     nelpsp   = 20
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.340000000000_gp, -0.621648860000_gp, 1.274222890000_gp /)
     psppar(1,0:6) = (/ 0.238928240000_gp, 0.308443680000_gp, -15.955113180000_gp, 0.000000000000_gp, 12.358777520000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.239601390000_gp, -9.437442200000_gp, -9.934238220000_gp, 0.000000000000_gp, 8.395963700000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.206562460000_gp, -14.032174270000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Zr" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 40
     nelpsp   = 4
     npspcode = 10
     ixc      = 1
     psppar(0,0:1) = (/ 0.750000000000_gp, -0.782610980000_gp /)
     psppar(1,0:6) = (/ 0.649998210000_gp, 1.739877470000_gp, 2.388208460000_gp, 1.205348760000_gp, -0.924949160000_gp &
        & , 0.294074990000_gp, -0.759298350000_gp /)
     psppar(2,0:6) = (/ 0.874407690000_gp, 1.018293810000_gp, 0.528223320000_gp, 0.000000000000_gp, -0.223215090000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.630667610000_gp, -1.173910570000_gp, 0.212178610000_gp, 0.000000000000_gp, -0.093561970000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Zr_sc" .and. trim(name_ixc) == trim(name_xcpsp(1))) then
     nzatom   = 40
     nelpsp   = 12
     npspcode = 10
     ixc      = 1
     psppar(0,0:2) = (/ 0.470000000000_gp, 6.342618370000_gp, -1.732171000000_gp /)
     psppar(1,0:6) = (/ 0.262509600000_gp, 11.101774560000_gp, 9.589809390000_gp, 0.000000000000_gp, -3.714117200000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.288813760000_gp, 3.446819550000_gp, 4.229020440000_gp, 0.000000000000_gp, -1.787087310000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.588252390000_gp, 0.334636950000_gp, -0.195519900000_gp, 0.000000000000_gp, 0.086216170000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ag" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 47
     nelpsp   = 11
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.570000000000_gp, 0.033419120000_gp /)
     psppar(1,0:6) = (/ 0.527044610000_gp, 9.582045350000_gp, 8.430712590000_gp, 2.043338820000_gp, -5.274240430000_gp &
        & , 0.997047250000_gp, -2.574364940000_gp /)
     psppar(2,0:6) = (/ 0.629112180000_gp, 3.874019040000_gp, 2.061299250000_gp, 0.000000000000_gp, -1.742115830000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.405381860000_gp, -2.724952760000_gp, 0.491597810000_gp, 0.000000000000_gp, -0.433548510000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Al" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 13
     nelpsp   = 3
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.450000000000_gp, -7.554761260000_gp /)
     psppar(1,0:6) = (/ 0.487435290000_gp, 6.959938320000_gp, 2.438476590000_gp, 0.000000000000_gp, -1.888835840000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.562189490000_gp, 1.865298570000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ar" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 18
     nelpsp   = 8
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.400000000000_gp, -7.100000000000_gp /)
     psppar(1,0:6) = (/ 0.318814680000_gp, 17.252038070000_gp, 7.210834470000_gp, 0.000000000000_gp, -5.585488360000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.353370190000_gp, 4.974215510000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "As" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 33
     nelpsp   = 5
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.520000000000_gp /)
     psppar(1,0:6) = (/ 0.455549570000_gp, 5.520673270000_gp, -1.771193200000_gp, -2.174571800000_gp, 0.035122200000_gp &
        & , -1.061082390000_gp, 2.739702950000_gp /)
     psppar(2,0:6) = (/ 0.554605570000_gp, 1.021791560000_gp, -0.744489250000_gp, 0.000000000000_gp, 0.629208260000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.703688720000_gp, 0.314795040000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "At" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 85
     nelpsp   = 7
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.580000000000_gp, 14.217168530000_gp /)
     psppar(1,0:6) = (/ 0.665806830000_gp, -0.378912030000_gp, -0.399961680000_gp, 0.571471300000_gp, 0.661126260000_gp &
        & , 0.278849440000_gp, -0.719986160000_gp /)
     psppar(2,0:6) = (/ 0.652411950000_gp, 0.267047450000_gp, -0.385998450000_gp, 0.000000000000_gp, 0.326228230000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.854060590000_gp, 0.452594670000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Au" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 79
     nelpsp   = 11
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.590000000000_gp, 10.517178810000_gp /)
     psppar(1,0:6) = (/ 0.543847330000_gp, 5.786811030000_gp, 2.905614950000_gp, 0.000000000000_gp, -2.250679660000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.609172980000_gp, 4.284048730000_gp, 4.817209620000_gp, 0.000000000000_gp, -4.071285200000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.437309220000_gp, -7.403281240000_gp, -3.413238110000_gp, 0.000000000000_gp, 3.010193070000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Au_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 79
     nelpsp   = 19
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.490000000000_gp, 8.369458850000_gp /)
     psppar(1,0:6) = (/ 0.290084020000_gp, -5.988690020000_gp, -58.385560500000_gp, -31.101994770000_gp, 26.105021370000_gp &
        & , -15.176219480000_gp, 39.184830210000_gp /)
     psppar(2,0:6) = (/ 0.361505760000_gp, -5.876953320000_gp, -0.725138630000_gp, 4.922910220000_gp, 4.731446060000_gp &
        & , 2.927105260000_gp, -6.926795300000_gp /)
     psppar(3,0:6) = (/ 0.340373130000_gp, -8.804584320000_gp, -10.762820320000_gp, 0.000000000000_gp, 9.491915320000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "B" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 5
     nelpsp   = 3
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.418991450000_gp, -5.859461710000_gp, 0.903756430000_gp /)
     psppar(1,0:6) = (/ 0.371320460000_gp, 6.297280180000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.364563080000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ba" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 56
     nelpsp   = 10
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.540000000000_gp, 24.526780700000_gp, -2.468670010000_gp /)
     psppar(1,0:6) = (/ 0.492068390000_gp, 0.095150930000_gp, -1.509583570000_gp, 0.000000000000_gp, 1.169318400000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.391489300000_gp, 0.800182610000_gp, 1.913069790000_gp, 0.000000000000_gp, -1.616839070000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.672173480000_gp, 0.388531000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.300497730000_gp, -19.653794520000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Be" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 4
     nelpsp   = 4
     npspcode = 10
     ixc      = 11
     psppar(0,0:4) = (/ 0.325000000000_gp, -24.067466840000_gp, 17.279021860000_gp, -3.339106290000_gp, 0.165549120000_gp &
        &  /)
     exists = .true.
  else if (trim(symbol) == "Bi" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 83
     nelpsp   = 5
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.605000000000_gp, 7.945756920000_gp /)
     psppar(1,0:6) = (/ 0.582232160000_gp, 0.643735270000_gp, -5.244797110000_gp, -2.952352750000_gp, 2.247616170000_gp &
        & , -1.440600630000_gp, 3.719614840000_gp /)
     psppar(2,0:6) = (/ 0.766394000000_gp, 0.212532920000_gp, -0.449425850000_gp, 0.000000000000_gp, 0.379834170000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.965654790000_gp, 0.347298220000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Br" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 35
     nelpsp   = 7
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.500000000000_gp /)
     psppar(1,0:6) = (/ 0.438038920000_gp, 6.078556320000_gp, -2.440900200000_gp, -2.537928410000_gp, 0.330498170000_gp &
        & , -1.238382260000_gp, 3.197489240000_gp /)
     psppar(2,0:6) = (/ 0.453135610000_gp, 2.459303810000_gp, -0.618529850000_gp, 0.000000000000_gp, 0.522753130000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.567713830000_gp, 0.559266450000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "C" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 6
     nelpsp   = 4
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.338471240000_gp, -8.803673980000_gp, 1.339210850000_gp /)
     psppar(1,0:6) = (/ 0.302575750000_gp, 9.622486650000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.291506940000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ca" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 20
     nelpsp   = 10
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.390000000000_gp, -4.167072220000_gp, -1.583797810000_gp /)
     psppar(1,0:6) = (/ 0.289355720000_gp, 20.531876350000_gp, 9.204513870000_gp, 0.000000000000_gp, -7.129785780000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.327882060000_gp, 5.805605130000_gp, 0.507307820000_gp, 0.000000000000_gp, -0.428753360000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.679617130000_gp, 0.058068260000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cd" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 48
     nelpsp   = 12
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.550000000000_gp, 3.633958580000_gp /)
     psppar(1,0:6) = (/ 0.491279000000_gp, 10.111382280000_gp, 11.335585980000_gp, 3.698281910000_gp, -6.506954090000_gp &
        & , 1.804576790000_gp, -4.659397240000_gp /)
     psppar(2,0:6) = (/ 0.599709990000_gp, 4.001487290000_gp, 2.229102880000_gp, 0.000000000000_gp, -1.883935780000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.377872560000_gp, -6.137032230000_gp, -1.741332090000_gp, 0.000000000000_gp, 1.535710550000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cl" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 17
     nelpsp   = 7
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.410000000000_gp, -6.392081810000_gp /)
     psppar(1,0:6) = (/ 0.339538640000_gp, 15.218989830000_gp, 6.370442080000_gp, 0.000000000000_gp, -4.934523210000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.378474160000_gp, 4.338775270000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Co" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 27
     nelpsp   = 17
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.355000000000_gp, 4.828197360000_gp, 0.368143010000_gp /)
     psppar(1,0:6) = (/ 0.276800760000_gp, -0.584495820000_gp, -11.988552420000_gp, 0.000000000000_gp, 9.286292770000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.268157830000_gp, -6.851953490000_gp, -6.720823760000_gp, 0.000000000000_gp, 5.680132800000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.222584140000_gp, -12.333150190000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cr" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 24
     nelpsp   = 14
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.370000000000_gp, 5.699657640000_gp, -0.695485990000_gp /)
     psppar(1,0:6) = (/ 0.313934420000_gp, 2.869954740000_gp, -6.421995700000_gp, 0.000000000000_gp, 4.974456480000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.240866240000_gp, -4.476208670000_gp, -8.674646500000_gp, 0.000000000000_gp, 7.331414400000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.220286330000_gp, -11.197116410000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cs" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 55
     nelpsp   = 9
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.540000000000_gp, 33.313316760000_gp, -2.921216700000_gp /)
     psppar(1,0:6) = (/ 0.461895680000_gp, -3.322927000000_gp, -3.170234880000_gp, 0.000000000000_gp, 2.455653380000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.366358600000_gp, -4.950764050000_gp, -0.994362590000_gp, 0.000000000000_gp, 0.840389770000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.761501930000_gp, 0.198407230000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.597015030000_gp, -1.550566930000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Cu" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 29
     nelpsp   = 11
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.530000000000_gp /)
     psppar(1,0:6) = (/ 0.431355050000_gp, 9.693805070000_gp, 11.501773960000_gp, 3.967521270000_gp, -6.470165350000_gp &
        & , 1.935952150000_gp, -4.998606960000_gp /)
     psppar(2,0:6) = (/ 0.561391550000_gp, 2.545473300000_gp, 0.928393520000_gp, 0.000000000000_gp, -0.784635730000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.264554850000_gp, -12.828614060000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "F" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 9
     nelpsp   = 7
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.214929590000_gp, -21.573028360000_gp, 3.199776150000_gp /)
     psppar(1,0:6) = (/ 0.194684020000_gp, 23.743540450000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.186156080000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Fe" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 26
     nelpsp   = 16
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.360000000000_gp, 6.756789160000_gp, -0.228832510000_gp /)
     psppar(1,0:6) = (/ 0.278263030000_gp, 0.629505700000_gp, -10.215810020000_gp, 0.000000000000_gp, 7.913132420000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.251383380000_gp, -7.932132930000_gp, -9.107306540000_gp, 0.000000000000_gp, 7.697078880000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.222855780000_gp, -12.385799370000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ga" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 31
     nelpsp   = 3
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.560000000000_gp /)
     psppar(1,0:6) = (/ 0.565866450000_gp, 2.215750510000_gp, -2.570048450000_gp, -1.558826520000_gp, 1.032447930000_gp &
        & , -0.760629460000_gp, 1.963936820000_gp /)
     psppar(2,0:6) = (/ 0.646716130000_gp, 0.311223940000_gp, -0.725803660000_gp, 0.000000000000_gp, 0.613416050000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.999424840000_gp, 0.089519510000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ga_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 31
     nelpsp   = 13
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.490000000000_gp /)
     psppar(1,0:6) = (/ 0.416777230000_gp, 10.475689750000_gp, 7.770178090000_gp, 1.784415450000_gp, -4.921768140000_gp &
        & , 0.870705590000_gp, -2.248152160000_gp /)
     psppar(2,0:6) = (/ 0.569626520000_gp, 1.777985340000_gp, -0.231744390000_gp, 0.000000000000_gp, 0.195859760000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.238126500000_gp, -16.248680220000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ge" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 32
     nelpsp   = 4
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.540000000000_gp /)
     psppar(1,0:6) = (/ 0.421865180000_gp, 7.510241210000_gp, -1.595888190000_gp, -2.967467350000_gp, -0.588108360000_gp &
        & , -1.447975800000_gp, 3.738657440000_gp /)
     psppar(2,0:6) = (/ 0.567528870000_gp, 0.913859690000_gp, -0.647071630000_gp, 0.000000000000_gp, 0.546875340000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.813913940000_gp, 0.197177310000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "H" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 1
     nelpsp   = 1
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.200000000000_gp, -4.178900440000_gp, 0.724463310000_gp /)
     exists = .true.
  else if (trim(symbol) == "He" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 2
     nelpsp   = 2
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.200000000000_gp, -9.122143830000_gp, 1.702707700000_gp /)
     exists = .true.
  else if (trim(symbol) == "Hf" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 72
     nelpsp   = 12
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.560000000000_gp, 15.522365670000_gp, -2.433566780000_gp /)
     psppar(1,0:6) = (/ 0.311828490000_gp, -10.910130590000_gp, -59.672928920000_gp, -30.662093760000_gp, 27.372645870000_gp &
        & , -14.961569770000_gp, 38.630607030000_gp /)
     psppar(2,0:6) = (/ 0.361966600000_gp, -9.651700490000_gp, -10.913152640000_gp, 0.000000000000_gp, 9.223297390000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.415790700000_gp, -2.748914640000_gp, -0.545780720000_gp, 0.000000000000_gp, 0.481333350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Hg" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 80
     nelpsp   = 12
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.570000000000_gp, 8.467847340000_gp /)
     psppar(1,0:6) = (/ 0.529786690000_gp, 7.371243060000_gp, 3.834181260000_gp, 0.000000000000_gp, -2.969944030000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.635165960000_gp, 3.551161410000_gp, 2.038573830000_gp, 0.000000000000_gp, -1.722909350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.407985430000_gp, -8.613980150000_gp, -5.678040690000_gp, 0.000000000000_gp, 5.007561200000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "I" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 53
     nelpsp   = 7
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.560000000000_gp, 8.207101570000_gp /)
     psppar(1,0:6) = (/ 0.531928130000_gp, 2.308145810000_gp, -2.856108820000_gp, -1.965684980000_gp, 1.003909330000_gp &
        & , -0.959156060000_gp, 2.476530300000_gp /)
     psppar(2,0:6) = (/ 0.589182440000_gp, 0.906482190000_gp, -0.502950320000_gp, 0.000000000000_gp, 0.425070600000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.739721470000_gp, 0.479194580000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "In" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 49
     nelpsp   = 3
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.610000000000_gp, 5.086228490000_gp /)
     psppar(1,0:6) = (/ 0.688883180000_gp, 0.562283760000_gp, -2.071954760000_gp, -0.985629930000_gp, 0.999004130000_gp &
        & , -0.480938160000_gp, 1.241776990000_gp /)
     psppar(2,0:6) = (/ 0.763709740000_gp, 0.108922990000_gp, -0.500829700000_gp, 0.000000000000_gp, 0.423278350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.143911920000_gp, 0.116839480000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "In_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 49
     nelpsp   = 13
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.530000000000_gp, 3.324785460000_gp /)
     psppar(1,0:6) = (/ 0.479495210000_gp, 11.117160240000_gp, 10.937274710000_gp, 3.088150740000_gp, -6.573507290000_gp &
        & , 1.506863270000_gp, -3.890704220000_gp /)
     psppar(2,0:6) = (/ 0.569932850000_gp, 4.700614190000_gp, 2.623265570000_gp, 0.000000000000_gp, -2.217064060000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.377068900000_gp, -4.002287850000_gp, 0.952616140000_gp, 0.000000000000_gp, -0.840128460000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ir" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 77
     nelpsp   = 9
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.641000000000_gp, 14.581813970000_gp /)
     psppar(1,0:6) = (/ 0.510104740000_gp, 3.715249990000_gp, 1.630057940000_gp, 0.000000000000_gp, -1.262637450000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.684891600000_gp, 1.919101520000_gp, 2.243607690000_gp, 0.000000000000_gp, -1.896194580000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.471735080000_gp, -8.856031300000_gp, -3.594729150000_gp, 0.000000000000_gp, 3.170253120000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ir_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 77
     nelpsp   = 17
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.510000000000_gp, 13.410805760000_gp, -2.341948220000_gp /)
     psppar(1,0:6) = (/ 0.387264110000_gp, -2.516284910000_gp, 6.241735090000_gp, 9.581014300000_gp, 1.055190060000_gp &
        & , 4.675056280000_gp, -12.070943400000_gp /)
     psppar(2,0:6) = (/ 0.346083070000_gp, -6.526150690000_gp, -8.700404550000_gp, 0.000000000000_gp, 7.353183920000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.378812900000_gp, -0.855952500000_gp, 1.332722890000_gp, 0.000000000000_gp, -1.175351110000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "K" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 19
     nelpsp   = 9
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.400000000000_gp, -3.363551840000_gp, -1.086529750000_gp /)
     psppar(1,0:6) = (/ 0.305317720000_gp, 17.850623210000_gp, 7.258808260000_gp, 0.000000000000_gp, -5.622648700000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.316484320000_gp, 7.333780210000_gp, 2.911829450000_gp, 0.000000000000_gp, -2.460945050000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Kr" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 36
     nelpsp   = 8
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.500000000000_gp /)
     psppar(1,0:6) = (/ 0.421657170000_gp, 6.465303580000_gp, -3.139388700000_gp, -3.079416070000_gp, 0.538660490000_gp &
        & , -1.502601180000_gp, 3.879699570000_gp /)
     psppar(2,0:6) = (/ 0.433744370000_gp, 2.601165350000_gp, -0.834297150000_gp, 0.000000000000_gp, 0.705109780000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.524690730000_gp, 0.635594720000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "La" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 57
     nelpsp   = 11
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.535000000000_gp, 20.689804690000_gp, -1.703270350000_gp /)
     psppar(1,0:6) = (/ 0.561447230000_gp, -0.028239770000_gp, -1.392464300000_gp, 0.000000000000_gp, 1.078598210000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.475173090000_gp, 0.268022680000_gp, -0.796641600000_gp, 0.000000000000_gp, 0.673285030000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.629083990000_gp, 0.380227180000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(4,0:6) = (/ 0.299117080000_gp, -18.443548860000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Li" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 3
     nelpsp   = 3
     npspcode = 10
     ixc      = 11
     psppar(0,0:4) = (/ 0.400000000000_gp, -14.081154550000_gp, 9.626219620000_gp, -1.783616050000_gp, 0.085152070000_gp &
        &  /)
     exists = .true.
  else if (trim(symbol) == "Mg" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 12
     nelpsp   = 2
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.576960170000_gp, -2.690407440000_gp /)
     psppar(1,0:6) = (/ 0.593923500000_gp, 3.503210990000_gp, 0.925348250000_gp, 0.000000000000_gp, -0.716771670000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.707157280000_gp, 0.831158480000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mg_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 12
     nelpsp   = 10
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.192757870000_gp, -20.575390770000_gp, 3.040167320000_gp /)
     psppar(1,0:6) = (/ 0.141406820000_gp, 41.047292090000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.102931870000_gp, -9.985625660000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mn" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 25
     nelpsp   = 15
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.365000000000_gp, 6.093046490000_gp, -0.446469480000_gp /)
     psppar(1,0:6) = (/ 0.295685920000_gp, 1.887119840000_gp, -8.206640740000_gp, 0.000000000000_gp, 6.356836580000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.245612610000_gp, -6.570024520000_gp, -9.446038740000_gp, 0.000000000000_gp, 7.983359830000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.222522790000_gp, -11.612050920000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Mo" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 42
     nelpsp   = 14
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.430000000000_gp, 28.609368320000_gp, -4.721803360000_gp /)
     psppar(1,0:6) = (/ 0.345215790000_gp, 0.146303050000_gp, -3.565733120000_gp, 0.000000000000_gp, 2.762005000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.416887620000_gp, -0.190784950000_gp, 0.862261560000_gp, 0.000000000000_gp, -0.728744020000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.420507850000_gp, 1.216814190000_gp, 3.046162340000_gp, 0.000000000000_gp, -2.686462670000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "N" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 7
     nelpsp   = 5
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.283790510000_gp, -12.415225590000_gp, 1.868095920000_gp /)
     psppar(1,0:6) = (/ 0.255405000000_gp, 13.630262570000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.245494530000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Na" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 11
     nelpsp   = 9
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.236523220000_gp, 0.295104990000_gp, -0.913884880000_gp /)
     psppar(1,0:6) = (/ 0.143560460000_gp, 34.601492280000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.129932240000_gp, -14.277461680000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Nb" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 41
     nelpsp   = 13
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.460000000000_gp, 26.275262520000_gp, -4.578031460000_gp /)
     psppar(1,0:6) = (/ 0.351169420000_gp, -1.043718700000_gp, -4.231755920000_gp, 0.000000000000_gp, 3.277904040000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.405460400000_gp, -0.662466470000_gp, 1.074157380000_gp, 0.000000000000_gp, -0.907828680000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.422121550000_gp, 1.494093230000_gp, 3.889299250000_gp, 0.000000000000_gp, -3.430039530000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ne" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 10
     nelpsp   = 8
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.190000000000_gp, -27.120159730000_gp, 4.360449620000_gp /)
     psppar(1,0:6) = (/ 0.176059380000_gp, 28.177370820000_gp, -1.076245280000_gp, 0.000000000000_gp, 0.833656010000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.195474520000_gp, -0.236293600000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ni" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 28
     nelpsp   = 18
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.350000000000_gp, 2.102165980000_gp, 0.648483870000_gp /)
     psppar(1,0:6) = (/ 0.261295300000_gp, 0.622658470000_gp, -12.871507290000_gp, 0.000000000000_gp, 9.970226670000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.224253460000_gp, -11.142708220000_gp, -14.706861340000_gp, 0.000000000000_gp, 12.429566440000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.215348250000_gp, -12.628145500000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "O" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 8
     nelpsp   = 6
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.244554300000_gp, -16.667214800000_gp, 2.487311320000_gp /)
     psppar(1,0:6) = (/ 0.220955920000_gp, 18.337458110000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.211332470000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Os" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 76
     nelpsp   = 8
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.667000000000_gp, 13.079048990000_gp /)
     psppar(1,0:6) = (/ 0.495760150000_gp, 4.350338780000_gp, 1.932364030000_gp, 0.000000000000_gp, -1.496802740000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.701161400000_gp, 1.816695500000_gp, 2.364253820000_gp, 0.000000000000_gp, -1.998159170000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.471173330000_gp, -10.995986970000_gp, -6.779753870000_gp, 0.000000000000_gp, 5.979180900000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Os_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 76
     nelpsp   = 16
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.520000000000_gp, 13.463030080000_gp, -2.241169830000_gp /)
     psppar(1,0:6) = (/ 0.390122070000_gp, -3.274168290000_gp, 2.826534640000_gp, 7.400385770000_gp, 2.360031370000_gp &
        & , 3.611018510000_gp, -9.323609690000_gp /)
     psppar(2,0:6) = (/ 0.349450250000_gp, -6.899282140000_gp, -8.908810170000_gp, 0.000000000000_gp, 7.529318820000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.392842070000_gp, -0.942682820000_gp, 1.226385580000_gp, 0.000000000000_gp, -1.081570420000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "P" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 15
     nelpsp   = 5
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.430000000000_gp, -5.875943270000_gp /)
     psppar(1,0:6) = (/ 0.396377420000_gp, 11.008862070000_gp, 4.480210420000_gp, 0.000000000000_gp, -3.470356070000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.448298380000_gp, 3.056064160000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pb" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 82
     nelpsp   = 4
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.617500000000_gp, 4.672384280000_gp /)
     psppar(1,0:6) = (/ 0.622358810000_gp, 0.879917680000_gp, -5.014690160000_gp, -2.933204210000_gp, 2.081147840000_gp &
        & , -1.431257100000_gp, 3.695489940000_gp /)
     psppar(2,0:6) = (/ 0.812002020000_gp, 0.153456790000_gp, -0.566639580000_gp, 0.000000000000_gp, 0.478897850000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.025015250000_gp, 0.301702060000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pd" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 46
     nelpsp   = 10
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.596000000000_gp, 5.299874010000_gp /)
     psppar(1,0:6) = (/ 0.591949900000_gp, 5.308194560000_gp, 2.662520270000_gp, 0.000000000000_gp, -2.062379330000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.666285260000_gp, 2.734584460000_gp, 1.735742370000_gp, 0.000000000000_gp, -1.466970050000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.438518390000_gp, -3.719788320000_gp, 0.915492230000_gp, 0.000000000000_gp, -0.807388250000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pd_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 46
     nelpsp   = 18
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.410000000000_gp, 26.783659170000_gp, -4.931305940000_gp /)
     psppar(1,0:6) = (/ 0.337970770000_gp, -0.718728750000_gp, -5.660838400000_gp, 0.000000000000_gp, 4.384866570000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.415195910000_gp, -0.046244490000_gp, 1.275450400000_gp, 0.000000000000_gp, -1.077952330000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.440270490000_gp, 1.639163580000_gp, 3.507912410000_gp, 0.000000000000_gp, -3.093687950000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Po" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 84
     nelpsp   = 6
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.592500000000_gp, 8.134325660000_gp /)
     psppar(1,0:6) = (/ 0.804223570000_gp, 0.326334080000_gp, 0.722874560000_gp, 1.082270940000_gp, 0.105399860000_gp &
        & , 0.528094140000_gp, -1.363533220000_gp /)
     psppar(2,0:6) = (/ 0.817036520000_gp, 0.158014810000_gp, -0.444063870000_gp, 0.000000000000_gp, 0.375302470000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.890149430000_gp, 0.462532380000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pt" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 78
     nelpsp   = 10
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.616000000000_gp, 11.313635250000_gp /)
     psppar(1,0:6) = (/ 0.550904260000_gp, 4.733491100000_gp, 2.303900960000_gp, 0.000000000000_gp, -1.784594010000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.674137810000_gp, 2.534798500000_gp, 2.103835530000_gp, 0.000000000000_gp, -1.778065550000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.457392430000_gp, -7.264011010000_gp, -2.901253180000_gp, 0.000000000000_gp, 2.558664800000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Pt_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 78
     nelpsp   = 18
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.500000000000_gp, 8.814323240000_gp, -0.292509430000_gp /)
     psppar(1,0:6) = (/ 0.298002210000_gp, -5.968384980000_gp, -53.687634130000_gp, -28.260433010000_gp, 24.212899660000_gp &
        & , -13.789679320000_gp, 35.604798900000_gp /)
     psppar(2,0:6) = (/ 0.360171820000_gp, -6.668659040000_gp, -7.207660720000_gp, 1.289806040000_gp, 7.170659220000_gp &
        & , 0.766903700000_gp, -1.814825380000_gp /)
     psppar(3,0:6) = (/ 0.340532060000_gp, -8.589904550000_gp, -10.670075420000_gp, 0.000000000000_gp, 9.410122000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rb" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 37
     nelpsp   = 9
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.490000000000_gp, 5.669086440000_gp, -0.811627030000_gp /)
     psppar(1,0:6) = (/ 0.281802920000_gp, 21.390732400000_gp, 10.429513940000_gp, 0.000000000000_gp, -8.078666760000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.285708280000_gp, 12.256348590000_gp, 14.433508070000_gp, 0.000000000000_gp, -12.198540750000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.541796510000_gp, 0.345666260000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Re" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 75
     nelpsp   = 7
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.693000000000_gp, 11.961941600000_gp /)
     psppar(1,0:6) = (/ 0.463315390000_gp, 6.087008760000_gp, 2.829059010000_gp, 0.000000000000_gp, -2.191379690000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.709648240000_gp, 1.815061560000_gp, 2.785434630000_gp, 0.000000000000_gp, -2.354121930000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.476064540000_gp, -12.393710020000_gp, -9.078287070000_gp, 0.000000000000_gp, 8.006296640000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Re_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 75
     nelpsp   = 15
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.530000000000_gp, 13.462631430000_gp, -2.234922400000_gp /)
     psppar(1,0:6) = (/ 0.393800770000_gp, -3.717480550000_gp, 0.572376400000_gp, 5.852925060000_gp, 3.154779030000_gp &
        & , 2.855935000000_gp, -7.373992450000_gp /)
     psppar(2,0:6) = (/ 0.352533320000_gp, -7.053404250000_gp, -8.953109220000_gp, 0.000000000000_gp, 7.566758350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.401867650000_gp, -0.900023590000_gp, 1.303037490000_gp, 0.000000000000_gp, -1.149171050000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rh" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 45
     nelpsp   = 9
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.619009480000_gp, 4.704543970000_gp /)
     psppar(1,0:6) = (/ 0.613326810000_gp, 4.993205150000_gp, 2.491337730000_gp, 0.000000000000_gp, -1.929781910000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.693650000000_gp, 2.532375060000_gp, 1.515534490000_gp, 0.000000000000_gp, -1.280860420000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.370037720000_gp, -16.882603770000_gp, -16.688889220000_gp, 0.000000000000_gp, 14.718216840000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rh_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 45
     nelpsp   = 17
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.420000000000_gp, 26.206793400000_gp, -4.937383350000_gp /)
     psppar(1,0:6) = (/ 0.345446220000_gp, -0.452482320000_gp, -5.025588850000_gp, 0.000000000000_gp, 3.892804380000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.378380140000_gp, -0.941112420000_gp, 0.006743510000_gp, 0.000000000000_gp, -0.005699310000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.433747250000_gp, 1.574236220000_gp, 3.415481660000_gp, 0.000000000000_gp, -3.012171700000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Rn" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 86
     nelpsp   = 8
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.570000000000_gp, 16.200617810000_gp /)
     psppar(1,0:6) = (/ 0.634808020000_gp, -0.581994050000_gp, -0.553135310000_gp, 0.609460040000_gp, 0.803127970000_gp &
        & , 0.297386050000_gp, -0.767847480000_gp /)
     psppar(2,0:6) = (/ 0.647108770000_gp, 0.169278800000_gp, -0.361086130000_gp, 0.000000000000_gp, 0.305173480000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.806342710000_gp, 0.511038740000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ru" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 44
     nelpsp   = 8
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.612113320000_gp, 5.044893320000_gp /)
     psppar(1,0:6) = (/ 0.642150400000_gp, 4.625563550000_gp, 2.328113590000_gp, 0.000000000000_gp, -1.803349030000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.679366540000_gp, 3.233952380000_gp, 2.864578420000_gp, 0.000000000000_gp, -2.421010640000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.380597200000_gp, -15.531654550000_gp, -15.398783490000_gp, 0.000000000000_gp, 13.580450540000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ru_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 44
     nelpsp   = 16
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.430000000000_gp, 26.832391040000_gp, -5.050497200000_gp /)
     psppar(1,0:6) = (/ 0.341355080000_gp, -0.555040910000_gp, -4.796676500000_gp, 0.000000000000_gp, 3.715489640000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.428270850000_gp, 0.106775080000_gp, 1.511643350000_gp, 0.000000000000_gp, -1.277571810000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.438147790000_gp, 1.509217420000_gp, 3.337110020000_gp, 0.000000000000_gp, -2.943054400000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "S" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 16
     nelpsp   = 6
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.420000000000_gp, -5.986260380000_gp /)
     psppar(1,0:6) = (/ 0.364820350000_gp, 13.143544480000_gp, 5.476179570000_gp, 0.000000000000_gp, -4.241830450000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.409480480000_gp, 3.700890570000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sb" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 51
     nelpsp   = 5
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.590000000000_gp, 7.928520840000_gp /)
     psppar(1,0:6) = (/ 0.556136360000_gp, 1.430477900000_gp, -3.130133400000_gp, -1.892065700000_gp, 1.261425990000_gp &
        & , -0.923233530000_gp, 2.383778720000_gp /)
     psppar(2,0:6) = (/ 0.622755070000_gp, 0.561472330000_gp, -0.360697730000_gp, 0.000000000000_gp, 0.304845220000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.889485760000_gp, 0.270868640000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 21
     nelpsp   = 11
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.385000000000_gp, 8.214900300000_gp, -0.557059100000_gp /)
     psppar(1,0:6) = (/ 0.363611080000_gp, 2.646533390000_gp, -3.900202590000_gp, 0.000000000000_gp, 3.021083930000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.243897780000_gp, -2.634822650000_gp, -9.456424210000_gp, 0.000000000000_gp, 7.992137150000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.253205750000_gp, -8.165947690000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Se" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 34
     nelpsp   = 6
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.510000000000_gp /)
     psppar(1,0:6) = (/ 0.432460050000_gp, 6.518109900000_gp, -1.657978330000_gp, -2.451334980000_gp, -0.222716390000_gp &
        & , -1.196128990000_gp, 3.088391780000_gp /)
     psppar(2,0:6) = (/ 0.470491620000_gp, 2.281262230000_gp, -0.432270550000_gp, 0.000000000000_gp, 0.365335290000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.625600340000_gp, 0.439799480000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Si" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 14
     nelpsp   = 4
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.440000000000_gp, -6.269288330000_gp /)
     psppar(1,0:6) = (/ 0.435633830000_gp, 8.951741500000_gp, 3.493780600000_gp, 0.000000000000_gp, -2.706270820000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.497942180000_gp, 2.431276730000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sn" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 50
     nelpsp   = 4
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.605000000000_gp, 6.266782300000_gp /)
     psppar(1,0:6) = (/ 0.566437320000_gp, 1.571181240000_gp, -3.814770130000_gp, -2.415363470000_gp, 1.470041180000_gp &
        & , -1.178576690000_gp, 3.043071930000_gp /)
     psppar(2,0:6) = (/ 0.641849590000_gp, 0.526897690000_gp, -0.477141070000_gp, 0.000000000000_gp, 0.403257810000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.990873020000_gp, 0.198766390000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Sr" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 38
     nelpsp   = 10
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.480000000000_gp, 6.810950350000_gp, -1.196109790000_gp /)
     psppar(1,0:6) = (/ 0.275885810000_gp, 21.289719430000_gp, 10.197609260000_gp, 0.000000000000_gp, -7.899034160000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.281740860000_gp, 11.709051350000_gp, 12.974882000000_gp, 0.000000000000_gp, -10.965776730000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.521089110000_gp, 0.360539060000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ta" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 73
     nelpsp   = 5
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.744000000000_gp, 9.839342570000_gp /)
     psppar(1,0:6) = (/ 0.452396660000_gp, 6.123380660000_gp, 2.800042180000_gp, 0.000000000000_gp, -2.168903350000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.751643900000_gp, 1.649701030000_gp, 2.975563770000_gp, 0.000000000000_gp, -2.514810380000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.501141810000_gp, -12.423344770000_gp, -10.221747350000_gp, 0.000000000000_gp, 9.014733810000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ta_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 73
     nelpsp   = 13
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.550000000000_gp, 13.385201670000_gp, -2.253920080000_gp /)
     psppar(1,0:6) = (/ 0.400883120000_gp, -4.436708990000_gp, -2.341148130000_gp, 3.843852290000_gp, 4.176489340000_gp &
        & , 1.875607870000_gp, -4.842798680000_gp /)
     psppar(2,0:6) = (/ 0.356549360000_gp, -7.624428080000_gp, -9.677470470000_gp, 0.000000000000_gp, 8.178955340000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.418229250000_gp, -1.113560850000_gp, 0.992531830000_gp, 0.000000000000_gp, -0.875330800000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 43
     nelpsp   = 15
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.430000000000_gp, 27.301999470000_gp, -4.647157090000_gp /)
     psppar(1,0:6) = (/ 0.346174990000_gp, -0.379218520000_gp, -4.312651880000_gp, 0.000000000000_gp, 3.340565780000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.423468400000_gp, -0.241516390000_gp, 0.972781490000_gp, 0.000000000000_gp, -0.822150420000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.431864680000_gp, 1.218784730000_gp, 3.032041820000_gp, 0.000000000000_gp, -2.674009540000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Te" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 52
     nelpsp   = 6
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.575000000000_gp, 8.713648680000_gp /)
     psppar(1,0:6) = (/ 0.574922400000_gp, 1.401812730000_gp, -2.054576240000_gp, -0.996630780000_gp, 0.978779920000_gp &
        & , -0.486306020000_gp, 1.255636750000_gp /)
     psppar(2,0:6) = (/ 0.589890760000_gp, 0.764788650000_gp, -0.383345680000_gp, 0.000000000000_gp, 0.323986230000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.813389250000_gp, 0.344858200000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Ti" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 22
     nelpsp   = 12
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.380000000000_gp, 8.711442180000_gp, -0.700286770000_gp /)
     psppar(1,0:6) = (/ 0.337770780000_gp, 2.575263860000_gp, -4.767604610000_gp, 0.000000000000_gp, 3.692970650000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.242531350000_gp, -4.630541230000_gp, -10.496160870000_gp, 0.000000000000_gp, 8.870875020000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.243316940000_gp, -9.406652680000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tl" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 81
     nelpsp   = 3
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.630000000000_gp, 1.452720830000_gp /)
     psppar(1,0:6) = (/ 0.780767880000_gp, 0.379730430000_gp, -2.306838340000_gp, -0.939784570000_gp, 1.209128020000_gp &
        & , -0.458567920000_gp, 1.184017270000_gp /)
     psppar(2,0:6) = (/ 0.897050090000_gp, -0.024235960000_gp, -0.689052690000_gp, 0.000000000000_gp, 0.582355820000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 1.093791940000_gp, 0.227641520000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Tl_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 81
     nelpsp   = 13
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.550000000000_gp, 12.290585150000_gp /)
     psppar(1,0:6) = (/ 0.512803060000_gp, 7.190170170000_gp, 3.696130960000_gp, 0.000000000000_gp, -2.863010730000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.577115050000_gp, 4.760945800000_gp, 4.346336710000_gp, 0.000000000000_gp, -3.673324960000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.393230010000_gp, -11.012687000000_gp, -7.281400930000_gp, 0.000000000000_gp, 6.421592020000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "V" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 23
     nelpsp   = 13
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.375000000000_gp, 7.474703540000_gp, -0.370263630000_gp /)
     psppar(1,0:6) = (/ 0.327795440000_gp, 1.940877620000_gp, -6.100837280000_gp, 0.000000000000_gp, 4.725688240000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.244765900000_gp, -5.978167050000_gp, -11.073291180000_gp, 0.000000000000_gp, 9.358639150000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.241738790000_gp, -9.499891100000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "W" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 74
     nelpsp   = 6
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.719000000000_gp, 10.699890130000_gp /)
     psppar(1,0:6) = (/ 0.467553720000_gp, 5.803502890000_gp, 2.673175160000_gp, 0.000000000000_gp, -2.070632570000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.726664630000_gp, 1.788719150000_gp, 3.022120730000_gp, 0.000000000000_gp, -2.554158190000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.499290650000_gp, -10.598325620000_gp, -7.311223650000_gp, 0.000000000000_gp, 6.447893190000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "W_sc" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 74
     nelpsp   = 14
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.540000000000_gp, 13.414811230000_gp, -2.213456030000_gp /)
     psppar(1,0:6) = (/ 0.397027900000_gp, -4.141210890000_gp, -1.319244040000_gp, 4.576655610000_gp, 3.835423460000_gp &
        & , 2.233179270000_gp, -5.766044080000_gp /)
     psppar(2,0:6) = (/ 0.353530690000_gp, -7.456236260000_gp, -9.598634010000_gp, 0.000000000000_gp, 8.112326370000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.412107030000_gp, -0.954660750000_gp, 1.210370260000_gp, 0.000000000000_gp, -1.067446230000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Xe" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 54
     nelpsp   = 8
     npspcode = 10
     ixc      = 11
     psppar(0,0:1) = (/ 0.560000000000_gp, 8.036362620000_gp /)
     psppar(1,0:6) = (/ 0.530494200000_gp, 2.232021480000_gp, -3.173713480000_gp, -2.046312450000_gp, 1.200358360000_gp &
        & , -0.998498240000_gp, 2.578111360000_gp /)
     psppar(2,0:6) = (/ 0.581774830000_gp, 0.796981810000_gp, -0.699555900000_gp, 0.000000000000_gp, 0.591232640000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.685545090000_gp, 0.560189000000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Y" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 39
     nelpsp   = 11
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.475000000000_gp, 12.167769040000_gp, -2.328551030000_gp /)
     psppar(1,0:6) = (/ 0.246740700000_gp, 23.450271950000_gp, 10.747990290000_gp, 0.000000000000_gp, -8.325357480000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.296563970000_gp, 5.978634010000_gp, 6.924593480000_gp, 0.000000000000_gp, -5.852349640000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.450455690000_gp, 1.187490480000_gp, 1.495234990000_gp, 0.000000000000_gp, -1.318673310000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Zn" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 30
     nelpsp   = 12
     npspcode = 10
     ixc      = 11
     psppar(0,0:0) = (/ 0.510000000000_gp /)
     psppar(1,0:6) = (/ 0.400316440000_gp, 11.530041330000_gp, 16.465775180000_gp, 6.445509180000_gp, -8.791898150000_gp &
        & , 3.145086440000_gp, -8.120578270000_gp /)
     psppar(2,0:6) = (/ 0.543182330000_gp, 2.597195120000_gp, 0.703141170000_gp, 0.000000000000_gp, -0.594262750000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.250958850000_gp, -14.466957950000_gp, 0.000000000000_gp, 0.000000000000_gp, 0.000000000000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  else if (trim(symbol) == "Zr" .and. trim(name_ixc) == trim(name_xcpsp(2))) then
     nzatom   = 40
     nelpsp   = 12
     npspcode = 10
     ixc      = 11
     psppar(0,0:2) = (/ 0.470000000000_gp, 7.796056770000_gp, -1.893210300000_gp /)
     psppar(1,0:6) = (/ 0.259828850000_gp, 23.380874170000_gp, 11.066326090000_gp, 0.000000000000_gp, -8.571939330000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(2,0:6) = (/ 0.288968990000_gp, 8.592765810000_gp, 6.362575890000_gp, 0.000000000000_gp, -5.377358080000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     psppar(3,0:6) = (/ 0.581245040000_gp, 0.027810640000_gp, -0.313931840000_gp, 0.000000000000_gp, 0.276861860000_gp &
        & , 0.000000000000_gp, 0.000000000000_gp /)
     exists = .true.
  end if
end subroutine psp_from_data
