!> @file
!!   Filters for interpolating scaling functions (order 50)
!! @author
!!    Copyright (C) 2009-2011 BigDFT group 
!!    This file is distributed under the terms of the
!!    GNU General Public License, see ~/COPYING file
!!    or http://www.gnu.org/copyleft/gpl.txt .
!!    For the list of contributors, see ~/AUTHORS 

integer, parameter :: m=52

real(kind=8), dimension(-m:m) :: ch = (/ &
     0.d0, 0.d0, 0.d0, &
     2.03510990661269603d-16,0.d0,-1.03963806080363471d-14,0.d0,&
      2.60602607241444435d-13,0.d0,-4.27267065360972853d-12,0.d0,&
      5.15325765417075794d-11,0.d0,-4.87577454971540944d-10,0.d0,&
      3.76884194923947865d-9,0.d0,-2.44743981275102471d-8,0.d0,&
      1.36277898664545694d-7,0.d0,-6.60874540835592558d-7,0.d0,&
      2.82580838150391301d-6,0.d0,-0.0000107609066649189415d0,0.d0,&
      0.0000368023007940227798d0,0.d0,-0.000113853271687194218d0,0.d0,&
      0.000320647989649649023d0,0.d0,-0.00082693428909646327d0,0.d0,&
      0.00196396893660410027d0,0.d0,-0.00432073166052902059d0,0.d0,&
      0.008863039303649273d0,0.d0,-0.0170899753079935742d0,0.d0,&
      0.0313316213979882195d0,0.d0,-0.0556296135025505121d0,0.d0,&
      0.0991218567863627306d0,0.d0,-0.193934067625492299d0,0.d0,0.630285719782849972d0,&
      1.d0,0.630285719782849972d0,0.d0,-0.193934067625492299d0,0.d0,&
      0.0991218567863627306d0,0.d0,-0.0556296135025505121d0,0.d0,&
      0.0313316213979882195d0,0.d0,-0.0170899753079935742d0,0.d0,&
      0.008863039303649273d0,0.d0,-0.00432073166052902059d0,0.d0,&
      0.00196396893660410027d0,0.d0,-0.00082693428909646327d0,0.d0,&
      0.000320647989649649023d0,0.d0,-0.000113853271687194218d0,0.d0,&
      0.0000368023007940227798d0,0.d0,-0.0000107609066649189415d0,0.d0,&
      2.82580838150391301d-6,0.d0,-6.60874540835592558d-7,0.d0,&
      1.36277898664545694d-7,0.d0,-2.44743981275102471d-8,0.d0,&
      3.76884194923947865d-9,0.d0,-4.87577454971540944d-10,0.d0,&
      5.15325765417075794d-11,0.d0,-4.27267065360972853d-12,0.d0,&
      2.60602607241444435d-13,0.d0,-1.03963806080363471d-14,0.d0,&
      2.03510990661269603d-16,&
     0.d0, 0.d0, 0.d0   /)
real(kind=8), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0.d0
   cg(i)=0.d0
   cgt(i)=0.d0
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1.d0

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1.d0)**(i+1)
   cgt(i+1)=ch(-i)*(-1.d0)**(i+1)
enddo


