!> @file
!!  Include file for filters for interpolating scaling functions (order 100)
!! @author
!!    Copyright (C) 2009-2011 BigDFT group 
!!    This file is distributed under the terms of the
!!    GNU General Public License, see ~/COPYING file
!!    or http://www.gnu.org/copyleft/gpl.txt .
!!    For the list of contributors, see ~/AUTHORS 
integer, parameter :: m=102
real(kind=8), dimension(-m:m) :: ch = (/ 0.d0, 0.d0, 0.d0, &
  -1.2683805626484815d-31,0.d0,1.28158741180595538d-29,0.d0,  -6.41198417717232202d-28,0.d0,2.11779334023809847d-26,0.d0,&
  -5.19441179715542395d-25,0.d0,1.00911662890805933d-23,0.d0, -1.61729304931893186d-22,0.d0,2.19924673311587861d-21,0.d0,&
  -2.59007672484430282d-20,0.d0,2.68351845030850743d-19,0.d0, -2.47631006363911635d-18,0.d0,2.05560047903738218d-17,0.d0,&
  -1.54763876066192241d-16,0.d0,1.06410357358472536d-15,0.d0, -6.72076683598079057d-15,0.d0,3.91882394735691508d-14,0.d0,&
  -2.1187969775075261d-13,0.d0,1.06630135673478305d-12,0.d0, -5.01180443685748998d-12,0.d0,2.20666419683207691d-11,0.d0,&
  -9.1258654919835045d-11,0.d0,3.55352205999457932d-10,0.d0, -1.30569909741619005d-9,0.d0,4.53620646231137398d-9,0.d0,&
  -1.49279735540769725d-8,0.d0,4.66118357913015673d-8,0.d0, -1.38309751701521672d-7,0.d0,3.90568525175243503d-7,0.d0,&
  -1.05103157937523999d-6,0.d0,2.69873794098621337d-6,0.d0, -6.61998110310293365d-6,0.d0,0.0000155312721433740143d0,0.d0,&
  -0.0000348898934935080536d0,0.d0,0.0000751302114254144957d0,0.d0,&
  -0.000155250095336387829d0,0.d0,0.000308205854288494064d0,0.d0,&
  -0.000588508297900663563d0,0.d0,0.00108221904295030132d0,0.d0,&
  -0.00191926718143360074d0,0.d0,0.00328782888345707184d0,0.d0,&
  -0.00545087420152093489d0,0.d0,0.00876675750345045625d0,0.d0,&
  -0.0137206712673049998d0,0.d0,0.0209859998811194541d0,0.d0,&
  -0.031565718829452402d0,0.d0,0.0471537281279474153d0,0.d0, -0.0711699126403181485d0,0.d0,0.112357606764076737d0,0.d0,&
  -0.202867901101805219d0,0.d0,0.633444670787269357d0,1.d0,0.633444670787269357d0,&
   0.d0,-0.202867901101805219d0,0.d0,0.112357606764076737d0,0.d0,&
  -0.0711699126403181485d0,0.d0,0.0471537281279474153d0,0.d0,&
  -0.031565718829452402d0,0.d0,0.0209859998811194541d0,0.d0,&
  -0.0137206712673049998d0,0.d0,0.00876675750345045625d0,0.d0,&
  -0.00545087420152093489d0,0.d0,0.00328782888345707184d0,0.d0,&
  -0.00191926718143360074d0,0.d0,0.00108221904295030132d0,0.d0,&
  -0.000588508297900663563d0,0.d0,0.000308205854288494064d0,0.d0,&
  -0.000155250095336387829d0,0.d0,0.0000751302114254144957d0,0.d0,&
  -0.0000348898934935080536d0,0.d0,0.0000155312721433740143d0,0.d0,&
  -6.61998110310293365d-6,0.d0,2.69873794098621337d-6,0.d0, -1.05103157937523999d-6,0.d0,3.90568525175243503d-7,0.d0,&
  -1.38309751701521672d-7,0.d0,4.66118357913015673d-8,0.d0, -1.49279735540769725d-8,0.d0,4.53620646231137398d-9,0.d0,&
  -1.30569909741619005d-9,0.d0,3.55352205999457932d-10,0.d0, -9.1258654919835045d-11,0.d0,2.20666419683207691d-11,0.d0,&
  -5.01180443685748998d-12,0.d0,1.06630135673478305d-12,0.d0, -2.1187969775075261d-13,0.d0,3.91882394735691508d-14,0.d0,&
  -6.72076683598079057d-15,0.d0,1.06410357358472536d-15,0.d0, -1.54763876066192241d-16,0.d0,2.05560047903738218d-17,0.d0,&
  -2.47631006363911635d-18,0.d0,2.68351845030850743d-19,0.d0, -2.59007672484430282d-20,0.d0,2.19924673311587861d-21,0.d0,&
  -1.61729304931893186d-22,0.d0,1.00911662890805933d-23,0.d0, -5.19441179715542395d-25,0.d0,2.11779334023809847d-26,0.d0,&
  -6.41198417717232202d-28,0.d0,1.28158741180595538d-29,0.d0, -1.2683805626484815d-31, 0.d0, 0.d0, 0.d0   /)
real(kind=8), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0.d0
   cg(i)=0.d0
   cgt(i)=0.d0
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1.d0

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1.d0)**(i+1)
   cgt(i+1)=ch(-i)*(-1.d0)**(i+1)
enddo


