!{\src2tex{textfont=tt}}
!!****f* ABINIT/contstr25
!! NAME
!! contstr25
!!
!! FUNCTION
!! Carries out specialized metric tensor operations needed for contraction
!! of the 2nd strain derivative of the l=0,1,2,3 nonlocal Kleinman-Bylander
!! pseudopotential operation.  Derivatives are wrt a pair of cartesian
!! strain components.
!! Full advantage is taken of the full permutational symmetry of these
!! tensors.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2014 ABINIT group (DRH)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  istr1=1,...6 specifies cartesian strain component 11,22,33,32,31,21
!!  istr2=seccond strain component
!!  rank=angular momentum
!!  gm(3,3)=metric tensor (array is symmetric but stored as 3x3)
!!  gprimd(3,3)=reciprocal space dimensional primitive translations
!!  aa(2,*)=unique elements of complex right-hand tensor
!!  bb(2,*)=unique elements of complex left-hand tensor
!!
!! OUTPUT
!!  e2nl=contraction for nonlocal 2nd-order strain derivative energy
!!
!! NOTES
!! All tensors are stored in a compressed storage mode defined below;
!! input and output conform to this scheme.
!! When tensor elements occur repeatedly due to symmetry, the
!! WEIGHT IS INCLUDED in the output tensor element to simplify later
!! contractions with other tensors of the same rank and form, i.e. the
!! next contraction is then simply a dot product over the unique elements.
!!
!! PARENTS
!!      nonlop_pl
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine contstr25(istr1,istr2,rank,gm,gprimd,e2nl,aa,bb)

 use m_profiling_abi

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'contstr25'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: istr1,istr2,rank
 real(dp),intent(out) :: e2nl
!arrays
 real(dp),intent(in) :: aa(2,((rank+3)*(rank+4))/2),bb(2,((rank+3)*(rank+4))/2)
 real(dp),intent(in) :: gm(3,3),gprimd(3,3)

!Local variables-------------------------------
!scalars
 integer,parameter :: mrank=3
 integer :: ii,jj,ka,kb,kd,kg
!arrays
 integer,save :: idx(12)=(/1,1,2,2,3,3,3,2,3,1,2,1/)
 real(dp) :: d2gm(3,3),dgm01(3,3),dgm10(3,3),tmp(2)
 real(dp),allocatable :: cm(:,:)

! *************************************************************************
 ABI_ALLOCATE(cm,(((mrank+3)*(mrank+4))/2,((mrank+3)*(mrank+4))/2))

 ka=idx(2*istr1-1);kb=idx(2*istr1);kg=idx(2*istr2-1);kd=idx(2*istr2)

 do ii = 1,3
   dgm01(:,ii)=-(gprimd(ka,:)*gprimd(kb,ii)+gprimd(kb,:)*gprimd(ka,ii))
   dgm10(:,ii)=-(gprimd(kg,:)*gprimd(kd,ii)+gprimd(kd,:)*gprimd(kg,ii))
 end do

 d2gm(:,:)=0.d0
 do ii = 1,3
   if(ka==kg) d2gm(:,ii)=d2gm(:,ii)&
&   +gprimd(kb,:)*gprimd(kd,ii)+gprimd(kd,:)*gprimd(kb,ii)
   if(ka==kd) d2gm(:,ii)=d2gm(:,ii)&
&   +gprimd(kb,:)*gprimd(kg,ii)+gprimd(kg,:)*gprimd(kb,ii)
   if(kb==kg) d2gm(:,ii)=d2gm(:,ii)&
&   +gprimd(ka,:)*gprimd(kd,ii)+gprimd(kd,:)*gprimd(ka,ii)
   if(kb==kd) d2gm(:,ii)=d2gm(:,ii)&
&   +gprimd(ka,:)*gprimd(kg,ii)+gprimd(kg,:)*gprimd(ka,ii)
 end do
 d2gm(:,:)=0.5d0*d2gm(:,:)

!
!The code below was written by a Mathematica program and formatted by
!a combination of editing scripts.  It is not intended to be read
!by human beings, and certainly not to be modified by one.  Conceivably
!it could be shortened somewhat by identifying common subexpressions.
!

 if(rank==0)then
   cm(1,1)=2*dgm01(1,1)*dgm10(1,1)
   cm(2,1)=dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2)
   cm(3,1)=dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)
   cm(4,1)=2*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))
   cm(5,1)=2*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))
   cm(6,1)=2*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))
   cm(1,2)=dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2)
   cm(2,2)=2*dgm01(2,2)*dgm10(2,2)
   cm(3,2)=dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)
   cm(4,2)=2*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))
   cm(5,2)=2*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))
   cm(6,2)=2*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))
   cm(1,3)=dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)
   cm(2,3)=dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)
   cm(3,3)=2*dgm01(3,3)*dgm10(3,3)
   cm(4,3)=2*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3))
   cm(5,3)=2*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))
   cm(6,3)=2*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))
   cm(1,4)=2*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))
   cm(2,4)=2*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))
   cm(3,4)=2*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3))
   cm(4,4)=8*dgm01(2,3)*dgm10(2,3)
   cm(5,4)=4*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))
   cm(6,4)=4*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))
   cm(1,5)=2*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))
   cm(2,5)=2*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))
   cm(3,5)=2*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))
   cm(4,5)=4*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))
   cm(5,5)=8*dgm01(1,3)*dgm10(1,3)
   cm(6,5)=4*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))
   cm(1,6)=2*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))
   cm(2,6)=2*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))
   cm(3,6)=2*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))
   cm(4,6)=4*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))
   cm(5,6)=4*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))
   cm(6,6)=8*dgm01(1,2)*dgm10(1,2)
 elseif(rank==1)then
   cm(1,1)=2*gm(1,1)*dgm01(1,1)*dgm10(1,1)
   cm(2,1)=2*gm(1,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,1)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))
   cm(3,1)=2*gm(1,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(1,1)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))
   cm(4,1)=2*(gm(1,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,2)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+gm(1,1)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3)))
   cm(5,1)=2*(gm(1,3)*dgm01(1,1)*dgm10(1,1)+gm(1,1)*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3)))
   cm(6,1)=2*(gm(1,2)*dgm01(1,1)*dgm10(1,1)+gm(1,1)*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2)))
   cm(7,1)=gm(1,2)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))
   cm(8,1)=2*gm(1,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +gm(1,2)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))
   cm(9,1)=gm(1,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*gm(1,2)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))
   cm(10,1)=gm(1,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))
   cm(1,2)=2*gm(1,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,1)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))
   cm(2,2)=2*(4*gm(2,2)*dgm01(1,2)*dgm10(1,2)+gm(1,1)*dgm01(2,2)&
&   *dgm10(2,2)+2*gm(1,2)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(3,2)=2*gm(1,3)*dgm01(2,2)*dgm10(1,3)+4*gm(2,3)*(dgm01(1,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+2*gm(1,3)*dgm01(1,3)*dgm10(2,2)&
&   +gm(1,1)*dgm01(3,3)*dgm10(2,2)+gm(1,1)*dgm01(2,2)*dgm10(3,3)&
&   +2*gm(1,2)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))
   cm(4,2)=2*(4*gm(2,3)*dgm01(1,2)*dgm10(1,2)+gm(1,3)*dgm01(2,2)&
&   *dgm10(1,2)+2*gm(1,2)*dgm01(2,3)*dgm10(1,2)+gm(1,2)*dgm01(2,2)&
&   *dgm10(1,3)+2*gm(2,2)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +gm(1,3)*dgm01(1,2)*dgm10(2,2)+gm(1,2)*dgm01(1,3)*dgm10(2,2)&
&   +gm(1,1)*dgm01(2,3)*dgm10(2,2)+2*gm(1,2)*dgm01(1,2)*dgm10(2,3)&
&   +gm(1,1)*dgm01(2,2)*dgm10(2,3))
   cm(5,2)=2*gm(2,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+2*(2*gm(1,2)&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+gm(1,1)*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2)))
   cm(6,2)=2*gm(2,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,2)*(dgm01(2,2)*dgm10(1,1)+8*dgm01(1,2)*dgm10(1,2)+dgm01(1,1)&
&   *dgm10(2,2))+2*gm(1,1)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))
   cm(7,2)=2*(gm(1,2)*dgm01(2,2)*dgm10(2,2)+gm(2,2)*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(8,2)=2*gm(1,3)*dgm01(2,3)*dgm10(2,2)+gm(1,2)*dgm01(3,3)*dgm10(2,2)&
&   +2*gm(1,3)*dgm01(2,2)*dgm10(2,3)+4*gm(2,3)*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+gm(1,2)*dgm01(2,2)*dgm10(3,3)+2*gm(2,2)&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))
   cm(9,2)=2*(gm(1,3)*dgm01(2,2)*dgm10(2,2)+gm(1,2)*dgm01(2,3)&
&   *dgm10(2,2)+gm(2,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +gm(1,2)*dgm01(2,2)*dgm10(2,3)+2*gm(2,2)*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3)))
   cm(10,2)=2*gm(2,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +gm(1,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))
   cm(1,3)=2*gm(1,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(1,1)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))
   cm(2,3)=2*gm(1,3)*dgm01(2,2)*dgm10(1,3)+4*gm(2,3)*(dgm01(1,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+2*gm(1,3)*dgm01(1,3)*dgm10(2,2)&
&   +gm(1,1)*dgm01(3,3)*dgm10(2,2)+gm(1,1)*dgm01(2,2)*dgm10(3,3)&
&   +2*gm(1,2)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))
   cm(3,3)=2*(4*gm(3,3)*dgm01(1,3)*dgm10(1,3)+gm(1,1)*dgm01(3,3)&
&   *dgm10(3,3)+2*gm(1,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(4,3)=2*(4*gm(2,3)*dgm01(1,3)*dgm10(1,3)+gm(1,2)*dgm01(3,3)&
&   *dgm10(1,3)+2*gm(3,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +gm(1,1)*dgm01(3,3)*dgm10(2,3)+gm(1,2)*dgm01(1,3)*dgm10(3,3)&
&   +gm(1,1)*dgm01(2,3)*dgm10(3,3)+gm(1,3)*(dgm01(3,3)*dgm10(1,2)&
&   +2*dgm01(2,3)*dgm10(1,3)+2*dgm01(1,3)*dgm10(2,3)+dgm01(1,2)*dgm10(3,3)))
   cm(5,3)=2*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(1,3)*(dgm01(3,3)*dgm10(1,1)+8*dgm01(1,3)*dgm10(1,3)+dgm01(1,1)&
&   *dgm10(3,3))+2*gm(1,1)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))
   cm(6,3)=2*gm(2,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(1,2)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+2*(2*gm(1,3)&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+gm(1,1)*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))
   cm(7,3)=2*gm(2,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +gm(1,2)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))
   cm(8,3)=2*(gm(1,3)*dgm01(3,3)*dgm10(2,3)+2*gm(3,3)*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+gm(1,3)*dgm01(2,3)*dgm10(3,3)&
&   +gm(1,2)*dgm01(3,3)*dgm10(3,3)+gm(2,3)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3)))
   cm(9,3)=gm(1,3)*dgm01(3,3)*dgm10(2,2)+2*gm(3,3)*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+2*gm(1,2)*dgm01(3,3)*dgm10(2,3)&
&   +4*gm(2,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+gm(1,3)&
&   *dgm01(2,2)*dgm10(3,3)+2*gm(1,2)*dgm01(2,3)*dgm10(3,3)
   cm(10,3)=2*(gm(1,3)*dgm01(3,3)*dgm10(3,3)+gm(3,3)*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(1,4)=2*(gm(1,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,2)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+gm(1,1)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3)))
   cm(2,4)=2*(4*gm(2,3)*dgm01(1,2)*dgm10(1,2)+gm(1,3)*dgm01(2,2)&
&   *dgm10(1,2)+2*gm(1,2)*dgm01(2,3)*dgm10(1,2)+gm(1,2)*dgm01(2,2)&
&   *dgm10(1,3)+2*gm(2,2)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +gm(1,3)*dgm01(1,2)*dgm10(2,2)+gm(1,2)*dgm01(1,3)*dgm10(2,2)&
&   +gm(1,1)*dgm01(2,3)*dgm10(2,2)+2*gm(1,2)*dgm01(1,2)*dgm10(2,3)&
&   +gm(1,1)*dgm01(2,2)*dgm10(2,3))
   cm(3,4)=2*(4*gm(2,3)*dgm01(1,3)*dgm10(1,3)+gm(1,2)*dgm01(3,3)&
&   *dgm10(1,3)+2*gm(3,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +gm(1,1)*dgm01(3,3)*dgm10(2,3)+gm(1,2)*dgm01(1,3)*dgm10(3,3)&
&   +gm(1,1)*dgm01(2,3)*dgm10(3,3)+gm(1,3)*(dgm01(3,3)*dgm10(1,2)&
&   +2*dgm01(2,3)*dgm10(1,3)+2*dgm01(1,3)*dgm10(2,3)+dgm01(1,2)*dgm10(3,3)))
   cm(4,4)=8*(gm(3,3)*dgm01(1,2)*dgm10(1,2)+gm(1,3)*dgm01(2,3)&
&   *dgm10(1,2)+gm(2,2)*dgm01(1,3)*dgm10(1,3)+gm(1,2)*dgm01(2,3)&
&   *dgm10(1,3)+gm(2,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +gm(1,3)*dgm01(1,2)*dgm10(2,3)+gm(1,2)*dgm01(1,3)*dgm10(2,3)&
&   +gm(1,1)*dgm01(2,3)*dgm10(2,3))
   cm(5,4)=2*(gm(1,3)*dgm01(2,3)*dgm10(1,1)+2*gm(1,3)*dgm01(1,3)&
&   *dgm10(1,2)+gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +2*gm(1,3)*dgm01(1,2)*dgm10(1,3)+4*gm(1,2)*dgm01(1,3)*dgm10(1,3)&
&   +2*gm(1,1)*dgm01(2,3)*dgm10(1,3)+gm(2,3)*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+gm(1,3)*dgm01(1,1)*dgm10(2,3)+2*gm(1,1)&
&   *dgm01(1,3)*dgm10(2,3))
   cm(6,4)=2*(gm(1,2)*dgm01(2,3)*dgm10(1,1)+4*gm(1,3)*dgm01(1,2)&
&   *dgm10(1,2)+2*gm(1,2)*dgm01(1,3)*dgm10(1,2)+2*gm(1,1)*dgm01(2,3)&
&   *dgm10(1,2)+gm(2,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +2*gm(1,2)*dgm01(1,2)*dgm10(1,3)+gm(2,2)*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+gm(1,2)*dgm01(1,1)*dgm10(2,3)+2*gm(1,1)&
&   *dgm01(1,2)*dgm10(2,3))
   cm(7,4)=2*(gm(2,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +gm(2,2)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+gm(1,2)&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))
   cm(8,4)=2*(gm(2,2)*dgm01(3,3)*dgm10(1,3)+4*gm(1,3)*dgm01(2,3)&
&   *dgm10(2,3)+gm(1,2)*dgm01(3,3)*dgm10(2,3)+2*gm(3,3)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+gm(2,2)*dgm01(1,3)*dgm10(3,3)&
&   +gm(1,2)*dgm01(2,3)*dgm10(3,3)+gm(2,3)*(dgm01(3,3)*dgm10(1,2)&
&   +2*dgm01(2,3)*dgm10(1,3)+2*dgm01(1,3)*dgm10(2,3)+dgm01(1,2)*dgm10(3,3)))
   cm(9,4)=2*(2*gm(2,2)*dgm01(2,3)*dgm10(1,3)+gm(1,3)*dgm01(2,3)&
&   *dgm10(2,2)+gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +2*gm(2,2)*dgm01(1,3)*dgm10(2,3)+gm(1,3)*dgm01(2,2)*dgm10(2,3)&
&   +4*gm(1,2)*dgm01(2,3)*dgm10(2,3)+gm(2,3)*(2*dgm01(2,3)*dgm10(1,2)&
&   +dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2)+2*dgm01(1,2)*dgm10(2,3)))
   cm(10,4)=2*(gm(3,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +gm(2,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+gm(1,3)&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(1,5)=2*(gm(1,3)*dgm01(1,1)*dgm10(1,1)+gm(1,1)*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3)))
   cm(2,5)=2*gm(2,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+2*(2*gm(1,2)&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+gm(1,1)*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2)))
   cm(3,5)=2*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(1,3)*(dgm01(3,3)*dgm10(1,1)+8*dgm01(1,3)*dgm10(1,3)+dgm01(1,1)&
&   *dgm10(3,3))+2*gm(1,1)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))
   cm(4,5)=2*(gm(1,3)*dgm01(2,3)*dgm10(1,1)+2*gm(1,3)*dgm01(1,3)&
&   *dgm10(1,2)+gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +2*gm(1,3)*dgm01(1,2)*dgm10(1,3)+4*gm(1,2)*dgm01(1,3)*dgm10(1,3)&
&   +2*gm(1,1)*dgm01(2,3)*dgm10(1,3)+gm(2,3)*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+gm(1,3)*dgm01(1,1)*dgm10(2,3)+2*gm(1,1)&
&   *dgm01(1,3)*dgm10(2,3))
   cm(5,5)=2*(gm(3,3)*dgm01(1,1)*dgm10(1,1)+2*(2*gm(1,1)*dgm01(1,3)&
&   *dgm10(1,3)+gm(1,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))))
   cm(6,5)=2*(gm(2,3)*dgm01(1,1)*dgm10(1,1)+gm(1,2)*dgm01(1,3)&
&   *dgm10(1,1)+2*gm(1,1)*dgm01(1,3)*dgm10(1,2)+gm(1,3)*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+gm(1,2)*dgm01(1,1)*dgm10(1,3)&
&   +2*gm(1,1)*dgm01(1,2)*dgm10(1,3))
   cm(7,5)=gm(2,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*gm(1,2)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))
   cm(8,5)=2*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +gm(2,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+2*(2*gm(1,3)&
&   *(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+gm(1,2)*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(9,5)=gm(3,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*(gm(1,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+gm(2,3)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+2*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3)))
   cm(10,5)=gm(3,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +2*gm(1,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))
   cm(1,6)=2*(gm(1,2)*dgm01(1,1)*dgm10(1,1)+gm(1,1)*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2)))
   cm(2,6)=2*gm(2,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,2)*(dgm01(2,2)*dgm10(1,1)+8*dgm01(1,2)*dgm10(1,2)+dgm01(1,1)&
&   *dgm10(2,2))+2*gm(1,1)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))
   cm(3,6)=2*gm(2,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(1,2)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+2*(2*gm(1,3)&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+gm(1,1)*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))
   cm(4,6)=2*(gm(1,2)*dgm01(2,3)*dgm10(1,1)+4*gm(1,3)*dgm01(1,2)&
&   *dgm10(1,2)+2*gm(1,2)*dgm01(1,3)*dgm10(1,2)+2*gm(1,1)*dgm01(2,3)&
&   *dgm10(1,2)+gm(2,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +2*gm(1,2)*dgm01(1,2)*dgm10(1,3)+gm(2,2)*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+gm(1,2)*dgm01(1,1)*dgm10(2,3)+2*gm(1,1)&
&   *dgm01(1,2)*dgm10(2,3))
   cm(5,6)=2*(gm(2,3)*dgm01(1,1)*dgm10(1,1)+gm(1,2)*dgm01(1,3)&
&   *dgm10(1,1)+2*gm(1,1)*dgm01(1,3)*dgm10(1,2)+gm(1,3)*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+gm(1,2)*dgm01(1,1)*dgm10(1,3)&
&   +2*gm(1,1)*dgm01(1,2)*dgm10(1,3))
   cm(6,6)=2*(gm(2,2)*dgm01(1,1)*dgm10(1,1)+2*(2*gm(1,1)*dgm01(1,2)&
&   *dgm10(1,2)+gm(1,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))))
   cm(7,6)=gm(2,2)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*gm(1,2)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))
   cm(8,6)=2*gm(2,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +gm(2,2)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+2*(2*gm(1,3)&
&   *(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+gm(1,2)*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))
   cm(9,6)=gm(2,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*(gm(1,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+gm(2,2)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+2*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3)))
   cm(10,6)=gm(2,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +2*gm(1,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))
   cm(1,7)=gm(1,2)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))
   cm(2,7)=2*(gm(1,2)*dgm01(2,2)*dgm10(2,2)+gm(2,2)*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(3,7)=2*gm(2,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +gm(1,2)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))
   cm(4,7)=2*(gm(2,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +gm(2,2)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+gm(1,2)&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))
   cm(5,7)=gm(2,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*gm(1,2)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))
   cm(6,7)=gm(2,2)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*gm(1,2)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))
   cm(7,7)=2*gm(2,2)*dgm01(2,2)*dgm10(2,2)
   cm(8,7)=2*gm(2,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +gm(2,2)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))
   cm(9,7)=2*(gm(2,3)*dgm01(2,2)*dgm10(2,2)+gm(2,2)*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))
   cm(10,7)=gm(2,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))
   cm(1,8)=2*gm(1,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +gm(1,2)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))
   cm(2,8)=2*gm(1,3)*dgm01(2,3)*dgm10(2,2)+gm(1,2)*dgm01(3,3)*dgm10(2,2)&
&   +2*gm(1,3)*dgm01(2,2)*dgm10(2,3)+4*gm(2,3)*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+gm(1,2)*dgm01(2,2)*dgm10(3,3)+2*gm(2,2)&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))
   cm(3,8)=2*(gm(1,3)*dgm01(3,3)*dgm10(2,3)+2*gm(3,3)*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+gm(1,3)*dgm01(2,3)*dgm10(3,3)&
&   +gm(1,2)*dgm01(3,3)*dgm10(3,3)+gm(2,3)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3)))
   cm(4,8)=2*(gm(2,2)*dgm01(3,3)*dgm10(1,3)+4*gm(1,3)*dgm01(2,3)&
&   *dgm10(2,3)+gm(1,2)*dgm01(3,3)*dgm10(2,3)+2*gm(3,3)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+gm(2,2)*dgm01(1,3)*dgm10(3,3)&
&   +gm(1,2)*dgm01(2,3)*dgm10(3,3)+gm(2,3)*(dgm01(3,3)*dgm10(1,2)&
&   +2*dgm01(2,3)*dgm10(1,3)+2*dgm01(1,3)*dgm10(2,3)+dgm01(1,2)*dgm10(3,3)))
   cm(5,8)=2*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +gm(2,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+2*(2*gm(1,3)&
&   *(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+gm(1,2)*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(6,8)=2*gm(2,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +gm(2,2)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+2*(2*gm(1,3)&
&   *(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+gm(1,2)*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))
   cm(7,8)=2*gm(2,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +gm(2,2)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))
   cm(8,8)=2*(4*gm(3,3)*dgm01(2,3)*dgm10(2,3)+gm(2,2)*dgm01(3,3)&
&   *dgm10(3,3)+2*gm(2,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(9,8)=2*gm(3,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +gm(2,3)*(dgm01(3,3)*dgm10(2,2)+8*dgm01(2,3)*dgm10(2,3)+dgm01(2,2)&
&   *dgm10(3,3))+2*gm(2,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3))
   cm(10,8)=2*(gm(2,3)*dgm01(3,3)*dgm10(3,3)+gm(3,3)*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(1,9)=gm(1,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*gm(1,2)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))
   cm(2,9)=2*(gm(1,3)*dgm01(2,2)*dgm10(2,2)+gm(1,2)*dgm01(2,3)&
&   *dgm10(2,2)+gm(2,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +gm(1,2)*dgm01(2,2)*dgm10(2,3)+2*gm(2,2)*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3)))
   cm(3,9)=gm(1,3)*dgm01(3,3)*dgm10(2,2)+2*gm(3,3)*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+2*gm(1,2)*dgm01(3,3)*dgm10(2,3)&
&   +4*gm(2,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+gm(1,3)&
&   *dgm01(2,2)*dgm10(3,3)+2*gm(1,2)*dgm01(2,3)*dgm10(3,3)
   cm(4,9)=2*(2*gm(2,2)*dgm01(2,3)*dgm10(1,3)+gm(1,3)*dgm01(2,3)&
&   *dgm10(2,2)+gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +2*gm(2,2)*dgm01(1,3)*dgm10(2,3)+gm(1,3)*dgm01(2,2)*dgm10(2,3)&
&   +4*gm(1,2)*dgm01(2,3)*dgm10(2,3)+gm(2,3)*(2*dgm01(2,3)*dgm10(1,2)&
&   +dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2)+2*dgm01(1,2)*dgm10(2,3)))
   cm(5,9)=gm(3,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*(gm(1,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+gm(2,3)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+2*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3)))
   cm(6,9)=gm(2,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +2*(gm(1,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+gm(2,2)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+2*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3)))
   cm(7,9)=2*(gm(2,3)*dgm01(2,2)*dgm10(2,2)+gm(2,2)*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))
   cm(8,9)=2*gm(3,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +gm(2,3)*(dgm01(3,3)*dgm10(2,2)+8*dgm01(2,3)*dgm10(2,3)+dgm01(2,2)&
&   *dgm10(3,3))+2*gm(2,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3))
   cm(9,9)=2*(gm(3,3)*dgm01(2,2)*dgm10(2,2)+2*(2*gm(2,2)*dgm01(2,3)&
&   *dgm10(2,3)+gm(2,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))))
   cm(10,9)=gm(3,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))&
&   +2*gm(2,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3))
   cm(1,10)=gm(1,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))
   cm(2,10)=2*gm(2,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +gm(1,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))
   cm(3,10)=2*(gm(1,3)*dgm01(3,3)*dgm10(3,3)+gm(3,3)*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(4,10)=2*(gm(3,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +gm(2,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+gm(1,3)&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(5,10)=gm(3,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +2*gm(1,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))
   cm(6,10)=gm(2,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +2*gm(1,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))
   cm(7,10)=gm(2,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))
   cm(8,10)=2*(gm(2,3)*dgm01(3,3)*dgm10(3,3)+gm(3,3)*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(9,10)=gm(3,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))&
&   +2*gm(2,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3))
   cm(10,10)=2*gm(3,3)*dgm01(3,3)*dgm10(3,3)
 elseif(rank==2)then
   cm(1,1)=2*gm(1,1)**2*dgm01(1,1)*dgm10(1,1)
   cm(2,1)=(48*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(1,1)*dgm10(1,1)&
&   +384*gm(1,1)*gm(1,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +96*gm(1,1)**2*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2)))&
&   /96.d0
   cm(3,1)=(48*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(1,1)*dgm10(1,1)&
&   +384*gm(1,1)*gm(1,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +96*gm(1,1)**2*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)))&
&   /96.d0
   cm(4,1)=(48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(1,1)&
&   *dgm10(1,1)+192*gm(1,1)*gm(1,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+192*gm(1,1)*gm(1,2)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,3))+96*gm(1,1)**2*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,3)))/48.d0
   cm(5,1)=gm(1,1)*(4*gm(1,3)*dgm01(1,1)*dgm10(1,1)+2*gm(1,1)*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3)))
   cm(6,1)=gm(1,1)*(4*gm(1,2)*dgm01(1,1)*dgm10(1,1)+2*gm(1,1)*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2)))
   cm(7,1)=(72*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+288*gm(1,1)*gm(1,2)*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2)))/144.d0
   cm(8,1)=(24*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+192*gm(1,1)*gm(1,3)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+96*gm(1,1)*gm(1,2)&
&   *(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)))/48.d0
   cm(9,1)=(48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+24*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+96*gm(1,1)&
&   *gm(1,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+192*gm(1,1)&
&   *gm(1,2)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3)))/48.d0
   cm(10,1)=(72*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+288*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3)))/144.d0
   cm(11,1)=((6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2)))/4.d0
   cm(12,1)=((6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)))/4.d0
   cm(13,1)=(4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+4*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3)))/8.d0
   cm(14,1)=(4*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,3))+4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)))/8.d0
   cm(15,1)=((6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3)))/4.d0
   cm(1,2)=(48*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(1,1)*dgm10(1,1)&
&   +384*gm(1,1)*gm(1,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +96*gm(1,1)**2*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2)))&
&   /96.d0
   cm(2,2)=(32*gm(2,2)**2*dgm01(1,1)*dgm10(1,1)+128*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*dgm01(1,2)*dgm10(1,2)+128*gm(1,2)*gm(2,2)&
&   *(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+32*gm(1,1)**2*dgm01(2,2)&
&   *dgm10(2,2)+8*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+128*gm(1,1)*gm(1,2)*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2)))/16.d0
   cm(3,2)=(8*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(1,1)*dgm10(1,1)&
&   +16*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+16*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+64*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+4*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+64*gm(1,1)*gm(1,3)*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+64*gm(1,1)*gm(1,2)*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+16*gm(1,1)**2*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/16.d0
   cm(4,2)=(32*gm(2,2)*gm(2,3)*dgm01(1,1)*dgm10(1,1)+64*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*dgm01(1,2)*dgm10(1,2)+16*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +8*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+32*gm(1,2)*gm(2,2)*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+32*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(1,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)&
&   *gm(2,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+32*gm(1,1)&
&   *gm(1,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+32*gm(1,1)&
&   *gm(1,2)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+4*(6*gm(1,2)&
&   **2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +64*gm(1,1)*gm(1,2)*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +16*gm(1,1)**2*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))&
&   /8.d0
   cm(5,2)=(24*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(1,1)&
&   *dgm10(1,1)+48*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+192*gm(1,1)&
&   *gm(1,2)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+48*gm(1,1)&
&   *gm(1,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+48*gm(1,1)&
&   **2*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2)))/24.d0
   cm(6,2)=5*gm(1,2)**2*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,2)*(4*gm(2,2)*dgm01(1,1)*dgm10(1,1)+gm(1,1)*(2*dgm01(2,2)&
&   *dgm10(1,1)+16*dgm01(1,2)*dgm10(1,2)+2*dgm01(1,1)*dgm10(2,2)))&
&   +gm(1,1)*(5*gm(2,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +2*gm(1,1)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(7,2)=2*gm(2,2)**2*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(2,2)*(gm(1,2)*(2*dgm01(2,2)*dgm10(1,1)+16*dgm01(1,2)*dgm10(1,2)&
&   +2*dgm01(1,1)*dgm10(2,2))+5*gm(1,1)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2)))+gm(1,2)*(4*gm(1,1)*dgm01(2,2)*dgm10(2,2)+5*gm(1,2)&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(8,2)=(32*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(1,2)&
&   *dgm10(1,2)+4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+32*gm(2,2)*gm(2,3)*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+32*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+8*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2))+8*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+32*(1*gm(1,2)*gm(1,3)+3*gm(1,1)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+32*gm(1,1)&
&   *gm(1,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+16*gm(1,2)&
&   *gm(2,2)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+16*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +16*gm(1,1)*gm(1,2)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))&
&   /8.d0
   cm(9,2)=(64*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*dgm01(1,2)*dgm10(1,2)&
&   +32*gm(2,2)*gm(2,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +16*gm(2,2)**2*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +64*gm(1,2)*gm(2,2)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +32*gm(1,1)*gm(1,3)*dgm01(2,2)*dgm10(2,2)+4*(-2*gm(1,3)*gm(2,2)&
&   +6*gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+16*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+4*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+32*gm(1,2)&
&   *gm(2,2)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+32*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +32*gm(1,1)*gm(1,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))&
&   /8.d0
   cm(10,2)=(12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+12*(6*gm(1,3)&
&   **2-2*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +12*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+48*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+48*gm(1,1)*gm(1,3)&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/24.d0
   cm(11,2)=(48*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(2,2)*dgm10(2,2)&
&   +96*gm(2,2)**2*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +384*gm(1,2)*gm(2,2)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))&
&   /96.d0
   cm(12,2)=(8*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(2,2)*dgm10(2,2)&
&   +4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+16*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+64*gm(2,2)*gm(2,3)*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+64*(3*gm(1,3)*gm(2,2)+gm(1,2)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+16*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3))+16*gm(2,2)**2*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+64*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))+4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3)))/16.d0
   cm(13,2)=(24*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(2,2)&
&   *dgm10(2,2)+48*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+48*gm(2,2)**2*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+192*gm(1,2)*gm(2,2)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/24.d0
   cm(14,2)=(12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,3))+48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+12*(6*gm(1,3)&
&   **2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +48*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +48*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/24.d0
   cm(15,2)=((6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+4*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/4.d0
   cm(1,3)=(48*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(1,1)*dgm10(1,1)&
&   +384*gm(1,1)*gm(1,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +96*gm(1,1)**2*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)))&
&   /96.d0
   cm(2,3)=(8*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(1,1)*dgm10(1,1)&
&   +16*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+16*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+64*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+4*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+64*gm(1,1)*gm(1,3)*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+64*gm(1,1)*gm(1,2)*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+16*gm(1,1)**2*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/16.d0
   cm(3,3)=(32*gm(3,3)**2*dgm01(1,1)*dgm10(1,1)+128*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*dgm01(1,3)*dgm10(1,3)+128*gm(1,3)*gm(3,3)&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+32*gm(1,1)**2*dgm01(3,3)&
&   *dgm10(3,3)+8*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+128*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3)))/16.d0
   cm(4,3)=(32*gm(2,3)*gm(3,3)*dgm01(1,1)*dgm10(1,1)+32*gm(1,3)&
&   *gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+64*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*dgm01(1,3)*dgm10(1,3)+8*(6*gm(1,3)&
&   *gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,3))+16*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+32*(1*gm(1,3)**2+3*gm(1,1)&
&   *gm(3,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+4*(6*gm(1,3)&
&   **2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +64*gm(1,1)*gm(1,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))&
&   +4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+32*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+32*gm(1,1)*gm(1,2)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+16*gm(1,1)**2*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/8.d0
   cm(5,3)=5*gm(1,3)**2*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(1,3)*(4*gm(3,3)*dgm01(1,1)*dgm10(1,1)+gm(1,1)*(2*dgm01(3,3)&
&   *dgm10(1,1)+16*dgm01(1,3)*dgm10(1,3)+2*dgm01(1,1)*dgm10(3,3)))&
&   +gm(1,1)*(5*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +2*gm(1,1)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(6,3)=(24*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(1,1)&
&   *dgm10(1,1)+12*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+48*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+192*gm(1,1)*gm(1,3)&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+48*gm(1,1)*gm(1,2)&
&   *(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+48*gm(1,1)**2*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))/24.d0
   cm(7,3)=(12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+12*(6*gm(1,3)&
&   *gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+48*gm(1,1)&
&   *gm(1,2)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/24.d0
   cm(8,3)=(16*gm(3,3)**2*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +64*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(1,3)*dgm10(1,3)&
&   +32*gm(2,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +64*gm(1,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +32*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +32*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+32*gm(1,1)*gm(1,2)*dgm01(3,3)*dgm10(3,3)+4*(6*gm(1,3)&
&   *gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+4*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+16*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+32*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/8.d0
   cm(9,3)=(32*gm(2,3)*gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+32*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(1,3)&
&   *dgm10(1,3)+4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+32*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+16*gm(1,3)*gm(3,3)&
&   *(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+16*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,3))+32*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+8*(6*gm(1,2)*gm(1,3)&
&   -2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+16*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+32*gm(1,1)*gm(1,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/8.d0
   cm(10,3)=2*gm(3,3)**2*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(3,3)*(gm(1,3)*(2*dgm01(3,3)*dgm10(1,1)+16*dgm01(1,3)*dgm10(1,3)&
&   +2*dgm01(1,1)*dgm10(3,3))+5*gm(1,1)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3)))+gm(1,3)*(4*gm(1,1)*dgm01(3,3)*dgm10(3,3)+5*gm(1,3)&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(11,3)=((6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+4*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/4.d0
   cm(12,3)=(16*gm(3,3)**2*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +64*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +64*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +64*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+8*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(3,3)&
&   *dgm10(3,3)+4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+16*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+16*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/16.d0
   cm(13,3)=(48*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+12*(6*gm(2,3)**2-2*gm(2,2)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+48*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/24.d0
   cm(14,3)=(48*gm(3,3)**2*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +192*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))&
&   +24*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(3,3)*dgm10(3,3)&
&   +48*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +48*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+12*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/24.d0
   cm(15,3)=(48*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(3,3)*dgm10(3,3)&
&   +96*gm(3,3)**2*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +384*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))&
&   /96.d0
   cm(1,4)=(48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(1,1)&
&   *dgm10(1,1)+192*gm(1,1)*gm(1,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+192*gm(1,1)*gm(1,2)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,3))+96*gm(1,1)**2*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,3)))/48.d0
   cm(2,4)=(32*gm(2,2)*gm(2,3)*dgm01(1,1)*dgm10(1,1)+64*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*dgm01(1,2)*dgm10(1,2)+16*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +8*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+32*gm(1,2)*gm(2,2)*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+32*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(1,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)&
&   *gm(2,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+32*gm(1,1)&
&   *gm(1,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+32*gm(1,1)&
&   *gm(1,2)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+4*(6*gm(1,2)&
&   **2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +64*gm(1,1)*gm(1,2)*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +16*gm(1,1)**2*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))&
&   /8.d0
   cm(3,4)=(32*gm(2,3)*gm(3,3)*dgm01(1,1)*dgm10(1,1)+32*gm(1,3)&
&   *gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+64*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*dgm01(1,3)*dgm10(1,3)+8*(6*gm(1,3)&
&   *gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,3))+16*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+32*(1*gm(1,3)**2+3*gm(1,1)&
&   *gm(3,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+4*(6*gm(1,3)&
&   **2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +64*gm(1,1)*gm(1,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))&
&   +4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+32*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+32*gm(1,1)*gm(1,2)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+16*gm(1,1)**2*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/8.d0
   cm(4,4)=(8*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*dgm01(1,1)*dgm10(1,1)&
&   +32*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*dgm01(1,2)*dgm10(1,2)+16*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+32*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*dgm01(1,3)*dgm10(1,3)&
&   +16*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+32*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+32*gm(1,1)**2*dgm01(2,3)&
&   *dgm10(2,3)+8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+64*gm(1,1)*gm(1,3)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+64*gm(1,1)*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3)))/4.d0
   cm(5,4)=(24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(1,1)&
&   *dgm10(1,1)+24*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+192*gm(1,1)*gm(1,2)*dgm01(1,3)*dgm10(1,3)&
&   +12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+96*gm(1,1)*gm(1,3)&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+48*gm(1,1)*gm(1,3)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+48*gm(1,1)**2*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3)))/12.d0
   cm(6,4)=(24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*dgm01(1,1)*dgm10(1,1)&
&   +192*gm(1,1)*gm(1,3)*dgm01(1,2)*dgm10(1,2)+12*(6*gm(1,2)*gm(1,3)&
&   -2*gm(1,1)*gm(2,3))*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+24*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+96*gm(1,1)*gm(1,2)*(dgm01(1,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+48*gm(1,1)*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+48*gm(1,1)**2*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3)))/12.d0
   cm(7,4)=(48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(1,2)&
&   *dgm10(1,2)+48*gm(2,2)*gm(2,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+96*gm(1,2)*gm(2,2)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+12*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)&
&   *gm(2,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+24*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +12*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+48*gm(1,1)*gm(1,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3)))/12.d0
   cm(8,4)=(64*gm(1,3)*gm(3,3)*dgm01(1,2)*dgm10(1,2)+16*gm(2,3)&
&   *gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+32*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*dgm01(1,3)*dgm10(1,3)+8*(1*gm(2,3)&
&   **2+3*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(1,3))+16*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+64*gm(1,1)*gm(1,3)&
&   *dgm01(2,3)*dgm10(2,3)+8*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+16*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+16*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+4*(3*gm(1,3)*gm(2,2)&
&   +gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +8*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+8*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+16*gm(1,1)*gm(1,2)*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/4.d0
   cm(9,4)=(32*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(1,2)&
&   *dgm10(1,2)+8*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+64*gm(1,2)*gm(2,2)*dgm01(1,3)*dgm10(1,3)&
&   +16*gm(2,2)*gm(2,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +16*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(1,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(1,3))+8*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+4*(1*gm(1,3)*gm(2,3)&
&   +3*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +8*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+8*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+64*gm(1,1)*gm(1,2)*dgm01(2,3)&
&   *dgm10(2,3)+8*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+16*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+16*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+16*gm(1,1)*gm(1,3)*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/4.d0
   cm(10,4)=(48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(1,3)&
&   *dgm10(1,3)+48*gm(2,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,3))+96*gm(1,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+12*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+12*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+24*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+48*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(11,4)=(96*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+192*gm(1,2)*gm(2,2)*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+24*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/48.d0
   cm(12,4)=(16*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+32*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+32*(6*gm(1,2)*gm(1,3)-2*gm(1,1)&
&   *gm(2,3))*dgm01(2,3)*dgm10(2,3)+16*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+32*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+32*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+16*gm(2,2)&
&   *gm(2,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+8*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))+32*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/8.d0
   cm(13,4)=(12*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+24*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +24*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(2,3)*dgm10(2,3)+48*gm(2,2)&
&   *gm(2,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+24*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+96*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/12.d0
   cm(14,4)=(24*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(2,3)*dgm10(2,3)&
&   +48*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +96*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +24*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+12*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+24*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))&
&   +12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(15,4)=(96*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+192*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))+48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+24*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/48.d0
   cm(1,5)=gm(1,1)*(4*gm(1,3)*dgm01(1,1)*dgm10(1,1)+2*gm(1,1)*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3)))
   cm(2,5)=(24*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(1,1)&
&   *dgm10(1,1)+48*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+192*gm(1,1)&
&   *gm(1,2)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+48*gm(1,1)&
&   *gm(1,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+48*gm(1,1)&
&   **2*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2)))/24.d0
   cm(3,5)=5*gm(1,3)**2*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(1,3)*(4*gm(3,3)*dgm01(1,1)*dgm10(1,1)+gm(1,1)*(2*dgm01(3,3)&
&   *dgm10(1,1)+16*dgm01(1,3)*dgm10(1,3)+2*dgm01(1,1)*dgm10(3,3)))&
&   +gm(1,1)*(5*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +2*gm(1,1)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(4,5)=(24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(1,1)&
&   *dgm10(1,1)+24*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+192*gm(1,1)*gm(1,2)*dgm01(1,3)*dgm10(1,3)&
&   +12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+96*gm(1,1)*gm(1,3)&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+48*gm(1,1)*gm(1,3)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+48*gm(1,1)**2*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3)))/12.d0
   cm(5,5)=(72*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*dgm01(1,1)*dgm10(1,1)&
&   +288*gm(1,1)**2*dgm01(1,3)*dgm10(1,3)+288*gm(1,1)*gm(1,3)*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3)))/36.d0
   cm(6,5)=(72*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*dgm01(1,1)&
&   *dgm10(1,1)+144*gm(1,1)*gm(1,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+144*gm(1,1)*gm(1,2)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,3))+144*gm(1,1)**2*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3)))/36.d0
   cm(7,5)=(36*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+36*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+36*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+144*gm(1,1)*gm(1,2)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2)))/36.d0
   cm(8,5)=(48*gm(1,3)*gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(1,3)&
&   *dgm10(1,3)+24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+12*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+24*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +96*gm(1,1)*gm(1,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))&
&   +12*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+48*gm(1,1)*gm(1,2)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3)))/12.d0
   cm(9,5)=(24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+24*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*dgm01(1,3)*dgm10(1,3)+12*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)&
&   *gm(2,3))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+24*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+12*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+48*gm(1,1)*gm(1,3)*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+96*gm(1,1)&
&   *gm(1,2)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3)))/12.d0
   cm(10,5)=(72*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(1,3)*dgm10(1,3)&
&   +144*gm(1,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +36*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+144*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3)))/36.d0
   cm(11,5)=(4*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+4*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2)))/8.d0
   cm(12,5)=(48*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+12*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+48*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+48*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+12*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))/24.d0
   cm(13,5)=(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+(-2*gm(1,3)*gm(2,2)&
&   +6*gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))
   cm(14,5)=(144*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,3))+36*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+36*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+36*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3)))/36.d0
   cm(15,5)=(288*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+72*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))/144.d0
   cm(1,6)=gm(1,1)*(4*gm(1,2)*dgm01(1,1)*dgm10(1,1)+2*gm(1,1)*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2)))
   cm(2,6)=5*gm(1,2)**2*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(1,2)*(4*gm(2,2)*dgm01(1,1)*dgm10(1,1)+gm(1,1)*(2*dgm01(2,2)&
&   *dgm10(1,1)+16*dgm01(1,2)*dgm10(1,2)+2*dgm01(1,1)*dgm10(2,2)))&
&   +gm(1,1)*(5*gm(2,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +2*gm(1,1)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(3,6)=(24*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(1,1)&
&   *dgm10(1,1)+12*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+48*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+192*gm(1,1)*gm(1,3)&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+48*gm(1,1)*gm(1,2)&
&   *(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+48*gm(1,1)**2*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))/24.d0
   cm(4,6)=(24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*dgm01(1,1)*dgm10(1,1)&
&   +192*gm(1,1)*gm(1,3)*dgm01(1,2)*dgm10(1,2)+12*(6*gm(1,2)*gm(1,3)&
&   -2*gm(1,1)*gm(2,3))*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+24*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+96*gm(1,1)*gm(1,2)*(dgm01(1,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+48*gm(1,1)*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+48*gm(1,1)**2*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3)))/12.d0
   cm(5,6)=(72*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*dgm01(1,1)&
&   *dgm10(1,1)+144*gm(1,1)*gm(1,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+144*gm(1,1)*gm(1,2)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,3))+144*gm(1,1)**2*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3)))/36.d0
   cm(6,6)=(72*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*dgm01(1,1)*dgm10(1,1)&
&   +288*gm(1,1)**2*dgm01(1,2)*dgm10(1,2)+288*gm(1,1)*gm(1,2)*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2)))/36.d0
   cm(7,6)=(72*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(1,2)*dgm10(1,2)&
&   +144*gm(1,2)*gm(2,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +36*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+144*gm(1,1)*gm(1,2)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2)))/36.d0
   cm(8,6)=(24*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(1,2)*dgm10(1,2)&
&   +12*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+24*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+96*gm(1,1)*gm(1,3)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+12*(1*gm(1,2)**2+3*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+48*gm(1,1)&
&   *gm(1,2)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))/12.d0
   cm(9,6)=(48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(1,2)&
&   *dgm10(1,2)+24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+48*gm(1,2)*gm(2,2)*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+12*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*gm(1,1)*gm(1,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+24*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+96*gm(1,1)*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3)))/12.d0
   cm(10,6)=(36*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+36*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+36*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+144*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3)))/36.d0
   cm(11,6)=(288*gm(1,2)*gm(2,2)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+72*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))/144.d0
   cm(12,6)=(12*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+12*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+48*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+48*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+12*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))/24.d0
   cm(13,6)=(36*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+36*(6*gm(1,2)*gm(1,3)-2*gm(1,1)&
&   *gm(2,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+144*gm(1,2)&
&   *gm(2,2)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+36*(6*gm(1,2)&
&   **2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3)))&
&   /36.d0
   cm(14,6)=(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,3))+(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+(3*gm(1,3)*gm(2,2)+gm(1,2)&
&   *gm(2,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))
   cm(15,6)=(4*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))/8.d0
   cm(1,7)=(72*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+288*gm(1,1)*gm(1,2)*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2)))/144.d0
   cm(2,7)=2*gm(2,2)**2*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +gm(2,2)*(gm(1,2)*(2*dgm01(2,2)*dgm10(1,1)+16*dgm01(1,2)*dgm10(1,2)&
&   +2*dgm01(1,1)*dgm10(2,2))+5*gm(1,1)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2)))+gm(1,2)*(4*gm(1,1)*dgm01(2,2)*dgm10(2,2)+5*gm(1,2)&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(3,7)=(12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+12*(6*gm(1,3)&
&   *gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+48*gm(1,1)&
&   *gm(1,2)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/24.d0
   cm(4,7)=(48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(1,2)&
&   *dgm10(1,2)+48*gm(2,2)*gm(2,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+96*gm(1,2)*gm(2,2)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+12*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)&
&   *gm(2,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+24*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +12*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+48*gm(1,1)*gm(1,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3)))/12.d0
   cm(5,7)=(36*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+36*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+36*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+144*gm(1,1)*gm(1,2)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2)))/36.d0
   cm(6,7)=(72*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(1,2)*dgm10(1,2)&
&   +144*gm(1,2)*gm(2,2)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +36*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+144*gm(1,1)*gm(1,2)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2)))/36.d0
   cm(7,7)=(288*gm(2,2)**2*dgm01(1,2)*dgm10(1,2)+72*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*dgm01(2,2)*dgm10(2,2)+288*gm(1,2)*gm(2,2)&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))/36.d0
   cm(8,7)=(24*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(1,2)*dgm10(1,2)&
&   +96*gm(2,2)*gm(2,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +12*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+24*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+48*gm(1,2)*gm(2,2)*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+12*(1*gm(1,2)**2+3*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/12.d0
   cm(9,7)=(192*gm(2,2)*gm(2,3)*dgm01(1,2)*dgm10(1,2)+48*gm(2,2)&
&   **2*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+24*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*dgm01(2,2)*dgm10(2,2)+24*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +12*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+48*gm(1,2)*gm(2,2)*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+96*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+24*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/12.d0
   cm(10,7)=(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(1,3))+(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+(-2*gm(1,3)*gm(2,2)&
&   +6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3))
   cm(11,7)=gm(2,2)*(4*gm(1,2)*dgm01(2,2)*dgm10(2,2)+2*gm(2,2)&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(12,7)=(24*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(2,2)&
&   *dgm10(2,2)+12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+192*gm(2,2)*gm(2,3)*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+48*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+48*gm(2,2)**2*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+48*gm(1,2)*gm(2,2)*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/24.d0
   cm(13,7)=(72*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*dgm01(2,2)&
&   *dgm10(2,2)+144*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+144*gm(2,2)**2*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+144*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3)))/36.d0
   cm(14,7)=(36*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+36*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+144*gm(2,2)*gm(2,3)&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+36*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))&
&   /36.d0
   cm(15,7)=(4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+4*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/8.d0
   cm(1,8)=(24*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+192*gm(1,1)*gm(1,3)&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+96*gm(1,1)*gm(1,2)&
&   *(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)))/48.d0
   cm(2,8)=(32*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(1,2)&
&   *dgm10(1,2)+4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+32*gm(2,2)*gm(2,3)*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+32*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+8*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2))+8*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+32*(1*gm(1,2)*gm(1,3)+3*gm(1,1)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+32*gm(1,1)&
&   *gm(1,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+16*gm(1,2)&
&   *gm(2,2)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+16*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +16*gm(1,1)*gm(1,2)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))&
&   /8.d0
   cm(3,8)=(16*gm(3,3)**2*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +64*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(1,3)*dgm10(1,3)&
&   +32*gm(2,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +64*gm(1,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +32*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +32*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+32*gm(1,1)*gm(1,2)*dgm01(3,3)*dgm10(3,3)+4*(6*gm(1,3)&
&   *gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+4*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+16*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+32*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/8.d0
   cm(4,8)=(64*gm(1,3)*gm(3,3)*dgm01(1,2)*dgm10(1,2)+16*gm(2,3)&
&   *gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+32*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*dgm01(1,3)*dgm10(1,3)+8*(1*gm(2,3)&
&   **2+3*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(1,3))+16*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+64*gm(1,1)*gm(1,3)&
&   *dgm01(2,3)*dgm10(2,3)+8*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+16*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+16*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+4*(3*gm(1,3)*gm(2,2)&
&   +gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +8*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+8*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+16*gm(1,1)*gm(1,2)*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/4.d0
   cm(5,8)=(48*gm(1,3)*gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(1,3)&
&   *dgm10(1,3)+24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+12*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+24*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +96*gm(1,1)*gm(1,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))&
&   +12*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+48*gm(1,1)*gm(1,2)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3)))/12.d0
   cm(6,8)=(24*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(1,2)*dgm10(1,2)&
&   +12*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+24*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+96*gm(1,1)*gm(1,3)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+12*(1*gm(1,2)**2+3*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+48*gm(1,1)&
&   *gm(1,2)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))/12.d0
   cm(7,8)=(24*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(1,2)*dgm10(1,2)&
&   +96*gm(2,2)*gm(2,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +12*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+24*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+48*gm(1,2)*gm(2,2)*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+12*(1*gm(1,2)**2+3*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/12.d0
   cm(8,8)=(32*gm(3,3)**2*dgm01(1,2)*dgm10(1,2)+32*(1*gm(2,3)**2+3*gm(2,2)&
&   *gm(3,3))*dgm01(1,3)*dgm10(1,3)+64*gm(2,3)*gm(3,3)*(dgm01(1,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+32*(1*gm(1,3)**2+3*gm(1,1)&
&   *gm(3,3))*dgm01(2,3)*dgm10(2,3)+64*gm(1,3)*gm(3,3)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+32*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+8*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*dgm01(3,3)*dgm10(3,3)+8*(6*gm(1,3)*gm(2,3)&
&   -2*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +16*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+16*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/4.d0
   cm(9,8)=(64*gm(2,3)*gm(3,3)*dgm01(1,2)*dgm10(1,2)+64*gm(2,2)&
&   *gm(2,3)*dgm01(1,3)*dgm10(1,3)+4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+16*(1*gm(2,3)&
&   **2+3*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +16*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +8*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+32*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *dgm01(2,3)*dgm10(2,3)+8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+16*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+16*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+8*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+8*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +8*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+16*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+4*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+8*(1*gm(1,2)**2+3*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/4.d0
   cm(10,8)=(48*gm(3,3)**2*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +72*gm(1,1)*gm(2,3)*dgm01(3,3)*dgm10(3,3)+24*gm(1,3)**2*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3))+gm(3,3)*(192*gm(2,3)*dgm01(1,3)&
&   *dgm10(1,3)+48*gm(1,2)*dgm01(3,3)*dgm10(1,3)+72*gm(1,1)*dgm01(3,3)&
&   *dgm10(2,3)+48*gm(1,2)*dgm01(1,3)*dgm10(3,3)+72*gm(1,1)*dgm01(2,3)&
&   *dgm10(3,3)+gm(1,3)*(48*dgm01(3,3)*dgm10(1,2)+96*dgm01(2,3)*dgm10(1,3)&
&   +96*dgm01(1,3)*dgm10(2,3)+48*dgm01(1,2)*dgm10(3,3)))+gm(1,3)&
&   *(24*gm(1,2)*dgm01(3,3)*dgm10(3,3)+96*gm(2,3)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))))/12.d0
   cm(11,8)=(24*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+192*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+96*gm(1,2)*gm(2,2)&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/48.d0
   cm(12,8)=(16*gm(3,3)**2*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +32*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +64*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(2,3)*dgm10(2,3)&
&   +64*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +32*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+32*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3))+32*gm(1,2)*gm(2,2)*dgm01(3,3)*dgm10(3,3)+4*(6*gm(2,3)&
&   **2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +32*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))&
&   +4*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3))+16*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3))+8*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/8.d0
   cm(13,8)=(48*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+24*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)&
&   *gm(2,3))*dgm01(2,3)*dgm10(2,3)+12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+96*gm(2,2)*gm(2,3)&
&   *(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+24*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3))+12*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+48*gm(1,2)*gm(2,2)*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(14,8)=(48*gm(3,3)**2*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +72*gm(1,3)*gm(2,2)*dgm01(3,3)*dgm10(3,3)+24*gm(2,3)**2*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+gm(3,3)*(192*gm(1,3)*dgm01(2,3)&
&   *dgm10(2,3)+48*gm(1,2)*dgm01(3,3)*dgm10(2,3)+48*gm(1,2)*dgm01(2,3)&
&   *dgm10(3,3)+gm(2,3)*(48*dgm01(3,3)*dgm10(1,2)+96*dgm01(2,3)*dgm10(1,3)&
&   +96*dgm01(1,3)*dgm10(2,3)+48*dgm01(1,2)*dgm10(3,3))+72*gm(2,2)&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))+gm(2,3)*(24*gm(1,2)&
&   *dgm01(3,3)*dgm10(3,3)+96*gm(1,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3))))/12.d0
   cm(15,8)=(48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(3,3)&
&   *dgm10(3,3)+96*gm(3,3)**2*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +192*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))&
&   +192*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))&
&   /48.d0
   cm(1,9)=(48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+24*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+96*gm(1,1)&
&   *gm(1,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+192*gm(1,1)&
&   *gm(1,2)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3)))/48.d0
   cm(2,9)=(64*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*dgm01(1,2)*dgm10(1,2)&
&   +32*gm(2,2)*gm(2,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)*dgm10(1,2))&
&   +16*gm(2,2)**2*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +64*gm(1,2)*gm(2,2)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +32*gm(1,1)*gm(1,3)*dgm01(2,2)*dgm10(2,2)+4*(-2*gm(1,3)*gm(2,2)&
&   +6*gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+16*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+4*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+32*gm(1,2)&
&   *gm(2,2)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+32*(1*gm(1,2)&
&   **2+3*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +32*gm(1,1)*gm(1,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))&
&   /8.d0
   cm(3,9)=(32*gm(2,3)*gm(3,3)*(dgm01(1,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,2))+32*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(1,3)&
&   *dgm10(1,3)+4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+32*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+16*gm(1,3)*gm(3,3)&
&   *(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+16*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,3))+32*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+8*(6*gm(1,2)*gm(1,3)&
&   -2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+16*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+32*gm(1,1)*gm(1,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/8.d0
   cm(4,9)=(32*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(1,2)&
&   *dgm10(1,2)+8*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(1,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,2))+64*gm(1,2)*gm(2,2)*dgm01(1,3)*dgm10(1,3)&
&   +16*gm(2,2)*gm(2,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +16*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(1,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(1,3))+8*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+4*(1*gm(1,3)*gm(2,3)&
&   +3*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +8*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+8*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+64*gm(1,1)*gm(1,2)*dgm01(2,3)&
&   *dgm10(2,3)+8*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+8*(6*gm(1,2)*gm(1,3)-2*gm(1,1)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+16*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+16*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+16*gm(1,1)*gm(1,3)*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/4.d0
   cm(5,9)=(24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+24*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*dgm01(1,3)*dgm10(1,3)+12*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)&
&   *gm(2,3))*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+24*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+12*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+48*gm(1,1)*gm(1,3)*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+96*gm(1,1)&
&   *gm(1,2)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3)))/12.d0
   cm(6,9)=(48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(1,2)&
&   *dgm10(1,2)+24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(1,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,2))+48*gm(1,2)*gm(2,2)*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+12*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*gm(1,1)*gm(1,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+24*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+96*gm(1,1)*gm(1,2)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3)))/12.d0
   cm(7,9)=(192*gm(2,2)*gm(2,3)*dgm01(1,2)*dgm10(1,2)+48*gm(2,2)&
&   **2*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+24*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*dgm01(2,2)*dgm10(2,2)+24*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +12*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+48*gm(1,2)*gm(2,2)*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+96*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+24*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/12.d0
   cm(8,9)=(64*gm(2,3)*gm(3,3)*dgm01(1,2)*dgm10(1,2)+64*gm(2,2)&
&   *gm(2,3)*dgm01(1,3)*dgm10(1,3)+4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+16*(1*gm(2,3)&
&   **2+3*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +16*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +8*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+32*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *dgm01(2,3)*dgm10(2,3)+8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+16*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+16*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+8*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+8*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +8*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+16*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+4*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+8*(1*gm(1,2)**2+3*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/4.d0
   cm(9,9)=(32*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*dgm01(1,2)*dgm10(1,2)&
&   +32*gm(2,2)**2*dgm01(1,3)*dgm10(1,3)+64*gm(2,2)*gm(2,3)*(dgm01(1,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+8*(1*gm(1,3)**2+3*gm(1,1)&
&   *gm(3,3))*dgm01(2,2)*dgm10(2,2)+16*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+8*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2))+32*(1*gm(1,2)**2+3*gm(1,1)*gm(2,2))*dgm01(2,3)*dgm10(2,3)&
&   +32*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+64*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+16*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/4.d0
   cm(10,9)=(24*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(1,3)*dgm10(1,3)&
&   +96*gm(2,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +48*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +24*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+12*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+12*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)&
&   *gm(2,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(11,9)=(48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(2,2)&
&   *dgm10(2,2)+192*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+96*gm(2,2)**2*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2))+192*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3)))/48.d0
   cm(12,9)=(32*gm(1,3)*gm(3,3)*dgm01(2,2)*dgm10(2,2)+32*gm(2,3)&
&   *gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+4*(6*gm(2,3)&
&   **2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +64*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*dgm01(2,3)*dgm10(2,3)&
&   +32*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+64*gm(2,2)*gm(2,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+16*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+32*gm(2,2)&
&   *gm(2,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+16*gm(2,2)&
&   **2*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+4*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+32*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/8.d0
   cm(13,9)=(72*gm(1,2)*gm(3,3)*dgm01(2,2)*dgm10(2,2)+24*gm(2,3)&
&   **2*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+48*gm(2,2)&
&   **2*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+gm(2,3)*(24*gm(1,3)&
&   *dgm01(2,2)*dgm10(2,2)+gm(2,2)*(96*dgm01(2,3)*dgm10(1,2)+48*dgm01(2,2)&
&   *dgm10(1,3)+48*dgm01(1,3)*dgm10(2,2)+96*dgm01(1,2)*dgm10(2,3))&
&   +96*gm(1,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))+gm(2,2)&
&   *(72*gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+192*gm(1,2)&
&   *dgm01(2,3)*dgm10(2,3)+48*gm(1,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3))))/12.d0
   cm(14,9)=(48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(2,3)&
&   *dgm10(2,3)+96*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+48*gm(1,3)*gm(3,3)*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+24*(1*gm(2,3)**2+3*gm(2,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+48*gm(2,2)&
&   *gm(2,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+12*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(15,9)=(192*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))+24*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+96*gm(1,3)*gm(3,3)*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/48.d0
   cm(1,10)=(72*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+288*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3)))/144.d0
   cm(2,10)=(12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(1,3))+48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+12*(6*gm(1,3)&
&   **2-2*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +12*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+48*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+48*gm(1,1)*gm(1,3)&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/24.d0
   cm(3,10)=2*gm(3,3)**2*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +gm(3,3)*(gm(1,3)*(2*dgm01(3,3)*dgm10(1,1)+16*dgm01(1,3)*dgm10(1,3)&
&   +2*dgm01(1,1)*dgm10(3,3))+5*gm(1,1)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3)))+gm(1,3)*(4*gm(1,1)*dgm01(3,3)*dgm10(3,3)+5*gm(1,3)&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(4,10)=(48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(1,3)&
&   *dgm10(1,3)+48*gm(2,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(1,3))+96*gm(1,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(1,3))+12*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+12*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+24*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+48*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(5,10)=(72*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(1,3)*dgm10(1,3)&
&   +144*gm(1,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,1)+dgm01(1,1)*dgm10(1,3))&
&   +36*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+144*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3)))/36.d0
   cm(6,10)=(36*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(1,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(1,3))+36*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))+36*(1*gm(1,2)&
&   *gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+144*gm(1,1)*gm(1,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3)))/36.d0
   cm(7,10)=(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(1,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(1,3))+(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+(-2*gm(1,3)*gm(2,2)&
&   +6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +(1*gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3))
   cm(8,10)=(48*gm(3,3)**2*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +72*gm(1,1)*gm(2,3)*dgm01(3,3)*dgm10(3,3)+24*gm(1,3)**2*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3))+gm(3,3)*(192*gm(2,3)*dgm01(1,3)&
&   *dgm10(1,3)+48*gm(1,2)*dgm01(3,3)*dgm10(1,3)+72*gm(1,1)*dgm01(3,3)&
&   *dgm10(2,3)+48*gm(1,2)*dgm01(1,3)*dgm10(3,3)+72*gm(1,1)*dgm01(2,3)&
&   *dgm10(3,3)+gm(1,3)*(48*dgm01(3,3)*dgm10(1,2)+96*dgm01(2,3)*dgm10(1,3)&
&   +96*dgm01(1,3)*dgm10(2,3)+48*dgm01(1,2)*dgm10(3,3)))+gm(1,3)&
&   *(24*gm(1,2)*dgm01(3,3)*dgm10(3,3)+96*gm(2,3)*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))))/12.d0
   cm(9,10)=(24*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(1,3)*dgm10(1,3)&
&   +96*gm(2,3)*gm(3,3)*(dgm01(1,3)*dgm10(1,2)+dgm01(1,2)*dgm10(1,3))&
&   +48*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +24*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+12*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+12*(1*gm(1,3)**2+3*gm(1,1)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+24*(1*gm(1,2)*gm(1,3)+3*gm(1,1)&
&   *gm(2,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(10,10)=(288*gm(3,3)**2*dgm01(1,3)*dgm10(1,3)+72*(1*gm(1,3)&
&   **2+3*gm(1,1)*gm(3,3))*dgm01(3,3)*dgm10(3,3)+288*gm(1,3)*gm(3,3)&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))/36.d0
   cm(11,10)=(4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+4*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/8.d0
   cm(12,10)=(48*gm(3,3)**2*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +192*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))&
&   +24*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(3,3)*dgm10(3,3)&
&   +12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+48*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+48*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/24.d0
   cm(13,10)=(144*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2))+36*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+36*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+36*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/36.d0
   cm(14,10)=(144*gm(3,3)**2*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+72*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(3,3)&
&   *dgm10(3,3)+144*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+144*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/36.d0
   cm(15,10)=gm(3,3)*(4*gm(1,3)*dgm01(3,3)*dgm10(3,3)+2*gm(3,3)&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(1,11)=((6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2)))/4.d0
   cm(2,11)=(48*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(2,2)*dgm10(2,2)&
&   +96*gm(2,2)**2*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +384*gm(1,2)*gm(2,2)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))&
&   /96.d0
   cm(3,11)=((6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+4*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/4.d0
   cm(4,11)=(96*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+192*gm(1,2)*gm(2,2)*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+24*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/48.d0
   cm(5,11)=(4*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+4*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2)))/8.d0
   cm(6,11)=(288*gm(1,2)*gm(2,2)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+72*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))/144.d0
   cm(7,11)=gm(2,2)*(4*gm(1,2)*dgm01(2,2)*dgm10(2,2)+2*gm(2,2)&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2)))
   cm(8,11)=(24*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+192*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+96*gm(1,2)*gm(2,2)&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/48.d0
   cm(9,11)=(48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(2,2)&
&   *dgm10(2,2)+192*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+96*gm(2,2)**2*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2))+192*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3)))/48.d0
   cm(10,11)=(4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,2))+4*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/8.d0
   cm(11,11)=2*gm(2,2)**2*dgm01(2,2)*dgm10(2,2)
   cm(12,11)=(48*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(2,2)*dgm10(2,2)&
&   +384*gm(2,2)*gm(2,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +96*gm(2,2)**2*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))&
&   /96.d0
   cm(13,11)=gm(2,2)*(4*gm(2,3)*dgm01(2,2)*dgm10(2,2)+2*gm(2,2)&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))
   cm(14,11)=(72*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(2,3))+288*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3)))/144.d0
   cm(15,11)=((6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3)))/4.d0
   cm(1,12)=((6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)))/4.d0
   cm(2,12)=(8*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(2,2)*dgm10(2,2)&
&   +4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+16*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+64*gm(2,2)*gm(2,3)*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+64*(3*gm(1,3)*gm(2,2)+gm(1,2)&
&   *gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+16*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3))+16*gm(2,2)**2*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+64*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))+4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3)))/16.d0
   cm(3,12)=(16*gm(3,3)**2*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)*dgm10(2,2))&
&   +64*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +64*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +64*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+8*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(3,3)&
&   *dgm10(3,3)+4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+16*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+16*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/16.d0
   cm(4,12)=(16*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+32*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+32*(6*gm(1,2)*gm(1,3)-2*gm(1,1)&
&   *gm(2,3))*dgm01(2,3)*dgm10(2,3)+16*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+32*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+32*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+16*gm(2,2)&
&   *gm(2,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+8*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))+32*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+4*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/8.d0
   cm(5,12)=(48*gm(1,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+12*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+48*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+48*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+12*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))/24.d0
   cm(6,12)=(12*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+12*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+48*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +48*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+48*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+12*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))/24.d0
   cm(7,12)=(24*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(2,2)&
&   *dgm10(2,2)+12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,2))+192*gm(2,2)*gm(2,3)*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+48*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+48*gm(2,2)**2*(dgm01(3,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+48*gm(1,2)*gm(2,2)*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/24.d0
   cm(8,12)=(16*gm(3,3)**2*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))&
&   +32*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +64*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(2,3)*dgm10(2,3)&
&   +64*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +32*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+32*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3))+32*gm(1,2)*gm(2,2)*dgm01(3,3)*dgm10(3,3)+4*(6*gm(2,3)&
&   **2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +32*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))&
&   +4*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3))+16*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3))+8*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/8.d0
   cm(9,12)=(32*gm(1,3)*gm(3,3)*dgm01(2,2)*dgm10(2,2)+32*gm(2,3)&
&   *gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+4*(6*gm(2,3)&
&   **2-2*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +64*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*dgm01(2,3)*dgm10(2,3)&
&   +32*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+64*gm(2,2)*gm(2,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+8*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+16*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+32*gm(2,2)&
&   *gm(2,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+16*gm(2,2)&
&   **2*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+4*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+32*gm(1,2)*gm(2,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/8.d0
   cm(10,12)=(48*gm(3,3)**2*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +192*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))&
&   +24*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)*gm(2,3))*dgm01(3,3)*dgm10(3,3)&
&   +12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+48*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+48*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/24.d0
   cm(11,12)=(48*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(2,2)*dgm10(2,2)&
&   +384*gm(2,2)*gm(2,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +96*gm(2,2)**2*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))&
&   /96.d0
   cm(12,12)=(32*gm(3,3)**2*dgm01(2,2)*dgm10(2,2)+128*(1*gm(2,3)&
&   **2+3*gm(2,2)*gm(3,3))*dgm01(2,3)*dgm10(2,3)+128*gm(2,3)*gm(3,3)&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+32*gm(2,2)**2*dgm01(3,3)&
&   *dgm10(3,3)+8*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3))+128*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/16.d0
   cm(13,12)=5*gm(2,3)**2*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +gm(2,3)*(4*gm(3,3)*dgm01(2,2)*dgm10(2,2)+gm(2,2)*(2*dgm01(3,3)&
&   *dgm10(2,2)+16*dgm01(2,3)*dgm10(2,3)+2*dgm01(2,2)*dgm10(3,3)))&
&   +gm(2,2)*(5*gm(3,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +2*gm(2,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(14,12)=2*gm(3,3)**2*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +gm(3,3)*(gm(2,3)*(2*dgm01(3,3)*dgm10(2,2)+16*dgm01(2,3)*dgm10(2,3)&
&   +2*dgm01(2,2)*dgm10(3,3))+5*gm(2,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))+gm(2,3)*(4*gm(2,2)*dgm01(3,3)*dgm10(3,3)+5*gm(2,3)&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(15,12)=(48*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(3,3)*dgm10(3,3)&
&   +96*gm(3,3)**2*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))&
&   +384*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))&
&   /96.d0
   cm(1,13)=(4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+4*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3)))/8.d0
   cm(2,13)=(24*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(2,2)&
&   *dgm10(2,2)+48*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+48*gm(2,2)**2*(dgm01(2,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+192*gm(1,2)*gm(2,2)*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/24.d0
   cm(3,13)=(48*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,2))+48*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+12*(6*gm(2,3)**2-2*gm(2,2)&
&   *gm(3,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+48*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+12*(6*gm(1,2)**2-2*gm(1,1)&
&   *gm(2,2))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/24.d0
   cm(4,13)=(12*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))&
&   *(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+24*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))&
&   +24*(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*dgm01(2,3)*dgm10(2,3)+48*gm(2,2)&
&   *gm(2,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+24*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+96*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/12.d0
   cm(5,13)=(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,2)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,2))+(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+(-2*gm(1,3)*gm(2,2)&
&   +6*gm(1,2)*gm(2,3))*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +(6*gm(1,2)**2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))
   cm(6,13)=(36*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(2,2)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(2,2))+36*(6*gm(1,2)*gm(1,3)-2*gm(1,1)&
&   *gm(2,3))*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+144*gm(1,2)&
&   *gm(2,2)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))+36*(6*gm(1,2)&
&   **2-2*gm(1,1)*gm(2,2))*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3)))&
&   /36.d0
   cm(7,13)=(72*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*dgm01(2,2)&
&   *dgm10(2,2)+144*gm(2,2)*gm(2,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+144*gm(2,2)**2*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+144*gm(1,2)*gm(2,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3)))/36.d0
   cm(8,13)=(48*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,2))+24*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(2,2)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,2))+48*(-2*gm(1,3)*gm(2,2)+6*gm(1,2)&
&   *gm(2,3))*dgm01(2,3)*dgm10(2,3)+12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+96*gm(2,2)*gm(2,3)&
&   *(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+24*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3))+12*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+48*gm(1,2)*gm(2,2)*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(9,13)=(72*gm(1,2)*gm(3,3)*dgm01(2,2)*dgm10(2,2)+24*gm(2,3)&
&   **2*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+48*gm(2,2)&
&   **2*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+gm(2,3)*(24*gm(1,3)&
&   *dgm01(2,2)*dgm10(2,2)+gm(2,2)*(96*dgm01(2,3)*dgm10(1,2)+48*dgm01(2,2)&
&   *dgm10(1,3)+48*dgm01(1,3)*dgm10(2,2)+96*dgm01(1,2)*dgm10(2,3))&
&   +96*gm(1,2)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))+gm(2,2)&
&   *(72*gm(3,3)*(dgm01(2,2)*dgm10(1,2)+dgm01(1,2)*dgm10(2,2))+192*gm(1,2)&
&   *dgm01(2,3)*dgm10(2,3)+48*gm(1,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(2,3))))/12.d0
   cm(10,13)=(144*gm(2,3)*gm(3,3)*(dgm01(2,2)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,2))+36*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+36*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+36*(-2*gm(1,3)&
&   *gm(2,2)+6*gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/36.d0
   cm(11,13)=gm(2,2)*(4*gm(2,3)*dgm01(2,2)*dgm10(2,2)+2*gm(2,2)&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))
   cm(12,13)=5*gm(2,3)**2*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +gm(2,3)*(4*gm(3,3)*dgm01(2,2)*dgm10(2,2)+gm(2,2)*(2*dgm01(3,3)&
&   *dgm10(2,2)+16*dgm01(2,3)*dgm10(2,3)+2*dgm01(2,2)*dgm10(3,3)))&
&   +gm(2,2)*(5*gm(3,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +2*gm(2,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(13,13)=(72*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*dgm01(2,2)*dgm10(2,2)&
&   +288*gm(2,2)**2*dgm01(2,3)*dgm10(2,3)+288*gm(2,2)*gm(2,3)*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3)))/36.d0
   cm(14,13)=(72*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(2,3)*dgm10(2,3)&
&   +144*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +36*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+144*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/36.d0
   cm(15,13)=(288*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+72*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/144.d0
   cm(1,14)=(4*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,3))+4*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3)))/8.d0
   cm(2,14)=(12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,3))+48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+12*(6*gm(1,3)&
&   **2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +48*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +48*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/24.d0
   cm(3,14)=(48*gm(3,3)**2*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +192*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)*dgm10(2,3))&
&   +24*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*dgm01(3,3)*dgm10(3,3)&
&   +48*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +48*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(3,3))+12*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/24.d0
   cm(4,14)=(24*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(2,3)*dgm10(2,3)&
&   +48*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)*dgm10(2,3))&
&   +96*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +24*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,3)&
&   +dgm01(1,3)*dgm10(2,3))+12*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+24*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+24*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))&
&   +12*(6*gm(1,2)*gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(2,3)&
&   +dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(5,14)=(144*gm(1,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(2,3))+36*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+36*(1*gm(1,3)*gm(2,3)+3*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+36*(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3)))/36.d0
   cm(6,14)=(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(2,3))+(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,2)+dgm01(1,2)*dgm10(2,3))+(3*gm(1,3)*gm(2,2)+gm(1,2)&
&   *gm(2,3))*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+(6*gm(1,2)&
&   *gm(1,3)-2*gm(1,1)*gm(2,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))
   cm(7,14)=(36*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(2,3))+36*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+144*gm(2,2)*gm(2,3)&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+36*(3*gm(1,3)&
&   *gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))&
&   /36.d0
   cm(8,14)=(48*gm(3,3)**2*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)*dgm10(2,3))&
&   +72*gm(1,3)*gm(2,2)*dgm01(3,3)*dgm10(3,3)+24*gm(2,3)**2*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+gm(3,3)*(192*gm(1,3)*dgm01(2,3)&
&   *dgm10(2,3)+48*gm(1,2)*dgm01(3,3)*dgm10(2,3)+48*gm(1,2)*dgm01(2,3)&
&   *dgm10(3,3)+gm(2,3)*(48*dgm01(3,3)*dgm10(1,2)+96*dgm01(2,3)*dgm10(1,3)&
&   +96*dgm01(1,3)*dgm10(2,3)+48*dgm01(1,2)*dgm10(3,3))+72*gm(2,2)&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))+gm(2,3)*(24*gm(1,2)&
&   *dgm01(3,3)*dgm10(3,3)+96*gm(1,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3))))/12.d0
   cm(9,14)=(48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(2,3)&
&   *dgm10(2,3)+96*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(2,3))+12*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(2,3))+48*gm(1,3)*gm(3,3)*(dgm01(2,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(2,3))+24*(1*gm(2,3)**2+3*gm(2,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+48*gm(2,2)&
&   *gm(2,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+12*(1*gm(1,3)&
&   *gm(2,3)+3*gm(1,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+24*(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/12.d0
   cm(10,14)=(144*gm(3,3)**2*(dgm01(2,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(2,3))+72*(1*gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))*dgm01(3,3)&
&   *dgm10(3,3)+144*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)&
&   *dgm10(3,3))+144*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/36.d0
   cm(11,14)=(72*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(2,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(2,3))+288*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3)))/144.d0
   cm(12,14)=2*gm(3,3)**2*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +gm(3,3)*(gm(2,3)*(2*dgm01(3,3)*dgm10(2,2)+16*dgm01(2,3)*dgm10(2,3)&
&   +2*dgm01(2,2)*dgm10(3,3))+5*gm(2,2)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))+gm(2,3)*(4*gm(2,2)*dgm01(3,3)*dgm10(3,3)+5*gm(2,3)&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(13,14)=(72*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(2,3)*dgm10(2,3)&
&   +144*gm(2,3)*gm(3,3)*(dgm01(2,3)*dgm10(2,2)+dgm01(2,2)*dgm10(2,3))&
&   +36*(1*gm(2,3)**2+3*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+144*gm(2,2)*gm(2,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)&
&   *dgm10(3,3)))/36.d0
   cm(14,14)=(288*gm(3,3)**2*dgm01(2,3)*dgm10(2,3)+72*(1*gm(2,3)&
&   **2+3*gm(2,2)*gm(3,3))*dgm01(3,3)*dgm10(3,3)+288*gm(2,3)*gm(3,3)&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/36.d0
   cm(15,14)=gm(3,3)*(4*gm(2,3)*dgm01(3,3)*dgm10(3,3)+2*gm(3,3)&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(1,15)=((6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3)))/4.d0
   cm(2,15)=((6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,1)&
&   +dgm01(1,1)*dgm10(3,3))+4*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))+(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/4.d0
   cm(3,15)=(48*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*dgm01(3,3)*dgm10(3,3)&
&   +96*gm(3,3)**2*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)*dgm10(3,3))&
&   +384*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))&
&   /96.d0
   cm(4,15)=(96*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+192*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))+48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+24*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/48.d0
   cm(5,15)=(288*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,1)+dgm01(1,1)&
&   *dgm10(3,3))+72*(6*gm(1,3)**2-2*gm(1,1)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))/144.d0
   cm(6,15)=(4*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,1)+dgm01(1,1)*dgm10(3,3))+4*(6*gm(1,3)**2-2*gm(1,1)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3)))/8.d0
   cm(7,15)=(4*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(1,2)&
&   +dgm01(1,2)*dgm10(3,3))+4*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))&
&   *(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3)))/8.d0
   cm(8,15)=(48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)*gm(3,3))*dgm01(3,3)&
&   *dgm10(3,3)+96*gm(3,3)**2*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)*dgm10(3,3))&
&   +192*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3))&
&   +192*gm(1,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))&
&   /48.d0
   cm(9,15)=(192*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(1,2)+dgm01(1,2)&
&   *dgm10(3,3))+24*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(1,3)+dgm01(1,3)*dgm10(3,3))+96*gm(1,3)*gm(3,3)*(dgm01(3,3)&
&   *dgm10(2,2)+dgm01(2,2)*dgm10(3,3))+48*(6*gm(1,3)*gm(2,3)-2*gm(1,2)&
&   *gm(3,3))*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/48.d0
   cm(10,15)=gm(3,3)*(4*gm(1,3)*dgm01(3,3)*dgm10(3,3)+2*gm(3,3)&
&   *(dgm01(3,3)*dgm10(1,3)+dgm01(1,3)*dgm10(3,3)))
   cm(11,15)=((6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)*dgm10(2,2)&
&   +dgm01(2,2)*dgm10(3,3)))/4.d0
   cm(12,15)=(48*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*dgm01(3,3)*dgm10(3,3)&
&   +96*gm(3,3)**2*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)*dgm10(3,3))&
&   +384*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))&
&   /96.d0
   cm(13,15)=(288*gm(2,3)*gm(3,3)*(dgm01(3,3)*dgm10(2,2)+dgm01(2,2)&
&   *dgm10(3,3))+72*(6*gm(2,3)**2-2*gm(2,2)*gm(3,3))*(dgm01(3,3)&
&   *dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))/144.d0
   cm(14,15)=gm(3,3)*(4*gm(2,3)*dgm01(3,3)*dgm10(3,3)+2*gm(3,3)&
&   *(dgm01(3,3)*dgm10(2,3)+dgm01(2,3)*dgm10(3,3)))
   cm(15,15)=2*gm(3,3)**2*dgm01(3,3)*dgm10(3,3)
 end if
!
!contraction to output scalar
!
 e2nl=0.d0
 do jj=1,((rank+3)*(rank+4))/2
   tmp(:)=0.d0
   do ii=1,((rank+3)*(rank+4))/2
     tmp(:)=tmp(:)+aa(:,ii)*cm(ii,jj)
   end do
   e2nl=e2nl+tmp(1)*bb(1,jj)+tmp(2)*bb(2,jj)
 end do
 e2nl=0.25d0*e2nl

 ABI_DEALLOCATE(cm)

end subroutine contstr25
!!***
