# -*- Autoconf -*-
#
# Copyright (C) 2005-2014 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-options on 2015/10/19 06:27:05 +0000

#
# Command-line options for the "configure" script
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-options
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_OPTIONS_DEFINE()
# --------------------
#
# Declares command-line arguments for the "configure" script.
#
AC_DEFUN([ABI_OPTIONS_DEFINE],[

  dnl
  dnl --enable arguments
  dnl

  AC_ARG_ENABLE(64bit-flags,
    AC_HELP_STRING([--enable-64bit-flags],
      [Use 64-bit flags (see documentation) (default: no)]))
  AC_SUBST(enable_64bit_flags)

  AC_ARG_ENABLE(bse-unpacked,
    AC_HELP_STRING([--enable-bse-unpacked],
      [Activate Bethe-Salpeter unpacking (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_bse_unpacked)

  AC_ARG_ENABLE(cclock,
    AC_HELP_STRING([--enable-cclock],
      [Use C clock for timings (default: no)]))
  AC_SUBST(enable_cclock)

  AC_ARG_ENABLE(clib,
    AC_HELP_STRING([--enable-clib],
      [Enable the Abinit C library (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_clib)

  AC_ARG_ENABLE(config-file,
    AC_HELP_STRING([--enable-config-file],
      [Read options from config file (default: yes)]))
  AC_SUBST(enable_config_file)

  AC_ARG_ENABLE(connectors,
    AC_HELP_STRING([--enable-connectors],
      [Enable detection of external libraries (EXPERIMENTAL) (default: yes)]))
  AC_SUBST(enable_connectors)

  AC_ARG_ENABLE(debug,
    AC_HELP_STRING([--enable-debug],
      [Set debug level (default: basic)]))
  AC_SUBST(enable_debug)

  AC_ARG_ENABLE(exports,
    AC_HELP_STRING([--enable-exports],
      [Activate build of exported libraries (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_exports)

  AC_ARG_ENABLE(fallbacks,
    AC_HELP_STRING([--enable-fallbacks],
      [Enable the internal build of external packages (default: yes)]))
  AC_SUBST(enable_fallbacks)

  AC_ARG_ENABLE(fast-check,
    AC_HELP_STRING([--enable-fast-check],
      [Run 'make check' using 4 processors (default: no)]))
  AC_SUBST(enable_fast_check)

  AC_ARG_ENABLE(fc-wrapper,
    AC_HELP_STRING([--enable-fc-wrapper],
      [Wrap Fortran compiler calls (default: no)]))
  AC_SUBST(enable_fc_wrapper)

  AC_ARG_ENABLE(gpu,
    AC_HELP_STRING([--enable-gpu],
      [Activate support for GPU (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_gpu)

  AC_ARG_ENABLE(gw-dpc,
    AC_HELP_STRING([--enable-gw-dpc],
      [Activate double-precision GW calculations (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_gw_dpc)

  AC_ARG_ENABLE(hints,
    AC_HELP_STRING([--enable-hints],
      [Preset flags to have the source building properly (default: yes)]))
  AC_SUBST(enable_hints)

  AC_ARG_ENABLE(lotf,
    AC_HELP_STRING([--enable-lotf],
      [Activate LOTF functionality (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_lotf)

  AC_ARG_ENABLE(macroave,
    AC_HELP_STRING([--enable-macroave],
      [Enable build of macroave (EXPERIMENTAL) (default: yes)]))
  AC_SUBST(enable_macroave)

  AC_ARG_ENABLE(maintainer-checks,
    AC_HELP_STRING([--enable-maintainer-checks],
      [Activate maintainer checks (BuildBot) (default: no)]))
  AC_SUBST(enable_maintainer_checks)

  AC_ARG_ENABLE(memory-profiling,
    AC_HELP_STRING([--enable-memory-profiling],
      [Enable memory profiling (default: None)]))
  AC_SUBST(enable_memory_profiling)

  AC_ARG_ENABLE(mpi,
    AC_HELP_STRING([--enable-mpi],
      [Enable MPI support (default: auto)]))
  AC_SUBST(enable_mpi)

  AC_ARG_ENABLE(mpi-inplace,
    AC_HELP_STRING([--enable-mpi-inplace],
      [Activate support for MPI_IN_PLACE (default: no)]))
  AC_SUBST(enable_mpi_inplace)

  AC_ARG_ENABLE(mpi-io,
    AC_HELP_STRING([--enable-mpi-io],
      [Enable MPI I/O (default: auto)]))
  AC_SUBST(enable_mpi_io)

  AC_ARG_ENABLE(openmp,
    AC_HELP_STRING([--enable-openmp],
      [Activate support for OpenMP (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_openmp)

  AC_ARG_ENABLE(optim,
    AC_HELP_STRING([--enable-optim],
      [Set optimization level (default: standard)]))
  AC_SUBST(enable_optim)

  AC_ARG_ENABLE(stdin,
    AC_HELP_STRING([--enable-stdin],
      [Tell Abinit to read file lists from standard input (default: yes)]))
  AC_SUBST(enable_stdin)

  AC_ARG_ENABLE(zdot-bugfix,
    AC_HELP_STRING([--enable-zdot-bugfix],
      [Activate workaround for bugged ZDOTC and ZDOTU (default: no)]))
  AC_SUBST(enable_zdot_bugfix)

  dnl
  dnl --with arguments
  dnl

  AC_ARG_WITH(algo-flavor,
    AC_HELP_STRING([--with-algo-flavor],
      [Kind of external algorithms to support (default: none)]))
  AC_SUBST(with_algo_flavor)

  AC_ARG_WITH(algo-incs,
    AC_HELP_STRING([--with-algo-incs],
      [Include parameters for the algorithmic libraries (default: None)]))
  AC_SUBST(with_algo_incs)

  AC_ARG_WITH(algo-libs,
    AC_HELP_STRING([--with-algo-libs],
      [Algorithmic libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_algo_libs)

  AC_ARG_WITH(atompaw-bins,
    AC_HELP_STRING([--with-atompaw-bins],
      [Path to the AtomPAW executables (default: None)]))
  AC_SUBST(with_atompaw_bins)

  AC_ARG_WITH(atompaw-incs,
    AC_HELP_STRING([--with-atompaw-incs],
      [Include parameters for AtomPAW support (default: None)]))
  AC_SUBST(with_atompaw_incs)

  AC_ARG_WITH(atompaw-libs,
    AC_HELP_STRING([--with-atompaw-libs],
      [AtomPAW libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_atompaw_libs)

  AC_ARG_WITH(bigdft-incs,
    AC_HELP_STRING([--with-bigdft-incs],
      [Include parameters for BigDFT support (default: None)]))
  AC_SUBST(with_bigdft_incs)

  AC_ARG_WITH(bigdft-libs,
    AC_HELP_STRING([--with-bigdft-libs],
      [BigDFT libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_bigdft_libs)

  AC_ARG_WITH(config-file,
    AC_HELP_STRING([--with-config-file],
      [Specify config file to read options from (default: None)]))
  AC_SUBST(with_config_file)

  AC_ARG_WITH(dft-flavor,
    AC_HELP_STRING([--with-dft-flavor],
      [Kind of DFT support to activate (default: none)]))
  AC_SUBST(with_dft_flavor)

  AC_ARG_WITH(etsf-io-incs,
    AC_HELP_STRING([--with-etsf-io-incs],
      [Include parameters for ETSF I/O support (default: None)]))
  AC_SUBST(with_etsf_io_incs)

  AC_ARG_WITH(etsf-io-libs,
    AC_HELP_STRING([--with-etsf-io-libs],
      [ETSF I/O libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_etsf_io_libs)

  AC_ARG_WITH(fc-vendor,
    AC_HELP_STRING([--with-fc-vendor],
      [Fortran compiler vendor to be used by the build system (default: None)]))
  AC_SUBST(with_fc_vendor)

  AC_ARG_WITH(fc-version,
    AC_HELP_STRING([--with-fc-version],
      [Fortran compiler version to be used by the build system (default: None)]))
  AC_SUBST(with_fc_version)

  AC_ARG_WITH(fft-flavor,
    AC_HELP_STRING([--with-fft-flavor],
      [Kind of FFT support to activate (default: none)]))
  AC_SUBST(with_fft_flavor)

  AC_ARG_WITH(fft-incs,
    AC_HELP_STRING([--with-fft-incs],
      [Include parameters for the FFT libraries (default: None)]))
  AC_SUBST(with_fft_incs)

  AC_ARG_WITH(fft-libs,
    AC_HELP_STRING([--with-fft-libs],
      [FFT libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_fft_libs)

  AC_ARG_WITH(fox-incs,
    AC_HELP_STRING([--with-fox-incs],
      [Include parameters for FoX support (default: None)]))
  AC_SUBST(with_fox_incs)

  AC_ARG_WITH(fox-libs,
    AC_HELP_STRING([--with-fox-libs],
      [FoX libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_fox_libs)

  AC_ARG_WITH(gpu-cflags,
    AC_HELP_STRING([--with-gpu-cflags],
      [C flags to build GPU kernels (default: None)]))
  AC_SUBST(with_gpu_cflags)

  AC_ARG_WITH(gpu-cppflags,
    AC_HELP_STRING([--with-gpu-cppflags],
      [Preprocessing options to build GPU kernels (default: None)]))
  AC_SUBST(with_gpu_cppflags)

  AC_ARG_WITH(gpu-flavor,
    AC_HELP_STRING([--with-gpu-flavor],
      [Kind of GPU support to activate (default: cuda-double)]))
  AC_SUBST(with_gpu_flavor)

  AC_ARG_WITH(gpu-incs,
    AC_HELP_STRING([--with-gpu-incs],
      [Include parameters for GPU support (default: None)]))
  AC_SUBST(with_gpu_incs)

  AC_ARG_WITH(gpu-ldflags,
    AC_HELP_STRING([--with-gpu-ldflags],
      [Link flags to build GPU-specific binaries (default: None)]))
  AC_SUBST(with_gpu_ldflags)

  AC_ARG_WITH(gpu-libs,
    AC_HELP_STRING([--with-gpu-libs],
      [GPU libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_gpu_libs)

  AC_ARG_WITH(gpu-prefix,
    AC_HELP_STRING([--with-gpu-prefix],
      [Prefix path for the GPU installation (default: None)]))
  AC_SUBST(with_gpu_prefix)

  AC_ARG_WITH(libpspio-incs,
    AC_HELP_STRING([--with-libpspio-incs],
      [Include parameters for Libpspio support (default: None)]))
  AC_SUBST(with_libpspio_incs)

  AC_ARG_WITH(libpspio-libs,
    AC_HELP_STRING([--with-libpspio-libs],
      [Libpspio libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_libpspio_libs)

  AC_ARG_WITH(libxc-incs,
    AC_HELP_STRING([--with-libxc-incs],
      [Include parameters for ETSF XC support (default: None)]))
  AC_SUBST(with_libxc_incs)

  AC_ARG_WITH(libxc-libs,
    AC_HELP_STRING([--with-libxc-libs],
      [ETSF XC libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_libxc_libs)

  AC_ARG_WITH(linalg-flavor,
    AC_HELP_STRING([--with-linalg-flavor],
      [See ~abinit/doc/build/config-template.ac for information, in particular for ScaLAPACK support (default: netlib)]))
  AC_SUBST(with_linalg_flavor)

  AC_ARG_WITH(linalg-incs,
    AC_HELP_STRING([--with-linalg-incs],
      [Include parameters for the linear algebra libraries (BLAS+LAPACK) (default: None)]))
  AC_SUBST(with_linalg_incs)

  AC_ARG_WITH(linalg-libs,
    AC_HELP_STRING([--with-linalg-libs],
      [Linear algebra libraries (BLAS+LAPACK) to link with (default: None)]))
  AC_SUBST(with_linalg_libs)

  AC_ARG_WITH(math-flavor,
    AC_HELP_STRING([--with-math-flavor],
      [Kind of math library to use (default: none)]))
  AC_SUBST(with_math_flavor)

  AC_ARG_WITH(math-incs,
    AC_HELP_STRING([--with-math-incs],
      [Include parameters for the math library (default: None)]))
  AC_SUBST(with_math_incs)

  AC_ARG_WITH(math-libs,
    AC_HELP_STRING([--with-math-libs],
      [GSL libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_math_libs)

  AC_ARG_WITH(mpi-incs,
    AC_HELP_STRING([--with-mpi-incs],
      [Include parameters for the MPI library (default: None)]))
  AC_SUBST(with_mpi_incs)

  AC_ARG_WITH(mpi-level,
    AC_HELP_STRING([--with-mpi-level],
      [MPI standard level to use (1 or 2) (default: None)]))
  AC_SUBST(with_mpi_level)

  AC_ARG_WITH(mpi-libs,
    AC_HELP_STRING([--with-mpi-libs],
      [MPI libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_mpi_libs)

  AC_ARG_WITH(mpi-prefix,
    AC_HELP_STRING([--with-mpi-prefix],
      [Prefix path to the MPI installation (default: None)]))
  AC_SUBST(with_mpi_prefix)

  AC_ARG_WITH(netcdf-incs,
    AC_HELP_STRING([--with-netcdf-incs],
      [Include parameters for NetCDF support (default: None)]))
  AC_SUBST(with_netcdf_incs)

  AC_ARG_WITH(netcdf-libs,
    AC_HELP_STRING([--with-netcdf-libs],
      [NetCDF libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_netcdf_libs)

  AC_ARG_WITH(tardir,
    AC_HELP_STRING([--with-tardir],
      [Repository of tarballs for fallbacks (default: None)]))
  AC_SUBST(with_tardir)

  AC_ARG_WITH(timer-flavor,
    AC_HELP_STRING([--with-timer-flavor],
      [Kind of timer to use (default: abinit)]))
  AC_SUBST(with_timer_flavor)

  AC_ARG_WITH(timer-incs,
    AC_HELP_STRING([--with-timer-incs],
      [Include parameters for the timer library (default: None)]))
  AC_SUBST(with_timer_incs)

  AC_ARG_WITH(timer-libs,
    AC_HELP_STRING([--with-timer-libs],
      [PAPI libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_timer_libs)

  AC_ARG_WITH(trio-flavor,
    AC_HELP_STRING([--with-trio-flavor],
      [Kind of transferable I/O to activate (default: none)]))
  AC_SUBST(with_trio_flavor)

  AC_ARG_WITH(wannier90-bins,
    AC_HELP_STRING([--with-wannier90-bins],
      [Full path to the Wannier90 executables (default: None)]))
  AC_SUBST(with_wannier90_bins)

  AC_ARG_WITH(wannier90-incs,
    AC_HELP_STRING([--with-wannier90-incs],
      [Include parameters for Wannier90 support (default: None)]))
  AC_SUBST(with_wannier90_incs)

  AC_ARG_WITH(wannier90-libs,
    AC_HELP_STRING([--with-wannier90-libs],
      [Wannier90 libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_wannier90_libs)

  AC_ARG_WITH(yaml-incs,
    AC_HELP_STRING([--with-yaml-incs],
      [Include parameters for YAML output support (default: None)]))
  AC_SUBST(with_yaml_incs)

  AC_ARG_WITH(yaml-libs,
    AC_HELP_STRING([--with-yaml-libs],
      [YAML libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_yaml_libs)
]) # ABI_OPTIONS_DEFINE



# ABI_OPTIONS_SETUP()
# -------------------
#
# Sets the default values of command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_SETUP],[

  dnl
  dnl --enable arguments
  dnl

  if test "${enable_64bit_flags}" = ""; then
    enable_64bit_flags="no"
  fi
  if test "${enable_bse_unpacked}" = ""; then
    enable_bse_unpacked="no"
  fi
  if test "${enable_cclock}" = ""; then
    enable_cclock="no"
  fi
  if test "${enable_clib}" = ""; then
    enable_clib="no"
  fi
  if test "${enable_config_file}" = ""; then
    enable_config_file="yes"
  fi
  if test "${enable_connectors}" = ""; then
    enable_connectors="yes"
  fi
  if test "${enable_debug}" = ""; then
    enable_debug="basic"
  fi
  if test "${enable_exports}" = ""; then
    enable_exports="no"
  fi
  if test "${enable_fallbacks}" = ""; then
    enable_fallbacks="yes"
  fi
  if test "${enable_fast_check}" = ""; then
    enable_fast_check="no"
  fi
  if test "${enable_fc_wrapper}" = ""; then
    enable_fc_wrapper="no"
  fi
  if test "${enable_gpu}" = ""; then
    enable_gpu="no"
  fi
  if test "${enable_gw_dpc}" = ""; then
    enable_gw_dpc="no"
  fi
  if test "${enable_hints}" = ""; then
    enable_hints="yes"
  fi
  if test "${enable_lotf}" = ""; then
    enable_lotf="no"
  fi
  if test "${enable_macroave}" = ""; then
    enable_macroave="yes"
  fi
  if test "${enable_maintainer_checks}" = ""; then
    enable_maintainer_checks="no"
  fi
  if test "${enable_mpi}" = ""; then
    enable_mpi="auto"
  fi
  if test "${enable_mpi_inplace}" = ""; then
    enable_mpi_inplace="no"
  fi
  if test "${enable_mpi_io}" = ""; then
    enable_mpi_io="auto"
  fi
  if test "${enable_openmp}" = ""; then
    enable_openmp="no"
  fi
  if test "${enable_optim}" = ""; then
    enable_optim="standard"
  fi
  if test "${enable_stdin}" = ""; then
    enable_stdin="yes"
  fi
  if test "${enable_zdot_bugfix}" = ""; then
    enable_zdot_bugfix="no"
  fi

  dnl
  dnl --with arguments
  dnl

  if test "${with_algo_flavor}" = ""; then
    with_algo_flavor="none"
  fi
  if test "${with_algo_flavor}" = "no"; then
    with_algo_flavor=""
  fi
  if test "${with_algo_incs}" = "no"; then
    with_algo_incs=""
  fi
  if test "${with_algo_libs}" = "no"; then
    with_algo_libs=""
  fi
  if test "${with_atompaw_bins}" = "no"; then
    with_atompaw_bins=""
  fi
  if test "${with_atompaw_incs}" = "no"; then
    with_atompaw_incs=""
  fi
  if test "${with_atompaw_libs}" = "no"; then
    with_atompaw_libs=""
  fi
  if test "${with_bigdft_incs}" = "no"; then
    with_bigdft_incs=""
  fi
  if test "${with_bigdft_libs}" = "no"; then
    with_bigdft_libs=""
  fi
  if test "${with_config_file}" = "no"; then
    with_config_file=""
  fi
  if test "${with_dft_flavor}" = ""; then
    with_dft_flavor="none"
  fi
  if test "${with_dft_flavor}" = "no"; then
    with_dft_flavor=""
  fi
  if test "${with_etsf_io_incs}" = "no"; then
    with_etsf_io_incs=""
  fi
  if test "${with_etsf_io_libs}" = "no"; then
    with_etsf_io_libs=""
  fi
  if test "${with_fc_vendor}" = "no"; then
    with_fc_vendor=""
  fi
  if test "${with_fc_version}" = "no"; then
    with_fc_version=""
  fi
  if test "${with_fft_flavor}" = ""; then
    with_fft_flavor="none"
  fi
  if test "${with_fft_flavor}" = "no"; then
    with_fft_flavor=""
  fi
  if test "${with_fft_incs}" = "no"; then
    with_fft_incs=""
  fi
  if test "${with_fft_libs}" = "no"; then
    with_fft_libs=""
  fi
  if test "${with_fox_incs}" = "no"; then
    with_fox_incs=""
  fi
  if test "${with_fox_libs}" = "no"; then
    with_fox_libs=""
  fi
  if test "${with_gpu_cflags}" = "no"; then
    with_gpu_cflags=""
  fi
  if test "${with_gpu_cppflags}" = "no"; then
    with_gpu_cppflags=""
  fi
  if test "${with_gpu_flavor}" = ""; then
    with_gpu_flavor="cuda-double"
  fi
  if test "${with_gpu_flavor}" = "no"; then
    with_gpu_flavor=""
  fi
  if test "${with_gpu_incs}" = "no"; then
    with_gpu_incs=""
  fi
  if test "${with_gpu_ldflags}" = "no"; then
    with_gpu_ldflags=""
  fi
  if test "${with_gpu_libs}" = "no"; then
    with_gpu_libs=""
  fi
  if test "${with_gpu_prefix}" = "no"; then
    with_gpu_prefix=""
  fi
  if test "${with_libpspio_incs}" = "no"; then
    with_libpspio_incs=""
  fi
  if test "${with_libpspio_libs}" = "no"; then
    with_libpspio_libs=""
  fi
  if test "${with_libxc_incs}" = "no"; then
    with_libxc_incs=""
  fi
  if test "${with_libxc_libs}" = "no"; then
    with_libxc_libs=""
  fi
  if test "${with_linalg_flavor}" = ""; then
    with_linalg_flavor="netlib"
  fi
  if test "${with_linalg_flavor}" = "no"; then
    with_linalg_flavor=""
  fi
  if test "${with_linalg_incs}" = "no"; then
    with_linalg_incs=""
  fi
  if test "${with_linalg_libs}" = "no"; then
    with_linalg_libs=""
  fi
  if test "${with_math_flavor}" = ""; then
    with_math_flavor="none"
  fi
  if test "${with_math_flavor}" = "no"; then
    with_math_flavor=""
  fi
  if test "${with_math_incs}" = "no"; then
    with_math_incs=""
  fi
  if test "${with_math_libs}" = "no"; then
    with_math_libs=""
  fi
  if test "${with_mpi_incs}" = "no"; then
    with_mpi_incs=""
  fi
  if test "${with_mpi_level}" = "no"; then
    with_mpi_level=""
  fi
  if test "${with_mpi_libs}" = "no"; then
    with_mpi_libs=""
  fi
  if test "${with_mpi_prefix}" = "no"; then
    with_mpi_prefix=""
  fi
  if test "${with_netcdf_incs}" = "no"; then
    with_netcdf_incs=""
  fi
  if test "${with_netcdf_libs}" = "no"; then
    with_netcdf_libs=""
  fi
  if test "${with_tardir}" = "no"; then
    with_tardir=""
  fi
  if test "${with_timer_flavor}" = ""; then
    with_timer_flavor="abinit"
  fi
  if test "${with_timer_flavor}" = "no"; then
    with_timer_flavor=""
  fi
  if test "${with_timer_incs}" = "no"; then
    with_timer_incs=""
  fi
  if test "${with_timer_libs}" = "no"; then
    with_timer_libs=""
  fi
  if test "${with_trio_flavor}" = ""; then
    with_trio_flavor="none"
  fi
  if test "${with_trio_flavor}" = "no"; then
    with_trio_flavor=""
  fi
  if test "${with_wannier90_bins}" = "no"; then
    with_wannier90_bins=""
  fi
  if test "${with_wannier90_incs}" = "no"; then
    with_wannier90_incs=""
  fi
  if test "${with_wannier90_libs}" = "no"; then
    with_wannier90_libs=""
  fi
  if test "${with_yaml_incs}" = "no"; then
    with_yaml_incs=""
  fi
  if test "${with_yaml_libs}" = "no"; then
    with_yaml_libs=""
  fi
]) # ABI_OPTIONS_SETUP



# ABI_OPTIONS_BACKUP()
# --------------------
#
# Saves all command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_BACKUP],[

  dnl
  dnl --enable arguments
  dnl
  cmd_enable_64bit_flags="${enable_64bit_flags}"
  cmd_enable_atompaw="${enable_atompaw}"
  cmd_enable_bigdft="${enable_bigdft}"
  cmd_enable_bse_unpacked="${enable_bse_unpacked}"
  cmd_enable_cclock="${enable_cclock}"
  cmd_enable_clib="${enable_clib}"
  cmd_enable_config_file="${enable_config_file}"
  cmd_enable_connectors="${enable_connectors}"
  cmd_enable_debug="${enable_debug}"
  cmd_enable_etsf_io="${enable_etsf_io}"
  cmd_enable_exports="${enable_exports}"
  cmd_enable_fallbacks="${enable_fallbacks}"
  cmd_enable_fast_check="${enable_fast_check}"
  cmd_enable_fc_wrapper="${enable_fc_wrapper}"
  cmd_enable_fox="${enable_fox}"
  cmd_enable_gpu="${enable_gpu}"
  cmd_enable_gw_dpc="${enable_gw_dpc}"
  cmd_enable_hints="${enable_hints}"
  cmd_enable_libpaw="${enable_libpaw}"
  cmd_enable_libxc="${enable_libxc}"
  cmd_enable_linalg="${enable_linalg}"
  cmd_enable_lotf="${enable_lotf}"
  cmd_enable_macroave="${enable_macroave}"
  cmd_enable_maintainer_checks="${enable_maintainer_checks}"
  cmd_enable_memory_profiling="${enable_memory_profiling}"
  cmd_enable_mpi="${enable_mpi}"
  cmd_enable_mpi_inplace="${enable_mpi_inplace}"
  cmd_enable_mpi_io="${enable_mpi_io}"
  cmd_enable_netcdf="${enable_netcdf}"
  cmd_enable_openmp="${enable_openmp}"
  cmd_enable_optim="${enable_optim}"
  cmd_enable_stdin="${enable_stdin}"
  cmd_enable_wannier90="${enable_wannier90}"
  cmd_enable_zdot_bugfix="${enable_zdot_bugfix}"

  dnl
  dnl --with arguments
  dnl
  cmd_with_algo_flavor="${with_algo_flavor}"
  cmd_with_algo_incs="${with_algo_incs}"
  cmd_with_algo_libs="${with_algo_libs}"
  cmd_with_atompaw_bins="${with_atompaw_bins}"
  cmd_with_atompaw_incs="${with_atompaw_incs}"
  cmd_with_atompaw_libs="${with_atompaw_libs}"
  cmd_with_bigdft_incs="${with_bigdft_incs}"
  cmd_with_bigdft_libs="${with_bigdft_libs}"
  cmd_with_config_file="${with_config_file}"
  cmd_with_dft_flavor="${with_dft_flavor}"
  cmd_with_etsf_io_incs="${with_etsf_io_incs}"
  cmd_with_etsf_io_libs="${with_etsf_io_libs}"
  cmd_with_fc_vendor="${with_fc_vendor}"
  cmd_with_fc_version="${with_fc_version}"
  cmd_with_fft_flavor="${with_fft_flavor}"
  cmd_with_fft_incs="${with_fft_incs}"
  cmd_with_fft_libs="${with_fft_libs}"
  cmd_with_fox_incs="${with_fox_incs}"
  cmd_with_fox_libs="${with_fox_libs}"
  cmd_with_gpu_cflags="${with_gpu_cflags}"
  cmd_with_gpu_cppflags="${with_gpu_cppflags}"
  cmd_with_gpu_flavor="${with_gpu_flavor}"
  cmd_with_gpu_incs="${with_gpu_incs}"
  cmd_with_gpu_ldflags="${with_gpu_ldflags}"
  cmd_with_gpu_libs="${with_gpu_libs}"
  cmd_with_gpu_prefix="${with_gpu_prefix}"
  cmd_with_libpspio_incs="${with_libpspio_incs}"
  cmd_with_libpspio_libs="${with_libpspio_libs}"
  cmd_with_libxc_incs="${with_libxc_incs}"
  cmd_with_libxc_libs="${with_libxc_libs}"
  cmd_with_linalg_flavor="${with_linalg_flavor}"
  cmd_with_linalg_incs="${with_linalg_incs}"
  cmd_with_linalg_libs="${with_linalg_libs}"
  cmd_with_math_flavor="${with_math_flavor}"
  cmd_with_math_incs="${with_math_incs}"
  cmd_with_math_libs="${with_math_libs}"
  cmd_with_mpi_incs="${with_mpi_incs}"
  cmd_with_mpi_level="${with_mpi_level}"
  cmd_with_mpi_libs="${with_mpi_libs}"
  cmd_with_mpi_prefix="${with_mpi_prefix}"
  cmd_with_netcdf_incs="${with_netcdf_incs}"
  cmd_with_netcdf_libs="${with_netcdf_libs}"
  cmd_with_tardir="${with_tardir}"
  cmd_with_timer_flavor="${with_timer_flavor}"
  cmd_with_timer_incs="${with_timer_incs}"
  cmd_with_timer_libs="${with_timer_libs}"
  cmd_with_trio_flavor="${with_trio_flavor}"
  cmd_with_wannier90_bins="${with_wannier90_bins}"
  cmd_with_wannier90_incs="${with_wannier90_incs}"
  cmd_with_wannier90_libs="${with_wannier90_libs}"
  cmd_with_yaml_incs="${with_yaml_incs}"
  cmd_with_yaml_libs="${with_yaml_libs}"

  dnl
  dnl Prefix
  dnl
  if test "${prefix}" != "NONE"; then
    cmd_prefix="${prefix}"
  fi
]) # ABI_OPTIONS_BACKUP



# ABI_OPTIONS_RECALL()
# --------------------
#
# Restores all previously-saved command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_RECALL],[

  dnl
  dnl --enable arguments
  dnl

  if test "${cmd_enable_64bit_flags}" != ""; then
    enable_64bit_flags="${cmd_enable_64bit_flags}"
  fi

  if test "${cmd_enable_atompaw}" != ""; then
    enable_atompaw="${cmd_enable_atompaw}"
  fi

  if test "${cmd_enable_bigdft}" != ""; then
    enable_bigdft="${cmd_enable_bigdft}"
  fi

  if test "${cmd_enable_bse_unpacked}" != ""; then
    enable_bse_unpacked="${cmd_enable_bse_unpacked}"
  fi

  if test "${cmd_enable_cclock}" != ""; then
    enable_cclock="${cmd_enable_cclock}"
  fi

  if test "${cmd_enable_clib}" != ""; then
    enable_clib="${cmd_enable_clib}"
  fi

  if test "${cmd_enable_config_file}" != ""; then
    enable_config_file="${cmd_enable_config_file}"
  fi

  if test "${cmd_enable_connectors}" != ""; then
    enable_connectors="${cmd_enable_connectors}"
  fi

  if test "${cmd_enable_debug}" != ""; then
    enable_debug="${cmd_enable_debug}"
  fi

  if test "${cmd_enable_etsf_io}" != ""; then
    enable_etsf_io="${cmd_enable_etsf_io}"
  fi

  if test "${cmd_enable_exports}" != ""; then
    enable_exports="${cmd_enable_exports}"
  fi

  if test "${cmd_enable_fallbacks}" != ""; then
    enable_fallbacks="${cmd_enable_fallbacks}"
  fi

  if test "${cmd_enable_fast_check}" != ""; then
    enable_fast_check="${cmd_enable_fast_check}"
  fi

  if test "${cmd_enable_fc_wrapper}" != ""; then
    enable_fc_wrapper="${cmd_enable_fc_wrapper}"
  fi

  if test "${cmd_enable_fox}" != ""; then
    enable_fox="${cmd_enable_fox}"
  fi

  if test "${cmd_enable_gpu}" != ""; then
    enable_gpu="${cmd_enable_gpu}"
  fi

  if test "${cmd_enable_gw_dpc}" != ""; then
    enable_gw_dpc="${cmd_enable_gw_dpc}"
  fi

  if test "${cmd_enable_hints}" != ""; then
    enable_hints="${cmd_enable_hints}"
  fi

  if test "${cmd_enable_libpaw}" != ""; then
    enable_libpaw="${cmd_enable_libpaw}"
  fi

  if test "${cmd_enable_libxc}" != ""; then
    enable_libxc="${cmd_enable_libxc}"
  fi

  if test "${cmd_enable_linalg}" != ""; then
    enable_linalg="${cmd_enable_linalg}"
  fi

  if test "${cmd_enable_lotf}" != ""; then
    enable_lotf="${cmd_enable_lotf}"
  fi

  if test "${cmd_enable_macroave}" != ""; then
    enable_macroave="${cmd_enable_macroave}"
  fi

  if test "${cmd_enable_maintainer_checks}" != ""; then
    enable_maintainer_checks="${cmd_enable_maintainer_checks}"
  fi

  if test "${cmd_enable_memory_profiling}" != ""; then
    enable_memory_profiling="${cmd_enable_memory_profiling}"
  fi

  if test "${cmd_enable_mpi}" != ""; then
    enable_mpi="${cmd_enable_mpi}"
  fi

  if test "${cmd_enable_mpi_inplace}" != ""; then
    enable_mpi_inplace="${cmd_enable_mpi_inplace}"
  fi

  if test "${cmd_enable_mpi_io}" != ""; then
    enable_mpi_io="${cmd_enable_mpi_io}"
  fi

  if test "${cmd_enable_netcdf}" != ""; then
    enable_netcdf="${cmd_enable_netcdf}"
  fi

  if test "${cmd_enable_openmp}" != ""; then
    enable_openmp="${cmd_enable_openmp}"
  fi

  if test "${cmd_enable_optim}" != ""; then
    enable_optim="${cmd_enable_optim}"
  fi

  if test "${cmd_enable_stdin}" != ""; then
    enable_stdin="${cmd_enable_stdin}"
  fi

  if test "${cmd_enable_wannier90}" != ""; then
    enable_wannier90="${cmd_enable_wannier90}"
  fi

  if test "${cmd_enable_zdot_bugfix}" != ""; then
    enable_zdot_bugfix="${cmd_enable_zdot_bugfix}"
  fi

  dnl
  dnl --with arguments
  dnl

  if test "${cmd_with_algo_flavor}" != ""; then
    with_algo_flavor="${cmd_with_algo_flavor}"
  fi

  if test "${cmd_with_algo_incs}" != ""; then
    with_algo_incs="${cmd_with_algo_incs}"
  fi

  if test "${cmd_with_algo_libs}" != ""; then
    with_algo_libs="${cmd_with_algo_libs}"
  fi

  if test "${cmd_with_atompaw_bins}" != ""; then
    with_atompaw_bins="${cmd_with_atompaw_bins}"
  fi

  if test "${cmd_with_atompaw_incs}" != ""; then
    with_atompaw_incs="${cmd_with_atompaw_incs}"
  fi

  if test "${cmd_with_atompaw_libs}" != ""; then
    with_atompaw_libs="${cmd_with_atompaw_libs}"
  fi

  if test "${cmd_with_bigdft_incs}" != ""; then
    with_bigdft_incs="${cmd_with_bigdft_incs}"
  fi

  if test "${cmd_with_bigdft_libs}" != ""; then
    with_bigdft_libs="${cmd_with_bigdft_libs}"
  fi

  if test "${cmd_with_config_file}" != ""; then
    with_config_file="${cmd_with_config_file}"
  fi

  if test "${cmd_with_dft_flavor}" != ""; then
    with_dft_flavor="${cmd_with_dft_flavor}"
  fi

  if test "${cmd_with_etsf_io_incs}" != ""; then
    with_etsf_io_incs="${cmd_with_etsf_io_incs}"
  fi

  if test "${cmd_with_etsf_io_libs}" != ""; then
    with_etsf_io_libs="${cmd_with_etsf_io_libs}"
  fi

  if test "${cmd_with_fc_vendor}" != ""; then
    with_fc_vendor="${cmd_with_fc_vendor}"
  fi

  if test "${cmd_with_fc_version}" != ""; then
    with_fc_version="${cmd_with_fc_version}"
  fi

  if test "${cmd_with_fft_flavor}" != ""; then
    with_fft_flavor="${cmd_with_fft_flavor}"
  fi

  if test "${cmd_with_fft_incs}" != ""; then
    with_fft_incs="${cmd_with_fft_incs}"
  fi

  if test "${cmd_with_fft_libs}" != ""; then
    with_fft_libs="${cmd_with_fft_libs}"
  fi

  if test "${cmd_with_fox_incs}" != ""; then
    with_fox_incs="${cmd_with_fox_incs}"
  fi

  if test "${cmd_with_fox_libs}" != ""; then
    with_fox_libs="${cmd_with_fox_libs}"
  fi

  if test "${cmd_with_gpu_cflags}" != ""; then
    with_gpu_cflags="${cmd_with_gpu_cflags}"
  fi

  if test "${cmd_with_gpu_cppflags}" != ""; then
    with_gpu_cppflags="${cmd_with_gpu_cppflags}"
  fi

  if test "${cmd_with_gpu_flavor}" != ""; then
    with_gpu_flavor="${cmd_with_gpu_flavor}"
  fi

  if test "${cmd_with_gpu_incs}" != ""; then
    with_gpu_incs="${cmd_with_gpu_incs}"
  fi

  if test "${cmd_with_gpu_ldflags}" != ""; then
    with_gpu_ldflags="${cmd_with_gpu_ldflags}"
  fi

  if test "${cmd_with_gpu_libs}" != ""; then
    with_gpu_libs="${cmd_with_gpu_libs}"
  fi

  if test "${cmd_with_gpu_prefix}" != ""; then
    with_gpu_prefix="${cmd_with_gpu_prefix}"
  fi

  if test "${cmd_with_libpspio_incs}" != ""; then
    with_libpspio_incs="${cmd_with_libpspio_incs}"
  fi

  if test "${cmd_with_libpspio_libs}" != ""; then
    with_libpspio_libs="${cmd_with_libpspio_libs}"
  fi

  if test "${cmd_with_libxc_incs}" != ""; then
    with_libxc_incs="${cmd_with_libxc_incs}"
  fi

  if test "${cmd_with_libxc_libs}" != ""; then
    with_libxc_libs="${cmd_with_libxc_libs}"
  fi

  if test "${cmd_with_linalg_flavor}" != ""; then
    with_linalg_flavor="${cmd_with_linalg_flavor}"
  fi

  if test "${cmd_with_linalg_incs}" != ""; then
    with_linalg_incs="${cmd_with_linalg_incs}"
  fi

  if test "${cmd_with_linalg_libs}" != ""; then
    with_linalg_libs="${cmd_with_linalg_libs}"
  fi

  if test "${cmd_with_math_flavor}" != ""; then
    with_math_flavor="${cmd_with_math_flavor}"
  fi

  if test "${cmd_with_math_incs}" != ""; then
    with_math_incs="${cmd_with_math_incs}"
  fi

  if test "${cmd_with_math_libs}" != ""; then
    with_math_libs="${cmd_with_math_libs}"
  fi

  if test "${cmd_with_mpi_incs}" != ""; then
    with_mpi_incs="${cmd_with_mpi_incs}"
  fi

  if test "${cmd_with_mpi_level}" != ""; then
    with_mpi_level="${cmd_with_mpi_level}"
  fi

  if test "${cmd_with_mpi_libs}" != ""; then
    with_mpi_libs="${cmd_with_mpi_libs}"
  fi

  if test "${cmd_with_mpi_prefix}" != ""; then
    with_mpi_prefix="${cmd_with_mpi_prefix}"
  fi

  if test "${cmd_with_netcdf_incs}" != ""; then
    with_netcdf_incs="${cmd_with_netcdf_incs}"
  fi

  if test "${cmd_with_netcdf_libs}" != ""; then
    with_netcdf_libs="${cmd_with_netcdf_libs}"
  fi

  if test "${cmd_with_tardir}" != ""; then
    with_tardir="${cmd_with_tardir}"
  fi

  if test "${cmd_with_timer_flavor}" != ""; then
    with_timer_flavor="${cmd_with_timer_flavor}"
  fi

  if test "${cmd_with_timer_incs}" != ""; then
    with_timer_incs="${cmd_with_timer_incs}"
  fi

  if test "${cmd_with_timer_libs}" != ""; then
    with_timer_libs="${cmd_with_timer_libs}"
  fi

  if test "${cmd_with_trio_flavor}" != ""; then
    with_trio_flavor="${cmd_with_trio_flavor}"
  fi

  if test "${cmd_with_wannier90_bins}" != ""; then
    with_wannier90_bins="${cmd_with_wannier90_bins}"
  fi

  if test "${cmd_with_wannier90_incs}" != ""; then
    with_wannier90_incs="${cmd_with_wannier90_incs}"
  fi

  if test "${cmd_with_wannier90_libs}" != ""; then
    with_wannier90_libs="${cmd_with_wannier90_libs}"
  fi

  if test "${cmd_with_yaml_incs}" != ""; then
    with_yaml_incs="${cmd_with_yaml_incs}"
  fi

  if test "${cmd_with_yaml_libs}" != ""; then
    with_yaml_libs="${cmd_with_yaml_libs}"
  fi

  dnl
  dnl Prefix
  dnl
  if test "${cmd_prefix}" != ""; then
    prefix="${cmd_prefix}"
  fi
]) # ABI_OPTIONS_RECALL



dnl ABI_OPTIONS_CHANGED()
dnl ---------------------
dnl
dnl Display changes of user interface between versions and warns about
dnl obsolete uses.
dnl
AC_DEFUN([ABI_OPTIONS_CHANGED],[
  AC_MSG_NOTICE([reporting user interface changes:])

  dnl Removed --enable-bindings option
  if test "${enable_bindings}" != ""; then
    AC_MSG_ERROR([removed option --enable-bindings has been used])
  fi

  dnl Removed --enable-dev-timer option
  if test "${enable_dev_timer}" != ""; then
    AC_MSG_ERROR([removed option --enable-dev-timer has been used])
  fi

  dnl Removed --enable-gui option
  if test "${enable_gui}" != ""; then
    AC_MSG_ERROR([removed option --enable-gui has been used])
  fi

  dnl Removed --enable-gui-build option
  if test "${enable_gui_build}" != ""; then
    AC_MSG_ERROR([removed option --enable-gui-build has been used])
  fi

  dnl Removed --enable-mpi-trace option
  if test "${enable_mpi_trace}" != ""; then
    AC_MSG_ERROR([removed option --enable-mpi-trace has been used])
  fi

  dnl Removed --enable-pkg-check option
  if test "${enable_pkg_check}" != ""; then
    AC_MSG_ERROR([removed option --enable-pkg-check has been used])
  fi

  dnl Removed --enable-test-timeout option
  if test "${enable_test_timeout}" != ""; then
    AC_MSG_ERROR([removed option --enable-test-timeout has been used])
  fi

  dnl Removed --with-test-timeout option
  if test "${with_test_timeout}" != ""; then
    AC_MSG_ERROR([removed option --with-test-timeout has been used])
  fi

]) dnl ABI_OPTIONS_CHANGED



dnl ABI_OPTIONS_PARSE()
dnl -------------------
dnl
dnl Parses command-line arguments.
dnl
AC_DEFUN([ABI_OPTIONS_PARSE],[
  AC_REQUIRE([AC_PROG_EGREP])
  AC_MSG_NOTICE([parsing command-line options])

  dnl Parse enable_64bit_flags
  if test "${enable_64bit_flags}" != ""; then
    for v in `echo "${enable_64bit_flags}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_64bit_flags = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_64bit_flags = ${v}])
    fi
  fi

  dnl Hidden option: enable_atompaw
  dnl ac_configure_args="${ac_configure_args} --enable-atompaw=\"${enable_atompaw}\""
  enable_atompaw="no"

  dnl Hidden option: enable_bigdft
  dnl ac_configure_args="${ac_configure_args} --enable-bigdft=\"${enable_bigdft}\""
  enable_bigdft="no"

  dnl Parse enable_bse_unpacked
  if test "${enable_bse_unpacked}" != ""; then
    for v in `echo "${enable_bse_unpacked}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_bse_unpacked = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_bse_unpacked = ${v}])
    fi
  fi

  dnl Parse enable_cclock
  if test "${enable_cclock}" != ""; then
    for v in `echo "${enable_cclock}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_cclock = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_cclock = ${v}])
    fi
  fi

  dnl Parse enable_clib
  if test "${enable_clib}" != ""; then
    for v in `echo "${enable_clib}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_clib = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_clib = ${v}])
    fi
  fi

  dnl Parse enable_config_file
  if test "${enable_config_file}" != ""; then
    for v in `echo "${enable_config_file}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_config_file = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_config_file = ${v}])
    fi
  fi

  dnl Parse enable_connectors
  if test "${enable_connectors}" != ""; then
    for v in `echo "${enable_connectors}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_connectors = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_connectors = ${v}])
    fi
  fi

  dnl Parse enable_debug
  if test "${enable_debug}" != ""; then
    for v in `echo "${enable_debug}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes basic verbose enhanced paranoid naughty; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_debug = (no|yes|basic|verbose|enhanced|paranoid|naughty)])
      AC_MSG_ERROR([invalid option: enable_debug = ${v}])
    fi
  fi

  dnl Hidden option: enable_etsf_io
  dnl ac_configure_args="${ac_configure_args} --enable-etsf-io=\"${enable_etsf_io}\""
  enable_etsf_io="no"

  dnl Parse enable_exports
  if test "${enable_exports}" != ""; then
    for v in `echo "${enable_exports}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_exports = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_exports = ${v}])
    fi
  fi

  dnl Parse enable_fallbacks
  if test "${enable_fallbacks}" != ""; then
    for v in `echo "${enable_fallbacks}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes force; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fallbacks = (no|yes|force)])
      AC_MSG_ERROR([invalid option: enable_fallbacks = ${v}])
    fi
  fi

  dnl Parse enable_fast_check
  if test "${enable_fast_check}" != ""; then
    for v in `echo "${enable_fast_check}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fast_check = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_fast_check = ${v}])
    fi
  fi

  dnl Parse enable_fc_wrapper
  if test "${enable_fc_wrapper}" != ""; then
    for v in `echo "${enable_fc_wrapper}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fc_wrapper = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_fc_wrapper = ${v}])
    fi
  fi

  dnl Hidden option: enable_fox
  dnl ac_configure_args="${ac_configure_args} --enable-fox=\"${enable_fox}\""
  enable_fox="no"

  dnl Parse enable_gpu
  if test "${enable_gpu}" != ""; then
    for v in `echo "${enable_gpu}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gpu = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gpu = ${v}])
    fi
  fi

  dnl Parse enable_gw_dpc
  if test "${enable_gw_dpc}" != ""; then
    for v in `echo "${enable_gw_dpc}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gw_dpc = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gw_dpc = ${v}])
    fi
  fi

  dnl Parse enable_hints
  if test "${enable_hints}" != ""; then
    for v in `echo "${enable_hints}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_hints = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_hints = ${v}])
    fi
  fi

  dnl Hidden option: enable_libpaw
  dnl ac_configure_args="${ac_configure_args} --enable-libpaw=\"${enable_libpaw}\""
  enable_libpaw="yes"

  dnl Hidden option: enable_libxc
  dnl ac_configure_args="${ac_configure_args} --enable-libxc=\"${enable_libxc}\""
  enable_libxc="no"

  dnl Hidden option: enable_linalg
  dnl ac_configure_args="${ac_configure_args} --enable-linalg=\"${enable_linalg}\""
  enable_linalg="no"

  dnl Parse enable_lotf
  if test "${enable_lotf}" != ""; then
    for v in `echo "${enable_lotf}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_lotf = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_lotf = ${v}])
    fi
  fi

  dnl Parse enable_macroave
  if test "${enable_macroave}" != ""; then
    for v in `echo "${enable_macroave}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_macroave = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_macroave = ${v}])
    fi
  fi

  dnl Parse enable_maintainer_checks
  if test "${enable_maintainer_checks}" != ""; then
    for v in `echo "${enable_maintainer_checks}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_maintainer_checks = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_maintainer_checks = ${v}])
    fi
  fi

  dnl Parse enable_memory_profiling
  if test "${enable_memory_profiling}" != ""; then
    for v in `echo "${enable_memory_profiling}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_memory_profiling = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_memory_profiling = ${v}])
    fi
  fi

  dnl Parse enable_mpi
  if test "${enable_mpi}" != ""; then
    for v in `echo "${enable_mpi}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes auto; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi = (no|yes|auto)])
      AC_MSG_ERROR([invalid option: enable_mpi = ${v}])
    fi
  fi

  dnl Parse enable_mpi_inplace
  if test "${enable_mpi_inplace}" != ""; then
    for v in `echo "${enable_mpi_inplace}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_inplace = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi_inplace = ${v}])
    fi
  fi

  dnl Parse enable_mpi_io
  if test "${enable_mpi_io}" != ""; then
    for v in `echo "${enable_mpi_io}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes auto; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_io = (no|yes|auto)])
      AC_MSG_ERROR([invalid option: enable_mpi_io = ${v}])
    fi
  fi

  dnl Hidden option: enable_netcdf
  dnl ac_configure_args="${ac_configure_args} --enable-netcdf=\"${enable_netcdf}\""
  enable_netcdf="no"

  dnl Parse enable_openmp
  if test "${enable_openmp}" != ""; then
    for v in `echo "${enable_openmp}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_openmp = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_openmp = ${v}])
    fi
  fi

  dnl Parse enable_optim
  if test "${enable_optim}" != ""; then
    for v in `echo "${enable_optim}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes safe standard aggressive; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_optim = (no|yes|safe|standard|aggressive)])
      AC_MSG_ERROR([invalid option: enable_optim = ${v}])
    fi
  fi

  dnl Parse enable_stdin
  if test "${enable_stdin}" != ""; then
    for v in `echo "${enable_stdin}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_stdin = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_stdin = ${v}])
    fi
  fi

  dnl Hidden option: enable_wannier90
  dnl ac_configure_args="${ac_configure_args} --enable-wannier90=\"${enable_wannier90}\""
  enable_wannier90="no"

  dnl Parse enable_zdot_bugfix
  if test "${enable_zdot_bugfix}" != ""; then
    for v in `echo "${enable_zdot_bugfix}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_zdot_bugfix = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_zdot_bugfix = ${v}])
    fi
  fi

  dnl Parse with_algo_flavor
  dnl FIXME: NOT IMPLEMENTED!

  dnl Parse with_algo_incs
 if test "${with_algo_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_algo_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_algo_incs: ${v}])
    fi
  fi

  dnl Parse with_algo_libs
 if test "${with_algo_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_algo_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_algo_libs: ${v}])
    fi
  fi

  dnl Parse with_atompaw_incs
 if test "${with_atompaw_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_atompaw_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_atompaw_incs: ${v}])
    fi
  fi

  dnl Parse with_atompaw_libs
 if test "${with_atompaw_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_atompaw_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_atompaw_libs: ${v}])
    fi
  fi

  dnl Parse with_bigdft_incs
 if test "${with_bigdft_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_bigdft_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_bigdft_incs: ${v}])
    fi
  fi

  dnl Parse with_bigdft_libs
 if test "${with_bigdft_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_bigdft_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_bigdft_libs: ${v}])
    fi
  fi

  dnl Parse with_dft_flavor
  if test "${with_dft_flavor}" != ""; then
    for v in `echo "${with_dft_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in atompaw atompaw-fallback bigdft bigdft-fallback libxc libxc-fallback none wannier90 wannier90-fallback; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_dft_flavor = (atompaw|atompaw-fallback|bigdft|bigdft-fallback|libxc|libxc-fallback|none|wannier90|wannier90-fallback)])
      AC_MSG_ERROR([invalid option: with_dft_flavor = ${v}])
    fi
  fi

  dnl Parse with_etsf_io_incs
 if test "${with_etsf_io_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_etsf_io_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_etsf_io_incs: ${v}])
    fi
  fi

  dnl Parse with_etsf_io_libs
 if test "${with_etsf_io_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_etsf_io_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_etsf_io_libs: ${v}])
    fi
  fi

  dnl Parse with_fft_flavor
  if test "${with_fft_flavor}" != ""; then
    for v in `echo "${with_fft_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in asl custom fftw2 fftw2-threads fftw3 fftw3-mkl fftw3-threads fftw3-mpi none sgimath dfti dfti-threads; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_fft_flavor = (asl|custom|fftw2|fftw2-threads|fftw3|fftw3-mkl|fftw3-threads|fftw3-mpi|none|sgimath|dfti|dfti-threads)])
      AC_MSG_ERROR([invalid option: with_fft_flavor = ${v}])
    fi
  fi

  dnl Parse with_fft_incs
 if test "${with_fft_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_fft_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_fft_incs: ${v}])
    fi
  fi

  dnl Parse with_fft_libs
 if test "${with_fft_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_fft_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_fft_libs: ${v}])
    fi
  fi

  dnl Parse with_fox_incs
 if test "${with_fox_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_fox_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_fox_incs: ${v}])
    fi
  fi

  dnl Parse with_fox_libs
 if test "${with_fox_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_fox_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_fox_libs: ${v}])
    fi
  fi

  dnl Parse with_gpu_flavor
  if test "${with_gpu_flavor}" != ""; then
    for v in `echo "${with_gpu_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in cuda-single cuda-double none; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_gpu_flavor = (cuda-single|cuda-double|none)])
      AC_MSG_ERROR([invalid option: with_gpu_flavor = ${v}])
    fi
  fi

  dnl Parse with_gpu_incs
 if test "${with_gpu_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_gpu_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_gpu_incs: ${v}])
    fi
  fi

  dnl Parse with_gpu_libs
 if test "${with_gpu_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_gpu_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_gpu_libs: ${v}])
    fi
  fi

  dnl Parse with_libpspio_incs
 if test "${with_libpspio_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_libpspio_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_libpspio_incs: ${v}])
    fi
  fi

  dnl Parse with_libpspio_libs
 if test "${with_libpspio_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_libpspio_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_libpspio_libs: ${v}])
    fi
  fi

  dnl Parse with_libxc_incs
 if test "${with_libxc_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_libxc_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_libxc_incs: ${v}])
    fi
  fi

  dnl Parse with_libxc_libs
 if test "${with_libxc_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_libxc_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_libxc_libs: ${v}])
    fi
  fi

  dnl Parse with_linalg_flavor
  if test "${with_linalg_flavor}" != ""; then
    for v in `echo "${with_linalg_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in acml asl atlas custom elpa essl goto magma mkl mlib netlib netlib-fallback none plasma scalapack sgimath sunperf; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_linalg_flavor = (acml|asl|atlas|custom|elpa|essl|goto|magma|mkl|mlib|netlib|netlib-fallback|none|plasma|scalapack|sgimath|sunperf)])
      AC_MSG_ERROR([invalid option: with_linalg_flavor = ${v}])
    fi
  fi

  dnl Parse with_linalg_incs
 if test "${with_linalg_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_linalg_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_linalg_incs: ${v}])
    fi
  fi

  dnl Parse with_linalg_libs
 if test "${with_linalg_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_linalg_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_linalg_libs: ${v}])
    fi
  fi

  dnl Parse with_math_flavor
  if test "${with_math_flavor}" != ""; then
    for v in `echo "${with_math_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in gsl mlib none; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_math_flavor = (gsl|mlib|none)])
      AC_MSG_ERROR([invalid option: with_math_flavor = ${v}])
    fi
  fi

  dnl Parse with_math_incs
 if test "${with_math_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_math_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_math_incs: ${v}])
    fi
  fi

  dnl Parse with_math_libs
 if test "${with_math_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_math_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_math_libs: ${v}])
    fi
  fi

  dnl Parse with_mpi_incs
 if test "${with_mpi_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_mpi_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_mpi_incs: ${v}])
    fi
  fi

  dnl Parse with_mpi_level
  if test "${with_mpi_level}" != ""; then
    for v in `echo "${with_mpi_level}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in 1 2; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_mpi_level = (1|2)])
      AC_MSG_ERROR([invalid option: with_mpi_level = ${v}])
    fi
  fi

  dnl Parse with_mpi_libs
 if test "${with_mpi_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_mpi_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_mpi_libs: ${v}])
    fi
  fi

  dnl Parse with_netcdf_incs
 if test "${with_netcdf_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_netcdf_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_netcdf_incs: ${v}])
    fi
  fi

  dnl Parse with_netcdf_libs
 if test "${with_netcdf_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_netcdf_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_netcdf_libs: ${v}])
    fi
  fi

  dnl Parse with_timer_flavor
  if test "${with_timer_flavor}" != ""; then
    for v in `echo "${with_timer_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in abinit gptl none papi; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_timer_flavor = (abinit|gptl|none|papi)])
      AC_MSG_ERROR([invalid option: with_timer_flavor = ${v}])
    fi
  fi

  dnl Parse with_timer_incs
 if test "${with_timer_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_timer_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_timer_incs: ${v}])
    fi
  fi

  dnl Parse with_timer_libs
 if test "${with_timer_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_timer_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_timer_libs: ${v}])
    fi
  fi

  dnl Parse with_trio_flavor
  if test "${with_trio_flavor}" != ""; then
    for v in `echo "${with_trio_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in etsf_io etsf_io-fallback fox fox-fallback libpspio netcdf netcdf-fallback yaml none; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_trio_flavor = (etsf_io|etsf_io-fallback|fox|fox-fallback|libpspio|netcdf|netcdf-fallback|yaml|none)])
      AC_MSG_ERROR([invalid option: with_trio_flavor = ${v}])
    fi
  fi

  dnl Parse with_wannier90_incs
 if test "${with_wannier90_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_wannier90_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_wannier90_incs: ${v}])
    fi
  fi

  dnl Parse with_wannier90_libs
 if test "${with_wannier90_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_wannier90_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_wannier90_libs: ${v}])
    fi
  fi

  dnl Parse with_yaml_incs
 if test "${with_yaml_incs}" != ""; then
    opt_ok="yes"
    for v in ${with_yaml_incs}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_yaml_incs: ${v}])
    fi
  fi

  dnl Parse with_yaml_libs
 if test "${with_yaml_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_yaml_libs}; do
      if test "`echo "${v}" | grep '^-[[LloW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_yaml_libs: ${v}])
    fi
  fi

]) dnl ABI_OPTIONS_PARSE



dnl ABI_OPTIONS_TRIGGERS()
dnl ----------------------
dnl
dnl Set triggers associated to 'enable_*' options (AC_DEFINE and
dnl AM_CONDTIONAL).
dnl
AC_DEFUN([ABI_OPTIONS_TRIGGERS],[
  AC_MSG_NOTICE([setting triggers associated to command-line options])


  dnl Triggers for enable_bse_unpacked
  AC_MSG_CHECKING([whether to activate Bethe-Salpeter unpacking (EXPERIMENTAL)])
  AC_MSG_RESULT([${enable_bse_unpacked}])

  if test "${enable_bse_unpacked}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_BSE_UNPACKED' preprocessing macro])
    AC_DEFINE([HAVE_BSE_UNPACKED],1,
      [Define to 1 if you want to activate Bethe-Salpeter unpacking (EXPERIMENTAL).])
  fi

  dnl Triggers for enable_clib
  AC_MSG_CHECKING([whether to enable the Abinit C library (EXPERIMENTAL)])
  AC_MSG_RESULT([${enable_clib}])

  if test "${enable_clib}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_02_CLIB' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_02_CLIB],[test "${enable_clib}" = "yes"])
  if test "${enable_clib}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_CLIB' preprocessing macro])
    AC_DEFINE([HAVE_CLIB],1,
      [Define to 1 if you want to enable the Abinit C library (EXPERIMENTAL).])
  fi

  dnl Triggers for enable_exports
  AC_MSG_CHECKING([whether to activate build of exported libraries (EXPERIMENTAL)])
  AC_MSG_RESULT([${enable_exports}])

  if test "${enable_exports}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_EXPORTS' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_EXPORTS],[test "${enable_exports}" = "yes"])

  dnl Triggers for enable_gw_dpc
  AC_MSG_CHECKING([whether to activate double-precision GW calculations (EXPERIMENTAL)])
  AC_MSG_RESULT([${enable_gw_dpc}])

  if test "${enable_gw_dpc}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_GW_DPC' preprocessing macro])
    AC_DEFINE([HAVE_GW_DPC],1,
      [Define to 1 if you want to activate double-precision GW calculations (EXPERIMENTAL).])
  fi

  dnl Triggers for enable_libpaw
  AC_MSG_CHECKING([whether to activate internal support for libPAW in ABINIT])
  AC_MSG_RESULT([${enable_libpaw}])

  if test "${enable_libpaw}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LIBPAW_ABINIT' preprocessing macro])
    AC_DEFINE([HAVE_LIBPAW_ABINIT],1,
      [Define to 1 if you want to activate internal support for libPAW in ABINIT.])
  fi

  dnl Triggers for enable_lotf
  AC_MSG_CHECKING([whether to activate LOTF functionality (EXPERIMENTAL)])
  AC_MSG_RESULT([${enable_lotf}])

  if test "${enable_lotf}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_65_LOTF_BASE' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_65_LOTF_BASE],[test "${enable_lotf}" = "yes"])
  if test "${enable_lotf}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_68_LOTF' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_68_LOTF],[test "${enable_lotf}" = "yes"])
  if test "${enable_lotf}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LOTF' preprocessing macro])
    AC_DEFINE([HAVE_LOTF],1,
      [Define to 1 if you want to activate LOTF functionality (EXPERIMENTAL).])
  fi

  dnl Triggers for enable_macroave
  AC_MSG_CHECKING([whether to enable build of macroave (EXPERIMENTAL)])
  AC_MSG_RESULT([${enable_macroave}])

  if test "${enable_macroave}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_01_MACROAVNEW_EXT' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_01_MACROAVNEW_EXT],[test "${enable_macroave}" = "yes"])
  if test "${enable_macroave}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_MACROAVE' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_MACROAVE],[test "${enable_macroave}" = "yes"])
  if test "${enable_macroave}" = "yes"; then
    AC_MSG_NOTICE([defining the 'USE_MACROAVE' preprocessing macro])
    AC_DEFINE([USE_MACROAVE],1,
      [Define to 1 if you want to enable build of macroave (EXPERIMENTAL).])
  fi

  dnl Triggers for enable_memory_profiling
  AC_MSG_CHECKING([whether to enable memory profiling])
  AC_MSG_RESULT([${enable_memory_profiling}])

  if test "${enable_memory_profiling}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MEM_PROFILING' preprocessing macro])
    AC_DEFINE([HAVE_MEM_PROFILING],1,
      [Define to 1 if you want to enable memory profiling.])
  fi

  dnl Triggers for enable_mpi_inplace
  AC_MSG_CHECKING([whether to activate support for MPI_IN_PLACE])
  AC_MSG_RESULT([${enable_mpi_inplace}])

  if test "${enable_mpi_inplace}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MPI2_INPLACE' preprocessing macro])
    AC_DEFINE([HAVE_MPI2_INPLACE],1,
      [Define to 1 if you want to activate support for MPI_IN_PLACE.])
  fi

  dnl Triggers for enable_openmp
  AC_MSG_CHECKING([whether to activate support for OpenMP (EXPERIMENTAL)])
  AC_MSG_RESULT([${enable_openmp}])

  if test "${enable_openmp}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_OPENMP' preprocessing macro])
    AC_DEFINE([HAVE_OPENMP],1,
      [Define to 1 if you want to activate support for OpenMP (EXPERIMENTAL).])
  fi

  dnl Triggers for enable_stdin
  AC_MSG_CHECKING([whether to tell Abinit to read file lists from standard input])
  AC_MSG_RESULT([${enable_stdin}])

  if test "${enable_stdin}" = "no"; then
    AC_MSG_NOTICE([defining the 'READ_FROM_FILE' preprocessing macro])
    AC_DEFINE([READ_FROM_FILE],1,
      [Define to 1 if you want to tell Abinit to read file lists from standard input.])
  fi

  dnl Triggers for enable_zdot_bugfix
  AC_MSG_CHECKING([whether to activate workaround for bugged ZDOTC and ZDOTU])
  AC_MSG_RESULT([${enable_zdot_bugfix}])

  if test "${enable_zdot_bugfix}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LINALG_ZDOTC_BUG' preprocessing macro])
    AC_DEFINE([HAVE_LINALG_ZDOTC_BUG],1,
      [Define to 1 if you want to activate workaround for bugged ZDOTC and ZDOTU.])
  fi
  if test "${enable_zdot_bugfix}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LINALG_ZDOTU_BUG' preprocessing macro])
    AC_DEFINE([HAVE_LINALG_ZDOTU_BUG],1,
      [Define to 1 if you want to activate workaround for bugged ZDOTC and ZDOTU.])
  fi
]) dnl ABI_OPTIONS_TRIGGERS
