#!/usr/bin/env python
"Check build docs"

import tempfile
from subprocess import Popen
import commands
import string
import os
import re
import sys

# ---------------------------------------------------------------------------- #
def abitest(abenv, *args, **kwargs):
  return main(home_dir=abenv.home_dir)

def main(home_dir=""):
  # Create pdf docs
  sys.stdout.write("Begin to create pdf docs in doc/...\n")

  cmd = "cd doc && make pdf-docs"
  ou = tempfile.TemporaryFile()
  er = tempfile.TemporaryFile()
  process = Popen( cmd, shell=True, stdout=ou, stderr=er )
  process.wait()
  process.communicate()
  rc=process.returncode
  if rc != 0:
     ou.seek(0)
     er.seek(0)
     sys.stdout.write("%s\n" % ou.read())
     sys.stderr.write("%s\n" % er.read())
     ou.close()
     er.close()
     retval = 1
     return retval

  ou.close()
  er.close()
  sys.stdout.write("Completed : success\n\nCounting...\n")

  # Test the number of pdf files generated
  # Init
  Input_file = "tests/buildsys/Input/Num_pfd_docs"
  num_of_pdf = int(commands.getoutput("cat "+ Input_file))
  pdf_count  = 0
  retval     = 0

  for (root, dirs, files) in os.walk("doc"):
    for item in files:
      if ( re.search("\.pdf$", item) ): pdf_count += 1

  sys.stdout.write("Number of pdf docs is %s ( expected : %s)\n" % (pdf_count, num_of_pdf) )

  if pdf_count < num_of_pdf:
      sys.stderr.write("Number of pdf docs is %s ( expected : %s)\n" % (pdf_count, num_of_pdf) )
      retval = 1
  return retval

if __name__ == "__main__":
  if len(sys.argv) == 1: 
    home_dir = "."
  else:
    home_dir = sys.argv[1] 

  exit_status = main(home_dir)
  sys.exit(exit_status)
