# sh script for running various tests of abinit
# Actually run different instances of the Run script.
# See the latter script for more information.

# Copyright (C) 2002-2012 ABINIT group (XG,LSi,YPouillon)
# This file is distributed under the terms of the
# GNU General Public License, see ~abinit/COPYING
# or http://www.gnu.org/copyleft/gpl.txt .
# For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
#
# Usage under sh-shell:
# ( wrap-parallel-tests machine_name [ seq | seqpar | gw | mpiio | tutoparal | scalapack | cuda ] ) >& log_file
#
# For example :
# ( wrap-parallel-tests ibm_pcpm seq) >& log_file
#
# The list of allowed machine names is mentioned in the run-parallel-tests
# script.
#

set -e

# Init
my_name="wrap-parallel-tests"
my_cnffile="./tests.env"
paral_sets="A B C D E F G H I J K L M N O P R T U V X Y AA AB AC AD AE AF AH"
gw_sets="M N O U V"
mpiio_sets="A P Q R T X Y AG AI"
scalapack_sets="A"
cuda_sets="A"
tutoparal_sets="dfpt_03 dfpt_04"
# Set-up environment
if test -s "${my_cnffile}"; then
  . ${my_cnffile}
else
  echo "${my_name}: ${my_cnffile} not found - aborting now" >&2
  exit 1
fi

# Finish init
run_parallel_tests="${PERL} ${abinit_rundir}/run-parallel-tests.pl"
run_charge_tests="${BOURNE_SHELL} ${abinit_rundir}/run-charge-tests.sh"

# Check arguments
if test "${#}" -lt "2"; then
  echo "Usage: ${my_name} machine_name ( seq | seqpar | gw | mpiio | tutoparal | scalapack | cuda )"
  echo ""
  echo "Two arguments must be provided giving machine name and test suite"
  echo ""
  echo "Note : in case you called ${my_name} from the make, the syntax is"
  echo " make tests_paral paral_host=machine_name paral_mode=( seq |seqpar)"
  exit 0
fi

# Set machine name
machine_name="${1}"

# Select test type
case "${2}" in

  seq)
    echo "Running in serial mode"
    my_mode="s"
    my_tests="0"
    my_test_dir="paral"
    my_sets=${paral_sets}
    ;;

  seqpar)
    echo "Running in parallel mode"
    my_mode="p"
    my_tests=""
    my_test_dir="paral"
    my_sets=${paral_sets}
    ;;

  gw)
    echo "Running GW tests in parallel"
    my_mode="p"
    my_tests=""
    my_test_dir="paral"
    my_sets=${gw_sets}
    ;;

  mpiio)
    echo "Running in parallel+mpiio mode"
    my_mode="p"
    my_tests=""
    my_test_dir="mpiio"
    my_sets=${mpiio_sets}
    ;;

  tutoparal)
    echo "Running in parallel mode"
    my_mode="p"
    my_tests=""
    my_test_dir="tutoparal"
    my_sets=${tutoparal_sets}
    ;;

  scalapack)
    echo "Running in parallel+scalapack mode"
    my_mode="p"
    my_tests=""
    my_test_dir="scalapack"
    my_sets=${scalapack_sets}
    ;;

  cuda)
    echo "Running in parallel+cuda mode"
    my_mode="p"
    my_tests=""
    my_test_dir="cuda"
    my_sets=${cuda_sets}
    ;;

  *)
    echo "${my_name}: unrecognized argument: ${2}" >&2
    exit 2
    ;;

esac

# Toggle timeout support
if test "${use_timeout}" != "yes"; then
  timeout="0"
fi

# Prepare the way
if ! test -d "${abinit_outdir}/${my_test_dir}"; then
  mkdir "${abinit_outdir}/${my_test_dir}"
fi

cd "${abinit_outdir}/${my_test_dir}"
rm -rf ./tmp-runlog*

# Run all test sets
for my_set in ${my_sets}; do
  echo "Parallel tests set ${my_set}"
  (${run_parallel_tests} ${machine_name} ${my_test_dir} ${my_set} ${my_tests}) \
    1>tmp-runlog${my_set} 2>&1
done

# XG051126 Disabled charge test. I do not understand why it does not work
# on my machine ...
#(${run_charge_tests} ${machine_name}) 1>tmp-runlog9 2>tmp-stderr-9

# Create report when in parallel mode
if test "${my_mode}" = "p"; then
  echo "Parallel tests report"
  (${run_parallel_tests} ${machine_name} ${my_test_dir} report) 1>tmp-runreport 2>&1
fi
