# sh script for running various tests of abinit
# Actually run different instances of the Run script.
# See the latter script for more information.

# Copyright (C) 2002-2012 ABINIT group (XG,LSi,YPouillon)
# This file is distributed under the terms of the
# GNU General Public License, see ~abinit/COPYING
# or http://www.gnu.org/copyleft/gpl.txt .
# For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
#
# Usage under sh-shell:
# ( drive-parallel-tests machine_name testdir sets [cases] ) >& log_file
#
# For example :
# ( drive-parallel-tests sleepy mpiio A ) >& log_file
# ( drive-parallel-tests sleepy paral A-D ) >& log_file
# ( drive-parallel-tests sleepy paral A 0 ) >& log_file
# ( drive-parallel-tests sleepy paral A 1-2 ) >& log_file
#
# The list of allowed machine names is mentioned in the run-parallel-tests
# script. More information on the arguments is also provided in the same script.
#

set -e

# Init
my_name="drive-parallel-tests"
my_cnffile="tests.env"

# Check arguments
if test "${#}" -lt "3"; then
  echo "Usage: ${my_name} machine_name testdir sets [cases]"
  echo ""
  echo "Three arguments must be provided giving machine name, testdir, sets"
  exit 0
fi

# Set-up environment
if test -s "${my_cnffile}"; then
 . ${my_cnffile}
else
 echo "${my_name}: ${my_cnffile} not found - aborting now"
 exit 1
fi

# Finish init
machine_name="${1}"
testdir_name="${2}"
run_parallel_tests="${PERL} ${abinit_rundir}/run-parallel-tests.pl"

#DEBUG
echo "${abinit_outdir}/${2}"
echo "${run_parallel_tests} ${machine_name} ${testdir_name} ${3} ${4}"
#ENDDEBUG

cd "${abinit_outdir}/${2}"
(${run_parallel_tests} ${machine_name} ${testdir_name} ${3} ${4}) 1>tmp-log 2>&1

