!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_wfsinp_scratch
!! NAME
!! wvl_wfsinp_scratch
!!
!! FUNCTION
!! This method allocates and initialises wavefunctions with values from input guess.
!! See wvl_wfsinp_disk() or wvl_wfsinp_reformat() from other initialisation
!! routines.
!!
!! When initialised from scratch or from disk, wvl%wfs%[h]psi comes unallocated
!! and will be allocated inside this routine.
!! When initialised from memory (reformating), wvl%wfs%[h]psi will be reallocated.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  hdr0 <type(hdr_type)>=the header of wf, den and pot files (read from restart)
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  ireadwf=1 for reading from file, 0 otherwise.
!!  mpi_enreg=informations about MPI parallelization
!!  option=1 for reading a file following ABINIT format, -1 for a BigDFT format.
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  wff <type(wffile_type)>= structure with informations on wf file.
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  wvl <type(wvl_data)>=wavefunctions & projectors informations for wavelets.
!!  xred(3,natom)=reduced dimensionless atomic coordinates (in fact IN but here
!!                because of INOUT xredxcart() behavior).
!!
!! PARENTS
!!      inwffil
!!
!! CHILDREN
!!      input_wf_diag,mklocl_wavelets,wrtout,xred2xcart
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine wvl_wfsinp_scratch(dtset, mpi_enreg, rprimd, wvl, xred)

 use defs_basis
 use defs_abitypes
 use defs_wvltypes
 use m_wffile
 use m_profiling
 use m_errors
 use m_ab6_kpoints
 use m_ab6_symmetry
 use m_xmpi

#if defined HAVE_DFT_BIGDFT
 use BigDFT_API, only : createIonicPotential, input_wf_diag, gaussian_basis, &
      & input_variables, calculate_rhocore, deallocate_Lzd_except_Glr, INPUT_IG_OFF, &
      & SMEARING_DIST_FERMI, SMEARING_DIST_COLD1, SMEARING_DIST_COLD2, SMEARING_DIST_METPX, &
      & SMEARING_DIST_ERF
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'wvl_wfsinp_scratch'
 use interfaces_14_hidewrite
 use interfaces_41_geometry
 use interfaces_67_common
!End of the abilint section

  implicit none

!Arguments -------------------------------
  !scalars
  type(dataset_type), intent(in)        :: dtset
  type(MPI_type), intent(inout)         :: mpi_enreg
  type(wvl_data), intent(inout)         :: wvl
  !arrays
  real(dp), intent(in)                  :: rprimd(3, 3)
  real(dp), intent(inout)               :: xred(3, dtset%natom)

!Local variables-------------------------------
  character(len = 500)  :: message
  integer               :: comm,me,nproc
  integer               :: nvirt
  real(dp), allocatable :: xcart(:,:)
  real(dp), allocatable :: rhor(:,:)
  real(dp), pointer     :: vpsp(:)
  character(len = *), parameter :: subname = "wvl_wfsinp_scratch"
  real(dp):: elecfield(3)

#if defined HAVE_DFT_BIGDFT
  type(gaussian_basis) :: Gvirt
  
  ! To be removed, waiting for BigDFT upgrade.
  type(input_variables) :: in
#endif

! *********************************************************************

 elecfield=zero

 write(message, '(a,a)' ) ch10,&
& ' wvl_wfsinp_scratch: wavefunction initialisation.'
 call wrtout(std_out,message,'COLL')

#if defined HAVE_DFT_BIGDFT
 comm=mpi_enreg%comm_cell
 me=xcomm_rank(comm)
 nproc=xcomm_size(comm)
!Store xcart for each atom
 ABI_ALLOCATE(xcart,(3, dtset%natom))
 call xred2xcart(dtset%natom, rprimd, xcart, xred)

!We allocate temporary arrays for rho and vpsp.
!allocate ionic potential
 if (wvl%den%denspot%dpbox%n3pi > 0) then
   ABI_ALLOCATE(vpsp,(wvl%descr%Glr%d%n1i * wvl%descr%Glr%d%n2i * wvl%den%denspot%dpbox%n3pi))
 else
   ABI_ALLOCATE(vpsp,(1))
 end if
 call mklocl_wavelets(elecfield, dtset%icoulomb, xcart, mpi_enreg, dtset%natom, &
& dtset%nfft, dtset%nscforder, dtset%nspden, 1, rhor, rprimd, vpsp, &
& wvl%den, wvl%descr, xcart)

!This routine allocates psi, hpsi and psit.
 nvirt = 0
 in%linear = INPUT_IG_OFF
 in%nspin = dtset%nsppol
 in%exctxpar = wvl%descr%exctxpar
 in%itrpmax = dtset%nnsclo
 select case (dtset%occopt)
   case  (3)
     in%occopt = SMEARING_DIST_FERMI
   case  (4)
     in%occopt = SMEARING_DIST_COLD1
   case  (5)
     in%occopt = SMEARING_DIST_COLD2
   case  (6)
     in%occopt = SMEARING_DIST_METPX
   case default
     in%occopt = SMEARING_DIST_ERF
 end select
 in%iscf = dtset%iscf
 in%Tel = dtset%tsmear
 if (dtset%iscf == 0) in%Tel = zero
 in%SIC = wvl%wfs%ks%SIC
 in%orthpar = wvl%wfs%ks%orthpar

!Note: check if all required in "in" is passed.
!remove argument "in" from input_wf_diag
 call input_wf_diag(me, nproc, &
& wvl%descr%atoms, wvl%den%denspot,&
& wvl%wfs%ks%orbs, nvirt, wvl%wfs%ks%comms, &
& wvl%wfs%ks%lzd, wvl%energs, xcart, &
& wvl%projectors%nlpspd, wvl%projectors%proj, &
& dtset%ixc, wvl%wfs%ks%psi, wvl%wfs%ks%hpsi, wvl%wfs%ks%psit, &
& Gvirt, in%nspin, wvl%descr%atoms%sym, wvl%wfs%GPU, in)

 write(message, '(a)' ) &
& '  | wavefunctions have been calculated.'
 call wrtout(std_out,message,'COLL')

 ABI_DEALLOCATE(xcart)
 ABI_DEALLOCATE(vpsp)

#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_wfsinp_scratch: BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 MSG_ERROR(message)
#endif

end subroutine wvl_wfsinp_scratch
!!***

