!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_ucrpa
!! NAME
!! calc_ucrpa
!!
!! FUNCTION
!! Calculate the screening interaction in the corelated orbital

!! COPYRIGHT
!! Copyright (C) 1999-2012 ABINIT group (TApplencourt,BA)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! npw : number of plane wave
!! nomega  : number of frequencis
!! bandinf,bandsup : kohn sham band 
!! optimisation : string for the optimisation 
!! Wfd:: MPI communicator
!! mesh <BZ_mesh_type>
!!    %nbz=Number of points in the BZ
!!    %nibz=Number of points in IBZ
!!    %kibz(,nibz)=k-point coordinates, irreducible Brillouin zone
!!    %kbz(3,nbz)=k-point coordinates, full Brillouin zone
!!    %ktab(nbz)= table giving for each k-point in the BZ (kBZ), the corresponding
!!    %ktabi(nbz)= for each k-point in the BZ defines whether inversion has to be considered
!!    %ktabp(nbz)= phase factor associated to tnons
!! OUTPUT
!!
!! NOTES
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      affichage,checkk,cpu_time,get_bz_item,read_screening,sauvegarde_m_q_m
!!      transformation_m,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

 subroutine calc_ucrpa(Kmesh,npw,nomega,bandinf,bandsup,optimisation,ucvol,Wfd,fname)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_profiling
 use m_timer
 use m_xmpi
 use m_defs_ptgroups
 use m_errors
#ifdef HAVE_CLIB
 use m_clib
#endif

 use m_wfs,      only : wfs_descriptor
 use m_io_screening,  only : read_screening
 use m_bz_mesh,       only : bz_mesh_type, get_BZ_item

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'calc_ucrpa'
 use interfaces_14_hidewrite
 use interfaces_70_gw, except_this_one => calc_ucrpa
!End of the abilint section

 implicit none
!   _____            _
!  |_   _|          | |
!    | |  _ __  _ __  _   _| |_
!    | | | '_ \| '_ \| | | | __|
!   _| |_| | | | |_) | |_| | |_
!  |_____|_| |_| .__/ \__,_|\__|
!              | |
!              |_|

!Arguments ------------------------------------
 integer, intent(in)   :: npw
 integer, intent(in)   :: nomega
 integer, intent(in)   :: bandinf
 integer, intent(in)   :: bandsup
 character(len=fnlen), intent(in) :: fname
 character, intent(in) :: optimisation
 real(dp), intent(in) :: ucvol
 
 type(wfs_descriptor),intent(inout) :: Wfd
 type(BZ_mesh_type),intent(in) :: Kmesh
 
!Local variables ------------------------------
!scalars
 real(dp) :: x,y
 real(dp) :: tot,t1,t2
 real(dp):: tol,tol2,eVnorme,wk
 real(dp) :: binR
 
 complex :: nC,nCt
 
 integer :: m1,m2,m3,m4
 integer :: n1,n2,n3,n4,ni,nj
 integer :: ik_bz,ik_ibz,iq_ibz,i,j,iG1,iG2,iG,iiG,iomega,iband
 integer :: nkibz,nbband,nkbz,nqibz,mbband
 integer :: inverse_ik_bz
 integer :: isym_kgw,iik
 complex(dpc) ::ph_mkt
 
 logical ::  wannier=.TRUE.
 logical :: verbose=.FALSE.
 logical :: bug=.FALSE.
 
 character(len=500) :: message

!arrays
 complex(dpc), allocatable :: V_n(:,:,:,:)
 complex(dpc), allocatable :: V_m(:,:,:,:)
 complex(dpc), allocatable :: U_m(:,:,:,:)
 
 complex(dpc), allocatable :: coeffW_BZ(:,:,:),coeffW_IBZ(:,:,:)
 complex(dpc), allocatable :: M_qk_n(:,:,:,:,:),M_qk_m(:,:,:,:,:),M_q_m(:,:,:,:)
 complex(dpc), allocatable :: rhot_qk_m(:,:,:,:,:),rhot_qk_n(:,:,:,:,:),rhot_q_n(:,:,:,:),rhot_q_m(:,:,:,:)
 complex(gwpc), allocatable :: scr(:,:,:,:)
 
 real(dp),allocatable :: k_coord(:,:),k_coordIBZ(:,:)
 real(dp),allocatable :: q_coord(:,:)
 real(dp),allocatable:: normG(:)
 
 integer,allocatable:: ikmq_bz_t(:,:)
 
 logical,allocatable :: bijection(:)
!************************************************************************

 write(message,*) '==== Calculation of the screened interaction ===='
 call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 nkbz = Kmesh%nbz
 nqibz= Kmesh%nibz
 
 nbband=1+bandsup-bandinf
!  _  __            ____
! | |/ /   ___     / __ \
! | ' /   ( _ )   | |  | |
! |  <    / _ \/\ | |  | |
! | . \  | (_>  < | |__| |
! |_|\_\  \___/\/  \___\_\

 write(message,*) "Read K and Q mesh"
 call wrtout(std_out,message,'COLL')
 call wrtout(ab_out,message,'COLL')
 
 ABI_ALLOCATE(k_coord,(nkbz,3))
 ABI_ALLOCATE(q_coord,(nqibz,4))


!==Read k and q==!
!open(unit=2012,file='ikbz_COORD',form='formatted',status='unknown')
!read(2012,*) (ik_bz,k_coord(ik_bz,:),i=1,nkbz)
!close(2012)

 do ik_bz=1,nkbz
   call get_BZ_item(Kmesh,ik_bz,&
&  k_coord(ik_bz,:),ik_ibz,isym_kgw,iik,ph_mkt)
 end do 
 
 open(unit=2012,file='iqbz_COORD',form='formatted',status='unknown')
 read(2012,*)
 do i=1,nqibz
   read(2012,*) iq_ibz,q_coord(iq_ibz,:)
   if (iq_ibz > nqibz) then
     write(message,*) iq_ibz,nqibz," Error on line",i,"Are you in iBZ ?"
     call wrtout(std_out,message,'COLL')
   end if
 end do
 close(2012)
 
!==Bijection and array for k-q==!
 ABI_ALLOCATE(bijection,(nkbz))
 ABI_ALLOCATE(ikmq_bz_t,(nkbz,nqibz))
 
 bijection(:)=.FALSE.
 do ik_bz=1,nkbz
   do iq_ibz=1,nqibz
   ikmq_bz_t(ik_bz,iq_ibz)=findkmq(ik_bz,k_coord,q_coord(iq_ibz,:),nkbz)
   if (ikmq_bz_t(ik_bz,iq_ibz)>nkbz) then
     BUG=.TRUE.
     write(message,*) "No K-Q for K/Q =",ik_bz,iq_ibz
     MSG_ERROR(message)
   end if
   bijection(ikmq_bz_t(ik_bz,iq_ibz))=.TRUE.
   end do 
 
   if (count(bijection).NE.nqibz) then
   BUG=.TRUE.
   write(message,*) 'No bijection ',ik_bz
   MSG_ERROR(message)
   end if
 
   bijection(:)=.FALSE.
 end do
 
 if (.NOT.BUG) then
   write(message,*)  "Bijection Ok."
   call wrtout(std_out,message,'COLL')
 end if
!                                           _____
!                                          / ____|
!   _ __   ___  _ __ _ __ ___   ___       | |  __
!  | '_ \ / _ \| '__| '_ ` _ \ / _ \      | | |_ |
!  | | | | (_) | |  | | | | | |  __/      | |__| |
!  |_| |_|\___/|_|  |_| |_| |_|\___|       \_____|

 ABI_ALLOCATE(normG,(npw))
 if (verbose) then
   write(message,*) 'Read the potential and G norm'
   call wrtout(std_out,message,'COLL')
   open(unit=2021,file='normG',form='formatted',status='unknown')
   read(2021,*) (iiG,x,normG(iiG),iG=1,npw)
   close(2021)
   !!False norme for G=0 idd G is the inverse of the potential inverse du potentiel (q=0)
   normG(1)=0
 end if
 
!                               _
!                              ( )
!   _ __ ___        _ __  _ __ |/
!  | '_ ` _ \      | '_ \| '_ \
!  | | | | | |     | | | | | | |
!  |_| |_| |_|     |_| |_|_| |_|
 
!==========================================================
!==Read M_G^(nn')(q,k)== in file Mnnp.ucrpa_SCR
!==========================================================
! tol=1E-1
! tolerance for the normalization of wfc: should be around 0.01.
 tol = 1 ! very large for test.
 ABI_ALLOCATE(M_qk_n,(bandinf:bandsup,bandinf:bandsup,npw,nqibz,nkbz))
 write(message,*) 'Check the norm of M'
 call wrtout(std_out,message,'COLL')
 write(message,*) 'Tolerance :',tol
 call wrtout(std_out,message,'COLL')
 write(message,*) ' Q=(0,0,0),G=0,n1=n2=21'
 call wrtout(std_out,message,'COLL')
 
 open(unit=2041,file='Mnnp.ucrpa_SCR',form='formatted',status='unknown')
 do i=1,nkbz*nqibz*nbband*nbband*npw
    read(2041,*) iG,ni,nj,ik_bz,iq_ibz,nC
    M_qk_n(ni,nj,iG,iq_ibz,ik_bz)=nC
 
   if (iq_ibz==1.AND.iG==1.AND.ni==nj.AND.abs(abs(nC)-1)>tol) then
     BUG=.TRUE.
!    write(6,*) iG,ni,nj,ik_bz,iq_ibz,nC
     write(message,*) "Norm fail for k",ik_bz,"and bands",ni,abs(nC)
     MSG_ERROR(message)
   end if
 
   if (modulo(ik_bz,10).EQ.1.AND.iq_ibz==1.AND.iG==1.AND.ni==21.AND.nj==21) then
     write(message,*) ik_bz,"/",nkbz,M_qk_n(ni,nj,1,1,ik_bz)
     call wrtout(std_out,message,'COLL')
   end if
 end do
 close(2041)
 
 
 if (.NOT.BUG) then
   write(message,*) "Norme check"
   call wrtout(std_out,message,'COLL')
 end if
 
 BUG=.FALSE.
 
 write(message,*)  'Read and check in',tot
 call wrtout(std_out,message,'COLL')
 
 if (verbose) then 
   !==Ecriture de M_(G=0)^(nn')(q,k=0)==!
   open(unit=2051,file='M_ninj(n=21_22_23)(q,k=0,G)',form='formatted',status='unknown')
   do iq_ibz=1,nqibz
   write(2051,*) iq_ibz,((abs(M_qk_n(i,j,1,iq_ibz,:)),i=bandinf,bandsup),j=bandinf,bandsup)
   end do
   close(2051)
 end if
!        _                             _
!       | |                           ( )
!   _ __| |__   ___        _ __  _ __ |/
!  | '__| '_ \ / _ \      | '_ \| '_ \
!  | |  | | | | (_) |     | | | | | | |
!  |_|  |_| |_|\___/      |_| |_|_| |_|
 
!M is correct we can read the rho
!==========================================================
!==Read Ro_G^(nn')(q,k) in file rhotwidle_SCR
!==========================================================
 ABI_ALLOCATE(rhot_qk_n,(bandinf:bandsup,bandinf:bandsup,npw,nqibz,nkbz))
 write(message,*) 'Read rhotwilde'
  call wrtout(std_out,message,'COLL')
  call wrtout(ab_out,message,'COLL')
 
!!Calcul of the "theorcial" rho
!!Cell volume
! tol2=ucvol
!!Volume of BZ
! tol=((2*3.1416)**3.0)/tol2
!!Formula
! tol=6.188*((tol/nkbz)**(-2.0/3))
!!4 Pi multiplication
! tol=(4*3.1416*tol)
 ! !Sqrt formule of rhotwidle
! tol=tol**0.5
! write(message,*) "Rhowtilde q=0, G=0 theorical",tol, "(Hartree^1/2)"
! call wrtout(std_out,message,'COLL')
! write(message,*) 'Q=(0,0,0), G=(0,0,0),n1=n2=22'
! call wrtout(std_out,message,'COLL')
 
 open(unit=2081,file='Rhotwg.ucrpa_SCR',form='formatted',status='unknown')
 do i=1,nkbz*nqibz*nbband*nbband*npw
   read(2081,*) iG,ni,nj,ik_bz,iq_ibz,nC
   rhot_qk_n(ni,nj,iG,iq_ibz,ik_bz)=nC
   if (modulo(ik_bz,10).EQ.1.AND.iq_ibz==1.AND.iG==1.AND.ni==nj.AND.nj==22) then
    write(message,*) ik_bz,"/",nkbz,rhot_qk_n(ni,nj,iG,iq_ibz,ik_bz)
    call wrtout(std_out,message,'COLL')
   end if
 end do
 close(2081)
 
 if (verbose) then 
   !==Write Ro_G^(nn')(q,k)==!
   ni=21
   eVnorme=sqrt(Ha_eV/(ucvol*nkbz))*1/nkbz
   open(unit=2019,file='Ro_qk_nn21(0,1&5)',form='formatted',status='unknown')
   do iG=1,npw
   write(2019,*) normG(iG),eVnorme*abs(rhot_qk_n(ni,ni,iG,1,1)),&
         &eVnorme*abs(rhot_qk_n(ni,ni,iG,1,5))
   end do
   close(2019)
 end if
 
!==Compute Ro_G^(nn')(q) 
 ABI_ALLOCATE(rhot_q_n,(bandinf:bandsup,bandinf:bandsup,npw,nqibz))
 
 rhot_q_n(:,:,:,:)=sum(rhot_qk_n(:,:,:,:,:),dim=5)/nkbz
 
!  __      __
!  \ \    / /
!   \ \  / /      _ __
!    \ \/ /      | '_ \
!     \  /       | | | |
!      \/        |_| |_|
!==========================================================
!==Compute V_{n,n'}
!==========================================================
 if(verbose) then
   write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
   write(message,*)  "==Calcul of the bare kohn-sham interaction V n=="; call wrtout(std_out,message,'COLL')
   call wrtout(ab_out,message,'COLL')
 endif
 
 ABI_ALLOCATE(V_n,(bandinf:bandsup,bandinf:bandsup,bandinf:bandsup,bandinf:bandsup))
 
 do n1=bandinf,bandsup
   do n2=bandinf,bandsup
     do n3=bandinf,bandsup
       do n4=bandinf,bandsup
           !! Sum_(iq_ibz) wi(iq_ibz)*Sum_ig  Rho(n3,n1,iG,iq)cong*Rho(n2,n4,ig,iq)
            V_n(n1,n2,n3,n4)=sum(q_coord(:,4)*&
&            sum(conjg(rhot_q_n(n3,n1,:,:))*rhot_q_n(n2,n4,:,:),dim = 1))*Ha_eV/(ucvol)
       end do
     end do
   end do
 end do
 
! tolerance for the symetry of U (should be around 0.01).
 tol=1E+1
 call Checkk(V_n,bandinf,bandsup,tol,0)
 
 if (verbose) then
   ni=21
   eVnorme=sqrt(Ha_eV/(ucvol*nkbz))
   open(unit=2091,file='Ro_q_nn21(0)',form='formatted',status='unknown')
   write(2091,*) "#U of 21 21",abs(V_n(bandinf,bandinf,bandinf,bandinf))
   do iG=1,npw
   write(2091,*) normG(iG),eVnorme*abs(rhot_q_n(ni,ni,iG,1))
   end do
   close(2091)
 end if
 ABI_DEALLOCATE(V_n)
 
 if (.NOT.WANNIER) RETURN
 
!
! \ \        / /       (_)
!  \ \  /\  / /_ _ _ __  _ __  _  ___ _ __
!   \ \/  \/ / _` | '_ \| '_ \| |/ _ \ '__|
!    \  /\  / (_| | | | | | | | |  __/ |
!     \/  \/ \__,_|_| |_|_| |_|_|\___|_|
 
!==========================================================
!== Read Wannier coefficient in forlb.ovlp
!==========================================================
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 write(message,*) "Read wannier in iBZ"
  call wrtout(ab_out,message,'COLL');call wrtout(std_out,message,'COLL')
 nkibz=nqibz
 
!Read "l"
 open(unit=2012,file='forlb.ovlp',form='formatted',status='unknown')
 rewind(2012)
 read(2012,*) message, mbband ;read(2012,*)
!!Read the bandinf, bandinf redondance information
 mbband=2*mbband+1
 
 ABI_ALLOCATE(coeffW_IBZ,(bandinf:bandsup,nkibz,mbband))
 
 
 do ik_ibz=1,nkibz
   !read k
    read(2012,*)
    do iband=bandinf,bandsup
   !read band
      read(2012,*)
   !read projection
      do m1=1,mbband
        read(2012,*) binR,binR,binR,x,y
        !write(message,*)  binR,binR,binR,x,y
        coeffW_IBZ(iband,ik_ibz,m1)=cmplx(x,y)
      end do
    end do
 end do
 close(2012)
      
 ABI_ALLOCATE(coeffW_BZ,(bandinf:bandsup,nkbz,mbband)) 
 
 if (nkbz==nkibz) then
   coeffW_BZ=coeffW_IBZ
 else
   write(message,*) "Recustruct in full BZ"
   call wrtout(std_out,message,'COLL')
   call wrtout(ab_out,message,'COLL')
   ABI_ALLOCATE(k_coordIBZ,(nkibz,3))
 
   k_coordIBZ(:,:)=q_coord(:,1:3)
 
   bijection(:)=.FALSE.
   write(message,*) "Indice in iBZ | Indice in BZ | Inverse in BZ"
   call wrtout(std_out,message,'COLL')
   do ik_ibz=1,nkibz
    ik_bz=fi(nkbz,k_coord,k_coordIBZ(ik_ibz,:))!indice dans BZ
 
    inverse_ik_bz=fi(nkbz,k_coord,-1*k_coord(ik_bz,:))     !Corespondance de l'inverse dans BZ
 
    if (inverse_ik_bz > nkbz.AND.ik_ibz.NE.1) then
      !Check if inverse do not exist because border of the BZ
      if (ANY(k_coordIBZ(ik_ibz,:).EQ.0.5)) then
      inverse_ik_bz=ik_bz
      else
      write(message,*) "The inverse of  k iBZ :",ik_ibz,"BZ :",ik_bz,"Coord",k_coordIBZ(ik_ibz,:),"not find"
      MSG_ERROR(message)
      end if
    end if     
    write(message,*) ik_ibz,ik_bz,inverse_ik_bz
    call wrtout(std_out,message,'COLL')
    
    coeffW_BZ(:,inverse_ik_bz,:)=conjg(coeffW_IBZ(:,ik_ibz,:))
    coeffW_BZ(:,ik_bz,:)=coeffW_IBZ(:,ik_ibz,:)
    
    bijection(ik_bz)=.TRUE.
    bijection(inverse_ik_bz)=.TRUE.
   end do
   
   if (count(bijection).NE.nkbz) then
    BUG=.TRUE.
    write(message,*) 'Miss somme K point for the Wannier',count(bijection),"/",nkbz
    MSG_ERROR(message)
   end if
   
   if (.NOT.BUG) then
     write(message,*) "Reconstruction Success"
     call wrtout(std_out,message,'COLL')
     call wrtout(ab_out,message,'COLL')
   end if
   ABI_DEALLOCATE(k_coordIBZ)
 end if
 
 ABI_DEALLOCATE(coeffW_IBZ)
 
 wk=1.0/nkbz
 
 write(message,*) 'Orthogonality check'
 call wrtout(std_out,message,'COLL')
 write(message,*)  'Sum on all the k point ,on all the Kohn-Sham band of C_(m1)*C_m(2)'
 call wrtout(std_out,message,'COLL')
 
! tolerance for the sum over k-points of the Wannier functions (orthogonality)
 tol=1E-6
 
! Sum for one k-point (should be around 0.1).
 tol2=10E0
 
 write(message,*) 'Tolerance : k',tol2,'m',tol
 call wrtout(std_out,message,'COLL')
 
 nC=cmplx(0,0)
 BUG=.FALSE.
 
 do m1=1,mbband
   do m2=1,mbband
     do ik_bz=1,nkbz
       nCt=sum(conjg(coeffW_BZ(:,ik_bz,m1))*coeffW_BZ(:,ik_bz,m2))
       if (  ((m1==m2).and.(abs(abs(ncT)-1)>tol2)).OR.&
       ((m1.NE.m2).and.(abs(ncT)>tol2)) ) then     
         BUG=.TRUE.
         write(message,*)  "No orthogonality for m1,m2",m1,m2,"kpt",ik_bz,abs(nCt)
         MSG_ERROR(message)
       end if
       nC=nC+wk*nCt
     end do
   
     if (  ((m1==m2).and.(abs(abs(nC)-1)>tol)).OR.&
     ((m1.NE.m2).and.(abs(nC)>tol)) ) then     
       bug=.TRUE.
       write(message,*) "No orthogonality for",m1,m2,abs(nC)
       MSG_ERROR(message)
     end if
     write(message,*)  m1,m2,abs(nC)
     nC=cmplx(0,0)
   end do
 end do
 if (.NOT.bug) then
   write(message,*) "Orthogonality check"
   call wrtout(std_out,message,'COLL')
 end if
 
!                                       _
!                                      ( )
!   _ __ ___        _ __ ___  _ __ ___ |/
!  | '_ ` _ \      | '_ ` _ \| '_ ` _ \
!  | | | | | |     | | | | | | | | | | |
!  |_| |_| |_|     |_| |_| |_|_| |_| |_|
 
 
!!!==Calculation of M_G^(mm')(q)==!
 ABI_ALLOCATE(M_qk_m,(mbband,mbband,npw,nqibz,nkbz))
 
 M_qk_m=cmplx(0,0)
 
 
 write(message,*) 'Calculation of M  m'
 call wrtout(std_out,message,'COLL')
 
 call Transformation_m(ikmq_BZ_t,M_qk_n,coeffW_BZ,nqibz,nkbz,bandinf,bandsup,npw,mbband,&
      M_qk_m)
 
 
 if (verbose) then 
   !====================================!
   !==Writes M_(G=0)^(mm')(q,k=0)
   !====================================!
    open(unit=2012,file='M_mimj(n=1_2_3)(q,k=0,G=0)',form='formatted',status='unknown')
    do iq_ibz=1,nqibz
      write(2012,*) iq_ibz,((abs(M_qk_m(i,j,1,iq_ibz,1)),i=1,mbband),j=1,mbband)
    end do
    close(2012)
 end if
 
 ABI_ALLOCATE(M_q_m,(mbband,mbband,npw,nqibz))
!Sum over k-points.
 M_q_m(:,:,:,:)=sum(M_qk_m(:,:,:,:,:),dim = 5)/nkbz
 
 ABI_DEALLOCATE(M_qk_m)
 
 if (verbose) then 
   call  Sauvegarde_M_q_m(M_q_m,normG,nqibz,npw,mbband)
 end if
 
 write(message,*)  "M_m,m' for G=(0,0,0) and Q=(0,0,0) "
 call wrtout(std_out,message,'COLL')
 do m1=1,mbband
   write(message,*)  M_q_m(m1,:,1,1)
 end do
 
 ABI_DEALLOCATE(M_q_m)
! BUG=.FALSE.
! write(message,*)  ''
! write(message,*)  'Check sum rules'
! tol = 3E0
! write(message,*)  'Tolerance :',tol
! nC=cmplx(0,0)
! nCt=cmplx(0,0)
! 
! do iq_ibz=1,nqibz
! do iG=1,npw
!      do n1=bandinf,bandsup
!      nc=nc+sum(M_qk_n(n1,n1,iG,iq_ibz,:))/nkbz
!      end do
!      
!      do m1=1,mbband
!      ncT=nct+M_q_m(m1,m1,iG,iq_ibz)
!      end do 
! 
!      if (abs(abs(nc)-abs(ncT))>tol) then 
!      write(message,*)  "orthogonality prb"
!      write(message,*) "iG ",iG," iq_ibz ",iq_ibz,"M_n", nc, "M_m",nct
!      BUG=.TRUE.
!      STOP
!      end if
! 
!      nC=cmplx(0,0)
!      nCt=cmplx(0,0)
! end do
! end do
! if (.NOT.BUG) write(message,*)  "Orthogonality fulfilled"
! ABI_DEALLOCATE(M_q_m)
! ABI_DEALLOCATE(M_qk_n)
!        _                                     _
!       | |                                   ( )
!   _ __| |__   ___        _ __ ___  _ __ ___ |/
!  | '__| '_ \ / _ \      | '_ ` _ \| '_ ` _ \
!  | |  | | | | (_) |     | | | | | | | | | | |
!  |_|  |_| |_|\___/      |_| |_| |_|_| |_| |_|
 
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
!==Calcul de Ro_G^(mm')(q)==!
 write(message,*) 'Calcul of rhotwilde  m'
  call wrtout(ab_out,message,'COLL'); call wrtout(std_out,message,'COLL')
 ABI_ALLOCATE(rhot_qk_m,(mbband,mbband,npw,nqibz,nkbz))
 rhot_qk_m=cmplx(0,0)
 
 call Transformation_m(ikmq_BZ_t,rhot_qk_n,coeffW_BZ,nqibz,nkbz,bandinf,bandsup,npw,mbband,&
      rhot_qk_m)
 
 ABI_ALLOCATE(rhot_q_m,(mbband,mbband,npw,nqibz))
 rhot_q_m(:,:,:,:)=sum(rhot_qk_m(:,:,:,:,:),dim = 5)/nkbz
 ABI_DEALLOCATE(rhot_qk_m)
 ABI_DEALLOCATE(ikmq_BZ_t)
 
 write(message,*)  "rho_m,m' for G=(0,0,0) and Q=(0,0,0)"
 do m1=1,mbband
   write(message,*) rhot_q_m(m1,:,1,1)
 end do
 
 if (verbose) then 
   !==Ecriture de Ro_G^(mm')(q)==!:
   eVnorme=sqrt(Ha_eV/ucvol)
   open(unit=2111,file='Ro_mm11(q)',form='formatted',status='unknown')
   do iG=1,npw
     write(2111,*) normG(iG),eVnorme*abs(rhot_q_m(1,1,iG,:))
   end do
   close(2111)
 end if
 
!  __      __
!  \ \    / /
!   \ \  / /      _ __ ___
!    \ \/ /      | '_ ` _ \
!     \  /       | | | | | |
!      \/        |_| |_| |_|
 
 
 ABI_ALLOCATE(V_m,(mbband,mbband,mbband,mbband))
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 write(message,*)  "==Calcul of the bare interaction on the correlated orbital V m=="
     call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 iomega=1
 V_m=cmplx(0,0)
 call cpu_time ( t1 )
 do m1=1,mbband
   do m2=1,mbband
     do m3=1,mbband
       do m4=1,mbband
         !!somme interne sur iG, puis somme externe sur iq_ibz
         !! Sum_(iq_ibz) wi(iq_ibz)*Sum_ig  Rho(m3,m1,iG,iq)cong*Rho(m2,m4,ig,iq)
          V_m(m1,m2,m3,m4)=sum(q_coord(:,4)*sum(conjg(rhot_q_m(m3,m1,:,:))*rhot_q_m(m2,m4,:,:),dim = 1))&
&          *Ha_eV/(ucvol)
       end do
     end do
   end do
 end do
 call cpu_time ( t2 )
 write(message,*)  "in ",t2-t1,"sec"
 call wrtout(std_out,message,'COLL')
!!==Voir si le calcul est corecte==!
 tol=1E-2
 call Checkk(V_m,1,mbband,tol,1)
 ABI_DEALLOCATE(V_m)
 
!    _____                          _
!   / ____|                        (_)
!  | (___   ___ _ __ ___  ___ _ __  _ _ __   __ _
!   \___ \ / __| '__/ _ \/ _ \ '_ \| | '_ \ / _` |
!   ____) | (__| | |  __/  __/ | | | | | | | (_| |
!  |_____/ \___|_|  \___|\___|_| |_|_|_| |_|\__, |
!                                            __/ |
!                                           |___/
!==========================================================
!== Read Dielectric Matrix for _SCR file
!==========================================================
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 write(message,*) "==Read the dielectric matrix=="
 call wrtout(ab_out,message,'COLL'); call wrtout(std_out,message,'COLL')
 ABI_ALLOCATE(scr,(npw,npw,nomega,nqibz))
 call read_screening(fname,npw,nqibz,nomega,scr,IO_MODE_FORTRAN,Wfd%comm)
 
!!Ecriture de la matrice dielectrique en formatted!!
 if (verbose) then 
   open(unit=2211,file='Screening',form='formatted',status='unknown')
   do iG1=1,npw
     do iG2=1,npw
       write(2211,*) iG1,iG2,normG(iG1),normG(iG2),abs(scr(iG1,iG2,1,1)),abs(scr(iG1,iG2,2,1))
     end do
   end do
   close(2211)
 end if
 
 write(message,*) "Check the hermiticity"
  call wrtout(ab_out,message,'COLL')
     call wrtout(std_out,message,'COLL')
 tol = 1E-2
 do iG1=1,npw
   if (modulo(iG1,100).EQ.1) then
     write(message,*)  iG1,"/",npw
     call wrtout(std_out,message,'COLL')
   end if
   do iG2=iG1,npw
     if (ANY(abs(scr(iG1,iG2,:,:)-scr(iG2,iG1,:,:))>tol)) then
       write(message,*) iG1,iG2,"False"
       MSG_ERROR(message)
     end if
   end do
 end do
 write(message,*)  "Done: Hermiticity of dielectric matrix checked"
 call wrtout(std_out,message,'COLL')
 call wrtout(ab_out,message,'COLL')
!   _    _
!  | |  | |
!  | |  | |      _ __ ___
!  | |  | |     | '_ ` _ \
!  | |__| |     | | | | | |
!   \____/      |_| |_| |_|
!
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 write(message,*)  "==Calculation of the screened interaction on the corelated orbital U m=="
  call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 ABI_ALLOCATE(U_m,(mbband,mbband,mbband,mbband))
 iomega=1
  
 SELECT CASE(Optimisation)
 CASE("naif")
   write(message,*)  "naif code"
   call wrtout(std_out,message,'COLL')
   U_m=cmplx(0,0)
   nc=cmplx(0,0)
   call cpu_time ( t1 )
   do m1=1,mbband
     do m2=1,mbband
       do m3=1,mbband
         do m4=1,mbband
           do iq_ibz=1,nqibz
             do iG1=1,npw
               do iG2=1,npw
                 nc=nc+conjg(rhot_q_m(m3,m1,iG1,iq_ibz))*&
&                 rhot_q_m(m2,m4,iG2,iq_ibz)*scr(iG1,iG2,iomega,iq_ibz)
               end do
             end do
             U_m(m1,m2,m3,m4)=U_m(m1,m2,m3,m4)+nc*q_coord(iq_ibz,4)
             nc=cmplx(0,0)
           end do
           U_m(m1,m2,m3,m4)=U_m(m1,m2,m3,m4)*Ha_eV/(ucvol)
         end do
       end do
     end do
   end do
   call cpu_time ( t2 )
   write(message,*)  "in ",t2-t1,"sec"
   call wrtout(std_out,message,'COLL')
   CASE("G") 
   write(message,*)  "Optimisation on G"
   call wrtout(std_out,message,'COLL')
   U_m=cmplx(0,0)
   nc=cmplx(0,0)
   nct=cmplx(0,0)
   call cpu_time ( t1 )
   do m1=1,mbband
     do m2=1,mbband
       do m3=1,mbband
        do m4=1,mbband
        !      sum q sum G1 sum G2 f(G1,q)f(G2,q)G(G1,G2,q)
        !      sum q sum G1 f(g1,q) sum G2 f(G2,q)G(G1,G2,q)
          do iq_ibz=1,nqibz
            do iG1=1,npw
              do iG2=1,npw
                nct=nct+rhot_q_m(m2,m4,iG2,iq_ibz)*scr(iG1,iG2,iomega,iq_ibz)
              end do
              nc=nc+conjg(rhot_q_m(m3,m1,iG1,iq_ibz))*nct
              nct=cmplx(0,0)
            end do
            U_m(m1,m2,m3,m4)=U_m(m1,m2,m3,m4)+nc*q_coord(iq_ibz,4)
            nc=cmplx(0,0)
          end do
          U_m(m1,m2,m3,m4)=U_m(m1,m2,m3,m4)*Ha_eV/(ucvol)
         end do
        end do
      end do
    end do
    call cpu_time ( t2 )
    write(message,*)  "in ",t2-t1,"sec"
   call wrtout(std_out,message,'COLL')
    CASE("G_sum") 
    write(message,*)  "Optimisation on G and sum"
    call wrtout(std_out,message,'COLL')
    U_m=cmplx(0,0)
    nc=cmplx(0,0)
    call cpu_time ( t1 )
    do m1=1,mbband
      do m2=1,mbband
        do m3=1,mbband
          do m4=1,mbband
         !      sum q sum G1 sum G2 f(G1,q)f(G2,q)G(G1,G2,q)
         !      sum q sum G1 f(g1,q) sum G2 f(G2,q)G(G1,G2,q)
            do iq_ibz=1,nqibz
              do iG1=1,npw
                   nc=nc+conjg(rhot_q_m(m3,m1,iG1,iq_ibz))*sum(rhot_q_m(m2,m4,:,iq_ibz)*scr(:,iG1,iomega,iq_ibz))
              end do
 
            U_m(m1,m2,m3,m4)=U_m(m1,m2,m3,m4)+nc*q_coord(iq_ibz,4)
            nc=cmplx(0,0)
            end do
            U_m(m1,m2,m3,m4)=U_m(m1,m2,m3,m4)*Ha_eV/(ucvol)
          end do
        end do
      end do
    end do
    call cpu_time ( t2 )
    write(message,*)  "in ",t2-t1, "sec"
    call wrtout(std_out,message,'COLL')
 END SELECT
! tolerance of the symetry of screened U.
  tol=1E-2
  call Checkk(U_m,1,mbband,tol,1)
 
 ABI_DEALLOCATE(rhot_q_m)
 ABI_DEALLOCATE(scr)
 ABI_DEALLOCATE(U_m)
 ABI_DEALLOCATE(k_coord)
 ABI_DEALLOCATE(q_coord)
 ABI_DEALLOCATE(bijection)
 ABI_DEALLOCATE(normG)
 ABI_DEALLOCATE(rhot_qk_n)
 ABI_DEALLOCATE(rhot_q_n)
 ABI_DEALLOCATE(coeffW_BZ)
 ABI_DEALLOCATE(M_qk_n)
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
 CONTAINS
 
!!    __                 _   _
!!   / _|               | | (_)
!!  | |_ ___  _ __   ___| |_ _  ___  _ __
!!  |  _/ _ \| '_ \ / __| __| |/ _ \| '_ \
!!  | || (_) | | | | (__| |_| | (_) | | | |
!!  |_| \___/|_| |_|\___|\__|_|\___/|_| |_|
! 
 integer FUNCTION fi(nkbz,k_coord,kprime_coord)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'fi'
!End of the abilint section

      implicit none
       integer,intent(in) :: nkbz
      real(dp),dimension(nkbz,3),intent(in) ::k_coord
      real(dp),dimension(3),intent(in) :: kprime_coord(3)
 
 do fi=1,nkbz
   if (ALL(abs(kprime_coord(:)-k_coord(fi,:))<0.001)) then 
     exit
   end if
 end do
 END FUNCTION fi
 
 integer FUNCTION findkmq(ik_bz,k_coord,q_coord,nkbz)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'findkmq'
 use interfaces_70_gw
!End of the abilint section

      implicit none
      integer,intent(in) :: ik_bz,nkbz
      real(dp),dimension(nkbz,3),intent(in) ::k_coord
      real(dp),dimension(4),intent(in) ::q_coord
      real(dp),dimension(3) :: kprime_coord
      integer :: i,j,k
 
 
 kprime_coord(:)=k_coord(ik_bz,:)-q_coord(1:3)
 
 where (kprime_coord > 0.5)
   kprime_coord(:)= kprime_coord(:)-1 
 elsewhere(kprime_coord < -0.5) 
   kprime_coord(:)= kprime_coord(:)+1
 end where
 
!! indice of k -q
 findkmq=fi(nkbz,k_coord,kprime_coord)
 
!!Test if k-q exists
 if (findkmq.EQ.(nkbz+1)) then
!!The prb comes from PBC included born_inf,born_sup]
!! One test all combination over boundaries
   do i=1,2
     if (abs(abs(kprime_coord(1))-0.5)<0.001) kprime_coord(1)=(-1)**i*0.5
     do j=1,2
       if (abs(abs(kprime_coord(2))-0.5)<0.001) kprime_coord(2)=(-1)**j*0.5
       do k=1,2
         if (abs(abs(kprime_coord(3))-0.5)<0.01) kprime_coord(3)=(-1)**k*0.5
         findkmq=fi(nkbz,k_coord,kprime_coord)
        !!Quand on a trouver la bonne valeur on part
         if (findkmq.NE.(nkbz+1)) return
       end do
     end do
   end do
 end if
 END FUNCTION findkmq
 
 SUBROUTINE Transformation_m(ikmq_BZ_t,X_qk_n,coeffW,nqibz,nkbz,bandinf,bandsup,npw,mbband,&
      X_qk_m)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Transformation_m'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none
 integer, intent(in)  :: nkbz,nqibz,ikmq_BZ_t(nkbz,nqibz),bandinf,bandsup,npw,mbband
 complex(dpc), intent(in)  ::  coeffW(bandinf:bandsup,nkbz,mbband),&
& X_qk_n(bandinf:bandsup,bandinf:bandsup,npw,nqibz,nkbz)
 complex(dpc), intent(out) :: X_qk_m(mbband,mbband,npw,nqibz,nkbz)
 integer       :: m1,m3,iq_ibz,ik_bz,n1,n2,ikmq_BZ
 real(dp)       :: t1,t2
 
 call cpu_time ( t1 )
 do iq_ibz=1,nqibz
    do ik_bz=1,nkbz
   !sum n1,n2 g(n1,n2)*conjg(f(n1))*f(n2)
      ikmq_BZ=ikmq_BZ_t(ik_bz,iq_ibz)
      do m1=1,mbband
        do m3=1,mbband
          do n1=bandinf,bandsup
            do n2=bandinf,bandsup
              X_qk_m(m1,m3,:,iq_ibz,ik_bz)=X_qk_m(m1,m3,:,iq_ibz,ik_bz)+&
              X_qk_n(n1,n2,:,iq_ibz,ik_bz)*coeffW(n2,ik_BZ,m3)*conjg(coeffW(n1,ikmq_BZ,m1))
            end do
          end do
        end do
      end do
    end do
 end do
 call cpu_time ( t2 )
 write(message,*)  'M tranformation in', t2-t1,'sec'
 call wrtout(std_out,message,'COLL')
 END SUBROUTINE Transformation_m
 
 
 SUBROUTINE Checkk(Interaction,l_bandinf,l_bandsup,tol,prtopt)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Checkk'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none
 integer, intent(in) :: l_bandinf,l_bandsup
 complex(dpc), intent(in) :: Interaction(l_bandinf:l_bandsup,l_bandinf:&
& l_bandsup,l_bandinf:l_bandsup,l_bandinf:l_bandsup)
 real(dp), intent(in)    :: tol
 integer     :: i,j
 integer :: prtopt
 logical        :: bug=.FALSE.
 
!==Check correctness
 write(message,*)  "== Check == "
 call wrtout(std_out,message,'COLL')
 write(message,*) 'Tolerance :',tol
 call wrtout(std_out,message,'COLL')
 do i=l_bandinf,l_bandsup
   do j=i+1,l_bandsup
      !if (abs(abs(Interaction(i,i,i,i)-Interaction(j,j,j,j)))>tol) then
      !     BUG=.TRUE.
      !     write(message,*) "Problem in the interband calculation"&
!&      ,i,j,abs(Interaction(i,i,i,i)),abs(Interaction(j,j,j,j))
      !     call wrtout(std_out,message,'COLL')
      !end if
   
     if (abs(Interaction(i,j,i,j)-Interaction(j,i,j,i))>tol) then
       BUG=.TRUE.
       write(message,*) "Error in the symetry of U'",i,j,abs(Interaction(i,j,i,j)),&
&       abs(Interaction(j,i,j,i)),abs(Interaction(i,j,i,j)-Interaction(j,i,j,i))
       call wrtout(std_out,message,'COLL')
     end if
   
     if (abs(Interaction(i,i,j,j)-Interaction(j,j,i,i))>tol) then
       BUG=.TRUE.
       write(message,*) "Error in the symetry of J'",i,j,abs(Interaction(i,i,j,j)),&
&       abs(Interaction(j,j,i,i)),abs(Interaction(j,j,i,i)-Interaction(i,i,j,j))
       call wrtout(std_out,message,'COLL')
     end if
   end do
 end do
 
 
 do i=l_bandinf,l_bandsup
   do j=l_bandinf,l_bandsup
     if (i.EQ.j) cycle
     if (abs(Interaction(i,j,j,j))>tol) then
       BUG=.TRUE.
       write(message,*) "Error in the symetry U(,i,j,j,j) need to vanish or",&
&       i,j,abs(Interaction(i,j,j,j))
       call wrtout(std_out,message,'COLL')
     end if
   end do
 end do
 
! if (.not.BUG) then
!    call wrtout(std_out,'Calcul is possibly correct','COLL')
!    call Affichage(Interaction,l_bandinf,l_bandsup,2)
! else 
!     call wrtout(std_out,'Maybe somme error','COLL')
!     call Affichage(Interaction,l_bandinf,l_bandsup,1)
! end if
 
 if(prtopt>0)  call Affichage(Interaction,l_bandinf,l_bandsup,1)
 
 END SUBROUTINE Checkk
 
 SUBROUTINE Affichage(Interaction,l_bandinf,l_bandsup,option)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Affichage'
 use interfaces_14_hidewrite
!End of the abilint section

  implicit none
  integer, intent(in) :: l_bandinf,l_bandsup,option
  complex(dpc), intent(in) :: Interaction(l_bandinf:l_bandsup,l_bandinf:l_bandsup,&
&  l_bandinf:l_bandsup,l_bandinf:l_bandsup)
  integer :: m1,m2
  character(len=500) :: message
 
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 
 write(message,*)"U Hubbard (Band or orbital/Interaction)"
 call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
 
  do m1=l_bandinf,l_bandsup
    if (option.EQ.1) then 
       write(message,'(i3,14f7.3)') m1,real(Interaction(m1,m1,m1,m1))
       call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
    end if
  end do
 
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 
 write(message,*)"U'"
 call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
 
 write(message,'(a,14i7)') "-",(m1,m1=l_bandinf,l_bandsup)
 call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
 do m1=l_bandinf,l_bandsup
   if (option.EQ.1) then
     write(message,'(i3,14f7.3)') m1,(real(Interaction(m1,m2,m1,m2)),m2=l_bandinf,l_bandsup)
     call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
   end if
 end do
 
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 
 write(message,*)'Hund coupling J'
 call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
 
 write(message,'(a,14i7)') "-",(m1,m1=l_bandinf,l_bandsup)
 call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
 do m1=l_bandinf,l_bandsup
   if (option.EQ.1) then
      write(message,'(i3,14f7.3)') m1,(real(Interaction(m1,m1,m2,m2)),m2=l_bandinf,l_bandsup)
      call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
   end if
 end do
 write(message,*) "";call wrtout(std_out,message,'COLL');call wrtout(ab_out,message,'COLL')
 write(message,*) "U'=U-2J for the t2g should be checked"
 call wrtout(std_out,message,'COLL'); call wrtout(ab_out,message,'COLL')
 
 END SUBROUTINE Affichage
 
 SUBROUTINE Sauvegarde_M_q_m(M_q_m,normG,nqibz,npw,mbband)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'Sauvegarde_M_q_m'
!End of the abilint section

 implicit none
 integer, intent(in) :: nqibz,npw,mbband
 complex(dpc), intent(in) :: M_q_m(mbband,mbband,npw,nqibz)
 real(dp), intent(in) :: normG(npw)
 integer :: i,j,iq_ibz,iG
 
!==Ecriture de M_(G=0)^(mm')(q) ==!
 open(unit=2012,file='M_mimj(n=1_2_3)(q,G=0)',form='formatted',status='unknown')
 do iq_ibz=1,nqibz
    write(2012,*) iq_ibz,((abs(M_q_m(i,j,1,iq_ibz)),i=1,mbband),j=1,mbband)
 end do
 close(2012)
 
!==Ecriture de M_G^(mm')(q=0) ==!
 open(unit=2411,file='M_mm(m=1..mbband)(q=0)',form='formatted',status='unknown')
 do iG=1,npw
    write(2411,*) normG(iG),(abs(M_q_m(i,i,iG,1)),i=1,mbband)
 end do
 close(2411)
 END SUBROUTINE Sauvegarde_M_q_m

 end subroutine calc_ucrpa
!!***
