!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_hu
!! NAME
!!  m_hu
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2006-2012 ABINIT group (BAmadon)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

MODULE m_hu

 use m_profiling

 use defs_basis
 use defs_datatypes

 implicit none

 private 

 public :: init_hu
 public :: destroy_hu
! public :: qmc_hu
 public :: nullify_hu
 public :: print_hu
 public :: vee2udens_hu
 public :: rotatevee_hu
 public :: printvee_hu
 public :: vee2udensatom_hu


!!***

!!****t* m_hu/hu_type
!! NAME
!!  hu_type
!!
!! FUNCTION
!!  This structured datatype contains interaction matrices for the correlated subspace
!!
!! SOURCE

 type, public :: hu_type ! for each typat

  integer :: lpawu         

  real(dp) :: upawu    ! => upaw

  real(dp) :: jpawu    ! => jpaw

  logical :: jpawu_zero  ! true if all jpawu are zero
                         ! false if one of the jpaw is not zero

  real(dp), pointer :: vee(:,:,:,:) ! => vee

  real(dp), pointer :: uqmc(:)

  real(dp), pointer :: udens(:,:)

 end type hu_type

!----------------------------------------------------------------------


CONTAINS  !========================================================================================
!!***

!!****f* m_hu/init_hu
!! NAME
!! init_hu
!!
!! FUNCTION
!!  Allocate variables used in type hu_type.
!!
!! INPUTS
!!  cryst_struc <type(crystal_structure)>=crystal structure data
!!  pawtab <type(pawtab)>=paw related data
!!
!! OUTPUTS
!!  hu <type(hu_type)>= U interaction
!!
!! PARENTS
!!      dmft_solve
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine init_hu(cryst_struc,pawtab,hu,t2g)

 use defs_basis
 use defs_datatypes
 use m_crystal, only : crystal_structure

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'init_hu'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 type(crystal_structure),intent(in) :: cryst_struc
 type(pawtab_type), target, intent(in)  :: pawtab(cryst_struc%ntypat)
 type(hu_type), intent(inout) :: hu(cryst_struc%ntypat)
 integer :: t2g
!Local variables ------------------------------------
 integer :: itypat,i,ij,ij1,ij2,j,lpawu,ms,ms1,m,m1,ndim
 integer :: ns,ns1,n,n1
 integer, allocatable :: xij(:,:)
 real(dp) :: xtemp
 character(len=500) :: message
!************************************************************************
 write(message,'(2a)') ch10,"  == Compute Interactions for DMFT"
 call wrtout(std_out,message,'COLL')

 xtemp=zero
 call nullify_hu(hu,cryst_struc%ntypat)

! ====================================
!  Compute hu(iatom)%uqmc from vee
! ====================================
 hu(1)%jpawu_zero=.true.
 do itypat=1,cryst_struc%ntypat
   hu(itypat)%lpawu=pawtab(itypat)%lpawu
   if(t2g==1.and.hu(itypat)%lpawu==2) hu(itypat)%lpawu=1
   lpawu=hu(itypat)%lpawu
   if(lpawu.ne.-1) then
     hu(itypat)%upawu=pawtab(itypat)%upawu
     hu(itypat)%jpawu=pawtab(itypat)%jpawu
     if(hu(itypat)%jpawu>tol4) hu(1)%jpawu_zero=.false.
     ndim=2*lpawu+1
!     ndim1=2*hu(itypat)%lpawu+1
     write(message,'(2a,i4)')  ch10,'  -------> For Correlated Species', itypat
     call wrtout(std_out,  message,'COLL')
!     allocate(hu(itypat)%vee(ndim,ndim,ndim,ndim))
     ABI_ALLOCATE(hu(itypat)%uqmc,(ndim*(2*ndim-1)))
     ABI_ALLOCATE(hu(itypat)%udens,(2*ndim,2*ndim))
     ABI_ALLOCATE(xij,(2*ndim,2*ndim))
     if(t2g==0) then
       hu(itypat)%vee => pawtab(itypat)%vee
!   t2g case begin
     else if(t2g==1.and.hu(itypat)%lpawu==1) then
       ABI_ALLOCATE(hu(itypat)%vee,(ndim,ndim,ndim,ndim))
       n=0
       do m=1,5
         if((m/=1.and.m/=2.and.m/=4)) cycle
         n=n+1
         ns=0
         do ms=1,5
           if((ms/=1.and.ms/=2.and.ms/=4)) cycle
           ns=ns+1
           n1=0
           do m1=1,5
             if((m1/=1.and.m1/=2.and.m1/=4)) cycle
             n1=n1+1
             ns1=0
             do ms1=1,5
               if((ms1/=1.and.ms1/=2.and.ms1/=4)) cycle
               ns1=ns1+1
               hu(itypat)%vee(n,ns,n1,ns1)=pawtab(itypat)%vee(m,ms,m1,ms1)
             enddo
           enddo
         enddo
       enddo
     endif
!   t2g case end

     hu(itypat)%udens=zero
     ij=0
     do ms=1,2*ndim-1
         xij(ms,ms)=0
       do ms1=ms+1,2*ndim 
         ij=ij+1
         xij(ms,ms1)=ij
         xij(ms1,ms)=ij
         if(ms<=ndim.and.ms1>ndim) then
           m1 = ms1 - ndim
           m  = ms
           hu(itypat)%uqmc(ij)=hu(itypat)%vee(m,m1,m,m1)
           hu(itypat)%udens(ms,ms1)= hu(itypat)%vee(m,m1,m,m1)
           hu(itypat)%udens(ms1,ms)= hu(itypat)%udens(ms,ms1)
         else if(ms<=ndim.and.ms1<=ndim) then
           m1 = ms1
           m  = ms
           hu(itypat)%uqmc(ij)=hu(itypat)%vee(m,m1,m,m1)-hu(itypat)%vee(m,m1,m1,m)
           hu(itypat)%udens(ms,ms1)= hu(itypat)%uqmc(ij)
           hu(itypat)%udens(ms1,ms)= hu(itypat)%udens(ms,ms1)
         else
           m1 = ms1 - ndim
           m  = ms  - ndim
           hu(itypat)%uqmc(ij)=hu(itypat)%vee(m,m1,m,m1)-hu(itypat)%vee(m,m1,m1,m)
           hu(itypat)%udens(ms,ms1)= hu(itypat)%uqmc(ij)
           hu(itypat)%udens(ms1,ms)= hu(itypat)%udens(ms,ms1)
         endif
       enddo
     enddo
     xij(2*ndim,2*ndim)=0
     write(message,'(a,5x,a)') ch10,"-------- Interactions in the density matrix representation "
     call wrtout(std_out,  message,'COLL')
     write(message,'(1x,14(2x,i5))') (m,m=1,2*ndim)
     call wrtout(std_out,  message,'COLL')
!     xtemp1b=0.d0
! ====================================
!  Print hu(iatom)%uqmc 
! ====================================
     ij1=-10
     ij2=-10
     ij=0
     do i=1,2*ndim
       do j=i+1,2*ndim
         ij=ij+1
         if(j==i+1) ij1=ij
         if(j==2*ndim) ij2=ij
       enddo 
!       write(std_out,*) itypat
!       do m=1,i
!        write(std_out,*) i,m
!        write(std_out,*) xij(i,m)
!        write(std_out,*) ij1,ij2
!       enddo
       if(i==1)               write(message,'(i3,14f7.3)') &
&                              i,xtemp, (hu(itypat)%uqmc(m),m=ij1,ij2)
       if(i/=2*ndim.and.i/=1) write(message,'(i3,14f7.3)') i, &
&        (hu(itypat)%uqmc(xij(i,m)), m=1,i-1),xtemp, (hu(itypat)%uqmc(m),m=ij1,ij2)
       if(i==2*ndim)          write(message,'(i3,14f7.3)') i, &
&                  (hu(itypat)%uqmc(xij(i,m)), m=1,i-1),xtemp
       call wrtout(std_out,  message,'COLL')
     enddo 
       write(message,'(5x,a)') "--------------------------------------------------------"
       call wrtout(std_out,  message,'COLL')
     ABI_DEALLOCATE(xij)
     if(t2g==1) then
       ABI_DEALLOCATE(hu(itypat)%vee)
     endif
   else
     hu(itypat)%upawu=zero
     hu(itypat)%jpawu=zero
!     allocate(hu(itypat)%vee(0,0,0,0))
   endif
 enddo ! itypat

end subroutine init_hu
!!***

!!****f* m_hu/nullify_hu
!! NAME
!! nullify_hu
!!
!! FUNCTION
!!  nullify hu
!!
!! INPUTS
!!  ntypat = number of species
!!  hu <type(hu_type)> = data for the interaction in DMFT. 
!!
!! OUTPUT
!!
!! PARENTS
!!      m_hu
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine nullify_hu(hu,ntypat)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'nullify_hu'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer, intent(in) :: ntypat
 type(hu_type),intent(inout) :: hu(ntypat)
!Local variables-------------------------------
 integer :: itypat

!*********************************************************************

 do itypat=1,ntypat
   nullify(hu(itypat)%vee)
   nullify(hu(itypat)%uqmc)
   nullify(hu(itypat)%udens)
 enddo


end subroutine nullify_hu
!!***

!!****f* m_hu/destroy_hu
!! NAME
!! destroy_mh
!!
!! FUNCTION
!!  deallocate hu
!!
!! INPUTS
!!  ntypat = number of species
!!  hu <type(hu_type)> = data for the interaction in DMFT. 
!!
!! OUTPUT
!!
!! PARENTS
!!  
!!
!! CHILDREN
!!   wrtout
!!
!! SOURCE

subroutine destroy_hu(hu,ntypat)

 use defs_basis
 use m_crystal, only : crystal_structure

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'destroy_hu'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer, intent(in) :: ntypat
 type(hu_type),intent(inout) :: hu(ntypat)

!Local variables-------------------------------
 integer :: itypat

! *********************************************************************

 do itypat=1,ntypat
!  if ( associated(hu(itypat)%vee) )  deallocate(hu(itypat)%vee)
  if ( associated(hu(itypat)%uqmc) )   then
    ABI_DEALLOCATE(hu(itypat)%uqmc)
  end if
  if ( associated(hu(itypat)%udens) )   then
    ABI_DEALLOCATE(hu(itypat)%udens)
  end if
 enddo

end subroutine destroy_hu
!!***

!!****f* m_hu/print_hu
!! NAME
!! print_hu
!!
!! FUNCTION
!!  print density density interaction (used for DFT+DMFT)
!!
!! INPUTS
!!  ntypat = number of species
!!  prtopt = option for printing
!!  hu <type(hu_type)> = data for the interaction in DMFT. 
!!
!! OUTPUT
!!
!! PARENTS
!!      m_hu
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine print_hu(hu,ntypat,prtopt)

 use defs_basis
 use m_crystal, only : crystal_structure

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'print_hu'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 integer, intent(in):: ntypat
 type(hu_type),intent(in) :: hu(ntypat)
 integer :: prtopt

!Local variables-------------------------------
 integer :: itypat
 integer :: lpawu,ms,ms1,m,ndim
 character(len=500) :: message
! *********************************************************************

 if(prtopt>0) then
 endif
 do itypat = 1 , ntypat
   lpawu=hu(itypat)%lpawu
   if(lpawu/=-1) then
     ndim=2*lpawu+1
     write(message,'(2a,i4)')  ch10,'  -------> For Correlated species'
     call wrtout(std_out,  message,'COLL')
     write(message,'(a,5x,a)') ch10,"-------- Interactions in the density matrix representation "
     call wrtout(std_out,  message,'COLL')
     write(message,'(1x,14(2x,i5))') (m,m=1,2*ndim)
     call wrtout(std_out,  message,'COLL')
       do ms=1,2*ndim
          write(message,'(i3,14f7.3)') &
&          ms, (hu(itypat)%udens(ms,ms1),ms1=1,2*ndim)
          call wrtout(std_out,  message,'COLL')
       enddo
       write(message,'(5x,a)') "--------------------------------------------------------"
       call wrtout(std_out,  message,'COLL')
   endif ! lpawu/=1
 enddo ! ntypat


end subroutine print_hu
!!***

!!****f* m_hu/vee2udens_hu
!! NAME
!! print_hu
!!
!! FUNCTION
!!  interaction udens in recomputed from new vee.
!!
!! INPUTS
!!  ntypat = number of species
!!  prtopt = option for printing
!!
!! OUTPUT
!!
!! SIDE EFFECT
!!  hu <type(hu_type)> = data for the interaction in DMFT. 
!!
!! PARENTS
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine vee2udens_hu(hu,ntypat,prtopt)

 use defs_basis
 use m_crystal, only : crystal_structure

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'vee2udens_hu'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 integer, intent(in):: ntypat
 type(hu_type),intent(inout) :: hu(ntypat)
 integer :: prtopt

!Local variables-------------------------------
 integer :: ij,itypat
 integer :: lpawu,m1,ms,ms1,m,ndim
 character(len=500) :: message
! *********************************************************************
 do itypat=1,ntypat
   lpawu=hu(itypat)%lpawu
   if(lpawu.ne.-1) then
     ndim=2*lpawu+1
     write(message,'(2a,i4)')  ch10,'  -------> For Correlated Species', itypat
     call wrtout(std_out,  message,'COLL')

     hu(itypat)%udens=zero
     ij=0
     do ms=1,2*ndim-1
!         xij(ms,ms)=0
       do ms1=ms+1,2*ndim 
         ij=ij+1
!         xij(ms,ms1)=ij
!         xij(ms1,ms)=ij
         if(ms<=ndim.and.ms1>ndim) then
           m1 = ms1 - ndim
           m  = ms
           hu(itypat)%uqmc(ij)=hu(itypat)%vee(m,m1,m,m1)
           hu(itypat)%udens(ms,ms1)= hu(itypat)%vee(m,m1,m,m1)
           hu(itypat)%udens(ms1,ms)= hu(itypat)%udens(ms,ms1)
         else if(ms<=ndim.and.ms1<=ndim) then
           m1 = ms1
           m  = ms
           hu(itypat)%uqmc(ij)=hu(itypat)%vee(m,m1,m,m1)-hu(itypat)%vee(m,m1,m1,m)
           hu(itypat)%udens(ms,ms1)= hu(itypat)%uqmc(ij)
           hu(itypat)%udens(ms1,ms)= hu(itypat)%udens(ms,ms1)
         else
           m1 = ms1 - ndim
           m  = ms  - ndim
           hu(itypat)%uqmc(ij)=hu(itypat)%vee(m,m1,m,m1)-hu(itypat)%vee(m,m1,m1,m)
           hu(itypat)%udens(ms,ms1)= hu(itypat)%uqmc(ij)
           hu(itypat)%udens(ms1,ms)= hu(itypat)%udens(ms,ms1)
         endif
       enddo
     enddo
!     xij(2*ndim,2*ndim)=0
!     write(message,'(a,5x,a)') ch10,"-------- Interactions in the density matrix representation "
!     call wrtout(std_out,  message,'COLL')
!     write(message,'(1x,14(2x,i5))') (m,m=1,2*ndim)
!     call wrtout(std_out,  message,'COLL')
   endif
 enddo ! itypat
 call print_hu(hu,ntypat,prtopt)


end subroutine vee2udens_hu
!!***

!!****f* m_hu/rotatevee_hu
!! NAME
!! rotatevee_hu
!!
!! FUNCTION
!!  interaction udens in recomputed from new vee.
!!
!! INPUTS
!!  ntypat = number of species
!!  cryst_struc <type(crystal_structure)>=crystal structure data
!!
!! OUTPUT
!!
!! SIDE EFFECT
!!  hu <type(hu_type)> = data for the interaction in DMFT. 
!!
!! PARENTS
!!      hubbard_one
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine rotatevee_hu(cryst_struc,hu,nspinor,nsppol,pawprtvol,rot_mat,udens_atoms)

 use defs_basis
 use m_crystal, only : crystal_structure
 use m_io_tools,         only : flush_unit

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'rotatevee_hu'
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 type(crystal_structure),intent(in) :: cryst_struc
 integer, intent(in):: nsppol,nspinor,pawprtvol
 type(hu_type),intent(inout) :: hu(cryst_struc%ntypat)
 type(coeff2c_type),optional,intent(in) :: rot_mat(cryst_struc%natom,nsppol)
 type(coeff2_type),intent(out) :: udens_atoms(cryst_struc%natom)
 
!Local variables-------------------------------
 integer :: iatom,itypat
 integer :: lpawu,m1,m2,m3,m4,mi,mj,mk,ml,natom,ndim,tndim
 character(len=500) :: message
 real(dp) :: xsum,xsum2,xsumnew,xsum2new
 complex(dpc),allocatable :: temp_mat(:,:)
 complex(dpc),allocatable :: temp_mat2(:,:)
 real(dp),allocatable :: veetemp(:,:,:,:)
! *********************************************************************
 natom=cryst_struc%natom
 if(hu(1)%jpawu_zero.and.nspinor==2) then
!   call vee2udens_hu(hu,cryst_struc%ntypat,2)
   do iatom=1,natom
     itypat=cryst_struc%typat(iatom)
     lpawu=hu(itypat)%lpawu
     if(lpawu.ne.-1) then
       ndim=2*lpawu+1
       write(message,'(2a,i4)')  ch10,'  -------> For Correlated Species', itypat
       call wrtout(std_out,  message,'COLL')
   write(std_out,*)"ndim",ndim
   write(std_out,*)"udens before vee2udensaomt", udens_atoms(1)%value
       call vee2udensatom_hu(ndim,udens_atoms(iatom)%value,hu(cryst_struc%typat(iatom))%vee)
   write(std_out,*)"udens after vee2udensatom", udens_atoms(1)%value
     endif
   enddo
   write(std_out,*)"udensafter after", udens_atoms(1)%value
   return
 endif

 do iatom=1,natom
   itypat=cryst_struc%typat(iatom)
   lpawu=hu(itypat)%lpawu
   if(lpawu.ne.-1) then
     if(cryst_struc%natom>1.and.(hu(itypat)%jpawu>tol4)) then
        write(message,'(3a)')  ch10,'  -------> Warning: assume all atoms '&
&       ,' of the same species are equivalent '
        call wrtout(std_out,  message,'COLL')
        call flush_unit(std_out)
        call leave_new('COLL')
     endif
     if(nspinor==2.and.(hu(itypat)%jpawu>tol4)) then
        write(message,'(3a)')  ch10,' Generalization to spinorial case is not done for jpawu/=0'
        call wrtout(std_out,  message,'COLL')
        call flush_unit(std_out)
        call leave_new('COLL')
     endif


!!    Check rotation for spin 2 and rotation for spin 1 are equal.
     ndim=2*lpawu+1
     tndim=nspinor*ndim
     do m1=1,tndim
       do m2=1,tndim
         if(nsppol==2) then
           if(abs(rot_mat(iatom,1)%value(m1,m2)-rot_mat(iatom,2)%value(m1,m2))>tol4.and.pawprtvol>=3) then
             write(message,'(2a,i4)')  ch10,' rot_mat differs for value of isppol but value for isppol=2 not used'
             call wrtout(std_out,  message,'COLL')
             write(message,'(a,4e16.8)')  ch10,rot_mat(iatom,1)%value(m1,m2),rot_mat(iatom,2)%value(m1,m2)
             call wrtout(std_out,  message,'COLL')
             call flush_unit(std_out)
!             call leave_new('COLL')
           endif
         endif
       end do 
     end do 
     ABI_ALLOCATE(temp_mat,(ndim,ndim))
     ABI_ALLOCATE(temp_mat2,(ndim,ndim))
     ABI_ALLOCATE(veetemp,(ndim,ndim,ndim,ndim))
     temp_mat(:,:)=czero
     temp_mat2(:,:)=czero

!!    See if rotation is complex or real
     do mi=1,ndim
       do m1=1,ndim
         if(abs(imag(rot_mat(iatom,1)%value(mi,m1)))>tol8.and.pawprtvol>=3) then
            write(message,'(2a,2i6,2e14.3)')  ch10,"rot_mat is complex for", &
&            mi,m1,rot_mat(iatom,1)%value(mi,m1)
            call wrtout(std_out,  message,'COLL')
         endif
       enddo
     enddo


!!    test: put vee to zero for some values
!     hu(itypat)%vee=zero
!     do mi=1,ndim
!         hu(itypat)%vee(mi,mi,mi,mi)=2.6
!     enddo
!     do mi=1,ndim
!       do mj=mi+1,ndim
!         hu(itypat)%vee(mi,mj,mi,mj)=2
!         hu(itypat)%vee(mj,mi,mj,mi)=2
!       enddo
!     enddo
!     do mi=1,ndim
!       do mj=mi+1,ndim
!         hu(itypat)%vee(mi,mj,mj,mi)=0.2
!         hu(itypat)%vee(mj,mi,mi,mj)=0.2
!       enddo
!     enddo
!     do mi=1,ndim
!       do mj=mi+1,ndim
!         hu(itypat)%vee(mi,mi,mj,mj)=0.4
!         hu(itypat)%vee(mj,mj,mi,mi)=0.4
!       enddo
!     enddo
!     write(message,'(2a)')  ch10," vee is put to zero for"
!     call wrtout(std_out,  message,'COLL')
!     do mi=1,ndim
!       do mj=1,ndim
!         do mk=1,ndim
!           do ml=1,ndim
!              if((.not.(mi==mk.and.mj==ml)).and.(.not.(mi==ml.and.mj==mk)).and.&
!&                 .not.(mi==mj.and.mk==ml)) then
!                if(hu(itypat)%vee(mi,mj,mk,ml)>tol8) then
!                  hu(itypat)%vee(mi,mj,mk,ml)=zero
!                endif
!              endif
!           enddo
!         enddo
!       enddo
!     enddo
!    write(message,'(a)')  ch10
!     call wrtout(std_out,  message,'COLL')

!!    write vee for information with a classification.
     if(pawprtvol>=3) then
       write(message,'(2a)')  ch10," VEE INPUT"
       call wrtout(std_out,  message,'COLL')
       call printvee_hu(ndim,hu(itypat)%vee)
     endif
!     do m1=1,ndim
!       do m2=1,ndim
!         ztemp=czero
!         do mi=1,ndim
!                ztemp=ztemp+conjg(rot_mat(iatom,1)%value(mi,m1))*&
!&                          rot_mat(iatom,1)%value(mi,m2)
!        enddo
!      enddo
!    enddo


!!    Compute rotated vee.
     veetemp=zero
     do m1=1,ndim
       do m2=1,ndim
         do m3=1,ndim
           do m4=1,ndim
             do mi=1,ndim
               do mj=1,ndim
                 do mk=1,ndim
                   do ml=1,ndim
!                      if((mi==mk.and.mj==ml).or.(mi==ml.and.mj==mk)) then
                      veetemp(m1,m2,m3,m4)= veetemp(m1,m2,m3,m4) + &
!&                         (rot_mat(iatom,1)%value(m1,mi))* &
!&                         (rot_mat(iatom,1)%value(m2,mj))* &
!&                    conjg(rot_mat(iatom,1)%value(m3,mk))* &
!&                    conjg(rot_mat(iatom,1)%value(m4,ml))* &
!&                          hu(itypat)%vee(mi,mj,mk,ml)
&                    conjg(rot_mat(iatom,1)%value(m1,mi))* &
&                    conjg(rot_mat(iatom,1)%value(m2,mj))* &
&                          rot_mat(iatom,1)%value(m3,mk)* &
&                          rot_mat(iatom,1)%value(m4,ml)* &
&                          hu(itypat)%vee(mi,mj,mk,ml)
!                      endif
                   enddo
                 enddo
               enddo
             enddo
           enddo
         enddo
       enddo
     enddo
     ABI_DEALLOCATE(temp_mat)
     ABI_DEALLOCATE(temp_mat2)
     xsum=zero
     xsum2=zero
     xsumnew=zero
     xsum2new=zero
     do m1=1,ndim
       do m2=1,ndim
         xsum=xsum+hu(itypat)%vee(m1,m2,m1,m2)
         xsum2=xsum2+hu(itypat)%vee(m1,m2,m2,m1)
         xsumnew=xsumnew+veetemp(m1,m2,m1,m2)
         xsum2new=xsum2new+veetemp(m1,m2,m2,m1)
       enddo
     enddo
     if(abs(xsum-xsumnew)>tol5.or.abs(xsum2-xsum2new)>tol5) then
       write(message,'(2a)')  ch10," BUG: New interaction after rotation do not respect sum rules"
       call wrtout(std_out,  message,'COLL')
       write(message,'(2a,2f14.5)')  ch10,' Comparison of \sum_{m1,m3} vee(m1,m3,m1,m3) before and after rotation is',&
&       xsum,xsumnew
       call wrtout(std_out,  message,'COLL')
       write(message,'(2a,2f14.5)')  ch10,' Comparison of \sum_{m1,m3} vee(m1,m3,m3,m1) before and after rotation is',&
&       xsum2,xsum2new
       call wrtout(std_out,  message,'COLL')
     endif
     if(pawprtvol>=3) then
       write(message,'(2a)')  ch10," VEE ROTATED"
       call wrtout(std_out,  message,'COLL')
       call printvee_hu(tndim,veetemp)
       write(message,'(a)') ch10
       call wrtout(std_out,  message,'COLL')
     endif

     write(message,'(2a,i4)')  ch10,'  -------> For Correlated Species', itypat
     call wrtout(std_out,  message,'COLL')

     call vee2udensatom_hu(ndim,udens_atoms(iatom)%value,veetemp)

!     udens_atoms(iatom)%value=zero
!     ij=0
!     do ms=1,2*ndim-1
!       do ms1=ms+1,2*ndim 
!         ij=ij+1
!         if(ms<=ndim.and.ms1>ndim) then
!           m1 = ms1 - ndim
!           m  = ms
!           hu(itypat)%uqmc(ij)=veetemp(m,m1,m,m1)
!           udens_atoms(iatom)%value(ms,ms1)= veetemp(m,m1,m,m1)
!           udens_atoms(iatom)%value(ms1,ms)= udens_atoms(iatom)%value(ms,ms1)
!         else if(ms<=ndim.and.ms1<=ndim) then
!           m1 = ms1
!           m  = ms
!           hu(itypat)%uqmc(ij)=veetemp(m,m1,m,m1)-veetemp(m,m1,m1,m)
!           udens_atoms(iatom)%value(ms,ms1)= hu(itypat)%uqmc(ij)
!           udens_atoms(iatom)%value(ms1,ms)= udens_atoms(iatom)%value(ms,ms1)
!         else
!           m1 = ms1 - ndim
!           m  = ms  - ndim
!           hu(itypat)%uqmc(ij)=veetemp(m,m1,m,m1)-veetemp(m,m1,m1,m)
!           udens_atoms(iatom)%value(ms,ms1)= hu(itypat)%uqmc(ij)
!           udens_atoms(iatom)%value(ms1,ms)= udens_atoms(iatom)%value(ms,ms1)
!         endif
!       enddo
!     enddo
!     write(message,'(a,5x,a)') ch10,"-------- Interactions in the density matrix representation "
!     call wrtout(std_out,  message,'COLL')
!     write(message,'(1x,14(2x,i5))') (m,m=1,2*ndim)
!     call wrtout(std_out,  message,'COLL')
!     do ms=1,2*ndim
!        write(message,'(i3,14f7.3)') &
!&        ms, (udens_atoms(iatom)%value(ms,ms1),ms1=1,2*ndim)
!        call wrtout(std_out,  message,'COLL')
!     enddo
!     write(message,'(5x,a)') "--------------------------------------------------------"
!     call wrtout(std_out,  message,'COLL')
     ABI_DEALLOCATE(veetemp)
   endif
! call print_hu(hu,cryst_struc%ntypat,1)

 enddo ! iatom
! call print_hu(hu,cryst_struc%ntypat,1)
! call vee2udens_hu(hu,cryst_struc%ntypat,2)


end subroutine rotatevee_hu
!!***

!!****f* m_hu/printvee_hu
!! NAME
!! print_hu
!!
!! FUNCTION
!!  print vee 
!!
!! INPUTS
!!  vee = number of species
!!  lpawu = value of l
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine printvee_hu(ndim,vee)

 use defs_basis
 use m_crystal, only : crystal_structure

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'printvee_hu'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 integer,intent(in) :: ndim
 real(dp), intent(in) :: vee(ndim,ndim,ndim,ndim)

!Local variables-------------------------------
 integer :: m1,m2,mi,mj,mk,ml
 character(len=500) :: message
! *********************************************************************
 write(message,'(2a)')  ch10," <mi,mi|vee|mi mi> : U1"
 call wrtout(std_out,  message,'COLL')
 do mi=1,ndim
     write(message,'(4i4,f10.5)')   mi,mi,mi,mi,vee(mi,mi,mi,mi)
     call wrtout(std_out,  message,'COLL')
 enddo
 write(message,'(2a)')  ch10," <mi,mj|vee|mi mj> : U2"
 call wrtout(std_out,  message,'COLL')
 do mi=1,ndim
   do mj=mi+1,ndim
     write(message,'(4i4,f10.5)')   mi,mj,mi,mj,vee(mi,mj,mi,mj)
     call wrtout(std_out,  message,'COLL')
   enddo
 enddo
 write(message,'(2a)')  ch10," <mi,mj|vee|mj mi> : J"
 call wrtout(std_out,  message,'COLL')
 do mi=1,ndim
   do mj=mi+1,ndim
     write(message,'(4i4,f10.5)')   mi,mj,mj,mi,vee(mi,mj,mj,mi)
     call wrtout(std_out,  message,'COLL')
   enddo
 enddo
 write(message,'(2a)')  ch10," <mi,mi|vee|mj mj> : J"
 call wrtout(std_out,  message,'COLL')
 do mi=1,ndim
   do mj=mi+1,ndim
     write(message,'(4i4,f10.5)')   mi,mi,mj,mj,vee(mi,mi,mj,mj)
     call wrtout(std_out,  message,'COLL')
   enddo
 enddo
 write(message,'(2a)')  ch10," vee is non zero also for"
 call wrtout(std_out,  message,'COLL')
 do mi=1,ndim
   do mj=1,ndim
     do mk=1,ndim
       do ml=1,ndim
          if((.not.(mi==mk.and.mj==ml)).and.(.not.(mi==ml.and.mj==mk)).and.&
&             .not.(mi==mj.and.mk==ml)) then
            if(vee(mi,mj,mk,ml)>tol8) then
              write(message,'(4i4,f10.5)')   mi,mj,mk,ml,vee(mi,mj,mk,ml)
              call wrtout(std_out,  message,'COLL')
            endif
          endif
       enddo
     enddo
   enddo
 enddo
 write(message,'(a)')  ch10
 call wrtout(std_out,  message,'COLL')

 do m1=1,ndim
    write(message,'(a,14f7.3)') "vee     u",&
&     (vee(m1,m2,m1,m2),m2=1,ndim)
    call wrtout(std_out,  message,'COLL')
 enddo
 write(message,'(a)') ch10
 call wrtout(std_out,  message,'COLL')
 do m1=1,ndim
    write(message,'(a,14f7.3)') "vee     j",&
&    (vee(m1,m2,m2,m1),m2=1,ndim)
    call wrtout(std_out,  message,'COLL')
 enddo


end subroutine printvee_hu
!!***

!!****f* m_hu/vee2udensatom_hu
!! NAME
!! vee2udensatom_hu
!!
!! FUNCTION
!!  print density density interaction (used for DFT+DMFT)
!!
!! INPUTS
!!  ntypat = number of species
!!  hu <type(hu_type)> = data for the interaction in DMFT. 
!!
!! OUTPUT
!!
!! PARENTS
!!      m_hu
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

subroutine vee2udensatom_hu(ndim,udens_atoms,veetemp)

 use defs_basis
 use m_crystal, only : crystal_structure

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'vee2udensatom_hu'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!type
 integer, intent(in):: ndim
 real(dp),intent(out) :: udens_atoms(2*ndim,2*ndim)
 real(dp), intent(in) :: veetemp(ndim,ndim,ndim,ndim)

!Local variables-------------------------------
 integer :: ij,ms,ms1,m,m1
 character(len=1000) :: message
! *********************************************************************
 
 udens_atoms=zero
 ij=0
 do ms=1,2*ndim-1
   do ms1=ms+1,2*ndim 
     ij=ij+1
     if(ms<=ndim.and.ms1>ndim) then
       m1 = ms1 - ndim
       m  = ms
!       hu(itypat)%uqmc(ij)=veetemp(m,m1,m,m1)
       udens_atoms(ms,ms1)= veetemp(m,m1,m,m1)
       udens_atoms(ms1,ms)= udens_atoms(ms,ms1)
     else if(ms<=ndim.and.ms1<=ndim) then
       m1 = ms1
       m  = ms
!       hu(itypat)%uqmc(ij)=veetemp(m,m1,m,m1)-veetemp(m,m1,m1,m)
       udens_atoms(ms,ms1)= veetemp(m,m1,m,m1)-veetemp(m,m1,m1,m)
       udens_atoms(ms1,ms)= udens_atoms(ms,ms1)
     else
       m1 = ms1 - ndim
       m  = ms  - ndim
!       hu(itypat)%uqmc(ij)=veetemp(m,m1,m,m1)-veetemp(m,m1,m1,m)
       udens_atoms(ms,ms1)= veetemp(m,m1,m,m1)-veetemp(m,m1,m1,m)
       udens_atoms(ms1,ms)= udens_atoms(ms,ms1)
     endif
   enddo
 enddo

 write(message,'(a,5x,a)') ch10,&
& "-------- Interactions in the density density representation are "
 call wrtout(std_out,  message,'COLL')
 write(message,'(1x,14(2x,i5))') (m,m=1,2*ndim)
 call wrtout(std_out,  message,'COLL')
 do ms=1,2*ndim
    write(message,'(i3,14f7.3)') &
&    ms, (udens_atoms(ms,ms1),ms1=1,2*ndim)
    call wrtout(std_out,  message,'COLL')
 enddo
 write(message,'(5x,a)') "--------------------------------------------------------"
 call wrtout(std_out,  message,'COLL')

end subroutine vee2udensatom_hu
!!***

!!****f* m_hu/reddd
!! NAME
!! reddd
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

function reddd(mi,ndim)
    
 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'reddd'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mi,ndim
 integer :: reddd
! *************************************************************************

 if(mi<ndim+1)  reddd=mi
 if(mi>=ndim+1) reddd=mi-ndim

end function reddd

END MODULE m_hu
!!***
