!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_mkrho
!! NAME
!! wvl_mkrho
!!
!! FUNCTION
!! This method is just a wrapper around the BigDFT routine to compute the
!! density from the wavefunctions.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  mpi_enreg=informations about MPI parallelization
!!  occ(dtset%mband)=occupation numbers.
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  wfs <type(wvl_projector_type)>=wavefunctions informations for wavelets.
!!
!! OUTPUT
!!  rhor(dtset%nfft)=electron density in r space
!!
!! SIDE EFFECTS
!!  proj <type(wvl_projector_type)>=projectors informations for wavelets.
!!   | proj(OUT)=computed projectors.
!!
!! PARENTS
!!      afterscfloop,gstate,mkrho,scfcv_new
!!
!! CHILDREN
!!      communicate_density,sumrho,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine wvl_mkrho(dtset, irrzon, mpi_enreg, phnons, rhor, wfs, wvl_den)

 use defs_basis
 use defs_abitypes
 use defs_wvltypes
 use m_profiling
 use m_errors
 use m_xmpi
#if defined HAVE_DFT_BIGDFT
  use BigDFT_API, only : sumrho, symmetry_data, ELECTRONIC_DENSITY, communicate_density
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'wvl_mkrho'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments -------------------------------
!scalars
 type(MPI_type),intent(in) :: mpi_enreg
 type(dataset_type),intent(in) :: dtset
 type(wvl_wf_type),intent(inout) :: wfs
 type(wvl_denspot_type), intent(inout) :: wvl_den
!arrays
 real(dp),intent(inout) :: rhor(dtset%nfft,dtset%nspden)
 integer, target, intent(in) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,  &
&               (dtset%nspden/dtset%nsppol)-3*(dtset%nspden/4))
 real(dp), target, intent(in) :: phnons(2,(dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3))**(1-1/dtset%nsym),  &
&                                 (dtset%nspden/dtset%nsppol)-3*(dtset%nspden/4))

!Local variables-------------------------------
!scalars
 character(len=500) :: message
#if defined HAVE_DFT_BIGDFT
 integer :: comm,ifft,ii,ispden,me,nproc
 type(symmetry_data) :: sym
#endif

! *************************************************************************

#if defined HAVE_DFT_BIGDFT
 comm=mpi_enreg%comm_cell
 me=xcomm_rank(comm)
 nproc=xcomm_size(comm)

 sym%symObj = wvl_den%symObj
 sym%irrzon => irrzon
 sym%phnons => phnons

 call sumrho(me, nproc, wfs%ks%orbs, wfs%ks%lzd, &
& wvl_den%denspot%dpbox%hgrids(1), wvl_den%denspot%dpbox%hgrids(2), wvl_den%denspot%dpbox%hgrids(3), &
& wvl_den%denspot%dpbox%nscatterarr,wfs%GPU, sym, wvl_den%denspot%rhod,&
& wfs%ks%psi, wvl_den%denspot%rho_psi)

 call communicate_density(me,nproc,wfs%ks%orbs%nspin,&
& wvl_den%denspot%dpbox%hgrids(1), wvl_den%denspot%dpbox%hgrids(2), wvl_den%denspot%dpbox%hgrids(3),&
& wfs%ks%Lzd, wvl_den%denspot%rhod, wvl_den%denspot%dpbox%nscatterarr, &
& wvl_den%denspot%rho_psi, wvl_den%denspot%rhov, .false.)

 wvl_den%denspot%rhov_is = ELECTRONIC_DENSITY
 write(message, '(a,a,a,a)' ) ch10, ' wvl_mkrho : but why are you copying me :..o('
 call wrtout(std_out,message,'COLL')

!There seems to be a bug in the intel11 compiler
!rhor = reshape(wvl_den%denspot%rhov, shape(rhor))
 do ispden=1,dtset%nspden
   do ifft=1,dtset%nfft
     ii=ifft+dtset%nfft*(ispden-1)
     rhor(ifft,ispden)=wvl_den%denspot%rhov(ii)
   end do
 end do

#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_mkrho : BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 MSG_ERROR(message)
#endif
end subroutine wvl_mkrho
!!***
