!{\src2tex{textfont=tt}}
!!****f* ABINIT/outwf
!! NAME
!! outwf
!!
!! FUNCTION
!! Conduct output of a "wave-functions" file.
!!  - Compute the maximal residual
!!  - Then open a permanent file wff2 for final output of wf data
!!  - Create a new header for the file.
!!  - Write wave-functions (and energies)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (DCA, XG, GMR, AR, MB, MVer)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  cg(2,mcg)=wavefunction array (storage if nkpt>1)
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  eigen( (2*mband)**response *mband*nkpt*nsppol)=
!!                  eigenvalues (hartree) for all bands at each k point
!!  filnam= character string giving the root to form the name of the
!!   output WFK or WFQ file if response==0, otherwise it is the filename.
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  kg(3,mpw*mkmem)=reduced planewave coordinates.
!!  kptns(3,nkpt)=k points in terms of recip primitive translations
!!  mband=maximum number of bands
!!  mcg=size of wave-functions array (cg) =mpw*nspinor*mband*mkmem*nsppol
!!  mkmem=maximum number of k-points in core memory
!!  mpi_enreg=informations about MPI parallelization
!!  mpw=maximum number of plane waves
!!  mxfh=last dimension of the xfhist array
!!  natom=number of atoms in unit cell
!!  nband=number of bands
!!  nkpt=number of k points
!!  npwarr(nkpt)=number of planewaves in basis and on boundary for each k
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  nstep=desired number of electron iteration steps
!!  nxfh=actual number of (x,f) history pairs, see xfhist array.
!!  occ(mband*nkpt*nsppol)=occupations for all bands at each k point
!!  resid(mband*nkpt*nsppol)=squared residuals for each band and k point
!!   where resid(n,k)=|<C(n,k)|(H-e(n,k))|C(n,k)>|^2 for the ground state
!!  response: if == 0, GS wavefunctions , if == 1, RF wavefunctions
!!  unwff2=unit for output of wavefunction
!!  wffnow=structure information for current wavefunction (if nkpt>1)
!!  xfhist(3,natom+4,2,mxfh)=(x,f) history array,
!!                                 also includes rprim and stress
!!  wfs <type(wvl_projector_type)>=wavefunctions informations for wavelets.
!!
!! OUTPUT
!!  (only writing)
!!
!! NOTES
!! * The name of the file wff2 might be the same as that of the file wff1.
!! * The routine includes closing wffnow.
!!
!! PARENTS
!!      berryphase_new,gstate,loper3
!!
!! CHILDREN
!!      hdr_io,hdr_io_etsf,hdr_skip,leave_test,rwwf,timab,wffclose,wffdelete
!!      wffkg,wffoffset,wffopen,wrtout,wvl_write,xbarrier_mpi,xdefineoff
!!      xexch_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine outwf(cg,dtset,eigen,filnam,hdr,kg,kptns,mband,mcg,mkmem,&
&                mpi_enreg,mpw,mxfh,natom,nband,nkpt,npwarr,&
&                nsppol,nstep,nxfh,occ,resid,response,unwff2,&
&                wffnow,wfs,wvl,xfhist)

 use defs_basis
 use defs_abitypes
 use defs_wvltypes
 use m_profiling
 use m_errors
 use m_xmpi
 use m_wffile
#if defined HAVE_MPI2
 use mpi
#endif

 use m_header,       only : hdr_skip, hdr_io_etsf, hdr_io

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'outwf'
 use interfaces_14_hidewrite
 use interfaces_18_timing
 use interfaces_32_util
 use interfaces_51_manage_mpi
 use interfaces_59_io_mpi
 use interfaces_62_wvl_wfs
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif
!Arguments ------------------------------------
 integer, intent(in) :: mband,mcg,mkmem,mpw,mxfh,natom,nkpt,nsppol
 integer, intent(in) :: nstep,nxfh,response,unwff2
 character(len=fnlen), intent(in) :: filnam
 type(MPI_type), intent(inout) :: mpi_enreg
 type(dataset_type), intent(in) :: dtset
 type(hdr_type), intent(inout) :: hdr
 type(wffile_type), intent(inout) :: wffnow
 type(wvl_wf_type), intent(in) :: wfs
 type(wvl_internal_type), intent(in) :: wvl
 integer, intent(in) :: kg(3,mpw*mkmem),nband(nkpt*nsppol),npwarr(nkpt)
 real(dp), intent(inout) :: cg(2,mcg)
 real(dp), intent(in) :: eigen((2*mband)**response*mband*nkpt*nsppol),kptns(3,nkpt)
 real(dp), intent(in) :: occ(mband*nkpt*nsppol),resid(mband*nkpt*nsppol)
 real(dp), intent(in) :: xfhist(3,natom+4,2,mxfh)

!Local variables-------------------------------
 integer,parameter :: nkpt_max=50
 integer :: accesswff,action,band_index,fform,formeig,headform,iband,ibdkpt,icg
 integer :: icg0,ierr,ii,ikg,ikpt,isppol,ixfh,master,mcg_disk,me,me0,my_nspinor
 integer :: nband_disk,nband_k,nkpt_eff,nmaster,npw_k,option,optkg,rdwr,sender,source
 integer :: spaceComm,spaceComm_io,spacecomsender,spaceWorld,sread,sskip,tim_rwwf
 integer :: xfdim2
#if defined HAVE_MPI
 integer :: ipwnbd
#endif
 real(dp) :: residk,residm,resims
 logical :: mydata,swrite,tmaster
 character(len=500) :: message
 type(wffile_type) :: wff2
 integer,allocatable :: kg_disk(:,:)
 real(dp) :: tsec(2)
!There are two cases of use of the cg_disk : if mkmem==0, or parallel treatment.
 real(dp),allocatable :: cg_disk(:,:),eig_dum(:),eig_k(:),occ_dum(:),occ_k(:)

! *************************************************************************
!For readability of the source file, define a "me" variable also in the sequential case

 DBG_ENTER("COLL")

 xfdim2 = natom+4
!Init mpi_comm
 spaceWorld= mpi_enreg%comm_cell
 spaceComm=spaceWorld
 spaceComm_io=xmpi_self
 if (mpi_enreg%paral_kgb==1 ) spaceComm_io= mpi_enreg%comm_bandspinorfft
 if (mpi_enreg%paral_kgb==1 ) spaceComm= mpi_enreg%comm_cell

!Paral_kgb=1 and Fortran-I/O is not supported (only for testing purpose)
 if (mpi_enreg%paral_kgb==1.and.dtset%accesswff==0) then
   spaceWorld=mpi_enreg%comm_kpt
   write(message,'(7a)') &
&   '  WF file is written using standard Fortran I/O',ch10,&
&   '   and Kpt-band-FFT parallelization is active !',ch10,&
&   '   This is only allowed for testing purposes.',ch10,&
&   '   The produced WF file will be incomplete and not useable.'
   MSG_WARNING(message)
 end if

!Init me
 me=mpi_enreg%me_kpt
 me0=me
!Define master
 master=0



 my_nspinor=max(1,dtset%nspinor/mpi_enreg%nproc_spinor)
 tim_rwwf =0
 source = master
 sread = master
 tmaster=(master==me)
 swrite=tmaster
 sender=-1

!Compute mean square and maximum residual over all bands and k points and spins
!(disregard k point weights and occupation numbers here)
 band_index=sum(nband(1:nkpt*nsppol))
 resims=sum(resid(1:band_index))/dble(band_index)

!Find largest residual over bands, k points, and spins, except for nbdbuf highest bands
!Already AVAILABLE in hdr ?!
 ibdkpt=1
 residm=zero
 do isppol=1,nsppol
   do ikpt=1,nkpt
     nband_k=nband(ikpt+(isppol-1)*nkpt)
     nband_k=max(1,nband_k-dtset%nbdbuf)
     residm=max(residm,maxval(resid(ibdkpt:ibdkpt+nband_k-1)))
     ibdkpt=ibdkpt+nband_k
   end do
 end do

 write(message,'(a,1p,e12.4,a,e12.4)')' Mean square residual over all n,k,spin= ',resims,'; max=',residm
 call wrtout(ab_out,message,'COLL')

 band_index=0
 nkpt_eff=nkpt
 if( (dtset%prtvol==0 .or. dtset%prtvol==1) .and. nkpt_eff>nkpt_max ) nkpt_eff=nkpt_max

!Loop over spin again
 do isppol=1,nsppol
!  Give (squared) residuals for all bands at each k
   do ikpt=1,nkpt
     nband_k=nband(ikpt+(isppol-1)*nkpt)
!    Will not print all residuals when prtvol=0 or 1
     if(ikpt<=nkpt_eff)then
!      Find largest residual over all bands for given k point
       residk=maxval(resid(1+band_index:nband_k+band_index))
       write(message,'(1x,3f8.4,3x,i2,1p,e13.5,a)')kptns(1:3,ikpt),isppol,residk,' kpt; spin; max resid(k); each band:'
       call wrtout(ab_out,message,'COLL')
       do ii=0,(nband_k-1)/8
         write(message,'(1x,1p,8e9.2)')(resid(iband+band_index),iband=1+ii*8,min(nband_k,8+ii*8))
         call wrtout(ab_out,message,'COLL')
       end do
     else if(ikpt==nkpt_eff+1)then
       write(message,'(2a)')' outwf : prtvol=0 or 1, do not print more k-points.',ch10
       call wrtout(ab_out,message,'COLL')
     end if
     band_index=band_index+nband_k
   end do
 end do

!Will write the wavefunction file only when nstep>0
 if (nstep>0 .and. dtset%prtwf/=0) then

!  Only the master write the file, except if MPI I/O, but the
!  full wff dataset should be provided to WffOpen in this case
   accesswff=-1
   if(dtset%accesswff==1) then
     accesswff=1
   else if (dtset%accesswff == 3) then
     accesswff = 3
   end if

   write(message,'(4a,i0)')ch10,' outwf: write wavefunction to file ',trim(filnam),", with accesswff ",accesswff
   call wrtout(std_out,message,'COLL')


   call WffOpen(accesswff,spaceComm,filnam,ierr,wff2,master,me0,unwff2,spaceComm_io)
!  Conduct wavefunction output to wff2

   ABI_ALLOCATE(kg_disk,(3,mpw))

   mcg_disk=mpw*my_nspinor*mband
   formeig=0; if(response==1)formeig=1
   if (mkmem == 0) then
     ABI_ALLOCATE(eig_dum,( (2*mband)**formeig * mband))
     ABI_ALLOCATE(occ_dum,(mband))
   end if
   ABI_ALLOCATE(eig_k,( (2*mband)**formeig * mband))
   ABI_ALLOCATE(occ_k,(mband))

#if defined HAVE_MPI
   call leave_test()
!  Compute mband and mpw
   if(mkmem/=0) then
     ABI_ALLOCATE(cg_disk,(2,mcg_disk))
   end if
#endif

   if (mkmem==0) then
!    Skip wffnow header
     call hdr_skip(wffnow,ierr)

     ABI_ALLOCATE(cg_disk,(2,mcg_disk))
!    Define offsets, in case of MPI I/O
     call WffKg(wffnow,1)
     call xdefineOff(formeig,wffnow,mpi_enreg,nband,npwarr,dtset%nspinor,nsppol,nkpt)
   end if  !mkmem = 0


   band_index=0
   icg=0
   if(mpi_enreg%paralbd==0) tim_rwwf=6
   if(mpi_enreg%paralbd==1) tim_rwwf=12

!  Write header info for new wf file
   rdwr=2
   if (dtset%usewvl == 0) then
     fform=2
   else
!    Use 200 as radical for naming file format used by wavelets.
     fform = 200
   end if

   if (wff2%accesswff < 2) then
     call hdr_io(fform,hdr,rdwr,wff2)
     call WffKg(wff2,1)
   else if (wff2%accesswff == 3 .and. tmaster) then
     call hdr_io_etsf(fform, hdr, rdwr, wff2%unwff)
   end if

   do isppol=1,nsppol
     ikg=0

     do ikpt=1,nkpt
       nband_k=nband(ikpt+(isppol-1)*nkpt)
       npw_k=npwarr(ikpt)

!      Read the wavefunction block, without the eigenvalues
       if(mkmem==0)then
#if defined HAVE_MPI
         sread=-1
         if(.not.(proc_distrb_cycle(mpi_enreg%proc_distrb,ikpt,1,nband_k,isppol,me))) sread=me
#endif
         if(sread==me)then

           headform=0 ; icg0=0 ; option=-2 ; optkg=1
           call rwwf(cg_disk,eig_dum,formeig,headform,&
&           icg0,ikpt,isppol,kg_disk,mband,mcg_disk,mpi_enreg,nband_k,nband_disk,&
&           npw_k,my_nspinor,occ_dum,option,optkg,tim_rwwf,wffnow)

           if (nband_k/=nband_disk) then
             write(message, '(a,i0,a,i0,3a,i0,a)' )&
&             ' For kpt number',ikpt,' disk file has',nband_disk,' bands',ch10,&
&             ' but input file gave nband=',nband_k,'.'
             MSG_BUG(message)
           end if

         end if ! sread==me
       end if ! mkmem

#if defined HAVE_MPI
       if (dtset%usewvl == 0) then
         call xbarrier_mpi(spaceWorld)

!        Must transfer the wavefunctions to the master processor
!        Separate sections for paralbd=1 or other values ; might be merged
         if(mpi_enreg%paralbd==0)then
           nmaster=0
           source=minval(mpi_enreg%proc_distrb(ikpt,1:nband_k,isppol))
           mydata=.false.
           if(source==me)mydata=.true.
           action=0
!          I am the master node, and I have the data in cg or cg_disk
           if((tmaster).and.(mydata))action=1
!          I am not the master, and I have the data => send to master
           if((.not.tmaster).and.(mydata))action=2
!          I am the master, and I receive the data
           if((tmaster).and.(.not.mydata))action=3

!          I have the data in cg or cg_disk ( MPI_IO case)
           if (accesswff==1  ) then
             action = 0
             sender=-1
             swrite=.false.
             if (mydata)then
               action=1
               swrite=.true.
               sender=me
             end if
           end if

!          I am the master node, and I have the data in cg or cg_disk
!          I have the data in cg or cg_disk ( MPI_IO case)
           if(action==1)then
             if(mkmem/=0)then
!              Copy from kg to kg_disk
               kg_disk(:,1:npw_k)=kg(:,1+ikg:npw_k+ikg)
!              Copy from cg to cg_disk
               do ipwnbd=1,nband_k*npw_k*my_nspinor
                 cg_disk(1,ipwnbd)=cg(1,ipwnbd+icg)
                 cg_disk(2,ipwnbd)=cg(2,ipwnbd+icg)
               end do
             end if
           end if

!          I am not the master, and I have the data => send to master
!          I am the master, and I receive the data
           if ( action==2.or.action==3) then
             call timab(48,1,tsec)
             if(mkmem/=0 .and. action==2)then
               call xexch_mpi(kg(:,1+ikg:npw_k+ikg),3*npw_k,source,kg_disk,nmaster,spaceWorld,ierr)
               call xexch_mpi(cg(:,icg+1:icg+nband_k*npw_k*my_nspinor),2*nband_k*npw_k*my_nspinor, &
&               source,cg_disk,nmaster,spaceWorld,ierr)
             else
               call xexch_mpi(kg_disk,3*npw_k,source,kg_disk,nmaster,spaceWorld,ierr)
               call xexch_mpi(cg_disk,2*nband_k*npw_k*my_nspinor,source,cg_disk,nmaster, &
&               spaceWorld,ierr)
             end if
             call timab(48,2,tsec)
           end if


         else if(mpi_enreg%paralbd==1)then
           nmaster=0
#if defined HAVE_MPI_IO
           sender=-1
           if( accesswff ==1 ) then
             nmaster=mpi_enreg%proc_distrb(ikpt,1,isppol)
             sender=nmaster
           end if
#endif

!          Note the loop over bands
           do iband=1,nband_k

!            The message passing related to kg is counted as one band
             action=0

!            I am the master node, and I have the data in cg or cg_disk
             if( mpi_enreg%proc_distrb(ikpt,iband,isppol)==nmaster .and. &
&             me==nmaster) then
               action=1
!              I am not the master, and I have the data => send to master
             elseif( mpi_enreg%proc_distrb(ikpt,iband,isppol)==me &
&               .and. me/=nmaster ) then
               action = 2
!              I am the master, and I receive the data
             elseif( mpi_enreg%proc_distrb(ikpt,iband,isppol)/=me &
&               .and. me==nmaster ) then
               action=3
             end if

             if(action==1) then
!              I am the master node, and I have the data in cg or cg_disk
               if(mkmem/=0)then
!                Copy from kg to kg_disk
                 if(iband==1)kg_disk(:,1:npw_k)=kg(:,1+ikg:npw_k+ikg)
!                Copy from cg to cg_disk
                 do ipwnbd=1,npw_k*my_nspinor
                   cg_disk(1,(iband-1)*npw_k*my_nspinor+ipwnbd)= &
&                   cg(1,(iband-1)*npw_k*my_nspinor+ipwnbd+icg)
                   cg_disk(2,(iband-1)*npw_k*my_nspinor+ipwnbd)= &
&                   cg(2,(iband-1)*npw_k*my_nspinor+ipwnbd+icg)
                 end do
               end if
             end if  ! action=1

             if ( action==2.or.action==3) then
!              action=2 :  I am not the master, and I have the data => send to master
!              action=3 :  I am the master, and I receive the data
               call timab(48,1,tsec)
               if ( iband == 1 ) then
                 if ( mkmem/=0 .and. action==2) then
                   call xexch_mpi(kg(:,1+ikg:npw_k+ikg),3*npw_k,mpi_enreg%proc_distrb(ikpt,iband,isppol), &
&                   kg_disk,nmaster,spaceWorld,ierr)
                 else
                   call xexch_mpi(kg_disk,3*npw_k,mpi_enreg%proc_distrb(ikpt,iband,isppol),  &
&                   kg_disk,nmaster,spaceWorld,ierr)
                 end if
               end if       ! iband =1
               ipwnbd=(iband-1)*npw_k*my_nspinor
               if(mkmem/=0 .and. action==2)then
                 call xexch_mpi( cg(:,ipwnbd+icg+1:ipwnbd+icg+npw_k*my_nspinor),2*npw_k*my_nspinor &
&                 ,mpi_enreg%proc_distrb(ikpt,iband,isppol)                    &
&                 ,cg_disk(:,ipwnbd+1:ipwnbd+npw_k*my_nspinor),nmaster,spaceWorld,ierr)
               else
                 call xexch_mpi( cg_disk(:,ipwnbd+1:ipwnbd+npw_k*my_nspinor),2*npw_k*my_nspinor    &
&                 ,mpi_enreg%proc_distrb(ikpt,iband,isppol)                    &
&                 ,cg_disk(:,ipwnbd+1:ipwnbd+npw_k*my_nspinor),nmaster,spaceWorld,ierr)
               end if

               call timab(48,2,tsec)
             end if        ! action=2 or action=3

             if(accesswff ==1 ) then
!              I have the data in cg or cg_disk
               swrite=.false.
               if (nmaster == me) then
                 swrite=.true.
               end if
             end if

           end do ! End of loop over bands
         end if ! End of paralbd=1
       end if
#endif

!      Only the master will write to disk the final output wf file.
!      in MPI_IO case only swrite will write to disk the final output wf file.
       if(swrite) then
!        DEBUG
!        write(std_out,*) 'outwf : I am master and will write wf file'
!        ENDDEBUG
         if(formeig==0)then
           eig_k(1:nband_k)=eigen(1+band_index:nband_k+band_index)
           occ_k(1:nband_k)=occ(1+band_index:nband_k+band_index)
         else
           eig_k(1:2*nband_k*nband_k)=eigen(1+band_index:2*nband_k*nband_k+band_index)
         end if
         option=2
         if(dtset%prtwf==3)option=5
!        if (dtset%prtwf == 2 .and. mkmem/=0) option=4

         if (dtset%usewvl == 0) then
#if defined HAVE_MPI
           call rwwf(cg_disk,eig_k,formeig,0,0,ikpt,isppol,kg_disk,mband,mcg_disk,mpi_enreg, &
&           nband_k, nband_k,npw_k,my_nspinor,occ_k,option,1,tim_rwwf,wff2)
#elif !defined HAVE_MPI
           if(mkmem==0)then
             call rwwf(cg_disk,eig_k,formeig,0,0,ikpt,isppol,kg_disk,mband,mcg_disk,mpi_enreg, &
&             nband_k,nband_k, npw_k,my_nspinor,occ_k,2,1,tim_rwwf,wff2)
           else if(mkmem/=0)then
             kg_disk(:,1:npw_k)=kg(:,1+ikg:npw_k+ikg)
             call rwwf(cg,eig_k,formeig,0,icg,ikpt,isppol,kg_disk,mband,mcg,mpi_enreg,nband_k, &
&             nband_k, npw_k,my_nspinor,occ_k,option,1,tim_rwwf,wff2)
           end if
#endif
         else
           call wvl_write(dtset, eigen, mpi_enreg, option, hdr%rprimd, &
&           wff2, wfs, wvl, hdr%xred)
         end if
       end if

!      The wavefunctions for the present k point and spin are written
       if(response==0)band_index=band_index+nband_k
       if(response==1)band_index=band_index+2*nband_k*nband_k

       if (mkmem/=0) then

         sskip=1
#if defined HAVE_MPI
         if (dtset%usewvl == 0) then
           sskip=0
           if(.not.(proc_distrb_cycle(mpi_enreg%proc_distrb,ikpt,1,nband_k,isppol,me)))sskip=1
         end if
#endif
         if(sskip==1)then
           icg=icg+npw_k*my_nspinor*nband_k
           ikg=ikg+npw_k
         end if

       end if !mkem/=0


#if defined HAVE_MPI_IO
       spacecomsender=spaceComm
       if (mpi_enreg%paral_kgb==1) spacecomsender =mpi_enreg%comm_kpt
       call WffOffset(wff2,sender,spacecomsender,ierr)
#endif

     end do ! ikpt
   end do ! isppol

   ABI_DEALLOCATE(kg_disk)
   if(mkmem==0) then
     ABI_DEALLOCATE(cg_disk)
   end if
#if defined HAVE_MPI
   if(mkmem/=0) then
     ABI_DEALLOCATE(cg_disk)
   end if
#endif

   if(mkmem==0)  then
     ABI_DEALLOCATE(eig_dum)
     ABI_DEALLOCATE(occ_dum)
   end if
   ABI_DEALLOCATE(eig_k)
   ABI_DEALLOCATE(occ_k)

!  Write the (x,f) history
   if(me0==0 .and. nxfh>0 .and. response==0)then
     if (wff2%accesswff /= 2) then
#if defined HAVE_MPI_IO
       if(wff2%accesswff == 1 ) then
         close(unit=wff2%unwff)
!        the file is to be positioned at the terminal point
         open(unit=wff2%unwff,file=wff2%fname,form='unformatted',POSITION="APPEND")
       end if
#endif
       write(unit=wff2%unwff)nxfh
       do ixfh=1,nxfh
         write(unit=wff2%unwff)xfhist(:,:,:,ixfh)
       end do
     end if
   end if

!  Close the wavefunction file (and do NOT delete it !)
   if (wff2%accesswff /= 2) then
     call WffClose(wff2,ierr)
   end if
!  
 end if ! End condition of nstep>0

!Close the temporary data file, if any
 if (mkmem==0) then
   call WffDelete(wffnow,ierr)
 end if

 DBG_EXIT("COLL")

end subroutine outwf
!!***
