!{\src2tex{textfont=tt}}
!!****f* ABINIT/psps_free
!! NAME
!! psps_free
!!
!! FUNCTION
!! Deallocate all memory of psps structure.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2012 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!! psps=<type pseudopotential_type>the pseudopotentials description
!!
!! PARENTS
!!      driver
!!
!! CHILDREN
!!      psp2params_free
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine psps_free(psps)

 use m_profiling

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'psps_free'
 use interfaces_65_psp, except_this_one => psps_free
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(pseudopotential_type),intent(inout) :: psps
!arrays

!Local variables-------------------------------
!scalars

! *************************************************************************

!Allocation of some arrays independent of the dataset
 if (associated(psps%filpsp))  then
   ABI_DEALLOCATE(psps%filpsp)
 end if
 if (associated(psps%pspcod))  then
   ABI_DEALLOCATE(psps%pspcod)
 end if
 if (associated(psps%pspdat))  then
   ABI_DEALLOCATE(psps%pspdat)
 end if
 if (associated(psps%pspso))  then
   ABI_DEALLOCATE(psps%pspso)
 end if
 if (associated(psps%pspxc))  then
   ABI_DEALLOCATE(psps%pspxc)
 end if
 if (associated(psps%title))  then
   ABI_DEALLOCATE(psps%title)
 end if
 if (associated(psps%zionpsp))  then
   ABI_DEALLOCATE(psps%zionpsp)
 end if
 if (associated(psps%znuclpsp))  then
   ABI_DEALLOCATE(psps%znuclpsp)
 end if

 call psp2params_free(psps%gth_params)

 if (associated(psps%algalch))  then
   ABI_DEALLOCATE(psps%algalch)
 end if
 if (associated(psps%mixalch))  then
   ABI_DEALLOCATE(psps%mixalch)
 end if
 if (associated(psps%ekb))  then
   ABI_DEALLOCATE(psps%ekb)
 end if
 if (associated(psps%indlmn))  then
   ABI_DEALLOCATE(psps%indlmn)
 end if
 if (associated(psps%ffspl))  then
   ABI_DEALLOCATE(psps%ffspl)
 end if
 if (associated(psps%qgrid_ff))  then
   ABI_DEALLOCATE(psps%qgrid_ff)
 end if
 if (associated(psps%qgrid_vl))  then
   ABI_DEALLOCATE(psps%qgrid_vl)
 end if
 if (associated(psps%vlspl))  then
   ABI_DEALLOCATE(psps%vlspl)
 end if

 if (.not.psps%vlspl_recipSpace) then
   if (associated(psps%dvlspl))  then
     ABI_DEALLOCATE(psps%dvlspl)
   end if
 end if
 if (associated(psps%xccc1d))  then
   ABI_DEALLOCATE(psps%xccc1d)
 end if
 if (associated(psps%xcccrc))  then
   ABI_DEALLOCATE(psps%xcccrc)
 end if
 if (associated(psps%ziontypat))  then
   ABI_DEALLOCATE(psps%ziontypat)
 end if
 if (associated(psps%znucltypat))  then
   ABI_DEALLOCATE(psps%znucltypat)
 end if

end subroutine psps_free
!!***
