!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_psitohpsi
!! NAME
!! wvl_psitohpsi
!!
!! FUNCTION
!! Compute new trial potential and calculate the hamiltionian application into hpsi.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (DCA, XG, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  mpi_enreg=informations about MPI parallelization
!!
!! OUTPUT
!!  vhartr(nfft)=array for holding Hartree potential
!!  vxc(nfft,nspden)=exchange-correlation potential (hartree)
!!  vtrial(nfft,nspden)=new potential
!!
!! NOTES
!!
!! PARENTS
!!      rhotov,setvtr,vtorho
!!
!! CHILDREN
!!      psitohpsi,total_energies,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine wvl_psitohpsi(alphamix, eexctX, eexcu, ehart, ekin_sum, epot_sum, eproj_sum, eSIC_DC, &
     & itrp, iter, iscf, ixc, me, natom, nfft, nproc, nspden, rpnrm, scopt, vexcu, wvl, &
     & xcart, xcstr, vhartr, vtrial, vxc)

 use defs_basis
 use defs_wvltypes
 use m_profiling
 use m_errors
#if defined HAVE_DFT_BIGDFT
 use BigDFT_API, only: psitohpsi, HARTREE_POTENTIAL, KS_POTENTIAL
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'wvl_psitohpsi'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments-------------------------------
!scalars
 logical, intent(in) :: scopt
 integer, intent(in) :: me, nproc, itrp, iter, iscf, ixc, natom, nfft, nspden
 real(dp), intent(in) :: alphamix
 real(dp), intent(out) :: rpnrm
 type(wvl_data), intent(inout) :: wvl
 real(dp), intent(out) :: eexctX,eSIC_DC,ehart,eexcu,vexcu, ekin_sum, epot_sum, eproj_sum
 real(dp), dimension(6), intent(out) :: xcstr
 real(dp), intent(inout) :: xcart(3, natom)
!arrays
 real(dp),intent(out), optional :: vhartr(nfft)
 real(dp),intent(out), optional :: vxc(nfft*nspden)
 real(dp),intent(out), optional :: vtrial(nfft*nspden)

!Local variables-------------------------------
!scalars
 character(len=500) :: message
#if defined HAVE_DFT_BIGDFT
 integer :: linflag = 0
 integer :: dim1,dim2,dim3,dim4,ii,i1,i2,i3,i4
 character(len=3), parameter :: unblock_comms = "OFF"
#endif

! *************************************************************************

#if defined HAVE_DFT_BIGDFT
 call psitohpsi(me,nproc,wvl%descr%atoms,scopt,wvl%den%denspot, &
& itrp, iter, iscf, alphamix, ixc,&
& wvl%projectors%nlpspd,wvl%projectors%proj,xcart,linflag,unblock_comms, &
& wvl%wfs%GPU,wvl%wfs%ks,wvl%energs,rpnrm,xcstr)
 eexctX    = wvl%energs%eexctX
 eSIC_DC   = wvl%energs%evsic
 ehart     = wvl%energs%eh
 eexcu     = wvl%energs%exc
 vexcu     = wvl%energs%evxc
 ekin_sum  = wvl%energs%ekin
 epot_sum  = wvl%energs%epot
 eproj_sum = wvl%energs%eproj

 call total_energies(wvl%energs, iter, me)

!There seems to be a bug in the intel11 compiler
!vxc = reshape(wvl%den%denspot%v_xc, shape(vxc))
 if (present(vxc)) then
   write(message, '(a,a,a,a)' ) ch10, ' wvl_psitohpsi : but why are you copying vxc :..o('
   call wrtout(std_out,message,'COLL')
   dim1=size(wvl%den%denspot%v_xc,1)
   dim2=size(wvl%den%denspot%v_xc,2)
   dim3=size(wvl%den%denspot%v_xc,3)
   dim4=size(wvl%den%denspot%v_xc,4)
   do i4=1,dim4
     do i3=1,dim3
       do i2=1,dim2
         do i1=1,dim1
           ii=i1+dim1*(i2-1+dim2*(i3-1+dim3*(i4-1)))
           vxc(ii)=wvl%den%denspot%v_xc(i1,i2,i3,i4)
         end do
       end do
     end do
   end do
 end if

!There seems to be a bug in the intel11 compiler
!vhartr = reshape(wvl%den%denspot%rhov, shape(vhartr))
 if (wvl%den%denspot%rhov_is == HARTREE_POTENTIAL .and. present(vhartr)) then
   write(message, '(a,a,a,a)' ) ch10, ' wvl_psitohpsi : but why are you copying vhartr :..o('
   call wrtout(std_out,message,'COLL')
   dim1=size(wvl%den%denspot%rhov,1)
   do i1=1,dim1
     vhartr(i1)=wvl%den%denspot%rhov(i1)
   end do
 end if

!There seems to be a bug in the intel11 compiler
!vtrial = reshape(wvl%den%denspot%rhov, shape(vtrial))
 if (wvl%den%denspot%rhov_is == KS_POTENTIAL .and. present(vtrial)) then
   write(message, '(a,a,a,a)' ) ch10, ' wvl_psitohpsi : but why are you copying vtrial :..o('
   call wrtout(std_out,message,'COLL')
   dim1=size(wvl%den%denspot%rhov,1)
   do i1=1,dim1
     vtrial(i1)=wvl%den%denspot%rhov(i1)
   end do
 end if

#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_psitohpsi: BUG -',ch10,&
& '  BigDFT is not compiled. Use --enable-bigdft during configure.'
 MSG_BUG(message)
#endif
end subroutine wvl_psitohpsi
!!***
