!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_hpsitopsi
!! NAME
!! wvl_hpsitopsi
!!
!! FUNCTION
!! Heart of the wavelet resolution, compute new wavefunctions mixed witf previous
!! by computing the gradient of the wavefunctions knowing the external potential.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  istep=id of the current iteration (first is 1).
!!  mpi_enreg=informations about MPI parallelization
!!  proj <type(wvl_projector_type)>=projectors informations for wavelets.
!!  vtrial(dtset%nfft)=external potential.
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  energies <type(energies_type)>=storage for energies computed here :
!!   | e_kinetic(OUT)=kinetic energy part of total energy
!!   | e_localpsp(OUT)=local pseudopotential part of total energy
!!   | e_nonlocalpsp(OUT)=nonlocal pseudopotential part of total energy
!!  residm=max value for gradient in the minimisation process.
!!  rhor(dtset%nfft)=electron density in r space
!!  wfs <type(wvl_projector_type)>=wavefunctions informations for wavelets.
!!  xred(3,natom)=reduced dimensionless atomic coordinates (in fact IN but here
!!                because of INOUT xredxcart() behavior).
!!
!! PARENTS
!!      vtorho
!!
!! CHILDREN
!!      calculate_energy_and_gradient,hpsitopsi,wrtout
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine wvl_hpsitopsi(dtset, energies, istep, mpi_enreg, residm, wvl)

 use m_profiling

  use defs_basis
  use defs_abitypes
  use defs_wvltypes
  use m_errors
  use m_xmpi

  use m_energies, only : energies_type
#if defined HAVE_DFT_BIGDFT
  use BigDFT_API, only : hpsitopsi, calculate_energy_and_gradient
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'wvl_hpsitopsi'
 use interfaces_14_hidewrite
!End of the abilint section

  implicit none

!Arguments -------------------------------
  type(dataset_type), intent(in)         :: dtset
  type(energies_type), intent(inout)     :: energies
  integer, intent(in)                    :: istep
  type(MPI_type), intent(in)             :: mpi_enreg
  real(dp), intent(inout)                :: residm
  type(wvl_data), intent(inout)          :: wvl

!Local variables-------------------------------
  character(len = 500)  :: message
#if defined HAVE_DFT_BIGDFT
  real(dp), save        :: etotal_local
  integer, save         :: ids
  real(dp)              :: gnrm_zero
  integer               :: comm,me,nproc
#endif

! *********************************************************************

#if defined HAVE_DFT_BIGDFT

 write(message, '(a,a)' ) ch10,&
& ' wvl_hpsitopsi: compute the new density from the trial potential.'
 call wrtout(std_out,message,'COLL')

 comm=mpi_enreg%comm_cell
 me=xcomm_rank(comm)
 nproc=xcomm_size(comm)

!Initialisation of mixing parameter
 if (istep == 1) then
   etotal_local = real(1.d100, dp)
   ids          = dtset%nwfshist
 end if

!WARNING! e_hartree is taken from the previous iteration as e_xc
!Update physical values
 energies%e_corepsp = zero

!Precondition, minimise (DIIS or steepest descent) and ortho.
!Compute also the norm of the gradient.
 call calculate_energy_and_gradient(istep, me, nproc, wvl%wfs%GPU, dtset%wvl_nprccg, &
& dtset%iscf, wvl%energs, wvl%wfs%ks, residm, gnrm_zero)
 etotal_local = wvl%wfs%ks%diis%energy

 call hpsitopsi(me, nproc, istep, ids, wvl%wfs%ks)

#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_hpsitopsi : BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 MSG_ERROR(message)
#endif
end subroutine wvl_hpsitopsi
!!***
