!{\src2tex{textfont=tt}}
!!****f* ABINIT/handle_ncerr
!! NAME
!! handle_ncerr
!!
!! FUNCTION
!! Rudimentary Error catching for NetCDF using routines: prints out a string
!! describing what was being done when the error code showed up.
!!
!! COPYRIGHT
!! Copyright (C) 2004-2012 ABINIT group (Mver)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!   ncerr = error code. If different from the preset nf90_noerr, then error
!!   message = subroutine specified message (description of action which
!!    produced the error)
!!
!! OUTPUT
!!  (only writes)
!!
!! PARENTS
!!      ab_define_var,cut3d,m_bse_io,outxfhist,read_md_hist,write_eig
!!      write_md_hist,wrt_moldyn_netcdf
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine handle_ncerr(ncerr,message)

 use defs_basis
 use m_profiling
 use m_errors
#if defined HAVE_TRIO_NETCDF
 use netcdf
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'handle_ncerr'
!End of the abilint section

 implicit none

!Arguments --------------------------
 integer         ,intent(in) :: ncerr
 character(len=*),intent(in) :: message

!local variables
 character(len=500) :: msg

! *********************************************************************

#if defined HAVE_TRIO_NETCDF
 if (ncerr /= nf90_noerr) then
   msg =  'Error in netcdf call while: '//trim(message)//trim(nf90_strerror(ncerr))
   MSG_ERROR(msg)
 end if
#else
 msg = ' handle_ncerr : Error : NETCDF not defined at compile time. handle_ncerr should not be called.'
 MSG_ERROR(msg)
#endif

end subroutine handle_ncerr
!!***
