!{\src2tex{textfont=tt}}
!!****f* ABINIT/invars2
!!
!! NAME
!! invars2
!!
!! FUNCTION
!! Initialize variables for the ABINIT code, for one particular
!! dataset, characterized by jdtset.
!! Note : some parameters have already been read in invars0 and invars1,
!! and were used to dimension the arrays needed here.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! bravais(11): bravais(1)=iholohedry
!!              bravais(2)=center
!!              bravais(3:11)=coordinates of rprim in the axes
!!               of the conventional bravais lattice (*2 if center/=0)
!! iout=unit number for echoed output
!! jdtset=number of the dataset looked for
!! lenstr=actual length of the string
!! mband=maximum number of bands for any k-point
!! msym=default maximal number of symmetries
!! npsp=number of pseudopotentials
!! string*(*)=character string containing all the input data.
!!  Initialized previously in instrng.
!! usepaw= 0 for non paw calculation; =1 for paw calculation
!! zionpsp(npsp)=valence charge of each type of atom (coming from the psp files)
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!! Input/Output:
!!  dtset=<type datafiles_type>contains all input variables,
!!   some of which are initialized here, while other were already
!! All rest of arguments given alphabetically from acell (length scales)
!! to wtk (k-point weights), used to control running of the main routine.
!! See abinit_help for definitions of these variables.
!! These values become defined by being read from string,
!! that contains all information from the input file,
!! in a compressed, standardized, format
!! At the input, they already contain a default value.
!!
!! NOTES
!!
!! PARENTS
!!      invars2m,m_ab6_invars_f90
!!
!! CHILDREN
!!      chkneu,inkpts,intagm,invacuum,sort_int,timab,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine invars2(bravais,dtset,iout,jdtset,lenstr,&
& mband,msym,npsp,string,usepaw,zionpsp)

 use defs_basis
 use defs_abitypes
 use m_profiling
 use m_errors
#if defined HAVE_DFT_LIBXC
 use xc_f90_lib_m
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'invars2'
 use interfaces_14_hidewrite
 use interfaces_18_timing
 use interfaces_28_numeric_noabirule
 use interfaces_42_parser
 use interfaces_57_iovars, except_this_one => invars2
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iout,jdtset,lenstr,mband,msym,npsp,usepaw
 character(len=*),intent(in) :: string
 type(dataset_type),intent(inout) :: dtset
!arrays
 integer,intent(in) :: bravais(11)
 real(dp),intent(in) :: zionpsp(npsp)

!Local variables-------------------------------
!scalars
 integer :: bantot,berryopt,dmatsize,getocc,iatom,ii,ikpt,index_nat,ionmov,intimage
 integer :: iprcch,ipsp,iscf,itypat,jj,kptopt,lpawu,marr,natom,nband1,nberry
 integer :: niatcon,nimage,nkpt,npspalch,nqpt,nspinor,nsppol,nsym,ntypalch,ntypat,ntyppure
 integer :: occopt,occopt_tmp,response,tfband,tnband,tread,tread_alt,tread_key
 integer :: itol, itol_gen, ds_input, ifreq
 real(dp) :: areaxy,charge,fband,kptrlen,nelectjell
 real(dp) :: rhoavg,zelect,zval
 real(dp) :: toldfe_, tolrff_, toldff_, tolwfr_, tolvrs_
 character(len=30) :: token
 character(len=500) :: message
 character(len=fnlen) :: keyw
!arrays
 integer :: vacuum(3)
 integer,allocatable :: iatcon(:),natcon(:)
 integer,allocatable :: intarr(:) !Dummy arguments for subroutine 'intagm' to parse input file
 real(dp) :: tsec(2)
 real(dp),allocatable :: dprarr(:) !Dummy arguments for subroutine 'intagm' to parse input file

! *************************************************************************

 call timab(191,1,tsec)

!Compute the maximum size of arrays intarr and dprarr
 natom=dtset%natom
 nimage=dtset%nimage
 nkpt=dtset%nkpt
 npspalch=dtset%npspalch
 nspinor=dtset%nspinor
 nsppol=dtset%nsppol
 ntypat=dtset%ntypat
 ntypalch=dtset%ntypalch
 ntyppure=dtset%ntyppure

 dmatsize=0
 if (dtset%usepawu>0.and.dtset%usedmatpu/=0) then
   do iatom=1,natom
     lpawu=dtset%lpawu(dtset%typat(iatom))
     if (lpawu/=-1) dmatsize=dmatsize+nsppol*nspinor*(2*lpawu+1)**2
   end do
 end if
 marr=max(3*natom,nkpt*nsppol*mband,2*dtset%nkptgw*nsppol,dmatsize,&
& 3*nkpt,npsp,ntypat,9*msym,60,3*dtset%nconeq*natom,nimage,3*dtset%nqptdm,&
& dtset%natvshift*nsppol*natom)
 ABI_ALLOCATE(intarr,(marr))
 ABI_ALLOCATE(dprarr,(marr))

!----------------------------------------------------------------------------

!****   Read parameters which set remaining array dimensions ****

!Note : some parameters have already been read in invars0 and invars1
!Also, some checking is needed here.

!Read ngfft(1), ngfft(2), and ngfft(3),
!then ngfft(7)=fftalg and ngfft(8)=fftcache.
!Read ngfftdg(1:3)

 token = 'ngfft'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ngfft(1:3)=intarr(1:3)

 token = 'fftalg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%ngfft(7)=intarr(1)
   if (usepaw==1) dtset%ngfftdg(7)=intarr(1)
 else
   if (dtset%optdriver==RUNL_GSTATE) then
     if(dtset%paral_kgb==1.or.dtset%use_gpu_cuda/=0.or. &
&     mod(dtset%wfoptalg,10)==4) then
       dtset%ngfft(7)=401
       if (usepaw==1) dtset%ngfftdg(7)=401
     end if
   end if
 end if

 token = 'fftcache'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')

 if(tread==1) then
   dtset%ngfft(8)=intarr(1)
   if (usepaw==1) dtset%ngfftdg(8)=intarr(1)
 end if

 token = 'fft_opt_lob'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%fft_opt_lob=intarr(1)
 else
   if(dtset%paral_kgb==1) dtset%fft_opt_lob=2
 end if

 token = 'ngfftdg'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ngfftdg(1:3)=intarr(1:3)

 token = 'ng'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   write(message, '(a,a,a)' )&
&   '  The use of the "ng" input variable is forbidden since version 1.8.',ch10,&
&   '  Action : take "ng" out of your input file.'
   MSG_ERROR(message)
 end if

 token = 'mqgrid'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%mqgrid=intarr(1)

 token = 'mqgriddg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%mqgriddg=intarr(1)

!Make special arrangements to check nband: may be a scalar
!(for occopt=0, 1 or 3, 4, 5, 6, 7, 8) or may be an array (for occopt=2)

 token = 'occopt'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%occopt=intarr(1)
 occopt=dtset%occopt

!check for variables related to genetic algorithm. ga_n_rules has been already read

 if (dtset%imgmov==4) then
   token = 'ga_algor'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%ga_algor=intarr(1)

   token = 'ga_fitness'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%ga_fitness=intarr(1)

   token = 'ga_opt_percent'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
   if(tread==1) dtset%ga_opt_percent=dprarr(1)

   token = 'ga_rules'
   call intagm(dprarr,intarr,jdtset,marr,dtset%ga_n_rules,string(1:lenstr),token,tread,'INT')
!  DEBUG AHR
!  write(std_out,*) ' write ga_n_rules ',dtset%ga_n_rules
!  call flush(std_out)
!  ENDDEBUG
   if(tread==1)then
     dtset%ga_rules(1:dtset%ga_n_rules)=intarr(1:dtset%ga_n_rules)
     do ii=1,dtset%ga_n_rules
       if(dtset%ga_rules(ii)<0)then
         write(message, '(a,i4,a)' )&
&         '  All values for Genetic rules must be greater than 0.',ch10,&
&         '  Action : check the values of ga_rules.'
         MSG_ERROR(message)
       end if
     end do
   end if
 end if


 token = 'gwcalctyp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gwcalctyp=intarr(1)

 token = 'chkgwcomp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%chkgwcomp=intarr(1)

 token = 'gwcomp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gwcomp=intarr(1)

 token = 'gwencomp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%gwencomp=dprarr(1)

 if (usepaw==1) then
   token = 'gw_sigxcore'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%gw_sigxcore=intarr(1)
 end if

 token = 'gwmem'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gwmem=intarr(1)

 token = 'gw_sctype'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_sctype=intarr(1)

 token = 'gw_nstep'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_nstep=intarr(1)

 token = 'gw_toldfeig'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%gw_toldfeig=dprarr(1)

 token = 'rhoqpmix'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%rhoqpmix=dprarr(1)

 token = 'nfreqim'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nfreqim=intarr(1)
 if (dtset%cd_customnimfrqs/=0) then
   write(message, '(a,a,a,a,a,a)' )ch10,&
&   ' invars2: WARNING -',ch10,&
&   '  cd_customnimfrqs not equal to zero and not equal to nfreqim',ch10,&
&   '  setting nfreqim = cd_customnimfrqs'
   call wrtout(std_out,message,'COLL')
   dtset%nfreqim = dtset%cd_customnimfrqs
 end if

 token = 'freqim_alpha'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%freqim_alpha=dprarr(1)

 token = 'freqremin'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%freqremin=dprarr(1)

 token = 'freqremax'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%freqremax=dprarr(1)

 token = 'nfreqre'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nfreqre=intarr(1)

 token = 'nfreqsp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nfreqsp=intarr(1)

 token = 'freqspmax'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%freqspmax=dprarr(1)

 token = 'freqspmin'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) then ! If found, set it
   dtset%freqspmin=dprarr(1)
 else ! Else give it the value -freqspmax
   dtset%freqspmin=-dtset%freqspmax
 end if

 token = 'gw_frqim_inzgrid'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_frqim_inzgrid=intarr(1)

 token = 'gw_frqre_inzgrid'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_frqre_inzgrid=intarr(1)

 token = 'gw_frqre_tangrid'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_frqre_tangrid=intarr(1)

 token = 'gw_use_pole_scr'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_use_pole_scr=intarr(1)

 token = 'gw_npoles'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_npoles=intarr(1)

 if(dtset%cd_customnimfrqs/=0) then
   token = 'cd_imfrqs'
   call intagm(dprarr,intarr,jdtset,marr,dtset%cd_customnimfrqs,string(1:lenstr),&
&   token,tread,'ENE')
   if(tread==1) then
     dtset%cd_imfrqs(1:dtset%cd_customnimfrqs)=dprarr(1:dtset%cd_customnimfrqs)
     do ifreq=1,dtset%cd_customnimfrqs-1
       if (dtset%cd_imfrqs(ifreq+1)<dtset%cd_imfrqs(ifreq)) then
         write(message, '(a,a,a)' )&
&         '  The frequencies specified in cd_imfrqs must be strictly increasing',ch10,&
&         '  Action : Correct this in your input file'
         MSG_ERROR(message)
       end if
     end do
   end if
 end if

 if(dtset%gw_customnfreqsp/=0) then
   token = 'gw_freqsp'
   call intagm(dprarr,intarr,jdtset,marr,dtset%gw_customnfreqsp,string(1:lenstr),token,tread,'ENE')
   if(tread==1) then
     dtset%gw_freqsp(1:dtset%gw_customnfreqsp)=dprarr(1:dtset%gw_customnfreqsp)
     do ifreq=1,dtset%gw_customnfreqsp-1
       if (dtset%gw_freqsp(ifreq+1)<dtset%gw_freqsp(ifreq)) then
         write(message, '(a,a,a)' )&
&         '  The frequencies specified in gw_freqsp must be strictly increasing',ch10,&
&         '  Action : Correct this in your input file'
         MSG_ERROR(message)
       end if
     end do
   end if
 end if

 token = 'cd_full_grid'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%cd_full_grid=intarr(1)

 token = 'cd_frqim_method'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%cd_frqim_method=intarr(1)

 token = 'cd_halfway_freq'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%cd_halfway_freq=dprarr(1)

 token = 'cd_max_freq'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%cd_max_freq=dprarr(1)

 token = 'gw_reconst_scr'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_reconst_scr=intarr(1)

 token = 'cd_subset_freq'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%cd_subset_freq(1:2)=intarr(1:2)

 token = 'gwrpacorr'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gwrpacorr=intarr(1)

 token = 'supercell'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%supercell(1:3)=intarr(1:3)
 token = 'scphon_supercell'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%scphon_supercell(1:3)=intarr(1:3)

!RESPFN integer input variables (needed here to get the value of response
!Presently, rfmeth is not used.
!Warning : rfddk,rfelfd,rfphon,rfstrs and rfuser are also read in invars1
 token = 'rfasr'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfasr=intarr(1)

 token = 'rfatpol'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfatpol(1:2)=intarr(1:2)

 token = 'rfdir'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfdir(1:3)=intarr(1:3)

 token = 'rfddk'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfddk=intarr(1)

 token = 'rfelfd'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfelfd=intarr(1)

 token = 'rfmeth'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfmeth=intarr(1)

 token = 'rfphon'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfphon=intarr(1)

 token = 'rfstrs'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfstrs=intarr(1)

 token = 'rfuser'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rfuser=intarr(1)

 response=0
 if(dtset%rfddk/=0 .or. dtset%rfelfd/=0 .or. &
& dtset%rfphon/=0 .or. dtset%rfstrs/=0 .or. dtset%rfuser/=0 ) response=1

!NONLINEAR integer input variables (same definition as for rfarr)
!Presently, rf?asr, rf?meth,rf?strs and rf?thrd are not used
 token = 'rf1atpol'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf1atpol(1:2)=intarr(1:2)

 token = 'rf1dir'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf1dir(1:3)=intarr(1:3)

 token = 'rf1elfd'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf1elfd=intarr(1)

 token = 'rf1phon'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf1phon=intarr(1)

 token = 'rf2atpol'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf2atpol(1:2)=intarr(1:2)

 token = 'rf2dir'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf2dir(1:3)=intarr(1:3)

 token = 'rf2elfd'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf2elfd=intarr(1)

 token = 'rf2phon'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf2phon=intarr(1)

 token = 'rf3atpol'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf3atpol(1:2)=intarr(1:2)

 token = 'rf3dir'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf3dir(1:3)=intarr(1:3)

 token = 'rf3elfd'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf3elfd=intarr(1)

 token = 'rf3phon'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rf3phon=intarr(1)

 response=0
 if(dtset%rfddk/=0 .or. dtset%rfelfd/=0 .or. &
& dtset%rfphon/=0 .or. &
& dtset%rfstrs/=0 .or. dtset%rfuser/=0 .or. &
& dtset%rf1elfd/=0 .or. dtset%rf1phon/=0 .or. &
& dtset%rf2elfd/=0 .or. dtset%rf2phon/=0 .or. &
& dtset%rf3elfd/=0 .or. dtset%rf3phon/=0 ) response=1

 token = 'prepanl'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prepanl=intarr(1)

 token = 'prepgkk'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prepgkk=intarr(1)

 token = 'prepscphon'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prepscphon=intarr(1)

!real(dp) input variables
 token = 'boxcutmin'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%boxcutmin=dprarr(1)

 token = 'charge'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%charge=dprarr(1)

 token = 'dosdeltae'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%dosdeltae=dprarr(1)

 token = 'dtion'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%dtion=dprarr(1)

 token = 'ecut'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%ecut=dprarr(1)

 token = 'elph2_imagden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%elph2_imagden=dprarr(1)

 token = 'esmear'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%esmear=dprarr(1)

 token = 'fermie_nest'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%fermie_nest=dprarr(1)

 token = 'scphon_temp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%scphon_temp=dprarr(1)

 token = 'sciss'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%sciss=dprarr(1)

 token = 'tsmear'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%tsmear=dprarr(1)

 token = 'vis'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%vis=dprarr(1)

 token = 'ecutsm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%ecutsm=dprarr(1)

 token = 'exchmix'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%exchmix=dprarr(1)

 token = 'dilatmx'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%dilatmx=dprarr(1)

 token = 'fxcartfactor'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%fxcartfactor=dprarr(1)

 token = 'strfact'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%strfact=dprarr(1)

 token = 'freqsusin'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%freqsusin=dprarr(1)

 token = 'freqsuslo'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%freqsuslo=dprarr(1)

 token = 'optfreqsus'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%optfreqsus=intarr(1)

 token = 'effmass'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%effmass=dprarr(1)

 token = 'mdtemp'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%mdtemp(1:2)=dprarr(1:2)

!Recursion input variables

 token = 'tfkinfunc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%tfkinfunc=intarr(1)

 token = 'recgratio'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%recgratio=intarr(1)

 token = 'recefermi'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%recefermi=dprarr(1)

 token = 'recnpath'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%recnpath=intarr(1)

 token = 'recnrec'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%recnrec=intarr(1)

 token = 'recrcut'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'LEN')
 if(tread==1) dtset%recrcut=dprarr(1)

 token = 'recptrott'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%recptrott=intarr(1)

 token = 'rectesteg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%rectesteg=intarr(1)

 token = 'rectolden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%rectolden=dprarr(1)

!Constant NPT Molecular Dynamics Input variables
 token = 'noseinert'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%noseinert=dprarr(1)

 token = 'bmass'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%bmass=dprarr(1)

 token = 'qmass'
 call intagm(dprarr,intarr,jdtset,marr,dtset%nnos,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%qmass(:)=dprarr(1:dtset%nnos)

 token = 'tphysel'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%tphysel=dprarr(1)

 token = 'strtarget'
 call intagm(dprarr,intarr,jdtset,marr,6,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%strtarget(1:6)=dprarr(1:6)

 token = 'vcutgeo'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%vcutgeo(1:3)=dprarr(1:3)

 token = 'friction'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%friction=dprarr(1)

 token = 'mdwall'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'LEN')
 if(tread==1) dtset%mdwall=dprarr(1)

 token = 'spinmagntarget'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%spinmagntarget=dprarr(1)

 token = 'eshift'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%eshift=dprarr(1)

 token = 'boxcenter'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%boxcenter(1:3)=dprarr(1:3)

 token = 'ecuteps'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%ecuteps=dprarr(1)

 token = 'ecutsigx'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) then
   dtset%ecutsigx=dprarr(1)
!  else
!  if(dtset%optdriver==RUNL_SIGMA .or. dtset%optdriver==RUNL_SCGW) dtset%ecutsigx=dtset%ecut
 end if
 token = 'ecutwfn'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) then
   dtset%ecutwfn=dprarr(1)
 else
   if(dtset%optdriver==RUNL_SCREENING .or. dtset%optdriver==RUNL_SIGMA &
&   .or. dtset%optdriver==RUNL_SCGW) dtset%ecutwfn=dtset%ecut
 end if
 token = 'omegasimax'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%omegasimax=dprarr(1)

 token = 'omegasrdmax'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%omegasrdmax=dprarr(1)

 token = 'soenergy'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%soenergy=dprarr(1)

 token = 'spbroad'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%spbroad=dprarr(1)

 token = 'stmbias'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%stmbias=dprarr(1)

 token = 'awtr'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%awtr=intarr(1)

 token = 'inclvkb'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%inclvkb=intarr(1)

 token = 'nomegasf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nomegasf=intarr(1)

 token = 'spmeth'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%spmeth=intarr(1)

 token= 'symchi'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%symchi=intarr(1)

 token = 'getscr'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getscr=intarr(1)

 token = 'gwgamma'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gwgamma=intarr(1)

 token = 'irdsuscep'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdsuscep=intarr(1)

 token = 'irdscr'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdscr=intarr(1)

 token = 'nomegasi'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nomegasi=intarr(1)

 token = 'ppmodel'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ppmodel=intarr(1)

 token = 'symsigma'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%symsigma=intarr(1)

 token = 'fftgw'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%fftgw=intarr(1)

 token = 'getsuscep'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getsuscep=intarr(1)

 token = 'getqps'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getqps=intarr(1)

 token = 'getkss'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getkss=intarr(1)

 token='gwpara'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gwpara=intarr(1)

 token = 'irdqps'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdqps=intarr(1)

 token = 'irdkss'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdkss=intarr(1)

 token = 'ppmfrq'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%ppmfrq=dprarr(1)

 token = 'rcut'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'LEN')
 if(tread==1) dtset%rcut=dprarr(1)

 token = 'zcut'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%zcut=dprarr(1)

!q-points for long wave-length limit.
 if (dtset%gw_nqlwl>0) then
   token = 'gw_qlwl'
   call intagm(dprarr,intarr,jdtset,marr,3*dtset%gw_nqlwl,string(1:lenstr),token,tread,'DPR')
   if(tread==1) dtset%gw_qlwl(1:3,1:dtset%gw_nqlwl) = reshape(dprarr(1:3*dtset%gw_nqlwl),(/3,dtset%gw_nqlwl/))
 end if

!@bethe_salpeter

!integer scalars
 token = 'bs_nstates'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_nstates=intarr(1)

 token = 'bs_algorithm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_algorithm=intarr(1)

 token = 'bs_haydock_niter'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_haydock_niter=intarr(1)

 token = 'bs_hayd_term'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_hayd_term=intarr(1)

 token = 'bs_exchange_term'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_exchange_term=intarr(1)

 token = 'bs_calctype'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_calctype=intarr(1)

 token = 'bs_coulomb_term'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_coulomb_term=intarr(1)

 token = 'bs_coupling'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_coupling=intarr(1)

 token = 'irdbseig'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdbseig=intarr(1)

!token = 'irdbsr'
!call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
!if(tread==1) dtset%irdbsr=intarr(1)

!token = 'irdbsc'
!call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
!if(tread==1) dtset%irdbsc=intarr(1)

 token = 'getbseig'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getbseig=intarr(1)

 token = 'getbsreso'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getbsreso=intarr(1)

 token = 'getbscoup'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getbscoup=intarr(1)

 token = 'gethaydock'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gethaydock=intarr(1)

!integer arrays
 token = 'bs_loband'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bs_loband=intarr(1)

!real arrays
 token = 'bs_eh_cutoff'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%bs_eh_cutoff(1:3)=dprarr(1:3)

 token = 'bs_freq_mesh'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%bs_freq_mesh(1:3)=dprarr(1:3)

 token = 'bs_haydock_tol'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%bs_haydock_tol=dprarr(1:2)

 token = 'gw_eet'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_eet=intarr(1)

 token = 'gw_eet_nband'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_eet_nband=intarr(1)

 token = 'gw_eet_inclvkb'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gw_eet_inclvkb=intarr(1)

 token = 'gw_eet_scale'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%gw_eet_scale=dprarr(1)

 ntypalch=dtset%ntypalch
 npspalch=dtset%npspalch

!Compute ziontypat
!When the pseudo-atom is pure, simple copy
 if(ntyppure>0)then
   do itypat=1,ntyppure
     dtset%ziontypat(itypat)=zionpsp(itypat)
   end do
 end if
!When the pseudo-atom is alchemical, must make mixing
 if(ntypalch>0)then
   do itypat=ntyppure+1,ntypat
     dtset%ziontypat(itypat)=zero
     do ipsp=ntyppure+1,npsp
       dtset%ziontypat(itypat)=dtset%ziontypat(itypat) &
&       +dtset%mixalch_orig(ipsp-ntyppure,itypat-ntyppure,1)*zionpsp(ipsp)
     end do
   end do
 end if

 charge=dtset%charge

 if (occopt==0 .or. occopt==1 .or. (occopt>=3 .and. occopt<=8) ) then

   token = 'nband'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tnband,'INT')
   if(tnband==1) then
     nband1=intarr(1)
   else
!    Default value in the metallic case, or in the insulating case
     fband=0.5_dp
     if(occopt==1)fband=0.125_dp
     if (dtset%usewvl == 1) fband = zero
     token = 'fband'
     call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tfband,'DPR')
     if(tfband==1)then
       fband=dprarr(1)
       write(message, '(a,es16.8,a)' )&
&       ' invars2: read the value of fband=',fband,' from input file.'
     else
       write(message, '(a,es16.8)' )&
&       ' invars2: take the default value of fband=',fband
     end if
     call wrtout(std_out,message,'COLL')
!    First compute the total valence charge
     zval=0.0_dp
     do iatom=1,natom
       zval=zval+dtset%ziontypat(dtset%typat(iatom))
     end do
     zelect=zval-charge
!    Then select the minimum number of bands, and add the required number
!    Note that this number might be smaller than the one computed
!    by a slightly different formula in invars1
     nband1=dtset%nspinor*&
&     ((ceiling(zelect-1.0d-10)+1)/2 + ceiling( fband*natom - 1.0d-10 ))
   end if

!  Set nband to same input number for each k point and spin
!  where nband1 is the eventual input, computed value, or default
   do ikpt=1,nkpt*nsppol
     dtset%nband(ikpt)=nband1
   end do

 else if (occopt==2) then
!  Give nband explicitly for each k point and spin

   token = 'nband'
   call intagm(dprarr,intarr,jdtset,nkpt*nsppol,nkpt*nsppol,string(1:lenstr),token,tnband,'INT')
   if(tnband==1) dtset%nband(1:nkpt*nsppol)=intarr(1:nkpt*nsppol)

 else
   write(message, '(a,i0,a,a,a)' )&
&   ' occopt=',occopt,' not allowed.',ch10,&
&   ' Action : correct your input file.'
   MSG_ERROR(message)
 end if

!----------------------------------------------------------------------------

!****   Read other parameters  ****

!All checking should be done in chkinp.f

 token = 'builtintest'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%builtintest=intarr(1)

 token = 'chksymbreak'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%chksymbreak=intarr(1)

!Get array
 token = 'getocc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getocc=intarr(1)

 getocc=dtset%getocc
 token = 'getwfk'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getwfk=intarr(1)

 token = 'getxcart'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getxcart=intarr(1)

 token = 'getxred'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getxred=intarr(1)

 token = 'getden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getden=intarr(1)

 token = 'getpawden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getpawden=intarr(1)

 token = 'getcell'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getcell=intarr(1)

 token = 'getgam_eig2nkq'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getgam_eig2nkq=intarr(1)

 token = 'getwfq'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getwfq=intarr(1)

 token = 'get1wf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%get1wf=intarr(1)

 token = 'getddk'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getddk=intarr(1)

 token = 'getvel'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%getvel=intarr(1)

 token = 'get1den'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%get1den=intarr(1)

 token = 'getwf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   write(message, '(a,a,a)' )&
&   '  The use of the "getwf" variable is forbidden since version 2.0.',ch10,&
&   '  Action : replace "getwf" by "getwfk" in your input file.'
   MSG_ERROR(message)
 end if

 token = 'accesswff'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%accesswff=intarr(1)

 token = 'enunit'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%enunit=intarr(1)

 token = 'exchn2n3d'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%exchn2n3d=intarr(1)

 token = 'iboxcut'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%iboxcut=intarr(1)

 token = 'icutcoul'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%icutcoul=intarr(1)

 token = 'mdf_epsinf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%mdf_epsinf=dprarr(1)

 if (dtset%imgmov==0.or.dtset%imgmov==2.or.dtset%imgmov==5) then
   token = 'mep_mxstep'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'LEN')
   if(tread==1) then
     dtset%mep_mxstep=dprarr(1)
   else if(dtset%imgmov==5) then
     dtset%mep_mxstep=0.4_dp
   end if
 end if
 if (dtset%imgmov==2.or.dtset%imgmov==5) then
   token = 'mep_solver'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) then
     dtset%mep_solver=intarr(1)
   else if(dtset%imgmov==2) then
     dtset%mep_solver=0
   else if(dtset%imgmov==5) then
     dtset%mep_solver=0
   end if
   if (dtset%imgmov==2) then
     token = 'string_algo'
     call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
     if(tread==1) dtset%string_algo=intarr(1)
   end if
   if (dtset%imgmov==5) then
     token = 'neb_algo'
     call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
     if(tread==1) dtset%neb_algo=intarr(1)
     token = 'neb_spring'
     call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'DPR')
     if(tread==1) then
       dtset%neb_spring(1:2)=dprarr(1:2)
     else if (dtset%neb_algo==2) then
       dtset%neb_spring(1:2)=(/0.02_dp,0.15_dp/)
     end if
     token = 'cineb_start'
     call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
     if(tread==1) dtset%cineb_start=intarr(1)
   end if
 end if

 token = 'istatimg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%istatimg=intarr(1)

!variables for random positions in unit cell
 token = 'random_atpos'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%random_atpos=intarr(1)

 token = 'ionmov'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ionmov=intarr(1)

 token = 'intxc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%intxc=intarr(1)

 token = 'iprcch'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%iprcch=intarr(1)
 else
   if (dtset%paral_kgb==1) dtset%iprcch=6
 end if

 token = 'iprcel'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%iprcel=intarr(1)

 token = 'iprctfvw'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%iprctfvw=intarr(1)

 token = 'iprcfc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%iprcfc=intarr(1)

 token = 'irandom'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irandom=intarr(1)

 token = 'irdden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdden=intarr(1)

 token = 'irdpawden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdpawden=intarr(1)

 token = 'irdhaydock'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdhaydock=intarr(1)

 token = 'irdwfk'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdwfk=intarr(1)

 token = 'iscf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%iscf=intarr(1)
 else if (dtset%optdriver==1.and.dtset%iscf>=10) then
   dtset%iscf=dtset%iscf-10
 end if

 token = 'isecur'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%isecur=intarr(1)

!Reading ixc must be immediately followed by reading xcname
 token = 'ixc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ixc=intarr(1)
 keyw='xcname'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),keyw,tread_key,'KEY')
 if(tread_key==1)then
   if(tread==1)then
     write(message, '(a,a,a,a,a)' )&
&     ' ixc and xcname cannot be specified simultaneously',ch10,&
&     ' for the same dataset.',ch10,&
&     ' Action : check the input file.'
     MSG_ERROR(message)
   else
!    Note that xcname is a 'key' variable : its value is stored in keyw at output of intagm
     if(trim(keyw)=='PW92')dtset%ixc=7
     tread=1
   end if
 end if
 dtset%xclevel=0
 if( ( 1<=dtset%ixc .and. dtset%ixc<=10).or.(30<=dtset%ixc .and. dtset%ixc<=39) )dtset%xclevel=1 ! LDA
 if( (11<=dtset%ixc .and. dtset%ixc<=19).or.(23<=dtset%ixc .and. dtset%ixc<=29) )dtset%xclevel=2 ! GGA
 if( 20<=dtset%ixc .and. dtset%ixc<=22 )dtset%xclevel=3 ! ixc for TDDFT kernel tests
#if defined HAVE_DFT_LIBXC
 if (dtset%ixc<0) then
   dtset%xclevel=1
   ii=-dtset%ixc/1000
   jj=xc_f90_family_from_id(ii)
   if (jj==XC_FAMILY_GGA.or.jj==XC_FAMILY_MGGA) dtset%xclevel=2
   ii=-dtset%ixc-ii*1000
   jj=xc_f90_family_from_id(ii)
   if (jj==XC_FAMILY_GGA.or.jj==XC_FAMILY_MGGA) dtset%xclevel=2
 end if
#endif

 token = 'vdw_xc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%vdw_xc=intarr(1)

 token = 'positron'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%positron=intarr(1)

 token = 'ixcpositron'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ixcpositron=intarr(1)

 token = 'posnstep'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%posnstep=intarr(1)

 token = 'posocc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%posocc=dprarr(1)

 token = 'frzfermi'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%frzfermi=intarr(1)

 token = 'nqpt'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nqpt=intarr(1)

 token = 'ieig2rf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ieig2rf=intarr(1)

 token = 'smdelta'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%smdelta=intarr(1)

 token = 'bdeigrf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%bdeigrf=intarr(1)

 token = 'restartxf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%restartxf=intarr(1)

 token = 'optcell'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%optcell=intarr(1)

 token = 'irdwfq'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdwfq=intarr(1)

 token = 'ird1den'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ird1den=intarr(1)

 token = 'ird1wf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ird1wf=intarr(1)

 token = 'irdddk'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%irdddk=intarr(1)

 token = 'kptopt'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%kptopt=intarr(1)

 token = 'chkexit'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%chkexit=intarr(1)

 token = 'ikhxc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ikhxc=intarr(1)

 token = 'nbdbuf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1)then
   dtset%nbdbuf=intarr(1)
 else
   if(response/=1 .and. dtset%iscf<0)dtset%nbdbuf=2*dtset%nspinor
   if(response==1 .and. 3<=occopt .and. occopt<=8 )dtset%nbdbuf=2*dtset%nspinor
 end if

 token = 'localrdwf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%localrdwf=intarr(1)

 token = 'optforces'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%optforces=intarr(1)

 token = 'optstress'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%optstress=intarr(1)

 token = 'optnlxccc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%optnlxccc=intarr(1)

 token = 'nberry'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nberry=intarr(1)

 token = 'bdberry'
 call intagm(dprarr,intarr,jdtset,marr,2*nsppol,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%bdberry(1)=intarr(1); dtset%bdberry(2)=intarr(2)
   if(nsppol==2)then
     dtset%bdberry(3)=intarr(3); dtset%bdberry(4)=intarr(4)
   end if
 end if

 token = 'berrystep'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%berrystep=intarr(1)

 token = 'delayperm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%delayperm=intarr(1)

 token = 'signperm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%signperm=intarr(1)

 token = 'nbandkss'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nbandkss=intarr(1)

 token = 'npwkss'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%npwkss=intarr(1)

 token = 'kssform'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%kssform=intarr(1)

 token = 'td_mexcit'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%td_mexcit=intarr(1)

 token = 'npweps'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%npweps=intarr(1)

 token = 'npulayit'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%npulayit=intarr(1)

 token = 'diismemory'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%diismemory=intarr(1)

 token = 'goprecon'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%goprecon=intarr(1)

 token = 'goprecprm'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%goprecprm(1:3)=dprarr(1:3)

 token = 'gpu_linalg_limit'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%gpu_linalg_limit=intarr(1)

 token = 'nwfshist'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nwfshist=intarr(1)

 token = 'npwsigx'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%npwsigx=intarr(1)

 token = 'nscforder'
 call intagm(dprarr, intarr, jdtset, marr, 1, string(1:lenstr), token, tread, 'INT')
 if (tread == 1) dtset%nscforder = intarr(1)

 token = 'nsheps'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nsheps=intarr(1)

 token = 'nshsigx'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nshsigx=intarr(1)

 token = 'nomegasrd'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nomegasrd=intarr(1)

 token = 'corecs'
 call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'DPR')
 if(tread==1)then
   dtset%corecs(1:ntypat)=dprarr(1:ntypat)
 end if

 token = 'corecs'
 call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'DPR')
 if(tread==1)then
   dtset%corecs(1:ntypat)=dprarr(1:ntypat)
 end if

 token = 'ptcharge'
 call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'DPR')
 if(tread==1)then
   dtset%ptcharge(1:ntypat)=dprarr(1:ntypat)
 end if

 token = 'quadmom'
 call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'DPR')
 if(tread==1)then
   dtset%quadmom(1:ntypat)=dprarr(1:ntypat)
 end if

 token = 'pawcpxocc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%pawcpxocc=intarr(1)
 else if (dtset%nspinor==2.and.(dtset%usepawu>=1.or.dtset%usedmft>0)) then
   dtset%pawcpxocc=2
 else if (dtset%pawspnorb>0.and.(dtset%kptopt<=0.or.dtset%kptopt>=3)) then
   if (dtset%optdriver/=0.or.dtset%ionmov<6.or.dtset%iscf<10) dtset%pawcpxocc=2
 end if

 token = 'pawcross'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawcross=intarr(1)

 token = 'pawecutdg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) then
   dtset%pawecutdg=dprarr(1)
!  else                           ! MT 2006, nov 28th: this defaut was "dangerous"
!  dtset%pawecutdg=two*dtset%ecut
 end if
 token = 'pawlcutd'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawlcutd=intarr(1)

 token = 'pawlmix'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawlmix=intarr(1)

 token = 'pawmixdg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%pawmixdg=intarr(1)
 else if (dtset%npfft>1.and.usepaw==1) then
   dtset%pawmixdg=1
 end if

 token = 'pawnhatxc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawnhatxc=intarr(1)

 token = 'pawntheta'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawntheta=intarr(1)

 token = 'pawnphi'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawnphi=intarr(1)

 token = 'pawnzlm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawnzlm=intarr(1)

 token = 'pawoptmix'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%pawoptmix=intarr(1)
 else
   if (usepaw==1.and.dtset%iscf<10.and.(dtset%positron==1.or.dtset%positron<0)) dtset%pawoptmix=1
 end if

 token = 'pawovlp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%pawovlp=dprarr(1)

!token = 'pawprtden'
!call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
!if(tread==1) then
!dtset%pawprtden=intarr(1)
!write(message, '(a,a,a,a,a,a,a,a)' )ch10,&
!&   ' invars2 : COMMENT -',ch10,&
!&   '  The pawprtden variable is deprecated and will soon be removed,',ch10,&
!&   '  use prtden instead next time.'
!call wrtout(std_out,message,'COLL')
!call wrtout(ab_out,message,'COLL')
!end if
!if (dtset%pawprtden>0.and.dtset%paral_kgb<=0) dtset%paral_atom=0

 token = 'paral_atom'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1)dtset%paral_atom=intarr(1)

 token = 'pawprtdos'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawprtdos=intarr(1)

 token = 'pawprtvol'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawprtvol=intarr(1)

 token = 'pawprtwf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawprtwf=intarr(1)

 token = 'pawprt_k'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawprt_k=intarr(1)

 token = 'pawprt_b'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawprt_b=intarr(1)

 token = 'pawstgylm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawstgylm=intarr(1)

 token = 'pawsushat'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawsushat=intarr(1)

 token = 'pawusecp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawusecp=intarr(1)

 token = 'pawxcdev'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawxcdev=intarr(1)

 token = 'spnorbscl'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%spnorbscl=dprarr(1)

 if (dtset%usedmft>0) then
   token = 'dmft_dc'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmft_dc=intarr(1)
   token = 'dmft_iter'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmft_iter=intarr(1)
   token = 'dmft_mxsf'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
   if(tread==1) dtset%dmft_mxsf=dprarr(1)
   token = 'dmft_nwli'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmft_nwli=intarr(1)
   token = 'dmft_nwlo'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmft_nwlo=intarr(1)
   token = 'dmft_read_occnd'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmft_read_occnd=intarr(1)
   token = 'dmft_rslf'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmft_rslf=intarr(1)
   token = 'dmft_solv'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmft_solv=intarr(1)
   token = 'dmft_tollc'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
   if(tread==1) dtset%dmft_tollc=dprarr(1)
   token = 'dmftbandi'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmftbandi=intarr(1)
   token = 'dmftbandf'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmftbandf=intarr(1)
   token = 'dmftcheck'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmftcheck=intarr(1)
 end if

 if (dtset%usepawu>0.or.dtset%usedmft>0) then
   token = 'upawu'
   call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'ENE')
   if(tread==1)then
     dtset%upawu(1:ntypat)=dprarr(1:ntypat)
   end if
   token = 'f4of2_sla'
   call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'ENE')
   if(tread==1)then
     dtset%f4of2_sla(1:ntypat)=dprarr(1:ntypat)
   end if
   token = 'f6of2_sla'
   call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'ENE')
   if(tread==1)then
     dtset%f6of2_sla(1:ntypat)=dprarr(1:ntypat)
   end if
   token = 'jpawu'
   call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'ENE')
   if(tread==1)then
     dtset%jpawu(1:ntypat)=dprarr(1:ntypat)
   end if
   token = 'dmatpuopt'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmatpuopt=intarr(1)
   token = 'dmatudiag'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%dmatudiag=intarr(1)

   if (dtset%usedmatpu/=0) then
     token = 'dmatpawu'
     if (dmatsize>0) then
       call intagm(dprarr,intarr,jdtset,marr,dmatsize,string(1:lenstr),token,tread,'DPR')
       if(tread==1) then
         ii=1;jj=0
         do iatom=1,natom
           lpawu=dtset%lpawu(dtset%typat(iatom))
           if (lpawu/=-1) then
             dtset%dmatpawu(1:2*lpawu+1,1:2*lpawu+1,1:nsppol*nspinor,ii)= &
&             reshape(dprarr(jj+1:jj+nsppol*nspinor*(2*lpawu+1)**2),(/2*lpawu+1,2*lpawu+1,nsppol*nspinor/))
             ii=ii+1;jj=jj+nsppol*nspinor*(2*lpawu+1)**2
           end if
         end do
       else
         write(message, '(3a)' )&
&         '  When LDA/GGA+U is activated and usedmatpu/=0, dmatpawu MUST be defined.',ch10,&
&         '  Action : add dmatpawu keyword in input file.'
         MSG_ERROR(message)
       end if
     end if
   end if
 end if

 if (dtset%macro_uj>0) then

   token = 'pawujat'
   dtset%pawujat=minval(pack((/ (ii,ii=1,dtset%natom) /) ,dtset%lpawu(dtset%typat(:))>0))
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%pawujat=intarr(1)

   token = 'pawujrad'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'LEN')
   if(tread==1) dtset%pawujrad=dprarr(1)

   token = 'pawujv'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
   if(tread==1) dtset%pawujv=dprarr(1)

 end if

 token = 'pawfatbnd'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pawfatbnd=intarr(1)

 token = 'bxctmindg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) then
   dtset%bxctmindg=dprarr(1)
 else if(usepaw==1)then
   dtset%bxctmindg=dtset%boxcutmin
 end if

 token = 'usexcnhat'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%usexcnhat=intarr(1)

 token = 'useylm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%useylm=intarr(1)
   if ((usepaw==1).and.(dtset%useylm==0)) then
     write(message, '(a,a,a,a,a)' )&
&     '  Pseudopotential file is PAW format (pspcod=7 or 17) while',ch10,&
&     '  input variable "useylm" has the incompatible value 0 !',ch10,&
&     '  Action : change psp format or "useylm" value in your input file.'
     MSG_ERROR(message)
   end if
   if ((dtset%tfkinfunc==2).and.(dtset%useylm==0)) then
     write(message, '(a,a,a,a,a)' )&
&     '  You are using recursion method (tfkinfunc=2)  while',ch10,&
&     '  input variable "useylm" has the incompatible value 0 !',ch10,&
&     '  Action : change  "useylm" value in your input file.'
     MSG_ERROR(message)
   end if
 end if
 if (usepaw==1) dtset%useylm=1
 if (dtset%use_gpu_cuda==1) dtset%useylm=1

 if(dtset%tfkinfunc==2) then
   dtset%useylm=1
   dtset%userec=1
 end if

 token = 'ireadc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   write(message, '(a,a,a)' )&
&   '  The use of the "ireadc" variable is forbidden since version 2.0.',ch10,&
&   '  Action : replace "ireadc" by "irdwfk" in your input file.'
   MSG_ERROR(message)
 end if

 ionmov=dtset%ionmov ; iprcch=dtset%iprcch ; iscf=dtset%iscf ; nqpt=dtset%nqpt
 kptopt=dtset%kptopt; nberry=dtset%nberry ; berryopt=dtset%berryopt

!Dielectric real(dp) input variables
!Reading of diemix/diemixmag must be inserted after iprcel
 token = 'diecut'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%diecut=dprarr(1)
!Special treatment if iscf==-1
 if(iscf==-1) dtset%diecut=four*dtset%ecut
 token = 'dielng'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'LEN')
 if(tread==1) dtset%dielng=dprarr(1)
 token = 'diemac'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%diemac=dprarr(1)

 token = 'diemix'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) then
   dtset%diemix=dprarr(1)
 else
   if (mod(dtset%iprcel,100)>19) dtset%diemix=one
 end if

 token = 'diemixmag'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) then
   dtset%diemixmag=dprarr(1)
 else
   if (dtset%iscf<10.or.dtset%nspden==1.or.dtset%iprcel==0.or.(dtset%iprcel>70.and.dtset%iprcel<80)) then
     dtset%diemixmag=dtset%diemix
   else
     dtset%diemixmag=-dtset%diemix
   end if
 end if

 token = 'diegap'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%diegap=dprarr(1)

 token = 'dielam'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%dielam=dprarr(1)

 token = 'maxestep'    !!HONG
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%maxestep=dprarr(1)

 token = 'td_maxene'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%td_maxene=dprarr(1)

!ACFD input variables
 token = 'idyson'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%idyson=intarr(1)

 token = 'ndyson'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ndyson=intarr(1)

 token = 'intexact'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%intexact=intarr(1)

 token = 'nbandsus'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nbandsus=intarr(1)
 token = 'ldgapp'

 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ldgapp=intarr(1)

 token = 'suskxcrs'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%suskxcrs=intarr(1)

 if((iscf==5.or.iscf==6) .and. ionmov==4 .and. iprcch/=3 )then
   iprcch=3
   dtset%iprcch=iprcch
   write(message, '(a,a,a,a,a,a)' ) ch10,&
&   ' invars2: COMMENT -',ch10,&
&   '  When ionmov==4 and iscf==5 or 6, iprcch must be 3.',ch10,&
&   '  Set iprcch to 3.'
   call wrtout(std_out,message,'COLL')
 end if


 token = 'mffmem'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%mffmem=intarr(1)

!Set default values of 0 for occupation numbers and k pt wts
 bantot=0

!nkpt and nband must be defined to execute following loop
 if ( tnband == 1 ) then
   do ikpt=1,nkpt*nsppol
     do ii=1,dtset%nband(ikpt)
       bantot=bantot+1
       dtset%occ_orig(bantot)=0.0_dp
     end do
   end do
 end if

!NON DEVLOP CASE
 token = 'nloalg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%nloalg(1)=mod(intarr(1),10)
   dtset%nloalg(5)=intarr(1)/10
 end if
!DEVLOP CASE. Note that the fifth component is not used now.
!token = 'nloalg'
!call intagm(dprarr,intarr,jdtset,marr,5,string(1:lenstr),token,tread,'INT')
!if(tread==1) then
!dtset%nloalg(1)=intarr(1) ; dtset%nloalg(2)=intarr(2)
!dtset%nloalg(3)=intarr(3) ; dtset%nloalg(4)=intarr(4) ; dtset%nloalg(4)=intarr(5)
!end if
!ENDDEVLOP

!LOOP variables
 token = 'nline'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nline=intarr(1)

 token = 'nnsclo'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nnsclo=intarr(1)

 token = 'nstep'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nstep=intarr(1)

 token = 'ntime'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ntime=intarr(1)

 token = 'nfreqsus'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nfreqsus=intarr(1)

 token = 'nctime'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%nctime=intarr(1)

 token = 'ortalg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%ortalg=intarr(1)
 else if (dtset%wfoptalg>=10 .and. dtset%ortalg>0) then
   dtset%ortalg=-dtset%ortalg
 end if

 token = 'pitransform'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%pitransform=intarr(1)

!Print variables
 token = 'prtatlist'
 call intagm(dprarr,intarr,jdtset,marr,natom,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%prtatlist=intarr(1:natom)
   call sort_int(natom,dtset%prtatlist,intarr)
 end if

 token = 'prtbbb'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtbbb=intarr(1)

 token = 'prtbltztrp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtbltztrp=intarr(1)

 token = 'prtcif'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtcif=intarr(1)

 token = 'prtcml'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtcml=intarr(1)

 token = 'prtcs'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtcs=intarr(1)

 token = 'prtden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtden=intarr(1)

 token = 'prtdipole'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtdipole=intarr(1)

 token = 'prtdos'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtdos=intarr(1)

 token = 'prtdosm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtdosm=intarr(1)

 token = 'prtefg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtefg=intarr(1)

 token = 'prteig'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prteig=intarr(1)

 token = 'prtelf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtelf=intarr(1)

 token = 'prtfc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtfc=intarr(1)

 token = 'prtfsurf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtfsurf=intarr(1)

 token = 'prtgden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtgden=intarr(1)

 token = 'prtgeo'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtgeo=intarr(1)

 token = 'prtgkk'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtgkk=intarr(1)

 token = 'prtkden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtkden=intarr(1)

 token = 'prtlden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtlden=intarr(1)

 token = 'prtnabla'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtnabla=intarr(1)

 token = 'prtnest'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtnest=intarr(1)

 token = 'prtposcar'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtposcar=intarr(1)

 token = 'prtpot'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtpot=intarr(1)

 token = 'prtspcur'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtspcur=intarr(1)

 token = 'prtsuscep'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtsuscep=intarr(1)

 token = 'prtstm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtstm=intarr(1)

 token = 'prt1dm'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prt1dm=intarr(1)
 if(dtset%nspden==4 .and. dtset%prt1dm==1) then
   write(message, '(a,a,a)' )&
&   ' prt1dm is not implemented for nspden 4 yet', ch10,&
&   ' Action : change  "prt1dm=0" value in your input file.'
   MSG_ERROR(message)
 end if

 token = 'prtvha'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtvha=intarr(1)

 token = 'prtvhxc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtvhxc=intarr(1)

 token = 'prtvol'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtvol=intarr(1)

 token = 'prtvolimg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtvolimg=intarr(1)

 token = 'prtvxc'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtvxc=intarr(1)

 token = 'prtwant'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtwant=intarr(1)

 token = 'prtwf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%prtwf=intarr(1)
   if ((dtset%tfkinfunc==2).and.(dtset%prtwf==1)) then
     write(message, '(a,a,a,a,a)' )&
&     '  You are using recursion method (tfkinfunc=2)  while',ch10,&
&     '  input variable "prtwf" has the incompatible value 1 !',ch10,&
&     '  Action : change  "prtwf=0" value in your input file.'
     MSG_ERROR(message)
   end if
 end if
 if (dtset%tfkinfunc==2) dtset%prtwf=0

 token = 'prtxml'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%prtxml=intarr(1)

 token = 'qprtrb'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%qprtrb(:)=intarr(1:3)

 token = 'strprecon'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%strprecon=dprarr(1)

 token = 'xc_denpos'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%xc_denpos=dprarr(1)

 token = 'xc_tb09_c'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%xc_tb09_c=dprarr(1)

!WVL - Wavelets related values
 token = 'wvl_hgrid'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%wvl_hgrid=dprarr(1)

 token = 'wvl_crmult'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%wvl_crmult=dprarr(1)

 token = 'wvl_frmult'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%wvl_frmult=dprarr(1)

 token = 'wvl_nprccg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%wvl_nprccg=intarr(1)

 token = 'tl_nprccg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%tl_nprccg=intarr(1)

 token = 'tl_radius'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%tl_radius=dprarr(1)

!Wannier90 interface related variables
!w90iniprj
 token = 'w90iniprj'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%w90iniprj=intarr(1)
   if ( usepaw == 0 .and. ( dtset%w90iniprj /= 2  .and. dtset%w90iniprj/=0 .and. dtset%w90iniprj /= 1 )) then
     write(message, '(a,i4,2a)' )&
&     ' w90iniprj should be set to 0, 1 or 2, however, it was ',dtset%w90iniprj,ch10,&
&     ' Action : check the values of w90iniprj.'
     MSG_ERROR(message)
   end if
   if ( usepaw == 1 .and. ( dtset%w90iniprj < 2 .or. dtset%w90iniprj>6 ) &
&   .and. ( dtset%w90iniprj /= 1 .and. dtset%w90iniprj/=0 )) then
     write(message, '(a,i4,2a)' )&
&     ' In the PAW case, the only valid values for w90iniprj are 0, 1, 2, 5 and 6 however, it was ',dtset%w90iniprj,ch10,&
&     ' Action : check the values of w90iniprj.'
     MSG_ERROR(message)
   end if
 end if
!w90prtunk
 token = 'w90prtunk'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%w90prtunk=intarr(1)
   if ( dtset%w90prtunk < 0 ) then
     write(message, '(4a)' )&
&     ' w90prtunk should be greater or equal to zero, however, it was ',dtset%w90prtunk,ch10,&
&     ' Action : check the values of w90prtunk.'
     MSG_ERROR(message)
   end if
 end if

!Wannier90 - GW quasiparticle interface
 if(dtset%prtwant==3) then
   token = 'getqps'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%getqps=intarr(1)
   token = 'irdqps'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%irdqps=intarr(1)
 end if

!van der Waals with DFT-D2 approach
 if(dtset%vdw_xc==5) then
   token = 'vdw_tol'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
   if(tread==1) dtset%vdw_tol=dprarr(1)
 end if

!van der Waals with Wannier functions (Silvestrelli's approach versions 1,2 and 3)
 if(dtset%vdw_xc==10.or.dtset%vdw_xc==11.or.dtset%vdw_xc==12) then
   token = 'vdw_nfrag'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
   if(tread==1)then
     dtset%vdw_nfrag=intarr(1)
   end if
   token = 'vdw_supercell'
   call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'INT')
   if(tread==1)then
     dtset%vdw_supercell(1:3)=intarr(1:3)
     if (dtset%supercell(1)<zero.and.dtset%supercell(2)<zero) then
       write(message, '(7a)' )&
&       ' only one component of vdw_supercell could be < 0, however, it was ',ch10,&
&       dtset%vdw_supercell(1),dtset%vdw_supercell(2),dtset%vdw_supercell(3),ch10,&
&       '  Action : check the components of vdw_supercell.'
       MSG_ERROR(message)
     end if
     if (dtset%supercell(2)<zero.and.dtset%supercell(3)<zero) then
       write(message, '(7a)' )&
&       ' only one component of vdw_supercell could be < 0, however, it was ',ch10,&
&       dtset%vdw_supercell(1),dtset%vdw_supercell(2),dtset%vdw_supercell(3),ch10,&
&       '  Action : check the components of vdw_supercell.'
       MSG_ERROR(message)
     end if
     if (dtset%supercell(1)<zero.and.dtset%supercell(3)<zero) then
       write(message, '(7a)' )&
&       ' only one component of vdw_supercell could be < 0, however, it was ',ch10,&
&       dtset%vdw_supercell(1),dtset%vdw_supercell(2),dtset%vdw_supercell(3),ch10,&
&       '  Action : check the components of vdw_supercell.'
       MSG_ERROR(message)
     end if
   end if

   token = 'vdw_typfrag'
   call intagm(dprarr,intarr,jdtset,marr,dtset%natom,string(1:lenstr),token,tread,'INT')
   if(tread==1)then
     dtset%vdw_typfrag(1:dtset%natom)=intarr(1:dtset%natom)
     do ii=1,dtset%natom
       if(dtset%vdw_typfrag(ii)<0)then
         write(message, '(a,a,a,i4,a,i4,a,a)' )&
&         '  All the components of vdw_typfrag must be greater than 0.',ch10,&
&         '  The component',ii,' is equal to ',dtset%vdw_typfrag(ii),ch10,&
&         '  Action : check the values of vdw_typfrag.'
         MSG_ERROR(message)
       end if
     end do
   end if
 end if !vdw_xc==10 or vdw_xc==11 or vdw_xc==12

 token = 'ucrpa'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%ucrpa=intarr(1)

 token = 'ucrpa_bands'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   if(dtset%nsym/=1) then
     write(message,*)&
&     '  Value of nsym should be 1 when ucrpa_bands is used ',dtset%nsym,&
&     '  (because symmetry is not yet used)',ch10,&
&     '  Action : use nsym=1 for optdriver=3 and kptopt=1'
     MSG_ERROR(message)
   else 
     dtset%ucrpa_bands(1:2)=intarr(1:2)
   end if
 end if


!Tolerance variables
 token = 'tolimg'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%tolimg=dprarr(1)

 token = 'tolmxf'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%tolmxf=dprarr(1)

 token = 'tolrde'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%tolrde=dprarr(1)

!find which tolXXX are defined generically and for this jdtset
 tolwfr_=zero
 toldfe_=zero
 toldff_=zero
 tolrff_=zero
 tolvrs_=zero
 itol=0
 itol_gen=0
 token = 'tolwfr'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR',ds_input)
 if(tread==1) then
   if (ds_input == 0) then
     tolwfr_=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol_gen=itol_gen+1
   else
     dtset%tolwfr=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol=itol+1
   end if
 end if

 token = 'toldff'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR',ds_input)
 if(tread==1) then
   if (ds_input == 0) then
     toldff_=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol_gen=itol_gen+1
   else
     dtset%toldff=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol=itol+1
   end if
   dtset%optforces=1
 end if

 token = 'tolrff'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR',ds_input)
 if(tread==1) then
   if (ds_input == 0) then
     tolrff_=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol_gen=itol_gen+1
   else
     dtset%tolrff=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol=itol+1
   end if
   dtset%optforces=1
 end if

 token = 'toldfe'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE',ds_input)
 if(tread==1) then
   if (ds_input == 0) then
     toldfe_=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol_gen=itol_gen+1
   else
     dtset%toldfe=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol=itol+1
   end if
 end if

 token = 'tolvrs'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR',ds_input)
 if(tread==1) then
   if (ds_input == 0) then
     tolvrs_=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol_gen=itol_gen+1
   else
     dtset%tolvrs=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol=itol+1
   end if
 end if

!check for multiple definitions of tolXXX for the present dataset
 if (itol > 1 .or. itol_gen > 1) then
   write(message, '(6a)' )ch10,&
&   ' invars2: ERROR -',ch10,&
&   '  Only one of the tolXXX variables may be defined at once.',ch10,&
&   '  Action : check values of tolvrs, toldfe, tolrff, tolwfr, and toldff.'
   MSG_ERROR(message)
 end if

!if no value is given for jdtset, use defaults
 if (itol == 0 .and. itol_gen == 1) then
   dtset%tolwfr=tolwfr_
   dtset%toldfe=toldfe_
   dtset%toldff=toldff_
   dtset%tolrff=tolrff_
   dtset%tolvrs=tolvrs_
 end if

!Tolerance variables for electrons-positron tc-dft
 toldfe_=zero;toldff_=zero
 itol=0;itol_gen=0
 token = 'postoldff'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR',ds_input)
 if(tread==1) then
   if (ds_input == 0) then
     toldff_=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol_gen=itol_gen+1
   else
     dtset%postoldff=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol=itol+1
   end if
   dtset%postoldfe=zero
 end if

 token = 'postoldfe'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'ENE',ds_input)
 if(tread==1) then
   if (ds_input == 0) then
     toldfe_=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol_gen=itol_gen+1
   else
     dtset%postoldfe=dprarr(1)
     if(abs(dprarr(1))>tiny(0._dp))itol=itol+1
   end if
 end if
 if (itol > 1.or.itol_gen >1) then
   write(message, '(3a)' )&
&   '  Only one of the postolXXX variables may be defined at once.',ch10,&
&   '  Action : check values of postoldfe and postoldff.'
   MSG_ERROR(message)
 end if
 if (itol==0.and.itol_gen==1) then
   dtset%postoldfe=toldfe_
   dtset%postoldff=toldff_
 end if

 token = 'usekden'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) dtset%usekden=intarr(1)

 token = 'vprtrb'
 call intagm(dprarr,intarr,jdtset,marr,2,string(1:lenstr),token,tread,'ENE')
 if(tread==1) dtset%vprtrb(:)=dprarr(1:2)

 if((dtset%pawfatbnd>0.or.dtset%prtdos==3) .and. dtset%natsph>0)then
   token = 'iatsph'
   call intagm(dprarr,intarr,jdtset,marr,dtset%natsph,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%iatsph(1:dtset%natsph)=intarr(1:dtset%natsph)
 end if

 token = 'prtdensph'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'INT')
 if(tread==1) then
   dtset%prtdensph=intarr(1)
 else if (dtset%nsppol==1.and.dtset%nspden==2) then
   dtset%prtdensph=1
 end if

!Initialize atvshift
 if(dtset%natvshift>0)then
   token = 'atvshift'
   call intagm(dprarr,intarr,jdtset,marr,dtset%natvshift*nsppol*dtset%natom,string(1:lenstr),&
&   token,tread,'ENE')
   if(tread==1) dtset%atvshift(1:dtset%natvshift,1:nsppol,1:dtset%natom)=&
&   reshape(dprarr(1:dtset%natvshift*nsppol*dtset%natom),(/dtset%natvshift,nsppol,dtset%natom/))
 end if

!Initialize wtatcon
 if(dtset%nconeq>0)then

!  Read and check natcon
   ABI_ALLOCATE(natcon,(dtset%nconeq))
   token = 'natcon'
   call intagm(dprarr,intarr,jdtset,marr,dtset%nconeq,string(1:lenstr),token,tread,'INT')
   if(tread==1)then
     natcon(:)=intarr(1:dtset%nconeq)
   else
     write(message, '(3a)' )&
&     '  When nconeq is positive, natcon MUST be defined.',ch10,&
&     '  Action : check the values of nconeq and natcon.'
     MSG_ERROR(message)
   end if
   do ii=1,dtset%nconeq
     if(natcon(ii)<0)then
       write(message, '(a,a,a,i4,a,i4,a,a)' )&
&       '  All the components of natcon must be greater than 0.',ch10,&
&       '  The component',ii,' is equal to ',natcon(ii),ch10,&
&       '  Action : check the values of natcon.'
       MSG_ERROR(message)
     end if
   end do
   niatcon=sum(natcon(:))

!  Read and check iatcon
   ABI_ALLOCATE(iatcon,(niatcon))
   token = 'iatcon'
   call intagm(dprarr,intarr,jdtset,marr,niatcon,string(1:lenstr),token,tread,'INT')
   if(tread==1)then
     iatcon(:)=intarr(1:niatcon)
   else
     write(message, '(3a)' )&
&     '  When nconeq is positive, natcon MUST be defined.',ch10,&
&     '  Action : check the values of nconeq and natcon.'
     MSG_ERROR(message)
   end if
   do ii=1,niatcon
     if(iatcon(ii)<0)then
       write(message, '(a,a,a,i4,a,i4,a,a)' )&
&       ' All the components of iatcon must be greater than 0.',ch10,&
&       ' The component',ii,' is equal to ',iatcon(ii),ch10,&
&       ' Action : check the values of iatcon.'
       MSG_ERROR(message)
     end if
   end do

!  Read wtatcon, and unfold it.
   token = 'wtatcon'
   call intagm(dprarr,intarr,jdtset,marr,3*niatcon,string(1:lenstr),token,tread,'DPR')
   if(tread/=1)then
     write(message, '(3a)' )&
&     '  When nconeq is positive, wtatcon MUST be defined.',ch10,&
&     '  Action : check the values of nconeq and wtatcon.'
     MSG_ERROR(message)
   end if
   index_nat=0
   do ii=1,dtset%nconeq
     do jj=1,natcon(ii)
       dtset%wtatcon(1:3,iatcon(jj+index_nat),ii)=dprarr(1+3*(jj+index_nat-1):3+3*(jj+index_nat-1))
     end do
     index_nat=index_nat+natcon(ii)
   end do

   ABI_DEALLOCATE(iatcon)
   ABI_DEALLOCATE(natcon)

 end if

!Initialize the list of k points, as well as wtk and istwfk
 intimage=1 ; if(nimage>2)intimage=(1+nimage)/2
 call invacuum(jdtset,lenstr,natom,dtset%rprimd_orig(1:3,1:3,intimage),string,vacuum,&
& dtset%xred_orig(1:3,1:natom,intimage))

!In case of a Berryphase calculation, put response = 1
!in order to set istwfk = 1 at all k-points

 if (abs(dtset%berryopt) > 0) response = 1

 nsym=dtset%nsym 
 ii=0;if (mod(dtset%wfoptalg,10)==4) ii=2
 call inkpts(bravais,dtset%chksymbreak,iout,iscf,dtset%istwfk(1:nkpt),jdtset,&
& dtset%kpt(:,1:nkpt),kptopt,dtset%kptnrm,dtset%kptrlatt,kptrlen,&
& lenstr,nsym,nkpt,nqpt,dtset%nshiftk,&
& nsym,occopt,dtset%qptn,response,&
& dtset%rprimd_orig(1:3,1:3,intimage),&
& dtset%shiftk,string,dtset%symafm(1:nsym),&
& dtset%symrel(:,:,1:nsym),vacuum,dtset%wtk(1:nkpt),&
& impose_istwf_1=ii)

 dtset%kptrlen=kptrlen

 dtset%kptns(:,1:nkpt)=dtset%kpt(:,1:nkpt)/dtset%kptnrm
 if(nqpt>=1 .and. dtset%optdriver/=1)then
   dtset%kptns(1,1:nkpt)=dtset%kptns(1,1:nkpt)+dtset%qptn(1)
   dtset%kptns(2,1:nkpt)=dtset%kptns(2,1:nkpt)+dtset%qptn(2)
   dtset%kptns(3,1:nkpt)=dtset%kptns(3,1:nkpt)+dtset%qptn(3)
 end if

 if(dtset%nkptgw>0) then

   token = 'bdgw'
   call intagm(dprarr,intarr,jdtset,marr,2*dtset%nkptgw*dtset%nsppol,string(1:lenstr),token,tread,'INT')
   if(tread==1) &
&   dtset%bdgw(1:2,1:dtset%nkptgw,1:dtset%nsppol)=reshape(intarr(1:2*dtset%nkptgw*dtset%nsppol),(/2,dtset%nkptgw,dtset%nsppol/))

   token = 'kptgw'
   call intagm(dprarr,intarr,jdtset,marr,3*dtset%nkptgw,string(1:lenstr),token,tread,'DPR')
   if(tread==1) dtset%kptgw(1:3,1:dtset%nkptgw)=&
&   reshape(dprarr(1:3*dtset%nkptgw),(/3,dtset%nkptgw/))

 end if

 if(dtset%nqptdm>0) then
   token = 'qptdm'
   call intagm(dprarr,intarr,jdtset,marr,3*dtset%nqptdm,string(1:lenstr),token,tread,'DPR')
   if(tread==1) dtset%qptdm(1:3,1:dtset%nqptdm)=reshape(dprarr(1:3*dtset%nqptdm),(/3,dtset%nqptdm/))
 end if

!Only read occ if (iscf >0 or iscf=-1 or iscf=-3) and (occopt==0 or occopt==2)
 if  (iscf>=0.or.iscf==-1.or.iscf==-3)  then
   if (occopt==2 .and. getocc==0) then
!    Read occ(nband(kpt)*nkpt*nsppol) explicitly
     write(message, '(a)' )&
&     ' invars2: reading occ(nband*nkpt*nsppol) explicitly'
     call wrtout(std_out,message,'COLL')
     token = 'occ'
     call intagm(dprarr,intarr,jdtset,marr,bantot,string(1:lenstr),token,tread,'DPR')
     if(tread==1) dtset%occ_orig(1:bantot)=dprarr(1:bantot)
   else if(occopt==0) then
!    Read usual occupancy--same for all k points and spins
     token = 'occ'
     call intagm(dprarr,intarr,jdtset,marr,dtset%nband(1),string(1:lenstr),token,tread,'DPR')
     if(tread==1) dtset%occ_orig(1:dtset%nband(1))=dprarr(1:dtset%nband(1))
!    Fill in full occ array using input values for each k and spin
!    (make a separate copy for each k point and spin)
     do ikpt=1,nkpt*nsppol
       dtset%occ_orig(1+(ikpt-1)*dtset%nband(1):ikpt*dtset%nband(1))=&
&       dtset%occ_orig(1:dtset%nband(1))
     end do
   end if
 end if

 if(dtset%jellslab/=0)then

   token = 'slabwsrad'
   call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'LEN')
   if(tread==1) dtset%slabwsrad=dprarr(1)

!  Update number of electrons taking into account jellium
!  Suppose that the cell has z axis perpendicular to x and y axes.
!  This will be checked later
   areaxy=abs(dtset%rprimd_orig(1,1,1)*dtset%rprimd_orig(2,2,1)-dtset%rprimd_orig(1,2,1)*dtset%rprimd_orig(2,1,1))
   rhoavg=three/(four_pi*dtset%slabwsrad**3)
   nelectjell=areaxy*(dtset%slabzend-dtset%slabzbeg)*rhoavg
   charge=charge-nelectjell

 end if

!Initialize occ if occopt==1 or 3 ... 8,
!while if getocc/=0, make a fake initialization
!If iscf>0, check the charge of the system, and compute nelect.
 occopt_tmp=occopt
 if(getocc/=0)occopt_tmp=1
 call chkneu(charge,dtset,occopt_tmp)

!Initialize Berry phase vectors
!Should check that nberry is smaller than 20
 if(berryopt>0 .and. nberry>0)then
   token = 'kberry'
   call intagm(dprarr,intarr,jdtset,marr,3*nberry,string(1:lenstr),token,tread,'INT')
   if(tread==1) dtset%kberry(1:3,1:nberry)=reshape(intarr(1:3*nberry), (/3,nberry/))
 end if

 token = 'ddamp'
 call intagm(dprarr,intarr,jdtset,marr,1,string(1:lenstr),token,tread,'DPR')
 if (tread==1) dtset%ddamp = dprarr(1)

 token = 'polcen'
 call intagm(dprarr,intarr,jdtset,marr,3,string(1:lenstr),token,tread,'DPR')
 if (tread==1) dtset%polcen(1:3) = dprarr(1:3)

 token = 'pimass'
!Default for pimass is amu
 dtset%pimass(1:ntypat)=dtset%amu_orig(1:ntypat,1)   ! NOTE : initialisation with the first image only. TO BE MODIFIED ....
 call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%pimass(1:ntypat)=dprarr(1:ntypat)

 token = 'densty'
 call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread,'DPR')
 if(tread==1) dtset%densty(1:ntypat,1)=dprarr(1:ntypat)


 token = 'so_psp'
 call intagm(dprarr,intarr,jdtset,marr,npsp,string(1:lenstr),token,tread,'INT')
 if(tread==1)then
   dtset%so_psp(1:npsp)=intarr(1:npsp)
 end if

!This is to be removed after a few version (from 5.4)
 token = 'so_typat'
 call intagm(dprarr,intarr,jdtset,marr,ntypat,string(1:lenstr),token,tread_alt,'INT')
 if(tread_alt==1)then
   write(message, '(3a)' )&
&   '  The use of the input variable so_typat has been discontinued in v5.4.',ch10,&
&   '  Action : please switch to so_psp (dimensioned to npsp - with different meanings of 0 and 1.'
   MSG_ERROR(message)
 end if

 ABI_DEALLOCATE(intarr)
 ABI_DEALLOCATE(dprarr)

 call timab(191,2,tsec)

end subroutine invars2
!!***
