!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawxcsph3
!! NAME
!! pawxcsph3
!!
!! FUNCTION
!! PAW only
!! Compute XC 1st-order potential for a 1st-order spherical density rho1(r)
!! associated to a spherical density, both given as (up,dn)
!! Driver of XC functionals. Only treat collinear spins. LDA and GGA
!!
!! COPYRIGHT
!! Copyright (C) 2012-2012 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!! This routine has been written from rhohxc_coll
!!
!! INPUTS
!!  cplex_den= if 1, 1st-order densities are REAL, if 2, COMPLEX
!!  cplex_vxc= if 1, 1st-order XC potential is complex, if 2, COMPLEX
!!  ixc= choice of exchange-correlation scheme (see above and below)
!!  nrad= dimension of the radial mesh
!!  nspden=number of spin-density components
!!  pawrad <type(pawrad_type)>=paw radial mesh and related data
!!  rho_updn(nrad,lm_size,nspden)=electron density in real space
!!             up (ispden=1) and down (ispden=2) parts
!!             If nspden=1, rho_updn(:,:,1) contains (1/2).rho_total
!!  rho1_updn(nrad,lm_size,nspden)=electron 1st-order density in real space
!!             up (ispden=1) and down (ispden=2) parts
!!             If nspden=1, rho_updn(:,:,1) contains (1/2).rho1_total
!!  xclevel= XC functional level
!!
!! OUTPUT
!!  vxc1((nrad,nspden)= XC 1st-order potential
!!
!! PARENTS
!!
!! CHILDREN
!!      deducer0,drivexc_main,nderiv_gen,size_dvxc
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

 subroutine pawxcsph3(cplex_den,cplex_vxc,ixc,nrad,nspden,pawrad,rho_updn,rho1_updn,vxc1,xclevel)

 use defs_basis
 use defs_datatypes
 use m_profiling
 use m_errors
 use m_radmesh, only : nderiv_gen, deducer0

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'pawxcsph3'
 use interfaces_56_xc, except_this_one => pawxcsph3
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: cplex_den,cplex_vxc,ixc,nrad,nspden,xclevel
 type(pawrad_type),intent(in) :: pawrad
!arrays
 real(dp),intent(in) :: rho_updn(nrad,nspden),rho1_updn(cplex_den*nrad,nspden)
 real(dp),intent(out) :: vxc1(cplex_vxc*nrad,nspden)

!Local variables-------------------------------
!scalars
 integer :: ii,ir,ispden,ivxc,jr,kr,mgga,ndvxc,nd2vxc,ngr2,ngrad,nkxc,nvxcdgr,order
 real(dp),parameter :: tol24=tol12*tol12
 real(dp) :: coeff_grho_corr,coeff_grho_dn,coeff_grho_up,fact
 real(dp) :: grho_grho1,grho_grho1_dn,grho_grho1_up
 character(len=500) :: msg
!arrays
 integer,parameter :: ikxc(4)=(/1,2,2,3/),irho(4)=(/1,2,1,2/)
 real(dp),allocatable :: dff(:),dgg(:),dvxcdgr(:,:),dvxc(:,:),exc(:),ff(:),gg(:)
 real(dp),allocatable :: grho_updn(:,:),grho1_updn(:,:),grho2(:,:)
 real(dp),allocatable :: gxc1i(:,:),gxc1r(:,:),kxc(:,:),vxc(:,:),vxc1i(:,:),vxc1r(:,:)

! *************************************************************************

 if(nspden>2)then
   write(msg, '(a,a,a,i0)' )&
&   ' Only non-spin-polarised or collinear spin-densities are allowed,',ch10,&
&   ' while the argument nspden=',nspden
   MSG_BUG(msg)
 end if
 if(nrad/=pawrad%mesh_size)then
   msg=' nrad is not equal to radial mesh size !'
   MSG_BUG(msg)
 end if

!Compute sizes of arrays and flags
 order=2 ! We need Kxc
 ngrad=1;if (xclevel==2) ngrad=2 ! ngrad=1 is for LDAs or LSDs; ngrad=2 is for GGAs
 call size_dvxc(ixc,ndvxc,ngr2,nd2vxc,nspden,nvxcdgr,order)
 nkxc=2*nspden-1;if (xclevel==2) nkxc=15
 mgga=0 !metaGGA contributions are not taken into account here

!--------------------------------------------------------------------------
!-------------- GGA: computation of the gradients of the densities
!--------------------------------------------------------------------------

 ABI_ALLOCATE(grho2,(nrad,ngr2))
 if (ngrad==2) then

   ABI_ALLOCATE(grho_updn,(nrad,nspden))
   ABI_ALLOCATE(grho1_updn,(cplex_den*nrad,nspden))

!  Gradient of density
   ABI_ALLOCATE(dff,(nrad))
   do ispden=1,nspden
     call nderiv_gen(dff,rho_updn(:,ispden),1,pawrad)
     grho_updn(:,ispden)=dff(:)
   end do
!  Gradient of 1st-order density
   if (cplex_den==1) then
     do ispden=1,nspden
       call nderiv_gen(dff,rho1_updn(:,ispden),1,pawrad)
       grho1_updn(:,ispden)=dff(:)
     end do
   else
     ABI_ALLOCATE(ff,(nrad))
     ABI_ALLOCATE(gg,(nrad))
     ABI_ALLOCATE(dgg,(nrad))
     do ispden=1,nspden
       do ir=1,nrad
         ff(ir)=rho1_updn(2*ir-1,ispden)
         gg(ir)=rho1_updn(2*ir  ,ispden)
       end do
       call nderiv_gen(dff,ff,1,pawrad)
       call nderiv_gen(dgg,gg,1,pawrad)
       do ir=1,nrad
         grho1_updn(2*ir-1,ispden)=dff(ir)
         grho1_updn(2*ir  ,ispden)=dgg(ir)
       end do
     end do
     ABI_DEALLOCATE(ff)
     ABI_DEALLOCATE(gg)
     ABI_DEALLOCATE(dgg)
   end if
   ABI_DEALLOCATE(dff)

!  Squared norm of the gradient
   grho2(:,1)=grho_updn(:,1)**2
   if (nspden==2) then
     grho2(:,2)=grho_updn(:,2)**2
     grho2(:,3)=(grho_updn(:,1)+grho_updn(:,2))**2
   end if

 end if

!--------------------------------------------------------------------------
!-------------- Computation of Kxc (and Exc, Vxc)
!--------------------------------------------------------------------------

 ABI_ALLOCATE(exc,(nrad))
 ABI_ALLOCATE(vxc,(nrad,nspden))
 ABI_ALLOCATE(dvxc,(nrad,ndvxc))
 ABI_ALLOCATE(dvxcdgr,(nrad,nvxcdgr))

!Call to main XC driver
 call drivexc_main(exc,ixc,mgga,ndvxc,nd2vxc,ngr2,nrad,nspden,nvxcdgr,order,rho_updn,vxc,xclevel, &
& dvxc=dvxc,grho2=grho2,vxcgrho=dvxcdgr)

!Transfer the XC kernel
 ABI_ALLOCATE(kxc,(nrad,nkxc))
 kxc(1:nrad,1:nkxc)=zero
 if (nkxc==1.and.ndvxc==15) then
   kxc(1:nrad,1)=half*(dvxc(1:nrad,1)+dvxc(1:nrad,9)+dvxc(1:nrad,10))
 else if (nkxc==3.and.ndvxc==15) then
   kxc(1:nrad,1)=dvxc(1:nrad,1)+dvxc(1:nrad,9)
   kxc(1:nrad,2)=dvxc(1:nrad,10)
   kxc(1:nrad,3)=dvxc(1:nrad,2)+dvxc(1:nrad,11)
 else
   kxc(1:nrad,1:min(nkxc,ndvxc))=dvxc(1:nrad,1:min(nkxc,ndvxc))
 end if

 ABI_DEALLOCATE(exc)
 ABI_DEALLOCATE(vxc)
 ABI_DEALLOCATE(dvxc)
 ABI_DEALLOCATE(dvxcdgr)

!--------------------------------------------------------------------------
!-------------- LDA
!--------------------------------------------------------------------------
 if (ngrad==1.or.ixc==13) then

   do ispden=1,3*nspden-2
     ivxc=1;if (ispden>2) ivxc=2
     if (cplex_vxc==1.and.cplex_den==1) then
       vxc1(:,ivxc)=vxc1(:,ivxc)+kxc(:,ikxc(ii))*rho1_updn(:,irho(ii))
     else
       do ir=1,nrad
         jr=cplex_den*(ir-1);kr=cplex_vxc*(ir-1)
         do ii=1,1+(cplex_den*cplex_vxc)/4
           jr=jr+1;kr=kr+1
           vxc1(kr,ivxc)=vxc1(kr,ivxc)+kxc(ir,ikxc(ii))*rho1_updn(jr,irho(ii))
         end do
       end do
     end if
   end do

!  --------------------------------------------------------------------------
!  -------------- GGA
!  --------------------------------------------------------------------------
 else

!  FOR NSPDEN=1, should eliminate computation of gxc1i(...), vxc1i(...)

   ABI_ALLOCATE(vxc1r,(nrad,2))
   ABI_ALLOCATE(vxc1i,(nrad,2))
   ABI_ALLOCATE(gxc1r,(nrad,2))
   ABI_ALLOCATE(gxc1i,(nrad,2))
   do ir=1,nrad
     if (cplex_vxc==1) then  ! cplex_vxc==1 and (cplex_den==1 or cplex_den=2)
       jr=cplex_den*(ir-1)+1
       grho_grho1_up=grho_updn(ir,1)*grho1_updn(jr,1)
       grho_grho1_dn=grho_updn(ir,2)*grho1_updn(jr,2)
       vxc1r(ir,1)=(kxc(ir, 1)+kxc(ir, 9))*rho1_updn(jr,1)+kxc(ir,10)*rho1_updn(jr,2) &
&       +kxc(ir, 5)*grho_grho1_up+kxc(ir,13)*grho_grho1
       vxc1r(ir,2)=(kxc(ir, 2)+kxc(ir,11))*rho1_updn(jr,2)+kxc(ir,10)*rho1_updn(jr,1) &
&       +kxc(ir, 6)*grho_grho1_dn+kxc(ir,14)*grho_grho1
       coeff_grho_corr=kxc(ir,13)*rho1_updn(jr,1)+kxc(ir,14)*rho1_updn(jr,2)+kxc(ir,15)*grho_grho1
       coeff_grho_up  =kxc(ir, 5)*rho1_updn(jr,1)+kxc(ir, 7)*grho_grho1_up
       coeff_grho_dn  =kxc(ir, 6)*rho1_updn(jr,2)+kxc(ir, 8)*grho_grho1_dn
       gxc1r(ir,1)=(kxc(ir, 3)+kxc(ir,12))*grho1_updn(jr,1)+kxc(ir,12)*grho1_updn(jr,2) &
&       +coeff_grho_up*grho_updn(jr,1)+coeff_grho_corr*(grho_updn(jr,1)+grho_updn(jr,2))
       gxc1r(ir,2)=(kxc(ir, 4)+kxc(ir,12))*grho1_updn(jr,2)+kxc(ir,12)*grho1_updn(jr,1) &
&       +coeff_grho_dn*grho_updn(jr,2)+coeff_grho_corr*(grho_updn(jr,1)+grho_updn(jr,2))
     end if
     if (grho2(ir,1)<tol24) gxc1r(ir,:)=zero ! ???
   end do

!  Apply divergence
   fact=one;if (nspden==1) fact=two  ! Is it true  ? we force nspden=2 for gxc...
   if (cplex_vxc==1) then
     ABI_ALLOCATE(dff,(nrad))
     do ispden=1,nspden
       call nderiv_gen(dff,gxc1r(:,ispden),1,pawrad)
       vxc1(2:nrad,ispden)=vxc1r(2:nrad,ispden)-fact*(dff(2:nrad)+two*gxc1r(2:nrad,ispden)/pawrad%rad(2:nrad))
       call deducer0(vxc1(:,ispden),nrad,pawrad)
     end do
     ABI_DEALLOCATE(dff)
   else
     ABI_ALLOCATE(dff,(nrad))
     ABI_ALLOCATE(dgg,(nrad))
     ABI_ALLOCATE(ff,(nrad))
     ABI_ALLOCATE(gg,(nrad))
     do ispden=1,nspden
       call nderiv_gen(dff,gxc1r(:,ispden),1,pawrad)
       call nderiv_gen(dgg,gxc1i(:,ispden),1,pawrad)
       ff(2:nrad)=vxc1r(2:nrad,ispden)-fact*(dff(2:nrad)+two*gxc1r(2:nrad,ispden)/pawrad%rad(2:nrad))
       gg(2:nrad)=vxc1i(2:nrad,ispden)-fact*(dgg(2:nrad)+two*gxc1i(2:nrad,ispden)/pawrad%rad(2:nrad))
       call deducer0(ff,nrad,pawrad)
       call deducer0(gg,nrad,pawrad)
       do ir=1,nrad
         vxc1(2*ir-1,ispden)=ff(ir)
         vxc1(2*ir  ,ispden)=gg(ir)
       end do
     end do
     ABI_DEALLOCATE(dff)
     ABI_DEALLOCATE(dgg)
     ABI_DEALLOCATE(ff)
     ABI_DEALLOCATE(gg)
   end if

   ABI_DEALLOCATE(vxc1r)
   ABI_DEALLOCATE(vxc1i)
   ABI_DEALLOCATE(gxc1r)
   ABI_DEALLOCATE(gxc1i)

 end if ! ngrad==2

!--------------------------------------------------------------------------
!-------------- Deallocations
!--------------------------------------------------------------------------

 ABI_DEALLOCATE(grho2)
 ABI_DEALLOCATE(kxc)
 if (ngrad==2) then
   ABI_DEALLOCATE(grho_updn)
   ABI_DEALLOCATE(grho1_updn)
 end if

 end subroutine pawxcsph3
!!***
