!{\src2tex{textfont=tt}}
!!****f* ABINIT/sqnorm_g
!! NAME
!! sqnorm_g
!!
!! FUNCTION
!! Compute the square of the norm of one complex vector vecti, in reciprocal space
!! Take into account the storage mode of the vector (istwf_k)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2012 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  istwf_k=option parameter that describes the storage of wfs
!!  mpi_enreg=informations about MPI parallelization
!!  npwsp= (effective) number of planewaves at this k point.
!!  vect(2,npwsp)=the vector in reciprocal space (npw*nspinor, usually)
!!
!! OUTPUT
!!  dotr= <vect|vect>
!!
!! SIDE EFFECTS
!!
!!
!! NOTES
!!
!!
!! PARENTS
!!      cgwf,cgwf3,dens_in_sph,mkresi,vtowfk3
!!
!! CHILDREN
!!      timab,xsum_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine sqnorm_g(dotr,istwf_k,mpi_enreg,npwsp,vect)

 use defs_basis
 use defs_abitypes
 use m_profiling
 use m_errors
 use m_xmpi
 use m_cgtools

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'sqnorm_g'
 use interfaces_18_timing
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: istwf_k,npwsp
 real(dp),intent(out) :: dotr
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 real(dp),intent(in) :: vect(2,npwsp)

!Local variables-------------------------------
!scalars
 integer :: ierr,ipw
!arrays
 real(dp) :: tsec(2)

! *************************************************************************

 DBG_CHECK(ANY(istwf_k==(/(ipw,ipw=1,9)/)),"Wrong istwf_k")

 if (istwf_k==1) then ! General k-point
#if 0
   dotr = cg_real_zdotc(npwsp,vect,vect)
#else
   dotr=zero
!$OMP PARALLEL DO REDUCTION(+:dotr)
   do ipw=1,npwsp
     dotr=dotr+vect(1,ipw)**2+vect(2,ipw)**2
   end do
#endif

 else
   if (istwf_k==2 .and. mpi_enreg%me_g0==1) then  ! Gamma k-point and I have G=0
     dotr=half*vect(1,1)**2
!    dotr = dotr + cg_real_zdotc(npwsp-1,vect(2),vect(2))
!$OMP PARALLEL DO REDUCTION(+:dotr) 
     do ipw=2,npwsp
       dotr=dotr+vect(1,ipw)**2+vect(2,ipw)**2
     end do
   else  ! Other TR k-points
!    dotr = cg_real_zdotc(npwsp,vect,vect)
     dotr=zero
!$OMP PARALLEL DO REDUCTION(+:dotr) 
     do ipw=1,npwsp
       dotr=dotr+vect(1,ipw)**2+vect(2,ipw)**2
     end do
   end if
   dotr=two*dotr
 end if

!XG030513 : MPIWF reduction on dotr is needed here
!Init mpi_comm
 if(mpi_enreg%nproc_fft>1)then
   call timab(48,1,tsec)
   call xsum_mpi(dotr,mpi_enreg%comm_fft ,ierr)
   call timab(48,2,tsec)
 end if

end subroutine sqnorm_g
!!***
