!{\src2tex{textfont=tt}}
!!****f* ABINIT/mean_fftr
!! NAME
!! mean_fftr
!!
!! FUNCTION
!!  Compute the mean of an arraysp(nfft,nspden), over the
!!  FFT grid, for each component nspden, and return it
!!  in meansp(nspden). Take into account the spread
!!  of the array due to parallelism : the actual number of fft
!!  points is nfftot, but the number of points on this proc
!!  is nfft only.
!!  So : for ispden from 1 to nspden
!!       meansp(ispden) = sum(ifft=1,nfftot) arraysp(ifft,ispden) / nfftot
!!
!! COPYRIGHT
!! Copyright (C) 2003-2012 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  arraysp(nfft,nspden)=the array whose average has to be computed
!!  mpi_enreg=informations about MPI parallelization
!!  nfft=number of FFT points stored by one proc
!!  nfftot=total number of FFT points
!!  nspden=number of spin-density components
!!
!! OUTPUT
!!  meansp(nspden)=mean value for each nspden component
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      fresid,multipoles_fftr,newvtr,pawmknhat,prcref,prcref_PMA,prctfvw1
!!      prctfvw2,prctfw3,psolver_rhohxc,rhohxc,rhohxcpositron,rhotov
!!
!! CHILDREN
!!      timab,xsum_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine mean_fftr(arraysp,meansp,mpi_enreg,nfft,nfftot,nspden)

 use defs_basis
 use defs_abitypes
 use m_profiling
 use m_errors
 use m_errors
 use m_xmpi

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'mean_fftr'
 use interfaces_18_timing
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nfft,nfftot,nspden
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 real(dp),intent(in) :: arraysp(nfft,nspden)
 real(dp),intent(out) :: meansp(nspden)

!Local variables-------------------------------
!scalars
 integer :: ierr,ifft,ispden,spaceComm
 real(dp) :: invnfftot,tmean
!arrays
 real(dp) :: tsec(2)

! *************************************************************************

 DBG_CHECK(ANY(nspden==(/1,2,4/)),"Wrong nspden")

 invnfftot=one/(dble(nfftot))

 do ispden=1,nspden
   tmean=zero
!$OMP PARALLEL DO REDUCTION(+:tmean)
   do ifft=1,nfft
     tmean=tmean+arraysp(ifft,ispden)
   end do 
   meansp(ispden)=tmean*invnfftot
 end do

!XG030514 : MPIWF The values of meansp(ispden) should
!now be summed accross processors in the same WF group, and spread on all procs.

!Init mpi_comm
 if(mpi_enreg%paral_kgb==1)then
   call timab(48,1,tsec)
   call xsum_mpi(meansp,nspden,mpi_enreg%comm_fft ,ierr)
   call timab(48,2,tsec)
 else if (mpi_enreg%usewvl) then
   spaceComm=mpi_enreg%comm_cell
   call timab(48,1,tsec)
   call xsum_mpi(meansp,nspden,spaceComm ,ierr)
   call timab(48,2,tsec)
 end if

end subroutine mean_fftr
!!***
