!{\src2tex{textfont=tt}}
!!****f* ABINIT/dotprod_g
!! NAME
!! dotprod_g
!!
!!
!! FUNCTION
!! Compute scalar product <vec1|vect2> of complex vectors vect1 and vect2 (can be the same)
!! Take into account the storage mode of the vectors (istwf_k)
!! If option=1, compute only real part, if option=2 compute also imaginary part. 
!! If the number of calls to the dot product scales quadratically
!! with the volume of the system, it is preferable not to
!! call the present routine, but but to write a specially
!! optimized routine, that will avoid many branches related to
!! the existence of 'option' and 'istwf_k'.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2012 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  istwf_k=option parameter that describes the storage of wfs
!!  vect1(2,npw)=first vector (one should take its complex conjugate)
!!  vect2(2,npw)=second vector
!!  mpi_enreg=information about MPI parallelization
!!  npw= (effective) number of planewaves at this k point (including spinorial level)
!!  option= 1 if only real part to be computed,
!!          2 if both real and imaginary.
!!          3 if in case istwf_k==1 must compute real and imaginary parts,
!!               but if  istwf_k >1 must compute only real part
!!
!! OUTPUT
!!  $doti=\Im ( <vect1|vect2> )$ , output only if option=2 and eventually option=3.
!!  $dotr=\Re ( <vect1|vect2> )$
!!
!! PARENTS
!!      cgwf,cgwf3,corrmetalwf1,eig2tot,extrapwf,mkresi,nonlop_gpu,nstpaw3
!!      nstwf3,nstwf4,recip_ylm,vtowfk3,wfkfermi3
!!
!! CHILDREN
!!      timab,xsum_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine dotprod_g(dotr,doti,istwf_k,mpi_enreg,npw,option,vect1,vect2)

 use defs_basis
 use defs_abitypes
 use m_errors
 use m_profiling
 use m_xmpi
 use m_cgtools

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'dotprod_g'
 use interfaces_18_timing
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: istwf_k,npw,option
 real(dp),intent(out) :: doti,dotr
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 real(dp),intent(in) :: vect1(2,npw),vect2(2,npw)

!Local variables-------------------------------
!scalars
 integer :: ierr,ipw
!arrays
 real(dp) :: dotarr(2),tsec(2)

! *************************************************************************

 DBG_CHECK(ANY(option==(/1,2,3/)),"Wrong option")
 DBG_CHECK(ANY(istwf_k==(/(ipw,ipw=1,9)/)),"Wrong istwf_k")

 if (istwf_k==1) then ! General k-point
   
   if(option==1)then
#if 0
     dotr = cg_real_zdotc(npw,vect1,vect2)
#else
     dotr=zero
!$OMP PARALLEL DO REDUCTION(+:dotr) 
     do ipw=1,npw
       dotr=dotr+vect1(1,ipw)*vect2(1,ipw)+vect1(2,ipw)*vect2(2,ipw)
     end do
#endif
   else
#if 1
     dotr=zero ; doti=zero
!$OMP PARALLEL DO REDUCTION(+:doti,dotr)
     do ipw=1,npw
       dotr=dotr+vect1(1,ipw)*vect2(1,ipw)+vect1(2,ipw)*vect2(2,ipw)
       doti=doti-vect1(2,ipw)*vect2(1,ipw)+vect1(1,ipw)*vect2(2,ipw)
     end do
#else
     dotarr = cg_zdotc(npw,vect1,vect2)
     dotr = dotarr(1)
     doti = dotarr(2)
#endif
   end if

 else if (istwf_k==2 .and. mpi_enreg%me_g0==1) then ! Gamma k-point and I have G=0

   dotr=half*vect1(1,1)*vect2(1,1)
!  dotarr(1) = cg_ddot(2*(npw-1),vect1(2),vect2(2))
!$OMP PARALLEL DO REDUCTION(+:dotr) 
   do ipw=2,npw
     dotr=dotr+vect1(1,ipw)*vect2(1,ipw)+vect1(2,ipw)*vect2(2,ipw)
   end do
   dotr = two*dotr
   if (option==2) doti=zero

 else ! Other TR k-points

   dotr=zero
!  dotarr(1) = cg_ddot(2*npw,vect1,vect2)
!$OMP PARALLEL DO REDUCTION(+:dotr) 
   do ipw=1,npw
     dotr=dotr+vect1(1,ipw)*vect2(1,ipw)+vect1(2,ipw)*vect2(2,ipw)
   end do
   dotr=two*dotr
   if (option==2) doti=zero
 end if

!Reduction in case of parallelism
 if(xcomm_size(mpi_enreg%comm_spinorfft)>1)then
   call timab(48,1,tsec)
   if (option==1.or.istwf_k/=1) then
     call xsum_mpi(dotr,mpi_enreg%comm_spinorfft,ierr)
   else
     dotarr(1)=dotr ; dotarr(2)=doti
     call xsum_mpi(dotarr,mpi_enreg%comm_spinorfft,ierr)
     dotr=dotarr(1) ; doti=dotarr(2)
   end if
   call timab(48,2,tsec)
 end if

end subroutine dotprod_g
!!***
