!{\src2tex{textfont=tt}}
!!****f* ABINIT/dfti_fourwf
!! NAME
!! dfti_fourwf
!!
!! FUNCTION
!! Carry out composite Fourier transforms between real and reciprocal (G) space.
!! Wavefunctions, contained in a sphere in reciprocal space,
!! can be FFT to real space. They can also be FFT from real space
!! to a sphere. Also, the density maybe accumulated, and a local potential can be applied.
!!
!! The different options are :
!! - option=0 --> reciprocal to real space and output the result.
!! - option=1 --> reciprocal to real space and accumulate the density.
!! - option=2 --> reciprocal to real space, apply the local potential to the wavefunction
!!                in real space and produce the result in reciprocal space.
!! - option=3 --> real space to reciprocal space.
!!                NOTE that in this case, fftalg=1x1 MUST be used. This may be changed in the future.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! cplex= if 1 , denpot is real, if 2 , denpot is complex
!!    (cplex=2 only allowed for option=2, and istwf_k=1)
!!    not relevant if option=0 or option=3, so cplex=0 can be used to minimize memory
!! fofgin(2,npwin)=holds input wavefunction in G vector basis sphere.
!!                 (intent(in) but the routine sphere can modify it for another iflag)
!! gboundin(2*mgfft+8,2)=sphere boundary info for reciprocal to real space
!! gboundout(2*mgfft+8,2)=sphere boundary info for real to reciprocal space
!! istwf_k=option parameter that describes the storage of wfs
!! kg_kin(3,npwin)=reduced planewave coordinates, input
!! kg_kout(3,npwout)=reduced planewave coordinates, output
!! mgfft=maximum size of 1D FFTs
!! mpi_enreg=information about MPI parallelization
!! ndat=number of FFT to do in //
!! ngfft(18)=contain all needed information about 3D FFT, see ~abinit/doc/input_variables/vargs.htm#ngfft
!! npwin=number of elements in fofgin array (for option 0, 1 and 2)
!! npwout=number of elements in fofgout array (for option 2 and 3)
!! n4,n5,n6=ngfft(4),ngfft(5),ngfft(6), dimensions of fofr.
!! option= if 0: do direct FFT
!!         if 1: do direct FFT, then sum the density
!!         if 2: do direct FFT, multiply by the potential, then do reverse FFT
!!         if 3: do reverse FFT only
!! paral_kgb=Flag related to the kpoint-band-fft parallelism
!! weight_r=weight to be used for the accumulation of the density in real space
!!         (needed only when option=1)
!!
!! weight_i=weight to be used for the accumulation of the density in real space
!!         (needed only when option=1 and (fftalg=4 and fftalgc/=0))
!! fofginb(2,npwin)=holds second input wavefunction in G vector basis sphere.
!!                 (intent(in) but the routine sphere can modify it for another iflag) 
!!                 (for non diagonal occupation)
!! use_ndo = use non diagonal occupations.

!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!! Input/Output
!! for option==0, fofgin(2,npwin*ndat)=holds input wavefunction in G sphere;
!!                fofr(2,n4,n5,n6) contains the output Fourier Transform of fofgin;
!!                no use of denpot, fofgout and npwout.
!! for option==1, fofgin(2,npwin*ndat)=holds input wavefunction in G sphere;
!!                denpot(cplex*n4,n5,n6) contains the input density at input,
!!                and the updated density at output (accumulated);
!!                no use of fofgout and npwout.
!! for option==2, fofgin(2,npwin*ndat)=holds input wavefunction in G sphere;
!!                denpot(cplex*n4,n5,n6) contains the input local potential;
!!                fofgout(2,npwout*ndat) contains the output function;
!! for option==3, fofr(2,n4,n5,n6*ndat) contains the input real space wavefunction;
!!                fofgout(2,npwout*ndat) contains its output Fourier transform;
!!                no use of fofgin and npwin.
!!
!! PARENTS
!!      fourwf
!!
!! CHILDREN
!!      cg_addtorho,cg_box2gsph,cg_vlocpsi,dfti_fftpad,sphere
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine dfti_fourwf(cplex,denpot,fofgin,fofgout,fofr,gboundin,gboundout,istwf_k,&
&  kg_kin,kg_kout,mgfft,mpi_enreg,ndat,ngfft,npwin,npwout,n4,n5,n6,option,paral_kgb,weight_r,weight_i,&
&  use_ndo,fofginb) ! optional Arguments.

 use defs_basis
 use defs_abitypes
 use m_profiling
 use m_cgtools
 use m_dfti
 use m_errors
 use m_timer

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'dfti_fourwf'
 use interfaces_53_ffts, except_this_one => dfti_fourwf
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: cplex,istwf_k,n4,n5,n6,ndat,npwin,npwout,option,paral_kgb,mgfft
 integer,intent(in),optional :: use_ndo
 real(dp),intent(in) :: weight_r,weight_i
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: gboundin(2*mgfft+8,2),gboundout(2*mgfft+8,2)
 integer,intent(in) :: kg_kin(3,npwin),kg_kout(3,npwout),ngfft(18)
 real(dp),intent(inout) :: denpot(cplex*n4,n5,n6),fofgin(2,npwin*ndat)
! real(dp) :: fofginb(2,npwin*ndat)
 real(dp),intent(inout),optional :: fofginb(:,:)
 real(dp),intent(inout) :: fofr(2,n4,n5,n6*ndat)
 real(dp),intent(out) :: fofgout(2,npwout*ndat)

!Local variables-------------------------------
!scalars
 integer :: fftalg,fftalga,fftalgc
 integer :: me_fft,n1,n2,n3,fftcache,nfftot,nproc_fft
 character(len=500) :: msg
 logical :: luse_ndo
!arrays
 integer :: shiftg(3),symm(3,3)

! *************************************************************************

 if (paral_kgb/=0) then 
   write(msg,'(a,i0)')' paral_kgb/=0 not yet compatible with FFTW3 wrappers but paral_kgb=',paral_kgb
   MSG_ERROR(msg)
 end if

 n1=ngfft(1); n2=ngfft(2); n3=ngfft(3); nfftot=n1*n2*n3
 fftalg=ngfft(7); fftalga=fftalg/100; fftalgc=mod(fftalg,10)
 me_fft=ngfft(11); nproc_fft=ngfft(10)
 fftcache=ngfft(8)

 luse_ndo=.false.
 if(present(use_ndo).and.present(fofginb)) then
   if(use_ndo==1) luse_ndo=.true.
 end if
 if(luse_ndo) then
   if((size(fofginb,2)==0).and.(use_ndo==1)) then
     write(msg, '(a,a,a,i4,i5)' )&
&     ' fofginb has a dimension equal to zero and use_ndo==1',ch10,&
&     ' Action : check dimension of fofginb',size(fofginb,2),use_ndo
     MSG_ERROR(msg)
   end if
 end if

 if (luse_ndo) then
   MSG_ERROR(" Non diagonal occupations are not compatible with FFTW3")
 end if

 if ( ALL(option /= (/0,1,2,3/)) ) then
   write(msg, '(a,i0,a)' )&
&   '  The option number',option,' is not allowed. Only option=0, 1, 2 or 3 are allowed presently.'
   MSG_ERROR(msg)
 end if

 if( option==1 .and. cplex/=1 )then
   write(msg,'(a,i0)')&
&   ' With the option number 1, cplex must be 1 but it is cplex=',cplex
   MSG_ERROR(msg)
 end if

 if( option==2 .and. (cplex/=1 .and. cplex/=2) )then
   write(msg,'(a,i0)')&
&   ' With the option number 2, cplex must be 1 or 2, but it is cplex=',cplex
   MSG_ERROR(msg)
 end if

 shiftg(:)=0
 symm=0; symm(1,1)=1; symm(2,2)=1; symm(3,3)=1

 if (ANY( option == (/0,1,2/) ))  then

!  if (istwf_k==2) then
!  call sphere(fofgin,ndat,npwin,fofr,n1,n2,n3,n4,n5,n6,kg_kin,istwf_k,1,mpi_enreg,shiftg,symm,one)
!  call dfti_fftpad_tr(fofr,n1,n2,n3,n4,n5,n6,ndat,mgfft,+1,gboundin)
!  RETURN
!  end if

   call sphere(fofgin,ndat,npwin,fofr,n1,n2,n3,n4,n5,n6,kg_kin,istwf_k,1,mpi_enreg,shiftg,symm,one)

   write(std_out,*)"dfti_fftpad"
   call dfti_fftpad(fofr,n1,n2,n3,n4,n5,n6,ndat,mgfft,+1,gboundin)
!  write(std_out,*)"dfti_many_dft"
!  call dfti_many_dft_ip(n1,n2,n3,n4,n5,n6,ndat,+1,fofr) 

   select case (option) 
     case (1)
       call cg_addtorho(n1,n2,n3,n4,n5,n6,ndat,weight_r,fofr,denpot)
       RETURN

     case (2)
       call cg_vlocpsi(n1,n2,n3,n4,n5,n6,ndat,cplex,denpot,fofr)

!      The data for option==2 is now in fofr.
!      call dfti_many_dft_ip(n1,n2,n3,n4,n5,n6,ndat,-1,fofr) 
       call dfti_fftpad(fofr,n1,n2,n3,n4,n5,n6,ndat,mgfft,-1,gboundout)

       call cg_box2gsph(n1,n2,n3,n4,n5,n6,ndat,npwout,kg_kout,fofr,fofgout)
   end select

 else if (option==3) then !  The data for option==3 is already in fofr.
   call dfti_fftpad(fofr,n1,n2,n3,n4,n5,n6,ndat,mgfft,-1,gboundout)

   call cg_box2gsph(n1,n2,n3,n4,n5,n6,ndat,npwout,kg_kout,fofr,fofgout)
 end if

 RETURN

 ABI_UNUSED(paral_kgb)
 ABI_UNUSED(weight_i)

end subroutine dfti_fourwf
!!***
