!{\src2tex{textfont=tt}}
!!****f* ABINIT/m_dtset
!! NAME
!!  m_dtset
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 1992-2012 ABINIT group (XG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

MODULE m_dtset

 use m_profiling
 use m_copy
 use m_errors

 use defs_abitypes, only : dataset_type

 implicit none

 private

 public :: dtset_nullify
 public :: dtset_copy
 public :: dtset_free

CONTAINS  !=========================================================================================================================
!!***

!!****f* m_dtset/dtset_nullify
!! NAME
!! dtset_nullify
!!
!! FUNCTION
!! Nullify all pointers of a dataset before use.
!!
!! SIDE EFFECTS
!!  dtset <type(dataset_type)>=nullify all pointers.
!!
!! PARENTS
!!      m_ab6_invars_f90
!!
!! CHILDREN
!!
!! SOURCE

subroutine dtset_nullify(dtset)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'dtset_nullify'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(dataset_type),intent(inout) :: dtset

! *************************************************************************

!please, use the same order as the one used in the declaration of the type (see defs_abitypes).
 !@dataset_type

!integer pointers
 nullify(dtset%algalch)
 nullify(dtset%bdgw)
 nullify(dtset%dynimage)
 nullify(dtset%iatfix)
 nullify(dtset%iatsph)
 nullify(dtset%istwfk)
 nullify(dtset%kberry)
 nullify(dtset%lexexch)
 nullify(dtset%lpawu)
 nullify(dtset%nband)
 nullify(dtset%prtatlist)
 nullify(dtset%so_psp)
 nullify(dtset%symafm)
 nullify(dtset%symrel)
 nullify(dtset%typat)

!real pointers
 nullify(dtset%acell_orig)
 nullify(dtset%amu_orig)
 nullify(dtset%atvshift)
 nullify(dtset%cd_imfrqs)
 nullify(dtset%corecs)
 nullify(dtset%densty)
 nullify(dtset%dmatpawu)
 nullify(dtset%gw_qlwl)
 nullify(dtset%f4of2_sla)
 nullify(dtset%f6of2_sla)
 nullify(dtset%gw_freqsp)
 nullify(dtset%jpawu)
 nullify(dtset%kpt)
 nullify(dtset%kptgw)
 nullify(dtset%kptns)
 nullify(dtset%mixalch_orig)
 nullify(dtset%occ_orig)
 nullify(dtset%pimass)
 nullify(dtset%ptcharge)
 nullify(dtset%qmass)
 nullify(dtset%qptdm)
 nullify(dtset%quadmom)
 nullify(dtset%ratsph)
 nullify(dtset%rprim_orig)
 nullify(dtset%rprimd_orig)
 nullify(dtset%shiftk)
 nullify(dtset%spinat)
 nullify(dtset%tnons)
 nullify(dtset%upawu)
 nullify(dtset%vel_orig)
 nullify(dtset%vel_cell_orig)
 nullify(dtset%wtatcon)
 nullify(dtset%wtk)
 nullify(dtset%xred_orig)
 nullify(dtset%ziontypat)
 nullify(dtset%znucl)

end subroutine dtset_nullify
!!***

!----------------------------------------------------------------------

!!****f* m_dtset/dtset_copy
!! NAME
!! dtset_copy
!!
!! FUNCTION
!! Copy all values of dataset dtin to dataset dtout. Pointers of dtout are
!! allocated if required. Use dtset_free() to free a dataset after use.
!!
!! INPUTS
!!  dtin <type(dataset_type)>=all input variables in this dataset
!!
!! OUTPUT
!!  dtout <type(dataset_type)>
!!
!! PARENTS
!!      afterscfloop,calc_vhxc_me,chkinp,driver,kxc_alda,m_io_kss,xc_kernel
!!      xc_kernel_ADA
!!
!! CHILDREN
!!
!! SOURCE

subroutine dtset_copy(dtout, dtin)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'dtset_copy'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(dataset_type),intent(in) :: dtin
 type(dataset_type),intent(out) :: dtout

!Local variables-------------------------------

! *************************************************************************

 DBG_ENTER("COLL")

 !@dataset_type

!BEGIN VARIABLES FOR @Bethe-Salpeter
 dtout%bs_algorithm     = dtin%bs_algorithm
 dtout%bs_haydock_niter = dtin%bs_haydock_niter
 dtout%bs_exchange_term = dtin%bs_exchange_term
 dtout%bs_coulomb_term  = dtin%bs_coulomb_term
 dtout%bs_calctype      = dtin%bs_calctype
 dtout%bs_coupling      = dtin%bs_coupling

 dtout%bs_haydock_tol   = dtin%bs_haydock_tol
 dtout%bs_hayd_term     = dtin%bs_hayd_term

 dtout%bs_loband        = dtin%bs_loband

 dtout%bs_eh_cutoff(:) = dtin%bs_eh_cutoff(:)
 dtout%bs_freq_mesh(:) = dtin%bs_freq_mesh(:)
!END VARIABLES FOR @Bethe-Salpeter.

!Copy integers from dtin to dtout
 dtout%accesswff          = dtin%accesswff
 dtout%awtr               = dtin%awtr
 dtout%bandpp             = dtin%bandpp
 dtout%bdeigrf            = dtin%bdeigrf
 dtout%berryopt           = dtin%berryopt
 dtout%berrysav           = dtin%berrysav
 dtout%berrystep          = dtin%berrystep
 dtout%brvltt             = dtin%brvltt
 dtout%bs_nstates         = dtin%bs_nstates
 dtout%builtintest        = dtin%builtintest
 dtout%cd_customnimfrqs   = dtin%cd_customnimfrqs
 dtout%cd_frqim_method    = dtin%cd_frqim_method
 dtout%cd_full_grid       = dtin%cd_full_grid
 dtout%chkexit            = dtin%chkexit
 dtout%chkgwcomp          = dtin%chkgwcomp
 dtout%chkprim            = dtin%chkprim
 dtout%chksymbreak        = dtin%chksymbreak
 dtout%cineb_start        = dtin%cineb_start
 dtout%delayperm          = dtin%delayperm
 dtout%diismemory         = dtin%diismemory
 dtout%dmatpuopt          = dtin%dmatpuopt
 dtout%dmatudiag          = dtin%dmatudiag
 dtout%dmft_dc            = dtin%dmft_dc
 dtout%dmft_iter          = dtin%dmft_iter
 dtout%dmft_mxsf          = dtin%dmft_mxsf
 dtout%dmft_nwlo          = dtin%dmft_nwlo
 dtout%dmft_nwli          = dtin%dmft_nwli
 dtout%dmft_read_occnd    = dtin%dmft_read_occnd
 dtout%dmft_rslf          = dtin%dmft_rslf
 dtout%dmft_solv          = dtin%dmft_solv
 dtout%dmft_tollc         = dtin%dmft_tollc
 dtout%dmftbandi          = dtin%dmftbandi
 dtout%dmftbandf          = dtin%dmftbandf
 dtout%dmftcheck          = dtin%dmftcheck
 dtout%enunit             = dtin%enunit
 dtout%exchn2n3d          = dtin%exchn2n3d
 dtout%pawfatbnd          = dtin%pawfatbnd
 dtout%fermie_nest        = dtin%fermie_nest
 dtout%fftgw              = dtin%fftgw
 dtout%fft_opt_lob        = dtin%fft_opt_lob
 dtout%freqim_alpha       = dtin%freqim_alpha
 dtout%freqremin          = dtin%freqremin
 dtout%freqremax          = dtin%freqremax
 dtout%freqspmin          = dtin%freqspmin
 dtout%freqspmax          = dtin%freqspmax
 dtout%frzfermi           = dtin%frzfermi
 dtout%ga_algor           = dtin%ga_algor
 dtout%ga_fitness         = dtin%ga_fitness
 dtout%ga_n_rules         = dtin%ga_n_rules
 dtout%getbseig           = dtin%getbseig
 dtout%getbsreso          = dtin%getbsreso
 dtout%getbscoup          = dtin%getbscoup
 dtout%getcell            = dtin%getcell
 dtout%getddk             = dtin%getddk
 dtout%getden             = dtin%getden
 dtout%getgam_eig2nkq     = dtin%getgam_eig2nkq
 dtout%gethaydock         = dtin%gethaydock
 dtout%getkss             = dtin%getkss
 dtout%getocc             = dtin%getocc
 dtout%getpawden          = dtin%getpawden
 dtout%getqps             = dtin%getqps
 dtout%getscr             = dtin%getscr
 dtout%getsuscep          = dtin%getsuscep
 dtout%getvel             = dtin%getvel
 dtout%getwfk             = dtin%getwfk
 dtout%getwfq             = dtin%getwfq
 dtout%getxcart           = dtin%getxcart
 dtout%getxred            = dtin%getxred
 dtout%get1den            = dtin%get1den
 dtout%get1wf             = dtin%get1wf
 dtout%goprecon           = dtin%goprecon
 dtout%gpu_linalg_limit   =dtin%gpu_linalg_limit
 dtout%gwcalctyp          = dtin%gwcalctyp
 dtout%gwcomp             = dtin%gwcomp
 dtout%gwencomp           = dtin%gwencomp
 dtout%gwmem              = dtin%gwmem
 dtout%gwpara             = dtin%gwpara
 dtout%gwgamma            = dtin%gwgamma
 dtout%gwrpacorr          = dtin%gwrpacorr
 dtout%gw_customnfreqsp   = dtin%gw_customnfreqsp
 dtout%gw_nqlwl           = dtin%gw_nqlwl
 dtout%gw_eet_nband       = dtin%gw_eet_nband
 dtout%gw_nstep           = dtin%gw_nstep
 dtout%gw_eet             = dtin%gw_eet
 dtout%gw_eet_inclvkb     = dtin%gw_eet_inclvkb
 dtout%gw_frqim_inzgrid   = dtin%gw_frqim_inzgrid
 dtout%gw_frqre_inzgrid   = dtin%gw_frqre_inzgrid
 dtout%gw_frqre_tangrid   = dtin%gw_frqre_tangrid
 dtout%gw_sctype          = dtin%gw_sctype
 dtout%gw_sigxcore        = dtin%gw_sigxcore
 dtout%gw_toldfeig        = dtin%gw_toldfeig
 dtout%gw_use_pole_scr    = dtin%gw_use_pole_scr
 dtout%gw_reconst_scr     = dtin%gw_reconst_scr
 dtout%gw_npoles          = dtin%gw_npoles
 dtout%iboxcut            = dtin%iboxcut
 dtout%icoulomb           = dtin%icoulomb
 dtout%icutcoul           = dtin%icutcoul
 dtout%idyson             = dtin%idyson
 dtout%ieig2rf            = dtin%ieig2rf
 dtout%ikhxc              = dtin%ikhxc
 dtout%imgmov             = dtin%imgmov
 dtout%inclvkb            = dtin%inclvkb
 dtout%intexact           = dtin%intexact
 dtout%intxc              = dtin%intxc
 dtout%ionmov             = dtin%ionmov
 dtout%iprcch             = dtin%iprcch
 dtout%iprcel             = dtin%iprcel
 dtout%iprctfvw           = dtin%iprctfvw
 dtout%iprcfc             = dtin%iprcfc
 dtout%irandom            = dtin%irandom
 dtout%irdbseig           = dtin%irdbseig
 dtout%irdbsreso          = dtin%irdbsreso
 dtout%irdbscoup          = dtin%irdbscoup
 dtout%irdddk             = dtin%irdddk
 dtout%irdden             = dtin%irdden
 dtout%irdhaydock         = dtin%irdhaydock
 dtout%irdkss             = dtin%irdkss
 dtout%irdpawden          = dtin%irdpawden
 dtout%irdqps             = dtin%irdqps
 dtout%irdscr             = dtin%irdscr
 dtout%irdsuscep          = dtin%irdsuscep
 dtout%irdwfk             = dtin%irdwfk
 dtout%irdwfq             = dtin%irdwfq
 dtout%ird1den            = dtin%ird1den
 dtout%ird1wf             = dtin%ird1wf
 dtout%iscf               = dtin%iscf
 dtout%isecur             = dtin%isecur
 dtout%istatimg           = dtin%istatimg
 dtout%istatr             = dtin%istatr
 dtout%istatshft          = dtin%istatshft
 dtout%ixc                = dtin%ixc
 dtout%ixcpositron        = dtin%ixcpositron
 dtout%jdtset             = dtin%jdtset
 dtout%jellslab           = dtin%jellslab
 dtout%kptopt             = dtin%kptopt
 dtout%kssform            = dtin%kssform
 dtout%ldgapp             = dtin%ldgapp
 dtout%localrdwf          = dtin%localrdwf
 dtout%maxnsym            = dtin%maxnsym
 dtout%mband              = dtin%mband
 dtout%mdf_epsinf         = dtin%mdf_epsinf
 dtout%mep_solver         = dtin%mep_solver
 dtout%mffmem             = dtin%mffmem
 dtout%mgfft              = dtin%mgfft
 dtout%mgfftdg            = dtin%mgfftdg
 dtout%mkmem              = dtin%mkmem
 dtout%mkqmem             = dtin%mkqmem
 dtout%mk1mem             = dtin%mk1mem
 dtout%mpw                = dtin%mpw
 dtout%mqgrid             = dtin%mqgrid
 dtout%mqgriddg           = dtin%mqgriddg
 dtout%natom              = dtin%natom
 dtout%natrd              = dtin%natrd
 dtout%natsph             = dtin%natsph
 dtout%natpawu            = dtin%natpawu
 dtout%natvshift          = dtin%natvshift
 dtout%nbandsus           = dtin%nbandsus
 dtout%nbdblock           = dtin%nbdblock
 dtout%nbdbuf             = dtin%nbdbuf
 dtout%nberry             = dtin%nberry
 dtout%nbandkss           = dtin%nbandkss
 dtout%nconeq             = dtin%nconeq
 dtout%nctime             = dtin%nctime
 dtout%ndtset             = dtin%ndtset
 dtout%ndyson             = dtin%ndyson
 dtout%ndynimage          = dtin%ndynimage
 dtout%neb_algo           = dtin%neb_algo
 dtout%nfft               = dtin%nfft
 dtout%nfftdg             = dtin%nfftdg
 dtout%nfreqim            = dtin%nfreqim
 dtout%nfreqre            = dtin%nfreqre
 dtout%nfreqsp            = dtin%nfreqsp
 dtout%nfreqsus           = dtin%nfreqsus
 dtout%nimage             = dtin%nimage
 dtout%nkptgw             = dtin%nkptgw
 dtout%nkpt               = dtin%nkpt
 dtout%nline              = dtin%nline
 dtout%nnsclo             = dtin%nnsclo
 dtout%nomegasf           = dtin%nomegasf
 dtout%nomegasi           = dtin%nomegasi
 dtout%nomegasrd          = dtin%nomegasrd
 dtout%npband             = dtin%npband
 dtout%npfft              = dtin%npfft
 dtout%npimage            = dtin%npimage
 dtout%npkpt              = dtin%npkpt
 dtout%nppert             = dtin%nppert
 dtout%npspinor           = dtin%npspinor
 dtout%npsp               = dtin%npsp
 dtout%npspalch           = dtin%npspalch
 dtout%npulayit           = dtin%npulayit
 dtout%npweps             = dtin%npweps
 dtout%npwkss             = dtin%npwkss
 dtout%npwsigx            = dtin%npwsigx
 dtout%npwwfn             = dtin%npwwfn
 dtout%np_slk             = dtin%np_slk
 dtout%nqpt               = dtin%nqpt
 dtout%nqptdm             = dtin%nqptdm
 dtout%nscforder          = dtin%nscforder
 dtout%nsheps             = dtin%nsheps
 dtout%nshiftk            = dtin%nshiftk
 dtout%nshsigx            = dtin%nshsigx
 dtout%nshwfn             = dtin%nshwfn
 dtout%nspden             = dtin%nspden
 dtout%nspinor            = dtin%nspinor
 dtout%nsppol             = dtin%nsppol
 dtout%nstep              = dtin%nstep
 dtout%nsym               = dtin%nsym
 dtout%ntime              = dtin%ntime
 dtout%ntimimage          = dtin%ntimimage
 dtout%ntypalch           = dtin%ntypalch
 dtout%ntypat             = dtin%ntypat
 dtout%ntyppure           = dtin%ntyppure
 dtout%nwfshist           = dtin%nwfshist
 dtout%occopt             = dtin%occopt
 dtout%optcell            = dtin%optcell
 dtout%optdriver          = dtin%optdriver
 dtout%optforces          = dtin%optforces
 dtout%optfreqsus         = dtin%optfreqsus
 dtout%optnlxccc          = dtin%optnlxccc
 dtout%optstress          = dtin%optstress
 dtout%ortalg             = dtin%ortalg
 dtout%paral_atom          = dtin%paral_atom
 dtout%paral_kgb          = dtin%paral_kgb
 dtout%paral_rf           = dtin%paral_rf
 dtout%pawcpxocc          = dtin%pawcpxocc
 dtout%pawcross           = dtin%pawcross
 dtout%pawlcutd           = dtin%pawlcutd
 dtout%pawlmix            = dtin%pawlmix
 dtout%pawmixdg           = dtin%pawmixdg
 dtout%pawnhatxc          = dtin%pawnhatxc
 dtout%pawnphi            = dtin%pawnphi
 dtout%pawntheta          = dtin%pawntheta
 dtout%pawnzlm            = dtin%pawnzlm
 dtout%pawoptmix          = dtin%pawoptmix
!dtout%pawprtden          = dtin%pawprtden
 dtout%pawprtdos          = dtin%pawprtdos
 dtout%pawprtvol          = dtin%pawprtvol
 dtout%pawprtwf           = dtin%pawprtwf
 dtout%pawprt_k           = dtin%pawprt_k
 dtout%pawprt_b           = dtin%pawprt_b
 dtout%pawspnorb          = dtin%pawspnorb
 dtout%pawstgylm          = dtin%pawstgylm
 dtout%pawsushat          = dtin%pawsushat
 dtout%pawusecp           = dtin%pawusecp
 dtout%pawujat            = dtin%pawujat
 dtout%macro_uj           = dtin%macro_uj
 dtout%pawujrad           = dtin%pawujrad
 dtout%pawujv             = dtin%pawujv
 dtout%pawxcdev           = dtin%pawxcdev
 dtout%pitransform        = dtin%pitransform
 dtout%positron           = dtin%positron
 dtout%posnstep           = dtin%posnstep
 dtout%ppmodel            = dtin%ppmodel
 dtout%prepanl            = dtin%prepanl
 dtout%prepgkk            = dtin%prepgkk
 dtout%prepscphon         = dtin%prepscphon
 dtout%prtbbb             = dtin%prtbbb
 dtout%prtbltztrp         = dtin%prtbltztrp
 dtout%prtcif             = dtin%prtcif
 dtout%prtcml             = dtin%prtcml
 dtout%prtcs              = dtin%prtcs
 dtout%prtden             = dtin%prtden
 dtout%prtdensph          = dtin%prtdensph
 dtout%prtdipole          = dtin%prtdipole
 dtout%prtdos             = dtin%prtdos
 dtout%prtdosm            = dtin%prtdosm
 dtout%prtefg             = dtin%prtefg
 dtout%prteig             = dtin%prteig
 dtout%prtelf             = dtin%prtelf
 dtout%prtfc              = dtin%prtfc
 dtout%prtfsurf           = dtin%prtfsurf
 dtout%prtgden            = dtin%prtgden
 dtout%prtgeo             = dtin%prtgeo
 dtout%prtgkk             = dtin%prtgkk
 dtout%prtkden            = dtin%prtkden
 dtout%prtkpt             = dtin%prtkpt
 dtout%prtlden            = dtin%prtlden
 dtout%prtnabla           = dtin%prtnabla
 dtout%prtnest            = dtin%prtnest
 dtout%prtposcar          = dtin%prtposcar
 dtout%prtpot             = dtin%prtpot
 dtout%prtspcur           = dtin%prtspcur
 dtout%prtsuscep          = dtin%prtsuscep
 dtout%prtstm             = dtin%prtstm
 dtout%prtvha             = dtin%prtvha
 dtout%prtvhxc            = dtin%prtvhxc
 dtout%prtvol             = dtin%prtvol
 dtout%prtvolimg          = dtin%prtvolimg
 dtout%prtvxc             = dtin%prtvxc
 dtout%prtwant            = dtin%prtwant
 dtout%prtwf              = dtin%prtwf
 dtout%prtxml             = dtin%prtxml
 dtout%prt1dm             = dtin%prt1dm
 dtout%ptgroupma          = dtin%ptgroupma
 dtout%random_atpos       = dtin%random_atpos
 dtout%recgratio          = dtin%recgratio
 dtout%recnpath           = dtin%recnpath
 dtout%recnrec            = dtin%recnrec
 dtout%recptrott          = dtin%recptrott
 dtout%rectesteg          = dtin%rectesteg
 dtout%rcut               = dtin%rcut
 dtout%restartxf          = dtin%restartxf
 dtout%rfasr              = dtin%rfasr
 dtout%rfddk              = dtin%rfddk
 dtout%rfelfd             = dtin%rfelfd
 dtout%rfmeth             = dtin%rfmeth
 dtout%rfphon             = dtin%rfphon
 dtout%rfstrs             = dtin%rfstrs
 dtout%rfuser             = dtin%rfuser
 dtout%rf1elfd            = dtin%rf1elfd
 dtout%rf1phon            = dtin%rf1phon
 dtout%rf2elfd            = dtin%rf2elfd
 dtout%rf2phon            = dtin%rf2phon
 dtout%rf3elfd            = dtin%rf3elfd
 dtout%rf3phon            = dtin%rf3phon
 dtout%rhoqpmix           = dtin%rhoqpmix
 dtout%signperm           = dtin%signperm
 dtout%slabwsrad          = dtin%slabwsrad
 dtout%slabzbeg           = dtin%slabzbeg
 dtout%slabzend           = dtin%slabzend
 dtout%smdelta            = dtin%smdelta
 dtout%spgaxor            = dtin%spgaxor
 dtout%spgorig            = dtin%spgorig
 dtout%spgroup            = dtin%spgroup
 dtout%spmeth             = dtin%spmeth
 dtout%string_algo        = dtin%string_algo
 dtout%suskxcrs           = dtin%suskxcrs
 dtout%symchi             = dtin%symchi
 dtout%symmorphi          = dtin%symmorphi
 dtout%symsigma           = dtin%symsigma
 dtout%td_mexcit          = dtin%td_mexcit
 dtout%tfkinfunc          = dtin%tfkinfunc
 dtout%timopt             = dtin%timopt
 dtout%use_gpu_cuda       = dtin%use_gpu_cuda
 dtout%use_slk            = dtin%use_slk
 dtout%useexexch          = dtin%useexexch
 dtout%usedmatpu          = dtin%usedmatpu
 dtout%usedmft            = dtin%usedmft
 dtout%usekden            = dtin%usekden
 dtout%usepaw             = dtin%usepaw
 dtout%usepawu            = dtin%usepawu
 dtout%userec             = dtin%userec
 dtout%useria             = dtin%useria
 dtout%userib             = dtin%userib
 dtout%useric             = dtin%useric
 dtout%userid             = dtin%userid
 dtout%userie             = dtin%userie
 dtout%usewvl             = dtin%usewvl
 dtout%usexcnhat          = dtin%usexcnhat
 dtout%useylm             = dtin%useylm
 dtout%vacnum             = dtin%vacnum
 dtout%vdw_nfrag          = dtin%vdw_nfrag
 dtout%vdw_xc             = dtin%vdw_xc
 dtout%wfoptalg           = dtin%wfoptalg
 dtout%w90iniprj          = dtin%w90iniprj
 dtout%w90prtunk          = dtin%w90prtunk
 dtout%xclevel            = dtin%xclevel
 dtout%xc_denpos          = dtin%xc_denpos

!Copy allocated integer arrays from dtin to dtout
 dtout%bdberry(:)         = dtin%bdberry(:)
 dtout%cd_subset_freq(:)  = dtin%cd_subset_freq(:)
 dtout%ga_rules(:)        = dtin%ga_rules(:)
 dtout%jfielddir(:)       = dtin%jfielddir(:)
 dtout%kptrlatt(:,:)      = dtin%kptrlatt(:,:)
 dtout%ngfft(:)           = dtin%ngfft(:)
 dtout%ngfftdg(:)         = dtin%ngfftdg(:)
 dtout%nloalg(:)          = dtin%nloalg(:)
 dtout%qprtrb(:)          = dtin%qprtrb(:)
 dtout%rfatpol(:)         = dtin%rfatpol(:)
 dtout%rfdir(:)           = dtin%rfdir(:)
 dtout%rf1atpol(:)        = dtin%rf1atpol(:)
 dtout%rf1dir(:)          = dtin%rf1dir(:)
 dtout%rf2atpol(:)        = dtin%rf2atpol(:)
 dtout%rf2dir(:)          = dtin%rf2dir(:)
 dtout%rf3atpol(:)        = dtin%rf3atpol(:)
 dtout%rf3dir(:)          = dtin%rf3dir(:)
 dtout%scphon_supercell(:)= dtin%scphon_supercell(:)
 dtout%supercell(:)       = dtin%supercell(:)
 dtout%ucrpa_bands(:)     = dtin%ucrpa_bands(:)
 dtout%vdw_supercell(:)   = dtin%vdw_supercell(:)
 dtout%vdw_typfrag(:)     = dtin%vdw_typfrag(:)

!Copy reals from dtin to dtout
 dtout%boxcutmin          = dtin%boxcutmin
 dtout%bxctmindg          = dtin%bxctmindg
 dtout%cd_halfway_freq    = dtin%cd_halfway_freq
 dtout%cd_max_freq        = dtin%cd_max_freq
 dtout%charge             = dtin%charge
 dtout%cpus               = dtin%cpus
 dtout%ddamp              = dtin%ddamp
 dtout%diecut             = dtin%diecut
 dtout%diegap             = dtin%diegap
 dtout%dielam             = dtin%dielam
 dtout%dielng             = dtin%dielng
 dtout%diemac             = dtin%diemac
 dtout%diemix             = dtin%diemix
 dtout%diemixmag          = dtin%diemixmag
 dtout%dilatmx            = dtin%dilatmx
 dtout%dosdeltae          = dtin%dosdeltae
 dtout%dtion              = dtin%dtion
 dtout%ecut               = dtin%ecut
 dtout%ecuteps            = dtin%ecuteps
 dtout%ecutsigx           = dtin%ecutsigx
 dtout%ecutsm             = dtin%ecutsm
 dtout%ecutwfn            = dtin%ecutwfn
 dtout%effmass            = dtin%effmass
 dtout%elph2_imagden      = dtin%elph2_imagden
 dtout%eshift             = dtin%eshift
 dtout%esmear             = dtin%esmear
 dtout%exchmix            = dtin%exchmix
 dtout%fband              = dtin%fband
 dtout%spinmagntarget             = dtin%spinmagntarget
 dtout%freqsusin          = dtin%freqsusin
 dtout%freqsuslo          = dtin%freqsuslo
 dtout%friction           = dtin%friction
 dtout%fxcartfactor       = dtin%fxcartfactor
 dtout%ga_opt_percent     = dtin%ga_opt_percent
 dtout%gw_eet_scale       = dtin%gw_eet_scale
 dtout%kptnrm             = dtin%kptnrm
 dtout%kptrlen            = dtin%kptrlen
 dtout%maxestep           = dtin%maxestep
 dtout%bmass              = dtin%bmass
 dtout%nnos               = dtin%nnos
 dtout%mdwall             = dtin%mdwall
 dtout%mep_mxstep         = dtin%mep_mxstep
 dtout%nelect             = dtin%nelect
 dtout%noseinert          = dtin%noseinert
 dtout%omegasimax         = dtin%omegasimax
 dtout%omegasrdmax        = dtin%omegasrdmax
 dtout%pawecutdg          = dtin%pawecutdg
 dtout%pawovlp            = dtin%pawovlp
 dtout%posocc             = dtin%posocc
 dtout%postoldfe          = dtin%postoldfe
 dtout%postoldff          = dtin%postoldff
 dtout%ppmfrq             = dtin%ppmfrq
 dtout%recrcut            = dtin%recrcut
 dtout%recefermi          = dtin%recefermi
 dtout%rectolden          = dtin%rectolden
 dtout%scphon_temp        = dtin%scphon_temp
 dtout%sciss              = dtin%sciss
 dtout%soenergy           = dtin%soenergy
 dtout%spbroad            = dtin%spbroad
 dtout%spnorbscl          = dtin%spnorbscl
 dtout%stmbias            = dtin%stmbias
 dtout%strfact            = dtin%strfact
 dtout%strprecon          = dtin%strprecon
 dtout%tl_radius          = dtin%tl_radius
 dtout%tl_nprccg          = dtin%tl_nprccg
 dtout%td_maxene          = dtin%td_maxene
 dtout%toldfe             = dtin%toldfe
 dtout%toldff             = dtin%toldff
 dtout%tolimg             = dtin%tolimg
 dtout%tolmxf             = dtin%tolmxf
 dtout%tolrde             = dtin%tolrde
 dtout%tolrff             = dtin%tolrff
 dtout%tolsym             = dtin%tolsym
 dtout%tolvrs             = dtin%tolvrs
 dtout%tolwfr             = dtin%tolwfr
 dtout%tphysel            = dtin%tphysel
 dtout%tsmear             = dtin%tsmear
 dtout%ucrpa              = dtin%ucrpa
 dtout%userra             = dtin%userra
 dtout%userrb             = dtin%userrb
 dtout%userrc             = dtin%userrc
 dtout%userrd             = dtin%userrd
 dtout%userre             = dtin%userre
 dtout%vacwidth           = dtin%vacwidth
 dtout%vdw_tol            = dtin%vdw_tol
 dtout%vis                = dtin%vis
 dtout%wvl_hgrid          = dtin%wvl_hgrid
 dtout%wvl_crmult         = dtin%wvl_crmult
 dtout%wvl_frmult         = dtin%wvl_frmult
 dtout%wvl_nprccg         = dtin%wvl_nprccg
 dtout%xc_tb09_c          = dtin%xc_tb09_c
 dtout%zcut               = dtin%zcut

!Copy allocated real arrays from dtin to dtout
 dtout%boxcenter(:)       = dtin%boxcenter(:)
 dtout%bfield(:)          = dtin%bfield(:)
 dtout%dfield(:)          = dtin%dfield(:)
 dtout%efield(:)          = dtin%efield(:)
 dtout%genafm(:)          = dtin%genafm(:)
 dtout%goprecprm(:)       = dtin%goprecprm(:)
 dtout%mdtemp(:)          = dtin%mdtemp(:)
 dtout%neb_spring(:)      = dtin%neb_spring(:)
 dtout%polcen(:)          = dtin%polcen(:)
 dtout%qptn(:)            = dtin%qptn(:)
 dtout%red_efield(:)      = dtin%red_efield(:)
 dtout%red_dfield(:)      = dtin%red_dfield(:)
 dtout%red_efieldbar(:)   = dtin%red_efieldbar(:)
 dtout%strtarget(:)       = dtin%strtarget(:)
 dtout%vcutgeo(:)         = dtin%vcutgeo(:)
 dtout%vprtrb(:)          = dtin%vprtrb(:)
 dtout%zeemanfield(:)     = dtin%zeemanfield(:)

!Use deep_copy to copy all the pointers that are associated.
!
!*******************************************************************
!*** CAVEAT: Remember to nullify the pointers in dtsetnullify    ***
!*** as F90 does not specify the initial status of the pointers! ***
!*******************************************************************

!integer pointers
 call deep_copy( dtin%algalch, dtout%algalch)

 call deep_copy( dtin%bdgw, dtout%bdgw)

 call deep_copy( dtin%dynimage, dtout%dynimage)

 call deep_copy( dtin%iatfix, dtout%iatfix)

 call deep_copy( dtin%iatsph, dtout%iatsph)

 call deep_copy( dtin%istwfk, dtout%istwfk)

 call deep_copy( dtin%kberry, dtout%kberry)

 call deep_copy( dtin%lexexch, dtout%lexexch)

 call deep_copy( dtin%lpawu, dtout%lpawu)

 call deep_copy( dtin%nband, dtout%nband)

 call deep_copy( dtin%prtatlist, dtout%prtatlist)

 call deep_copy( dtin%so_psp, dtout%so_psp)

 call deep_copy( dtin%symafm, dtout%symafm)

 call deep_copy( dtin%symrel, dtout%symrel)

 call deep_copy( dtin%typat, dtout%typat)

!Allocate and copy real pointers
 call deep_copy( dtin%acell_orig, dtout%acell_orig)

 call deep_copy( dtin%amu_orig, dtout%amu_orig)

 call deep_copy( dtin%atvshift, dtout%atvshift)

 call deep_copy( dtin%cd_imfrqs, dtout%cd_imfrqs)

 call deep_copy( dtin%corecs, dtout%corecs)

 call deep_copy( dtin%densty, dtout%densty)

 call deep_copy( dtin%dmatpawu, dtout%dmatpawu)

 call deep_copy( dtin%f4of2_sla, dtout%f4of2_sla)

 call deep_copy( dtin%f6of2_sla, dtout%f6of2_sla)

 call deep_copy( dtin%gw_qlwl, dtout%gw_qlwl)

 call deep_copy( dtin%gw_freqsp, dtout%gw_freqsp)

 call deep_copy( dtin%jpawu, dtout%jpawu)

 call deep_copy( dtin%kpt, dtout%kpt)

 call deep_copy( dtin%kptgw, dtout%kptgw)

 call deep_copy( dtin%kptns, dtout%kptns)

 call deep_copy( dtin%mixalch_orig, dtout%mixalch_orig)

 call deep_copy( dtin%occ_orig, dtout%occ_orig)

 call deep_copy( dtin%pimass, dtout%pimass)

 call deep_copy( dtin%ptcharge, dtout%ptcharge)

 call deep_copy( dtin%qmass, dtout%qmass)

 call deep_copy( dtin%qptdm, dtout%qptdm)

 call deep_copy( dtin%quadmom, dtout%quadmom)

 call deep_copy( dtin%ratsph, dtout%ratsph)

 call deep_copy( dtin%rprim_orig, dtout%rprim_orig)

 call deep_copy( dtin%rprimd_orig, dtout%rprimd_orig)

 call deep_copy( dtin%shiftk, dtout%shiftk)

 call deep_copy( dtin%spinat, dtout%spinat)

 call deep_copy( dtin%tnons, dtout%tnons)

 call deep_copy( dtin%upawu, dtout%upawu)

 call deep_copy( dtin%vel_orig, dtout%vel_orig)

 call deep_copy( dtin%vel_cell_orig, dtout%vel_cell_orig)

 call deep_copy( dtin%wtatcon, dtout%wtatcon)

 call deep_copy( dtin%wtk, dtout%wtk)

 call deep_copy( dtin%xred_orig, dtout%xred_orig)

 call deep_copy( dtin%ziontypat, dtout%ziontypat)

 call deep_copy( dtin%znucl, dtout%znucl)

 DBG_EXIT("COLL")

end subroutine dtset_copy
!!***

!----------------------------------------------------------------------

!!****f* m_dtset/dtset_free
!! NAME
!! dtset_free
!!
!! FUNCTION
!! Free a dataset after use.
!!
!! SIDE EFFECTS
!!  dtset <type(dataset_type)>=free all associated pointers.
!!
!! PARENTS
!!      afterscfloop,calc_vhxc_me,chkinp,driver,kxc_alda,m_ab6_invars_f90
!!      m_io_kss,xc_kernel,xc_kernel_ADA
!!
!! CHILDREN
!!
!! SOURCE

subroutine dtset_free(dtset)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'dtset_free'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(dataset_type),intent(inout) :: dtset

! *************************************************************************

!please, use the same order as the one used in the declaration of the type (see defs_abitypes).

 !@dataset_type
!integer pointers
 if (associated(dtset%algalch))     then
   ABI_DEALLOCATE(dtset%algalch)
 end if
 if (associated(dtset%bdgw))        then
   ABI_DEALLOCATE(dtset%bdgw)
 end if
 if (associated(dtset%dynimage))    then
   ABI_DEALLOCATE(dtset%dynimage)
 end if
 if (associated(dtset%iatfix))      then
   ABI_DEALLOCATE(dtset%iatfix)
 end if
 if (associated(dtset%iatsph))      then
   ABI_DEALLOCATE(dtset%iatsph)
 end if
 if (associated(dtset%istwfk))      then
   ABI_DEALLOCATE(dtset%istwfk)
 end if
 if (associated(dtset%kberry))      then
   ABI_DEALLOCATE(dtset%kberry)
 end if
 if (associated(dtset%lexexch))     then
   ABI_DEALLOCATE(dtset%lexexch)
 end if
 if (associated(dtset%lpawu))       then
   ABI_DEALLOCATE(dtset%lpawu)
 end if
 if (associated(dtset%nband))       then
   ABI_DEALLOCATE(dtset%nband)
 end if
 if (associated(dtset%prtatlist))   then
   ABI_DEALLOCATE(dtset%prtatlist)
 end if
 if (associated(dtset%so_psp))      then
   ABI_DEALLOCATE(dtset%so_psp)
 end if
 if (associated(dtset%symafm))      then
   ABI_DEALLOCATE(dtset%symafm)
 end if
 if (associated(dtset%symrel))      then
   ABI_DEALLOCATE(dtset%symrel)
 end if
 if (associated(dtset%typat))       then
   ABI_DEALLOCATE(dtset%typat)
 end if

!real pointers
 if (associated(dtset%acell_orig))  then
   ABI_DEALLOCATE(dtset%acell_orig)
 end if
 if (associated(dtset%amu_orig))    then
   ABI_DEALLOCATE(dtset%amu_orig)
 end if
 if (associated(dtset%atvshift))    then
   ABI_DEALLOCATE(dtset%atvshift)
 end if
 if (associated(dtset%cd_imfrqs))   then
   ABI_DEALLOCATE(dtset%cd_imfrqs)
 end if
 if (associated(dtset%corecs))      then
   ABI_DEALLOCATE(dtset%corecs)
 end if
 if (associated(dtset%densty))      then
   ABI_DEALLOCATE(dtset%densty)
 end if
 if (associated(dtset%dmatpawu))    then
   ABI_DEALLOCATE(dtset%dmatpawu)
 end if
 if (associated(dtset%gw_qlwl))     then
   ABI_DEALLOCATE(dtset%gw_qlwl)
 end if
 if (associated(dtset%gw_freqsp))   then
   ABI_DEALLOCATE(dtset%gw_freqsp)
 end if
 if (associated(dtset%f4of2_sla))   then
   ABI_DEALLOCATE(dtset%f4of2_sla)
 end if
 if (associated(dtset%f6of2_sla))   then
   ABI_DEALLOCATE(dtset%f6of2_sla)
 end if
 if (associated(dtset%jpawu))       then
   ABI_DEALLOCATE(dtset%jpawu)
 end if
 if (associated(dtset%kpt))         then
   ABI_DEALLOCATE(dtset%kpt)
 end if
 if (associated(dtset%kptgw))       then
   ABI_DEALLOCATE(dtset%kptgw)
 end if
 if (associated(dtset%kptns))       then
   ABI_DEALLOCATE(dtset%kptns)
 end if
 if (associated(dtset%mixalch_orig))     then
   ABI_DEALLOCATE(dtset%mixalch_orig)
 end if
 if (associated(dtset%occ_orig))    then
   ABI_DEALLOCATE(dtset%occ_orig)
 end if
 if (associated(dtset%pimass))      then
   ABI_DEALLOCATE(dtset%pimass)
 end if
 if (associated(dtset%ptcharge))    then
   ABI_DEALLOCATE(dtset%ptcharge)
 end if
 if (associated(dtset%qmass))       then
   ABI_DEALLOCATE(dtset%qmass)
 end if
 if (associated(dtset%qptdm))       then
   ABI_DEALLOCATE(dtset%qptdm)
 end if
 if (associated(dtset%quadmom))     then
   ABI_DEALLOCATE(dtset%quadmom)
 end if
 if (associated(dtset%ratsph))      then
   ABI_DEALLOCATE(dtset%ratsph)
 end if
 if (associated(dtset%rprim_orig))  then
   ABI_DEALLOCATE(dtset%rprim_orig)
 end if
 if (associated(dtset%rprimd_orig)) then
   ABI_DEALLOCATE(dtset%rprimd_orig)
 end if
 if (associated(dtset%shiftk))      then
   ABI_DEALLOCATE(dtset%shiftk)
 end if
 if (associated(dtset%spinat))      then
   ABI_DEALLOCATE(dtset%spinat)
 end if
 if (associated(dtset%tnons))       then
   ABI_DEALLOCATE(dtset%tnons)
 end if
 if (associated(dtset%upawu))       then
   ABI_DEALLOCATE(dtset%upawu)
 end if
 if (associated(dtset%vel_orig))    then
   ABI_DEALLOCATE(dtset%vel_orig)
 end if
 if (associated(dtset%vel_cell_orig))    then
   ABI_DEALLOCATE(dtset%vel_cell_orig)
 end if
 if (associated(dtset%wtatcon))     then
   ABI_DEALLOCATE(dtset%wtatcon)
 end if
 if (associated(dtset%wtk))         then
   ABI_DEALLOCATE(dtset%wtk)
 end if
 if (associated(dtset%xred_orig))   then
   ABI_DEALLOCATE(dtset%xred_orig)
 end if
 if (associated(dtset%ziontypat))   then
   ABI_DEALLOCATE(dtset%ziontypat)
 end if
 if (associated(dtset%znucl))       then
   ABI_DEALLOCATE(dtset%znucl)
 end if

end subroutine dtset_free
!!***

END MODULE m_dtset
!!***
