#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"
!!***

!!****f* ABINIT/init_mpi_enreg
!! NAME
!! init_mpi_enreg
!!
!! FUNCTION
!!  Initialise a mpi_enreg structure with dataset independent values.
!!  Other values of mpi_enreg are dataset dependent, and should NOT be initialized
!!  inside abinit.F90 .
!!  XG 071118 : At present several other values are
!!  initialized temporarily inside invars1.F90, FROM THE DTSET
!!  VALUES. In order to releave the present constraint of having mpi_enreg
!!  equal for all datasets, they should be reinitialized from the dtset values
!!  inside invars2m.F90 (where there is a loop over datasets, and finally,
!!  reinitialized from the dataset values inside each big routine called by driver,
!!  according to the kind of parallelisation that is needed there.
!!  One should have one init_mpi_dtset routine (or another name) per big routine (well, there is also
!!  the problem of TDDFT ...). Also, one should have a clean_mpi_dtset called at the end
!!  of each big routine, as well as invars1.F90 or invars2m.F90 .
!!
!! INPUTS
!!
!! SIDE EFFECTS
!!  MPI_enreg<MPI_type>=All pointer set to null().
!!
!! PARENTS
!!      lapackprof,mpi_setup
!!
!! CHILDREN
!!
!! SOURCE
subroutine init_mpi_enreg(mpi_enreg)

 use m_profiling

 use defs_basis
 use defs_abitypes
 use m_xmpi
 use m_errors
#if defined HAVE_MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'init_mpi_enreg'
 use interfaces_51_manage_mpi, except_this_one => init_mpi_enreg
!End of the abilint section

 implicit none
#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
!scalars
 type(MPI_type),intent(inout) :: MPI_enreg

!Local variables-------------------------------
#if defined HAVE_MPI
 integer :: ierr
#endif
#if defined HAVE_MPI_IO
 character(len=500) :: message
#endif

! *********************************************************************

!Default for sequential use
 call nullify_mpi_enreg(mpi_enreg)

 call initmpi_seq(mpi_enreg)

!MG080916 If we want to avoid MPI preprocessing options, %proc_distr should be always allocated and
!set to mpi_enreg%me. In such a way we can safely test its value inside loops parallelized over k-points
!For the time being, do not remove this line since it is needed in outkss.F90.
!nullify(mpi_enreg%proc_distrb)
!nullify(mpi_enreg%bandfft_kpt,mpi_enreg%my_kpttab)

!Initialize MPI
#if defined HAVE_MPI
 mpi_enreg%comm_world=xmpi_world
 call MPI_COMM_RANK(xmpi_world,mpi_enreg%me,ierr)
 call MPI_COMM_SIZE(xmpi_world,mpi_enreg%nproc,ierr)
#endif

!Signal MPI I/O compilation has been activated
#if defined HAVE_MPI_IO
 if(xmpi_paral==0)then
   write(message,'(3a)')&
&   '  In order to use MPI_IO, you must compile with the MPI flag ',ch10,&
&   '  Action : recompile your code with different CPP flags.'
   MSG_ERROR(message)
 end if
!Test the opening, writing, closing and deleting of a test file
!call MPI_FILE_OPEN(xmpi_world,"Testfile",MPI_MODE_WRONLY+MPI_MODE_CREATE,MPI_INFO_NULL,fh,ierr)
!call print_ierr(ierr,"abinit","MPI_FILE_OPEN")
!Write 1 integer per proc
!data=mpi_enreg%me;offset=4*mpi_enreg%me
!call MPI_FILE_WRITE_AT(fh,offset,data,1,MPI_INTEGER,mpi_status,ierr)
!call print_ierr(ierr,"abinit","MPI_FILE_WRITE_AT")
!Close file
!call MPI_FILE_CLOSE(fh,ierr)
!call print_ierr(ierr,"abinit","MPI_FILE_CLOSE")
!Delete file
!call MPI_FILE_DELETE(fh,MPI_INFO_NULL,ierr)
!call print_ierr(ierr,"abinit","MPI_FILE_DELETE")
#endif


 
end subroutine init_mpi_enreg
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/nullify_mpi_enreg
!! NAME
!! nullify_mpi_enreg
!!
!! FUNCTION
!!  nullify a mpi_enreg datastructure
!!
!! SIDE EFFECTS
!!  MPI_enreg<MPI_type>=All pointer set to null().
!!
!! PARENTS
!!      fftprof,initmpi_seq,kss2wfk,m_fft_prof,m_wfs,mpi_enreg_tools
!!
!! CHILDREN
!!
!! SOURCE

subroutine nullify_mpi_enreg(MPI_enreg)

 use m_profiling

 use defs_basis
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'nullify_mpi_enreg'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(MPI_type),intent(inout) :: MPI_enreg

! *********************************************************************

 nullify(mpi_enreg%proc_distrb)
 nullify(mpi_enreg%kptdstrb)
 nullify(mpi_enreg%kpt_loc2fbz_sp)
 nullify(mpi_enreg%kpt_loc2ibz_sp)
 nullify(mpi_enreg%mkmem)
 nullify(mpi_enreg%nscatterarr)
 nullify(mpi_enreg%ngatherarr)
 nullify(mpi_enreg%my_kpttab)
 nullify(mpi_enreg%my_atmtab)
 nullify(mpi_enreg%distrb_pert)
 nullify(mpi_enreg%distrb_img)
 nullify(mpi_enreg%my_imgtab)
 nullify(mpi_enreg%my_kgtab)

 end subroutine nullify_mpi_enreg
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/destroy_mpi_enreg
!! NAME
!! destroy_mpi_enreg
!!
!! FUNCTION
!!  Destroy a mpi_enreg datastructure
!!
!! COPYRIGHT
!!  Copyright (C) 2009-2012 ABINIT group (MT)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SIDE EFFECTS
!!  MPI_enreg<MPI_type>=Datatype gathering information on the parallelism.
!!
!! PARENTS
!!      abinit,anaddb,cut3d,fftprof,inwffil,kss2wfk,lapackprof,lwf,m_fft_prof
!!      m_wfs,mrgddb,mrggkk,mrgscr,ujdet
!!
!! CHILDREN
!!
!! SOURCE

subroutine destroy_mpi_enreg(MPI_enreg)

 use m_profiling

 use defs_basis
 use defs_abitypes
 use m_xmpi,only : xgroup_free

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'destroy_mpi_enreg'
 use interfaces_51_manage_mpi, except_this_one => destroy_mpi_enreg
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(MPI_type),intent(inout) :: MPI_enreg

!Local variables-------------------------------

! *********************************************************************


 if (associated(mpi_enreg%proc_distrb)) then
   ABI_DEALLOCATE(mpi_enreg%proc_distrb)
   nullify(mpi_enreg%proc_distrb)
 end if
 if (associated(mpi_enreg%kptdstrb)) then
   ABI_DEALLOCATE(mpi_enreg%kptdstrb)
   nullify(mpi_enreg%kptdstrb)
 end if
 if (associated(mpi_enreg%kpt_loc2fbz_sp)) then
   ABI_DEALLOCATE(mpi_enreg%kpt_loc2fbz_sp)
   nullify(mpi_enreg%kpt_loc2fbz_sp)
 end if
 if (associated(mpi_enreg%kpt_loc2ibz_sp)) then
   ABI_DEALLOCATE(mpi_enreg%kpt_loc2ibz_sp)
   nullify(mpi_enreg%kpt_loc2ibz_sp)
 end if
 if (associated(mpi_enreg%mkmem)) then
   ABI_DEALLOCATE(mpi_enreg%mkmem)
   nullify(mpi_enreg%mkmem)
 end if
 if (associated(mpi_enreg%my_kpttab)) then
   ABI_DEALLOCATE(mpi_enreg%my_kpttab)
   nullify(mpi_enreg%my_kpttab)
 end if
 if (associated(mpi_enreg%my_atmtab)) then
   ABI_DEALLOCATE(mpi_enreg%my_atmtab)
   nullify(mpi_enreg%my_atmtab)
 end if
 if (associated(mpi_enreg%distrb_pert)) then
   ABI_DEALLOCATE(mpi_enreg%distrb_pert)
   nullify(mpi_enreg%distrb_pert)
 end if
 if (associated(mpi_enreg%distrb_img)) then
   ABI_DEALLOCATE(mpi_enreg%distrb_img)
   nullify(mpi_enreg%distrb_img)
 end if
 if (associated(mpi_enreg%my_imgtab)) then
   ABI_DEALLOCATE(mpi_enreg%my_imgtab)
   nullify(mpi_enreg%my_imgtab)
 end if
 if (associated(mpi_enreg%my_kgtab)) then
   ABI_DEALLOCATE(mpi_enreg%my_kgtab)
   nullify(mpi_enreg%my_kgtab)
 end if
 
!Do not deallocate wavelet denspot distribution arrays,
!they are handled by BigDFT.

 call initmpi_seq(mpi_enreg)

end subroutine destroy_mpi_enreg
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/copy_mpi_enreg
!! NAME
!! copy_mpi_enreg
!!
!! FUNCTION
!!  Copy a mpi_enreg datastructure into another
!!
!! INPUTS
!!  opt_bandfft=if 1, the bandfft_kpt field has to be copied
!!              else, it is ignored
!!  MPI_enreg1<MPI_type>=input mpi_enreg datastructure
!!
!! OUTPUT
!!  MPI_enreg2<MPI_type>=output mpi_enreg datastructure
!!
!! PARENTS
!!      inwffil,m_fft_prof,m_wfs
!!
!! CHILDREN
!!
!! SOURCE

subroutine copy_mpi_enreg(MPI_enreg1,MPI_enreg2,opt_bandfft)

 use m_profiling

 use defs_basis
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'copy_mpi_enreg'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer :: opt_bandfft
 type(MPI_type),intent(inout) :: mpi_enreg1,MPI_enreg2

!Local variables-------------------------------

! *********************************************************************

!scalars
 mpi_enreg2%comm_world=mpi_enreg1%comm_world
 mpi_enreg2%me=mpi_enreg1%me
 mpi_enreg2%nproc=mpi_enreg1%nproc
 mpi_enreg2%paral_spinor=mpi_enreg1%paral_spinor
 mpi_enreg2%paralbd=mpi_enreg1%paralbd
 mpi_enreg2%me_fft=mpi_enreg1%me_fft
 mpi_enreg2%me_band=mpi_enreg1%me_band
 mpi_enreg2%nproc_fft=mpi_enreg1%nproc_fft
 mpi_enreg2%paral_kgb=mpi_enreg1%paral_kgb
 mpi_enreg2%me_g0=mpi_enreg1%me_g0
!mpi_enreg2%flag_ind_kg_mpi_to_seq=mpi_enreg1%flag_ind_kg_mpi_to_seq
 mpi_enreg2%paral_pert=mpi_enreg1%paral_pert
 mpi_enreg2%me_pert=mpi_enreg1%me_pert
 mpi_enreg2%nproc_pert=mpi_enreg1%nproc_pert
 mpi_enreg2%comm_pert=mpi_enreg1%comm_pert
 mpi_enreg2%comm_bandfft=mpi_enreg1%comm_bandfft
 mpi_enreg2%comm_band=mpi_enreg1%comm_band
 mpi_enreg2%comm_fft=mpi_enreg1%comm_fft
 mpi_enreg2%nproc_band=mpi_enreg1%nproc_band
 mpi_enreg2%comm_bandspinorfft=mpi_enreg1%comm_bandspinorfft
 mpi_enreg2%comm_kpt=mpi_enreg1%comm_kpt
 mpi_enreg2%me_kpt=mpi_enreg1%me_kpt
 mpi_enreg2%nproc_kpt=mpi_enreg1%nproc_kpt
 mpi_enreg2%my_natom=mpi_enreg1%my_natom
 mpi_enreg2%comm_atom=mpi_enreg1%comm_atom
 mpi_enreg2%nproc_atom=mpi_enreg1%nproc_atom
 mpi_enreg2%comm_kptband=mpi_enreg1%comm_kptband
 mpi_enreg2%bandpp=mpi_enreg1%bandpp
 mpi_enreg2%paral_img=mpi_enreg1%paral_img
 mpi_enreg2%comm_img=mpi_enreg1%comm_img
 mpi_enreg2%me_img=mpi_enreg1%me_img
 mpi_enreg2%nproc_img=mpi_enreg1%nproc_img
 mpi_enreg2%comm_cell=mpi_enreg1%comm_cell
 mpi_enreg2%comm_cell_pert=mpi_enreg1%comm_cell_pert
 mpi_enreg2%me_cell=mpi_enreg1%me_cell
 mpi_enreg2%nproc_cell=mpi_enreg1%nproc_cell
 mpi_enreg2%nproc_spinor=mpi_enreg1%nproc_spinor
 mpi_enreg2%me_spinor=mpi_enreg1%me_spinor
 mpi_enreg2%comm_spinorfft=mpi_enreg1%comm_spinorfft
 mpi_enreg2%usewvl=mpi_enreg1%usewvl

!pointers
 if (associated(mpi_enreg1%proc_distrb)) then
   sz1=size(mpi_enreg1%proc_distrb,1)
   sz2=size(mpi_enreg1%proc_distrb,2)
   sz3=size(mpi_enreg1%proc_distrb,3)
   ABI_ALLOCATE(mpi_enreg2%proc_distrb,(sz1,sz2,sz3))
   mpi_enreg2%proc_distrb=mpi_enreg1%proc_distrb
 else
   nullify(mpi_enreg2%proc_distrb)
 end if
 if (associated(mpi_enreg1%kptdstrb)) then
   sz1=size(mpi_enreg1%kptdstrb,1)
   sz2=size(mpi_enreg1%kptdstrb,2)
   sz3=size(mpi_enreg1%kptdstrb,3)
   ABI_ALLOCATE(mpi_enreg2%kptdstrb,(sz1,sz2,sz3))
   mpi_enreg2%kptdstrb=mpi_enreg1%kptdstrb
 else
   nullify(mpi_enreg2%kptdstrb)
 end if
 if (associated(mpi_enreg1%kpt_loc2fbz_sp)) then
   sz1=size(mpi_enreg1%kpt_loc2fbz_sp,1)-1
   sz2=size(mpi_enreg1%kpt_loc2fbz_sp,2)
   sz3=size(mpi_enreg1%kpt_loc2fbz_sp,3)
   ABI_ALLOCATE(mpi_enreg2%kpt_loc2fbz_sp,(0:sz1,1:sz2,1:sz3))
   mpi_enreg2%kpt_loc2fbz_sp=mpi_enreg1%kpt_loc2fbz_sp
 else
   nullify(mpi_enreg2%kpt_loc2fbz_sp)
 end if
 if (associated(mpi_enreg1%kpt_loc2ibz_sp)) then
   sz1=size(mpi_enreg1%kpt_loc2ibz_sp,1)-1
   sz2=size(mpi_enreg1%kpt_loc2ibz_sp,2)
   sz3=size(mpi_enreg1%kpt_loc2ibz_sp,3)
   ABI_ALLOCATE(mpi_enreg2%kpt_loc2ibz_sp,(0:sz1,1:sz2,1:sz3))
   mpi_enreg2%kpt_loc2ibz_sp=mpi_enreg1%kpt_loc2ibz_sp
 else
   nullify(mpi_enreg2%kpt_loc2ibz_sp)
 end if
 if (associated(mpi_enreg1%mkmem)) then
   ABI_ALLOCATE(mpi_enreg2%mkmem,(0:size(mpi_enreg1%mkmem,1)-1))
   mpi_enreg2%mkmem=mpi_enreg1%mkmem
 else
   nullify(mpi_enreg2%mkmem)
 end if
 if (associated(mpi_enreg1%my_atmtab)) then
   ABI_ALLOCATE(mpi_enreg2%my_atmtab,(size(mpi_enreg1%my_atmtab)))
   mpi_enreg2%my_atmtab=mpi_enreg1%my_atmtab
 else
   nullify(mpi_enreg2%my_atmtab)
 end if
 if (associated(mpi_enreg1%my_kgtab)) then
   sz1=size(mpi_enreg1%my_kgtab,1)
   sz2=size(mpi_enreg1%my_kgtab,2)
   ABI_ALLOCATE(mpi_enreg2%my_kgtab,(sz1,sz2))
   mpi_enreg2%my_kgtab=mpi_enreg1%my_kgtab
 else
   nullify(mpi_enreg2%my_kgtab)
 end if
 if (associated(mpi_enreg1%distrb_pert)) then
   ABI_ALLOCATE(mpi_enreg2%distrb_pert,(size(mpi_enreg1%distrb_pert)))
   mpi_enreg2%distrb_pert=mpi_enreg1%distrb_pert
 else
   nullify(mpi_enreg2%distrb_pert)
 end if
 if (associated(mpi_enreg1%distrb_img)) then
   ABI_ALLOCATE(mpi_enreg2%distrb_img,(size(mpi_enreg1%distrb_img)))
   mpi_enreg2%distrb_img=mpi_enreg1%distrb_img
 else
   nullify(mpi_enreg2%distrb_img)
 end if
 if (associated(mpi_enreg1%my_imgtab)) then
   ABI_ALLOCATE(mpi_enreg2%my_imgtab,(size(mpi_enreg1%my_imgtab)))
   mpi_enreg2%my_imgtab=mpi_enreg1%my_imgtab
 else
   nullify(mpi_enreg2%my_imgtab)
 end if

!Optional pointers
 if (opt_bandfft==0) then
   nullify(mpi_enreg2%my_kpttab)
 else if (opt_bandfft==1) then
   if (associated(mpi_enreg1%my_kpttab)) then
     ABI_ALLOCATE(mpi_enreg2%my_kpttab,(size(mpi_enreg1%my_kpttab)))
     mpi_enreg2%my_kpttab=mpi_enreg1%my_kpttab
   end if

 end if

!Do not copy wavelet pointers, just associate.
 mpi_enreg2%nscatterarr => mpi_enreg1%nscatterarr
 mpi_enreg2%ngatherarr => mpi_enreg1%ngatherarr

end subroutine copy_mpi_enreg
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/set_mpi_enreg_fft
!! NAME
!! set_mpi_enreg_fft
!!
!! FUNCTION
!!  Set the content of a MPI datastructure in order to call fourwf/fourdp
!!  (in view of a wrapper for these routines)
!!
!! INPUTS
!!  me_g0=1 if the current process treat the g=0 plane-wave
!!  comm_fft= MPI communicator over FFT components
!!  paral_kgb= flag used to activate "band-FFT" parallelism
!!
!! SIDE EFFECTS
!!  MPI_enreg<MPI_type>=FFT pointer/flags intialized
!!
!! PARENTS
!!      atm2fft,atm2fft3,pawmknhat,pawmknhat_psipsi,pawsushat
!!
!! CHILDREN
!!
!! SOURCE

subroutine set_mpi_enreg_fft(MPI_enreg,comm_fft,me_g0,paral_kgb)

 use m_profiling
 use defs_basis
 use defs_abitypes
 use m_xmpi

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'set_mpi_enreg_fft'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: me_g0,comm_fft,paral_kgb
 type(MPI_type),intent(inout) :: MPI_enreg

! *********************************************************************

 mpi_enreg%me_g0=me_g0
 mpi_enreg%comm_fft=comm_fft
 mpi_enreg%nproc_fft=xcomm_size(comm_fft)
 mpi_enreg%me_fft=xcomm_rank(comm_fft)

 if (paral_kgb==1) then
   mpi_enreg%paral_kgb=1
 else
   mpi_enreg%paral_kgb=0
 end if

end subroutine set_mpi_enreg_fft
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/unset_mpi_enreg_fft
!! NAME
!! unset_mpi_enreg_fft
!!
!! FUNCTION
!!  Unset the content of a MPI datastructure used to call fourwf/fourdp
!!  (in view of a wrapper for these routines)
!!
!! INPUTS
!!
!! SIDE EFFECTS
!!  MPI_enreg<MPI_type>=FFT pointer/flags intialized
!!
!! PARENTS
!!      atm2fft,atm2fft3,pawmknhat,pawmknhat_psipsi,pawsushat
!!
!! CHILDREN
!!
!! SOURCE

subroutine unset_mpi_enreg_fft(MPI_enreg)

 use m_profiling
 use defs_basis
 use defs_abitypes
 use m_xmpi

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'unset_mpi_enreg_fft'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(MPI_type),intent(inout) :: MPI_enreg

! *********************************************************************

 mpi_enreg%me_g0=1
 mpi_enreg%comm_fft=xmpi_self
 mpi_enreg%nproc_fft=1
 mpi_enreg%me_fft=0
 mpi_enreg%paral_kgb=0

end subroutine unset_mpi_enreg_fft
!!***

!----------------------------------------------------------------------

!!****f* ABINIT/my_indeces
!! NAME
!! my_indeces
!!
!! FUNCTION
!!  Helper function returning useful local indeces from the global indeces (ikpt,isppol).
!!  It works only in the case of k-point parallelism or sequential run.
!!
!! INPUTS
!!  MPI_enreg<MPI_type>=Datatype gathering information on the parallelism.
!!  ikpt=The global index of the k-point.
!!  isppol=The global index for the spin.
!!  nkpt=The total number of k-points (global)
!!  nsppol=The total number of spins (global)
!!  nspinor=The number of spinorial components (on current proc)
!!  npwarr(nkpt)=Global array storing the number of planewaves at each k-point.
!!  nband(nkpt*nsppol)=Global array stoting the number of bands treated at each k-point and spin.
!!
!! OUTPUT
!!  kindex= kindex+1 is the local index in the cg array defining the beginning of the block
!!  of the wavefunctions with (ikpt,isppol) indeces
!!  bdtot_index
!!  ibg=Local index
!!  ikg= ikg+1 is the local index in the array kg_k
!!  ierr=Status error.
!!    == 0  => This processor has this (k,s)
!!    /= 0  => This node is not treating this (k,s). (kindex,ibg,ikg) are set to HUGE(0)
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine my_indeces(MPI_enreg,ikpt,isppol,nkpt,nsppol,nspinor,npwarr,nband,kindex,bdtot_index,ibg,ikg,ierr)

 use m_profiling

 use defs_basis
 use defs_abitypes
 use m_errors
 use m_xmpi

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'my_indeces'
 use interfaces_32_util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ikpt,isppol,nkpt,nsppol,nspinor
 integer,intent(out) :: kindex,ibg,ikg,bdtot_index
 type(MPI_type),intent(in) :: MPI_enreg
!arrays
 integer,intent(in) :: nband(nkpt*nsppol),npwarr(nkpt)
 integer,intent(out) :: ierr


!Local variables-------------------------------
!scalars
 integer :: iktot,isp,my_rank,nband_k,nprocs,npw_k
!arrays

! *********************************************************************
 if (xmpi_paral/=1) then
   MSG_ERROR(" xmpi_paral/=1")
 end if

 if (MPI_enreg%paral_img==1) then
   nprocs  = MPI_enreg%nproc_cell
   my_rank = MPI_enreg%me_cell
 else
   nprocs  = MPI_enreg%nproc
   my_rank = MPI_enreg%me
 end if

 ierr=1
 if (nprocs==1) then ! Calculate local indeces, cannot use %proc_distrb as it is not allocated.

   kindex=0; bdtot_index=0; ibg=0
   isp_loop1: do isp=1,nsppol
     ikg=0
     do iktot=1,nkpt
       if (iktot==ikpt.and.isp==isppol) then
         EXIT isp_loop1
         ierr=0
       end if
       nband_k = nband(iktot+(isp-1)*nkpt)
       npw_k   = npwarr(iktot)

       kindex  = kindex + npw_k*nspinor*nband_k
       bdtot_index=bdtot_index+nband_k
       ibg     = ibg + nspinor*nband_k
       ikg     = ikg+npw_k
     end do
   end do isp_loop1

 else ! parallel case: calculate local indeces.

   kindex=0; bdtot_index=0; ibg=0
   isp_loop2: do isp=1,nsppol
     ikg=0
     do iktot=1,nkpt
       nband_k = nband(iktot+(isp-1)*nkpt)
       if (.not.(proc_distrb_cycle(mpi_enreg%proc_distrb,iktot,1,nband_k,isp,my_rank))) then
!        if (MINVAL(ABS(MPI_enreg%proc_distrb(iktot,:,isp)-my_rank))==0) then  ! FIXME this cannot be tested in seq.
         if (iktot==ikpt.and.isp==isppol) then
           ierr=0
           EXIT isp_loop2
         end if
!        nband_k = nband(iktot+(isp-1)*nkpt)
         npw_k   = npwarr(iktot)

         kindex  = kindex + npw_k*nspinor*nband_k
         bdtot_index=bdtot_index+nband_k
         ibg     = ibg + nspinor*nband_k
         ikg     = ikg+npw_k
       end if
     end do
   end do isp_loop2
 end if

 if (ierr/=0) then ! This will lead to a SIGFAULT if the indeces are used in the caller.
   kindex = HUGE(0)
   bdtot_index = HUGE(0)
   ibg    = HUGE(0)
   ikg    = HUGE(0)
 end if

end subroutine my_indeces
!!***
