!!****m* ABINIT/interfaces_51_manage_mpi
!! NAME
!! interfaces_51_manage_mpi
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/51_manage_mpi
!!
!! COPYRIGHT
!! Copyright (C) 2010-2011 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: config/scripts/abilint . .
!!
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module interfaces_51_manage_mpi

 implicit none

interface
 subroutine clnmpi_atom(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_atom
end interface

interface
 subroutine clnmpi_grid(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_grid
end interface

interface
 subroutine clnmpi_img(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_img
end interface

interface
 subroutine clnmpi_pert(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine clnmpi_pert
end interface

interface
 subroutine distrb2(mband,nband, nkpt,nproc, nsppol, mpi_enreg)
  use defs_abitypes
  implicit none
  integer,intent(in) :: mband
  integer,intent(in) :: nkpt
  integer,intent(in) :: nproc
  integer,intent(in) :: nsppol
  type(mpi_type),intent(inout) :: mpi_enreg
  integer,intent(in) :: nband(nkpt*nsppol)
 end subroutine distrb2
end interface

interface
 subroutine get_npert_rbz(dtset,nband_rbz,nkpt_rbz,npert)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(out) :: npert
  type(dataset_type),intent(inout) :: dtset
  integer,pointer :: nkpt_rbz(:)
  real(dp),pointer :: nband_rbz(:,:)
 end subroutine get_npert_rbz
end interface

interface
 subroutine herald(code_name,code_version,iout)
  implicit none
  integer,intent(in) :: iout
  character(len=*),intent(in) :: code_name
  character(len=*),intent(in) :: code_version
 end subroutine herald
end interface

interface
 subroutine initmpi_atom(dtset,mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(in) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_atom
end interface

interface
 subroutine initmpi_band(mpi_enreg,nband,nkpt,nsppol)
  use defs_abitypes
  implicit none
  integer,intent(in) :: nkpt
  integer,intent(in) :: nsppol
  type(mpi_type),intent(inout) :: mpi_enreg
  integer,intent(in) :: nband(nkpt*nsppol)
 end subroutine initmpi_band
end interface

interface
 subroutine initmpi_grid(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_grid
end interface

interface
 subroutine initmpi_img(dtset,mpi_enreg,option)
  use defs_abitypes
  implicit none
  integer,intent(in) :: option
  type(dataset_type),intent(in) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_img
end interface

interface
 subroutine initmpi_pert(dtset,mpi_enreg,tread)
  use defs_abitypes
  implicit none
  integer,intent(in) :: tread
  type(dataset_type),intent(inout) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_pert
end interface

interface
 subroutine initmpi_seq(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(out) :: mpi_enreg
 end subroutine initmpi_seq
end interface

interface
 subroutine initmpi_world(mpi_enreg,nproc)
  use defs_abitypes
  implicit none
  integer, intent(in) :: nproc
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_world
end interface

interface
 subroutine leave_test()
  implicit none
 end subroutine leave_test
end interface

interface
 subroutine init_mpi_enreg(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: MPI_enreg
 end subroutine init_mpi_enreg
end interface

interface
 subroutine nullify_mpi_enreg(MPI_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: MPI_enreg
 end subroutine nullify_mpi_enreg
end interface

interface
 subroutine destroy_mpi_enreg(MPI_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: MPI_enreg
 end subroutine destroy_mpi_enreg
end interface

interface
 subroutine copy_mpi_enreg(MPI_enreg1,MPI_enreg2,opt_bandfft)
  use defs_abitypes
  implicit none
  integer :: opt_bandfft
  type(mpi_type),intent(inout) :: MPI_enreg2
  type(mpi_type),intent(inout) :: mpi_enreg1
 end subroutine copy_mpi_enreg
end interface

interface
 subroutine set_mpi_enreg_fft(MPI_enreg,comm_fft,me_g0,paral_kgb)
  use defs_abitypes
  implicit none
  integer,intent(in) :: comm_fft
  integer,intent(in) :: me_g0
  integer,intent(in) :: paral_kgb
  type(mpi_type),intent(inout) :: MPI_enreg
 end subroutine set_mpi_enreg_fft
end interface

interface
 subroutine unset_mpi_enreg_fft(MPI_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(inout) :: MPI_enreg
 end subroutine unset_mpi_enreg_fft
end interface

interface
 subroutine my_indeces(MPI_enreg,ikpt,isppol,nkpt,nsppol,nspinor,npwarr,nband,kindex,bdtot_index,ibg,ikg,ierr)
  use defs_abitypes
  implicit none
  integer,intent(out) :: bdtot_index
  integer,intent(out) :: ibg
  integer,intent(out) :: ierr
  integer,intent(out) :: ikg
  integer,intent(in) :: ikpt
  integer,intent(in) :: isppol
  integer,intent(out) :: kindex
  integer,intent(in) :: nkpt
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  type(mpi_type),intent(in) :: MPI_enreg
  integer,intent(in) :: nband(nkpt*nsppol)
  integer,intent(in) :: npwarr(nkpt)
 end subroutine my_indeces
end interface

interface
 subroutine pre_gather(array,array_allgather,n1,n2,n3,n4,mpi_enreg)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: n3
  integer,intent(in) :: n4
  type(mpi_type),intent(inout) :: mpi_enreg
  real(dp),intent(in) :: array(n1,n2,n4,1)
  real(dp),intent(inout) :: array_allgather(n1,n2,n3,1)
 end subroutine pre_gather
end interface

interface
 subroutine pre_scatter(array,array_allgather,n1,n2,n3,n4,mpi_enreg)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: n3
  integer,intent(in) :: n4
  type(mpi_type),intent(inout) :: mpi_enreg
  real(dp),intent(out) :: array(n1,n2,n4,1)
  real(dp),intent(in) :: array_allgather(n1,n2,n3,1)
 end subroutine pre_scatter
end interface

interface
 subroutine pspheads_comm(npsp,pspheads,test_paw)
  use defs_datatypes
  implicit none
  integer,intent(in) :: npsp
  integer,intent(inout) :: test_paw
  type(pspheader_type),intent(inout) :: pspheads(npsp)
 end subroutine pspheads_comm
end interface

interface
 subroutine xdefineOff(formeig,wff,mpi_enreg,nband,npwarr,nspinor,nsppol,nkpt)
  use defs_abitypes
  use m_wffile
  implicit none
  integer, intent(in) :: formeig
  integer, intent(in) :: nkpt
  integer, intent(in) :: nspinor
  integer, intent(in) :: nsppol
  type(mpi_type),intent(in) :: mpi_enreg
  type(wffile_type),intent(inout) :: wff
  integer, intent(in) :: nband(nkpt*nsppol)
  integer, intent(in) :: npwarr(nkpt)
 end subroutine xdefineOff
end interface


!Generic interface of the routines xderiveread
interface xderiveread
 subroutine xderiveRead_int(wff,xval,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(out) :: xval
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveRead_int
 subroutine xderiveRead_int1d(wff,xval,n1,spaceComm,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:)
 end subroutine xderiveRead_int1d
 subroutine xderiveRead_int2d(wff,xval,n1,n2,spaceComm,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:,:)
 end subroutine xderiveRead_int2d
 subroutine xderiveRead_dp(wff,xval,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval
 end subroutine xderiveRead_dp
 subroutine xderiveRead_dp1d(wff,xval,n1,spaceComm,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval(:)
 end subroutine xderiveRead_dp1d
 subroutine xderiveRead_dp2d(wff,xval,n1,n2,spaceComm,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval(:,:)
 end subroutine xderiveRead_dp2d
 subroutine xderiveRead_int2d_displ(wff,xval,n1,n2,spaceComm,displace,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  integer,intent(out) :: xval(:,:)
 end subroutine xderiveRead_int2d_displ
 subroutine xderiveRead_dp2d_displ(wff,xval,n1,n2,spaceComm,displace,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  real(dp),intent(out) :: xval(:,:)
 end subroutine xderiveRead_dp2d_displ
 subroutine xderiveReadVal_char(wff,xval,n,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n
  type(wffile_type),intent(inout) :: wff
  character(len=*),intent(out) :: xval
 end subroutine xderiveReadVal_char
 subroutine xmpi_read_int2d(wff,xval,spaceComm,at_option,ierr)
  use m_wffile
  implicit none
  integer,intent(in) :: at_option
  integer,intent(out) :: ierr
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:,:)
 end subroutine xmpi_read_int2d
end interface
!End of the generic interface of xderiveread


!Generic interface of the routines xderivewrite
interface xderivewrite
 subroutine xderiveWrite_int(wff,xval,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: xval
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveWrite_int
 subroutine xderiveWrite_int1d(wff,xval,n1,spaceComm,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: xval(:)
 end subroutine xderiveWrite_int1d
 subroutine xderiveWrite_int2d(wff,xval,n1,n2,spaceComm,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: xval(:,:)
 end subroutine xderiveWrite_int2d
 subroutine xderiveWrite_dp(wff,xval,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval
 end subroutine xderiveWrite_dp
 subroutine xderiveWrite_dp1d(wff,xval,n1,spaceComm,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval(:)
 end subroutine xderiveWrite_dp1d
 subroutine xderiveWrite_dp2d(wff,xval,n1,n2,spaceComm,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval(:,:)
 end subroutine xderiveWrite_dp2d
 subroutine xderiveWrite_int2d_displ(wff,xval,n1,n2,spaceComm,displace,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  integer,intent(in) :: xval(:,:)
 end subroutine xderiveWrite_int2d_displ
 subroutine xderiveWrite_dp2d_displ(wff,xval,n1,n2,spaceComm,displace,ierr)
  use defs_basis
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  real(dp),intent(in) :: xval(:,:)
 end subroutine xderiveWrite_dp2d_displ
 subroutine xderiveWrite_char(wff,xval,n,ierr)
  use m_wffile
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n
  type(wffile_type),intent(inout) :: wff
  character(len=*),intent(in) :: xval
 end subroutine xderiveWrite_char
end interface
!End of the generic interface of xderivewrite

end module interfaces_51_manage_mpi
!!***
