!{\src2tex{textfont=tt}}
!!****f* ABINIT/initmpi_seq
!! NAME
!!  initmpi_seq
!!
!! FUNCTION
!!  Initializes the MPI information for a sequential use of other routines.
!!
!! COPYRIGHT
!!  Copyright (C) 2004-2012 ABINIT group (XG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!
!! OUTPUT
!!  mpi_enreg=informations about MPI parallelization
!!
!! SIDE EFFECTS
!!
!! TODO
!!
!! PARENTS
!!      anaddb,atm2fft,atm2fft3,bethe_salpeter,calc_vhxc_me,cut3d,debug_tools
!!      fftprof,ks_ddiago,kss2wfk,linear_optics_paw,lwf,m_cprj_bspline
!!      m_fft_prof,m_gsphere,m_hamiltonian,m_io_kss,m_paw_pwij,m_ppmodel
!!      m_screening,m_wfs,mlwfovlp_qp,mpi_enreg_tools,mrgddb,mrggkk,mrgscr
!!      optic,overlap_wf,pawmknhat,pawmknhat_psipsi,pawsushat,scfcv,screening
!!      setshells,sigma,suscep_stat,susk,ujdet,wffile,wfk_read_ene,wfread
!!      xc_kernel,xc_kernel_ADA
!!
!! CHILDREN
!!      nullify_mpi_enreg
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine initmpi_seq(mpi_enreg)

 use m_profiling

 use defs_basis
 use defs_abitypes
 use m_xmpi
 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'initmpi_seq'
 use interfaces_51_manage_mpi, except_this_one => initmpi_seq
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 type(MPI_type),intent(out) :: mpi_enreg


!Local variables-------------------------------
 

! ***********************************************************************

 DBG_ENTER("COLL")

 mpi_enreg%bandpp=1
!mpi_enreg%flag_ind_kg_mpi_to_seq = 0
 mpi_enreg%me=0
 mpi_enreg%me_band=0
 mpi_enreg%me_cell=0
 mpi_enreg%me_fft=0
 mpi_enreg%me_g0=0
 mpi_enreg%me_img=0
 mpi_enreg%me_kpt=0
 mpi_enreg%me_pert=0
 mpi_enreg%me_spinor=0
 mpi_enreg%my_natom=0     ! Should be natom
 mpi_enreg%ngfft3_ionic=1
 mpi_enreg%my_nimage=1
 mpi_enreg%nproc=1
 mpi_enreg%nproc_atom=1
 mpi_enreg%nproc_band=1
 mpi_enreg%nproc_cell=1
 mpi_enreg%nproc_fft=1
 mpi_enreg%nproc_img=1
 mpi_enreg%nproc_kpt=1
 mpi_enreg%nproc_pert=1
 mpi_enreg%nproc_spinor=1
 mpi_enreg%paralbd=0
 mpi_enreg%paral_img=0
 mpi_enreg%paral_kgb=0
 mpi_enreg%paral_pert=0
 mpi_enreg%paral_spinor=0
 mpi_enreg%usewvl = .false.
 
!Set communicators to MPI_COMM_SELF to avoid problems in MPI calls
!MG: Not all the communicators defined in MPI_type are set to xmpi_self
!There are additional arrays that however should not be used in seq mode.
 mpi_enreg%comm_world=xmpi_world

 mpi_enreg%comm_atom           = xmpi_self
 mpi_enreg%comm_band           = xmpi_self
 mpi_enreg%comm_bandspinor     = xmpi_self
 mpi_enreg%comm_bandfft        = xmpi_self
 mpi_enreg%comm_bandspinorfft  = xmpi_self
 mpi_enreg%comm_cell           = xmpi_self
 mpi_enreg%comm_cell_pert      = xmpi_self
 mpi_enreg%comm_fft            = xmpi_self
 mpi_enreg%comm_img            = xmpi_self 
 mpi_enreg%comm_kpt            = xmpi_self
 mpi_enreg%comm_kptband        = xmpi_self
 mpi_enreg%comm_pert           = xmpi_self
 mpi_enreg%comm_spinor         = xmpi_self
 mpi_enreg%comm_spinorfft      = xmpi_self

!Nullify all pointers
 call nullify_mpi_enreg(mpi_enreg)

 DBG_EXIT("COLL")

end subroutine initmpi_seq
!!***
