!{\src2tex{textfont=tt}}
!!****f* ABINIT/initmpi_pert
!! NAME
!!  initmpi_pert
!!
!! FUNCTION
!!  Creates group for Parallelization over Perturbations.
!!
!! COPYRIGHT
!!  Copyright (C) 2005-2012 ABINIT group (FJ,MT)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  dtset <type(dataset_type)>=all input variables in this dataset
!!  tread= 1 if nppert has been read in the input file; 0 otherwise
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  mpi_enreg=informations about MPI parallelization
!!
!! TODO
!!
!! PARENTS
!!      mpi_setup
!!
!! CHILDREN
!!      get_npert_rbz,initmpi_world,mpi_comm_create,mpi_comm_rank
!!      mpi_group_free,mpi_group_incl,wrtout,xcomm_free,xcomm_group,xgroup_free
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine initmpi_pert(dtset,mpi_enreg,tread)

 use defs_basis
 use defs_abitypes
 use m_errors
 use m_profiling
 use m_xmpi

#if defined HAVE_MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'initmpi_pert'
 use interfaces_14_hidewrite
 use interfaces_51_manage_mpi, except_this_one => initmpi_pert
!End of the abilint section

 implicit none
#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
 integer,intent(in) :: tread
 type(MPI_type),intent(inout) :: mpi_enreg
 type(dataset_type),intent(inout) :: dtset
!Local variables-------------------------------
!no_abirules
#if defined HAVE_MPI
 integer:: group_cell,ierr,iprocmin,irank,nproc_per_cell,nproc_world,nrank,numproc,pert_group,world_group
 integer,allocatable    :: ranks(:)
 character*500 :: message
#endif
 integer:: npert
 integer,pointer :: nkpt_rbz(:)
 real(dp),pointer :: nband_rbz(:,:)


! ***********************************************************************


 call get_npert_rbz(dtset,nband_rbz,nkpt_rbz,npert)

#if defined HAVE_MPI
 call xcomm_group(mpi_enreg%comm_world,world_group,ierr)
 if (tread==0) then
   if (npert<=mpi_enreg%nproc) dtset%nppert=npert
   if (npert>mpi_enreg%nproc) dtset%nppert=mpi_enreg%nproc
 else
   if(dtset%nppert>npert) then
     dtset%nppert=npert
     write(message,'(6a,i6,a)') ch10,&
&     ' initmpi_pert :  WARNING -',ch10,&
&     ' nppert is bigger than npert ',ch10,&
&     '  We set nppert=npert=',npert,' .'
     call wrtout(std_out,message,'COLL')
   end if
 end if
 if (dtset%nppert>1) then
   nproc_world=   mpi_enreg%nproc/dtset%nppert*dtset%nppert
   if(nproc_world<mpi_enreg%nproc)then
     call initmpi_world(mpi_enreg,nproc_world)
     if (mpi_enreg%comm_cell/=mpi_enreg%comm_world) call xcomm_free(mpi_enreg%comm_cell)
     mpi_enreg%comm_cell=mpi_enreg%comm_world
     mpi_enreg%me_cell=mpi_enreg%me
     mpi_enreg%nproc_cell=mpi_enreg%nproc
   end if
   if (mpi_enreg%me>=0) then
     nproc_per_cell=mpi_enreg%nproc/dtset%nppert
!    Communicator over all images
     nrank=dtset%nppert
     ABI_ALLOCATE(ranks,(nrank))
     iprocmin=mod(mpi_enreg%me,nproc_per_cell)
     do irank=1,nrank
       ranks(irank)=iprocmin+(irank-1)*nproc_per_cell
     end do
     call MPI_GROUP_INCL(world_group,nrank,ranks,pert_group,ierr)
     ABI_DEALLOCATE(ranks)
     call MPI_COMM_CREATE(mpi_enreg%comm_world,pert_group,mpi_enreg%comm_pert,ierr)
     call MPI_GROUP_FREE(pert_group,ierr)
     call MPI_COMM_RANK(mpi_enreg%comm_pert,mpi_enreg%me_pert,ierr)
     mpi_enreg%nproc_pert=dtset%nppert
     if (iprocmin==0.and.mpi_enreg%me_pert==0.and.mpi_enreg%me/=0) then
       message=' initmpi_pert: Error on me_pert!'
       MSG_BUG(message)
     end if
!    Define mpi_enreg%distrb_pert
     ABI_ALLOCATE(mpi_enreg%distrb_pert,(npert))
     nrank=0
     do irank=1,npert
       nrank=nrank+1
       mpi_enreg%distrb_pert(irank)=mod(nrank,dtset%nppert)-1
       if (mpi_enreg%distrb_pert(irank)==-1) mpi_enreg%distrb_pert(irank)=dtset%nppert-1
     end do
     numproc=mpi_enreg%distrb_pert(npert)
     if(numproc/=0) then
       do irank=1,npert
         if (mpi_enreg%distrb_pert(irank)==numproc) mpi_enreg%distrb_pert(irank)=-2
         if (mpi_enreg%distrb_pert(irank)==0) mpi_enreg%distrb_pert(irank)=-3
       end do
       do irank=1,npert
         if (mpi_enreg%distrb_pert(irank)==-2) mpi_enreg%distrb_pert(irank)=0
         if (mpi_enreg%distrb_pert(irank)==-3) mpi_enreg%distrb_pert(irank)=numproc
       end do
     end if
!    mpi_enreg%my_npert=0
!    do irank=1,npert
!    if (mpi_enreg%distrb_pert(irank)==mpi_enreg%me_pert) mpi_enreg%my_npert=mpi_enreg%my_npert+1
!    end do
!    Communicator over one cell
     nrank=nproc_per_cell
     ABI_ALLOCATE(ranks,(nrank))
     iprocmin=(mpi_enreg%me/nrank)*nrank
     do irank=1,nrank
       ranks(irank)=iprocmin+irank-1
     end do
     call MPI_GROUP_INCL(world_group,nrank,ranks,group_cell,ierr)
     ABI_DEALLOCATE(ranks)
     call MPI_COMM_CREATE(mpi_enreg%comm_world,group_cell,mpi_enreg%comm_cell_pert,ierr)
     call xgroup_free(group_cell)
     call xgroup_free(world_group)
   end if
 else  !nppert<=1
#endif
   mpi_enreg%nproc_pert=1
   mpi_enreg%comm_pert=xmpi_self
   mpi_enreg%me_pert=0
   ABI_ALLOCATE(mpi_enreg%distrb_pert,(npert))
   mpi_enreg%distrb_pert(:)=0
#if defined HAVE_MPI
 end if
#endif

 ABI_DEALLOCATE(nband_rbz)
 ABI_DEALLOCATE(nkpt_rbz)


end subroutine initmpi_pert
!!***
