!{\src2tex{textfont=tt}}
!!****f* ABINIT/initmpi_atom
!! NAME
!!  initmpi_atom
!!
!! FUNCTION
!!  Initializes the mpi informations for parallelism over atoms (PAW).
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2012 ABINIT group (MT)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  mpi_enreg= informations about MPI parallelization
!!
!! OUTPUT
!!  mpi_enreg= informations about MPI parallelization
!!    comm_atom                 =communicator over atoms
!!    nproc_atom                =size of the communicator over atoms
!!    my_natom                  =number of atoms treated by current proc
!!    my_atmtab(mpi_enreg%natom)=indexes of the atoms treated by current processor
!!
!! NOTES
!!   MD, april 2012: the parallelization over atoms is above the parallelisation
!!   over bands and k-points. So the cprj(natom,nspinor*nband*mkmem) are not distributed
!!   over atoms because they are distributed over bands and k-points.

!! PARENTS
!!      mpi_setup
!!
!! CHILDREN
!!      get_my_atmtab,get_my_natom
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine initmpi_atom(dtset,mpi_enreg)

 use m_profiling

 use defs_basis
 use defs_abitypes
 use m_errors
 use m_xmpi
 use m_paral_atom

#if defined HAVE_MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'initmpi_atom'
!End of the abilint section

 implicit none
#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
!scalars
 type(dataset_type),intent(in) :: dtset
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays

!Local variables-------------------------------
!scalars
 logical :: my_atmtab_allocated,paral_atom
 character(len=500) :: msg
!arrays

! ***********************************************************************

 DBG_ENTER("COLL")

 mpi_enreg%nproc_atom=1
 mpi_enreg%comm_atom=xmpi_self
 mpi_enreg%my_natom=dtset%natom
 nullify(mpi_enreg%my_atmtab)

 if (xmpi_paral==0) return

!Check compatibility
 if (dtset%paral_atom>0) then
   msg=''
   if (dtset%usepaw==0)     msg= 'Parallelisation over atoms not compatible with usepaw=0 !'
   if (mpi_enreg%paralbd>0) msg=' Parallelisation over atoms not compatible with paralbd>0 !'
   if (dtset%paral_rf/=0)   msg=' Parallelisation over atoms not compatible with paral_rf!=0 !'
   if (dtset%usedmft==1)    msg=' Parallelisation over atoms not compatible with usedmft=1 !'
   if (dtset%prtden>1.and.dtset%paral_kgb<=0) &
&   msg= 'Parallelisation over atoms not compatible with prtden>1 (PAW AE densities) !'
   if (dtset%optdriver/=RUNL_GSTATE.and.dtset%optdriver/=RUNL_RESPFN) &
&   msg=' Parallelisation over atoms only compatible with GS or RF !'
   if (dtset%macro_uj/=0)   msg=' Parallelisation over atoms not compatible with macro_uj!=0 !'
   if (msg/='') then
     MSG_ERROR(msg)
   end if
 end if

 if (dtset%paral_atom>0) then

!  Build correct atom communicator
   if (dtset%paral_kgb==0) then
     if (mpi_enreg%paral_img==0) then
       mpi_enreg%comm_atom=mpi_enreg%comm_world
     else
       mpi_enreg%comm_atom=mpi_enreg%comm_cell
     end if
   else
     mpi_enreg%comm_atom=mpi_enreg%comm_kptband
   end if

!  Get number of processors sharing the atomic data distribution
   mpi_enreg%nproc_atom=xcomm_size(mpi_enreg%comm_atom)

!  Get local number of atoms
   call get_my_natom(mpi_enreg%comm_atom,mpi_enreg%my_natom,dtset%natom)
   paral_atom=(mpi_enreg%my_natom/=dtset%natom)

!  Build atom table
   if (mpi_enreg%my_natom>0.and.paral_atom) then
     my_atmtab_allocated=.false.
     call get_my_atmtab(mpi_enreg%comm_atom,mpi_enreg%my_atmtab,my_atmtab_allocated, &
&     paral_atom,dtset%natom)
   else
     ABI_ALLOCATE(mpi_enreg%my_atmtab,(0))
   end if

 end if

 DBG_EXIT("COLL")

end subroutine initmpi_atom
!!***


