!{\src2tex{textfont=tt}}
!!****f* ABINIT/clnmpi_pert
!! NAME
!!  clnmpi_pert
!!
!! FUNCTION
!!  Cleans-up the mpi informations for parallelization over perturbations.
!!
!! COPYRIGHT
!!  Copyright (C) 2009-2012 ABINIT group (MT)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!
!! SIDE EFFECTS
!!  mpi_enreg=informations about MPI parallelization
!!
!! PARENTS
!!      abinit
!!
!! CHILDREN
!!      xcomm_free
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine clnmpi_pert(mpi_enreg)

 use m_profiling

 use defs_basis
 use defs_abitypes
 use m_errors
 use m_xmpi

#if defined HAVE_MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'clnmpi_pert'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif
!Arguments ------------------------------------
 type(MPI_type),intent(inout) :: mpi_enreg

!Local variables-------------------------------


! ***********************************************************************

 DBG_ENTER("COLL")

 if (xmpi_paral==0) return

 if(mpi_enreg%paral_pert == 1) then

!  Reset communicators
   if (mpi_enreg%comm_pert/=mpi_enreg%comm_world) then
     call xcomm_free(mpi_enreg%comm_pert)
     mpi_enreg%comm_pert=xmpi_comm_null
   end if

   if (associated(mpi_enreg%distrb_pert))  then
     ABI_DEALLOCATE(mpi_enreg%distrb_pert)
   end if

   mpi_enreg%me_pert=0
   mpi_enreg%me_cell=0
   mpi_enreg%nproc_pert=1
   mpi_enreg%nproc_cell=1


 end if

 DBG_EXIT("COLL")

end subroutine clnmpi_pert
!!***
