!{\src2tex{textfont=tt}}
!!****f* ABINIT/clnmpi_grid
!! NAME
!!  clnmpi_grid
!!
!! FUNCTION
!!  Cleans-up the mpi informations for parallelism over grid (kpt/band/fft).
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2012 ABINIT group (MT,GG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt.
!!
!! SIDE EFFECTS
!!  mpi_enreg=informations about MPI parallelization
!!
!! PARENTS
!!      abinit
!!
!! CHILDREN
!!      xcomm_free
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine clnmpi_grid(mpi_enreg)

 use m_profiling

 use defs_basis
 use defs_abitypes
 use m_errors
 use m_xmpi

#if defined HAVE_MPI && defined HAVE_MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'clnmpi_grid'
!End of the abilint section

 implicit none
#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
 type(MPI_type), intent(inout) :: mpi_enreg

!Local variables-------------------------------

! ***********************************************************************

 DBG_ENTER("COLL")

 if (xmpi_paral==0) return

 if (mpi_enreg%comm_bandspinorfft/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_bandspinorfft)
   mpi_enreg%comm_bandspinorfft=xmpi_comm_null
 end if

 if (mpi_enreg%comm_bandfft/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_bandfft)
   mpi_enreg%comm_bandfft=xmpi_comm_null
 end if

 if (mpi_enreg%comm_spinorfft/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_spinorfft)
   mpi_enreg%comm_spinorfft=xmpi_comm_null
 end if

 if (mpi_enreg%comm_bandspinor/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_bandspinor)
   mpi_enreg%comm_bandspinor=xmpi_comm_null
 end if

 if (mpi_enreg%comm_kptband/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_kptband)
   mpi_enreg%comm_kptband=xmpi_comm_null
 end if

 if (mpi_enreg%comm_fft/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_fft)
   mpi_enreg%comm_fft=xmpi_comm_null
 end if

 if (mpi_enreg%comm_band/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_band)
   mpi_enreg%comm_band=xmpi_comm_null
 end if

 if (mpi_enreg%comm_spinor/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_spinor)
   mpi_enreg%comm_spinor=xmpi_comm_null
 end if

 if (mpi_enreg%comm_kpt/=mpi_enreg%comm_world) then
   call xcomm_free(mpi_enreg%comm_kpt)
   mpi_enreg%comm_kpt=xmpi_comm_null
 end if

 DBG_EXIT("COLL")

end subroutine clnmpi_grid
!!***
