!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_xml_pawpseudo
!! NAME
!! m_xml_pseudo
!!
!! FUNCTION
!! This module reads a pseudopotential file written in XML.
!! A full example of the building up of a data structure using
!! the SAX paradigm.
!!
!! COPYRIGHT
!! Copyright (C) 2005-2012 ABINIT group (FJ)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! 
!! OUTPUT
!!
!! PARENTS
!! 
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


module m_xml_pawpseudo

 use defs_basis
 use m_profiling
 use m_errors
#if defined HAVE_TRIO_FOX
 use fox_sax
 use m_xml_pawpseudo_types
#endif

implicit none

private

#if defined HAVE_TRIO_FOX
!
! It defines the routines that are called from xml_parser in response
! to particular events.
!
public  :: paw_begin_element1, paw_end_element1,pawdata_chunk
public  ::  destroy_paw_setup, nullify_paw_setup
public  ::  copy_paw_setup
private :: ddie_
integer,private  ::iaewf=0,iproj=0,ipswf=0
logical, private  :: in_valenceStates = .false.,in_data=.false.
logical, private  :: in_generator =.false.
integer, private, save  :: ndata
integer, private  :: ii,ival,igrid,mesh_size
integer, public, allocatable :: ipsp2xml(:)
integer, public :: npsp_pawxml
type(paw_setup_t), public, target, allocatable,save :: paw_setup(:)
type(paw_setup_t), public,target,save ::paw_setuploc


! Pointers to make it easier to manage the data
type(radialfunc_t), private, pointer  :: rp
type(state_t), private, pointer   :: valstate (:)
type(radial_grid_t), private, pointer   :: grids (:)


CONTAINS  !===========================================================
!!***

!!****f* m_xml_pawpseudo/paw_begin_element1
!! NAME
!! begin_element
!!
!! FUNCTION
!!  Read an XML tag with a given name.
!!  Fills the present module private data.
!!
!! INPUTS
!!  namespaceURI = universal resource indicator for XML namespace??? Not used.
!!  localName = local equivalent of tag name?? Not used.
!!  name = name of XML tag which has been read in
!!  attributes = attributes of XML tag
!!
!! OUTPUT
!!  Fills private data in present module.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine paw_begin_element1(namespaceURI,localName,name,attributes)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'paw_begin_element1'
!End of the abilint section

character(len=*),intent(in)   :: namespaceURI,localName,name
type(dictionary_t),intent(in) :: attributes

character(len=100)  :: value

!Just to fool abirules
 value=localName
 value=namespaceURI

select case(name)

      case ("paw_setup")
        paw_setuploc%tread=.true.
        igrid=0
        ABI_DATATYPE_ALLOCATE(grids,(10))
        value = getValue(attributes,"version")
!         if (value = "0.6") then
!            write(std_out,*) "Processing a PSEUDO version 0.6 XML file"
!          else
!            write(std_out,*) "Can only work with PSEUDO version 0.6 XML files"
!            STOP
!         end if
        paw_setuploc%version=trim(value)


      case ("atom")
         paw_setuploc%atom%tread=.true.
         value = getValue(attributes,"symbol")
         if (value == "" ) call ddie_("Cannot determine atomic symbol")
         paw_setuploc%atom%symbol = trim(value)

         value = getValue(attributes,"Z") 
         if (value == "" ) call ddie_("Cannot determine znucl")
         read(unit=value,fmt=*) paw_setuploc%atom%znucl

         value = getValue(attributes,"core")
         if (value == "" ) call ddie_("Cannot determine zion")
         read(unit=value,fmt=*) paw_setuploc%atom%zion

         value = getValue(attributes,"valence")
         if (value == "" ) call ddie_("Cannot determine zval")
         read(unit=value,fmt=*) paw_setuploc%atom%zval


      case ("xc_functional")
         paw_setuploc%xc_functional%tread=.true.
         value = getValue(attributes,"type")
         if (value == "" ) &
            call ddie_("Cannot determine xc-functional-type")
         paw_setuploc%xc_functional%functionaltype = trim(value)

         value = getValue(attributes,"name")
         if (value == "" ) &
&            call ddie_("Cannot determine xc-functional-name ")
         paw_setuploc%xc_functional%name= trim(value)

      case ("generator")
         paw_setuploc%generator%tread=.true.
         in_generator =.true.
         value = getValue(attributes,"type")
         if (value == "" ) value = "unknown"
         paw_setuploc%generator%gen = trim(value)

         value = getValue(attributes,"name")
         if (value == "" ) value = "unknown"
         paw_setuploc%generator%name = trim(value)


      case ("valence_states")
         paw_setuploc%valence_states%tread=.true.
         in_valenceStates=.true.
         ival=0
         ABI_DATATYPE_ALLOCATE(valstate,(50))

      case ("state")
         ival=ival+1

         value = getValue(attributes,"n")
         if (value == "" ) then 
           valstate(ival)%nn=-1    
         else
           read(unit=value,fmt=*) valstate(ival)%nn
         end if
 
         value = getValue(attributes,"l")
         if (value == "" ) call ddie_("Cannot determine l")
         read(unit=value,fmt=*) valstate(ival)%ll

         value = getValue(attributes,"f")
         if (value == "" ) then 
           valstate(ival)%ff=-1.d0
         else
           read(unit=value,fmt=*) valstate(ival)%ff
         end if

         value = getValue(attributes,"rc")
         if (value == "" ) call ddie_("Cannot determine rc")
         read(unit=value,fmt=*) valstate(ival)%rc

         value = getValue(attributes,"e")
         if (value == "" ) call ddie_("Cannot determine e")
         read(unit=value,fmt=*) valstate(ival)%ee

         value = getValue(attributes,"id")
         if (value == "" ) value = "unknown"
         valstate(ival)%id = trim(value)

      case ("radial_grid")
         igrid=igrid+1
         value = getValue(attributes,"eq")
         if (value == "" ) value = "unknown"
         grids(igrid)%eq = trim(value)
           
         value = getValue(attributes,"a")
         if (value == "" ) then
           grids(igrid)%aa=0.d0
         else
           read(unit=value,fmt=*) grids(igrid)%aa
         end if

         value = getValue(attributes,"n")
         if (value == "" ) then
           grids(igrid)%nn=0
         else
           read(unit=value,fmt=*) grids(igrid)%nn
         end if

         value = getValue(attributes,"d")
         if (value == "" ) then
           grids(igrid)%dd=0.d0
         else
           read(unit=value,fmt=*) grids(igrid)%dd
         end if

         value = getValue(attributes,"b")
         if (value == "" ) then
           grids(igrid)%bb=0.d0
         else
           read(unit=value,fmt=*) grids(igrid)%bb
         end if

         value = getValue(attributes,"istart")
         if (value == "" ) call ddie_("Cannot determine istart")
         read(unit=value,fmt=*) grids(igrid)%istart

         value = getValue(attributes,"iend")
         if (value == "" ) call ddie_("Cannot determine iend")
         read(unit=value,fmt=*) grids(igrid)%iend

         value = getValue(attributes,"id")
         if (value == "" ) value = "unknown"
         grids(igrid)%id = trim(value)

      case ("shape_function")
         paw_setuploc%shape_function%tread=.true.
         value = getValue(attributes,"type")
         if (value == "" ) value = "unknown"
         paw_setuploc%shape_function%gtype = trim(value)

         value = getValue(attributes,"grid")
         paw_setuploc%shape_function%grid=trim(value)
         if (value /= "" ) then
           paw_setuploc%shape_function%gtype ="num" 
           do ii=1,igrid
             if(trim(paw_setuploc%shape_function%grid)==trim(grids(ii)%id)) then
               mesh_size=grids(ii)%iend-grids(ii)%istart+1
             end if
           end do
           ABI_ALLOCATE(paw_setuploc%shape_function%data,(mesh_size))
           rp%data=>paw_setuploc%shape_function%data
           in_data=.true.
           ndata = 0
         end if

         value = getValue(attributes,"rc")
         if (value == "" ) then
           if(paw_setuploc%shape_function%gtype /="num") call ddie_("Cannot determine rc")
         else
           read(unit=value,fmt=*) paw_setuploc%shape_function%rc
         end if

         value = getValue(attributes,"lamb")
         if (value == "" ) then
           paw_setuploc%shape_function%lamb=0
         else
           read(unit=value,fmt=*) paw_setuploc%shape_function%lamb
         end if


end select



select case(name)
      case ("pseudo_partial_wave")
         ipswf=ipswf+1
         paw_setuploc%pseudo_partial_wave(ipswf)%tread=.true.
         value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%idgrid = trim(value)
         paw_setuploc%pseudo_partial_wave(ipswf)%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) call ddie_("Cannot determine pseudo_partial_wave state")
         paw_setuploc%pseudo_partial_wave(ipswf)%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%pseudo_partial_wave(ipswf)%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do
         ABI_ALLOCATE(paw_setuploc%pseudo_partial_wave(ipswf)%data,(mesh_size))
         rp=>paw_setuploc%pseudo_partial_wave(ipswf)
         in_data=.true.
         ndata = 0


      case ("ae_partial_wave")
         iaewf=iaewf+1
         paw_setuploc%ae_partial_wave(iaewf)%tread=.true.
         value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%ae_partial_wave(iaewf)%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) call ddie_("Cannot determine ae_partial_wave state")
         paw_setuploc%ae_partial_wave(iaewf)%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%ae_partial_wave(iaewf)%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%ae_partial_wave(iaewf)%data,(mesh_size))
         rp=>paw_setuploc%ae_partial_wave(iaewf)

         in_data=.true.
         ndata = 0

      case ("projector_function")
         iproj=iproj+1
         paw_setuploc%projector_function(iproj)%tread=.true.
         value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%projector_function(iproj)%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) call ddie_("Cannot determine projector_function state")
         paw_setuploc%projector_function(iproj)%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%projector_function(iproj)%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%projector_function(iproj)%data,(mesh_size))
         rp=>paw_setuploc%projector_function(iproj)
         in_data=.true.
         ndata = 0

     case ("ae_core_density")
         paw_setuploc%ae_core_density%tread=.true.
          value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%ae_core_density%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) value = "unknown"
         paw_setuploc%ae_core_density%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%ae_core_density%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%ae_core_density%data,(mesh_size))
         rp=>paw_setuploc%ae_core_density
         in_data=.true.
         ndata = 0

     case ("pseudo_core_density")
         paw_setuploc%pseudo_core_density%tread=.true.
          value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%pseudo_core_density%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) value = "unknown"
         paw_setuploc%pseudo_core_density%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%pseudo_core_density%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%pseudo_core_density%data,(mesh_size))
         rp=>paw_setuploc%pseudo_core_density
         in_data=.true.
         ndata = 0

     case ("pseudo_valence_density")
         paw_setuploc%pseudo_valence_density%tread=.true.
          value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%pseudo_valence_density%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) value = "unknown"
         paw_setuploc%pseudo_valence_density%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%pseudo_valence_density%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%pseudo_valence_density%data,(mesh_size))
         rp=>paw_setuploc%pseudo_valence_density
         in_data=.true.
         ndata = 0

     case ("zero_potential")
         paw_setuploc%zero_potential%tread=.true.
          value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%zero_potential%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) value = "unknown"
         paw_setuploc%zero_potential%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%zero_potential%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%zero_potential%data,(mesh_size))
         rp=>paw_setuploc%zero_potential
         in_data=.true.
         ndata = 0

     case ("ae_core_kinetic_energy_density")
         paw_setuploc%ae_core_kinetic_energy_density%tread=.true.
          value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%ae_core_kinetic_energy_density%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) value = "unknown"
         paw_setuploc%ae_core_kinetic_energy_density%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%ae_core_kinetic_energy_density%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%ae_core_kinetic_energy_density%data,(mesh_size))
         rp=>paw_setuploc%ae_core_kinetic_energy_density
         in_data=.true.
         ndata = 0

     case ("pseudo_core_kinetic_energy_density")
         paw_setuploc%pseudo_core_kinetic_energy_density%tread=.true.
          value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%pseudo_core_kinetic_energy_density%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) value = "unknown"
         paw_setuploc%pseudo_core_kinetic_energy_density%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%pseudo_core_kinetic_energy_density%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%pseudo_core_kinetic_energy_density%data,(mesh_size))
         rp=>paw_setuploc%pseudo_core_kinetic_energy_density
         in_data=.true.
         ndata = 0

     case ("kresse_joubert_local_ionic_potential")
         paw_setuploc%kresse_joubert_local_ionic_potential%tread=.true.
          value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%kresse_joubert_local_ionic_potential%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) value = "unknown"
         paw_setuploc%kresse_joubert_local_ionic_potential%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%kresse_joubert_local_ionic_potential%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%kresse_joubert_local_ionic_potential%data,(mesh_size))
         rp=>paw_setuploc%kresse_joubert_local_ionic_potential
         in_data=.true.
         ndata = 0

     case ("blochl_local_ionic_potential")
         paw_setuploc%blochl_local_ionic_potential%tread=.true.
          value = getValue(attributes,"grid")
         if (value == "" ) value = "unknown"
         paw_setuploc%blochl_local_ionic_potential%grid=trim(value)

         value = getValue(attributes,"state")
         if (value == "" ) value = "unknown"
         paw_setuploc%blochl_local_ionic_potential%state=trim(value)

         do ii=1,igrid
           if(trim(paw_setuploc%blochl_local_ionic_potential%grid)==trim(grids(ii)%id)) then
             mesh_size=grids(ii)%iend-grids(ii)%istart+1
           end if
         end do

         ABI_ALLOCATE(paw_setuploc%blochl_local_ionic_potential%data,(mesh_size))
         rp=>paw_setuploc%blochl_local_ionic_potential
         in_data=.true.
         ndata = 0

    case ("kinetic_energy_differences")
         paw_setuploc%kinetic_energy_differences%tread=.true.
         mesh_size=paw_setuploc%valence_states%nval*paw_setuploc%valence_states%nval
         ABI_ALLOCATE(paw_setuploc%kinetic_energy_differences%data,(mesh_size))
         rp=>paw_setuploc%kinetic_energy_differences
         in_data=.true.
         ndata = 0
end select



end subroutine paw_begin_element1
!!***

!!****f* m_xml_pawpseudo/paw_end_element1
!! NAME
!! end_element
!!
!! FUNCTION
!!  End XML tag effect: switches flags in private data of this module
!!
!! INPUTS
!!  namespaceURI = universal resource indicator for XML namespace??? Not used.
!!  localName = local equivalent of tag name?? Not used.
!!  name = name of XML tag which has been read in
!!
!! OUTPUT
!!  side effect: private data flags in present module are turned to .false.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine paw_end_element1(namespaceURI,localName,name)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'paw_end_element1'
!End of the abilint section

character(len=*),intent(in) :: namespaceURI,localName,name

character(len=100)  :: value

!Just to fool abirules 
 value=localName
 value=namespaceURI
 
select case(name)

      case ("generator")
         in_generator = .false.

      case ("valence_states")
        in_valenceStates = .false.
        if(ival>50) call ddie_("ival>50")
        if(ival>0)then
          ABI_DATATYPE_ALLOCATE(paw_setuploc%valence_states%state,(ival))
          paw_setuploc%valence_states%state(ival)%tread=.true.
          paw_setuploc%valence_states%nval=ival
          do ii=1,ival
            paw_setuploc%valence_states%state(ii)=valstate(ii)
          end do
        end if
        ABI_DATATYPE_DEALLOCATE(valstate)
        if(.not.associated(paw_setuploc%ae_partial_wave)) then
          ABI_DATATYPE_ALLOCATE(paw_setuploc%ae_partial_wave,(paw_setuploc%valence_states%nval))
        end if
        if(.not.associated(paw_setuploc%pseudo_partial_wave)) then
          ABI_DATATYPE_ALLOCATE(paw_setuploc%pseudo_partial_wave,(paw_setuploc%valence_states%nval))
        end if
        if(.not.associated(paw_setuploc%projector_function)) then
          ABI_DATATYPE_ALLOCATE(paw_setuploc%projector_function,(paw_setuploc%valence_states%nval))
        end if

      case ("paw_setup")
        if(igrid>10) call ddie_("igrid>10")
        ABI_DATATYPE_ALLOCATE(paw_setuploc%radial_grid,(igrid))
        paw_setuploc%radial_grid(igrid)%tread=.true.
        paw_setuploc%ngrid=igrid
        do ii=1,igrid
          paw_setuploc%radial_grid(ii)=grids(ii)
        end do
        ABI_DATATYPE_DEALLOCATE(grids)

      case ("shape_function")
        in_data=.false.

      case ("pseudo_partial_wave")
        in_data=.false.

      case ("ae_partial_wave")
        in_data=.false.

      case ("projector_function")
        in_data=.false.

      case ("ae_core_density")
        in_data=.false.

      case ("pseudo_core_density")
        in_data=.false.

      case ("pseudo_valence_density")
        in_data=.false.

      case ("zero_potential")
        in_data=.false.

      case ("ae_core_kinetic_energy_density")
        in_data=.false.

      case ("pseudo_core_kinetic_energy_density")
        in_data=.false.

      case ("kresse_joubert_local_ionic_potential")
        in_data=.false.

      case ("blochl_local_ionic_potential")
        in_data=.false.

      case ("kinetic_energy_differences")
        in_data=.false.


end select

end subroutine paw_end_element1
!!***

!!****f* m_xml_pseudo/pawdata_chunk
!! NAME
!! pawdata_chunk
!!
!! FUNCTION
!!   Read in data from XML structure, if we are in a valid data field
!!   for the present XML structures
!!
!! INPUTS
!!   chunk = raw data for chunk of XML data
!!
!! OUTPUT
!!   copied and translated into module data (side effect)
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine pawdata_chunk(chunk)

use m_xml_converters

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'pawdata_chunk'
!End of the abilint section

character(len=*), intent(in) :: chunk


if (len_trim(chunk) == 0) RETURN     ! skip empty chunk

if (in_data) then
!
! Note that we know where we need to put it through the pointer rp...
!

     call build_data_array(chunk,rp%data,ndata)

end if

end subroutine pawdata_chunk
!!***

!!****f* ABINIT/destroy_paw_setup
!! NAME
!! destroy_paw_setup
!!
!! FUNCTION
!!  Destroy a paw_setup datastructure
!!
!! COPYRIGHT
!!  Copyright (C) 2009-2012 ABINIT group (FJ)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SIDE EFFECTS
!!  paw_setup<paw_setup_type>=Datatype gathering information on XML paw setup.
!!
!! PARENTS
!!      abinit,inpspheads
!!
!! CHILDREN
!!
!! SOURCE

subroutine destroy_paw_setup(paw_setupin)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'destroy_paw_setup'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(paw_setup_t),intent(inout) :: paw_setupin

!Local variables-------------------------------
 integer :: ii
! *********************************************************************
 

 if(associated( paw_setupin%ae_core_density%data)) then
   ABI_DEALLOCATE(paw_setupin%ae_core_density%data)
   nullify(paw_setupin%ae_core_density%data)
 end if
 if(associated( paw_setupin%pseudo_core_density%data)) then
   ABI_DEALLOCATE(paw_setupin%pseudo_core_density%data)
   nullify(paw_setupin%pseudo_core_density%data)
 end if
 if(associated( paw_setupin%pseudo_valence_density%data)) then
   ABI_DEALLOCATE(paw_setupin%pseudo_valence_density%data)
   nullify(paw_setupin%pseudo_valence_density%data)
 end if
 if(associated( paw_setupin%zero_potential%data)) then
   ABI_DEALLOCATE(paw_setupin%zero_potential%data)
   nullify(paw_setupin%zero_potential%data)
 end if
 if(associated( paw_setupin%ae_core_kinetic_energy_density%data)) then
   ABI_DEALLOCATE(paw_setupin%ae_core_kinetic_energy_density%data)
   nullify(paw_setupin%ae_core_kinetic_energy_density%data)
 end if
 if(associated( paw_setupin%pseudo_core_kinetic_energy_density%data)) then
   ABI_DEALLOCATE(paw_setupin%pseudo_core_kinetic_energy_density%data)
   nullify(paw_setupin%pseudo_core_kinetic_energy_density%data)
 end if
 if(associated( paw_setupin%kresse_joubert_local_ionic_potential%data)) then
   ABI_DEALLOCATE(paw_setupin%kresse_joubert_local_ionic_potential%data)
   nullify(paw_setupin%kresse_joubert_local_ionic_potential%data)
 end if
 if(associated( paw_setupin%blochl_local_ionic_potential%data)) then
   ABI_DEALLOCATE(paw_setupin%blochl_local_ionic_potential%data)
   nullify(paw_setupin%blochl_local_ionic_potential%data)
 end if
 if(associated( paw_setupin%kinetic_energy_differences%data)) then
   ABI_DEALLOCATE(paw_setupin%kinetic_energy_differences%data)
   nullify(paw_setupin%kinetic_energy_differences%data)
 end if
 if (associated( paw_setupin%ae_partial_wave)) then
   do ii=1,paw_setupin%valence_states%nval
     if(associated( paw_setupin%ae_partial_wave(ii)%data)) then
       ABI_DEALLOCATE(paw_setupin%ae_partial_wave(ii)%data)
       nullify(paw_setupin%ae_partial_wave(ii)%data)
     end if
   end do
   ABI_DATATYPE_DEALLOCATE(paw_setupin%ae_partial_wave)
   nullify(paw_setupin%ae_partial_wave)
 end if
 if (associated( paw_setupin%pseudo_partial_wave)) then
   do ii=1,paw_setupin%valence_states%nval
     if(associated( paw_setupin%pseudo_partial_wave(ii)%data)) then
       ABI_DEALLOCATE(paw_setupin%pseudo_partial_wave(ii)%data)
       nullify(paw_setupin%pseudo_partial_wave(ii)%data)
     end if
   end do
   ABI_DATATYPE_DEALLOCATE(paw_setupin%pseudo_partial_wave)
   nullify(paw_setupin%pseudo_partial_wave)
 end if
 if (associated( paw_setupin%projector_function)) then
   do ii=1,paw_setupin%valence_states%nval
     if(associated( paw_setupin%projector_function(ii)%data)) then
       ABI_DEALLOCATE(paw_setupin%projector_function(ii)%data)
       nullify(paw_setupin%projector_function(ii)%data)
     end if
   end do
   ABI_DATATYPE_DEALLOCATE(paw_setupin%projector_function)
   nullify(paw_setupin%projector_function)
 end if
 if(associated(paw_setupin%valence_states%state)) then
   ABI_DATATYPE_DEALLOCATE(paw_setupin%valence_states%state)
   nullify(paw_setupin%valence_states%state)
 end if
 if(associated( paw_setupin%radial_grid)) then
   ABI_DATATYPE_DEALLOCATE(paw_setupin%radial_grid)
   nullify(paw_setupin%radial_grid)
 end if


end subroutine destroy_paw_setup
!!***

!!****f* ABINIT/nullify_paw_setup
!! NAME
!! nullify_paw_setup
!!
!! FUNCTION
!!  nullify a paw_setup datastructure
!!
!! COPYRIGHT
!!  Copyright (C) 2009-2012 ABINIT group (FJ)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SIDE EFFECTS
!!  paw_setup<paw_setup_type>=Datatype gathering information on XML paw setup.
!!
!! PARENTS
!!      inpspheads
!!
!! CHILDREN
!!
!! SOURCE

subroutine nullify_paw_setup(paw_setupin)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'nullify_paw_setup'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(paw_setup_t),intent(inout) :: paw_setupin

!Local variables-------------------------------

! *********************************************************************

 nullify(paw_setupin%radial_grid)
 nullify(paw_setupin%valence_states%state)
 nullify(paw_setupin%pseudo_partial_wave)
 nullify(paw_setupin%ae_partial_wave)
 nullify(paw_setupin%projector_function)
 nullify(paw_setupin%ae_core_density%data)
 nullify(paw_setupin%pseudo_core_density%data)
 nullify(paw_setupin%pseudo_valence_density%data)
 nullify(paw_setupin%zero_potential%data)
 nullify(paw_setupin%ae_core_kinetic_energy_density%data)
 nullify(paw_setupin%pseudo_core_kinetic_energy_density%data)
 nullify(paw_setupin%kresse_joubert_local_ionic_potential%data)
 nullify(paw_setupin%blochl_local_ionic_potential%data)
 nullify(paw_setupin%kinetic_energy_differences%data)

end subroutine nullify_paw_setup
!!***

!!****f* ABINIT/copy_paw_setup
!! NAME
!! copy_paw_setup
!!
!! FUNCTION
!!  Copy a paw_setup datastructure into another
!!
!! INPUTS
!!  
!!  paw_setupin<paw_setup_type>=input paw_setup datastructure
!!
!! OUTPUT
!!  paw_setupout<paw_setup_type>=output paw_setup datastructure
!!
!! PARENTS
!!      inpspheads
!!
!! CHILDREN
!!
!! SOURCE

subroutine copy_paw_setup(paw_setupin,paw_setupout)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'copy_paw_setup'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars

 type(paw_setup_t),intent(in) :: paw_setupin
 type(paw_setup_t),intent(out) :: paw_setupout

!Local variables-------------------------------
 integer :: ii,sz1
! *********************************************************************

!scalars
 paw_setupout%version=paw_setupin%version
 paw_setupout%tread=paw_setupin%tread
 paw_setupout%ngrid=paw_setupin%ngrid
 paw_setupout%idgrid=paw_setupin%idgrid
 paw_setupout%atom%tread=paw_setupin%atom%tread
 paw_setupout%atom%symbol=paw_setupin%atom%symbol
 paw_setupout%atom%znucl=paw_setupin%atom%znucl
 paw_setupout%atom%zion=paw_setupin%atom%zion
 paw_setupout%atom%zval=paw_setupin%atom%zval
 paw_setupout%xc_functional%tread=paw_setupin%xc_functional%tread
 paw_setupout%xc_functional%functionaltype=paw_setupin%xc_functional%functionaltype
 paw_setupout%xc_functional%name=paw_setupin%xc_functional%name
 paw_setupout%generator%tread=paw_setupin%generator%tread
 paw_setupout%generator%gen=paw_setupin%generator%gen
 paw_setupout%generator%name=paw_setupin%generator%name
 paw_setupout%valence_states%tread=paw_setupin%valence_states%tread
 paw_setupout%valence_states%nval=paw_setupin%valence_states%nval
 paw_setupout%shape_function%tread=paw_setupin%shape_function%tread
 paw_setupout%shape_function%gtype=paw_setupin%shape_function%gtype
 paw_setupout%shape_function%rc=paw_setupin%shape_function%rc
 paw_setupout%shape_function%lamb=paw_setupin%shape_function%lamb
 paw_setupout%ae_core_density%tread=paw_setupin%ae_core_density%tread
 paw_setupout%ae_core_density%grid=paw_setupin%ae_core_density%grid
 paw_setupout%ae_core_density%state=paw_setupin%ae_core_density%state
 paw_setupout%pseudo_core_density%tread=paw_setupin%pseudo_core_density%tread
 paw_setupout%pseudo_core_density%grid=paw_setupin%pseudo_core_density%grid
 paw_setupout%pseudo_core_density%state=paw_setupin%pseudo_core_density%state
 paw_setupout%pseudo_valence_density%tread=paw_setupin%pseudo_valence_density%tread
 paw_setupout%pseudo_valence_density%grid=paw_setupin%pseudo_valence_density%grid
 paw_setupout%pseudo_valence_density%state=paw_setupin%pseudo_valence_density%state
 paw_setupout%zero_potential%tread=paw_setupin%zero_potential%tread
 paw_setupout%zero_potential%grid=paw_setupin%zero_potential%grid
 paw_setupout%zero_potential%state=paw_setupin%zero_potential%state
 paw_setupout%ae_core_kinetic_energy_density%tread=&
&     paw_setupin%ae_core_kinetic_energy_density%tread
 paw_setupout%ae_core_kinetic_energy_density%grid=&
&     paw_setupin%ae_core_kinetic_energy_density%grid
 paw_setupout%ae_core_kinetic_energy_density%state=&
&     paw_setupin%ae_core_kinetic_energy_density%state
 paw_setupout%pseudo_core_kinetic_energy_density%tread=&
&     paw_setupin%pseudo_core_kinetic_energy_density%tread
 paw_setupout%pseudo_core_kinetic_energy_density%grid=&
&     paw_setupin%pseudo_core_kinetic_energy_density%grid
 paw_setupout%pseudo_core_kinetic_energy_density%state=&
&     paw_setupin%pseudo_core_kinetic_energy_density%state
 paw_setupout%kresse_joubert_local_ionic_potential%tread=&
&    paw_setupin%kresse_joubert_local_ionic_potential%tread
 paw_setupout%kresse_joubert_local_ionic_potential%grid=&
&    paw_setupin%kresse_joubert_local_ionic_potential%grid
 paw_setupout%kresse_joubert_local_ionic_potential%state=&
&    paw_setupin%kresse_joubert_local_ionic_potential%state
 paw_setupout%blochl_local_ionic_potential%tread=&
&    paw_setupin%blochl_local_ionic_potential%tread
 paw_setupout%blochl_local_ionic_potential%grid=&
&    paw_setupin%blochl_local_ionic_potential%grid
 paw_setupout%blochl_local_ionic_potential%state=&
&    paw_setupin%blochl_local_ionic_potential%state
 paw_setupout%kinetic_energy_differences%tread=paw_setupin%kinetic_energy_differences%tread
 paw_setupout%kinetic_energy_differences%grid=paw_setupin%kinetic_energy_differences%grid
 paw_setupout%kinetic_energy_differences%state=paw_setupin%kinetic_energy_differences%state

!pointers
 if (associated(paw_setupin%ae_core_density%data)) then
   sz1=size(paw_setupin%ae_core_density%data,1)
   ABI_ALLOCATE(paw_setupout%ae_core_density%data,(sz1))
   paw_setupout%ae_core_density%data=paw_setupin%ae_core_density%data
 else
   nullify(paw_setupout%ae_core_density%data)
 end if
 if (associated(paw_setupin%pseudo_core_density%data)) then
   sz1=size(paw_setupin%pseudo_core_density%data,1)
   ABI_ALLOCATE(paw_setupout%pseudo_core_density%data,(sz1))
   paw_setupout%pseudo_core_density%data=paw_setupin%pseudo_core_density%data
 else
   nullify(paw_setupout%pseudo_core_density%data)
 end if
 if (associated(paw_setupin%pseudo_valence_density%data)) then
   sz1=size(paw_setupin%pseudo_valence_density%data,1)
   ABI_ALLOCATE(paw_setupout%pseudo_valence_density%data,(sz1))
   paw_setupout%pseudo_valence_density%data=paw_setupin%pseudo_valence_density%data
 else
   nullify(paw_setupout%pseudo_valence_density%data)
 end if
 if (associated(paw_setupin%zero_potential%data)) then
   sz1=size(paw_setupin%zero_potential%data,1)
   ABI_ALLOCATE(paw_setupout%zero_potential%data,(sz1))
   paw_setupout%zero_potential%data=paw_setupin%zero_potential%data
 else
   nullify(paw_setupout%zero_potential%data)
 end if
 if (associated(paw_setupin%ae_core_kinetic_energy_density%data)) then
   sz1=size(paw_setupin%ae_core_kinetic_energy_density%data,1)
   ABI_ALLOCATE(paw_setupout%ae_core_kinetic_energy_density%data,(sz1))
   paw_setupout%ae_core_kinetic_energy_density%data=paw_setupin%ae_core_kinetic_energy_density%data
 else
   nullify(paw_setupout%ae_core_kinetic_energy_density%data)
 end if
 if (associated(paw_setupin%pseudo_core_kinetic_energy_density%data)) then
   sz1=size(paw_setupin%pseudo_core_kinetic_energy_density%data,1)
   ABI_ALLOCATE(paw_setupout%pseudo_core_kinetic_energy_density%data,(sz1))
   paw_setupout%pseudo_core_kinetic_energy_density%data=paw_setupin%pseudo_core_kinetic_energy_density%data
 else
   nullify(paw_setupout%pseudo_core_kinetic_energy_density%data)
 end if
 if (associated(paw_setupin%kresse_joubert_local_ionic_potential%data)) then
   sz1=size(paw_setupin%kresse_joubert_local_ionic_potential%data,1)
   ABI_ALLOCATE(paw_setupout%kresse_joubert_local_ionic_potential%data,(sz1))
   paw_setupout%kresse_joubert_local_ionic_potential%data=paw_setupin%kresse_joubert_local_ionic_potential%data
 else
   nullify(paw_setupout%kresse_joubert_local_ionic_potential%data)
 end if
 if (associated(paw_setupin%blochl_local_ionic_potential%data)) then
   sz1=size(paw_setupin%blochl_local_ionic_potential%data,1)
   ABI_ALLOCATE(paw_setupout%blochl_local_ionic_potential%data,(sz1))
   paw_setupout%blochl_local_ionic_potential%data=paw_setupin%blochl_local_ionic_potential%data
 else
   nullify(paw_setupout%blochl_local_ionic_potential%data)
 end if
 if (associated(paw_setupin%kinetic_energy_differences%data)) then
   sz1=size(paw_setupin%kinetic_energy_differences%data,1)
   ABI_ALLOCATE(paw_setupout%kinetic_energy_differences%data,(sz1))
   paw_setupout%kinetic_energy_differences%data=paw_setupin%kinetic_energy_differences%data
 else
   nullify(paw_setupout%kinetic_energy_differences%data)
 end if
 if(associated( paw_setupin%radial_grid)) then
   sz1=size(paw_setupin%radial_grid,1)
   ABI_DATATYPE_ALLOCATE(paw_setupout%radial_grid,(sz1))
   paw_setupout%radial_grid=paw_setupin%radial_grid
 else
   nullify(paw_setupout%radial_grid)
 end if
 if(associated(paw_setupin%valence_states%state)) then
   sz1=size(paw_setupin%valence_states%state,1)
   ABI_DATATYPE_ALLOCATE(paw_setupout%valence_states%state,(sz1))
   paw_setupout%valence_states%state=paw_setupin%valence_states%state
 else
   nullify(paw_setupout%valence_states%state)
 end if

 if (associated( paw_setupin%ae_partial_wave)) then
   sz1=size(paw_setupin%ae_partial_wave,1)
   ABI_DATATYPE_ALLOCATE(paw_setupout%ae_partial_wave,(sz1))
   do ii=1,paw_setupin%valence_states%nval
     paw_setupout%ae_partial_wave(ii)%tread=paw_setupin%ae_partial_wave(ii)%tread
     paw_setupout%ae_partial_wave(ii)%grid=paw_setupin%ae_partial_wave(ii)%grid
     paw_setupout%ae_partial_wave(ii)%state=paw_setupin%ae_partial_wave(ii)%state
     if(associated( paw_setupin%ae_partial_wave(ii)%data)) then
       sz1=size(paw_setupin%ae_partial_wave(ii)%data,1)
       ABI_ALLOCATE(paw_setupout%ae_partial_wave(ii)%data,(sz1))
       paw_setupout%ae_partial_wave(ii)%data=paw_setupin%ae_partial_wave(ii)%data
     else
       nullify(paw_setupout%ae_partial_wave(ii)%data)
     end if
   end do
 else
   nullify(paw_setupout%ae_partial_wave)
 end if 
 if (associated( paw_setupin%pseudo_partial_wave)) then
   sz1=size(paw_setupin%pseudo_partial_wave,1)
   ABI_DATATYPE_ALLOCATE(paw_setupout%pseudo_partial_wave,(sz1))
   do ii=1,paw_setupin%valence_states%nval
     paw_setupout%pseudo_partial_wave(ii)%tread=paw_setupin%pseudo_partial_wave(ii)%tread
     paw_setupout%pseudo_partial_wave(ii)%grid=paw_setupin%pseudo_partial_wave(ii)%grid
     paw_setupout%pseudo_partial_wave(ii)%state=paw_setupin%pseudo_partial_wave(ii)%state
     if(associated( paw_setupin%pseudo_partial_wave(ii)%data)) then
       sz1=size(paw_setupin%pseudo_partial_wave(ii)%data,1)
       ABI_ALLOCATE(paw_setupout%pseudo_partial_wave(ii)%data,(sz1))
       paw_setupout%pseudo_partial_wave(ii)%data=paw_setupin%pseudo_partial_wave(ii)%data
     else
       nullify(paw_setupout%pseudo_partial_wave(ii)%data)
     end if
   end do
 else
   nullify(paw_setupout%pseudo_partial_wave)
 end if 
  if (associated( paw_setupin%projector_function)) then
   sz1=size(paw_setupin%projector_function,1)
   ABI_DATATYPE_ALLOCATE(paw_setupout%projector_function,(sz1))
   do ii=1,paw_setupin%valence_states%nval
     paw_setupout%projector_function(ii)%tread=paw_setupin%projector_function(ii)%tread
     paw_setupout%projector_function(ii)%grid=paw_setupin%projector_function(ii)%grid
     paw_setupout%projector_function(ii)%state=paw_setupin%projector_function(ii)%state
     if(associated( paw_setupin%projector_function(ii)%data)) then
       sz1=size(paw_setupin%projector_function(ii)%data,1)
       ABI_ALLOCATE(paw_setupout%projector_function(ii)%data,(sz1))
       paw_setupout%projector_function(ii)%data=paw_setupin%projector_function(ii)%data
     else
       nullify(paw_setupout%projector_function(ii)%data)
     end if
   end do
 else
   nullify(paw_setupout%projector_function)
 end if 

end subroutine copy_paw_setup
!!***


!!****f* m_xml_pawpseudo/ddie_
!! NAME
!! die_
!!
!! FUNCTION
!!  If there is an error in reading of XML file, stop with an error message
!!
!! INPUTS
!!   str = error message string, for output before dying.
!!
!! OUTPUT
!!
!! TODO
!!  Use a generic abinit routine instead of this local one.
!!
!! PARENTS
!!      m_xml_pseudo
!!
!! CHILDREN
!!
!! SOURCE
subroutine ddie_(str)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'ddie_'
!End of the abilint section

      character(len=*), intent(in), optional   :: str
      if (present(str)) then
         write(unit=0,fmt="(a)") trim(str)
      end if
      write(unit=0,fmt="(a)") "Stopping Program"
      stop
end subroutine ddie_
#endif

end module m_xml_pawpseudo
!!***
