!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_abimover
!! NAME
!! m_abimover
!!
!! FUNCTION
!! This module contains definition the type abimover
!! and its related routines
!!
!! Datatypes :
!!
!! * abimover_specs     :
!!
!!
!!
!! Subroutines :
!!
!!
!!
!! COPYRIGHT
!! Copyright (C) 2001-2012 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

module m_abimover

 use m_profiling
 use defs_basis

 implicit none

 private

 public ::              &
      abimover,         &
      abimover_specs,   &
      abiforstr,        &
      mttk_type,        &
      ab_xfh_type,      &
      go_angles,        &
      go_bonds,         &
      delocint,         &
      abimover_ini,     &
      abimover_fin,     &
      abimover_nullify, &
      abiforstr_ini,    &
      abiforstr_fin,    &
      delocint_nullify, &
      delocint_fin,     &
      mttk_ini,         &
      mttk_fin,         &
      mover_AFTER,      &
      mover_BEFORE


 integer, parameter :: mover_BEFORE=0
 integer, parameter :: mover_AFTER=1

!!***

!----------------------------------------------------------------------

!!****t* m_abimover/delocint
!! NAME
!! delocint
!!
!! FUNCTION
!! Datatype with the important variables in pred_delocint
!!
!! NOTES
!!
!!   deloc <type(delocint)>=Important variables for
!!   |                           pred_delocint
!!   |
!!   | nang     = Number of angles
!!   | nbond    = Number of bonds
!!   | ncart    = Number of cartesian directions
!!   |             (used for constraints)
!!   | ndihed   = Number of dihedrals
!!   | nrshift  = Dimension of rshift
!!   | ninternal= Number of internal coordinates
!!   |            ninternal=nbond+nang+ndihed+ncart
!!   |
!!   | angs(2,3,nang)  = Indexes to characterize angles
!!   | bonds(2,2,nbond)= For a bond between iatom and jatom
!!   |                   bonds(1,1,nbond) = iatom
!!   |                   bonds(2,1,nbond) = icenter
!!   |                   bonds(1,2,nbond) = jatom
!!   |                   bonds(2,2,nbond) = irshift
!!   | carts(2,ncart)  = Index of total primitive internal,
!!   |                   and atom (carts(2,:))
!!   | dihedrals(2,4,ndihed)= Indexes to characterize dihedrals
!!   |
!!   | rshift(3,nrshift)= Shift in xred that must be done to find
!!   |                    all neighbors of a given atom within a
!!   |                    given number of neighboring shells
!!
!! SOURCE

type delocint

! scalars
 integer :: nang
 integer :: nbond
 integer :: ncart
 integer :: ndihed
 integer :: nrshift
 integer :: ninternal

! arrays
 integer,pointer :: angs(:,:,:)
 integer,pointer :: bonds(:,:,:)
 integer,pointer :: carts(:,:)
 integer,pointer :: dihedrals(:,:,:)
 real(dp),pointer :: rshift(:,:)

end type delocint
!!***

!----------------------------------------------------------------------

!!****t* m_abimover/abimover
!! NAME
!! abimover
!!
!! FUNCTION
!! This datatype has the purpouse of store all the data taked
!! usually from dtset needed for the different predictors
!! to update positions, acell, etc.
!!
!! NOTES
!!  At present 32 variables are present in abimover
!!  if a new variable is added in abimover it should
!!  be added also for nullify in abimover_nullify
!!
!! STATS
!!  integer         => 13
!!  real            =>  7
!!  integer array   =>  4
!!  real array      =>  6
!!  character array =>  1
!!  structures      =>  1
!!  TOTAL              34
!!
!! SOURCE

type abimover

! scalars
! Delay of Permutation (Used by pred_langevin only)
integer,pointer  :: delayperm
! DIIS memory (Used by pred_diisrelax only)
integer,pointer  :: diismemory
! Geometry Optimization Precondition option
integer,pointer  :: goprecon
! include a JELLium SLAB in the cell
integer,pointer  :: jellslab
! Number of ATOMs
integer,pointer  :: natom
! Number of CONstraint EQuations
integer,pointer  :: nconeq
! Use by pred_isothermal only
integer,pointer  :: nnos
! Number of SYMmetry operations
integer,pointer  :: nsym
! Number of Types of atoms
integer,pointer  :: ntypat
! OPTimize the CELL shape and dimensions
integer,pointer  :: optcell
! RESTART Xcart and Fred
integer,pointer  :: restartxf
! Sign of Permutation (Used by pred_langevin only)
integer,pointer  :: signperm
! Ion movement
integer,pointer  :: ionmov

! Use by pred_isothermal only
real(dp),pointer :: bmass
! Delta Time for IONs
real(dp),pointer :: dtion
! Used by pred_langevin only
real(dp),pointer :: friction
! Used by pred_langevin only
real(dp),pointer :: mdwall
! Used by pred_nose only
real(dp),pointer :: noseinert
! STRess PRECONditioner
real(dp),pointer :: strprecon
! VIScosity
real(dp),pointer :: vis

! arrays
! Indices of AToms that are FIXed
integer,pointer  :: iatfix(:,:)         ! iatfix(3,natom)
! SYMmetry in REaL space
integer,pointer  :: symrel(:,:,:)       ! symrel(3,3,nsym)
! TYPe of ATom
integer,pointer  :: typat(:)            ! typat(natom)
! PRTint ATom LIST
integer,pointer  :: prtatlist(:)        ! prtatlist(natom)

! Mass of each atom (NOT IN DTSET)
real(dp),pointer :: amass(:)            ! amass(natom)
! Geometry Optimization Preconditioner PaRaMeters
real(dp),pointer :: goprecprm(:)
! Molecular Dynamics Initial and Final Temperature
real(dp),pointer :: mdtemp(:)           ! mdtemp(2) (initial,final)
! STRess TARGET
real(dp),pointer :: strtarget(:)        ! strtarget(6)
! Use by pred_isothermal only
real(dp),pointer :: qmass(:)
! Z number of each NUCLeus
real(dp),pointer :: znucl(:)            ! znucl(npsp)

! Filename for Hessian matrix
character(len=fnlen), pointer :: fnameabi_hes
! Filename for _HIST file
character(len=fnlen), pointer :: filnam_ds(:)   ! dtfil%filnam_ds(5)

! structure for delocalized internal coordinates
type(delocint) :: deloc

end type abimover
!!***

!----------------------------------------------------------------------

 type abimover_specs

    !scalars
    integer           :: ncycle
    character(len=8)  :: crit4xml
    character(len=10) :: type4xml
    character(len=60) :: method
    logical :: isFconv ! If the convergence is needed
    logical :: isARused
    logical :: isVused

 end type abimover_specs
!!***

!----------------------------------------------------------------------

!!****t* m_abimover/mttk_type
!! NAME
!! mttk_type
!!
!! FUNCTION
!! For Martyna et al. (TTK) reversible MD integration scheme and related data
!!
!! SOURCE

 type mttk_type

! WARNING : if you modify this datatype, please check whether there might be creation/destruction/copy routines,
! declared in another part of ABINIT, that might need to take into account your modification.

!Real (double precision) scalars

   real(dp) :: glogv
    !Logarithm of the volume

   real(dp) :: vlogv
    !Derivative of logv

!Real (double precision) arrays

  real(dp) :: gboxg(3,3)
   !Imbalance in pressure (see paper)

  real(dp) :: vboxg(3,3)
   !Velocity of log rprimd (see paper)

  real(dp), pointer :: glogs(:)
   ! glogs(nnos)
   ! Imbalance of kinetic energy

  real(dp), pointer :: vlogs(:)
   ! vlogs(nnos)
   ! Velocities of thermostat variables

  real(dp), pointer :: xlogs(:)
   ! xlogs(nnos)
   ! Positions of thermostat variables

 end type mttk_type
!!***

!----------------------------------------------------------------------

!!****t* m_abimover/abiforstr
!! NAME
!! abiforstr
!!
!! FUNCTION
!! Store forces, stress and energy, cartesian and reduced forces
!! one scalar for energy and 6 element array for stress
!!
!! NOTES
!!
!! SOURCE

type abiforstr

! scalars
real(dp) :: etotal     ! Total energy
! arrays
real(dp),pointer :: fcart(:,:) ! Cartesian forces
real(dp),pointer :: fred(:,:)  ! Reduced forces
real(dp) :: strten(6)  ! Stress tensor (Symmetrical 3x3 matrix)

end type abiforstr
!!***

!----------------------------------------------------------------------

!!****t* m_abimover/ab_xfh_type
!! NAME
!! ab_xfh_type
!!
!! FUNCTION
!! Datatype with the old structure for storing history
!! used in gstate and brdmin,delocint, and others
!!
!! NOTES
!!
!! This is a transitional structure, to bridge between
!! the old code and the new one base on abihist
!!
!! SOURCE

type ab_xfh_type

!  mxfh = last dimension of the xfhist array
!  nxfh = actual number of (x,f) history pairs, see xfhist array
integer :: nxfh,nxfhr,mxfh

!  xfhist(3,natom+4,2,mxfh) = (x,f) history array, also including
!   rprim and stress
real(dp),pointer :: xfhist(:,:,:,:)

end type ab_xfh_type
!!***

!----------------------------------------------------------------------

!!****t* m_abimover/go_bonds
!! NAME
!! go_bonds
!!
!! FUNCTION
!! Datatype all the information relevant to create
!! bonds between atoms inside and outside the
!! cell
!!
!! NOTES
!!
!!
!! SOURCE

type go_bonds

!scalar
real(dp) :: tolerance ! To decide if consider bond the atom or not
                      ! 1.0 means that only consider values lower
                      ! than the sum of covalent radius

integer  :: nbonds ! Total number of bonds for the system

!arrays

integer,pointer :: nbondi(:)    ! Number of bonds for atom i
integer,pointer :: indexi(:,:)  ! Indices of bonds for atom i
                                ! Positive: Vector from i to j
                                ! Negative: Vector from j to i

real(dp),pointer :: bond_length(:) ! Bond lengths
real(dp),pointer :: bond_vect(:,:) ! Unitary vectors for bonds

end type go_bonds
!!***

!----------------------------------------------------------------------

!!****t* m_abimover/go_angles
!! NAME
!! go_angles
!!
!! FUNCTION
!! Datatype all the information relevant to create
!! angles between atoms inside and outside the
!! cell
!!
!! NOTES
!!
!!
!! SOURCE

type go_angles

!scalar

integer  :: nangles ! Total number of bonds for the system

!arrays

integer,pointer  :: angle_vertex(:)  ! Indices of the vertex atom
real(dp),pointer :: angle_value(:)   ! Value of angle in radians
real(dp),pointer :: angle_bonds(:,:) ! Indices of the bonds
real(dp),pointer :: angle_vect(:,:)  ! Unitary vector perpendicular to the plane

end type go_angles
!!***


!----------------------------------------------------------------------

contains  !=============================================================
!!***


!{\src2tex{textfont=tt}}
!!****f* m_abimover/abimover_ini
!! NAME
!! abimover_ini
!!
!! FUNCTION
!! Initializes the abimover structure
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (DCA, XG, GMR, SE)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! USE OF FFT GRIDS:
!! =================
!! In case of PAW:
!! ---------------
!!    Two FFT grids are used:
!!    - A "coarse" FFT grid (defined by ecut)
!!      for the application of the Hamiltonian on the plane waves basis.
!!      It is defined by nfft, ngfft, mgfft, ...
!!      Hamiltonian, wave-functions, density related to WFs (rhor here), ...
!!      are expressed on this grid.
!!    - A "fine" FFT grid (defined) by ecutdg)
!!      for the computation of the density inside PAW spheres.
!!      It is defined by nfftf, ngfftf, mgfftf, ...
!!      Total density, potentials, ...
!!      are expressed on this grid.
!! In case of norm-conserving:
!! ---------------------------
!!    - Only the usual FFT grid (defined by ecut) is used.
!!      It is defined by nfft, ngfft, mgfft, ...
!!      For compatibility reasons, (nfftf,ngfftf,mgfftf)
!!      are set equal to (nfft,ngfft,mgfft) in that case.
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!
!! SOURCE

subroutine abimover_ini(ab_mover,specs,&
& delayperm,diismemory,goprecon,jellslab,&
& natom,nconeq,nnos,nsym,ntypat,&
& optcell,restartxf,signperm,ionmov,&
& bmass,dtion,friction,mdwall,noseinert,strprecon,vis,&
& iatfix,symrel,typat,prtatlist,amass,goprecprm,mdtemp,strtarget,&
& qmass,znucl,fnameabi_hes,filnam_ds)

!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'abimover_ini'
!End of the abilint section

type(abimover),intent(out) :: ab_mover
type(abimover_specs),intent(out) :: specs
! Delay of Permutation (Used by pred_langevin only)
integer,target, intent(in)  :: delayperm
! DIIS memory (Used by pred_diisrelax only)
integer,target, intent(in)  :: diismemory
! Geometry Optimization Precondition option
integer,target, intent(in)  :: goprecon
! include a JELLium SLAB in the cell
integer,target, intent(in)  :: jellslab
! Number of ATOMs
integer,target, intent(in)  :: natom
! Number of CONstraint EQuations
integer,target, intent(in)  :: nconeq
! Use by pred_isothermal only
integer,target, intent(in)  :: nnos
! Number of SYMmetry operations
integer,target, intent(in)  :: nsym
! Number of Types of atoms
integer,target, intent(in)  :: ntypat
! OPTimize the CELL shape and dimensions
integer,target, intent(in)  :: optcell
! RESTART Xcart and Fred
integer,target, intent(in)  :: restartxf
! Sign of Permutation (Used by pred_langevin only)
integer,target, intent(in)  :: signperm
! Ion movement
integer,target, intent(in)  :: ionmov

! Use by pred_isothermal only
real(dp),target, intent(in) :: bmass
! Delta Time for IONs
real(dp),target, intent(in) :: dtion
! Used by pred_langevin only
real(dp),target, intent(in) :: friction
! Used by pred_langevin only
real(dp),target, intent(in) :: mdwall
! Used by pred_nose only
real(dp),target, intent(in) :: noseinert
! STRess PRECONditioner
real(dp),target, intent(in) :: strprecon
! VIScosity
real(dp),target, intent(in) :: vis

! arrays
! Indices of AToms that are FIXed
integer,target, intent(in)  :: iatfix(:,:)         ! iatfix(3,natom)
! SYMmetry in REaL space
integer,target, intent(in)  :: symrel(:,:,:)       ! symrel(3,3,nsym)
! TYPe of ATom
integer,target, intent(in)  :: typat(:)            ! typat(natom)
! PRTint ATom LIST
integer,target, intent(in)  :: prtatlist(:)        ! prtatlist(natom)

! Mass of each atom (NOT IN DTSET)
real(dp),target, intent(in) :: amass(:)            ! amass(natom)
! Geometry Optimization Preconditioner PaRaMeters
real(dp),target, intent(in) :: goprecprm(:)
! Molecular Dynamics Initial and Final Temperature
real(dp),target, intent(in) :: mdtemp(:)           ! mdtemp(2) (initial,final)
! STRess TARGET
real(dp),target, intent(in) :: strtarget(:)        ! strtarget(6)
! Use by pred_isothermal only
real(dp),target, intent(in) :: qmass(:)
! Z number of each NUCLeus
real(dp),target, intent(in) :: znucl(:)            ! znucl(npsp)

! Filename for Hessian matrix
character(len=fnlen), target, intent(in) :: fnameabi_hes
! Filename for _HIST file
character(len=fnlen), target, intent(in) :: filnam_ds(:)   ! dtfil%filnam_ds(5)


!Local variables-------------------------------
!scalars
!arrays

! ***************************************************************


!write(std_out,*) 'mover 01'
!###########################################################
!### 01. Initialization of indexes and allocations of arrays


!Copy the information from the Dataset (dtset)
!to the ab_mover structure
!Delay of Permutation (Used by pred_langevin only)
 ab_mover%delayperm=>delayperm
!DIIS memory (Use by pred_diisrelax only)
 ab_mover%diismemory=>diismemory
!Geometry Optimization Precondition option
 ab_mover%goprecon=>goprecon
!include a JELLium SLAB in the cell
 ab_mover%jellslab=>jellslab
!Number of ATOMs
 ab_mover%natom=>natom
!Number of CONstraint EQuations
 ab_mover%nconeq=>nconeq
!Use by pred_isothermal only
 ab_mover%nnos=>nnos
!Number of SYMmetry operations
 ab_mover%nsym=>nsym
!Number of Type of atoms
 ab_mover%ntypat=>ntypat
!OPTimize the CELL shape and dimensions
 ab_mover%optcell=>optcell
!RESTART Xcart and Fred
 ab_mover%restartxf=>restartxf
!Sign of Permutation (Used by pred_langevin only)
 ab_mover%signperm=>signperm
!Ion movements
 ab_mover%ionmov=>ionmov

!Use by pred_isothermal only
 ab_mover%bmass=>bmass
!Delta Time for IONs
 ab_mover%dtion=>dtion
!Used by pred_langevin only
 ab_mover%friction=>friction
!Used by pred_langevin only
 ab_mover%mdwall=>mdwall
!NOT DOCUMENTED
 ab_mover%noseinert=>noseinert
!STRess PRECONditioner
 ab_mover%strprecon=>strprecon
!VIScosity
 ab_mover%vis=>vis

!Indices of AToms that are FIXed
 ab_mover%iatfix=>iatfix
!SYMmetry in REaL space
 ab_mover%symrel=>symrel
!TYPe of ATom
 ab_mover%typat=>typat
!PRTint QTom LIST
 ab_mover%prtatlist=>prtatlist

!Mass of each atom (NOT IN DTSET)
 ab_mover%amass=>amass
!Geometry Optimization Preconditioner PaRaMeters
 ab_mover%goprecprm=>goprecprm
!Molecular Dynamics Temperatures
 ab_mover%mdtemp=>mdtemp
!STRess TARGET
 ab_mover%strtarget=>strtarget
!Use by pred_isothermal only
 ab_mover%qmass=>qmass
!Z number of each NUCLeus
 ab_mover%znucl=>znucl

!Filename for Hessian matrix (NOT IN DTSET)
 ab_mover%fnameabi_hes=>fnameabi_hes
!Filename for _HIST file
 ab_mover%filnam_ds=>filnam_ds


!!DEBUG
!call abimover_print(ab_mover,ab_out)
!!DEBUG

!write(std_out,*) 'mover 02'
!###########################################################
!### 02. Particularities of each predictor

!Default values first
!--------------------

!acell and rprimd are never change except if optcell/=0
 if (ab_mover%optcell/=0)then
   specs%isARused=.TRUE.
 else
   specs%isARused=.FALSE.
 end if

!Velocities are never change except for ionmov=1,6,7,8
 specs%isVused=.FALSE.

!In general convergence is needed
 specs%isFconv=.TRUE.

!specs%ncycle is 1 by default except for ionmov=1,9,14
 specs%ncycle=1

!This is the initialization for ionmov==1
!-----------------------------------------
 if(ab_mover%ionmov==1) then
   specs%ncycle=4 ! Number of internal cycles for first itime
   specs%isFconv=.FALSE.     ! Convergence is not used for MD
   specs%isVused=.TRUE. ! Velocities are used
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
!  Values use in XML Output
   specs%type4xml='moldyn'
   specs%crit4xml='none'
!  Name of specs%method
   if (abs(ab_mover%vis)<=1.d-8) then
     write(specs%method,'(a)')&
     'Molecular dynamics without viscosity (vis=0)'
   else
     write(specs%method,'(a,1p,e12.5,a)')&
     'Molecular dynamics with viscosity (vis=',&
&     ab_mover%vis,')'
   end if
!  This is the initialization for ionmov==2,3
!  -------------------------------------------
 else if (ab_mover%ionmov==2.or.ab_mover%ionmov==3)then
!  Values use in XML Output
   specs%type4xml='bfgs'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   if (ab_mover%ionmov==2) then
     write(specs%method,'(a)')&
     'Broyden-Fletcher-Goldfard-Shanno method (forces)'
   else
     write(specs%method,'(a)')&
     'Broyden-Fletcher-Goldfard-Shanno method (forces,Tot energy)'
   end if
!  This is the initialization for ionmov==4,5
!  -------------------------------------------
 else if (ab_mover%ionmov==4.or.ab_mover%ionmov==5)then
!  Values use in XML Output
   specs%type4xml='simple'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   if (ab_mover%ionmov==4) then
     write(specs%method,'(a)')&
     'Conjugate gradient of potential and ionic degrees of freedom'
   else
     write(specs%method,'(a)')&
     'Simple relaxation of ionic positions'
   end if
!  This is the initialization for ionmov==6
!  ------------------------------------------
 else if (ab_mover%ionmov==6)then
   specs%isFconv=.FALSE.     ! Convergence is not used for MD
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
   specs%isVused=.TRUE. ! Velocities are used
!  Values use in XML Output
   specs%type4xml='verlet'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Verlet algorithm for molecular dynamics'
!  This is the initialization for ionmov==7
!  ------------------------------------------
 else if (ab_mover%ionmov==7)then
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
   specs%isVused=.TRUE. ! Velocities are used
!  Values use in XML Output
   specs%type4xml='verlet'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Verlet algorithm blocking every atom where dot(vel,force)<0'
!  This is the initialization for ionmov==8
!  ------------------------------------------
 else if (ab_mover%ionmov==8)then
   specs%isVused=.TRUE.
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
!  Values use in XML Output
   specs%type4xml='nose'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Verlet algorithm with a nose-hoover thermostat'
!  This is the initialization for ionmov==9
!  ------------------------------------------
 else if (ab_mover%ionmov==9)then
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
   specs%isVused=.TRUE.  ! Velocities are used
   specs%ncycle=3
!  Values use in XML Output
   specs%type4xml='langevin'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Langevin molecular dynamics'
!  This is the initialization for ionmov==10
!  -------------------------------------------
 else if (ab_mover%ionmov==10)then
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
!  Values use in XML Output
   specs%type4xml='delocint'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'BFGS with delocalized internal coordinates'
!  This is the initialization for ionmov==11
!  -------------------------------------------
 else if (ab_mover%ionmov==11)then
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
!  Values use in XML Output
   specs%type4xml='cg'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Conjugate gradient algorithm'
!  This is the initialization for ionmov==12
!  -------------------------------------------
 else if (ab_mover%ionmov==12)then
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
   specs%isVused=.TRUE.  ! Velocities are used
!  Values use in XML Output
   specs%isFconv=.FALSE.      ! Convergence is not used for MD
   specs%type4xml='isokin'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Isokinetic ensemble molecular dynamics'
!  This is the initialization for ionmov==13
!  -------------------------------------------
 else if (ab_mover%ionmov==13)then
!  optcell is allow
   specs%isARused=.TRUE. ! RPRIMD and ACELL may change
   specs%isVused=.TRUE.  ! Velocities are used
   specs%isFconv=.FALSE.      ! Convergence is not used for MD
!  Values use in XML Output
   specs%type4xml='isother'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Isothermal/isenthalpic ensemble molecular dynamics'
!  This is the initialization for ionmov==14
!  -------------------------------------------
 else if (ab_mover%ionmov==14)then
   specs%ncycle=16
   specs%isFconv=.FALSE.     ! Convergence is not used for MD
   specs%isVused=.TRUE. ! Velocities are used
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
!  Values use in XML Output
   specs%type4xml='srkna14'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Symplectic algorithm Runge-Kutta-Nystrom SRKNa14'
!  This is the initialization for ionmov==20
!  -------------------------------------------
 else if (ab_mover%ionmov==20)then
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
!  Values use in XML Output
   specs%type4xml='diisrelax'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Ionic positions relaxation using DIIS'
!  This is the initialization for ionmov==21
!  -------------------------------------------
 else if (ab_mover%ionmov==21)then
   specs%isARused=.TRUE.
!  Values use in XML Output
   specs%type4xml='steepdesc'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Steepest descend algorithm'
!  This is the initialization for ionmov==30
!  -------------------------------------------
 else if (ab_mover%ionmov==30)then
!  TEMPORARLY optcell is not allow
   specs%isARused=.FALSE.
!  Values use in XML Output
   specs%type4xml='scphon'
   specs%crit4xml='tolmxf'
!  Name of specs%method
   write(specs%method,'(a)')&
   'Self consistent phonon structure using a supercell'
 end if

end subroutine abimover_ini
!!***

!!****f* m_abimover/delocint_nullify
!!
!! NAME
!! delocint_nullify
!!
!! FUNCTION
!! nullify function for delocalized internals object
!!
!! INPUT
!! deloc= container object for delocalized internal coordinates
!!
!! OUTPUT
!!
!! PARENTS
!!      m_abimover
!!
!! CHILDREN
!!
!! SOURCE

subroutine delocint_nullify(deloc)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'delocint_nullify'
!End of the abilint section

  type(delocint), intent(out) :: deloc

  nullify(deloc%angs)
  nullify(deloc%bonds)
  nullify(deloc%carts)
  nullify(deloc%dihedrals)
  nullify(deloc%rshift)

end subroutine delocint_nullify
!!***

!----------------------------------------------------------------------

!!****f* m_abimover/delocint_fin
!!
!! NAME
!! delocint_fin
!!
!! FUNCTION
!! destructor function for delocint object
!!
!! INPUT
!! deloc= container object for delocalized internal coordinates
!!
!! OUTPUT
!!
!! PARENTS
!!      m_abimover
!!
!! CHILDREN
!!
!! SOURCE

subroutine delocint_fin(deloc)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'delocint_fin'
!End of the abilint section

  type(delocint), intent(out) :: deloc

  if(associated(deloc%angs))  then
    ABI_DEALLOCATE(deloc%angs)
  end if
  if(associated(deloc%bonds))  then
    ABI_DEALLOCATE(deloc%bonds)
  end if
  if(associated(deloc%carts))  then
    ABI_DEALLOCATE(deloc%carts)
  end if
  if(associated(deloc%dihedrals))  then
    ABI_DEALLOCATE(deloc%dihedrals)
  end if
  if(associated(deloc%rshift))  then
    ABI_DEALLOCATE(deloc%rshift)
  end if

end subroutine delocint_fin
!!***

!----------------------------------------------------------------------

!!****f* m_abimover/abimover_nullify
!! NAME
!! abimover_nullify
!!
!! FUNCTION
!! Nullify all the pointers in a ab_mover
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  ab_mover <type(abimover)> = The ab_mover to nullify
!!
!! PARENTS
!!      m_abimover,mover
!!
!! CHILDREN
!!
!! NOTES
!!  At present 32 variables are present in abimover
!!  if a new variable is added in abimover it should
!!  be added also for nullify here
!!
!! STATS
!!  integer         => 13
!!  real            =>  7
!!  integer array   =>  4
!!  real array      =>  6
!!  character array =>  1
!!  structures      =>  1
!!  TOTAL              32
!!
!! SOURCE

subroutine abimover_nullify(ab_mover)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'abimover_nullify'
!End of the abilint section

 type(abimover),intent(inout) :: ab_mover

! ***************************************************************

! Delay of Permutation (Used by pred_langevin only)
 nullify(ab_mover%delayperm)
! Number of Geometry histories (Use by pred_diisrelax only)
 nullify(ab_mover%diismemory)
! Geometry Optimization precondition option
 nullify(ab_mover%goprecon)
! include a JELLium SLAB in the cell
 nullify(ab_mover%jellslab)
! Number of ATOMs
 nullify(ab_mover%natom)
! Number of CONstraint EQuations
 nullify(ab_mover%nconeq)
! Use by pred_isothermal only
 nullify(ab_mover%nnos)
! Number of SYMmetry operations
 nullify(ab_mover%nsym)
! Number of Types of atoms
 nullify(ab_mover%ntypat)
! OPTimize the CELL shape and dimensions
 nullify(ab_mover%optcell)
! RESTART Xcart and Fred
 nullify(ab_mover%restartxf)
! Sign of Permutation (Used by pred_langevin only)
 nullify(ab_mover%signperm)
! Ion movement
 nullify(ab_mover%ionmov)

! Use by pred_isothermal only
 nullify(ab_mover%bmass)
! Delta Time for IONs
 nullify(ab_mover%dtion)
! Used by pred_langevin only
 nullify(ab_mover%friction)
! Used by pred_langevin only
 nullify(ab_mover%mdwall)
! NOT DOCUMENTED
 nullify(ab_mover%noseinert)
! STRess PRECONditioner
 nullify(ab_mover%strprecon)
! VIScosity
 nullify(ab_mover%vis)

!arrays
! Indices of AToms that are FIXed
 nullify(ab_mover%iatfix)
! SYMmetry in REaL space
 nullify(ab_mover%symrel)
! TYPe of ATom
 nullify(ab_mover%typat)
! TYPe of ATom
 nullify(ab_mover%prtatlist)

! Mass of each atom (NOT IN DTSET)
 nullify(ab_mover%amass)!
! Molecular Dynamics Initial Temperature
 nullify(ab_mover%mdtemp)
! STRess TARGET
 nullify(ab_mover%strtarget)
! Use by pred_isothermal only
 nullify(ab_mover%qmass)
! Z number of each NUCLeus
 nullify(ab_mover%znucl)
! Geometry Optimization Preconditioner PaRaMeters
 nullify(ab_mover%goprecprm)

! Filename for Hessian matrix
 nullify(ab_mover%fnameabi_hes)
! Filename for _HIST file
 nullify(ab_mover%filnam_ds)

 call delocint_nullify(ab_mover%deloc)

end subroutine abimover_nullify
!!***

!----------------------------------------------------------------------

!!****f* m_abimover/abimover_fin
!! NAME
!! abimover_fin
!!
!! FUNCTION
!! Deallocate all the pointers in a ab_mover
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  ab_mover <type(abimover)> = The ab_mover to destroy
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!
!! NOTES
!!  At present 32 variables are present in abimover
!!  if a new variable is added in abimover it should
!!  be added also for deallocate here
!!
!! STATS
!!  integer         => 13
!!  real            =>  7
!!  integer array   =>  4
!!  real array      =>  6
!!  character array =>  1
!!  structures      =>  1
!!  TOTAL              32
!!
!! SOURCE

subroutine abimover_fin(ab_mover)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'abimover_fin'
!End of the abilint section

 type(abimover),intent(inout) :: ab_mover

! ***************************************************************

 call delocint_fin(ab_mover%deloc)

! ab_mover is only pointer associated to other data, except possibly amass.
! TODO: check for amass in mover.F90
 call abimover_nullify(ab_mover)

end subroutine abimover_fin
!!***

!----------------------------------------------------------------------

!!****f* defs_mover/abimover_print
!! NAME
!! abimover_print
!!
!! FUNCTION
!! Print all the variables in a ab_mover
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  ab_mover <type(abimover)> = The ab_mover to nullify
!!
!! PARENTS
!!
!! CHILDREN
!!
!! NOTES
!!  At present 29 variables are present in abimover
!!  if a new variable is added in abimover it should
!!  be added also for print here
!!
!! SOURCE

subroutine abimover_print(ab_mover,iout)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'abimover_print'
!End of the abilint section

 type(abimover),intent(inout) :: ab_mover
 integer,intent(in) :: iout

!Local variables-------------------------------
!arrays
character(len=1200) :: message
character(len=110)   :: fmt

! ***************************************************************

fmt='(a,e12.5,a,a,I5,a,a,I5,a,a,I5,a,a,I5,a,a,I5,a,a,I5,a,a,e12.5,a,a,e12.5,a,a,e12.5,a,a,e12.5,a,a,e12.5,a)'

write(message,fmt)&
& 'Delta Time for IONs',ab_mover%dtion,ch10, &
& 'include a JELLium SLAB in the cell',ab_mover%jellslab,ch10, &
& 'Number of ATOMs',ab_mover%natom,ch10, &
& 'Number of CONstraint EQuations',ab_mover%nconeq,ch10, &
& 'Number of SYMmetry operations',ab_mover%nsym,ch10, &
& 'OPTimize the CELL shape and dimensions',ab_mover%optcell,ch10, &
& 'RESTART Xcart and Fred',ab_mover%restartxf,ch10, &
& 'Molecular Dynamics Initial Temperature',ab_mover%mdtemp(1),ch10, &
& 'Molecular Dynamics Final Temperature',ab_mover%mdtemp(2),ch10, &
& 'NOT DOCUMENTED',ab_mover%noseinert,ch10, &
& 'STRess PRECONditioner',ab_mover%strprecon,ch10, &
& 'VIScosity',ab_mover%vis,ch10

! ! arrays
! ! Indices of AToms that are FIXed
! integer,  pointer :: iatfix(:,:)
! ! SYMmetry in REaL space
! integer,  pointer :: symrel(:,:,:)
! ! Mass of each atom (NOT IN DTSET)
! real(dp), pointer :: amass(:)
! ! STRess TARGET
! real(dp), pointer :: strtarget(:)
! Filename for Hessian matrix
! character(len=fnlen), pointer :: fnameabi_hes

 write(iout,*) 'CONTENTS of ab_mover'
 write(iout,'(a)') message

end subroutine abimover_print
!!***

!----------------------------------------------------------------------

!!****f* m_abimover/mttk_ini
!!
!! NAME
!! mttk_ini
!!
!! FUNCTION
!! destructor function for mttk object
!!
!! INPUT
!! mttk
!!
!! OUTPUT
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!
!! SOURCE

subroutine mttk_ini(mttk_vars,nnos)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'mttk_ini'
!End of the abilint section

  type(mttk_type), intent(out) :: mttk_vars
  integer,         intent(in)  :: nnos

  ABI_ALLOCATE(mttk_vars%glogs,(nnos))
  ABI_ALLOCATE(mttk_vars%vlogs,(nnos))
  ABI_ALLOCATE(mttk_vars%xlogs,(nnos))

end subroutine mttk_ini
!!***

!----------------------------------------------------------------------

!!****f* m_abimover/mttk_fin
!!
!! NAME
!! mttk_fin
!!
!! FUNCTION
!! destructor function for mttk object
!!
!! INPUT
!! mttk
!!
!! OUTPUT
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!
!! SOURCE

subroutine mttk_fin(mttk_vars)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'mttk_fin'
!End of the abilint section

  type(mttk_type), intent(inout) :: mttk_vars

  if(associated(mttk_vars%glogs))  then
   ABI_DEALLOCATE(mttk_vars%glogs)
  end if
  if(associated(mttk_vars%vlogs))  then
   ABI_DEALLOCATE(mttk_vars%vlogs)
  end if
  if(associated(mttk_vars%xlogs))  then
   ABI_DEALLOCATE(mttk_vars%xlogs)
  end if

end subroutine mttk_fin
!!***

!----------------------------------------------------------------------

!!****f* m_abimover/abiforstr_ini
!!
!! NAME
!! abiforstr_ini
!!
!! FUNCTION
!! destructor function for abiforstr object
!!
!! INPUT
!! forstr
!!
!! OUTPUT
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!
!! SOURCE

subroutine abiforstr_ini(forstr,natom)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'abiforstr_ini'
!End of the abilint section

  type(abiforstr), intent(out) :: forstr
  integer,              intent(in)  :: natom

  ABI_ALLOCATE(forstr%fcart,(3,natom))
  ABI_ALLOCATE(forstr%fred,(3,natom))

end subroutine abiforstr_ini
!!***

!----------------------------------------------------------------------

!!****f* m_abimover/abiforstr_fin
!!
!! NAME
!! abiforstr_fin
!!
!! FUNCTION
!! destructor function for abiforstr object
!!
!! INPUT
!! forstr
!!
!! OUTPUT
!!
!! PARENTS
!!      mover
!!
!! CHILDREN
!!
!! SOURCE

subroutine abiforstr_fin(forstr)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'abiforstr_fin'
!End of the abilint section

  type(abiforstr), intent(inout) :: forstr

  if(associated(forstr%fcart))  then
     ABI_DEALLOCATE(forstr%fcart)
  end if
  if(associated(forstr%fred))  then
     ABI_DEALLOCATE(forstr%fred)
  end if

end subroutine abiforstr_fin
!!***

end module m_abimover
!!***
