!!****f* defs_wvltypes/wvl_descr_atoms_set_sym
!!
!! NAME
!! wvl_descr_atoms_set_sym
!!
!! FUNCTION
!! Add symmetry information to  wvl%atoms data structure.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2012 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! acell(3)=unit cell length scales (bohr)
!! dtset <type(dataset_type)>=all input variables for this dataset
!!
!! OUTPUT
!! wvl <type(wvl_internal_type)>= wavelet type
!!                 | nat      =  number of atoms
!!                 | ntypes   =  number of species
!!                 | alat1    =  acell(1)
!!                 | alat2    =  acell(2)
!!                 | alat3    =  acell(3)
!!                 | iatype   =  types for atoms
!!                 | lfrztyp  =  flag for the movement of atoms.
!!                 | natpol   =  integer related to polarisation at the first step
!!
!! PARENTS
!!      gstate
!!
!! CHILDREN
!!      atoms_set_symmetries,symmetry_set_n_sym,wrtout,xred2xcart
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine wvl_descr_atoms_set_sym(wvl, efield, irrzon, natom, nsym, phnons, &
           & rprimd, symafm, symrel, tnons, tolsym, xred)

 use m_profiling

  use defs_basis
  use defs_wvltypes
  use m_ab6_symmetry

#if defined HAVE_DFT_BIGDFT
 use BigDFT_API, only: atoms_set_symmetries
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'wvl_descr_atoms_set_sym'
 use interfaces_14_hidewrite
 use interfaces_41_geometry
!End of the abilint section

  implicit none

!Arguments ------------------------------------
!scalars
  integer, intent(in)                    :: nsym, natom
  real(dp), intent(in)                   :: tolsym
  type(wvl_internal_type), intent(inout) :: wvl
  !arrays
  integer, intent(in)                    :: symafm(3,3,nsym), symrel(3,3,nsym)
  integer, target, intent(in)            :: irrzon(:,:,:)
  real(dp), target, intent(in)           :: phnons(:,:,:)
  real(dp), intent(in)                   :: efield(3), tnons(3,nsym), rprimd(3,3)
  real(dp), intent(inout)                :: xred(3,natom)

!Local variables-------------------------------
!scalars
#if defined HAVE_DFT_BIGDFT
  integer :: errno
#endif
 character(len=500) :: message
 real(dp),allocatable :: xcart(:,:)

! *********************************************************************

 write(message, '(a,a)' ) ch10,&
& ' wvl_descr_atoms_set_sym: Create symmetries for the wvl%atoms object.'
 call wrtout(std_out,message,'COLL')

!Store xcart for each atom
 ABI_ALLOCATE(xcart,(3, natom))
 call xred2xcart(natom, rprimd, xcart, xred)

#if defined HAVE_DFT_BIGDFT
 wvl%atoms%sym%symObj = -1
 nullify(wvl%atoms%sym%irrzon)
 nullify(wvl%atoms%sym%phnons)
 call atoms_set_symmetries(wvl%atoms, xcart, (nsym <= 1), tolsym, efield)
 if (nsym > 1) then
   call symmetry_set_n_sym(wvl%atoms%sym%symObj, nsym, symrel, tnons, symafm, errno)
 end if
 wvl%atoms%sym%irrzon => irrzon
 wvl%atoms%sym%phnons => phnons
#endif  

!Deallocations
 ABI_DEALLOCATE(xcart)
end subroutine wvl_descr_atoms_set_sym
!!***
