!{\src2tex{textfont=tt}}
!!****f* ABINIT/matcginv_dpc
!! NAME
!! matcginv_dpc
!!
!! FUNCTION
!! Invert a general matrix of complex elements.
!!
!! COPYRIGHT
!! Copyright (C) 2001-2012 ABINIT group (GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! lda=leading dimension of complex matrix a
!! n=size of complex matrix a
!! a=matrix of complex elements
!! OUTPUT
!! a=inverse of a input matrix
!! SIDE EFFECTS
!! a(lda,n)= array of complex elements, input, inverted at output
!!
!!
!! PARENTS
!!      m_matlu,m_matrix,m_oper
!!
!! CHILDREN
!!      zgetrf,zgetri
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine matcginv_dpc(a,lda,n)

 use defs_basis
 use m_linalg_interfaces
 use m_errors
 use m_profiling

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'matcginv_dpc'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: lda,n
!arrays
 complex(dpc),intent(inout) :: a(lda,n)

!Local variables-------------------------------
!scalars
 integer :: ierr,nwork
 character(len=500) :: message
!arrays
 integer :: ipvt(n)
 complex(dpc),allocatable :: work(:)

! *************************************************************************

 nwork=n

 ABI_ALLOCATE(work,(nwork))

 call zgetrf(n,n,a,lda,ipvt,ierr)
 if(ierr/=0) then
   write(message,'(5a,i4,2a)')&
&   '  The matrix that has been passed in argument of this subroutine',ch10,&
&   '  is probably either singular or nearly singular.',ch10,&
&   '  The LAPACK routine zgetrf failed.',ierr,ch10,&
&   '  Action : Contact ABINIT group '
   MSG_ERROR(message)
 end if
 call zgetri(n,a,n,ipvt,work,n,ierr)
 if(ierr/=0) then
   write(message,'(7a)')&
&   '  The matrix that has been passed in argument of this subroutine',ch10,&
&   '  is probably either singular or nearly singular.',ch10,&
&   '  The LAPACK routine zgetri failed.',ch10,&
&   '  Action : Contact ABINIT group '
   MSG_ERROR(message)
 end if

 ABI_DEALLOCATE(work)

end subroutine matcginv_dpc
!!***
