!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_xomp
!! NAME
!! m_xomp
!!
!! FUNCTION
!!  Thin wrappers and tools for OpenMP parallelization.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2012 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

MODULE m_xomp

 use defs_basis
#ifdef HAVE_OPENMP
 use omp_lib
#endif

 implicit none

 private
!!***

 public :: xomp_show_info
 public :: xomp_get_max_threads
 public :: xomp_get_thread_num
 public :: xomp_get_num_threads
 public :: xomp_set_num_threads

!----------------------------------------------------------------------

CONTAINS  !=========================================================================================================================


!!****f* m_xomp/xomp_show_info
!! NAME
!!  xomp_show_info
!!
!! FUNCTION
!!  Printout of the most important OMP environment variables.
!!
!! INPUTS
!!  unt=unit number for writing. The named constant dev_null defined in defs_basis can be used to avoid any printing.
!!  [mode_paral]= --optional argument--
!!   'COLL' if all procs are calling the routine with the same message to be written once only. Default.
!!   'PERS' if the procs are calling the routine with different messages each to be written,
!!          or if one proc is calling the routine
!!   "INIT" to change the rank of the master node that prints the message if "COLL" is used.
!!
!! OUTPUT
!!  (only writing)
!!
!! PARENTS
!!      abinit,fftprof,lapackprof
!!
!! CHILDREN
!!      omp_set_num_threads
!!
!! SOURCE

subroutine xomp_show_info(unt,mode_paral)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xomp_show_info'
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments-------------------------
 integer,intent(in) :: unt
 character(len=*),optional,intent(in) :: mode_paral

!Local variables-------------------
 character(len=500) :: msg,my_mode

! *************************************************************************

 my_mode = "COLL"; if (PRESENT(mode_paral)) my_mode = mode_paral

#ifdef HAVE_OPENMP
 write(msg,'(a)')   " ==== OpenMP parallelism is ON ====";                call wrtout(unt,msg,my_mode)
 write(msg,'(a,i0)')"-  Max_threads :        ",xomp_get_max_threads();      call wrtout(unt,msg,my_mode)
 write(msg,'(a,i0)')"-   Num_procs :         ",omp_get_num_procs();         call wrtout(unt,msg,my_mode)
 write(msg,'(a,l1)')"-   Dynamic :           ",omp_get_dynamic();           call wrtout(unt,msg,my_mode)
 write(msg,'(a,l1)')"-   Nested :            ",omp_get_nested();            call wrtout(unt,msg,my_mode)
 !write(msg,'(a,i0)')"-  Thread_limit :      ",omp_get_thread_limit();      call wrtout(unt,msg,my_mode)
 !write(msg,'(a,i0)')"-  Max_active_levels: ",omp_get_max_active_levels(); call wrtout(unt,msg,my_mode)
#else
 write(msg,'(a)')   " ==== OpenMP parallelism is OFF ====";               call wrtout(unt,msg,my_mode)
#endif

 call wrtout(unt,"",my_mode)

end subroutine xomp_show_info
!!***

!----------------------------------------------------------------------

!!****f* m_xomp/xomp_get_max_threads
!! NAME
!!  xomp_get_max_threads
!!
!! FUNCTION
!!  Wrapper for omp_get_max_threads.
!!
!! INPUTS
!!
!! OUTPUT
!!  Return the maximum number of threads used for the current parallel region that
!!  does not use the clause num_threads. Return 1 if OMP is disabled.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

function xomp_get_max_threads()


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xomp_get_max_threads'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer :: xomp_get_max_threads

! *************************************************************************

#ifdef HAVE_OPENMP
 xomp_get_max_threads = omp_get_max_threads()
#else
 xomp_get_max_threads = 1
#endif

end function xomp_get_max_threads
!!***

!----------------------------------------------------------------------

!!****f* m_xomp/xomp_get_thread_num
!! NAME
!!  xomp_get_thread_num
!!
!! FUNCTION
!!  Wrapper for omp_get_thread_num
!!  Returns a unique thread identification number within the current team.
!!  In a sequential parts of the program, omp_get_thread_num always returns 0.
!!  In parallel regions the return value varies from 0 to omp_get_num_threads-1 inclusive.
!!  The return value of the master thread of a team is always 0.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

function xomp_get_thread_num()


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xomp_get_thread_num'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer :: xomp_get_thread_num

! *************************************************************************

#ifdef HAVE_OPENMP
 xomp_get_thread_num = omp_get_thread_num()
#else
 xomp_get_thread_num = 0
#endif

end function xomp_get_thread_num
!!***

!----------------------------------------------------------------------

!!****f* m_xomp/xomp_get_num_threads
!! NAME
!!  xomp_get_num_threads
!!
!! FUNCTION
!!  Wrapper for omp_get_num_threads.
!!  The omp_get_num_threads function returns the number of threads in the team currently executing
!!  the parallel region from which it is called. The function binds to the closest enclosing PARALLEL directive.
!!  The omp_set_num_threads subroutine and the OMP_NUM_THREADS environment variable control the number of threads in a team.
!!  If you do not explicitly set the number of threads, the run-time environment will use the number of online processors
!!  on the machine by default. If you call omp_get_num_threads from a serial portion of your program or from a
!!  nested parallel region that is serialized, the function returns 1.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

function xomp_get_num_threads()


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xomp_get_num_threads'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer :: xomp_get_num_threads

! *************************************************************************

#ifdef HAVE_OPENMP
 xomp_get_num_threads = omp_get_num_threads()
#else
 xomp_get_num_threads = 0
#endif

end function xomp_get_num_threads
!!***

!----------------------------------------------------------------------

!!****f* m_xomp/xomp_set_num_threads
!! NAME
!!  xomp_set_num_threads
!!
!! FUNCTION
!!  Specifies the number of threads used by default in subsequent parallel sections,
!!  if those do not specify a num_threads clause. The argument of xomp_set_num_threads shall be a positive integer.
!!
!! INPUTS
!!  nthreads = number of threads
!!
!! SIDE EFFECTS
!!  See description.
!!
!! PARENTS
!!      m_fft_prof
!!
!! CHILDREN
!!      omp_set_num_threads
!!
!! SOURCE

subroutine xomp_set_num_threads(nthreads)

 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xomp_set_num_threads'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nthreads

! *************************************************************************

#ifdef HAVE_OPENMP
 call omp_set_num_threads(nthreads)
#else
 if (.FALSE.) write(std_out,*) nthreads
#endif

end subroutine xomp_set_num_threads
!!***

!----------------------------------------------------------------------

END MODULE m_xomp
!!***
