!{\src2tex{textfont=tt}}
!!****f* ABINIT/sec2str
!! NAME
!!  sec2str
!!
!! FUNCTION
!!  Convert time data in seconds to string
!!
!! COPYRIGHT
!!  Copyright (C) 1998-2012 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   time_s=Time in seconds
!!
!! OUTPUT
!!   string with time displayed in the form: "days: ?, hours: ?, minutes: ?, seconds: ?"
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

function sec2str(time_s) result(str)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'sec2str'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp),intent(in) :: time_s
 character(len=500) :: str

!Local variables-------------------------------
 integer :: days,hours,minutes,seconds

! *************************************************************************

 days    = time_s / 86400 
 hours   = MOD(time_s,86400._dp) / 3600
 minutes = MOD(time_s,3600._dp) / 60
 seconds = MOD(time_s,60._dp)

 if (days>0) then
   write(str,'(4(a,i3))')" Days = ",days,", Hours = ",hours,", Minutes = ",minutes,", Seconds = ",seconds
 else if (hours>0) then
   write(str,'(3(a,i3))')" Hours = ",hours,", Minutes = ",minutes,", Seconds = ",seconds
 else if (minutes>0) then
   write(str,'(2(a,i3))')" Minutes = ",minutes,", Seconds = ",seconds
 else
   write(str,'((a,i3))')" Seconds = ",seconds
 end if

end function sec2str
!!***
