!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_xpapi
!! NAME
!! m_xpapi
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2009-2012 ABINIT group (MG,DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

MODULE m_xpapi

 use defs_basis

#ifdef HAVE_FC_ISO_C_BINDING
 use iso_c_binding
#else
 use m_iso_c_binding
#endif

 implicit none

 public

#if defined HAVE_TIMER_PAPI
#include "f90papi.h"
#endif

 public :: xpapi_init
 public :: xpapi_shutdown
!!***

!----------------------------------------------------------------------

CONTAINS  !===========================================================
!!***

!!****f* m_xpapi/xpapi_init
!! NAME
!!  xpapi_init
!!
!! FUNCTION
!!
!! PARENTS
!!      abinit
!!
!! CHILDREN
!!      papif_perror
!!
!! SOURCE

subroutine xpapi_init()

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xpapi_init'
!End of the abilint section

 implicit none

#ifdef HAVE_TIMER_PAPI
!Local variables-------------------------------
 character(len=PAPI_MAX_STR_LEN) :: papi_errstr
 integer(C_INT) :: check
 real(C_FLOAT) :: real_time,proc_time,mflops 
 integer(C_LONG_LONG) :: flpops 

! *************************************************************************

 call PAPIf_library_init(check)

 if ( check /= PAPI_VER_CURRENT .and. check >0 ) then
   write(std_out,*)" PAPI library version mismatch!"
 end if

 if ( check < 0) then
   write(std_out,*)" PAPI Initialization error!"
 end if

! First pass. Set up counters to monitor PAPI_FP_OPS and PAPI_TOT_CYC events and start the counters
! Subsequent calls will read the counters and return total real time, 
! total process time, total floting point instructions or operations 
! since the start of the mesurement and the Mflop/s rate since latests call to PAPI_flops
 call PAPIf_flops(real_time, proc_time, flpops, mflops, check)
 XPAPI_CHECK(check,"Problem in PAPIf_flops")

#endif

end subroutine xpapi_init
!!***

!----------------------------------------------------------------------

!!****f* m_xpapi/xpapi_show_info
!! NAME
!!  xpapi_show_info
!!
!! FUNCTION
!!
!! INPUTS
!!  unt=unit number for writing. The named constant dev_null defined in defs_basis can be used to avoid any printing.
!!  [mode_paral]= --optional argument--
!!   'COLL' if all procs are calling the routine with the same message to be written once only. Default.
!!   'PERS' if the procs are calling the routine with different messages each to be written,
!!          or if one proc is calling the routine
!!
!! PARENTS
!!
!! CHILDREN
!!      papif_perror
!!
!! SOURCE

subroutine xpapi_show_info(unt,mode_paral)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xpapi_show_info'
!End of the abilint section

 implicit none

!Arguments-------------------------
 integer,intent(in) :: unt
 character(len=*),optional,intent(in) :: mode_paral

#ifdef HAVE_TIMER_PAPI
!Local variables-------------------
 integer(C_INT) :: num_hwcntrs,ncpu,nnodes,totalcpus,vendor,model
 real(C_FLOAT) :: revision,mhz
 character(len=PAPI_MAX_STR_LEN) :: vendor_string,model_string
 character(len=500) :: msg,my_mode

! *************************************************************************

 my_mode = "COLL"; if (PRESENT(mode_paral)) my_mode = mode_paral
 write(std_out,*)" PAPI Version ",PAPI_VER_CURRENT

 call PAPIf_num_counters(num_hwcntrs)
 if (num_hwcntrs  < 0) then
   write(std_out,*) " The installation does not support PAPI "
 end if 

 if (num_hwcntrs == 0) then
   write(std_out,*) " The installation supports PAPI, but this machine does not provide hardware counters."
 end if
 
 call PAPIF_get_hardware_info (ncpu, nnodes, totalcpus, vendor, vendor_string, model, model_string, revision, mhz)
#else
 if (.FALSE.) write(unt,*)mode_paral
#endif

end subroutine xpapi_show_info
!!***

!----------------------------------------------------------------------

!!****f* m_xpapi/xpapi_flops
!! NAME
!!  xpapi_flops
!!
!! FUNCTION
!!
!! INPUTS
!!
!! PARENTS
!!
!! CHILDREN
!!      papif_perror
!!
!! SOURCE

subroutine xpapi_flops(real_time, proc_time, flops1, mflops1, check)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xpapi_flops'
!End of the abilint section

 implicit none

!Arguments-------------------------
 integer(C_INT),intent(out) :: check 
 integer(C_LONG_LONG),intent(out) :: flops1
 real(C_FLOAT),intent(out) :: real_time,proc_time,mflops1

!Local variables-------------------

! *************************************************************************

#ifdef HAVE_TIMER_PAPI
 call PAPIf_flops(real_time, proc_time, flops1, mflops1, check)
#endif

end subroutine xpapi_flops
!!***

!----------------------------------------------------------------------

!!****f* m_xpapi/xpapi_shutdown
!! NAME
!!  xpapi_shutdown
!!
!! FUNCTION
!!
!! PARENTS
!!      abinit
!!
!! CHILDREN
!!      papif_perror
!!
!! SOURCE

subroutine xpapi_shutdown()

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xpapi_shutdown'
!End of the abilint section

 implicit none

! *************************************************************************

#ifdef HAVE_TIMER_PAPI
 call PAPIf_shutdown()
#endif

end subroutine xpapi_shutdown
!!***

!----------------------------------------------------------------------

!!****f* m_xpapi/xpapi_handle_error
!! NAME
!!  xpapi_handle_error
!!
!! FUNCTION
!!
!! PARENTS
!!
!! CHILDREN
!!      papif_perror
!!
!! SOURCE

subroutine xpapi_handle_error(check,err_msg,file,line)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xpapi_handle_error'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer(C_INT),intent(in) :: check
 integer,optional,intent(in) :: line
 character(len=*),intent(in) :: err_msg
 character(len=*),optional,intent(in) :: file


!Local variables-------------------------------
 integer :: f90line
 character(len=10) :: lnum
 character(len=500) :: f90name
 character(len=500) :: my_msg
#ifdef HAVE_TIMER_PAPI
 integer(C_INT) :: ierr
 character(len=PAPI_MAX_STR_LEN) :: papi_errstr
#endif

! *************************************************************************

 if (PRESENT(line)) then
   f90line=line
 else 
   f90line=0
 end if
 !call int2char(f90line,lnum)
 write(lnum,'(i0)')f90line

 if (PRESENT(file)) then 
   !f90name = basename(file)
   f90name = file
 else
   f90name='Subroutine Unknown'
 end if
                                            
 my_msg=TRIM(f90name)//":"//TRIM(lnum)//":"

#ifdef HAVE_TIMER_PAPI
 if (check /= PAPI_OK) then
   write(std_out,*) " Error in papi library at: "//TRIM(my_msg)
   write(std_out,*) " User message: "//TRIM(err_msg)
   call papif_perror(check,papi_errstr,ierr)
   write(std_out,*) 'Error code: ',TRIM(papi_errstr)
 end if

 stop  ! FIXME
#else
 if (.FALSE.) then 
   write(std_out,*)err_msg
   write(std_out,*)check
 end if
#endif

end subroutine xpapi_handle_error
!!***

END MODULE m_xpapi
!!***
