!{\src2tex{textfont=tt}}
!!****f* ABINIT/cwtime
!! NAME
!!  cwtime
!!
!! FUNCTION
!!  Timing routine. Returns cpu and wall clock time in seconds.
!!
!! COPYRIGHT
!!  Copyright (C) 1998-2012 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  start_or_stop=
!!    "start" to start the timers
!!    "stop" to stop the timers and return the final cpu_time and wall_time 
!!
!! OUTPUT
!!  cpu= cpu time in seconds
!!  wall= wall clock time in seconds
!!
!! NOTES
!!  Example:
!!  ! Init cpu and wall
!!  call cwtime(cpu,wall,"start")
!! 
!!  do_stuff()
!!
!!  ! stop the counters, return cpu- and wall-time spent in do_stuff()
!!  call cwtime(cpu,wall,"stop")
!!
!! PARENTS
!!      lapackprof,m_abilasi,m_wfk
!!
!! CHILDREN
!!      leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine cwtime(cpu,wall,start_or_stop)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'cwtime'
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_18_timing, except_this_one => cwtime
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp),intent(inout) :: cpu,wall
 character(len=*),intent(in) :: start_or_stop

!Local variables-------------------------------
 character(len=500) :: msg

! *************************************************************************

 if (start_or_stop=="start") then
   cpu = abi_cpu_time()
   wall = abi_wtime()
!  %call xpapi_flops(real_time, proc_time, flops1, mflops1, check)
 else if (start_or_stop=="stop") then
   cpu = abi_cpu_time() - cpu
   wall = abi_wtime() - wall
!  %call xpapi_flops(real_time, proc_time, flops1, mflops1, check)
 else 
   msg = " Wrong option for start_or_stop: "//TRIM(start_or_stop)
   call wrtout(std_out,msg,"COLL")
   call leave_new("COLL")
 end if

end subroutine cwtime
!!***
