!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_cppopts_dumper
!! NAME
!!  m_cppopts_dumper
!!
!! FUNCTION
!!  Displays preprocessing options activated at compile-time.
!!
!! COPYRIGHT
!!  Copyright (C) 2010-2012 ABINIT group (Yann Pouillon)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt.
!!
!! NOTES
!!  This file is generated by make-cppopts-dumper,
!!  on 2013/01/19 13:17:47 +0000.
!!  Any modification will be lost.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module m_cppopts_dumper

  implicit none

  public :: dump_cpp_options

contains
!!***

!!****f* ABINIT/m_cppopts_dumper/dump_cpp_options
!! NAME
!!  dump_cpp_options
!!
!! FUNCTION
!!  Reports a printout of the CPP options used at compile-time,
!!  useful for error messages and debugging.
!!
!! INPUTS
!!  my_unit= Fortran unit number (optional, default is std_out)
!!
!! OUTPUT
!!  Only printing.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

subroutine dump_cpp_options(my_unit)

  use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'dump_cpp_options'
 use interfaces_14_hidewrite
!End of the abilint section

  implicit none

!Arguments -------------------------------------
  integer,optional,intent(in) :: my_unit

!Local variables -------------------------------
  character(len=26) :: tmp
  character(len=80) :: msg
  integer :: msg_index,unt

! **********************************************************************

  unt = std_out
  if ( present(my_unit) ) unt = my_unit

  write(msg,"(a,1x,a)") ch10,repeat("+",78)
  call wrtout(unt,msg,"COLL")
  write(msg,"(1x,a,a)") "CPP options activated during the build:",ch10
  call wrtout(unt,msg,"COLL")

  msg_index = 0
  msg = ""

#if defined CC_COMPAQ
  write(tmp,"(1x,a25)") "CC_COMPAQ"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CC_GNU
  write(tmp,"(1x,a25)") "CC_GNU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CC_IBM
  write(tmp,"(1x,a25)") "CC_IBM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CC_INTEL
  write(tmp,"(1x,a25)") "CC_INTEL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CC_OPEN64
  write(tmp,"(1x,a25)") "CC_OPEN64"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CC_PATHSCALE
  write(tmp,"(1x,a25)") "CC_PATHSCALE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CC_PGI
  write(tmp,"(1x,a25)") "CC_PGI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CC_SUN
  write(tmp,"(1x,a25)") "CC_SUN"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CXX_COMPAQ
  write(tmp,"(1x,a25)") "CXX_COMPAQ"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CXX_GNU
  write(tmp,"(1x,a25)") "CXX_GNU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CXX_IBM
  write(tmp,"(1x,a25)") "CXX_IBM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CXX_INTEL
  write(tmp,"(1x,a25)") "CXX_INTEL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CXX_OPEN64
  write(tmp,"(1x,a25)") "CXX_OPEN64"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CXX_PATHSCALE
  write(tmp,"(1x,a25)") "CXX_PATHSCALE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CXX_PGI
  write(tmp,"(1x,a25)") "CXX_PGI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined CXX_SUN
  write(tmp,"(1x,a25)") "CXX_SUN"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined DEBUG_CONTRACT
  write(tmp,"(1x,a25)") "DEB*G_CONTRACT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined DEBUG_MODE
  write(tmp,"(1x,a25)") "DEB*G_MODE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_ABSOFT
  write(tmp,"(1x,a25)") "FC_ABSOFT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_COMPAQ
  write(tmp,"(1x,a25)") "FC_COMPAQ"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_FUJITSU
  write(tmp,"(1x,a25)") "FC_FUJITSU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_G95
  write(tmp,"(1x,a25)") "FC_G95"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_GNU
  write(tmp,"(1x,a25)") "FC_GNU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_HITACHI
  write(tmp,"(1x,a25)") "FC_HITACHI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_IBM
  write(tmp,"(1x,a25)") "FC_IBM"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_INTEL
  write(tmp,"(1x,a25)") "FC_INTEL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_MIPSPRO
  write(tmp,"(1x,a25)") "FC_MIPSPRO"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_NAG
  write(tmp,"(1x,a25)") "FC_NAG"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_OPEN64
  write(tmp,"(1x,a25)") "FC_OPEN64"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_PATHSCALE
  write(tmp,"(1x,a25)") "FC_PATHSCALE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_PGI
  write(tmp,"(1x,a25)") "FC_PGI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined FC_SUN
  write(tmp,"(1x,a25)") "FC_SUN"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_ALGO
  write(tmp,"(1x,a25)") "HAVE_ALGO"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_ALGO_LEVMAR
  write(tmp,"(1x,a25)") "HAVE_ALGO_LEVMAR"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_ALGO_MPI
  write(tmp,"(1x,a25)") "HAVE_ALGO_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_ALGO_SERIAL
  write(tmp,"(1x,a25)") "HAVE_ALGO_SERIAL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_BZR_BRANCH
  write(tmp,"(1x,a25)") "HAVE_BZR_BRANCH"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_CCLOCK
  write(tmp,"(1x,a25)") "HAVE_CCLOCK"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_DFT_ATOMPAW
  write(tmp,"(1x,a25)") "HAVE_DFT_ATOMPAW"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_DFT_BIGDFT
  write(tmp,"(1x,a25)") "HAVE_DFT_BIGDFT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_DFT_LIBXC
  write(tmp,"(1x,a25)") "HAVE_DFT_LIBXC"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_DFT_WANNIER90
  write(tmp,"(1x,a25)") "HAVE_DFT_WANNIER90"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_ALLOCATABLE_DTARRAYS
  write(tmp,"(1x,a25)") "HAVE_FC_ALLOCATABLE_DT..."
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_CPUTIME
  write(tmp,"(1x,a25)") "HAVE_FC_CPUTIME"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_ETIME
  write(tmp,"(1x,a25)") "HAVE_FC_ETIME"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_EXIT
  write(tmp,"(1x,a25)") "HAVE_FC_EXIT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_FLUSH
  write(tmp,"(1x,a25)") "HAVE_FC_FLUSH"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_FLUSH_
  write(tmp,"(1x,a25)") "HAVE_FC_FLUSH_"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_GAMMA
  write(tmp,"(1x,a25)") "HAVE_FC_GAMMA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_GETENV
  write(tmp,"(1x,a25)") "HAVE_FC_GETENV"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_GETPID
  write(tmp,"(1x,a25)") "HAVE_FC_GETPID"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_INT_QUAD
  write(tmp,"(1x,a25)") "HAVE_FC_INT_QUAD"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_ISO_C_BINDING
  write(tmp,"(1x,a25)") "HAVE_FC_ISO_C_BINDING"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_LONG_LINES
  write(tmp,"(1x,a25)") "HAVE_FC_LONG_LINES"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_NULL
  write(tmp,"(1x,a25)") "HAVE_FC_NULL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FC_STREAM_IO
  write(tmp,"(1x,a25)") "HAVE_FC_STREAM_IO"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT
  write(tmp,"(1x,a25)") "HAVE_FFT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_ASL
  write(tmp,"(1x,a25)") "HAVE_FFT_ASL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_FFTW2
  write(tmp,"(1x,a25)") "HAVE_FFT_FFTW2"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_FFTW2_THREADS
  write(tmp,"(1x,a25)") "HAVE_FFT_FFTW2_THREADS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_FFTW3
  write(tmp,"(1x,a25)") "HAVE_FFT_FFTW3"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_FFTW3_MKL
  write(tmp,"(1x,a25)") "HAVE_FFT_FFTW3_MKL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_FFTW3_THREADS
  write(tmp,"(1x,a25)") "HAVE_FFT_FFTW3_THREADS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_MLIB
  write(tmp,"(1x,a25)") "HAVE_FFT_MLIB"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_MPI
  write(tmp,"(1x,a25)") "HAVE_FFT_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_SERIAL
  write(tmp,"(1x,a25)") "HAVE_FFT_SERIAL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FFT_SGIMATH
  write(tmp,"(1x,a25)") "HAVE_FFT_SGIMATH"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_FORTRAN2003
  write(tmp,"(1x,a25)") "HAVE_FORTRAN2003"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_GPU
  write(tmp,"(1x,a25)") "HAVE_GPU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_GPU_CUDA
  write(tmp,"(1x,a25)") "HAVE_GPU_CUDA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_GPU_CUDA3
  write(tmp,"(1x,a25)") "HAVE_GPU_CUDA3"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_GPU_CUDA_DP
  write(tmp,"(1x,a25)") "HAVE_GPU_CUDA_DP"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_GPU_CUDA_SP
  write(tmp,"(1x,a25)") "HAVE_GPU_CUDA_SP"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_GPU_MPI
  write(tmp,"(1x,a25)") "HAVE_GPU_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_GPU_SERIAL
  write(tmp,"(1x,a25)") "HAVE_GPU_SERIAL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG
  write(tmp,"(1x,a25)") "HAVE_LINALG"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ASL
  write(tmp,"(1x,a25)") "HAVE_LINALG_ASL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_AXPBY
  write(tmp,"(1x,a25)") "HAVE_LINALG_AXPBY"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_ESSL
  write(tmp,"(1x,a25)") "HAVE_LINALG_ESSL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_GEMM3M
  write(tmp,"(1x,a25)") "HAVE_LINALG_GEMM3M"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_GPU
  write(tmp,"(1x,a25)") "HAVE_LINALG_GPU"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MAGMA
  write(tmp,"(1x,a25)") "HAVE_LINALG_MAGMA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MKL_IMATCOPY
  write(tmp,"(1x,a25)") "HAVE_LINALG_MKL_IMATCOPY"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MKL_OMATADD
  write(tmp,"(1x,a25)") "HAVE_LINALG_MKL_OMATADD"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MKL_OMATCOPY
  write(tmp,"(1x,a25)") "HAVE_LINALG_MKL_OMATCOPY"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_MPI
  write(tmp,"(1x,a25)") "HAVE_LINALG_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_PLASMA
  write(tmp,"(1x,a25)") "HAVE_LINALG_PLASMA"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_SCALAPACK
  write(tmp,"(1x,a25)") "HAVE_LINALG_SCALAPACK"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_LINALG_SERIAL
  write(tmp,"(1x,a25)") "HAVE_LINALG_SERIAL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MATH
  write(tmp,"(1x,a25)") "HAVE_MATH"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MATH_GSL
  write(tmp,"(1x,a25)") "HAVE_MATH_GSL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MATH_MLIB
  write(tmp,"(1x,a25)") "HAVE_MATH_MLIB"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MATH_MPI
  write(tmp,"(1x,a25)") "HAVE_MATH_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MATH_SERIAL
  write(tmp,"(1x,a25)") "HAVE_MATH_SERIAL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MPI
  write(tmp,"(1x,a25)") "HAVE_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MPI1
  write(tmp,"(1x,a25)") "HAVE_MPI1"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MPI2
  write(tmp,"(1x,a25)") "HAVE_MPI2"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MPI_INCLUDED_ONCE
  write(tmp,"(1x,a25)") "HAVE_MPI_INCLUDED_ONCE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MPI_IO
  write(tmp,"(1x,a25)") "HAVE_MPI_IO"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MPI_TRACE
  write(tmp,"(1x,a25)") "HAVE_MPI_TRACE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_MPI_TYPE_CREATE_STRUCT
  write(tmp,"(1x,a25)") "HAVE_MPI_TYPE_CREATE_S..."
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_NUMPY
  write(tmp,"(1x,a25)") "HAVE_NUMPY"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_OMP_COLLAPSE
  write(tmp,"(1x,a25)") "HAVE_OMP_COLLAPSE"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_OS_LINUX
  write(tmp,"(1x,a25)") "HAVE_OS_LINUX"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_OS_MACOSX
  write(tmp,"(1x,a25)") "HAVE_OS_MACOSX"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_OS_WINDOWS
  write(tmp,"(1x,a25)") "HAVE_OS_WINDOWS"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_TIMER
  write(tmp,"(1x,a25)") "HAVE_TIMER"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_TIMER_ABINIT
  write(tmp,"(1x,a25)") "HAVE_TIMER_ABINIT"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_TIMER_MPI
  write(tmp,"(1x,a25)") "HAVE_TIMER_MPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_TIMER_PAPI
  write(tmp,"(1x,a25)") "HAVE_TIMER_PAPI"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_TIMER_SERIAL
  write(tmp,"(1x,a25)") "HAVE_TIMER_SERIAL"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_TRIO_ETSF_IO
  write(tmp,"(1x,a25)") "HAVE_TRIO_ETSF_IO"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_TRIO_FOX
  write(tmp,"(1x,a25)") "HAVE_TRIO_FOX"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif
#if defined HAVE_TRIO_NETCDF
  write(tmp,"(1x,a25)") "HAVE_TRIO_NETCDF"
  msg = trim(msg)//trim(tmp)
  msg_index = msg_index + 1
  if ( mod(msg_index,3) == 0 ) then
    msg = trim(msg)//ch10
    call wrtout(unt,msg,"COLL")
    msg = ""
  end if
#endif

  if ( mod(msg_index,3) /= 0 ) call wrtout(unt,msg,"COLL")

  write(msg,"(1x,a,a)") repeat("+",78),ch10
  call wrtout(unt,msg,"COLL")

end subroutine dump_cpp_options

end module m_cppopts_dumper
!!***
