!{\src2tex{textfont=tt}}
!!****f* ABINIT/leave_new
!! NAME
!!  leave_new
!!
!! FUNCTION
!!  Routine for clean exit of f90 code, taking into account possible
!!  parallelization.
!!
!! COPYRIGHT
!!  Copyright (C) 1998-2012 ABINIT group (DCA, XG, GMR, NCJ)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  mode_paral=
!!   'COLL' if all procs are calling the routine with the same message to be
!!     written once only or
!!   'PERS' if the procs are calling the routine with different mesgs
!!     each to be written, or if one proc is calling the routine
!!  print_config=(optional, default=true)
!!       if true print out several informations before leaving
!!
!! OUTPUT
!!  (only writing, then stop)
!!
!! NOTES
!!  By default, it uses "call exit(1)", that is not completely portable.
!!
!! PARENTS
!!      abi_wtime,bestwfs,cwtime,int2char,int2char4,m_errors,m_hu,m_matlu
!!      m_timer,mpi_setup,print_ierr,timab,time_accu
!!
!! CHILDREN
!!      dump_config,leave_myproc,print_kinds,wrtout,xmpi_abort,xmpi_end
!!      xmpi_show_info
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine leave_new(mode_paral,print_config)

 use defs_basis
 use m_build_info
 use m_xmpi
 use m_profiling
#if defined FC_NAG
 use f90_unix
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'leave_new'
 use interfaces_14_hidewrite
 use interfaces_16_hideleave, except_this_one => leave_new
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 character(len=4),intent(in) :: mode_paral
 logical,intent(in),optional :: print_config

!Local variables-------------------------------
 integer :: nproc
 logical :: print_config_
 character(len=500) :: msg

! **********************************************************************

 write(msg,'(2a)') ch10,' leave_new : decision taken to exit ...'
 call wrtout(std_out,msg,'PERS')

 print_config_=.true.;if (present(print_config)) print_config_=print_config

!Determine nproc in COMM_WORLD
 nproc = xcomm_size(xmpi_world)

!Dump configuration before exiting
 if (print_config_) then
   call print_kinds()
   call xmpi_show_info()
   call dump_config()
 end if

 if( (mode_paral=='COLL') .or. (nproc==1) ) then

   if (abinit_comm_leave==xmpi_world) then
     call xmpi_end()
     call leave_myproc()
   else
     call leave_myproc(option=1)
     call xmpi_abort()
   end if

 else if(mode_paral=='PERS') then  ! Caveat: Do not use MPI collective calls!

   call wrtout(std_out,' leave_new : calling XMPI_ABORT...','PERS')
   call leave_myproc(option=1)
   call xmpi_abort()

 end if

end subroutine leave_new
!!***
