!{\src2tex{textfont=tt}}
!!****f* ABINIT/wrtout
!! NAME
!!  wrtout
!!
!! FUNCTION
!!  Organizes the sequential or parallel version of the write intrinsic
!!  Also allows to treat correctly the write operations for Unix (+DOS) and MacOS.
!!
!! COPYRIGHT
!!  Copyright (C) 1998-2012 ABINIT group (DCA, XG, GMR)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  msg=(character(len=*)) message to be written
!!  unit=unit number for writing. The named constant dev_null defined in defs_basis can be used to avoid any printing.
!!  [mode_paral]= --optional argument--
!!   'COLL' if all procs are calling the routine with the same message to be written once only. Default.
!!   'PERS' if the procs are calling the routine with different messages each to be written,
!!          or if one proc is calling the routine
!!   "INIT" to change the rank of the master node that prints the message if "COLL" is used.
!!
!! OUTPUT
!!  (only writing)
!!
!! PARENTS
!!      abi_etsf_electrons_put,abi_etsf_geo_put,abi_etsf_init,abi_wtime,abinit
!!      acfd_dyson,acfd_intexact,afterscfloop,anaddb,append_cml2,append_xyz
!!      asria_calc,asria_corr,asrprs,atm2fft,atomden,berryphase,berryphase_new
!!      bestwfs,bethe_salpeter,bonds_lgth_angles,calc_cs,calc_efg,calc_fc
!!      calc_optical_mels,calc_rpa_functional,calc_sig_ppm_eet,calc_sigc_me
!!      calc_sigx_me,calc_ucrpa,calc_vhxc_me,calcdensph,canat9,cchi0,cchi0q0
!!      cchi0q0_intraband,cgwf,cgwf3,check_completeness,chiscwrt,chkdpr,chkexi
!!      chkilwf,chkinp,chkint_prt,chkneu,chkpawovlp,chkph3,chkprimit,chneu9
!!      clnup1,clnup2,cohsex_me,constrf,cwtime,d3output,datafordmft,debug_tools
!!      defs_scalapack,deloc2xcart,denfgr,diel9,dielmt,dieltcel,distrb2
!!      dmft_solve,dos_hdr_write,driver,dsksta,dyson,echo_xc_name,elast9
!!      electrooptic,eliashberg_1d,elphon,elpolariz,energy,entropyrec
!!      ep_fs_weights,ep_setupqpt,evdw_wannier,ewald,ewald4,exc_build_block
!!      exc_build_ham,exc_den,exc_diago,exc_iterative_diago,exc_plot
!!      exc_spectra,extraprho,fconv,fermi_green,fermisolverec,fftprof
!!      find_getdtset,finddistrproc,findmin,findminscf,first_rec,forstrnps
!!      fred2fdeloc,fsumrule,gaus_dos,gensymspgr,get_all_gkq,get_fs_bands
!!      get_full_gsphere,get_npert_rbz,get_nv_fs_en,get_nv_fs_temp,getcgqphase
!!      getcut,getdim_nloc,getfreqsus,getghc,getkgrid,getmpw,getnel,getng
!!      getshell,getspinrot,gran_potrec,green_kernel,gstate,gstateimg,gtblk9
!!      gtdyn9,gw_driver,gw_tools,gwcompleteness,haydock,haydock_psherm
!!      hdr_check,hdr_vs_dtset,herald,hermit,hubbard_one,importcml,importxyz
!!      impurity_solve,inarray,incomprs,ingeo,ingeobld,initberry,initberry3
!!      initmpi_grid,initmpi_pert,initro,initwf,initylmg,inkpts,inpgkk,inprep8
!!      inpspheads,instr9,instrng,insy3,int2char,int2char4,intagm
!!      integrate_gamma,integrate_gamma_alt,integrate_gamma_tr
!!      integrate_gamma_tr_lova,invars1,invars1m,invars2,invars9,inwffil
!!      inwffil3,ioarr,ioddb8_in,ioddb8_out,iofn1,ioniondist,irred_perts,irrzg
!!      isfile,kpgio,kramerskronig,ks_ddiago,kss2wfk,kxc_alda,kxc_eok,ladielmt
!!      lapackprof,lavnl,ldau_self,leave_new,leave_test,linemin,lobpcgwf
!!      local_ks_green,loop3dte,loper3,m_abilasi,m_atom,m_bands_sym,m_bfgs
!!      m_bs_defs,m_bse_io,m_bz_mesh,m_cgtools,m_commutator_vkbr
!!      m_cppopts_dumper,m_crystal,m_crystal_io,m_dyson_solver,m_ebands
!!      m_energy,m_errors,m_fft_mesh,m_fft_prof,m_fftw3,m_gamma,m_geometry
!!      m_gpu_detect,m_green,m_gsphere,m_hamiltonian,m_header,m_hidecudarec
!!      m_hu,m_initcuda,m_io_gkk,m_io_kss,m_io_screening,m_iterators
!!      m_libxc_functionals,m_matlu,m_matrix,m_melemts,m_mep,m_numeric_tools
!!      m_oper,m_optim_dumper,m_paw_dmft,m_paw_pwij,m_paw_slater,m_paw_toolbox
!!      m_phdos,m_pimd,m_ppmodel,m_pretty_rec,m_ptgroups,m_qparticles,m_radmesh
!!      m_rec,m_screen,m_screening,m_self,m_shexc,m_shirley,m_sigma_results
!!      m_timer,m_vcoul,m_wfk,m_wfs,m_xomp,mag_out,mat_mlms2jmj,mat_slm2ylm
!!      mblktyp1,mblktyp5,memana,memkss,memorf,memory,metric,mka2f,mka2fQgrid
!!      mka2f_tr,mka2f_tr_lova,mkdenpos,mkfilename,mkfskgrid,mkifc9
!!      mklocl_recipspace,mklocl_wavelets,mknesting,mknormpath,mkph_linwid
!!      mkphbs,mkqptequiv,mkrho,mkrho3,mlwfovlp,mlwfovlp_proj,mlwfovlp_projpaw
!!      mlwfovlp_pw,mlwfovlp_qp,mlwfovlp_seedname,mlwfovlp_setup,mover
!!      mpi_setup,mrgddb,mrggkk,mrgscr,multipoles_fftr,mv_3dte,my_calc_wfwfg
!!      new_integrate_gamma,new_integrate_gamma_tr,new_integrate_gamma_tr_lova
!!      newfermie1,newkpt,newocc,newton,newvtr3,nlenergyrec,nonlinear
!!      normsq_gkq,nselt3,nstdy3,nstpaw3,orthonormalize,out1dm,outelph,outgkk
!!      outkss,outphdos,outqmc,outscfcv,outvars,outwant,outwf,pareigocc
!!      paw_mknewh0,paw_qpscgw,pawdenpot,pawdensities,pawlsylm,pawmkaewf
!!      pawmkrhoij,pawprt,pawpupot,pawpuxinit,pawuenergy,pawuj_det,pawuj_red
!!      pawuj_utils,pawxcpositron,pawxenergy,pawxpot,phfrq3,piezo9
!!      pimd_nosehoover_nvt,polcart,poslifetime,prctfvw1,prctfvw2,precon
!!      precon2,pred_delocint,pred_isokinetic,pred_isothermal,pred_langevin
!!      pred_nose,pred_verlet,predictimg,prep_calc_ucrpa,print_ierr,print_ij
!!      print_psps,prmat,projbd,prt_cml2,prtefield,prteigrs,prtene,prtene3
!!      prtfatbands,prtimg,prtph3,prtrhomxmn,prtspgroup,prtvsound,prtxf
!!      prtxfase,prtxvf,psddb8,psichi_renormalization,psolver_hartree
!!      psolver_kernel,psolver_rhohxc,psp10in,psp17in,psp1in,psp2in,psp2lo
!!      psp3in,psp5in,psp6in,psp7in,psp8in,psp9in,pspatm,pspini,pspnl_hgh_rec
!!      pspnl_operat_rec,psxml2ab,pw_orthon,randac,rdddb9,read_gkk,refineblk
!!      remove_inversion,respfn,rhofermi3,rhohxc,rotmat,rsiaf9,scfcge,scfcv
!!      scfcv3,scfeig,scfopt,scphon,scphon_build_qsym_map
!!      scphon_dynmat_to_freq2,scphon_free_energy,scphon_supercell_vectors_init
!!      scprqt,screening,setmqgrid,setnoccmmp,setrhoijpbe0,setshells
!!      setsymrhoij,setup1,setup2,setup_bse,setup_positron,setup_screening
!!      setup_sigma,setvtr,shellstruct,sigma,smpbz,spectral,spectral_function
!!      stress,sumrule,suscep,suscep_dyn,suscep_kxc_dyn,suscep_stat,sym_gkk
!!      symanal,symatm,symaxes,symbrav,symcharac,symdij,symdm9,symkchk,symkpt
!!      symlatt,symmetrize_afm_chi0,symmultsg,symph3,symplanes,symq3,symrhoij
!!      symspgr,tddft,testkgrid,tetrahedron,thm9,thmeig,timab,timana,time_accu
!!      uderiv,ujdet,vdw_dftd2,vtorho,vtorho3,vtorhorec,vtorhotf,vtowfk,vtowfk3
!!      wfconv,wfd_mkrho,wfd_pawrhoij,wffile,wffopen,wfkfermi3,wfsinp
!!      wrt_moldyn_netcdf,wrtloctens,wvl_denspot_set,wvl_descr_atoms_set_sym
!!      wvl_hpsitopsi,wvl_memory,wvl_mkrho,wvl_nl_gradient,wvl_projectors_set
!!      wvl_psitohpsi,wvl_rwwf,wvl_setboxgeometry,wvl_setngfft
!!      wvl_tail_corrections,wvl_wfs_set,wvl_wfsinp_disk,wvl_wfsinp_reformat
!!      wvl_wfsinp_scratch,xc_kernel,xc_kernel_ADA,xcacfd,zorthonormalize
!!      zprecon3
!!
!! CHILDREN
!!      wrtout_myproc
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine wrtout(unit,msg,mode_paral)

 use m_profiling

 use defs_basis
 use m_xmpi,    only : xmpi_world, xcomm_rank, xcomm_size

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'wrtout'
 use interfaces_14_hidewrite, except_this_one => wrtout
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: unit
 character(len=*),optional,intent(in) :: mode_paral
 character(len=*),intent(in) :: msg

!Local variables-------------------------------
 integer :: comm
 integer,save :: master=0
 integer :: me,nproc,rtnpos
 character(len=7) :: tag
 character(len=len(msg)) :: my_msg
 character(len=len(msg)+50) :: string
 character(len=500) :: my_mode_paral

!******************************************************************

!Be careful with the coding  of the parallel case ...

!MG: Be careful**2, me and nproc are defined in MPI_COMM_WORLD.
!One should pass the MPI communicator

 if ((unit == std_out).and.(.not.do_write_log)) RETURN
 if (unit == dev_null) RETURN

 my_mode_paral = "COLL"; if (PRESENT(mode_paral)) my_mode_paral = mode_paral

!Communicator is xmpi_world by default, except for the parallelization over images
 if (abinit_comm_output/=-1) then
   comm=abinit_comm_output
 else
   comm=xmpi_world
 end if

!Determine who I am in COMM_WORLD
 nproc = xcomm_size(comm)
 me    = xcomm_rank(comm)

!msg is not changed therefore we can pass literal strings as well.
 my_msg = msg

 if( (my_mode_paral=='COLL') .or. (nproc==1) ) then

   if (me==master) then
     call wrtout_myproc(unit, my_msg)
   end if

 else if (my_mode_paral=='PERS') then

   if(me<10) then
     write(tag,'("-P-000",i1)') me
   elseif(me<100) then
     write(tag,'("-P-00",i2)') me
   elseif(me<1000) then
     write(tag,'("-P-0",i3)') me
   elseif(me<10000) then
     write(tag,'("-P-",i4)') me
   else
     tag=' ######'
   end if

   rtnpos=index(my_msg,ch10)
   do while(rtnpos/=0)
     write(string,'(3a)') tag, ' ', my_msg(1:rtnpos-1)
     write(unit,'(A)') trim(string)
     my_msg=my_msg(rtnpos+1:len(my_msg))
     rtnpos=index(my_msg,ch10)
   end do
   write(string, "(3a)") tag, ' ', my_msg
   write(unit,'(A)') trim(string)

 else if (my_mode_paral=='INIT') then

   master=unit

 else
   write(string,'(7a)')ch10,&
&   '  wrtout: ERROR -',ch10,&
&   '  Unknown write mode: ',my_mode_paral,ch10,&
&   '  Continuing anyway ...'
   write(unit, '(A)' ) trim(string)
 end if

end subroutine wrtout
!!***
