!{\src2tex{textfont=tt}}
!!****f* ABINIT/xmax_mpi_intv
!! NAME
!!  xmax_mpi_intv
!!
!! FUNCTION
!!  This module contains functions that calls MPI routine,
!!  if we compile the code using the MPI  CPP flags.
!!  xmax_mpi is the generic function.
!!
!! COPYRIGHT
!!  Copyright (C) 2001-2012 ABINIT group (AR,XG,MB)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~ABINIT/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! TODO
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allreduce
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine xmax_mpi_intv(xval,xmax,spaceComm,ier)


#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xmax_mpi_intv'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer ,intent(in) :: xval
 integer, intent(out) :: xmax
 integer ,intent(in) :: spaceComm
 integer ,intent(out) :: ier

!Local variables-------------------

! *************************************************************************
 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLREDUCE(xval,xmax,1,MPI_INTEGER,MPI_MAX,spaceComm,ier)
 else
#endif
   xmax=xval
#if defined HAVE_MPI
 end if
#endif
end subroutine xmax_mpi_intv
!!***

!!****f* ABINIT/xmax_mpi_int
!! NAME
!!  xmax_mpi_int
!!
!! FUNCTION
!!  This module contains functions that calls MPI routine,
!!  if we compile the code using the MPI  CPP flags.
!!  xmax_mpi is the generic function.
!!
!! COPYRIGHT
!!  Copyright (C) 2001-2012 ABINIT group (AR,XG,MB,YG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~ABINIT/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! TODO
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allreduce
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine xmax_mpi_int(xval,xmax,spaceComm,ier)


#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xmax_mpi_int'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer ,intent(in) :: xval(:)
 integer ,intent(out):: xmax(:)
 integer ,intent(in) :: spaceComm
 integer ,intent(out) :: ier

!Local variables-------------------
 integer :: s1

! *************************************************************************
 ier=0
 s1 =SIZE(xval)
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLREDUCE(xval,xmax,s1,MPI_INTEGER,MPI_MAX,spaceComm,ier)
 else
#endif
   xmax=xval
#if defined HAVE_MPI
 end if
#endif
end subroutine xmax_mpi_int
!!***


!!****f* ABINIT/xmax_mpi_dpv
!! NAME
!!  xmax_mpi_dpv
!!
!! FUNCTION
!!  Combines values from all processes and distribute
!!  the result back to all processes.
!!  Target: scalar double precisions.
!!
!! INPUTS
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  xval= buffer array
!!  xmax= number of elements in send buffer
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allreduce
!!
!! SOURCE
subroutine xmax_mpi_dpv(xval,xmax,spaceComm,ier)

 use defs_basis

#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xmax_mpi_dpv'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(in) :: xval
 real(dp),intent(out) :: xmax
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************

 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLREDUCE(xval,xmax,1,MPI_DOUBLE_PRECISION,MPI_MAX,spaceComm,ier)
 else
#endif
   xmax=xval
#if defined HAVE_MPI
 end if
#endif
end subroutine xmax_mpi_dpv
!!***
