!{\src2tex{textfont=tt}}
!!****f* ABINIT/xallgatherv_mpi_int2d
!! NAME
!!  xallgatherv_mpi_int2d
!!
!! FUNCTION
!!  This module contains functions that calls MPI routine,
!!  if we compile the code using the MPI CPP flags.
!!  xallgatherv_mpi is the generic function.
!!
!! COPYRIGHT
!!  Copyright (C) 2001-2012 ABINIT group (AR,XG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~ABINIT/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! TODO
!!
!! PARENTS
!!
!! CHILDREN
!!      xallgather_mpi,xallgatherv_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine xallgatherv_mpi_int2d(xval,nelem,recvbuf,recvcounts,displs,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgatherv_mpi_int2d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(in) :: xval(:,:)
 integer,intent(inout) :: recvbuf(:,:)
 integer,intent(in) :: recvcounts(:),displs(:)
 integer,intent(in) :: nelem,spaceComm
 integer,intent(out)   :: ier

!Local variables--------------
 integer :: cc,dd,sz1

! *************************************************************************

 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLGATHERV(xval,nelem,MPI_INTEGER,recvbuf,recvcounts,displs,&
&   MPI_INTEGER,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
#endif
   sz1=size(xval,1)
   dd=0;if (size(displs)>0) dd=displs(1)/sz1
   cc=size(xval,2);if (size(recvcounts)>0) cc=recvcounts(1)/sz1
   recvbuf(:,dd+1:dd+cc)=xval(:,1:cc)
#if defined HAVE_MPI
 end if
#endif
end subroutine xallgatherv_mpi_int2d
!!***

!!****f* ABINIT/xallgatherv_mpi_int
!! NAME
!!  xallgatherv_mpi_int
!!
!! FUNCTION
!!  Gathers data from all tasks and delivers it to all.
!!  Target: one-dimensional integer arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  recvcounts= number of received elements
!!  displs= relative offsets for incoming data
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received buffer
!!
!! PARENTS
!!
!! CHILDREN
!!      xallgather_mpi,xallgatherv_mpi
!!
!! SOURCE
subroutine xallgatherv_mpi_int(xval,nelem,recvbuf,recvcounts,displs,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgatherv_mpi_int'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(in) :: xval(:)
 integer,intent(inout)   :: recvbuf(:)
 integer,intent(in) :: recvcounts(:),displs(:)
 integer,intent(in) :: nelem,spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer :: cc,dd

! *************************************************************************

 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLGATHERV(xval,nelem,MPI_INTEGER,recvbuf,recvcounts,displs,&
&   MPI_INTEGER,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
#endif
   dd=0;if (size(displs)>0) dd=displs(1)
   cc=size(xval);if (size(recvcounts)>0) cc=recvcounts(1)
   recvbuf(dd+1:dd+cc)=xval(1:cc)
#if defined HAVE_MPI
 end if
#endif
end subroutine xallgatherv_mpi_int
!!***

!!****f* ABINIT/xallgatherv_mpi_dp
!! NAME
!!  xallgatherv_mpi_dp
!!
!! FUNCTION
!!  Gathers data from all tasks and delivers it to all.
!!  Target: one-dimensional double precision arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  recvcounts= number of received elements
!!  displs= relative offsets for incoming data
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received buffer
!!
!! PARENTS
!!
!! CHILDREN
!!      xallgather_mpi,xallgatherv_mpi
!!
!! SOURCE
subroutine xallgatherv_mpi_dp(xval,nelem,recvbuf,recvcounts,displs,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgatherv_mpi_dp'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(in) :: xval(:)
 real(dp),intent(inout)   :: recvbuf(:)
 integer,intent(in) :: recvcounts(:),displs(:)
 integer,intent(in) :: nelem,spaceComm
 integer,intent(out)   :: ier

!Local variables--------------
 integer :: cc,dd

! *************************************************************************

 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLGATHERV(xval,nelem,MPI_DOUBLE_PRECISION,recvbuf,recvcounts,displs,&
&   MPI_DOUBLE_PRECISION,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
#endif
   dd=0;if (size(displs)>0) dd=displs(1)
   cc=size(xval);if (size(recvcounts)>0) cc=recvcounts(1)
   recvbuf(dd+1:dd+cc)=xval(1:cc)
#if defined HAVE_MPI
 end if
#endif
end subroutine xallgatherv_mpi_dp
!!***

!!****f* ABINIT/xallgatherv_mpi_dp2d
!! NAME
!!  xallgatherv_mpi_dp2d
!!
!! FUNCTION
!!  Gathers data from all tasks and delivers it to all.
!!  Target: double precision two-dimensional arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  recvcounts= number of received elements
!!  displs= relative offsets for incoming data
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received buffer
!!
!! PARENTS
!!
!! CHILDREN
!!      xallgather_mpi,xallgatherv_mpi
!!
!! SOURCE
subroutine xallgatherv_mpi_dp2d(xval,nelem,recvbuf,recvcounts,displs,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgatherv_mpi_dp2d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(in) :: xval(:,:)
 real(dp),intent(inout) :: recvbuf(:,:)
 integer,intent(in) :: recvcounts(:),displs(:)
 integer,intent(in) :: nelem,spaceComm
 integer,intent(out)   :: ier

!Local variables--------------
 integer :: cc,dd,sz1

! *************************************************************************

 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLGATHERV(xval,nelem,MPI_DOUBLE_PRECISION,recvbuf,recvcounts,displs,&
&   MPI_DOUBLE_PRECISION,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
#endif
   sz1=size(xval,1)
   dd=0;if (size(displs)>0) dd=displs(1)/sz1
   cc=size(xval,2);if (size(recvcounts)>0) cc=recvcounts(1)/sz1
   recvbuf(:,dd+1:dd+cc)=xval(:,1:cc)
#if defined HAVE_MPI
 end if
#endif
end subroutine xallgatherv_mpi_dp2d
!!***

!!****f* ABINIT/xallgatherv_mpi_dp3d
!! NAME
!!  xallgatherv_mpi_dp3d
!!
!! FUNCTION
!!  Gathers data from all tasks and delivers it to all.
!!  Target: double precision three-dimensional arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  recvcounts= number of received elements
!!  displs= relative offsets for incoming data
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received buffer
!!
!! PARENTS
!!
!! CHILDREN
!!      xallgather_mpi,xallgatherv_mpi
!!
!! SOURCE
subroutine xallgatherv_mpi_dp3d(xval,nelem,recvbuf,recvcounts,displs,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgatherv_mpi_dp3d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(in) :: xval(:,:,:)
 real(dp),intent(inout)   :: recvbuf(:,:,:)
 integer,intent(in) :: recvcounts(:),displs(:)
 integer,intent(in) :: nelem,spaceComm
 integer,intent(out)   :: ier

!Local variables--------------
 integer :: cc,dd,sz12

! *************************************************************************

 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLGATHERV(xval,nelem,MPI_DOUBLE_PRECISION,recvbuf,recvcounts,displs,&
&   MPI_DOUBLE_PRECISION,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
#endif
   sz12=size(xval,1)*size(xval,2)
   dd=0;if (size(displs)>0) dd=displs(1)/sz12
   cc=size(xval,3);if (size(recvcounts)>0) cc=recvcounts(1)/sz12
   recvbuf(:,:,dd+1:dd+cc)=xval(:,:,1:cc)
#if defined HAVE_MPI
 end if
#endif
end subroutine xallgatherv_mpi_dp3d
!!***

!!****f* ABINIT/xallgatherv_mpi_dp4d
!! NAME
!!  xallgatherv_mpi_dp4d
!!
!! FUNCTION
!!  Gathers data from all tasks and delivers it to all.
!!  Target: double precision four-dimensional arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  recvcounts= number of received elements
!!  displs= relative offsets for incoming data
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received buffer
!!
!! PARENTS
!!
!! CHILDREN
!!      xallgather_mpi,xallgatherv_mpi
!!
!! SOURCE
subroutine xallgatherv_mpi_dp4d(xval,nelem,recvbuf,recvcounts,displs,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgatherv_mpi_dp4d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(in) :: xval(:,:,:,:)
 real(dp),intent(inout)   :: recvbuf(:,:,:,:)
 integer,intent(in) :: recvcounts(:),displs(:)
 integer,intent(in) :: nelem,spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer :: cc,dd,sz123

! *************************************************************************

 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
   call MPI_ALLGATHERV(xval,nelem,MPI_DOUBLE_PRECISION,recvbuf,recvcounts,displs,&
&   MPI_DOUBLE_PRECISION,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
#endif
   sz123=size(xval,1)*size(xval,2)*size(xval,3)
   dd=0;if (size(displs)>0) dd=displs(1)/sz123
   cc=size(xval,4);if (size(recvcounts)>0) cc=recvcounts(1)/sz123
   recvbuf(:,:,:,dd+1:dd+cc)=xval(:,:,:,1:cc)
#if defined HAVE_MPI
 end if
#endif
end subroutine xallgatherv_mpi_dp4d
!!***

!!****f* ABINIT/xallgatherv_mpi_coeff2d
!! NAME
!!  xallgatherv_mpi_coeff2d
!!
!! FUNCTION
!!  Gathers data from all tasks and delivers it to all.
!!  Target: coeff2_type 1D-structure
!!
!! INPUTS
!!  xval_in = coeff2d_type array structure
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  xval_out = coeff2d_type array structure
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!
!! PARENTS
!!
!! CHILDREN
!!      xallgather_mpi,xallgatherv_mpi
!!
!! SOURCE

subroutine xallgatherv_mpi_coeff2d(xval_in,xval_out,spaceComm,ierr)

 use defs_basis
#if defined HAVE_MPI && defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgatherv_mpi_coeff2d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ierr
!arrays
 type(coeff2_type),intent(in) :: xval_in(:)
 type(coeff2_type),intent(out) :: xval_out(:)

!Local variables-------------------------------
!scalars
 integer :: ii,n1,n2
#if defined HAVE_MPI
 integer :: buf_int_size,buf_int_size_all,buf_dp_size,buf_dp_size_all
 integer :: i2,indx_int,indx_dp,nb,nb_out,nproc
#endif
!arrays
#if defined HAVE_MPI
 integer, allocatable ::  buf_int(:),buf_int_all(:),count_dp(:),count_int(:)
 integer, allocatable :: dimxval(:,:),disp_dp(:),disp_int(:)
 real(dp),allocatable :: buf_dp(:),buf_dp_all(:)
#endif

! *************************************************************************

 ierr=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_NULL) then

   nproc=xcomm_size(spaceComm)
   nb = size(xval_in,1)

   if (spaceComm==MPI_COMM_SELF.or.nproc==1) then
     do ii=1,nb
       n1=size(xval_in(ii)%value,1)
       n2=size(xval_in(ii)%value,2)
       if (associated(xval_out(ii)%value)) then
         ABI_DEALLOCATE(xval_out(ii)%value)
       end if
       ABI_ALLOCATE(xval_out(ii)%value,(n1,n2))
       xval_out(ii)%value=xval_in(ii)%value
     end do
     return
   end if

   buf_dp_size=0
   ABI_ALLOCATE(dimxval,(nb,2))
   do ii=1,nb
     dimxval(ii,1)=size(xval_in(ii)%value,dim=1)
     dimxval(ii,2)=size(xval_in(ii)%value,dim=2)
     buf_dp_size=buf_dp_size+dimxval(ii,1)*dimxval(ii,2)
   end do

   buf_int_size=2*nb;
   ABI_ALLOCATE(buf_int,(buf_int_size))
   indx_int=1
   do ii=1,nb
     buf_int(indx_int  )=dimxval(ii,1)
     buf_int(indx_int+1)=dimxval(ii,2)
     indx_int=indx_int+2
   end do

   ABI_ALLOCATE(buf_dp,(buf_dp_size))
   indx_dp=1
   do ii=1,nb
     n1=dimxval(ii,1); n2=dimxval(ii,2)
     do i2=1,n2
       buf_dp(indx_dp:indx_dp+n1-1)=xval_in(ii)%value(1:n1,i2)
       indx_dp=indx_dp+n1
     end do
   end do

   ABI_ALLOCATE(count_int,(nproc))
   ABI_ALLOCATE(disp_int,(nproc))
   ABI_ALLOCATE(count_dp,(nproc))
   ABI_ALLOCATE(disp_dp,(nproc))

   call xallgather_mpi(buf_int_size,count_int,spaceComm,ierr)
   call xallgather_mpi(buf_dp_size ,count_dp ,spaceComm,ierr)

   disp_dp(1)=0 ; disp_int(1)=0
   do ii=2,nproc
     disp_int(ii)=disp_int(ii-1)+count_int(ii-1)
     disp_dp(ii) =disp_dp(ii-1) +count_dp(ii-1)
   end do

   buf_dp_size_all =sum(count_dp)
   buf_int_size_all=sum(count_int)
   ABI_ALLOCATE(buf_dp_all,(buf_dp_size_all))
   ABI_ALLOCATE(buf_int_all,(buf_int_size_all))
   call xallgatherv_mpi(buf_int,buf_int_size,buf_int_all,count_int,disp_int,spaceComm,ierr)
   call xallgatherv_mpi(buf_dp,buf_dp_size,buf_dp_all,count_dp,disp_dp,spaceComm,ierr)

   nb_out=buf_int_size_all/2

   indx_int=1;indx_dp=1
   do ii=1,nb_out
     n1=buf_int_all(indx_int)
     n2=buf_int_all(indx_int+1)
     indx_int=indx_int+2
     if (associated(xval_out(ii)%value)) then
       ABI_DEALLOCATE(xval_out(ii)%value)
     end if
     ABI_ALLOCATE(xval_out(ii)%value,(n1,n2))
     do i2=1,n2
       xval_out(ii)%value(1:n1,i2)=buf_dp_all(indx_dp:indx_dp+n1-1)
       indx_dp=indx_dp+n1
     end do
   end do

   ABI_DEALLOCATE(count_int)
   ABI_DEALLOCATE(disp_int)
   ABI_DEALLOCATE(count_dp)
   ABI_DEALLOCATE(disp_dp)
   ABI_DEALLOCATE(buf_dp_all)
   ABI_DEALLOCATE(buf_int_all)
   ABI_DEALLOCATE(buf_int)
   ABI_DEALLOCATE(buf_dp)
   ABI_DEALLOCATE(dimxval)

 end if

#else
 do ii=1,size(xval_in,1)
   n1=size(xval_in(ii)%value,1)
   n2=size(xval_in(ii)%value,2)
   if (associated(xval_out(ii)%value)) then
     ABI_DEALLOCATE(xval_out(ii)%value)
   end if
   ABI_ALLOCATE(xval_out(ii)%value,(n1,n2))
   xval_out(ii)%value=xval_in(ii)%value
 end do
#endif

end subroutine xallgatherv_mpi_coeff2d
!!***

!!****f* ABINIT/xallgatherv_mpi_coeff2d_indx
!! NAME
!!  xallgatherv_mpi_coeff2d_indx
!!
!! FUNCTION
!!  Gathers data from all tasks and delivers it to all.
!!  Target: coeff2_type 1D-structure
!!          use of an indirect index to sort data
!!
!! INPUTS
!!  xval_in = coeff2d_type array structure
!!  spaceComm= MPI communicator
!!  indx= gives the indexes of xval_in in xval_out.
!!        xval_in(i) will be transfered in xval_out(indx(i))
!!
!! OUTPUT
!!  xval_out = coeff2d_type array structure
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!
!! PARENTS
!!
!! CHILDREN
!!      xallgather_mpi,xallgatherv_mpi
!!
!! SOURCE

subroutine xallgatherv_mpi_coeff2d_indx(xval_in,xval_out,spaceComm,indx,ierr)

 use defs_basis
#if defined HAVE_MPI && defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgatherv_mpi_coeff2d_indx'
!End of the abilint section

 implicit none

#if defined HAVE_MPI && defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ierr
!arrays
 integer,intent(in) :: indx(:)
 type(coeff2_type),intent(in) :: xval_in(:)
 type(coeff2_type),intent(out) :: xval_out(:)

!Local variables-------------------------------
!scalars
 integer :: ii,ival,n1,n2
#if defined HAVE_MPI
 integer :: buf_int_size,buf_int_size_all,buf_dp_size,buf_dp_size_all
 integer :: i2,indx_int,indx_dp,nb,nb_out,nproc
#endif
!arrays
#if defined HAVE_MPI
 integer, allocatable ::  buf_int(:),buf_int_all(:),count_dp(:),count_int(:)
 integer, allocatable :: dimxval(:,:),disp_dp(:),disp_int(:)
 real(dp),allocatable :: buf_dp(:),buf_dp_all(:)
#endif

! *************************************************************************

 ierr=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_NULL) then

   nproc=xcomm_size(spaceComm)
   nb = size(xval_in,1)

   if (spaceComm==MPI_COMM_SELF.or.nproc==1) then
     do ii=1,nb
       n1=size(xval_in(ii)%value,1)
       n2=size(xval_in(ii)%value,2)
       if (associated(xval_out(ii)%value)) then
         ABI_DEALLOCATE(xval_out(ii)%value)
       end if
       ABI_ALLOCATE(xval_out(ii)%value,(n1,n2))
       xval_out(ii)%value=xval_in(ii)%value
     end do
     return
   end if

   buf_dp_size=0
   ABI_ALLOCATE(dimxval,(nb,2))
   do ii=1,nb
     dimxval(ii,1)=size(xval_in(ii)%value,dim=1)
     dimxval(ii,2)=size(xval_in(ii)%value,dim=2)
     buf_dp_size=buf_dp_size+dimxval(ii,1)*dimxval(ii,2)
   end do

   buf_int_size=3*nb;
   ABI_ALLOCATE(buf_int,(buf_int_size))
   indx_int=1
   do ii=1,nb
     buf_int(indx_int  )=dimxval(ii,1)
     buf_int(indx_int+1)=dimxval(ii,2)
     buf_int(indx_int+2)=indx(ii)
     indx_int=indx_int+3
   end do

   ABI_ALLOCATE(buf_dp,(buf_dp_size))
   indx_dp=1
   do ii=1,nb
     n1=dimxval(ii,1); n2=dimxval(ii,2)
     do i2=1,n2
       buf_dp(indx_dp:indx_dp+n1-1)=xval_in(ii)%value(1:n1,i2)
       indx_dp=indx_dp+n1
     end do
   end do

   ABI_ALLOCATE(count_int,(nproc))
   ABI_ALLOCATE(disp_int,(nproc))
   ABI_ALLOCATE(count_dp,(nproc))
   ABI_ALLOCATE(disp_dp,(nproc))

   call xallgather_mpi(buf_int_size,count_int,spaceComm,ierr)
   call xallgather_mpi(buf_dp_size ,count_dp ,spaceComm,ierr)

   disp_dp(1)=0 ; disp_int(1)=0
   do ii=2,nproc
     disp_int(ii)=disp_int(ii-1)+count_int(ii-1)
     disp_dp(ii) =disp_dp(ii-1) +count_dp(ii-1)
   end do

   buf_dp_size_all =sum(count_dp)
   buf_int_size_all=sum(count_int)
   ABI_ALLOCATE(buf_dp_all,(buf_dp_size_all))
   ABI_ALLOCATE(buf_int_all,(buf_int_size_all))
   call xallgatherv_mpi(buf_int,buf_int_size,buf_int_all,count_int,disp_int,spaceComm,ierr)
   call xallgatherv_mpi(buf_dp,buf_dp_size,buf_dp_all,count_dp,disp_dp,spaceComm,ierr)

   nb_out=buf_int_size_all/3

   indx_int=1;indx_dp=1
   do ii=1,nb_out
     n1  =buf_int_all(indx_int)
     n2  =buf_int_all(indx_int+1)
     ival=buf_int_all(indx_int+2)
     indx_int=indx_int+3
     if (associated(xval_out(ival)%value)) then
       ABI_DEALLOCATE(xval_out(ival)%value)
     end if
     ABI_ALLOCATE(xval_out(ival)%value,(n1,n2))
     do i2=1,n2
       xval_out(ival)%value(1:n1,i2)=buf_dp_all(indx_dp:indx_dp+n1-1)
       indx_dp=indx_dp+n1
     end do
   end do

   ABI_DEALLOCATE(count_int)
   ABI_DEALLOCATE(disp_int)
   ABI_DEALLOCATE(count_dp)
   ABI_DEALLOCATE(disp_dp)
   ABI_DEALLOCATE(buf_dp_all)
   ABI_DEALLOCATE(buf_int_all)
   ABI_DEALLOCATE(buf_int)
   ABI_DEALLOCATE(buf_dp)
   ABI_DEALLOCATE(dimxval)

 end if

#else
 do ii=1,size(xval_in,1)
   n1=size(xval_in(ii)%value,1)
   n2=size(xval_in(ii)%value,2)
   ival=indx(ii)
   if (associated(xval_out(ival)%value)) then
     ABI_DEALLOCATE(xval_out(ival)%value)
   end if
   ABI_ALLOCATE(xval_out(ival)%value,(n1,n2))
   xval_out(ii)%value=xval_in(ival)%value
 end do
#endif

end subroutine xallgatherv_mpi_coeff2d_indx
!!***
