!{\src2tex{textfont=tt}}
!!****f* ABINIT/xallgather_mpi
!! NAME
!!  xallgather_mpi
!!
!! FUNCTION
!!  This module contains functions that calls MPI routine,
!!  if we compile the code using the  MPI CPP flags.
!!  xallgather_mpi is the generic function.
!!
!! COPYRIGHT
!!  Copyright (C) 2001-2012 ABINIT group (AR,XG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~ABINIT/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

!!***

!!****f* ABINIT/xallgather_mpi_int
!! NAME
!!  xallgather_mpi_int
!!
!! FUNCTION
!!  Gathers data from all tasks and distributes it to all.
!!  Target: one-dimensional integer arrays.
!!
!! INPUTS
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  xval= buffer array
!!  recvbuf= received elements
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allgather
!!
!! SOURCE

subroutine xallgather_mpi_int(xval,recvbuf,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgather_mpi_int'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(inout) :: xval
 integer,intent(inout) :: recvbuf(:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************
 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
!  allgather xval on all proc. in spaceComm
   call MPI_ALLGATHER(xval,1,MPI_INTEGER,recvbuf,1,MPI_INTEGER,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
   recvbuf(1)=xval
 end if
#else
 recvbuf(1)=xval
#endif
end subroutine xallgather_mpi_int
!!***



!!****f* ABINIT/xallgather_mpi_char
!! NAME
!!  xallgather_mpi_char
!!
!! FUNCTION
!!  Gathers data from all tasks and distributes it to all.
!!  Target: one-dimensional character(20) arrays.
!!
!! INPUTS
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  charval= buffer array
!!  recvbuf= received elements
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allgather
!!
!! SOURCE

subroutine xallgather_mpi_char(charval,recvbuf,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgather_mpi_char'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(in)  :: spaceComm
 integer,intent(out) :: ier
 character(20),intent(inout) :: charval
 character(20),intent(inout) :: recvbuf(:)

! *************************************************************************
 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
!  allgather xval on all proc. in spaceComm
   call MPI_ALLGATHER(charval,20,MPI_CHARACTER,recvbuf,20,MPI_CHARACTER,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
   recvbuf=charval
 end if
#else
 recvbuf=charval
#endif
end subroutine xallgather_mpi_char
!!***


!!****f* ABINIT/xallgather_mpi_int1d
!! NAME
!!  xallgather_mpi_int1d
!!
!! FUNCTION
!!  Gathers data from all tasks and distributes it to all.
!!  Target: one-dimensional integer arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received elements
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allgather
!!
!! SOURCE

subroutine xallgather_mpi_int1d(xval,nelem,recvbuf,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgather_mpi_int1d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(in) :: xval(:)
 integer,intent(inout) :: recvbuf(:)
 integer ,intent(in) :: nelem,spaceComm
 integer ,intent(out)   :: ier

! *************************************************************************
 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
!  allgather xval on all proc. in spaceComm
   call MPI_ALLGATHER(xval,nelem,MPI_INTEGER,recvbuf,nelem,MPI_INTEGER,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
   recvbuf(1:nelem)=xval(1:nelem)
 end if
#else
 recvbuf(1:nelem)=xval(1:nelem)
#endif
end subroutine xallgather_mpi_int1d
!!***

!!****f* ABINIT/xallgather_mpi_dp1d
!! NAME
!!  xallgather_mpi_dp1d
!!
!! FUNCTION
!!  Gathers data from all tasks and distributes it to all.
!!  Target: double precision one-dimensional arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received elements
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allgather
!!
!! SOURCE

subroutine xallgather_mpi_dp1d(xval,nelem,recvbuf,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgather_mpi_dp1d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(in) :: xval(:)
 real(dp),intent(inout) :: recvbuf(:)
 integer ,intent(in) :: nelem,spaceComm
 integer ,intent(out)   :: ier

! *************************************************************************
 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
!  allgather xval on all proc. in spaceComm
   call MPI_ALLGATHER(xval,nelem,MPI_DOUBLE_PRECISION,recvbuf,nelem,MPI_DOUBLE_PRECISION,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
   recvbuf(1:nelem)=xval(1:nelem)
 end if
#else
 recvbuf(1:nelem)=xval(1:nelem)
#endif
end subroutine xallgather_mpi_dp1d
!!***

!!****f* ABINIT/xallgather_mpi_dp2d
!! NAME
!!  xallgather_mpi_dp2d
!!
!! FUNCTION
!!  Gathers data from all tasks and distributes it to all.
!!  Target: double precision two-dimensional arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received elements
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allgather
!!
!! SOURCE

subroutine xallgather_mpi_dp2d(xval,nelem,recvbuf,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgather_mpi_dp2d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(in) :: xval(:,:)
 real(dp),intent(inout) :: recvbuf(:,:)
 integer ,intent(in) :: nelem,spaceComm
 integer ,intent(out)   :: ier

! *************************************************************************
 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
!  allgather xval on all proc. in spaceComm
   call MPI_ALLGATHER(xval,nelem,MPI_DOUBLE_PRECISION,recvbuf,nelem,MPI_DOUBLE_PRECISION,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
   recvbuf(:,:)=xval(:,:)
 end if
#else
 recvbuf(:,:)=xval(:,:)
#endif
end subroutine xallgather_mpi_dp2d
!!***

!!****f* ABINIT/xallgather_mpi_dp3d
!! NAME
!!  xallgather_mpi_dp3d
!!
!! FUNCTION
!!  Gathers data from all tasks and distributes it to all.
!!  Target: double precision three-dimensional arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received elements
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allgather
!!
!! SOURCE

subroutine xallgather_mpi_dp3d(xval,nelem,recvbuf,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgather_mpi_dp3d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
   real(dp),intent(in) :: xval(:,:,:)
   real(dp),intent(inout) :: recvbuf(:,:,:)
   integer ,intent(in) :: nelem,spaceComm
   integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************
 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
!  allgather xval on all proc. in spaceComm
   call MPI_ALLGATHER(xval,nelem,MPI_DOUBLE_PRECISION,recvbuf,nelem,MPI_DOUBLE_PRECISION,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
   recvbuf(:,:,:)=xval(:,:,:)
 end if
#else
 recvbuf(:,:,:)=xval(:,:,:)
#endif
end subroutine xallgather_mpi_dp3d
!!***

!!****f* ABINIT/xallgather_mpi_dp4d
!! NAME
!!  xallgather_mpi_dp4d
!!
!! FUNCTION
!!  Gathers data from all tasks and distributes it to all.
!!  Target: double precision four-dimensional arrays.
!!
!! INPUTS
!!  xval= buffer array
!!  nelem= number of elements
!!  spaceComm= MPI communicator
!!
!! OUTPUT
!!  ier= exit status, a non-zero value meaning there is an error
!!
!! SIDE EFFECTS
!!  recvbuf= received elements
!!
!! PARENTS
!!
!! CHILDREN
!!      mpi_allgather
!!
!! SOURCE

subroutine xallgather_mpi_dp4d(xval,nelem,recvbuf,spaceComm,ier)


 use defs_basis
#if defined HAVE_MPI2 && ! defined HAVE_MPI_INCLUDED_ONCE
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'xallgather_mpi_dp4d'
!End of the abilint section

 implicit none

#if defined HAVE_MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
   real(dp),intent(in) :: xval(:,:,:,:)
   real(dp),intent(inout) :: recvbuf(:,:,:,:)
   integer ,intent(in) :: nelem,spaceComm
   integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************
 ier=0
#if defined HAVE_MPI
 if (spaceComm /= MPI_COMM_SELF .and. spaceComm /= MPI_COMM_NULL) then
!  allgather xval on all proc. in spaceComm
   call MPI_ALLGATHER(xval,nelem,MPI_DOUBLE_PRECISION,recvbuf,nelem,MPI_DOUBLE_PRECISION,spaceComm,ier)
 else if (spaceComm == MPI_COMM_SELF) then
   recvbuf(:,:,:,:)=xval(:,:,:,:)
 end if
#else
 recvbuf(:,:,:,:)=xval(:,:,:,:)
#endif
end subroutine xallgather_mpi_dp4d
!!***
