#!/bin/sh
#
# Copyright (C) 2011 Yann Pouillon
#
# This file is part of the Abinit GUI software package. For license information,
# please see the COPYING file in the top-level directory of the source
# distribution.
#

#
# IMPORTANT NOTE:
#
#   For maintainer use only!
#
#   PLEASE DO NOT EDIT THIS FILE, AS IT COULD CAUSE A SERIOUS LOSS OF DATA.
#   *** YOU HAVE BEEN WARNED! ***
#

# Check that we are in the right directory
if test ! -s "./configure.ac" -o ! -s "src/Main.java"; then
  echo "[guiclean] Cowardly refusing to remove something from here!" >&2
  exit 1
fi

# Remove temporary directories and files
echo "[guiclean] Removing temporary directories and files"
rm -rf tmp*
find . -depth -name 'tmp-*' -exec rm -rf {} \;
find src -name '*.~[0-9]~' -exec rm -f {} \;

# Remove autotools files
echo "[guiclean] Removing autotools files"
find src -depth -name '.deps' -exec rm -rf {} \;
find src -depth -name '.libs' -exec rm -rf {} \;
rm -f core config.log config.status stamp-h1 config.h config.h.in*
rm -rf aclocal.m4 autom4te.cache configure confstat*
(cd gnu && rm -f config.guess config.sub depcomp install-sh ltmain.sh missing)

# Remove Makefiles and machine-generated files
echo "[guiclean] Removing files produced by the configure script"
find . -name Makefile -exec rm {} \;
find . -name Makefile.in -exec rm {} \;

# Remove object files, libraries and programs
echo "[guiclean] Removing object files, libraries and programs"
rm -f src/Prog/*.class
rm -f src/Prog/*.jar
