/*--
 WavefuncDens.java - Created March 27, 2010

 Copyright (c) 2009-2011 Flavio Miguel ABREU ARAUJO.
 Universit catholique de Louvain, Louvain-la-Neuve, Belgium
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions, and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions, and the disclaimer that follows
    these conditions in the documentation and/or other materials
    provided with the distribution.

 3. The names of the author may not be used to endorse or promote
    products derived from this software without specific prior written
    permission.

 In addition, we request (but do not require) that you include in the
 end-user documentation provided with the redistribution and/or in the
 software itself an acknowledgement equivalent to the following:
     "This product includes software developed by the
      Abinit Project (http://www.abinit.org/)."

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED.  IN NO EVENT SHALL THE JDOM AUTHORS OR THE PROJECT
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 For more information on the Abinit Project, please see
 <http://www.abinit.org/>.
 */

package abinitgui;

import java.awt.Color;

//@SuppressWarnings("serial")
public class WavefuncDens extends javax.swing.JPanel {

    private DisplayerJDialog outDialog;

    /** Creates new form WavefuncDens */
    public WavefuncDens(DisplayerJDialog outD, MainFrame parent) {
        outDialog = outD;
        initComponents();
    }

    public void printERR(String s) {
        // TODO mettre de la couleur
        if (s.endsWith("\n")) {
            outDialog.appendERR(s);
        } else {
            outDialog.appendERR(s + "\n");
        }
    }

    public void printOUT(String s) {
        if (s.endsWith("\n")) {
            outDialog.appendOUT(s);
        } else {
            outDialog.appendOUT(s + "\n");
        }
    }

    String removeEndl(String str) {
        if (str.endsWith("\n")) {
            return (String) str.subSequence(0, str.lastIndexOf('\n'));
        } else {
            return str;
        }
    }

    private void printDEB(String str) {
        if (str.endsWith("\n")) {
            outDialog.appendDEB("DEBUG: " + str);
        } else {
            outDialog.appendDEB("DEBUG: " + str + "\n");
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    //@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        nsppolCheckBox = new javax.swing.JCheckBox();
        occCheckBox = new javax.swing.JCheckBox();
        nsppolComboBox = new javax.swing.JComboBox();
        occoptComboBox = new javax.swing.JComboBox();
        occoptCheckBox = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        occTextArea = new javax.swing.JTextArea();
        occLabel = new javax.swing.JLabel();
        nbandTextField = new javax.swing.JTextField();
        nbandCheckBox = new javax.swing.JCheckBox();
        nspdenCheckBox = new javax.swing.JCheckBox();
        nspdenTextField = new javax.swing.JTextField();
        nspinorTextField = new javax.swing.JTextField();
        nspinorCheckBox = new javax.swing.JCheckBox();
        pawspnorbCheckBox = new javax.swing.JCheckBox();
        pawspnorbTextField = new javax.swing.JTextField();
        jScrollPane2 = new javax.swing.JScrollPane();
        nbandTextArea = new javax.swing.JTextArea();

        nsppolCheckBox.setForeground(java.awt.Color.blue);
        nsppolCheckBox.setText("nsppol");
        nsppolCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nsppolCheckBoxActionPerformed(evt);
            }
        });

        occCheckBox.setForeground(java.awt.Color.blue);
        occCheckBox.setText("occ");
        occCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                occCheckBoxActionPerformed(evt);
            }
        });

        nsppolComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "1", "2" }));
        nsppolComboBox.setEnabled(false);

        occoptComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "0", "1", "2", "3", "4", "5", "6", "7" }));
        occoptComboBox.setEnabled(false);
        occoptComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                occoptComboBoxActionPerformed(evt);
            }
        });

        occoptCheckBox.setForeground(java.awt.Color.blue);
        occoptCheckBox.setText("occopt");
        occoptCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                occoptCheckBoxActionPerformed(evt);
            }
        });

        occTextArea.setColumns(20);
        occTextArea.setRows(5);
        occTextArea.setEnabled(false);
        jScrollPane1.setViewportView(occTextArea);

        occLabel.setText("(see Abinit help)");

        nbandTextField.setEnabled(false);

        nbandCheckBox.setForeground(java.awt.Color.blue);
        nbandCheckBox.setText("nband");
        nbandCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nbandCheckBoxActionPerformed(evt);
            }
        });

        nspdenCheckBox.setForeground(java.awt.Color.blue);
        nspdenCheckBox.setText("nspden");
        nspdenCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nspdenCheckBoxActionPerformed(evt);
            }
        });

        nspdenTextField.setEnabled(false);

        nspinorTextField.setEnabled(false);

        nspinorCheckBox.setForeground(java.awt.Color.blue);
        nspinorCheckBox.setText("nspinor");
        nspinorCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nspinorCheckBoxActionPerformed(evt);
            }
        });

        pawspnorbCheckBox.setForeground(java.awt.Color.blue);
        pawspnorbCheckBox.setText("pawspnorb");
        pawspnorbCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pawspnorbCheckBoxActionPerformed(evt);
            }
        });

        pawspnorbTextField.setEnabled(false);

        nbandTextArea.setColumns(20);
        nbandTextArea.setRows(5);
        nbandTextArea.setEnabled(false);
        jScrollPane2.setViewportView(nbandTextArea);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(nsppolCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nsppolComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(nspdenCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nspdenTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(nspinorCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nspinorTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(pawspnorbCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(pawspnorbTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(nbandCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nbandTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(occoptCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(occoptComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(284, 284, 284)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(occCheckBox)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(occLabel))))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(nsppolComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(nsppolCheckBox)
                    .addComponent(nspdenCheckBox)
                    .addComponent(nspdenTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(nspinorCheckBox)
                    .addComponent(nspinorTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(pawspnorbCheckBox)
                    .addComponent(pawspnorbTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(nbandCheckBox)
                            .addComponent(nbandTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(occoptCheckBox)
                            .addComponent(occoptComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(occCheckBox)
                            .addComponent(occLabel))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void nsppolCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nsppolCheckBoxActionPerformed
        if (nsppolCheckBox.isSelected()) {
            nsppolCheckBox.setForeground(Color.red);
            nsppolComboBox.setEnabled(true);
        } else {
            nsppolCheckBox.setForeground(Color.blue);
            nsppolComboBox.setEnabled(false);
        }
    }//GEN-LAST:event_nsppolCheckBoxActionPerformed

    private void nspdenCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nspdenCheckBoxActionPerformed
        if (nspdenCheckBox.isSelected()) {
            nspdenCheckBox.setForeground(Color.red);
            nspdenTextField.setEnabled(true);
        } else {
            nspdenCheckBox.setForeground(Color.blue);
            nspdenTextField.setEnabled(false);
        }
    }//GEN-LAST:event_nspdenCheckBoxActionPerformed

    private void nspinorCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nspinorCheckBoxActionPerformed
        if (nspinorCheckBox.isSelected()) {
            nspinorCheckBox.setForeground(Color.red);
            nspinorTextField.setEnabled(true);
        } else {
            nspinorCheckBox.setForeground(Color.blue);
            nspinorTextField.setEnabled(false);
        }
    }//GEN-LAST:event_nspinorCheckBoxActionPerformed

    private void pawspnorbCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pawspnorbCheckBoxActionPerformed
        if (pawspnorbCheckBox.isSelected()) {
            pawspnorbCheckBox.setForeground(Color.red);
            pawspnorbTextField.setEnabled(true);
        } else {
            pawspnorbCheckBox.setForeground(Color.blue);
            pawspnorbTextField.setEnabled(false);
        }
    }//GEN-LAST:event_pawspnorbCheckBoxActionPerformed

    private void occoptCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_occoptCheckBoxActionPerformed
        if (occoptCheckBox.isSelected()) {
            occoptCheckBox.setForeground(Color.red);
            occoptComboBox.setEnabled(true);
        } else {
            occoptCheckBox.setForeground(Color.blue);
            occoptComboBox.setEnabled(false);
        }
    }//GEN-LAST:event_occoptCheckBoxActionPerformed

    private void nbandCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nbandCheckBoxActionPerformed
        if (nbandCheckBox.isSelected()) {
            nbandCheckBox.setForeground(Color.red);
            if (occoptCheckBox.isSelected() && occoptComboBox.getSelectedItem().equals("2")) {
                nbandTextArea.setEnabled(true);
            } else {
                nbandTextField.setEnabled(true);
            }
        } else {
            nbandCheckBox.setForeground(Color.blue);
            nbandTextArea.setEnabled(false);
            nbandTextField.setEnabled(false);
        }
    }//GEN-LAST:event_nbandCheckBoxActionPerformed

    private void occCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_occCheckBoxActionPerformed
        if (occCheckBox.isSelected()) {
            occCheckBox.setForeground(Color.red);
            occTextArea.setEnabled(true);
        } else {
            occCheckBox.setForeground(Color.blue);
            occTextArea.setEnabled(false);
        }
    }//GEN-LAST:event_occCheckBoxActionPerformed

    private void occoptComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_occoptComboBoxActionPerformed
        if (occoptComboBox.getSelectedItem().equals("2")) {
            if (nbandCheckBox.isSelected()) {
                nbandTextArea.setEnabled(true);
                nbandTextField.setEnabled(false);
            }
        } else {
            if (nbandCheckBox.isSelected()) {
                nbandTextArea.setEnabled(false);
                nbandTextField.setEnabled(true);
            }
        }
    }//GEN-LAST:event_occoptComboBoxActionPerformed

    public String getData() {
        String file = new String();

        // NSPPOL *************************************************************
        if (nsppolCheckBox.isSelected()) {
            file += nsppolCheckBox.getText() + " ";
            file += nsppolComboBox.getSelectedItem() + "\n\n";
        }
        // NSPDEN ***************************************************************
        if (nspdenCheckBox.isSelected()) {
            try {
                int nspden = Integer.parseInt(nspdenTextField.getText());
                file += nspdenCheckBox.getText() + " ";
                file += nspden + "\n\n";
            } catch (Exception e) {
                printERR("Please set up NSPDEN (must be an integer) !");
            }
        }
        // NSPINOR ***************************************************************
        if (nspinorCheckBox.isSelected()) {
            try {
                int nspinor = Integer.parseInt(nspinorTextField.getText());
                file += nspinorCheckBox.getText() + " ";
                file += nspinor + "\n\n";
            } catch (Exception e) {
                printERR("Please set up NSPINOR (must be an integer) !");
            }
        }
        // PAWSPNORB ***************************************************************
        if (pawspnorbCheckBox.isSelected()) {
            try {
                int pawspnorb = Integer.parseInt(pawspnorbTextField.getText());
                file += pawspnorbCheckBox.getText() + " ";
                file += pawspnorb + "\n\n";
            } catch (Exception e) {
                printERR("Please set up PAWSPNORB (must be an integer) !");
            }
        }
        // OCCOPT *************************************************************
        if (occoptCheckBox.isSelected()) {
            file += occoptCheckBox.getText() + " ";
            file += occoptComboBox.getSelectedItem() + "\n\n";
        }
        // NBAND *************************************************************
        if (nbandCheckBox.isSelected()) {
            if (occoptCheckBox.isSelected() && occoptComboBox.getSelectedItem().equals("2")) {
                if (!nbandTextArea.getText().equals("")) {
                    file += nbandCheckBox.getText() + " ";
                    file += nbandTextArea.getText() + "\n\n";
                } else {
                    printERR("Please set up NBAND !");
                }
            } else {
                try {
                    int nband = Integer.parseInt(nbandTextField.getText());
                    file += nbandCheckBox.getText() + " ";
                    file += nband + "\n\n";
                } catch (Exception e) {
                    printERR("Please set up NBAND (must be an integer) !");
                }
            }
        }
        // OCC *************************************************************
        if (occCheckBox.isSelected()) {
            if (!occTextArea.getText().equals("")) {
                file += occCheckBox.getText() + " ";
                file += occTextArea.getText() + "\n\n";
            } else {
                printERR("Please set up OCC !");
            }
        }

        return file;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JCheckBox nbandCheckBox;
    private javax.swing.JTextArea nbandTextArea;
    private javax.swing.JTextField nbandTextField;
    private javax.swing.JCheckBox nspdenCheckBox;
    private javax.swing.JTextField nspdenTextField;
    private javax.swing.JCheckBox nspinorCheckBox;
    private javax.swing.JTextField nspinorTextField;
    private javax.swing.JCheckBox nsppolCheckBox;
    private javax.swing.JComboBox nsppolComboBox;
    private javax.swing.JCheckBox occCheckBox;
    private javax.swing.JLabel occLabel;
    private javax.swing.JTextArea occTextArea;
    private javax.swing.JCheckBox occoptCheckBox;
    private javax.swing.JComboBox occoptComboBox;
    private javax.swing.JCheckBox pawspnorbCheckBox;
    private javax.swing.JTextField pawspnorbTextField;
    // End of variables declaration//GEN-END:variables
}
