/*--
 RealRecip.java - Created March 27, 2010

 Copyright (c) 2009-2011 Flavio Miguel ABREU ARAUJO.
 Universit catholique de Louvain, Louvain-la-Neuve, Belgium
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions, and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions, and the disclaimer that follows
    these conditions in the documentation and/or other materials
    provided with the distribution.

 3. The names of the author may not be used to endorse or promote
    products derived from this software without specific prior written
    permission.

 In addition, we request (but do not require) that you include in the
 end-user documentation provided with the redistribution and/or in the
 software itself an acknowledgement equivalent to the following:
     "This product includes software developed by the
      Abinit Project (http://www.abinit.org/)."

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED.  IN NO EVENT SHALL THE JDOM AUTHORS OR THE PROJECT
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 For more information on the Abinit Project, please see
 <http://www.abinit.org/>.
 */

package abinitgui;

import java.awt.Color;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/**
 *
 * @author flavio
 */
//@SuppressWarnings("serial")
public class RealRecip extends javax.swing.JPanel {

    private DisplayerJDialog outDialog;
    private MyTableModel kptModel = null;
    private MyTableModel shiftkModel = null;
    private MyTableModel wtkModel = null;

    /** Creates new form RealRecip */
    public RealRecip(DisplayerJDialog outD, MainFrame parent) {
        outDialog = outD;
        initComponents();

        kptModel = new MyTableModel(kptTable);
        kptTable.setModel(kptModel);
        initTableHeader(kptTable, new String[]{"a*", "b*", "c*"},
                new Integer[]{null, null, null});
        kptTable.setVisible(false);

        shiftkModel = new MyTableModel(shiftkTable);
        shiftkTable.setModel(shiftkModel);
        initTableHeader(shiftkTable, new String[]{"a*", "b*", "c*"},
                new Integer[]{null, null, null});
        shiftkTable.setVisible(false);

        wtkModel = new MyTableModel(wtkTable);
        wtkTable.setModel(wtkModel);
        initTableHeader(wtkTable, new String[]{"k-point weight"},
                new Integer[]{null});
        wtkTable.setVisible(false);
    }

    private void initTableHeader(JTable table, String header[], Integer headerWidths[]) {
        TableColumnModel tcm = new DefaultTableColumnModel();
        for (int i = 0; i < header.length; i++) {
            TableColumn tc = new TableColumn(i);
            tc.setHeaderValue(header[i]);
            tc.setResizable(false);
            if (headerWidths[i] != null) {
                tc.setMinWidth(headerWidths[i]);
                tc.setPreferredWidth(headerWidths[i]);
                tc.setMaxWidth(headerWidths[i]);
            }
            tcm.addColumn(tc);
        }
        table.setColumnModel(tcm);
    }

    public void printERR(String s) {
        // TODO mettre de la couleur
        if (s.endsWith("\n")) {
            outDialog.appendERR(s);
        } else {
            outDialog.appendERR(s + "\n");
        }
    }

    public void printOUT(String s) {
        if (s.endsWith("\n")) {
            outDialog.appendOUT(s);
        } else {
            outDialog.appendOUT(s + "\n");
        }
    }

    String removeEndl(String str) {
        if (str.endsWith("\n")) {
            return (String) str.subSequence(0, str.lastIndexOf('\n'));
        } else {
            return str;
        }
    }

    private void printDEB(String str) {
        if (str.endsWith("\n")) {
            outDialog.appendDEB("DEBUG: " + str);
        } else {
            outDialog.appendDEB("DEBUG: " + str + "\n");
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    //@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        ndtsetCheckBox = new javax.swing.JCheckBox();
        ecutPanel = new javax.swing.JPanel();
        ecutUnitsLabel2 = new javax.swing.JLabel();
        ecutUnitsLabel1 = new javax.swing.JLabel();
        ecutTextField2 = new javax.swing.JTextField();
        ecutTextField1 = new javax.swing.JTextField();
        ecutLabel2 = new javax.swing.JLabel();
        ecutCheckBox = new javax.swing.JCheckBox();
        ecutMultisetCheckBox = new javax.swing.JCheckBox();
        ngkptPanel = new javax.swing.JPanel();
        ngkptLabel2 = new javax.swing.JLabel();
        ngkptCheckBox = new javax.swing.JCheckBox();
        ngkptMultisetCheckBox = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        ngkptTextField1 = new javax.swing.JTextField();
        ngkptTextField2 = new javax.swing.JTextField();
        ngkptTextField3 = new javax.swing.JTextField();
        ngkptTextField6 = new javax.swing.JTextField();
        ngkptTextField5 = new javax.swing.JTextField();
        ngkptTextField4 = new javax.swing.JTextField();
        ngkptLabel3 = new javax.swing.JLabel();
        ndtsetTextField = new javax.swing.JTextField();
        shiftkTableScrollPane = new javax.swing.JScrollPane();
        shiftkTable = new javax.swing.JTable();
        shiftkCheckBox = new javax.swing.JCheckBox();
        nshiftkTextField = new javax.swing.JTextField();
        nshiftkCheckBox = new javax.swing.JCheckBox();
        ecutsmCheckBox = new javax.swing.JCheckBox();
        ecutsmTextField = new javax.swing.JTextField();
        wtkCheckBox = new javax.swing.JCheckBox();
        kptTableScrollPane1 = new javax.swing.JScrollPane();
        wtkTable = new javax.swing.JTable();
        kptoptTextField = new javax.swing.JTextField();
        kptoptComboBox = new javax.swing.JComboBox();
        kptoptCheckBox = new javax.swing.JCheckBox();
        kptTableScrollPane = new javax.swing.JScrollPane();
        kptTable = new javax.swing.JTable();
        nkptTextField = new javax.swing.JTextField();
        kptCheckBox = new javax.swing.JCheckBox();
        nkptCheckBox = new javax.swing.JCheckBox();
        kptnrmCheckBox = new javax.swing.JCheckBox();
        kptnrmTextField = new javax.swing.JTextField();
        pawecutdgCheckBox = new javax.swing.JCheckBox();
        pawecutdgTextField = new javax.swing.JTextField();

        ndtsetCheckBox.setForeground(java.awt.Color.blue);
        ndtsetCheckBox.setText("ndtset");
        ndtsetCheckBox.setEnabled(false);
        ndtsetCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ndtsetCheckBoxActionPerformed(evt);
            }
        });

        ecutPanel.setMaximumSize(new java.awt.Dimension(325, 56));
        ecutPanel.setMinimumSize(new java.awt.Dimension(325, 56));

        ecutUnitsLabel2.setText("(step)");
        ecutUnitsLabel2.setEnabled(false);

        ecutUnitsLabel1.setText("[Hartree]");
        ecutUnitsLabel1.setEnabled(false);

        ecutTextField2.setEnabled(false);

        ecutTextField1.setEnabled(false);

        ecutLabel2.setForeground(java.awt.Color.red);
        ecutLabel2.setText("ecut+");
        ecutLabel2.setEnabled(false);

        ecutCheckBox.setForeground(java.awt.Color.blue);
        ecutCheckBox.setText("ecut");
        ecutCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ecutCheckBoxActionPerformed(evt);
            }
        });

        ecutMultisetCheckBox.setForeground(new java.awt.Color(52, 145, 52));
        ecutMultisetCheckBox.setText("multiset");
        ecutMultisetCheckBox.setEnabled(false);
        ecutMultisetCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ecutMultisetCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout ecutPanelLayout = new javax.swing.GroupLayout(ecutPanel);
        ecutPanel.setLayout(ecutPanelLayout);
        ecutPanelLayout.setHorizontalGroup(
            ecutPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(ecutPanelLayout.createSequentialGroup()
                .addGroup(ecutPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ecutCheckBox)
                    .addGroup(ecutPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(ecutLabel2)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(ecutPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(ecutPanelLayout.createSequentialGroup()
                        .addComponent(ecutTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ecutUnitsLabel2))
                    .addGroup(ecutPanelLayout.createSequentialGroup()
                        .addComponent(ecutTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ecutUnitsLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE)
                        .addComponent(ecutMultisetCheckBox))))
        );
        ecutPanelLayout.setVerticalGroup(
            ecutPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(ecutPanelLayout.createSequentialGroup()
                .addGap(1, 1, 1)
                .addComponent(ecutCheckBox))
            .addGroup(ecutPanelLayout.createSequentialGroup()
                .addGroup(ecutPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(ecutTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ecutUnitsLabel1)
                    .addComponent(ecutMultisetCheckBox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(ecutPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(ecutTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ecutUnitsLabel2)
                    .addComponent(ecutLabel2)))
        );

        ngkptPanel.setMaximumSize(new java.awt.Dimension(325, 56));
        ngkptPanel.setMinimumSize(new java.awt.Dimension(325, 56));

        ngkptLabel2.setForeground(java.awt.Color.red);
        ngkptLabel2.setText("ngkpt+");
        ngkptLabel2.setEnabled(false);

        ngkptCheckBox.setForeground(java.awt.Color.blue);
        ngkptCheckBox.setText("ngkpt");
        ngkptCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ngkptCheckBoxActionPerformed(evt);
            }
        });

        ngkptMultisetCheckBox.setForeground(new java.awt.Color(52, 145, 52));
        ngkptMultisetCheckBox.setText("multiset");
        ngkptMultisetCheckBox.setEnabled(false);
        ngkptMultisetCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ngkptMultisetCheckBoxActionPerformed(evt);
            }
        });

        ngkptTextField1.setEnabled(false);
        ngkptTextField1.setMaximumSize(new java.awt.Dimension(10, 25));

        ngkptTextField2.setEnabled(false);
        ngkptTextField2.setMaximumSize(new java.awt.Dimension(10, 25));

        ngkptTextField3.setEnabled(false);
        ngkptTextField3.setMaximumSize(new java.awt.Dimension(10, 25));

        ngkptTextField6.setEnabled(false);
        ngkptTextField6.setMaximumSize(new java.awt.Dimension(10, 25));

        ngkptTextField5.setEnabled(false);
        ngkptTextField5.setMaximumSize(new java.awt.Dimension(10, 25));

        ngkptTextField4.setEnabled(false);
        ngkptTextField4.setMaximumSize(new java.awt.Dimension(10, 25));

        ngkptLabel3.setText("(step)");
        ngkptLabel3.setEnabled(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(ngkptTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ngkptTextField4, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(ngkptTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ngkptTextField5, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ngkptTextField3, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ngkptTextField6, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ngkptLabel3))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(ngkptTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(ngkptTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(ngkptTextField3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(31, 31, 31)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(ngkptTextField5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ngkptTextField4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ngkptTextField6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ngkptLabel3)))
        );

        javax.swing.GroupLayout ngkptPanelLayout = new javax.swing.GroupLayout(ngkptPanel);
        ngkptPanel.setLayout(ngkptPanelLayout);
        ngkptPanelLayout.setHorizontalGroup(
            ngkptPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(ngkptPanelLayout.createSequentialGroup()
                .addGroup(ngkptPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ngkptCheckBox)
                    .addGroup(ngkptPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(ngkptLabel2)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE)
                .addComponent(ngkptMultisetCheckBox))
        );
        ngkptPanelLayout.setVerticalGroup(
            ngkptPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(ngkptPanelLayout.createSequentialGroup()
                .addComponent(ngkptCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(ngkptLabel2))
            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addComponent(ngkptMultisetCheckBox)
        );

        ndtsetTextField.setEnabled(false);

        shiftkTableScrollPane.setMaximumSize(new java.awt.Dimension(325, 110));
        shiftkTableScrollPane.setMinimumSize(new java.awt.Dimension(325, 110));
        shiftkTableScrollPane.setPreferredSize(new java.awt.Dimension(325, 110));

        shiftkTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {},
                {},
                {}
            },
            new String [] {

            }
        ));
        shiftkTable.setEnabled(false);
        shiftkTable.setRowSelectionAllowed(false);
        shiftkTable.getTableHeader().setReorderingAllowed(false);
        shiftkTableScrollPane.setViewportView(shiftkTable);

        shiftkCheckBox.setForeground(java.awt.Color.blue);
        shiftkCheckBox.setText("shiftk");
        shiftkCheckBox.setEnabled(false);
        shiftkCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                shiftkCheckBoxActionPerformed(evt);
            }
        });

        nshiftkTextField.setEnabled(false);
        nshiftkTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                nshiftkTextFieldKeyReleased(evt);
            }
        });

        nshiftkCheckBox.setForeground(java.awt.Color.blue);
        nshiftkCheckBox.setText("nshiftk");
        nshiftkCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nshiftkCheckBoxActionPerformed(evt);
            }
        });

        ecutsmCheckBox.setForeground(java.awt.Color.blue);
        ecutsmCheckBox.setText("ecutsm");
        ecutsmCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ecutsmCheckBoxActionPerformed(evt);
            }
        });

        ecutsmTextField.setEnabled(false);

        wtkCheckBox.setForeground(java.awt.Color.blue);
        wtkCheckBox.setText("wtk");
        wtkCheckBox.setEnabled(false);
        wtkCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wtkCheckBoxActionPerformed(evt);
            }
        });

        kptTableScrollPane1.setMaximumSize(new java.awt.Dimension(325, 110));
        kptTableScrollPane1.setMinimumSize(new java.awt.Dimension(325, 110));
        kptTableScrollPane1.setPreferredSize(new java.awt.Dimension(325, 110));

        wtkTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        wtkTable.setEnabled(false);
        wtkTable.setRowSelectionAllowed(false);
        wtkTable.getTableHeader().setReorderingAllowed(false);
        kptTableScrollPane1.setViewportView(wtkTable);

        kptoptTextField.setEnabled(false);

        kptoptComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "neg.", "0", "1", "2", "3", "4" }));
        kptoptComboBox.setSelectedIndex(1);
        kptoptComboBox.setEnabled(false);
        kptoptComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                kptoptComboBoxActionPerformed(evt);
            }
        });

        kptoptCheckBox.setForeground(java.awt.Color.blue);
        kptoptCheckBox.setText("kptopt");
        kptoptCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                kptoptCheckBoxActionPerformed(evt);
            }
        });

        kptTableScrollPane.setMaximumSize(new java.awt.Dimension(325, 110));
        kptTableScrollPane.setMinimumSize(new java.awt.Dimension(325, 110));
        kptTableScrollPane.setPreferredSize(new java.awt.Dimension(325, 110));

        kptTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        kptTable.setEnabled(false);
        kptTable.setRowSelectionAllowed(false);
        kptTable.getTableHeader().setReorderingAllowed(false);
        kptTableScrollPane.setViewportView(kptTable);

        nkptTextField.setEnabled(false);
        nkptTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                nkptTextFieldKeyReleased(evt);
            }
        });

        kptCheckBox.setForeground(java.awt.Color.blue);
        kptCheckBox.setText("kpt");
        kptCheckBox.setEnabled(false);
        kptCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                kptCheckBoxActionPerformed(evt);
            }
        });

        nkptCheckBox.setForeground(java.awt.Color.blue);
        nkptCheckBox.setText("nkpt");
        nkptCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nkptCheckBoxActionPerformed(evt);
            }
        });

        kptnrmCheckBox.setForeground(java.awt.Color.blue);
        kptnrmCheckBox.setText("kptnrm ");
        kptnrmCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                kptnrmCheckBoxActionPerformed(evt);
            }
        });

        kptnrmTextField.setEnabled(false);

        pawecutdgCheckBox.setForeground(java.awt.Color.blue);
        pawecutdgCheckBox.setText("pawecutdg");
        pawecutdgCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pawecutdgCheckBoxActionPerformed(evt);
            }
        });

        pawecutdgTextField.setEnabled(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ecutPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(ndtsetCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ndtsetTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(ngkptPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(nshiftkCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nshiftkTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 59, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(shiftkCheckBox))
                    .addComponent(shiftkTableScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(ecutsmCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ecutsmTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(pawecutdgCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(pawecutdgTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(kptoptCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(kptoptComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(kptoptTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 43, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(nkptCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nkptTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 52, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(kptCheckBox))
                    .addComponent(kptTableScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(wtkCheckBox)
                    .addComponent(kptTableScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(kptnrmCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(kptnrmTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(ndtsetCheckBox)
                            .addComponent(ndtsetTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ecutPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ngkptPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(nshiftkCheckBox)
                            .addComponent(nshiftkTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(shiftkCheckBox))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(shiftkTableScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(ecutsmCheckBox)
                            .addComponent(ecutsmTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(pawecutdgCheckBox)
                            .addComponent(pawecutdgTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(kptoptCheckBox)
                            .addComponent(kptoptComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(kptoptTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(nkptCheckBox)
                            .addComponent(nkptTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(kptCheckBox))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(kptTableScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(wtkCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(kptTableScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(kptnrmCheckBox)
                            .addComponent(kptnrmTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void ndtsetCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ndtsetCheckBoxActionPerformed
        ndtsetCheckBox.setSelected(true);
}//GEN-LAST:event_ndtsetCheckBoxActionPerformed

    private void ecutCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ecutCheckBoxActionPerformed
        if (ecutCheckBox.isSelected()) {
            ecutCheckBox.setForeground(Color.red);
            ecutTextField1.setEnabled(true);
            ecutUnitsLabel1.setEnabled(true);
            ecutMultisetCheckBox.setEnabled(true);
        } else {
            ecutCheckBox.setForeground(Color.blue);
            ecutTextField1.setEnabled(false);
            ecutUnitsLabel1.setEnabled(false);
            ecutMultisetCheckBox.setEnabled(false);
            if (ecutMultisetCheckBox.isSelected()) {
                ecutMultisetCheckBox.setSelected(false);
                ecutMultisetCheckBoxActionPerformed(evt);
            }
        }
}//GEN-LAST:event_ecutCheckBoxActionPerformed

    private void ecutMultisetCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ecutMultisetCheckBoxActionPerformed
        if (ecutMultisetCheckBox.isSelected()) {
            ngkptMultisetCheckBox.setSelected(false);
            ngkptMultisetCheckBoxActionPerformed(evt);

            ecutCheckBox.setText("ecut:");
            ecutLabel2.setEnabled(true);
            ecutTextField2.setEnabled(true);
            ecutUnitsLabel2.setEnabled(true);

            ndtsetCheckBox.setEnabled(true);
            ndtsetCheckBox.setSelected(true);
            ndtsetCheckBox.setForeground(Color.red);
            ndtsetTextField.setEnabled(true);
            printERR("Fill in ndtset please !");
        } else {
            ecutCheckBox.setText("ecut");
            ecutLabel2.setEnabled(false);
            ecutTextField2.setEnabled(false);
            ecutUnitsLabel2.setEnabled(false);

            ndtsetCheckBox.setEnabled(false);
            ndtsetCheckBox.setSelected(false);
            ndtsetCheckBox.setForeground(Color.blue);
            ndtsetTextField.setEnabled(false);
        }
}//GEN-LAST:event_ecutMultisetCheckBoxActionPerformed

    private void ngkptCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ngkptCheckBoxActionPerformed
        if (ngkptCheckBox.isSelected()) {
            ngkptCheckBox.setForeground(Color.red);
            ngkptTextField1.setEnabled(true);
            ngkptTextField2.setEnabled(true);
            ngkptTextField3.setEnabled(true);
            ngkptMultisetCheckBox.setEnabled(true);
        } else {
            ngkptCheckBox.setForeground(Color.blue);
            ngkptTextField1.setEnabled(false);
            ngkptTextField2.setEnabled(false);
            ngkptTextField3.setEnabled(false);
            ngkptMultisetCheckBox.setEnabled(false);
            if (ngkptMultisetCheckBox.isSelected()) {
                ngkptMultisetCheckBox.setSelected(false);
                ngkptMultisetCheckBoxActionPerformed(evt);
            }
        }
}//GEN-LAST:event_ngkptCheckBoxActionPerformed

    private void ngkptMultisetCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ngkptMultisetCheckBoxActionPerformed
        if (ngkptMultisetCheckBox.isSelected()) {
            ecutMultisetCheckBox.setSelected(false);
            ecutMultisetCheckBoxActionPerformed(evt);

            ngkptCheckBox.setText("ngkpt:");
            ngkptLabel2.setEnabled(true);
            ngkptLabel3.setEnabled(true);
            ngkptTextField4.setEnabled(true);
            ngkptTextField5.setEnabled(true);
            ngkptTextField6.setEnabled(true);

            ndtsetCheckBox.setEnabled(true);
            ndtsetCheckBox.setSelected(true);
            ndtsetCheckBox.setForeground(Color.red);
            ndtsetTextField.setEnabled(true);
            printERR("Fill in ndtset please !");
        } else {
            ngkptCheckBox.setText("ngkpt");
            ngkptLabel2.setEnabled(false);
            ngkptLabel3.setEnabled(false);
            ngkptTextField4.setEnabled(false);
            ngkptTextField5.setEnabled(false);
            ngkptTextField6.setEnabled(false);

            ndtsetCheckBox.setEnabled(false);
            ndtsetCheckBox.setSelected(false);
            ndtsetCheckBox.setForeground(Color.blue);
            ndtsetTextField.setEnabled(false);
        }
}//GEN-LAST:event_ngkptMultisetCheckBoxActionPerformed

    private void shiftkCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_shiftkCheckBoxActionPerformed
        shiftkCheckBox.setSelected(true);
}//GEN-LAST:event_shiftkCheckBoxActionPerformed

    private void nshiftkTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_nshiftkTextFieldKeyReleased
        try {
            int nshiftk = Integer.parseInt(nshiftkTextField.getText());

            if (nshiftk > 1000) {
                nshiftk = 1000;
                Object strTab[][] = new Object[nshiftk][3];
                for (int i = 0; i < nshiftk; i++) {
                    strTab[i] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0)};
                }
                shiftkModel.setData(strTab);
            } else {
                Object strTab[][] = new Object[nshiftk][3];
                for (int i = 0; i < nshiftk; i++) {
                    strTab[i] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0)};
                }
                shiftkModel.setData(strTab);
            }
        } catch (Exception e) {
            //printERR(e.getMessage());
            shiftkModel.setData(null);
        }
}//GEN-LAST:event_nshiftkTextFieldKeyReleased

    private void nshiftkCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nshiftkCheckBoxActionPerformed
        if (nshiftkCheckBox.isSelected()) {
            nshiftkCheckBox.setForeground(Color.red);
            shiftkCheckBox.setForeground(Color.red);
            shiftkCheckBox.setEnabled(true);
            shiftkCheckBox.setSelected(true);

            nshiftkTextField.setEnabled(true);
            shiftkTable.setEnabled(true);
            shiftkTable.setVisible(true);
        } else {
            nshiftkCheckBox.setForeground(Color.blue);
            //shiftkCheckBox.setForeground(Color.red);
            shiftkCheckBox.setEnabled(false);
            shiftkCheckBox.setSelected(false);

            nshiftkTextField.setEnabled(false);
            shiftkTable.setEnabled(false);
            shiftkTable.setVisible(false);
        }
}//GEN-LAST:event_nshiftkCheckBoxActionPerformed

    private void ecutsmCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ecutsmCheckBoxActionPerformed
        if (ecutsmCheckBox.isSelected()) {
            ecutsmCheckBox.setForeground(Color.red);
            ecutsmTextField.setEnabled(true);
        } else {
            ecutsmCheckBox.setForeground(Color.blue);
            ecutsmTextField.setEnabled(false);
        }
}//GEN-LAST:event_ecutsmCheckBoxActionPerformed

    private void wtkCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wtkCheckBoxActionPerformed
        wtkCheckBox.setSelected(true);
}//GEN-LAST:event_wtkCheckBoxActionPerformed

    private void kptoptComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_kptoptComboBoxActionPerformed
        if (kptoptComboBox.getSelectedItem().equals(kptoptComboBox.getItemAt(0))) {
            kptoptTextField.setEnabled(true);
        } else {
            kptoptTextField.setEnabled(false);
        }
}//GEN-LAST:event_kptoptComboBoxActionPerformed

    private void kptoptCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_kptoptCheckBoxActionPerformed
        if (kptoptCheckBox.isSelected()) {
            kptoptCheckBox.setForeground(Color.red);
            kptoptComboBox.setEnabled(true);
            if (kptoptComboBox.getSelectedItem().equals("neg.")) {
                kptoptTextField.setEnabled(true);
            }
        } else {
            kptoptCheckBox.setForeground(Color.blue);
            kptoptComboBox.setEnabled(false);
            kptoptTextField.setEnabled(false);
        }
}//GEN-LAST:event_kptoptCheckBoxActionPerformed

    private void nkptTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_nkptTextFieldKeyReleased
        try {
            int nkpt = Integer.parseInt(nkptTextField.getText());

            if (nkpt > 1000) {
                nkpt = 1000;
                Object strTab[][] = new Object[nkpt][3];
                for (int i = 0; i < nkpt; i++) {
                    strTab[i] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0)};
                }
                kptModel.setData(strTab);
            } else {
                Object strTab[][] = new Object[nkpt][3];
                for (int i = 0; i < nkpt; i++) {
                    strTab[i] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0)};
                }
                kptModel.setData(strTab);
            }

            if (nkpt > 1000) {
                nkpt = 1000;
                Object strTab[][] = new Object[nkpt][3];
                for (int i = 0; i < nkpt; i++) {
                    strTab[i] = new Object[]{new Double(0.0)};
                }
                wtkModel.setData(strTab);
            } else {
                Object strTab[][] = new Object[nkpt][3];
                for (int i = 0; i < nkpt; i++) {
                    strTab[i] = new Object[]{new Double(0.0)};
                }
                wtkModel.setData(strTab);
            }
        } catch (Exception e) {
            //printERR(e.getMessage());
            kptModel.setData(null);
            wtkModel.setData(null);
        }
}//GEN-LAST:event_nkptTextFieldKeyReleased

    private void kptCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_kptCheckBoxActionPerformed
        kptCheckBox.setSelected(true);
}//GEN-LAST:event_kptCheckBoxActionPerformed

    private void nkptCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nkptCheckBoxActionPerformed
        if (nkptCheckBox.isSelected()) {
            nkptCheckBox.setForeground(Color.red);
            kptCheckBox.setForeground(Color.red);
            kptCheckBox.setEnabled(true);
            kptCheckBox.setSelected(true);
            wtkCheckBox.setForeground(Color.red);
            wtkCheckBox.setEnabled(true);
            wtkCheckBox.setSelected(true);

            nkptTextField.setEnabled(true);
            kptTable.setEnabled(true);
            kptTable.setVisible(true);
            wtkTable.setEnabled(true);
            wtkTable.setVisible(true);
        } else {
            nkptCheckBox.setForeground(Color.blue);
            //kptCheckBox.setForeground(Color.red);
            kptCheckBox.setEnabled(false);
            kptCheckBox.setSelected(false);
            wtkCheckBox.setEnabled(false);
            wtkCheckBox.setSelected(false);

            nkptTextField.setEnabled(false);
            kptTable.setEnabled(false);
            kptTable.setVisible(false);
            wtkTable.setEnabled(false);
            wtkTable.setVisible(false);
        }
}//GEN-LAST:event_nkptCheckBoxActionPerformed

    private void kptnrmCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_kptnrmCheckBoxActionPerformed
        if (kptnrmCheckBox.isSelected()) {
            kptnrmCheckBox.setForeground(Color.red);
            kptnrmTextField.setEnabled(true);
        } else {
            kptnrmCheckBox.setForeground(Color.blue);
            kptnrmTextField.setEnabled(false);
        }
    }//GEN-LAST:event_kptnrmCheckBoxActionPerformed

    private void pawecutdgCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pawecutdgCheckBoxActionPerformed
        if (pawecutdgCheckBox.isSelected()) {
            pawecutdgCheckBox.setForeground(Color.red);
            pawecutdgTextField.setEnabled(true);
        } else {
            pawecutdgCheckBox.setForeground(Color.blue);
            pawecutdgTextField.setEnabled(false);
        }
    }//GEN-LAST:event_pawecutdgCheckBoxActionPerformed

    public String getData() {
        String file = new String();

        // NDTSET **************************************************************
        if (ndtsetCheckBox.isSelected()) {
            try {
                int ndtset;
                ndtset = Integer.parseInt(ndtsetTextField.getText());
                file += ndtsetCheckBox.getText() + " " + ndtset + "\n\n";
            } catch (Exception e) {
                printERR("Please set up NDTSET !");
            }

        }
        // ECUT ****************************************************************
        if (ecutCheckBox.isSelected()) {
            if (ecutMultisetCheckBox.isSelected()) {
                try {
                    double ecut1 = Double.parseDouble(ecutTextField1.getText());
                    double ecut2 = Double.parseDouble(ecutTextField2.getText());
                    file += ecutCheckBox.getText() + " " + ecut1 + "    ";
                    file += ecutLabel2.getText() + " " + ecut2 + "\n\n";
                } catch (Exception e) {
                    printERR("Please set up ECUT:/ECUT+ !");
                }

            } else {
                try {
                    double ecut = Double.parseDouble(ecutTextField1.getText());
                    file += ecutCheckBox.getText() + " ";
                    file += ecut + "\n\n";
                } catch (Exception e) {
                    printERR("Please set up ECUT !");
                }

            }
        }
        // NGKPT ***************************************************************
        if (ngkptCheckBox.isSelected()) {
            if (ngkptMultisetCheckBox.isSelected()) {
                try {
                    int ngkpt1 = Integer.parseInt(ngkptTextField1.getText());
                    int ngkpt2 = Integer.parseInt(ngkptTextField2.getText());
                    int ngkpt3 = Integer.parseInt(ngkptTextField3.getText());
                    int ngkpt4 = Integer.parseInt(ngkptTextField4.getText());
                    int ngkpt5 = Integer.parseInt(ngkptTextField5.getText());
                    int ngkpt6 = Integer.parseInt(ngkptTextField6.getText());

                    file += ngkptCheckBox.getText() + " " + ngkpt1 + " " + ngkpt2 + " " + ngkpt3 + "    ";
                    file += ngkptLabel2.getText() + " " + ngkpt4 + " " + ngkpt5 + " " + ngkpt6 + "\n\n";
                } catch (Exception e) {
                    printERR("Please set up NGKPT:/NGKPT+ !");
                }

            } else {
                try {
                    int ngkpt1 = Integer.parseInt(ngkptTextField1.getText());
                    int ngkpt2 = Integer.parseInt(ngkptTextField2.getText());
                    int ngkpt3 = Integer.parseInt(ngkptTextField3.getText());

                    file += ngkptCheckBox.getText() + " ";
                    if (ngkpt1 == ngkpt2 || ngkpt2 == ngkpt3) {
                        file += "3*" + ngkpt1 + "\n\n";
                    } else {
                        file += ngkpt1 + " " + ngkpt2 + " " + ngkpt3 + "\n\n";
                    }

                } catch (Exception e) {
                    printERR("Please set up NGKPT !");
                }

            }
        }
        // ECUTSM *************************************************************
        if (ecutsmCheckBox.isSelected()) {
            try {
                double ecutsm = Double.parseDouble(ecutsmTextField.getText());
                file += ecutsmCheckBox.getText() + " ";
                file += ecutsm + "\n\n";
            } catch (Exception e) {
                printERR("Please set up ECUTSM !");
            }

        }
        // NSHIFTK *************************************************************
        if (nshiftkCheckBox.isSelected()) {
            try {
                int nsym;
                nsym = Integer.parseInt(nshiftkTextField.getText());
                file += nshiftkCheckBox.getText() + " " + nsym + "\n\n";
            } catch (Exception e) {
                printERR("Please set up NSHIFTK !");
            }

        }
        // SHIFTK **************************************************************
        if (shiftkCheckBox.isSelected()) {
            int col = shiftkTable.getColumnCount();
            int row = shiftkTable.getRowCount();
            if (row > 0) {
                int len = shiftkCheckBox.getText().length();
                file += shiftkCheckBox.getText();
                for (int i = 0; i < row; i++) {
                    for (int j = 0; j < col; j++) {
                        try {
                            file += " " + shiftkTable.getValueAt(i, j);
                        } catch (Exception e) {
                            printERR("Please set up SHIFTK !");
                        }
                    }
                    file += "\n";
                    for (int j = 0; j < len; j++) {
                        file += " ";
                    }
                }
                file += "\n";
            }
        }
        // KPTOPT **************************************************************
        if (kptoptCheckBox.isSelected()) {

            if (kptoptComboBox.getSelectedItem().equals("neg.")) {
                try {
                    int kptopt = Integer.parseInt(kptoptTextField.getText());
                    file += kptoptCheckBox.getText() + " ";
                    file += kptopt;
                } catch (Exception e) {
                    printERR("Please set up KPTOPT !");
                }
            } else {
                file += kptoptCheckBox.getText() + " ";
                file += kptoptComboBox.getSelectedItem() + "\n\n";
            }
        }
        // NKPT ****************************************************************
        if (nkptCheckBox.isSelected()) {
            try {
                int nsym;
                nsym = Integer.parseInt(nkptTextField.getText());
                file += nkptCheckBox.getText() + " " + nsym + "\n\n";
            } catch (Exception e) {
                printERR("Please set up NKPT !");
            }

        }
        // KPT, WTK ************************************************************
        if (kptCheckBox.isSelected()) {
            int col = kptTable.getColumnCount();
            int row = kptTable.getRowCount();
            if (row > 0) {
                int len = kptCheckBox.getText().length();
                file += kptCheckBox.getText();
                for (int i = 0; i < row; i++) {
                    for (int j = 0; j < col; j++) {
                        try {
                            file += " " + kptTable.getValueAt(i, j);
                        } catch (Exception e) {
                            printERR("Please set up KPT !");
                        }
                    }
                    file += "\n";
                    for (int j = 0; j < len; j++) {
                        file += " ";
                    }
                }
                file += "\n";
            }
        }
        if (wtkCheckBox.isSelected()) {
            int col = wtkTable.getColumnCount();
            int row = wtkTable.getRowCount();
            if (row > 0) {
                int len = wtkCheckBox.getText().length();
                file += wtkCheckBox.getText();
                for (int i = 0; i < row; i++) {
                    for (int j = 0; j < col; j++) {
                        try {
                            file += " " + wtkTable.getValueAt(i, j);
                        } catch (Exception e) {
                            printERR("Please set up WTK !");
                        }
                    }
                    file += "\n";
                    for (int j = 0; j < len; j++) {
                        file += " ";
                    }
                }
                file += "\n";
            }
        }
        // KPTNRM *************************************************************
        if (kptnrmCheckBox.isSelected()) {
            try {
                double kptnrm = Double.parseDouble(kptnrmTextField.getText());
                file += kptnrmCheckBox.getText() + " ";
                file += kptnrm + "\n\n";
            } catch (Exception e) {
                printERR("Please set up KPTNRM !");
            }

        }
        // PAWECUTDG *************************************************************
        if (pawecutdgCheckBox.isSelected()) {
            try {
                double pawecutdg = Double.parseDouble(pawecutdgTextField.getText());
                file += pawecutdgCheckBox.getText() + " ";
                file += pawecutdg + "\n\n";
            } catch (Exception e) {
                printERR("Please set up PAWECUTDG !");
            }

        }

        return file;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox ecutCheckBox;
    private javax.swing.JLabel ecutLabel2;
    private javax.swing.JCheckBox ecutMultisetCheckBox;
    private javax.swing.JPanel ecutPanel;
    private javax.swing.JTextField ecutTextField1;
    private javax.swing.JTextField ecutTextField2;
    private javax.swing.JLabel ecutUnitsLabel1;
    private javax.swing.JLabel ecutUnitsLabel2;
    private javax.swing.JCheckBox ecutsmCheckBox;
    private javax.swing.JTextField ecutsmTextField;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JCheckBox kptCheckBox;
    private javax.swing.JTable kptTable;
    private javax.swing.JScrollPane kptTableScrollPane;
    private javax.swing.JScrollPane kptTableScrollPane1;
    private javax.swing.JCheckBox kptnrmCheckBox;
    private javax.swing.JTextField kptnrmTextField;
    private javax.swing.JCheckBox kptoptCheckBox;
    private javax.swing.JComboBox kptoptComboBox;
    private javax.swing.JTextField kptoptTextField;
    private javax.swing.JCheckBox ndtsetCheckBox;
    private javax.swing.JTextField ndtsetTextField;
    private javax.swing.JCheckBox ngkptCheckBox;
    private javax.swing.JLabel ngkptLabel2;
    private javax.swing.JLabel ngkptLabel3;
    private javax.swing.JCheckBox ngkptMultisetCheckBox;
    private javax.swing.JPanel ngkptPanel;
    private javax.swing.JTextField ngkptTextField1;
    private javax.swing.JTextField ngkptTextField2;
    private javax.swing.JTextField ngkptTextField3;
    private javax.swing.JTextField ngkptTextField4;
    private javax.swing.JTextField ngkptTextField5;
    private javax.swing.JTextField ngkptTextField6;
    private javax.swing.JCheckBox nkptCheckBox;
    private javax.swing.JTextField nkptTextField;
    private javax.swing.JCheckBox nshiftkCheckBox;
    private javax.swing.JTextField nshiftkTextField;
    private javax.swing.JCheckBox pawecutdgCheckBox;
    private javax.swing.JTextField pawecutdgTextField;
    private javax.swing.JCheckBox shiftkCheckBox;
    private javax.swing.JTable shiftkTable;
    private javax.swing.JScrollPane shiftkTableScrollPane;
    private javax.swing.JCheckBox wtkCheckBox;
    private javax.swing.JTable wtkTable;
    // End of variables declaration//GEN-END:variables
}
