/*--
 DisplayerJDialog.java - Created January 30, 2010

 Copyright (c) 2009-2011 Flavio Miguel ABREU ARAUJO.
 Universit catholique de Louvain, Louvain-la-Neuve, Belgium
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions, and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions, and the disclaimer that follows
    these conditions in the documentation and/or other materials
    provided with the distribution.

 3. The names of the author may not be used to endorse or promote
    products derived from this software without specific prior written
    permission.

 In addition, we request (but do not require) that you include in the
 end-user documentation provided with the redistribution and/or in the
 software itself an acknowledgement equivalent to the following:
     "This product includes software developed by the
      Abinit Project (http://www.abinit.org/)."

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED.  IN NO EVENT SHALL THE JDOM AUTHORS OR THE PROJECT
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 For more information on the Abinit Project, please see
 <http://www.abinit.org/>.
 */

package abinitgui;

import java.awt.Color;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

//@SuppressWarnings("serial")
public class DisplayerJDialog extends javax.swing.JDialog {

    private StyledDocument doc;
    Style styleU;
    Style succes;
    Style failure;
    Style debug;
    Style out2;

    void printOUT(String str) {
        if (str != null) {
            if (str.endsWith("\n")) {
                System.out.print(str);
            } else {
                System.out.println(str);
            }
        }
    }

    void printERR(String str) {
        if (str != null) {
            if (str.endsWith("\n")) {
                System.err.print(str);
            } else {
                System.err.println(str);
            }
        }
    }

    /** Creates new form DisplayerJDialog */
    public DisplayerJDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();

        doc = (StyledDocument) MSGTextPane.getDocument();

        // Add a couple of styles
        styleU = doc.addStyle("UnderLine", null);
        succes = doc.addStyle("Succes", null);
        failure = doc.addStyle("Failure", null);
        debug = doc.addStyle("Debug", null);
        out2 = doc.addStyle("Out2", null);

        StyleConstants.setUnderline(styleU, true);
        // set the Foreground, can define other attrs too.
        StyleConstants.setForeground(succes, Color.BLUE);
        StyleConstants.setBold(succes, true);
        StyleConstants.setForeground(failure, Color.RED);
        StyleConstants.setBold(failure, true);
        StyleConstants.setForeground(debug, Color.DARK_GRAY);
        StyleConstants.setBold(debug, false);
        StyleConstants.setForeground(out2, Color.DARK_GRAY);
        StyleConstants.setBold(out2, true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    //@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        MSGScrollPane = new javax.swing.JScrollPane();
        MSGTextPane = new javax.swing.JTextPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        MSGTextPane.setEditable(false);
        MSGTextPane.setFont(new java.awt.Font("DejaVu Sans", 1, 13)); // NOI18N
        MSGTextPane.setAutoscrolls(true);
        MSGTextPane.setDragEnabled(true);
        MSGScrollPane.setViewportView(MSGTextPane);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(MSGScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 534, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(MSGScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    public void appendOUT(String msg) {
        try {
            doc.insertString(doc.getLength(), msg, succes);
            MSGTextPane.setCaretPosition(doc.getLength());
        } catch (Exception e) {
            printERR(e.getMessage());
        }
    }

    public void appendERR(String msg) {
        try {
            doc.insertString(doc.getLength(), msg, failure);
            MSGTextPane.setCaretPosition(doc.getLength());
        } catch (Exception e) {
            printERR(e.getMessage());
        }
    }

    public void appendDEB(String msg) {
        try {
            doc.insertString(doc.getLength(), msg, debug);
            MSGTextPane.setCaretPosition(doc.getLength());
        } catch (Exception e) {
            printERR(e.getMessage());
        }
    }

    public void appendOUT2(String msg) {
        try {
            doc.insertString(doc.getLength(), msg, out2);
            MSGTextPane.setCaretPosition(doc.getLength());
        } catch (Exception e) {
            printERR(e.getMessage());
        }
    }

    // append gnrique
    public void appendGEN(String msg, Color color, boolean underline, boolean bold) {
        Style gen = doc.addStyle("gen", null);
        StyleConstants.setUnderline(gen, underline);
        StyleConstants.setForeground(gen, color);
        StyleConstants.setBold(gen, bold);
        try {
            doc.insertString(doc.getLength(), msg, gen);
            MSGTextPane.setCaretPosition(doc.getLength());
        } catch (Exception e) {
            printERR(e.getMessage());
        }
    }

    public void setText(String msg) {
        try {
            MSGTextPane.setText(msg);
            MSGTextPane.setCaretPosition(0);
        } catch (Exception e) {
            printERR(e.getMessage());
        }
    }

    public void clear() {
        MSGTextPane.setText("");
    }
    
    public void setEditable(boolean bool) {
        MSGTextPane.setEditable(bool);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane MSGScrollPane;
    private javax.swing.JTextPane MSGTextPane;
    // End of variables declaration//GEN-END:variables
}
