/*--
 AlgoAndConv.java - Created March 26, 2010

 Copyright (c) 2009-2011 Flavio Miguel ABREU ARAUJO.
 Universit catholique de Louvain, Louvain-la-Neuve, Belgium
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions, and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions, and the disclaimer that follows
    these conditions in the documentation and/or other materials
    provided with the distribution.

 3. The names of the author may not be used to endorse or promote
    products derived from this software without specific prior written
    permission.

 In addition, we request (but do not require) that you include in the
 end-user documentation provided with the redistribution and/or in the
 software itself an acknowledgement equivalent to the following:
     "This product includes software developed by the
      Abinit Project (http://www.abinit.org/)."

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED.  IN NO EVENT SHALL THE JDOM AUTHORS OR THE PROJECT
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 For more information on the Abinit Project, please see
 <http://www.abinit.org/>.
 */

package abinitgui;

import java.awt.Color;
import javax.swing.JPanel;

/**
 *
 * @author flavio
 */
//@SuppressWarnings("serial")
public class AlgoAndConv extends JPanel {

    private DisplayerJDialog outDialog;

    /** Creates new form AlgoAndConv */
    public AlgoAndConv(DisplayerJDialog outD, MainFrame parent) {
        outDialog = outD;
        initComponents();
    }

    public void printERR(String s) {
        // TODO mettre de la couleur
        if (s.endsWith("\n")) {
            outDialog.appendERR(s);
        } else {
            outDialog.appendERR(s + "\n");
        }
    }

    public void printOUT(String s) {
        if (s.endsWith("\n")) {
            outDialog.appendOUT(s);
        } else {
            outDialog.appendOUT(s + "\n");
        }
    }

    String removeEndl(String str) {
        if (str.endsWith("\n")) {
            return (String) str.subSequence(0, str.lastIndexOf('\n'));
        } else {
            return str;
        }
    }

    private void printDEB(String str) {
        if (str.endsWith("\n")) {
            outDialog.appendDEB("DEBUG: " + str);
        } else {
            outDialog.appendDEB("DEBUG: " + str + "\n");
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        tolbuttonGroup = new javax.swing.ButtonGroup();
        iscfCheckBox = new javax.swing.JCheckBox();
        iscfComboBox = new javax.swing.JComboBox();
        nstepCheckBox = new javax.swing.JCheckBox();
        nstepTextField = new javax.swing.JTextField();
        toldfeCheckBox = new javax.swing.JCheckBox();
        toldfeTextField = new javax.swing.JTextField();
        toldffCheckBox = new javax.swing.JCheckBox();
        toldffTextField = new javax.swing.JTextField();
        tolrffCheckBox = new javax.swing.JCheckBox();
        tolrffTextField = new javax.swing.JTextField();
        tolvrsCheckBox = new javax.swing.JCheckBox();
        tolvrsTextField = new javax.swing.JTextField();
        tolwfrCheckBox = new javax.swing.JCheckBox();
        tolwfrTextField = new javax.swing.JTextField();
        optcellCheckBox = new javax.swing.JCheckBox();
        optcellComboBox = new javax.swing.JComboBox();
        dilatmxCheckBox = new javax.swing.JCheckBox();
        dilatmxTextField = new javax.swing.JTextField();
        ionmovCheckBox = new javax.swing.JCheckBox();
        ionmovComboBox = new javax.swing.JComboBox();
        diemacCheckBox = new javax.swing.JCheckBox();
        diemacTextField = new javax.swing.JTextField();
        diemixCheckBox = new javax.swing.JCheckBox();
        diemixTextField = new javax.swing.JTextField();
        iprcelCheckBox = new javax.swing.JCheckBox();
        iprcelTextField = new javax.swing.JTextField();
        jSeparator1 = new javax.swing.JSeparator();
        jSeparator2 = new javax.swing.JSeparator();
        ntimeCheckBox = new javax.swing.JCheckBox();
        ntimeTextField = new javax.swing.JTextField();
        tolmxfCheckBox = new javax.swing.JCheckBox();
        tolmxfTextField = new javax.swing.JTextField();

        iscfCheckBox.setForeground(java.awt.Color.blue);
        iscfCheckBox.setText("iscf");
        iscfCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                iscfCheckBoxActionPerformed(evt);
            }
        });

        iscfComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "-3", "-2", "-1", "1", "2", "3", "4", "5", "7", "12", "13", "14", "15", "17" }));
        iscfComboBox.setSelectedIndex(8);
        iscfComboBox.setEnabled(false);

        nstepCheckBox.setForeground(java.awt.Color.blue);
        nstepCheckBox.setText("nstep");
        nstepCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nstepCheckBoxActionPerformed(evt);
            }
        });

        nstepTextField.setEnabled(false);

        tolbuttonGroup.add(toldfeCheckBox);
        toldfeCheckBox.setForeground(java.awt.Color.blue);
        toldfeCheckBox.setText("toldfe");
        toldfeCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                toldfeCheckBoxActionPerformed(evt);
            }
        });

        toldfeTextField.setEnabled(false);

        tolbuttonGroup.add(toldffCheckBox);
        toldffCheckBox.setForeground(java.awt.Color.blue);
        toldffCheckBox.setText("toldff");
        toldffCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                toldffCheckBoxActionPerformed(evt);
            }
        });

        toldffTextField.setEnabled(false);

        tolbuttonGroup.add(tolrffCheckBox);
        tolrffCheckBox.setForeground(java.awt.Color.blue);
        tolrffCheckBox.setText("tolrff");
        tolrffCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tolrffCheckBoxActionPerformed(evt);
            }
        });

        tolrffTextField.setEnabled(false);

        tolbuttonGroup.add(tolvrsCheckBox);
        tolvrsCheckBox.setForeground(java.awt.Color.blue);
        tolvrsCheckBox.setText("tolvrs");
        tolvrsCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tolvrsCheckBoxActionPerformed(evt);
            }
        });

        tolvrsTextField.setEnabled(false);

        tolbuttonGroup.add(tolwfrCheckBox);
        tolwfrCheckBox.setForeground(java.awt.Color.blue);
        tolwfrCheckBox.setText("tolwfr");
        tolwfrCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tolwfrCheckBoxActionPerformed(evt);
            }
        });

        tolwfrTextField.setEnabled(false);

        optcellCheckBox.setForeground(java.awt.Color.blue);
        optcellCheckBox.setText("optcell");
        optcellCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                optcellCheckBoxActionPerformed(evt);
            }
        });

        optcellComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "0", "1", "2", "3", "4", "5", "6", "7", "8" }));
        optcellComboBox.setSelectedIndex(1);
        optcellComboBox.setEnabled(false);

        dilatmxCheckBox.setForeground(java.awt.Color.blue);
        dilatmxCheckBox.setText("dilatmx");
        dilatmxCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dilatmxCheckBoxActionPerformed(evt);
            }
        });

        dilatmxTextField.setEnabled(false);

        ionmovCheckBox.setForeground(java.awt.Color.blue);
        ionmovCheckBox.setText("ionmov");
        ionmovCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ionmovCheckBoxActionPerformed(evt);
            }
        });

        ionmovComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "13", "14" }));
        ionmovComboBox.setSelectedIndex(0);
        ionmovComboBox.setEnabled(false);

        diemacCheckBox.setForeground(java.awt.Color.blue);
        diemacCheckBox.setText("diemac");
        diemacCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                diemacCheckBoxActionPerformed(evt);
            }
        });

        diemacTextField.setEnabled(false);

        diemixCheckBox.setForeground(java.awt.Color.blue);
        diemixCheckBox.setText("diemix");
        diemixCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                diemixCheckBoxActionPerformed(evt);
            }
        });

        diemixTextField.setEnabled(false);

        iprcelCheckBox.setForeground(java.awt.Color.blue);
        iprcelCheckBox.setText("iprcel");
        iprcelCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                iprcelCheckBoxActionPerformed(evt);
            }
        });

        iprcelTextField.setEnabled(false);

        ntimeCheckBox.setForeground(java.awt.Color.blue);
        ntimeCheckBox.setText("ntime");
        ntimeCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ntimeCheckBoxActionPerformed(evt);
            }
        });

        ntimeTextField.setEnabled(false);

        tolmxfCheckBox.setForeground(java.awt.Color.blue);
        tolmxfCheckBox.setText("tolmxf");
        tolmxfCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tolmxfCheckBoxActionPerformed(evt);
            }
        });

        tolmxfTextField.setEnabled(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(iscfCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(iscfComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(nstepCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nstepTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 138, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(diemacCheckBox)
                        .addGap(6, 6, 6)
                        .addComponent(diemacTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(diemixCheckBox)
                        .addGap(6, 6, 6)
                        .addComponent(diemixTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(iprcelCheckBox)
                        .addGap(6, 6, 6)
                        .addComponent(iprcelTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(50, 50, 50)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(toldfeCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(toldfeTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(tolrffCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tolrffTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(toldffCheckBox)
                        .addGap(6, 6, 6)
                        .addComponent(toldffTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(tolvrsCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tolvrsTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(tolwfrCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tolwfrTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(55, 55, 55)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(dilatmxCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(dilatmxTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(optcellCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(optcellComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, 138, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(ionmovCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(ionmovComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(ntimeCheckBox)
                        .addGap(6, 6, 6)
                        .addComponent(ntimeTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(tolmxfCheckBox)
                        .addGap(6, 6, 6)
                        .addComponent(tolmxfTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(iscfCheckBox)
                            .addComponent(iscfComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(nstepCheckBox)
                            .addComponent(nstepTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(diemacCheckBox)
                            .addComponent(diemacTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(diemixCheckBox)
                            .addComponent(diemixTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(iprcelCheckBox)
                            .addComponent(iprcelTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(toldfeCheckBox)
                                    .addComponent(toldfeTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(toldffCheckBox)
                                    .addComponent(toldffTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(66, 66, 66)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(tolrffCheckBox)
                                    .addComponent(tolrffTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(tolvrsCheckBox)
                            .addComponent(tolvrsTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(tolwfrCheckBox)
                            .addComponent(tolwfrTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(optcellCheckBox)
                            .addComponent(optcellComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(dilatmxCheckBox)
                            .addComponent(dilatmxTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(ionmovCheckBox)
                            .addComponent(ionmovComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(ntimeCheckBox)
                            .addComponent(ntimeTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(tolmxfCheckBox)
                            .addComponent(tolmxfTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void optcellCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optcellCheckBoxActionPerformed
        if (optcellCheckBox.isSelected()) {
            optcellCheckBox.setForeground(Color.red);
            optcellComboBox.setEnabled(true);
        } else {
            optcellCheckBox.setForeground(Color.blue);
            optcellComboBox.setEnabled(false);
        }
}//GEN-LAST:event_optcellCheckBoxActionPerformed

    private void dilatmxCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dilatmxCheckBoxActionPerformed
        if (dilatmxCheckBox.isSelected()) {
            dilatmxCheckBox.setForeground(Color.red);
            dilatmxTextField.setEnabled(true);
        } else {
            dilatmxCheckBox.setForeground(Color.blue);
            dilatmxTextField.setEnabled(false);
        }
}//GEN-LAST:event_dilatmxCheckBoxActionPerformed

    private void ionmovCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ionmovCheckBoxActionPerformed
        if (ionmovCheckBox.isSelected()) {
            ionmovCheckBox.setForeground(Color.red);
            ionmovComboBox.setEnabled(true);
        } else {
            ionmovCheckBox.setForeground(Color.blue);
            ionmovComboBox.setEnabled(false);
        }
    }//GEN-LAST:event_ionmovCheckBoxActionPerformed

    private void iscfCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_iscfCheckBoxActionPerformed
        if (iscfCheckBox.isSelected()) {
            iscfCheckBox.setForeground(Color.red);
            iscfComboBox.setEnabled(true);
        } else {
            iscfCheckBox.setForeground(Color.blue);
            iscfComboBox.setEnabled(false);
        }
    }//GEN-LAST:event_iscfCheckBoxActionPerformed

    private void nstepCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nstepCheckBoxActionPerformed
        if (nstepCheckBox.isSelected()) {
            nstepCheckBox.setForeground(Color.red);
            nstepTextField.setEnabled(true);
        } else {
            nstepCheckBox.setForeground(Color.blue);
            nstepTextField.setEnabled(false);
        }
    }//GEN-LAST:event_nstepCheckBoxActionPerformed

    private void toldfeCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_toldfeCheckBoxActionPerformed
        if (toldfeCheckBox.isSelected()) {
            toldfeCheckBox.setForeground(Color.red);
            toldfeTextField.setEnabled(true);
            toldffCheckBox.setForeground(Color.blue);
            toldffTextField.setEnabled(false);
            tolrffCheckBox.setForeground(Color.blue);
            tolrffTextField.setEnabled(false);
            tolvrsCheckBox.setForeground(Color.blue);
            tolvrsTextField.setEnabled(false);
            tolwfrCheckBox.setForeground(Color.blue);
            tolwfrTextField.setEnabled(false);
        } else {
            toldfeCheckBox.setForeground(Color.blue);
            toldfeTextField.setEnabled(false);
        }
    }//GEN-LAST:event_toldfeCheckBoxActionPerformed

    private void toldffCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_toldffCheckBoxActionPerformed
        if (toldffCheckBox.isSelected()) {
            toldffCheckBox.setForeground(Color.red);
            toldffTextField.setEnabled(true);
            toldfeCheckBox.setForeground(Color.blue);
            toldfeTextField.setEnabled(false);
            tolrffCheckBox.setForeground(Color.blue);
            tolrffTextField.setEnabled(false);
            tolvrsCheckBox.setForeground(Color.blue);
            tolvrsTextField.setEnabled(false);
            tolwfrCheckBox.setForeground(Color.blue);
            tolwfrTextField.setEnabled(false);
        } else {
            toldffCheckBox.setForeground(Color.blue);
            toldffTextField.setEnabled(false);
        }
    }//GEN-LAST:event_toldffCheckBoxActionPerformed

    private void tolrffCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tolrffCheckBoxActionPerformed
        if (tolrffCheckBox.isSelected()) {
            tolrffCheckBox.setForeground(Color.red);
            tolrffTextField.setEnabled(true);
            toldfeCheckBox.setForeground(Color.blue);
            toldfeTextField.setEnabled(false);
            toldffCheckBox.setForeground(Color.blue);
            toldffTextField.setEnabled(false);
            tolvrsCheckBox.setForeground(Color.blue);
            tolvrsTextField.setEnabled(false);
            tolwfrCheckBox.setForeground(Color.blue);
            tolwfrTextField.setEnabled(false);
        } else {
            tolrffCheckBox.setForeground(Color.blue);
            tolrffTextField.setEnabled(false);
        }
    }//GEN-LAST:event_tolrffCheckBoxActionPerformed

    private void tolvrsCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tolvrsCheckBoxActionPerformed
        if (tolvrsCheckBox.isSelected()) {
            tolvrsCheckBox.setForeground(Color.red);
            tolvrsTextField.setEnabled(true);
            toldfeCheckBox.setForeground(Color.blue);
            toldfeTextField.setEnabled(false);
            toldffCheckBox.setForeground(Color.blue);
            toldffTextField.setEnabled(false);
            tolrffCheckBox.setForeground(Color.blue);
            tolrffTextField.setEnabled(false);
            tolwfrCheckBox.setForeground(Color.blue);
            tolwfrTextField.setEnabled(false);
        } else {
            tolvrsCheckBox.setForeground(Color.blue);
            tolvrsTextField.setEnabled(false);
        }
    }//GEN-LAST:event_tolvrsCheckBoxActionPerformed

    private void tolwfrCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tolwfrCheckBoxActionPerformed
        if (tolwfrCheckBox.isSelected()) {
            tolwfrCheckBox.setForeground(Color.red);
            tolwfrTextField.setEnabled(true);
            toldfeCheckBox.setForeground(Color.blue);
            toldfeTextField.setEnabled(false);
            toldffCheckBox.setForeground(Color.blue);
            toldffTextField.setEnabled(false);
            tolrffCheckBox.setForeground(Color.blue);
            tolrffTextField.setEnabled(false);
            tolvrsCheckBox.setForeground(Color.blue);
            tolvrsTextField.setEnabled(false);
        } else {
            tolwfrCheckBox.setForeground(Color.blue);
            tolwfrTextField.setEnabled(false);
        }
    }//GEN-LAST:event_tolwfrCheckBoxActionPerformed

    private void diemacCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_diemacCheckBoxActionPerformed
        if (diemacCheckBox.isSelected()) {
            diemacCheckBox.setForeground(Color.red);
            diemacTextField.setEnabled(true);
        } else {
            diemacCheckBox.setForeground(Color.blue);
            diemacTextField.setEnabled(false);
        }
    }//GEN-LAST:event_diemacCheckBoxActionPerformed

    private void diemixCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_diemixCheckBoxActionPerformed
        if (diemixCheckBox.isSelected()) {
            diemixCheckBox.setForeground(Color.red);
            diemixTextField.setEnabled(true);
        } else {
            diemixCheckBox.setForeground(Color.blue);
            diemixTextField.setEnabled(false);
        }
    }//GEN-LAST:event_diemixCheckBoxActionPerformed

    private void iprcelCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_iprcelCheckBoxActionPerformed
        if (iprcelCheckBox.isSelected()) {
            iprcelCheckBox.setForeground(Color.red);
            iprcelTextField.setEnabled(true);
        } else {
            iprcelCheckBox.setForeground(Color.blue);
            iprcelTextField.setEnabled(false);
        }
    }//GEN-LAST:event_iprcelCheckBoxActionPerformed

    private void ntimeCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ntimeCheckBoxActionPerformed
        if (ntimeCheckBox.isSelected()) {
            ntimeCheckBox.setForeground(Color.red);
            ntimeTextField.setEnabled(true);
        } else {
            ntimeCheckBox.setForeground(Color.blue);
            ntimeTextField.setEnabled(false);
        }
    }//GEN-LAST:event_ntimeCheckBoxActionPerformed

    private void tolmxfCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tolmxfCheckBoxActionPerformed
        if (tolmxfCheckBox.isSelected()) {
            tolmxfCheckBox.setForeground(Color.red);
            tolmxfTextField.setEnabled(true);
        } else {
            tolmxfCheckBox.setForeground(Color.blue);
            tolmxfTextField.setEnabled(false);
        }
    }//GEN-LAST:event_tolmxfCheckBoxActionPerformed

    public String getData() {
        String file = new String();

        // OPTCELL *************************************************************
        if (optcellCheckBox.isSelected()) {
            file += optcellCheckBox.getText() + " ";
            file += optcellComboBox.getSelectedItem() + "\n\n";
        }
        // DILATMX *************************************************************
        if (dilatmxCheckBox.isSelected()) {
            try {
                double dilatmx = Double.parseDouble(dilatmxTextField.getText());
                file += dilatmxCheckBox.getText() + " ";
                file += dilatmx + "\n\n";
            } catch (Exception e) {
                printERR("Please set up DILATMX !");
            }
        }
        // ISCF ****************************************************************
        if (iscfCheckBox.isSelected()) {
            file += iscfCheckBox.getText() + " ";
            file += iscfComboBox.getSelectedItem() + "\n\n";
        }
        // IONMOV **************************************************************
        if (ionmovCheckBox.isSelected()) {
            file += ionmovCheckBox.getText() + " ";
            file += ionmovComboBox.getSelectedItem() + "\n\n";
        }
        // NSTEP ***************************************************************
        if (nstepCheckBox.isSelected()) {
            try {
                int nstep = Integer.parseInt(nstepTextField.getText());
                file += nstepCheckBox.getText() + " ";
                file += nstep + "\n\n";
            } catch (Exception e) {
                printERR("Please set up NSTEP (must be an integer) !");
            }
        }
        // TOLDFE **************************************************************
        if (toldfeCheckBox.isSelected()) {
            try {
                double toldfe = Double.parseDouble(toldfeTextField.getText());
                file += toldfeCheckBox.getText() + " ";
                String str = "" + toldfe;
                file += str.replace("E", "d") + "\n\n";
            } catch (Exception e) {
                printERR("Please set up TOLDFE !");
            }
        }
        // TOLDFF **************************************************************
        if (toldffCheckBox.isSelected()) {
            try {
                double toldff = Double.parseDouble(toldffTextField.getText());
                file += toldffCheckBox.getText() + " ";
                String str = "" + toldff;
                file += str.replace("E", "d") + "\n\n";
            } catch (Exception e) {
                printERR("Please set up TOLDFF !");
            }
        }
        // TOLRFF **************************************************************
        if (tolrffCheckBox.isSelected()) {
            try {
                double tolrff = Double.parseDouble(tolrffTextField.getText());
                file += tolrffCheckBox.getText() + " ";
                String str = "" + tolrff;
                file += str.replace("E", "d") + "\n\n";
            } catch (Exception e) {
                printERR("Please set up TOLRFF !");
            }
        }
        // TOLVRS **************************************************************
        if (tolvrsCheckBox.isSelected()) {
            try {
                double tolvrs = Double.parseDouble(tolvrsTextField.getText());
                file += tolvrsCheckBox.getText() + " ";
                String str = "" + tolvrs;
                file += str.replace("E", "d") + "\n\n";
            } catch (Exception e) {
                printERR("Please set up TOLVRS !");
            }
        }
        // TOLWFR **************************************************************
        if (tolwfrCheckBox.isSelected()) {
            try {
                double tolwfr = Double.parseDouble(tolwfrTextField.getText());
                file += tolwfrCheckBox.getText() + " ";
                String str = "" + tolwfr;
                file += str.replace("E", "d") + "\n\n";
            } catch (Exception e) {
                printERR("Please set up TOLWFR !");
            }
        }
        // DIEMAC **************************************************************
        if (diemacCheckBox.isSelected()) {
            try {
                double diemac = Double.parseDouble(diemacTextField.getText());
                file += diemacCheckBox.getText() + " ";
                String str = "" + diemac;
                file += str.replace("E", "d") + "\n\n";
            } catch (Exception e) {
                printERR("Please set up DIEMAC !");
            }
        }
        // DIEMIX **************************************************************
        if (diemixCheckBox.isSelected()) {
            try {
                double diemix = Double.parseDouble(diemixTextField.getText());
                file += diemixCheckBox.getText() + " ";
                String str = "" + diemix;
                file += str.replace("E", "d") + "\n\n";
            } catch (Exception e) {
                printERR("Please set up DIEMIX !");
            }
        }
        // IPRCEL **************************************************************
        if (iprcelCheckBox.isSelected()) {
            try {
                int iprcel = Integer.parseInt(iprcelTextField.getText());
                file += iprcelCheckBox.getText() + " ";
                file += iprcel + "\n\n";
            } catch (Exception e) {
                printERR("Please set up IPRCEL (must be an integer) !");
            }
        }
        // NTIME ***************************************************************
        if (ntimeCheckBox.isSelected()) {
            try {
                int ntime = Integer.parseInt(ntimeTextField.getText());
                file += ntimeCheckBox.getText() + " ";
                file += ntime + "\n\n";
            } catch (Exception e) {
                printERR("Please set up NTIME (must be an integer) !");
            }
        }
        // TOLMXF **************************************************************
        if (tolmxfCheckBox.isSelected()) {
            try {
                double tolmxf = Double.parseDouble(tolmxfTextField.getText());
                file += tolmxfCheckBox.getText() + " ";
                String str = "" + tolmxf;
                file += str.replace("E", "d") + "\n\n";
            } catch (Exception e) {
                printERR("Please set up TOLMXF !");
            }
        }
        
        return file;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox diemacCheckBox;
    private javax.swing.JTextField diemacTextField;
    private javax.swing.JCheckBox diemixCheckBox;
    private javax.swing.JTextField diemixTextField;
    private javax.swing.JCheckBox dilatmxCheckBox;
    private javax.swing.JTextField dilatmxTextField;
    private javax.swing.JCheckBox ionmovCheckBox;
    private javax.swing.JComboBox ionmovComboBox;
    private javax.swing.JCheckBox iprcelCheckBox;
    private javax.swing.JTextField iprcelTextField;
    private javax.swing.JCheckBox iscfCheckBox;
    private javax.swing.JComboBox iscfComboBox;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JCheckBox nstepCheckBox;
    private javax.swing.JTextField nstepTextField;
    private javax.swing.JCheckBox ntimeCheckBox;
    private javax.swing.JTextField ntimeTextField;
    private javax.swing.JCheckBox optcellCheckBox;
    private javax.swing.JComboBox optcellComboBox;
    private javax.swing.ButtonGroup tolbuttonGroup;
    private javax.swing.JCheckBox toldfeCheckBox;
    private javax.swing.JTextField toldfeTextField;
    private javax.swing.JCheckBox toldffCheckBox;
    private javax.swing.JTextField toldffTextField;
    private javax.swing.JCheckBox tolmxfCheckBox;
    private javax.swing.JTextField tolmxfTextField;
    private javax.swing.JCheckBox tolrffCheckBox;
    private javax.swing.JTextField tolrffTextField;
    private javax.swing.JCheckBox tolvrsCheckBox;
    private javax.swing.JTextField tolvrsTextField;
    private javax.swing.JCheckBox tolwfrCheckBox;
    private javax.swing.JTextField tolwfrTextField;
    // End of variables declaration//GEN-END:variables
}
